// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

import QtCore
import QtQuick
import QtQuick.Controls
import QtQuick.Window
import CarConfigurator

Window {
    id: rootWindow

    width: Constants.width
    height: Constants.height
    minimumWidth: 640
    minimumHeight: 360
    color: Constants.screenColor
    visible: true
    title: "Car Configurator"

    ScreenPrimary {
        id: mainScreen
        anchors.centerIn: parent

        transform: Scale {
            origin.x: mainScreen.width / 2
            origin.y: mainScreen.height / 2
            readonly property real xRatio: rootWindow.width / mainScreen.width
            readonly property real yRatio: rootWindow.height / mainScreen.height
            xScale: Math.min(xRatio, yRatio)
            yScale: Math.min(xRatio, yRatio)
        }

        Keys.onPressed: (event) => {
                            if (event.key === Qt.Key_1) {
                                gui.visible = !gui.visible
                            }
                        }
    }

    Rectangle {
        id: splashScreen

        color: "black"
        anchors.fill: parent
        opacity: !mainScreen.assetPreLoadComplete ? 1 : 0

        Behavior on opacity { PropertyAnimation { duration: Constants.animationDuration } }

        Image {
            id: builtWithQtLogo

            source: "images/builtWithQt.png"
            anchors.centerIn: parent
        }
    }
}
