/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;

public class QtAndroidMediaPlayer
extends MediaPlayer {
    private Uri mUri = null;
    private final long mID;
    private boolean mMuted = false;
    private boolean mPreparing = false;
    private boolean mInitialized = false;
    private int mVolume = 100;
    private static final String TAG = "Qt MediaPlayer";
    private static Context mApplicationContext = null;
    final int MEDIA_PLAYER_INVALID_STATE = 1;
    final int MEDIA_PLAYER_PREPARING = 2;
    final int MEDIA_PLAYER_READY = 3;
    final int MEDIA_PLAYER_DURATION = 4;
    final int MEDIA_PLAYER_PROGRESS = 5;
    final int MEDIA_PLAYER_FINISHED = 6;

    public native void onErrorNative(int var1, int var2, long var3);

    public native void onBufferingUpdateNative(int var1, long var2);

    public native void onInfoNative(int var1, int var2, long var3);

    public native void onMediaPlayerInfoNative(int var1, int var2, long var3);

    public native void onVideoSizeChangedNative(int var1, int var2, long var3);

    public static void setActivity(Activity activity) {
        try {
            mApplicationContext = activity.getApplicationContext();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("" + exception.getMessage()));
        }
    }

    public QtAndroidMediaPlayer(long l) {
        this.mID = l;
        this.setOnBufferingUpdateListener(new MediaPlayerBufferingListener());
        this.setOnCompletionListener(new MediaPlayerCompletionListener());
        this.setOnInfoListener(new MediaPlayerInfoListener());
        this.setOnSeekCompleteListener(new MediaPlayerSeekCompleteListener());
        this.setOnVideoSizeChangedListener(new MediaPlayerVideoSizeChangedListener());
        this.setOnErrorListener(new MediaPlayerErrorListener());
    }

    public void start() {
        if (!this.mInitialized) {
            this.onMediaPlayerInfoNative(1, 0, this.mID);
            return;
        }
        if (mApplicationContext == null) {
            return;
        }
        if (this.mPreparing) {
            return;
        }
        if (this.isPlaying()) {
            return;
        }
        try {
            super.start();
            Thread thread = new Thread(new ProgressWatcher());
            thread.start();
        }
        catch (IllegalStateException illegalStateException) {
            this.reset();
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public void pause() {
        if (!this.isPlaying()) {
            return;
        }
        try {
            super.pause();
        }
        catch (IllegalStateException illegalStateException) {
            this.reset();
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.mInitialized) {
            return;
        }
        try {
            super.stop();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        finally {
            this.reset();
        }
    }

    public void seekTo(int n) {
        if (!this.mInitialized) {
            return;
        }
        try {
            super.seekTo(n);
            this.onMediaPlayerInfoNative(5, n, this.mID);
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public boolean isPlaying() {
        boolean bl = false;
        if (!this.mInitialized) {
            return bl;
        }
        try {
            bl = super.isPlaying();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return bl;
    }

    public void setMediaPath(String string) {
        if (this.mInitialized) {
            this.reset();
        }
        try {
            this.mPreparing = true;
            this.onMediaPlayerInfoNative(2, 0, this.mID);
            this.mUri = Uri.parse((String)string);
            if (this.mUri.getScheme().compareTo("assets") == 0) {
                String string2 = this.mUri.getPath().substring(1);
                AssetManager assetManager = mApplicationContext.getAssets();
                AssetFileDescriptor assetFileDescriptor = assetManager.openFd(string2);
                long l = assetFileDescriptor.getStartOffset();
                long l2 = assetFileDescriptor.getLength();
                FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
                this.setDataSource(fileDescriptor, l, l2);
            } else {
                this.setDataSource(mApplicationContext, this.mUri);
            }
            this.mInitialized = true;
            this.setOnPreparedListener(new MediaPlayerPreparedListener());
            this.prepareAsync();
        }
        catch (IOException iOException) {
            this.mPreparing = false;
            this.onErrorNative(1, -1010, this.mID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d((String)TAG, (String)("" + illegalArgumentException.getMessage()));
        }
        catch (SecurityException securityException) {
            Log.d((String)TAG, (String)("" + securityException.getMessage()));
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        catch (NullPointerException nullPointerException) {
            Log.d((String)TAG, (String)("" + nullPointerException.getMessage()));
        }
    }

    public int getCurrentPosition() {
        int n = 0;
        if (!this.mInitialized) {
            return n;
        }
        try {
            n = super.getCurrentPosition();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return n;
    }

    public int getDuration() {
        int n = 0;
        if (!this.mInitialized) {
            return n;
        }
        try {
            n = super.getDuration();
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
        return n;
    }

    private float adjustVolume(int n) {
        if (n < 1) {
            return 0.0f;
        }
        if (n > 98) {
            return 1.0f;
        }
        return (float)(1.0 - Math.log(100 - n) / Math.log(100.0));
    }

    public void setVolume(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        float f = this.adjustVolume(n);
        try {
            super.setVolume(f, f);
            if (!this.mMuted) {
                this.mVolume = n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            Log.d((String)TAG, (String)("" + illegalStateException.getMessage()));
        }
    }

    public int getVolume() {
        return this.mVolume;
    }

    public void mute(boolean bl) {
        this.mMuted = bl;
        this.setVolume(bl ? 0 : this.mVolume);
    }

    public boolean isMuted() {
        return this.mMuted;
    }

    public void reset() {
        this.mInitialized = false;
        super.reset();
    }

    private class MediaPlayerVideoSizeChangedListener
    implements MediaPlayer.OnVideoSizeChangedListener {
        private MediaPlayerVideoSizeChangedListener() {
        }

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onVideoSizeChangedNative(n, n2, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerSeekCompleteListener
    implements MediaPlayer.OnSeekCompleteListener {
        private MediaPlayerSeekCompleteListener() {
        }

        public void onSeekComplete(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.onMediaPlayerInfoNative(5, QtAndroidMediaPlayer.this.getCurrentPosition(), QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private MediaPlayerPreparedListener() {
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.mPreparing = false;
            QtAndroidMediaPlayer.this.onMediaPlayerInfoNative(3, 0, QtAndroidMediaPlayer.this.mID);
            QtAndroidMediaPlayer.this.onMediaPlayerInfoNative(4, QtAndroidMediaPlayer.this.getDuration(), QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerInfoListener
    implements MediaPlayer.OnInfoListener {
        private MediaPlayerInfoListener() {
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onInfoNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class MediaPlayerCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private MediaPlayerCompletionListener() {
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.onMediaPlayerInfoNative(6, 0, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerBufferingListener
    implements MediaPlayer.OnBufferingUpdateListener {
        private int mBufferPercent = -1;

        private MediaPlayerBufferingListener() {
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
            if (this.mBufferPercent == n) {
                return;
            }
            this.mBufferPercent = n;
            QtAndroidMediaPlayer.this.onBufferingUpdateNative(this.mBufferPercent, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayerErrorListener() {
        }

        public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.reset();
            QtAndroidMediaPlayer.this.onErrorNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private ProgressWatcher() {
        }

        @Override
        public void run() {
            int n = QtAndroidMediaPlayer.this.getDuration();
            int n2 = QtAndroidMediaPlayer.this.getCurrentPosition();
            try {
                while (n >= n2 && QtAndroidMediaPlayer.this.isPlaying()) {
                    QtAndroidMediaPlayer.this.onMediaPlayerInfoNative(5, n2, QtAndroidMediaPlayer.this.mID);
                    Thread.sleep(1000L);
                    n2 = QtAndroidMediaPlayer.this.getCurrentPosition();
                }
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)QtAndroidMediaPlayer.TAG, (String)("" + interruptedException.getMessage()));
                return;
            }
        }
    }
}

