/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.qtproject.qt5.android.QtNative;

public class QtSurface
extends SurfaceView
implements SurfaceHolder.Callback {
    private Bitmap m_bitmap = null;
    private boolean m_started = false;
    private boolean m_usesGL = false;
    private GestureDetector m_gestureDetector;
    private Object m_accessibilityDelegate = null;

    public QtSurface(Context context, int n) {
        super(context);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setType(2);
        this.setId(n);
        this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                if (!QtSurface.this.m_started) {
                    return;
                }
                QtNative.longPress(QtSurface.this.getId(), (int)motionEvent.getX(), (int)motionEvent.getY());
            }
        });
        this.m_gestureDetector.setIsLongpressEnabled(true);
    }

    public void applicationStarted(boolean bl) {
        this.m_started = true;
        this.m_usesGL = bl;
        if (this.getWidth() < 1 || this.getHeight() < 1) {
            return;
        }
        if (this.m_usesGL) {
            QtNative.setSurface(this.getHolder().getSurface());
        } else {
            QtNative.lockSurface();
            QtNative.setSurface(null);
            this.m_bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            QtNative.setSurface(this.m_bitmap);
            QtNative.unlockSurface();
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, this.getWidth(), this.getHeight(), displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity);
        if (this.m_usesGL) {
            surfaceHolder.setFormat(1);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Class<?> clazz = Class.forName("org.qtproject.qt5.android.accessibility.QtAccessibilityDelegate");
                Constructor<?> constructor = clazz.getConstructor(Class.forName("android.view.View"));
                this.m_accessibilityDelegate = constructor.newInstance(new Object[]{this});
                Class<?> clazz2 = Class.forName("android.view.View$AccessibilityDelegate");
                Method method = ((Object)((Object)this)).getClass().getMethod("setAccessibilityDelegate", clazz2);
                method.invoke((Object)this, this.m_accessibilityDelegate);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                Log.w((String)"Qt A11y", (String)("Unknown exception: " + exception.toString()));
            }
        }
    }

    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (this.m_accessibilityDelegate != null) {
            try {
                Method method = this.m_accessibilityDelegate.getClass().getMethod("dispatchHoverEvent", MotionEvent.class);
                boolean bl = (Boolean)method.invoke(this.m_accessibilityDelegate, motionEvent);
                if (bl) {
                    return true;
                }
                QtSurface qtSurface = this;
                Method method2 = ((Object)((Object)qtSurface)).getClass().getMethod("dispatchHoverEvent", MotionEvent.class);
                return (Boolean)method2.invoke((Object)qtSurface, motionEvent);
            }
            catch (Exception exception) {
                Log.w((String)"Qt A11y", (String)("EXCEPTION in dispatchHoverEvent for Accessibility: " + exception));
            }
        }
        return false;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, n2, n3, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity);
        if (!this.m_started) {
            return;
        }
        if (this.m_usesGL) {
            QtNative.setSurface(surfaceHolder.getSurface());
        } else {
            QtNative.lockSurface();
            QtNative.setSurface(null);
            this.m_bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.RGB_565);
            QtNative.setSurface(this.m_bitmap);
            QtNative.unlockSurface();
            QtNative.updateWindow();
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        if (this.m_usesGL) {
            QtNative.destroySurface();
        } else {
            if (!this.m_started) {
                return;
            }
            QtNative.lockSurface();
            QtNative.setSurface(null);
            QtNative.unlockSurface();
        }
    }

    public void drawBitmap(Rect rect) {
        if (!this.m_started) {
            return;
        }
        QtNative.lockSurface();
        if (null != this.m_bitmap) {
            try {
                Canvas canvas = this.getHolder().lockCanvas(rect);
                canvas.drawBitmap(this.m_bitmap, rect, rect, null);
                this.getHolder().unlockCanvasAndPost(canvas);
            }
            catch (Exception exception) {
                Log.e((String)"Qt JAVA", (String)"Can't create main activity", (Throwable)exception);
            }
        }
        QtNative.unlockSurface();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.m_started) {
            return false;
        }
        QtNative.sendTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (!this.m_started) {
            return false;
        }
        QtNative.sendTrackballEvent(motionEvent, this.getId());
        return true;
    }
}

