// Copyright (C) 2020 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT!

#include "ui4_p.h"


QT_BEGIN_NAMESPACE

using namespace Qt::StringLiterals;

#ifdef QFORMINTERNAL_NAMESPACE
using namespace QFormInternal;
#endif

/*******************************************************************************
** Implementations
*/

DomUI::~DomUI()
{
    delete m_widget;
    delete m_layoutDefault;
    delete m_layoutFunction;
    delete m_customWidgets;
    delete m_tabStops;
    delete m_includes;
    delete m_resources;
    delete m_connections;
    delete m_designerdata;
    delete m_slots;
    delete m_buttonGroups;
}

void DomUI::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"version"_s) {
            setAttributeVersion(attribute.value().toString());
            continue;
        }
        if (name == u"language"_s) {
            setAttributeLanguage(attribute.value().toString());
            continue;
        }
        if (name == u"displayname"_s) {
            setAttributeDisplayname(attribute.value().toString());
            continue;
        }
        if (name == u"idbasedtr"_s) {
            setAttributeIdbasedtr(attribute.value() == u"true"_s);
            continue;
        }
        if (name == u"label"_s) {
            setAttributeLabel(attribute.value().toString());
            continue;
        }
        if (name == u"connectslotsbyname"_s) {
            setAttributeConnectslotsbyname(attribute.value() == u"true"_s);
            continue;
        }
        if (name == u"stdsetdef"_s) {
            setAttributeStdsetdef(attribute.value().toInt());
            continue;
        }
        if (name == u"stdSetDef"_s) {
            setAttributeStdSetDef(attribute.value().toInt());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"author"_s, Qt::CaseInsensitive)) {
                setElementAuthor(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"comment"_s, Qt::CaseInsensitive)) {
                setElementComment(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"exportmacro"_s, Qt::CaseInsensitive)) {
                setElementExportMacro(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"class"_s, Qt::CaseInsensitive)) {
                setElementClass(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"widget"_s, Qt::CaseInsensitive)) {
                auto *v = new DomWidget();
                v->read(reader);
                setElementWidget(v);
                continue;
            }
            if (!tag.compare(u"layoutdefault"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLayoutDefault();
                v->read(reader);
                setElementLayoutDefault(v);
                continue;
            }
            if (!tag.compare(u"layoutfunction"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLayoutFunction();
                v->read(reader);
                setElementLayoutFunction(v);
                continue;
            }
            if (!tag.compare(u"pixmapfunction"_s, Qt::CaseInsensitive)) {
                setElementPixmapFunction(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"customwidgets"_s, Qt::CaseInsensitive)) {
                auto *v = new DomCustomWidgets();
                v->read(reader);
                setElementCustomWidgets(v);
                continue;
            }
            if (!tag.compare(u"tabstops"_s, Qt::CaseInsensitive)) {
                auto *v = new DomTabStops();
                v->read(reader);
                setElementTabStops(v);
                continue;
            }
            if (!tag.compare(u"images"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <images>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"includes"_s, Qt::CaseInsensitive)) {
                auto *v = new DomIncludes();
                v->read(reader);
                setElementIncludes(v);
                continue;
            }
            if (!tag.compare(u"resources"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResources();
                v->read(reader);
                setElementResources(v);
                continue;
            }
            if (!tag.compare(u"connections"_s, Qt::CaseInsensitive)) {
                auto *v = new DomConnections();
                v->read(reader);
                setElementConnections(v);
                continue;
            }
            if (!tag.compare(u"designerdata"_s, Qt::CaseInsensitive)) {
                auto *v = new DomDesignerData();
                v->read(reader);
                setElementDesignerdata(v);
                continue;
            }
            if (!tag.compare(u"slots"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSlots();
                v->read(reader);
                setElementSlots(v);
                continue;
            }
            if (!tag.compare(u"buttongroups"_s, Qt::CaseInsensitive)) {
                auto *v = new DomButtonGroups();
                v->read(reader);
                setElementButtonGroups(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomUI::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("ui") : tagName.toLower());

    if (hasAttributeVersion())
        writer.writeAttribute(u"version"_s, attributeVersion());

    if (hasAttributeLanguage())
        writer.writeAttribute(u"language"_s, attributeLanguage());

    if (hasAttributeDisplayname())
        writer.writeAttribute(u"displayname"_s, attributeDisplayname());

    if (hasAttributeIdbasedtr())
        writer.writeAttribute(u"idbasedtr"_s, (attributeIdbasedtr() ? u"true"_s : u"false"_s));

    if (hasAttributeLabel())
        writer.writeAttribute(u"label"_s, attributeLabel());

    if (hasAttributeConnectslotsbyname())
        writer.writeAttribute(u"connectslotsbyname"_s, (attributeConnectslotsbyname() ? u"true"_s : u"false"_s));

    if (hasAttributeStdsetdef())
        writer.writeAttribute(u"stdsetdef"_s, QString::number(attributeStdsetdef()));

    if (hasAttributeStdSetDef())
        writer.writeAttribute(u"stdsetdef"_s, QString::number(attributeStdSetDef()));

    if (m_children & Author)
        writer.writeTextElement(u"author"_s, m_author);

    if (m_children & Comment)
        writer.writeTextElement(u"comment"_s, m_comment);

    if (m_children & ExportMacro)
        writer.writeTextElement(u"exportmacro"_s, m_exportMacro);

    if (m_children & Class)
        writer.writeTextElement(u"class"_s, m_class);

    if (m_children & Widget)
        m_widget->write(writer, u"widget"_s);

    if (m_children & LayoutDefault)
        m_layoutDefault->write(writer, u"layoutdefault"_s);

    if (m_children & LayoutFunction)
        m_layoutFunction->write(writer, u"layoutfunction"_s);

    if (m_children & PixmapFunction)
        writer.writeTextElement(u"pixmapfunction"_s, m_pixmapFunction);

    if (m_children & CustomWidgets)
        m_customWidgets->write(writer, u"customwidgets"_s);

    if (m_children & TabStops)
        m_tabStops->write(writer, u"tabstops"_s);

    if (m_children & Includes)
        m_includes->write(writer, u"includes"_s);

    if (m_children & Resources)
        m_resources->write(writer, u"resources"_s);

    if (m_children & Connections)
        m_connections->write(writer, u"connections"_s);

    if (m_children & Designerdata)
        m_designerdata->write(writer, u"designerdata"_s);

    if (m_children & Slots)
        m_slots->write(writer, u"slots"_s);

    if (m_children & ButtonGroups)
        m_buttonGroups->write(writer, u"buttongroups"_s);

    writer.writeEndElement();
}

void DomUI::setElementAuthor(const QString &a)
{
    m_children |= Author;
    m_author = a;
}

void DomUI::setElementComment(const QString &a)
{
    m_children |= Comment;
    m_comment = a;
}

void DomUI::setElementExportMacro(const QString &a)
{
    m_children |= ExportMacro;
    m_exportMacro = a;
}

void DomUI::setElementClass(const QString &a)
{
    m_children |= Class;
    m_class = a;
}

DomWidget *DomUI::takeElementWidget()
{
    DomWidget *a = m_widget;
    m_widget = nullptr;
    m_children ^= Widget;
    return a;
}

void DomUI::setElementWidget(DomWidget *a)
{
    delete m_widget;
    m_children |= Widget;
    m_widget = a;
}

DomLayoutDefault *DomUI::takeElementLayoutDefault()
{
    DomLayoutDefault *a = m_layoutDefault;
    m_layoutDefault = nullptr;
    m_children ^= LayoutDefault;
    return a;
}

void DomUI::setElementLayoutDefault(DomLayoutDefault *a)
{
    delete m_layoutDefault;
    m_children |= LayoutDefault;
    m_layoutDefault = a;
}

DomLayoutFunction *DomUI::takeElementLayoutFunction()
{
    DomLayoutFunction *a = m_layoutFunction;
    m_layoutFunction = nullptr;
    m_children ^= LayoutFunction;
    return a;
}

void DomUI::setElementLayoutFunction(DomLayoutFunction *a)
{
    delete m_layoutFunction;
    m_children |= LayoutFunction;
    m_layoutFunction = a;
}

void DomUI::setElementPixmapFunction(const QString &a)
{
    m_children |= PixmapFunction;
    m_pixmapFunction = a;
}

DomCustomWidgets *DomUI::takeElementCustomWidgets()
{
    DomCustomWidgets *a = m_customWidgets;
    m_customWidgets = nullptr;
    m_children ^= CustomWidgets;
    return a;
}

void DomUI::setElementCustomWidgets(DomCustomWidgets *a)
{
    delete m_customWidgets;
    m_children |= CustomWidgets;
    m_customWidgets = a;
}

DomTabStops *DomUI::takeElementTabStops()
{
    DomTabStops *a = m_tabStops;
    m_tabStops = nullptr;
    m_children ^= TabStops;
    return a;
}

void DomUI::setElementTabStops(DomTabStops *a)
{
    delete m_tabStops;
    m_children |= TabStops;
    m_tabStops = a;
}

DomIncludes *DomUI::takeElementIncludes()
{
    DomIncludes *a = m_includes;
    m_includes = nullptr;
    m_children ^= Includes;
    return a;
}

void DomUI::setElementIncludes(DomIncludes *a)
{
    delete m_includes;
    m_children |= Includes;
    m_includes = a;
}

DomResources *DomUI::takeElementResources()
{
    DomResources *a = m_resources;
    m_resources = nullptr;
    m_children ^= Resources;
    return a;
}

void DomUI::setElementResources(DomResources *a)
{
    delete m_resources;
    m_children |= Resources;
    m_resources = a;
}

DomConnections *DomUI::takeElementConnections()
{
    DomConnections *a = m_connections;
    m_connections = nullptr;
    m_children ^= Connections;
    return a;
}

void DomUI::setElementConnections(DomConnections *a)
{
    delete m_connections;
    m_children |= Connections;
    m_connections = a;
}

DomDesignerData *DomUI::takeElementDesignerdata()
{
    DomDesignerData *a = m_designerdata;
    m_designerdata = nullptr;
    m_children ^= Designerdata;
    return a;
}

void DomUI::setElementDesignerdata(DomDesignerData *a)
{
    delete m_designerdata;
    m_children |= Designerdata;
    m_designerdata = a;
}

DomSlots *DomUI::takeElementSlots()
{
    DomSlots *a = m_slots;
    m_slots = nullptr;
    m_children ^= Slots;
    return a;
}

void DomUI::setElementSlots(DomSlots *a)
{
    delete m_slots;
    m_children |= Slots;
    m_slots = a;
}

DomButtonGroups *DomUI::takeElementButtonGroups()
{
    DomButtonGroups *a = m_buttonGroups;
    m_buttonGroups = nullptr;
    m_children ^= ButtonGroups;
    return a;
}

void DomUI::setElementButtonGroups(DomButtonGroups *a)
{
    delete m_buttonGroups;
    m_children |= ButtonGroups;
    m_buttonGroups = a;
}

void DomUI::clearElementAuthor()
{
    m_children &= ~Author;
}

void DomUI::clearElementComment()
{
    m_children &= ~Comment;
}

void DomUI::clearElementExportMacro()
{
    m_children &= ~ExportMacro;
}

void DomUI::clearElementClass()
{
    m_children &= ~Class;
}

void DomUI::clearElementWidget()
{
    delete m_widget;
    m_widget = nullptr;
    m_children &= ~Widget;
}

void DomUI::clearElementLayoutDefault()
{
    delete m_layoutDefault;
    m_layoutDefault = nullptr;
    m_children &= ~LayoutDefault;
}

void DomUI::clearElementLayoutFunction()
{
    delete m_layoutFunction;
    m_layoutFunction = nullptr;
    m_children &= ~LayoutFunction;
}

void DomUI::clearElementPixmapFunction()
{
    m_children &= ~PixmapFunction;
}

void DomUI::clearElementCustomWidgets()
{
    delete m_customWidgets;
    m_customWidgets = nullptr;
    m_children &= ~CustomWidgets;
}

void DomUI::clearElementTabStops()
{
    delete m_tabStops;
    m_tabStops = nullptr;
    m_children &= ~TabStops;
}

void DomUI::clearElementIncludes()
{
    delete m_includes;
    m_includes = nullptr;
    m_children &= ~Includes;
}

void DomUI::clearElementResources()
{
    delete m_resources;
    m_resources = nullptr;
    m_children &= ~Resources;
}

void DomUI::clearElementConnections()
{
    delete m_connections;
    m_connections = nullptr;
    m_children &= ~Connections;
}

void DomUI::clearElementDesignerdata()
{
    delete m_designerdata;
    m_designerdata = nullptr;
    m_children &= ~Designerdata;
}

void DomUI::clearElementSlots()
{
    delete m_slots;
    m_slots = nullptr;
    m_children &= ~Slots;
}

void DomUI::clearElementButtonGroups()
{
    delete m_buttonGroups;
    m_buttonGroups = nullptr;
    m_children &= ~ButtonGroups;
}

DomIncludes::~DomIncludes()
{
    qDeleteAll(m_include);
    m_include.clear();
}

void DomIncludes::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"include"_s, Qt::CaseInsensitive)) {
                auto *v = new DomInclude();
                v->read(reader);
                m_include.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomIncludes::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("includes") : tagName.toLower());

    for (DomInclude *v : m_include)
        v->write(writer, u"include"_s);

    writer.writeEndElement();
}

void DomIncludes::setElementInclude(const QList<DomInclude *> &a)
{
    m_children |= Include;
    m_include = a;
}

DomInclude::~DomInclude() = default;

void DomInclude::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"location"_s) {
            setAttributeLocation(attribute.value().toString());
            continue;
        }
        if (name == u"impldecl"_s) {
            setAttributeImpldecl(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        case QXmlStreamReader::Characters :
            if (!reader.isWhitespace())
                m_text.append(reader.text().toString());
            break;
        default :
            break;
        }
    }
}

void DomInclude::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("include") : tagName.toLower());

    if (hasAttributeLocation())
        writer.writeAttribute(u"location"_s, attributeLocation());

    if (hasAttributeImpldecl())
        writer.writeAttribute(u"impldecl"_s, attributeImpldecl());

    if (!m_text.isEmpty())
        writer.writeCharacters(m_text);

    writer.writeEndElement();
}

DomResources::~DomResources()
{
    qDeleteAll(m_include);
    m_include.clear();
}

void DomResources::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"include"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResource();
                v->read(reader);
                m_include.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomResources::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("resources") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    for (DomResource *v : m_include)
        v->write(writer, u"include"_s);

    writer.writeEndElement();
}

void DomResources::setElementInclude(const QList<DomResource *> &a)
{
    m_children |= Include;
    m_include = a;
}

DomResource::~DomResource() = default;

void DomResource::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"location"_s) {
            setAttributeLocation(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomResource::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("resource") : tagName.toLower());

    if (hasAttributeLocation())
        writer.writeAttribute(u"location"_s, attributeLocation());

    writer.writeEndElement();
}

DomActionGroup::~DomActionGroup()
{
    qDeleteAll(m_action);
    m_action.clear();
    qDeleteAll(m_actionGroup);
    m_actionGroup.clear();
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_attribute);
    m_attribute.clear();
}

void DomActionGroup::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"action"_s, Qt::CaseInsensitive)) {
                auto *v = new DomAction();
                v->read(reader);
                m_action.append(v);
                continue;
            }
            if (!tag.compare(u"actiongroup"_s, Qt::CaseInsensitive)) {
                auto *v = new DomActionGroup();
                v->read(reader);
                m_actionGroup.append(v);
                continue;
            }
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"attribute"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_attribute.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomActionGroup::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("actiongroup") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    for (DomAction *v : m_action)
        v->write(writer, u"action"_s);

    for (DomActionGroup *v : m_actionGroup)
        v->write(writer, u"actiongroup"_s);

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomProperty *v : m_attribute)
        v->write(writer, u"attribute"_s);

    writer.writeEndElement();
}

void DomActionGroup::setElementAction(const QList<DomAction *> &a)
{
    m_children |= Action;
    m_action = a;
}

void DomActionGroup::setElementActionGroup(const QList<DomActionGroup *> &a)
{
    m_children |= ActionGroup;
    m_actionGroup = a;
}

void DomActionGroup::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomActionGroup::setElementAttribute(const QList<DomProperty *> &a)
{
    m_children |= Attribute;
    m_attribute = a;
}

DomAction::~DomAction()
{
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_attribute);
    m_attribute.clear();
}

void DomAction::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        if (name == u"menu"_s) {
            setAttributeMenu(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"attribute"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_attribute.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomAction::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("action") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    if (hasAttributeMenu())
        writer.writeAttribute(u"menu"_s, attributeMenu());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomProperty *v : m_attribute)
        v->write(writer, u"attribute"_s);

    writer.writeEndElement();
}

void DomAction::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomAction::setElementAttribute(const QList<DomProperty *> &a)
{
    m_children |= Attribute;
    m_attribute = a;
}

DomActionRef::~DomActionRef() = default;

void DomActionRef::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomActionRef::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("actionref") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    writer.writeEndElement();
}

DomButtonGroup::~DomButtonGroup()
{
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_attribute);
    m_attribute.clear();
}

void DomButtonGroup::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"attribute"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_attribute.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomButtonGroup::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("buttongroup") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomProperty *v : m_attribute)
        v->write(writer, u"attribute"_s);

    writer.writeEndElement();
}

void DomButtonGroup::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomButtonGroup::setElementAttribute(const QList<DomProperty *> &a)
{
    m_children |= Attribute;
    m_attribute = a;
}

DomButtonGroups::~DomButtonGroups()
{
    qDeleteAll(m_buttonGroup);
    m_buttonGroup.clear();
}

void DomButtonGroups::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"buttongroup"_s, Qt::CaseInsensitive)) {
                auto *v = new DomButtonGroup();
                v->read(reader);
                m_buttonGroup.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomButtonGroups::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("buttongroups") : tagName.toLower());

    for (DomButtonGroup *v : m_buttonGroup)
        v->write(writer, u"buttongroup"_s);

    writer.writeEndElement();
}

void DomButtonGroups::setElementButtonGroup(const QList<DomButtonGroup *> &a)
{
    m_children |= ButtonGroup;
    m_buttonGroup = a;
}

DomCustomWidgets::~DomCustomWidgets()
{
    qDeleteAll(m_customWidget);
    m_customWidget.clear();
}

void DomCustomWidgets::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"customwidget"_s, Qt::CaseInsensitive)) {
                auto *v = new DomCustomWidget();
                v->read(reader);
                m_customWidget.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomCustomWidgets::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("customwidgets") : tagName.toLower());

    for (DomCustomWidget *v : m_customWidget)
        v->write(writer, u"customwidget"_s);

    writer.writeEndElement();
}

void DomCustomWidgets::setElementCustomWidget(const QList<DomCustomWidget *> &a)
{
    m_children |= CustomWidget;
    m_customWidget = a;
}

DomHeader::~DomHeader() = default;

void DomHeader::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"location"_s) {
            setAttributeLocation(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        case QXmlStreamReader::Characters :
            if (!reader.isWhitespace())
                m_text.append(reader.text().toString());
            break;
        default :
            break;
        }
    }
}

void DomHeader::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("header") : tagName.toLower());

    if (hasAttributeLocation())
        writer.writeAttribute(u"location"_s, attributeLocation());

    if (!m_text.isEmpty())
        writer.writeCharacters(m_text);

    writer.writeEndElement();
}

DomCustomWidget::~DomCustomWidget()
{
    delete m_header;
    delete m_sizeHint;
    delete m_slots;
    delete m_propertyspecifications;
}

void DomCustomWidget::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"class"_s, Qt::CaseInsensitive)) {
                setElementClass(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"extends"_s, Qt::CaseInsensitive)) {
                setElementExtends(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"header"_s, Qt::CaseInsensitive)) {
                auto *v = new DomHeader();
                v->read(reader);
                setElementHeader(v);
                continue;
            }
            if (!tag.compare(u"sizehint"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSize();
                v->read(reader);
                setElementSizeHint(v);
                continue;
            }
            if (!tag.compare(u"addpagemethod"_s, Qt::CaseInsensitive)) {
                setElementAddPageMethod(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"container"_s, Qt::CaseInsensitive)) {
                setElementContainer(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"sizepolicy"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <sizepolicy>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"pixmap"_s, Qt::CaseInsensitive)) {
                setElementPixmap(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"script"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <script>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"properties"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <properties>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"slots"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSlots();
                v->read(reader);
                setElementSlots(v);
                continue;
            }
            if (!tag.compare(u"propertyspecifications"_s, Qt::CaseInsensitive)) {
                auto *v = new DomPropertySpecifications();
                v->read(reader);
                setElementPropertyspecifications(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomCustomWidget::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("customwidget") : tagName.toLower());

    if (m_children & Class)
        writer.writeTextElement(u"class"_s, m_class);

    if (m_children & Extends)
        writer.writeTextElement(u"extends"_s, m_extends);

    if (m_children & Header)
        m_header->write(writer, u"header"_s);

    if (m_children & SizeHint)
        m_sizeHint->write(writer, u"sizehint"_s);

    if (m_children & AddPageMethod)
        writer.writeTextElement(u"addpagemethod"_s, m_addPageMethod);

    if (m_children & Container)
        writer.writeTextElement(u"container"_s, QString::number(m_container));

    if (m_children & Pixmap)
        writer.writeTextElement(u"pixmap"_s, m_pixmap);

    if (m_children & Slots)
        m_slots->write(writer, u"slots"_s);

    if (m_children & Propertyspecifications)
        m_propertyspecifications->write(writer, u"propertyspecifications"_s);

    writer.writeEndElement();
}

void DomCustomWidget::setElementClass(const QString &a)
{
    m_children |= Class;
    m_class = a;
}

void DomCustomWidget::setElementExtends(const QString &a)
{
    m_children |= Extends;
    m_extends = a;
}

DomHeader *DomCustomWidget::takeElementHeader()
{
    DomHeader *a = m_header;
    m_header = nullptr;
    m_children ^= Header;
    return a;
}

void DomCustomWidget::setElementHeader(DomHeader *a)
{
    delete m_header;
    m_children |= Header;
    m_header = a;
}

DomSize *DomCustomWidget::takeElementSizeHint()
{
    DomSize *a = m_sizeHint;
    m_sizeHint = nullptr;
    m_children ^= SizeHint;
    return a;
}

void DomCustomWidget::setElementSizeHint(DomSize *a)
{
    delete m_sizeHint;
    m_children |= SizeHint;
    m_sizeHint = a;
}

void DomCustomWidget::setElementAddPageMethod(const QString &a)
{
    m_children |= AddPageMethod;
    m_addPageMethod = a;
}

void DomCustomWidget::setElementContainer(int a)
{
    m_children |= Container;
    m_container = a;
}

void DomCustomWidget::setElementPixmap(const QString &a)
{
    m_children |= Pixmap;
    m_pixmap = a;
}

DomSlots *DomCustomWidget::takeElementSlots()
{
    DomSlots *a = m_slots;
    m_slots = nullptr;
    m_children ^= Slots;
    return a;
}

void DomCustomWidget::setElementSlots(DomSlots *a)
{
    delete m_slots;
    m_children |= Slots;
    m_slots = a;
}

DomPropertySpecifications *DomCustomWidget::takeElementPropertyspecifications()
{
    DomPropertySpecifications *a = m_propertyspecifications;
    m_propertyspecifications = nullptr;
    m_children ^= Propertyspecifications;
    return a;
}

void DomCustomWidget::setElementPropertyspecifications(DomPropertySpecifications *a)
{
    delete m_propertyspecifications;
    m_children |= Propertyspecifications;
    m_propertyspecifications = a;
}

void DomCustomWidget::clearElementClass()
{
    m_children &= ~Class;
}

void DomCustomWidget::clearElementExtends()
{
    m_children &= ~Extends;
}

void DomCustomWidget::clearElementHeader()
{
    delete m_header;
    m_header = nullptr;
    m_children &= ~Header;
}

void DomCustomWidget::clearElementSizeHint()
{
    delete m_sizeHint;
    m_sizeHint = nullptr;
    m_children &= ~SizeHint;
}

void DomCustomWidget::clearElementAddPageMethod()
{
    m_children &= ~AddPageMethod;
}

void DomCustomWidget::clearElementContainer()
{
    m_children &= ~Container;
}

void DomCustomWidget::clearElementPixmap()
{
    m_children &= ~Pixmap;
}

void DomCustomWidget::clearElementSlots()
{
    delete m_slots;
    m_slots = nullptr;
    m_children &= ~Slots;
}

void DomCustomWidget::clearElementPropertyspecifications()
{
    delete m_propertyspecifications;
    m_propertyspecifications = nullptr;
    m_children &= ~Propertyspecifications;
}

DomLayoutDefault::~DomLayoutDefault() = default;

void DomLayoutDefault::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"spacing"_s) {
            setAttributeSpacing(attribute.value().toInt());
            continue;
        }
        if (name == u"margin"_s) {
            setAttributeMargin(attribute.value().toInt());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomLayoutDefault::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("layoutdefault") : tagName.toLower());

    if (hasAttributeSpacing())
        writer.writeAttribute(u"spacing"_s, QString::number(attributeSpacing()));

    if (hasAttributeMargin())
        writer.writeAttribute(u"margin"_s, QString::number(attributeMargin()));

    writer.writeEndElement();
}

DomLayoutFunction::~DomLayoutFunction() = default;

void DomLayoutFunction::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"spacing"_s) {
            setAttributeSpacing(attribute.value().toString());
            continue;
        }
        if (name == u"margin"_s) {
            setAttributeMargin(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomLayoutFunction::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("layoutfunction") : tagName.toLower());

    if (hasAttributeSpacing())
        writer.writeAttribute(u"spacing"_s, attributeSpacing());

    if (hasAttributeMargin())
        writer.writeAttribute(u"margin"_s, attributeMargin());

    writer.writeEndElement();
}

DomTabStops::~DomTabStops()
{
    m_tabStop.clear();
}

void DomTabStops::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"tabstop"_s, Qt::CaseInsensitive)) {
                m_tabStop.append(reader.readElementText());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomTabStops::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("tabstops") : tagName.toLower());

    for (const QString &v : m_tabStop)
        writer.writeTextElement(u"tabstop"_s, v);

    writer.writeEndElement();
}

void DomTabStops::setElementTabStop(const QStringList &a)
{
    m_children |= TabStop;
    m_tabStop = a;
}

DomLayout::~DomLayout()
{
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_attribute);
    m_attribute.clear();
    qDeleteAll(m_item);
    m_item.clear();
}

void DomLayout::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"class"_s) {
            setAttributeClass(attribute.value().toString());
            continue;
        }
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        if (name == u"stretch"_s) {
            setAttributeStretch(attribute.value().toString());
            continue;
        }
        if (name == u"rowstretch"_s) {
            setAttributeRowStretch(attribute.value().toString());
            continue;
        }
        if (name == u"columnstretch"_s) {
            setAttributeColumnStretch(attribute.value().toString());
            continue;
        }
        if (name == u"rowminimumheight"_s) {
            setAttributeRowMinimumHeight(attribute.value().toString());
            continue;
        }
        if (name == u"columnminimumwidth"_s) {
            setAttributeColumnMinimumWidth(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"attribute"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_attribute.append(v);
                continue;
            }
            if (!tag.compare(u"item"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLayoutItem();
                v->read(reader);
                m_item.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomLayout::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("layout") : tagName.toLower());

    if (hasAttributeClass())
        writer.writeAttribute(u"class"_s, attributeClass());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    if (hasAttributeStretch())
        writer.writeAttribute(u"stretch"_s, attributeStretch());

    if (hasAttributeRowStretch())
        writer.writeAttribute(u"rowstretch"_s, attributeRowStretch());

    if (hasAttributeColumnStretch())
        writer.writeAttribute(u"columnstretch"_s, attributeColumnStretch());

    if (hasAttributeRowMinimumHeight())
        writer.writeAttribute(u"rowminimumheight"_s, attributeRowMinimumHeight());

    if (hasAttributeColumnMinimumWidth())
        writer.writeAttribute(u"columnminimumwidth"_s, attributeColumnMinimumWidth());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomProperty *v : m_attribute)
        v->write(writer, u"attribute"_s);

    for (DomLayoutItem *v : m_item)
        v->write(writer, u"item"_s);

    writer.writeEndElement();
}

void DomLayout::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomLayout::setElementAttribute(const QList<DomProperty *> &a)
{
    m_children |= Attribute;
    m_attribute = a;
}

void DomLayout::setElementItem(const QList<DomLayoutItem *> &a)
{
    m_children |= Item;
    m_item = a;
}

DomLayoutItem::~DomLayoutItem()
{
    delete m_widget;
    delete m_layout;
    delete m_spacer;
}

void DomLayoutItem::clear()
{
    delete m_widget;
    delete m_layout;
    delete m_spacer;

    m_kind = Unknown;

    m_widget = nullptr;
    m_layout = nullptr;
    m_spacer = nullptr;
}

void DomLayoutItem::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"row"_s) {
            setAttributeRow(attribute.value().toInt());
            continue;
        }
        if (name == u"column"_s) {
            setAttributeColumn(attribute.value().toInt());
            continue;
        }
        if (name == u"rowspan"_s) {
            setAttributeRowSpan(attribute.value().toInt());
            continue;
        }
        if (name == u"colspan"_s) {
            setAttributeColSpan(attribute.value().toInt());
            continue;
        }
        if (name == u"alignment"_s) {
            setAttributeAlignment(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"widget"_s, Qt::CaseInsensitive)) {
                auto *v = new DomWidget();
                v->read(reader);
                setElementWidget(v);
                continue;
            }
            if (!tag.compare(u"layout"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLayout();
                v->read(reader);
                setElementLayout(v);
                continue;
            }
            if (!tag.compare(u"spacer"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSpacer();
                v->read(reader);
                setElementSpacer(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomLayoutItem::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("layoutitem") : tagName.toLower());

    if (hasAttributeRow())
        writer.writeAttribute(u"row"_s, QString::number(attributeRow()));

    if (hasAttributeColumn())
        writer.writeAttribute(u"column"_s, QString::number(attributeColumn()));

    if (hasAttributeRowSpan())
        writer.writeAttribute(u"rowspan"_s, QString::number(attributeRowSpan()));

    if (hasAttributeColSpan())
        writer.writeAttribute(u"colspan"_s, QString::number(attributeColSpan()));

    if (hasAttributeAlignment())
        writer.writeAttribute(u"alignment"_s, attributeAlignment());

    switch (kind()) {
    case Widget:
        if (m_widget != nullptr)
            m_widget->write(writer, u"widget"_s);
        break;

    case Layout:
        if (m_layout != nullptr)
            m_layout->write(writer, u"layout"_s);
        break;

    case Spacer:
        if (m_spacer != nullptr)
            m_spacer->write(writer, u"spacer"_s);
        break;

    default:
        break;
    }
    writer.writeEndElement();
}

DomWidget *DomLayoutItem::takeElementWidget()
{
    DomWidget *a = m_widget;
    m_widget = nullptr;
    return a;
}

void DomLayoutItem::setElementWidget(DomWidget *a)
{
    clear();
    m_kind = Widget;
    m_widget = a;
}

DomLayout *DomLayoutItem::takeElementLayout()
{
    DomLayout *a = m_layout;
    m_layout = nullptr;
    return a;
}

void DomLayoutItem::setElementLayout(DomLayout *a)
{
    clear();
    m_kind = Layout;
    m_layout = a;
}

DomSpacer *DomLayoutItem::takeElementSpacer()
{
    DomSpacer *a = m_spacer;
    m_spacer = nullptr;
    return a;
}

void DomLayoutItem::setElementSpacer(DomSpacer *a)
{
    clear();
    m_kind = Spacer;
    m_spacer = a;
}

DomRow::~DomRow()
{
    qDeleteAll(m_property);
    m_property.clear();
}

void DomRow::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomRow::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("row") : tagName.toLower());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    writer.writeEndElement();
}

void DomRow::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

DomColumn::~DomColumn()
{
    qDeleteAll(m_property);
    m_property.clear();
}

void DomColumn::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomColumn::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("column") : tagName.toLower());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    writer.writeEndElement();
}

void DomColumn::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

DomItem::~DomItem()
{
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_item);
    m_item.clear();
}

void DomItem::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"row"_s) {
            setAttributeRow(attribute.value().toInt());
            continue;
        }
        if (name == u"column"_s) {
            setAttributeColumn(attribute.value().toInt());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"item"_s, Qt::CaseInsensitive)) {
                auto *v = new DomItem();
                v->read(reader);
                m_item.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomItem::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("item") : tagName.toLower());

    if (hasAttributeRow())
        writer.writeAttribute(u"row"_s, QString::number(attributeRow()));

    if (hasAttributeColumn())
        writer.writeAttribute(u"column"_s, QString::number(attributeColumn()));

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomItem *v : m_item)
        v->write(writer, u"item"_s);

    writer.writeEndElement();
}

void DomItem::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomItem::setElementItem(const QList<DomItem *> &a)
{
    m_children |= Item;
    m_item = a;
}

DomWidget::~DomWidget()
{
    m_class.clear();
    qDeleteAll(m_property);
    m_property.clear();
    qDeleteAll(m_attribute);
    m_attribute.clear();
    qDeleteAll(m_row);
    m_row.clear();
    qDeleteAll(m_column);
    m_column.clear();
    qDeleteAll(m_item);
    m_item.clear();
    qDeleteAll(m_layout);
    m_layout.clear();
    qDeleteAll(m_widget);
    m_widget.clear();
    qDeleteAll(m_action);
    m_action.clear();
    qDeleteAll(m_actionGroup);
    m_actionGroup.clear();
    qDeleteAll(m_addAction);
    m_addAction.clear();
    m_zOrder.clear();
}

void DomWidget::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"class"_s) {
            setAttributeClass(attribute.value().toString());
            continue;
        }
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        if (name == u"native"_s) {
            setAttributeNative(attribute.value() == u"true"_s);
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"class"_s, Qt::CaseInsensitive)) {
                m_class.append(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            if (!tag.compare(u"script"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <script>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"widgetdata"_s, Qt::CaseInsensitive)) {
                qWarning("Omitting deprecated element <widgetdata>.");
                reader.skipCurrentElement();
                continue;
            }
            if (!tag.compare(u"attribute"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_attribute.append(v);
                continue;
            }
            if (!tag.compare(u"row"_s, Qt::CaseInsensitive)) {
                auto *v = new DomRow();
                v->read(reader);
                m_row.append(v);
                continue;
            }
            if (!tag.compare(u"column"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColumn();
                v->read(reader);
                m_column.append(v);
                continue;
            }
            if (!tag.compare(u"item"_s, Qt::CaseInsensitive)) {
                auto *v = new DomItem();
                v->read(reader);
                m_item.append(v);
                continue;
            }
            if (!tag.compare(u"layout"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLayout();
                v->read(reader);
                m_layout.append(v);
                continue;
            }
            if (!tag.compare(u"widget"_s, Qt::CaseInsensitive)) {
                auto *v = new DomWidget();
                v->read(reader);
                m_widget.append(v);
                continue;
            }
            if (!tag.compare(u"action"_s, Qt::CaseInsensitive)) {
                auto *v = new DomAction();
                v->read(reader);
                m_action.append(v);
                continue;
            }
            if (!tag.compare(u"actiongroup"_s, Qt::CaseInsensitive)) {
                auto *v = new DomActionGroup();
                v->read(reader);
                m_actionGroup.append(v);
                continue;
            }
            if (!tag.compare(u"addaction"_s, Qt::CaseInsensitive)) {
                auto *v = new DomActionRef();
                v->read(reader);
                m_addAction.append(v);
                continue;
            }
            if (!tag.compare(u"zorder"_s, Qt::CaseInsensitive)) {
                m_zOrder.append(reader.readElementText());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomWidget::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("widget") : tagName.toLower());

    if (hasAttributeClass())
        writer.writeAttribute(u"class"_s, attributeClass());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    if (hasAttributeNative())
        writer.writeAttribute(u"native"_s, (attributeNative() ? u"true"_s : u"false"_s));

    for (const QString &v : m_class)
        writer.writeTextElement(u"class"_s, v);

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    for (DomProperty *v : m_attribute)
        v->write(writer, u"attribute"_s);

    for (DomRow *v : m_row)
        v->write(writer, u"row"_s);

    for (DomColumn *v : m_column)
        v->write(writer, u"column"_s);

    for (DomItem *v : m_item)
        v->write(writer, u"item"_s);

    for (DomLayout *v : m_layout)
        v->write(writer, u"layout"_s);

    for (DomWidget *v : m_widget)
        v->write(writer, u"widget"_s);

    for (DomAction *v : m_action)
        v->write(writer, u"action"_s);

    for (DomActionGroup *v : m_actionGroup)
        v->write(writer, u"actiongroup"_s);

    for (DomActionRef *v : m_addAction)
        v->write(writer, u"addaction"_s);

    for (const QString &v : m_zOrder)
        writer.writeTextElement(u"zorder"_s, v);

    writer.writeEndElement();
}

void DomWidget::setElementClass(const QStringList &a)
{
    m_children |= Class;
    m_class = a;
}

void DomWidget::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

void DomWidget::setElementAttribute(const QList<DomProperty *> &a)
{
    m_children |= Attribute;
    m_attribute = a;
}

void DomWidget::setElementRow(const QList<DomRow *> &a)
{
    m_children |= Row;
    m_row = a;
}

void DomWidget::setElementColumn(const QList<DomColumn *> &a)
{
    m_children |= Column;
    m_column = a;
}

void DomWidget::setElementItem(const QList<DomItem *> &a)
{
    m_children |= Item;
    m_item = a;
}

void DomWidget::setElementLayout(const QList<DomLayout *> &a)
{
    m_children |= Layout;
    m_layout = a;
}

void DomWidget::setElementWidget(const QList<DomWidget *> &a)
{
    m_children |= Widget;
    m_widget = a;
}

void DomWidget::setElementAction(const QList<DomAction *> &a)
{
    m_children |= Action;
    m_action = a;
}

void DomWidget::setElementActionGroup(const QList<DomActionGroup *> &a)
{
    m_children |= ActionGroup;
    m_actionGroup = a;
}

void DomWidget::setElementAddAction(const QList<DomActionRef *> &a)
{
    m_children |= AddAction;
    m_addAction = a;
}

void DomWidget::setElementZOrder(const QStringList &a)
{
    m_children |= ZOrder;
    m_zOrder = a;
}

DomSpacer::~DomSpacer()
{
    qDeleteAll(m_property);
    m_property.clear();
}

void DomSpacer::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomSpacer::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("spacer") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    writer.writeEndElement();
}

void DomSpacer::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

DomColor::~DomColor() = default;

void DomColor::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"alpha"_s) {
            setAttributeAlpha(attribute.value().toInt());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"red"_s, Qt::CaseInsensitive)) {
                setElementRed(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"green"_s, Qt::CaseInsensitive)) {
                setElementGreen(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"blue"_s, Qt::CaseInsensitive)) {
                setElementBlue(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomColor::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("color") : tagName.toLower());

    if (hasAttributeAlpha())
        writer.writeAttribute(u"alpha"_s, QString::number(attributeAlpha()));

    if (m_children & Red)
        writer.writeTextElement(u"red"_s, QString::number(m_red));

    if (m_children & Green)
        writer.writeTextElement(u"green"_s, QString::number(m_green));

    if (m_children & Blue)
        writer.writeTextElement(u"blue"_s, QString::number(m_blue));

    writer.writeEndElement();
}

void DomColor::setElementRed(int a)
{
    m_children |= Red;
    m_red = a;
}

void DomColor::setElementGreen(int a)
{
    m_children |= Green;
    m_green = a;
}

void DomColor::setElementBlue(int a)
{
    m_children |= Blue;
    m_blue = a;
}

void DomColor::clearElementRed()
{
    m_children &= ~Red;
}

void DomColor::clearElementGreen()
{
    m_children &= ~Green;
}

void DomColor::clearElementBlue()
{
    m_children &= ~Blue;
}

DomGradientStop::~DomGradientStop()
{
    delete m_color;
}

void DomGradientStop::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"position"_s) {
            setAttributePosition(attribute.value().toDouble());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"color"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColor();
                v->read(reader);
                setElementColor(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomGradientStop::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("gradientstop") : tagName.toLower());

    if (hasAttributePosition())
        writer.writeAttribute(u"position"_s, QString::number(attributePosition(), 'f', 15));

    if (m_children & Color)
        m_color->write(writer, u"color"_s);

    writer.writeEndElement();
}

DomColor *DomGradientStop::takeElementColor()
{
    DomColor *a = m_color;
    m_color = nullptr;
    m_children ^= Color;
    return a;
}

void DomGradientStop::setElementColor(DomColor *a)
{
    delete m_color;
    m_children |= Color;
    m_color = a;
}

void DomGradientStop::clearElementColor()
{
    delete m_color;
    m_color = nullptr;
    m_children &= ~Color;
}

DomGradient::~DomGradient()
{
    qDeleteAll(m_gradientStop);
    m_gradientStop.clear();
}

void DomGradient::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"startx"_s) {
            setAttributeStartX(attribute.value().toDouble());
            continue;
        }
        if (name == u"starty"_s) {
            setAttributeStartY(attribute.value().toDouble());
            continue;
        }
        if (name == u"endx"_s) {
            setAttributeEndX(attribute.value().toDouble());
            continue;
        }
        if (name == u"endy"_s) {
            setAttributeEndY(attribute.value().toDouble());
            continue;
        }
        if (name == u"centralx"_s) {
            setAttributeCentralX(attribute.value().toDouble());
            continue;
        }
        if (name == u"centraly"_s) {
            setAttributeCentralY(attribute.value().toDouble());
            continue;
        }
        if (name == u"focalx"_s) {
            setAttributeFocalX(attribute.value().toDouble());
            continue;
        }
        if (name == u"focaly"_s) {
            setAttributeFocalY(attribute.value().toDouble());
            continue;
        }
        if (name == u"radius"_s) {
            setAttributeRadius(attribute.value().toDouble());
            continue;
        }
        if (name == u"angle"_s) {
            setAttributeAngle(attribute.value().toDouble());
            continue;
        }
        if (name == u"type"_s) {
            setAttributeType(attribute.value().toString());
            continue;
        }
        if (name == u"spread"_s) {
            setAttributeSpread(attribute.value().toString());
            continue;
        }
        if (name == u"coordinatemode"_s) {
            setAttributeCoordinateMode(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"gradientstop"_s, Qt::CaseInsensitive)) {
                auto *v = new DomGradientStop();
                v->read(reader);
                m_gradientStop.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomGradient::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("gradient") : tagName.toLower());

    if (hasAttributeStartX())
        writer.writeAttribute(u"startx"_s, QString::number(attributeStartX(), 'f', 15));

    if (hasAttributeStartY())
        writer.writeAttribute(u"starty"_s, QString::number(attributeStartY(), 'f', 15));

    if (hasAttributeEndX())
        writer.writeAttribute(u"endx"_s, QString::number(attributeEndX(), 'f', 15));

    if (hasAttributeEndY())
        writer.writeAttribute(u"endy"_s, QString::number(attributeEndY(), 'f', 15));

    if (hasAttributeCentralX())
        writer.writeAttribute(u"centralx"_s, QString::number(attributeCentralX(), 'f', 15));

    if (hasAttributeCentralY())
        writer.writeAttribute(u"centraly"_s, QString::number(attributeCentralY(), 'f', 15));

    if (hasAttributeFocalX())
        writer.writeAttribute(u"focalx"_s, QString::number(attributeFocalX(), 'f', 15));

    if (hasAttributeFocalY())
        writer.writeAttribute(u"focaly"_s, QString::number(attributeFocalY(), 'f', 15));

    if (hasAttributeRadius())
        writer.writeAttribute(u"radius"_s, QString::number(attributeRadius(), 'f', 15));

    if (hasAttributeAngle())
        writer.writeAttribute(u"angle"_s, QString::number(attributeAngle(), 'f', 15));

    if (hasAttributeType())
        writer.writeAttribute(u"type"_s, attributeType());

    if (hasAttributeSpread())
        writer.writeAttribute(u"spread"_s, attributeSpread());

    if (hasAttributeCoordinateMode())
        writer.writeAttribute(u"coordinatemode"_s, attributeCoordinateMode());

    for (DomGradientStop *v : m_gradientStop)
        v->write(writer, u"gradientstop"_s);

    writer.writeEndElement();
}

void DomGradient::setElementGradientStop(const QList<DomGradientStop *> &a)
{
    m_children |= GradientStop;
    m_gradientStop = a;
}

DomBrush::~DomBrush()
{
    delete m_color;
    delete m_texture;
    delete m_gradient;
}

void DomBrush::clear()
{
    delete m_color;
    delete m_texture;
    delete m_gradient;

    m_kind = Unknown;

    m_color = nullptr;
    m_texture = nullptr;
    m_gradient = nullptr;
}

void DomBrush::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"brushstyle"_s) {
            setAttributeBrushStyle(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"color"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColor();
                v->read(reader);
                setElementColor(v);
                continue;
            }
            if (!tag.compare(u"texture"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                setElementTexture(v);
                continue;
            }
            if (!tag.compare(u"gradient"_s, Qt::CaseInsensitive)) {
                auto *v = new DomGradient();
                v->read(reader);
                setElementGradient(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomBrush::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("brush") : tagName.toLower());

    if (hasAttributeBrushStyle())
        writer.writeAttribute(u"brushstyle"_s, attributeBrushStyle());

    switch (kind()) {
    case Color:
        if (m_color != nullptr)
            m_color->write(writer, u"color"_s);
        break;

    case Texture:
        if (m_texture != nullptr)
            m_texture->write(writer, u"texture"_s);
        break;

    case Gradient:
        if (m_gradient != nullptr)
            m_gradient->write(writer, u"gradient"_s);
        break;

    default:
        break;
    }
    writer.writeEndElement();
}

DomColor *DomBrush::takeElementColor()
{
    DomColor *a = m_color;
    m_color = nullptr;
    return a;
}

void DomBrush::setElementColor(DomColor *a)
{
    clear();
    m_kind = Color;
    m_color = a;
}

DomProperty *DomBrush::takeElementTexture()
{
    DomProperty *a = m_texture;
    m_texture = nullptr;
    return a;
}

void DomBrush::setElementTexture(DomProperty *a)
{
    clear();
    m_kind = Texture;
    m_texture = a;
}

DomGradient *DomBrush::takeElementGradient()
{
    DomGradient *a = m_gradient;
    m_gradient = nullptr;
    return a;
}

void DomBrush::setElementGradient(DomGradient *a)
{
    clear();
    m_kind = Gradient;
    m_gradient = a;
}

DomColorRole::~DomColorRole()
{
    delete m_brush;
}

void DomColorRole::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"role"_s) {
            setAttributeRole(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"brush"_s, Qt::CaseInsensitive)) {
                auto *v = new DomBrush();
                v->read(reader);
                setElementBrush(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomColorRole::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("colorrole") : tagName.toLower());

    if (hasAttributeRole())
        writer.writeAttribute(u"role"_s, attributeRole());

    if (m_children & Brush)
        m_brush->write(writer, u"brush"_s);

    writer.writeEndElement();
}

DomBrush *DomColorRole::takeElementBrush()
{
    DomBrush *a = m_brush;
    m_brush = nullptr;
    m_children ^= Brush;
    return a;
}

void DomColorRole::setElementBrush(DomBrush *a)
{
    delete m_brush;
    m_children |= Brush;
    m_brush = a;
}

void DomColorRole::clearElementBrush()
{
    delete m_brush;
    m_brush = nullptr;
    m_children &= ~Brush;
}

DomColorGroup::~DomColorGroup()
{
    qDeleteAll(m_colorRole);
    m_colorRole.clear();
    qDeleteAll(m_color);
    m_color.clear();
}

void DomColorGroup::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"colorrole"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColorRole();
                v->read(reader);
                m_colorRole.append(v);
                continue;
            }
            if (!tag.compare(u"color"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColor();
                v->read(reader);
                m_color.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomColorGroup::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("colorgroup") : tagName.toLower());

    for (DomColorRole *v : m_colorRole)
        v->write(writer, u"colorrole"_s);

    for (DomColor *v : m_color)
        v->write(writer, u"color"_s);

    writer.writeEndElement();
}

void DomColorGroup::setElementColorRole(const QList<DomColorRole *> &a)
{
    m_children |= ColorRole;
    m_colorRole = a;
}

void DomColorGroup::setElementColor(const QList<DomColor *> &a)
{
    m_children |= Color;
    m_color = a;
}

DomPalette::~DomPalette()
{
    delete m_active;
    delete m_inactive;
    delete m_disabled;
}

void DomPalette::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"active"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColorGroup();
                v->read(reader);
                setElementActive(v);
                continue;
            }
            if (!tag.compare(u"inactive"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColorGroup();
                v->read(reader);
                setElementInactive(v);
                continue;
            }
            if (!tag.compare(u"disabled"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColorGroup();
                v->read(reader);
                setElementDisabled(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomPalette::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("palette") : tagName.toLower());

    if (m_children & Active)
        m_active->write(writer, u"active"_s);

    if (m_children & Inactive)
        m_inactive->write(writer, u"inactive"_s);

    if (m_children & Disabled)
        m_disabled->write(writer, u"disabled"_s);

    writer.writeEndElement();
}

DomColorGroup *DomPalette::takeElementActive()
{
    DomColorGroup *a = m_active;
    m_active = nullptr;
    m_children ^= Active;
    return a;
}

void DomPalette::setElementActive(DomColorGroup *a)
{
    delete m_active;
    m_children |= Active;
    m_active = a;
}

DomColorGroup *DomPalette::takeElementInactive()
{
    DomColorGroup *a = m_inactive;
    m_inactive = nullptr;
    m_children ^= Inactive;
    return a;
}

void DomPalette::setElementInactive(DomColorGroup *a)
{
    delete m_inactive;
    m_children |= Inactive;
    m_inactive = a;
}

DomColorGroup *DomPalette::takeElementDisabled()
{
    DomColorGroup *a = m_disabled;
    m_disabled = nullptr;
    m_children ^= Disabled;
    return a;
}

void DomPalette::setElementDisabled(DomColorGroup *a)
{
    delete m_disabled;
    m_children |= Disabled;
    m_disabled = a;
}

void DomPalette::clearElementActive()
{
    delete m_active;
    m_active = nullptr;
    m_children &= ~Active;
}

void DomPalette::clearElementInactive()
{
    delete m_inactive;
    m_inactive = nullptr;
    m_children &= ~Inactive;
}

void DomPalette::clearElementDisabled()
{
    delete m_disabled;
    m_disabled = nullptr;
    m_children &= ~Disabled;
}

DomFont::~DomFont() = default;

void DomFont::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"family"_s, Qt::CaseInsensitive)) {
                setElementFamily(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"pointsize"_s, Qt::CaseInsensitive)) {
                setElementPointSize(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"weight"_s, Qt::CaseInsensitive)) {
                setElementWeight(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"italic"_s, Qt::CaseInsensitive)) {
                setElementItalic(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"bold"_s, Qt::CaseInsensitive)) {
                setElementBold(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"underline"_s, Qt::CaseInsensitive)) {
                setElementUnderline(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"strikeout"_s, Qt::CaseInsensitive)) {
                setElementStrikeOut(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"antialiasing"_s, Qt::CaseInsensitive)) {
                setElementAntialiasing(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"stylestrategy"_s, Qt::CaseInsensitive)) {
                setElementStyleStrategy(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"kerning"_s, Qt::CaseInsensitive)) {
                setElementKerning(reader.readElementText() == u"true"_s);
                continue;
            }
            if (!tag.compare(u"hintingpreference"_s, Qt::CaseInsensitive)) {
                setElementHintingPreference(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"fontweight"_s, Qt::CaseInsensitive)) {
                setElementFontWeight(reader.readElementText());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomFont::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("font") : tagName.toLower());

    if (m_children & Family)
        writer.writeTextElement(u"family"_s, m_family);

    if (m_children & PointSize)
        writer.writeTextElement(u"pointsize"_s, QString::number(m_pointSize));

    if (m_children & Weight)
        writer.writeTextElement(u"weight"_s, QString::number(m_weight));

    if (m_children & Italic)
        writer.writeTextElement(u"italic"_s, (m_italic ? u"true"_s : u"false"_s));

    if (m_children & Bold)
        writer.writeTextElement(u"bold"_s, (m_bold ? u"true"_s : u"false"_s));

    if (m_children & Underline)
        writer.writeTextElement(u"underline"_s, (m_underline ? u"true"_s : u"false"_s));

    if (m_children & StrikeOut)
        writer.writeTextElement(u"strikeout"_s, (m_strikeOut ? u"true"_s : u"false"_s));

    if (m_children & Antialiasing)
        writer.writeTextElement(u"antialiasing"_s, (m_antialiasing ? u"true"_s : u"false"_s));

    if (m_children & StyleStrategy)
        writer.writeTextElement(u"stylestrategy"_s, m_styleStrategy);

    if (m_children & Kerning)
        writer.writeTextElement(u"kerning"_s, (m_kerning ? u"true"_s : u"false"_s));

    if (m_children & HintingPreference)
        writer.writeTextElement(u"hintingpreference"_s, m_hintingPreference);

    if (m_children & FontWeight)
        writer.writeTextElement(u"fontweight"_s, m_fontWeight);

    writer.writeEndElement();
}

void DomFont::setElementFamily(const QString &a)
{
    m_children |= Family;
    m_family = a;
}

void DomFont::setElementPointSize(int a)
{
    m_children |= PointSize;
    m_pointSize = a;
}

void DomFont::setElementWeight(int a)
{
    m_children |= Weight;
    m_weight = a;
}

void DomFont::setElementItalic(bool a)
{
    m_children |= Italic;
    m_italic = a;
}

void DomFont::setElementBold(bool a)
{
    m_children |= Bold;
    m_bold = a;
}

void DomFont::setElementUnderline(bool a)
{
    m_children |= Underline;
    m_underline = a;
}

void DomFont::setElementStrikeOut(bool a)
{
    m_children |= StrikeOut;
    m_strikeOut = a;
}

void DomFont::setElementAntialiasing(bool a)
{
    m_children |= Antialiasing;
    m_antialiasing = a;
}

void DomFont::setElementStyleStrategy(const QString &a)
{
    m_children |= StyleStrategy;
    m_styleStrategy = a;
}

void DomFont::setElementKerning(bool a)
{
    m_children |= Kerning;
    m_kerning = a;
}

void DomFont::setElementHintingPreference(const QString &a)
{
    m_children |= HintingPreference;
    m_hintingPreference = a;
}

void DomFont::setElementFontWeight(const QString &a)
{
    m_children |= FontWeight;
    m_fontWeight = a;
}

void DomFont::clearElementFamily()
{
    m_children &= ~Family;
}

void DomFont::clearElementPointSize()
{
    m_children &= ~PointSize;
}

void DomFont::clearElementWeight()
{
    m_children &= ~Weight;
}

void DomFont::clearElementItalic()
{
    m_children &= ~Italic;
}

void DomFont::clearElementBold()
{
    m_children &= ~Bold;
}

void DomFont::clearElementUnderline()
{
    m_children &= ~Underline;
}

void DomFont::clearElementStrikeOut()
{
    m_children &= ~StrikeOut;
}

void DomFont::clearElementAntialiasing()
{
    m_children &= ~Antialiasing;
}

void DomFont::clearElementStyleStrategy()
{
    m_children &= ~StyleStrategy;
}

void DomFont::clearElementKerning()
{
    m_children &= ~Kerning;
}

void DomFont::clearElementHintingPreference()
{
    m_children &= ~HintingPreference;
}

void DomFont::clearElementFontWeight()
{
    m_children &= ~FontWeight;
}

DomPoint::~DomPoint() = default;

void DomPoint::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"x"_s, Qt::CaseInsensitive)) {
                setElementX(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"y"_s, Qt::CaseInsensitive)) {
                setElementY(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomPoint::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("point") : tagName.toLower());

    if (m_children & X)
        writer.writeTextElement(u"x"_s, QString::number(m_x));

    if (m_children & Y)
        writer.writeTextElement(u"y"_s, QString::number(m_y));

    writer.writeEndElement();
}

void DomPoint::setElementX(int a)
{
    m_children |= X;
    m_x = a;
}

void DomPoint::setElementY(int a)
{
    m_children |= Y;
    m_y = a;
}

void DomPoint::clearElementX()
{
    m_children &= ~X;
}

void DomPoint::clearElementY()
{
    m_children &= ~Y;
}

DomRect::~DomRect() = default;

void DomRect::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"x"_s, Qt::CaseInsensitive)) {
                setElementX(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"y"_s, Qt::CaseInsensitive)) {
                setElementY(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"width"_s, Qt::CaseInsensitive)) {
                setElementWidth(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"height"_s, Qt::CaseInsensitive)) {
                setElementHeight(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomRect::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("rect") : tagName.toLower());

    if (m_children & X)
        writer.writeTextElement(u"x"_s, QString::number(m_x));

    if (m_children & Y)
        writer.writeTextElement(u"y"_s, QString::number(m_y));

    if (m_children & Width)
        writer.writeTextElement(u"width"_s, QString::number(m_width));

    if (m_children & Height)
        writer.writeTextElement(u"height"_s, QString::number(m_height));

    writer.writeEndElement();
}

void DomRect::setElementX(int a)
{
    m_children |= X;
    m_x = a;
}

void DomRect::setElementY(int a)
{
    m_children |= Y;
    m_y = a;
}

void DomRect::setElementWidth(int a)
{
    m_children |= Width;
    m_width = a;
}

void DomRect::setElementHeight(int a)
{
    m_children |= Height;
    m_height = a;
}

void DomRect::clearElementX()
{
    m_children &= ~X;
}

void DomRect::clearElementY()
{
    m_children &= ~Y;
}

void DomRect::clearElementWidth()
{
    m_children &= ~Width;
}

void DomRect::clearElementHeight()
{
    m_children &= ~Height;
}

DomLocale::~DomLocale() = default;

void DomLocale::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"language"_s) {
            setAttributeLanguage(attribute.value().toString());
            continue;
        }
        if (name == u"country"_s) {
            setAttributeCountry(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomLocale::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("locale") : tagName.toLower());

    if (hasAttributeLanguage())
        writer.writeAttribute(u"language"_s, attributeLanguage());

    if (hasAttributeCountry())
        writer.writeAttribute(u"country"_s, attributeCountry());

    writer.writeEndElement();
}

DomSizePolicy::~DomSizePolicy() = default;

void DomSizePolicy::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"hsizetype"_s) {
            setAttributeHSizeType(attribute.value().toString());
            continue;
        }
        if (name == u"vsizetype"_s) {
            setAttributeVSizeType(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"hsizetype"_s, Qt::CaseInsensitive)) {
                setElementHSizeType(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"vsizetype"_s, Qt::CaseInsensitive)) {
                setElementVSizeType(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"horstretch"_s, Qt::CaseInsensitive)) {
                setElementHorStretch(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"verstretch"_s, Qt::CaseInsensitive)) {
                setElementVerStretch(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomSizePolicy::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("sizepolicy") : tagName.toLower());

    if (hasAttributeHSizeType())
        writer.writeAttribute(u"hsizetype"_s, attributeHSizeType());

    if (hasAttributeVSizeType())
        writer.writeAttribute(u"vsizetype"_s, attributeVSizeType());

    if (m_children & HSizeType)
        writer.writeTextElement(u"hsizetype"_s, QString::number(m_hSizeType));

    if (m_children & VSizeType)
        writer.writeTextElement(u"vsizetype"_s, QString::number(m_vSizeType));

    if (m_children & HorStretch)
        writer.writeTextElement(u"horstretch"_s, QString::number(m_horStretch));

    if (m_children & VerStretch)
        writer.writeTextElement(u"verstretch"_s, QString::number(m_verStretch));

    writer.writeEndElement();
}

void DomSizePolicy::setElementHSizeType(int a)
{
    m_children |= HSizeType;
    m_hSizeType = a;
}

void DomSizePolicy::setElementVSizeType(int a)
{
    m_children |= VSizeType;
    m_vSizeType = a;
}

void DomSizePolicy::setElementHorStretch(int a)
{
    m_children |= HorStretch;
    m_horStretch = a;
}

void DomSizePolicy::setElementVerStretch(int a)
{
    m_children |= VerStretch;
    m_verStretch = a;
}

void DomSizePolicy::clearElementHSizeType()
{
    m_children &= ~HSizeType;
}

void DomSizePolicy::clearElementVSizeType()
{
    m_children &= ~VSizeType;
}

void DomSizePolicy::clearElementHorStretch()
{
    m_children &= ~HorStretch;
}

void DomSizePolicy::clearElementVerStretch()
{
    m_children &= ~VerStretch;
}

DomSize::~DomSize() = default;

void DomSize::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"width"_s, Qt::CaseInsensitive)) {
                setElementWidth(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"height"_s, Qt::CaseInsensitive)) {
                setElementHeight(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomSize::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("size") : tagName.toLower());

    if (m_children & Width)
        writer.writeTextElement(u"width"_s, QString::number(m_width));

    if (m_children & Height)
        writer.writeTextElement(u"height"_s, QString::number(m_height));

    writer.writeEndElement();
}

void DomSize::setElementWidth(int a)
{
    m_children |= Width;
    m_width = a;
}

void DomSize::setElementHeight(int a)
{
    m_children |= Height;
    m_height = a;
}

void DomSize::clearElementWidth()
{
    m_children &= ~Width;
}

void DomSize::clearElementHeight()
{
    m_children &= ~Height;
}

DomDate::~DomDate() = default;

void DomDate::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"year"_s, Qt::CaseInsensitive)) {
                setElementYear(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"month"_s, Qt::CaseInsensitive)) {
                setElementMonth(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"day"_s, Qt::CaseInsensitive)) {
                setElementDay(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomDate::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("date") : tagName.toLower());

    if (m_children & Year)
        writer.writeTextElement(u"year"_s, QString::number(m_year));

    if (m_children & Month)
        writer.writeTextElement(u"month"_s, QString::number(m_month));

    if (m_children & Day)
        writer.writeTextElement(u"day"_s, QString::number(m_day));

    writer.writeEndElement();
}

void DomDate::setElementYear(int a)
{
    m_children |= Year;
    m_year = a;
}

void DomDate::setElementMonth(int a)
{
    m_children |= Month;
    m_month = a;
}

void DomDate::setElementDay(int a)
{
    m_children |= Day;
    m_day = a;
}

void DomDate::clearElementYear()
{
    m_children &= ~Year;
}

void DomDate::clearElementMonth()
{
    m_children &= ~Month;
}

void DomDate::clearElementDay()
{
    m_children &= ~Day;
}

DomTime::~DomTime() = default;

void DomTime::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"hour"_s, Qt::CaseInsensitive)) {
                setElementHour(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"minute"_s, Qt::CaseInsensitive)) {
                setElementMinute(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"second"_s, Qt::CaseInsensitive)) {
                setElementSecond(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomTime::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("time") : tagName.toLower());

    if (m_children & Hour)
        writer.writeTextElement(u"hour"_s, QString::number(m_hour));

    if (m_children & Minute)
        writer.writeTextElement(u"minute"_s, QString::number(m_minute));

    if (m_children & Second)
        writer.writeTextElement(u"second"_s, QString::number(m_second));

    writer.writeEndElement();
}

void DomTime::setElementHour(int a)
{
    m_children |= Hour;
    m_hour = a;
}

void DomTime::setElementMinute(int a)
{
    m_children |= Minute;
    m_minute = a;
}

void DomTime::setElementSecond(int a)
{
    m_children |= Second;
    m_second = a;
}

void DomTime::clearElementHour()
{
    m_children &= ~Hour;
}

void DomTime::clearElementMinute()
{
    m_children &= ~Minute;
}

void DomTime::clearElementSecond()
{
    m_children &= ~Second;
}

DomDateTime::~DomDateTime() = default;

void DomDateTime::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"hour"_s, Qt::CaseInsensitive)) {
                setElementHour(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"minute"_s, Qt::CaseInsensitive)) {
                setElementMinute(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"second"_s, Qt::CaseInsensitive)) {
                setElementSecond(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"year"_s, Qt::CaseInsensitive)) {
                setElementYear(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"month"_s, Qt::CaseInsensitive)) {
                setElementMonth(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"day"_s, Qt::CaseInsensitive)) {
                setElementDay(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomDateTime::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("datetime") : tagName.toLower());

    if (m_children & Hour)
        writer.writeTextElement(u"hour"_s, QString::number(m_hour));

    if (m_children & Minute)
        writer.writeTextElement(u"minute"_s, QString::number(m_minute));

    if (m_children & Second)
        writer.writeTextElement(u"second"_s, QString::number(m_second));

    if (m_children & Year)
        writer.writeTextElement(u"year"_s, QString::number(m_year));

    if (m_children & Month)
        writer.writeTextElement(u"month"_s, QString::number(m_month));

    if (m_children & Day)
        writer.writeTextElement(u"day"_s, QString::number(m_day));

    writer.writeEndElement();
}

void DomDateTime::setElementHour(int a)
{
    m_children |= Hour;
    m_hour = a;
}

void DomDateTime::setElementMinute(int a)
{
    m_children |= Minute;
    m_minute = a;
}

void DomDateTime::setElementSecond(int a)
{
    m_children |= Second;
    m_second = a;
}

void DomDateTime::setElementYear(int a)
{
    m_children |= Year;
    m_year = a;
}

void DomDateTime::setElementMonth(int a)
{
    m_children |= Month;
    m_month = a;
}

void DomDateTime::setElementDay(int a)
{
    m_children |= Day;
    m_day = a;
}

void DomDateTime::clearElementHour()
{
    m_children &= ~Hour;
}

void DomDateTime::clearElementMinute()
{
    m_children &= ~Minute;
}

void DomDateTime::clearElementSecond()
{
    m_children &= ~Second;
}

void DomDateTime::clearElementYear()
{
    m_children &= ~Year;
}

void DomDateTime::clearElementMonth()
{
    m_children &= ~Month;
}

void DomDateTime::clearElementDay()
{
    m_children &= ~Day;
}

DomStringList::~DomStringList()
{
    m_string.clear();
}

void DomStringList::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"notr"_s) {
            setAttributeNotr(attribute.value().toString());
            continue;
        }
        if (name == u"comment"_s) {
            setAttributeComment(attribute.value().toString());
            continue;
        }
        if (name == u"extracomment"_s) {
            setAttributeExtraComment(attribute.value().toString());
            continue;
        }
        if (name == u"id"_s) {
            setAttributeId(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"string"_s, Qt::CaseInsensitive)) {
                m_string.append(reader.readElementText());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomStringList::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("stringlist") : tagName.toLower());

    if (hasAttributeNotr())
        writer.writeAttribute(u"notr"_s, attributeNotr());

    if (hasAttributeComment())
        writer.writeAttribute(u"comment"_s, attributeComment());

    if (hasAttributeExtraComment())
        writer.writeAttribute(u"extracomment"_s, attributeExtraComment());

    if (hasAttributeId())
        writer.writeAttribute(u"id"_s, attributeId());

    for (const QString &v : m_string)
        writer.writeTextElement(u"string"_s, v);

    writer.writeEndElement();
}

void DomStringList::setElementString(const QStringList &a)
{
    m_children |= String;
    m_string = a;
}

DomResourcePixmap::~DomResourcePixmap() = default;

void DomResourcePixmap::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"resource"_s) {
            setAttributeResource(attribute.value().toString());
            continue;
        }
        if (name == u"alias"_s) {
            setAttributeAlias(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        case QXmlStreamReader::Characters :
            if (!reader.isWhitespace())
                m_text.append(reader.text().toString());
            break;
        default :
            break;
        }
    }
}

void DomResourcePixmap::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("resourcepixmap") : tagName.toLower());

    if (hasAttributeResource())
        writer.writeAttribute(u"resource"_s, attributeResource());

    if (hasAttributeAlias())
        writer.writeAttribute(u"alias"_s, attributeAlias());

    if (!m_text.isEmpty())
        writer.writeCharacters(m_text);

    writer.writeEndElement();
}

DomResourceIcon::~DomResourceIcon()
{
    delete m_normalOff;
    delete m_normalOn;
    delete m_disabledOff;
    delete m_disabledOn;
    delete m_activeOff;
    delete m_activeOn;
    delete m_selectedOff;
    delete m_selectedOn;
}

void DomResourceIcon::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"theme"_s) {
            setAttributeTheme(attribute.value().toString());
            continue;
        }
        if (name == u"resource"_s) {
            setAttributeResource(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"normaloff"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementNormalOff(v);
                continue;
            }
            if (!tag.compare(u"normalon"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementNormalOn(v);
                continue;
            }
            if (!tag.compare(u"disabledoff"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementDisabledOff(v);
                continue;
            }
            if (!tag.compare(u"disabledon"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementDisabledOn(v);
                continue;
            }
            if (!tag.compare(u"activeoff"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementActiveOff(v);
                continue;
            }
            if (!tag.compare(u"activeon"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementActiveOn(v);
                continue;
            }
            if (!tag.compare(u"selectedoff"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementSelectedOff(v);
                continue;
            }
            if (!tag.compare(u"selectedon"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementSelectedOn(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        case QXmlStreamReader::Characters :
            if (!reader.isWhitespace())
                m_text.append(reader.text().toString());
            break;
        default :
            break;
        }
    }
}

void DomResourceIcon::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("resourceicon") : tagName.toLower());

    if (hasAttributeTheme())
        writer.writeAttribute(u"theme"_s, attributeTheme());

    if (hasAttributeResource())
        writer.writeAttribute(u"resource"_s, attributeResource());

    if (m_children & NormalOff)
        m_normalOff->write(writer, u"normaloff"_s);

    if (m_children & NormalOn)
        m_normalOn->write(writer, u"normalon"_s);

    if (m_children & DisabledOff)
        m_disabledOff->write(writer, u"disabledoff"_s);

    if (m_children & DisabledOn)
        m_disabledOn->write(writer, u"disabledon"_s);

    if (m_children & ActiveOff)
        m_activeOff->write(writer, u"activeoff"_s);

    if (m_children & ActiveOn)
        m_activeOn->write(writer, u"activeon"_s);

    if (m_children & SelectedOff)
        m_selectedOff->write(writer, u"selectedoff"_s);

    if (m_children & SelectedOn)
        m_selectedOn->write(writer, u"selectedon"_s);

    if (!m_text.isEmpty())
        writer.writeCharacters(m_text);

    writer.writeEndElement();
}

DomResourcePixmap *DomResourceIcon::takeElementNormalOff()
{
    DomResourcePixmap *a = m_normalOff;
    m_normalOff = nullptr;
    m_children ^= NormalOff;
    return a;
}

void DomResourceIcon::setElementNormalOff(DomResourcePixmap *a)
{
    delete m_normalOff;
    m_children |= NormalOff;
    m_normalOff = a;
}

DomResourcePixmap *DomResourceIcon::takeElementNormalOn()
{
    DomResourcePixmap *a = m_normalOn;
    m_normalOn = nullptr;
    m_children ^= NormalOn;
    return a;
}

void DomResourceIcon::setElementNormalOn(DomResourcePixmap *a)
{
    delete m_normalOn;
    m_children |= NormalOn;
    m_normalOn = a;
}

DomResourcePixmap *DomResourceIcon::takeElementDisabledOff()
{
    DomResourcePixmap *a = m_disabledOff;
    m_disabledOff = nullptr;
    m_children ^= DisabledOff;
    return a;
}

void DomResourceIcon::setElementDisabledOff(DomResourcePixmap *a)
{
    delete m_disabledOff;
    m_children |= DisabledOff;
    m_disabledOff = a;
}

DomResourcePixmap *DomResourceIcon::takeElementDisabledOn()
{
    DomResourcePixmap *a = m_disabledOn;
    m_disabledOn = nullptr;
    m_children ^= DisabledOn;
    return a;
}

void DomResourceIcon::setElementDisabledOn(DomResourcePixmap *a)
{
    delete m_disabledOn;
    m_children |= DisabledOn;
    m_disabledOn = a;
}

DomResourcePixmap *DomResourceIcon::takeElementActiveOff()
{
    DomResourcePixmap *a = m_activeOff;
    m_activeOff = nullptr;
    m_children ^= ActiveOff;
    return a;
}

void DomResourceIcon::setElementActiveOff(DomResourcePixmap *a)
{
    delete m_activeOff;
    m_children |= ActiveOff;
    m_activeOff = a;
}

DomResourcePixmap *DomResourceIcon::takeElementActiveOn()
{
    DomResourcePixmap *a = m_activeOn;
    m_activeOn = nullptr;
    m_children ^= ActiveOn;
    return a;
}

void DomResourceIcon::setElementActiveOn(DomResourcePixmap *a)
{
    delete m_activeOn;
    m_children |= ActiveOn;
    m_activeOn = a;
}

DomResourcePixmap *DomResourceIcon::takeElementSelectedOff()
{
    DomResourcePixmap *a = m_selectedOff;
    m_selectedOff = nullptr;
    m_children ^= SelectedOff;
    return a;
}

void DomResourceIcon::setElementSelectedOff(DomResourcePixmap *a)
{
    delete m_selectedOff;
    m_children |= SelectedOff;
    m_selectedOff = a;
}

DomResourcePixmap *DomResourceIcon::takeElementSelectedOn()
{
    DomResourcePixmap *a = m_selectedOn;
    m_selectedOn = nullptr;
    m_children ^= SelectedOn;
    return a;
}

void DomResourceIcon::setElementSelectedOn(DomResourcePixmap *a)
{
    delete m_selectedOn;
    m_children |= SelectedOn;
    m_selectedOn = a;
}

void DomResourceIcon::clearElementNormalOff()
{
    delete m_normalOff;
    m_normalOff = nullptr;
    m_children &= ~NormalOff;
}

void DomResourceIcon::clearElementNormalOn()
{
    delete m_normalOn;
    m_normalOn = nullptr;
    m_children &= ~NormalOn;
}

void DomResourceIcon::clearElementDisabledOff()
{
    delete m_disabledOff;
    m_disabledOff = nullptr;
    m_children &= ~DisabledOff;
}

void DomResourceIcon::clearElementDisabledOn()
{
    delete m_disabledOn;
    m_disabledOn = nullptr;
    m_children &= ~DisabledOn;
}

void DomResourceIcon::clearElementActiveOff()
{
    delete m_activeOff;
    m_activeOff = nullptr;
    m_children &= ~ActiveOff;
}

void DomResourceIcon::clearElementActiveOn()
{
    delete m_activeOn;
    m_activeOn = nullptr;
    m_children &= ~ActiveOn;
}

void DomResourceIcon::clearElementSelectedOff()
{
    delete m_selectedOff;
    m_selectedOff = nullptr;
    m_children &= ~SelectedOff;
}

void DomResourceIcon::clearElementSelectedOn()
{
    delete m_selectedOn;
    m_selectedOn = nullptr;
    m_children &= ~SelectedOn;
}

DomString::~DomString() = default;

void DomString::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"notr"_s) {
            setAttributeNotr(attribute.value().toString());
            continue;
        }
        if (name == u"comment"_s) {
            setAttributeComment(attribute.value().toString());
            continue;
        }
        if (name == u"extracomment"_s) {
            setAttributeExtraComment(attribute.value().toString());
            continue;
        }
        if (name == u"id"_s) {
            setAttributeId(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        case QXmlStreamReader::Characters :
            if (!reader.isWhitespace())
                m_text.append(reader.text().toString());
            break;
        default :
            break;
        }
    }
}

void DomString::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("string") : tagName.toLower());

    if (hasAttributeNotr())
        writer.writeAttribute(u"notr"_s, attributeNotr());

    if (hasAttributeComment())
        writer.writeAttribute(u"comment"_s, attributeComment());

    if (hasAttributeExtraComment())
        writer.writeAttribute(u"extracomment"_s, attributeExtraComment());

    if (hasAttributeId())
        writer.writeAttribute(u"id"_s, attributeId());

    if (!m_text.isEmpty())
        writer.writeCharacters(m_text);

    writer.writeEndElement();
}

DomPointF::~DomPointF() = default;

void DomPointF::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"x"_s, Qt::CaseInsensitive)) {
                setElementX(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"y"_s, Qt::CaseInsensitive)) {
                setElementY(reader.readElementText().toDouble());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomPointF::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("pointf") : tagName.toLower());

    if (m_children & X)
        writer.writeTextElement(u"x"_s, QString::number(m_x, 'f', 15));

    if (m_children & Y)
        writer.writeTextElement(u"y"_s, QString::number(m_y, 'f', 15));

    writer.writeEndElement();
}

void DomPointF::setElementX(double a)
{
    m_children |= X;
    m_x = a;
}

void DomPointF::setElementY(double a)
{
    m_children |= Y;
    m_y = a;
}

void DomPointF::clearElementX()
{
    m_children &= ~X;
}

void DomPointF::clearElementY()
{
    m_children &= ~Y;
}

DomRectF::~DomRectF() = default;

void DomRectF::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"x"_s, Qt::CaseInsensitive)) {
                setElementX(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"y"_s, Qt::CaseInsensitive)) {
                setElementY(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"width"_s, Qt::CaseInsensitive)) {
                setElementWidth(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"height"_s, Qt::CaseInsensitive)) {
                setElementHeight(reader.readElementText().toDouble());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomRectF::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("rectf") : tagName.toLower());

    if (m_children & X)
        writer.writeTextElement(u"x"_s, QString::number(m_x, 'f', 15));

    if (m_children & Y)
        writer.writeTextElement(u"y"_s, QString::number(m_y, 'f', 15));

    if (m_children & Width)
        writer.writeTextElement(u"width"_s, QString::number(m_width, 'f', 15));

    if (m_children & Height)
        writer.writeTextElement(u"height"_s, QString::number(m_height, 'f', 15));

    writer.writeEndElement();
}

void DomRectF::setElementX(double a)
{
    m_children |= X;
    m_x = a;
}

void DomRectF::setElementY(double a)
{
    m_children |= Y;
    m_y = a;
}

void DomRectF::setElementWidth(double a)
{
    m_children |= Width;
    m_width = a;
}

void DomRectF::setElementHeight(double a)
{
    m_children |= Height;
    m_height = a;
}

void DomRectF::clearElementX()
{
    m_children &= ~X;
}

void DomRectF::clearElementY()
{
    m_children &= ~Y;
}

void DomRectF::clearElementWidth()
{
    m_children &= ~Width;
}

void DomRectF::clearElementHeight()
{
    m_children &= ~Height;
}

DomSizeF::~DomSizeF() = default;

void DomSizeF::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"width"_s, Qt::CaseInsensitive)) {
                setElementWidth(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"height"_s, Qt::CaseInsensitive)) {
                setElementHeight(reader.readElementText().toDouble());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomSizeF::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("sizef") : tagName.toLower());

    if (m_children & Width)
        writer.writeTextElement(u"width"_s, QString::number(m_width, 'f', 15));

    if (m_children & Height)
        writer.writeTextElement(u"height"_s, QString::number(m_height, 'f', 15));

    writer.writeEndElement();
}

void DomSizeF::setElementWidth(double a)
{
    m_children |= Width;
    m_width = a;
}

void DomSizeF::setElementHeight(double a)
{
    m_children |= Height;
    m_height = a;
}

void DomSizeF::clearElementWidth()
{
    m_children &= ~Width;
}

void DomSizeF::clearElementHeight()
{
    m_children &= ~Height;
}

DomChar::~DomChar() = default;

void DomChar::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"unicode"_s, Qt::CaseInsensitive)) {
                setElementUnicode(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomChar::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("char") : tagName.toLower());

    if (m_children & Unicode)
        writer.writeTextElement(u"unicode"_s, QString::number(m_unicode));

    writer.writeEndElement();
}

void DomChar::setElementUnicode(int a)
{
    m_children |= Unicode;
    m_unicode = a;
}

void DomChar::clearElementUnicode()
{
    m_children &= ~Unicode;
}

DomUrl::~DomUrl()
{
    delete m_string;
}

void DomUrl::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"string"_s, Qt::CaseInsensitive)) {
                auto *v = new DomString();
                v->read(reader);
                setElementString(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomUrl::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("url") : tagName.toLower());

    if (m_children & String)
        m_string->write(writer, u"string"_s);

    writer.writeEndElement();
}

DomString *DomUrl::takeElementString()
{
    DomString *a = m_string;
    m_string = nullptr;
    m_children ^= String;
    return a;
}

void DomUrl::setElementString(DomString *a)
{
    delete m_string;
    m_children |= String;
    m_string = a;
}

void DomUrl::clearElementString()
{
    delete m_string;
    m_string = nullptr;
    m_children &= ~String;
}

DomProperty::~DomProperty()
{
    delete m_color;
    delete m_font;
    delete m_iconSet;
    delete m_pixmap;
    delete m_palette;
    delete m_point;
    delete m_rect;
    delete m_locale;
    delete m_sizePolicy;
    delete m_size;
    delete m_string;
    delete m_stringList;
    delete m_date;
    delete m_time;
    delete m_dateTime;
    delete m_pointF;
    delete m_rectF;
    delete m_sizeF;
    delete m_char;
    delete m_url;
    delete m_brush;
}

void DomProperty::clear()
{
    delete m_color;
    delete m_font;
    delete m_iconSet;
    delete m_pixmap;
    delete m_palette;
    delete m_point;
    delete m_rect;
    delete m_locale;
    delete m_sizePolicy;
    delete m_size;
    delete m_string;
    delete m_stringList;
    delete m_date;
    delete m_time;
    delete m_dateTime;
    delete m_pointF;
    delete m_rectF;
    delete m_sizeF;
    delete m_char;
    delete m_url;
    delete m_brush;

    m_kind = Unknown;

    m_color = nullptr;
    m_cursor = 0;
    m_font = nullptr;
    m_iconSet = nullptr;
    m_pixmap = nullptr;
    m_palette = nullptr;
    m_point = nullptr;
    m_rect = nullptr;
    m_locale = nullptr;
    m_sizePolicy = nullptr;
    m_size = nullptr;
    m_string = nullptr;
    m_stringList = nullptr;
    m_number = 0;
    m_float = 0.0;
    m_double = 0.0;
    m_date = nullptr;
    m_time = nullptr;
    m_dateTime = nullptr;
    m_pointF = nullptr;
    m_rectF = nullptr;
    m_sizeF = nullptr;
    m_longLong = 0;
    m_char = nullptr;
    m_url = nullptr;
    m_UInt = 0;
    m_uLongLong = 0;
    m_brush = nullptr;
}

void DomProperty::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        if (name == u"stdset"_s) {
            setAttributeStdset(attribute.value().toInt());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"bool"_s, Qt::CaseInsensitive)) {
                setElementBool(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"color"_s, Qt::CaseInsensitive)) {
                auto *v = new DomColor();
                v->read(reader);
                setElementColor(v);
                continue;
            }
            if (!tag.compare(u"cstring"_s, Qt::CaseInsensitive)) {
                setElementCstring(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"cursor"_s, Qt::CaseInsensitive)) {
                setElementCursor(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"cursorshape"_s, Qt::CaseInsensitive)) {
                setElementCursorShape(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"enum"_s, Qt::CaseInsensitive)) {
                setElementEnum(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"font"_s, Qt::CaseInsensitive)) {
                auto *v = new DomFont();
                v->read(reader);
                setElementFont(v);
                continue;
            }
            if (!tag.compare(u"iconset"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourceIcon();
                v->read(reader);
                setElementIconSet(v);
                continue;
            }
            if (!tag.compare(u"pixmap"_s, Qt::CaseInsensitive)) {
                auto *v = new DomResourcePixmap();
                v->read(reader);
                setElementPixmap(v);
                continue;
            }
            if (!tag.compare(u"palette"_s, Qt::CaseInsensitive)) {
                auto *v = new DomPalette();
                v->read(reader);
                setElementPalette(v);
                continue;
            }
            if (!tag.compare(u"point"_s, Qt::CaseInsensitive)) {
                auto *v = new DomPoint();
                v->read(reader);
                setElementPoint(v);
                continue;
            }
            if (!tag.compare(u"rect"_s, Qt::CaseInsensitive)) {
                auto *v = new DomRect();
                v->read(reader);
                setElementRect(v);
                continue;
            }
            if (!tag.compare(u"set"_s, Qt::CaseInsensitive)) {
                setElementSet(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"locale"_s, Qt::CaseInsensitive)) {
                auto *v = new DomLocale();
                v->read(reader);
                setElementLocale(v);
                continue;
            }
            if (!tag.compare(u"sizepolicy"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSizePolicy();
                v->read(reader);
                setElementSizePolicy(v);
                continue;
            }
            if (!tag.compare(u"size"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSize();
                v->read(reader);
                setElementSize(v);
                continue;
            }
            if (!tag.compare(u"string"_s, Qt::CaseInsensitive)) {
                auto *v = new DomString();
                v->read(reader);
                setElementString(v);
                continue;
            }
            if (!tag.compare(u"stringlist"_s, Qt::CaseInsensitive)) {
                auto *v = new DomStringList();
                v->read(reader);
                setElementStringList(v);
                continue;
            }
            if (!tag.compare(u"number"_s, Qt::CaseInsensitive)) {
                setElementNumber(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"float"_s, Qt::CaseInsensitive)) {
                setElementFloat(reader.readElementText().toFloat());
                continue;
            }
            if (!tag.compare(u"double"_s, Qt::CaseInsensitive)) {
                setElementDouble(reader.readElementText().toDouble());
                continue;
            }
            if (!tag.compare(u"date"_s, Qt::CaseInsensitive)) {
                auto *v = new DomDate();
                v->read(reader);
                setElementDate(v);
                continue;
            }
            if (!tag.compare(u"time"_s, Qt::CaseInsensitive)) {
                auto *v = new DomTime();
                v->read(reader);
                setElementTime(v);
                continue;
            }
            if (!tag.compare(u"datetime"_s, Qt::CaseInsensitive)) {
                auto *v = new DomDateTime();
                v->read(reader);
                setElementDateTime(v);
                continue;
            }
            if (!tag.compare(u"pointf"_s, Qt::CaseInsensitive)) {
                auto *v = new DomPointF();
                v->read(reader);
                setElementPointF(v);
                continue;
            }
            if (!tag.compare(u"rectf"_s, Qt::CaseInsensitive)) {
                auto *v = new DomRectF();
                v->read(reader);
                setElementRectF(v);
                continue;
            }
            if (!tag.compare(u"sizef"_s, Qt::CaseInsensitive)) {
                auto *v = new DomSizeF();
                v->read(reader);
                setElementSizeF(v);
                continue;
            }
            if (!tag.compare(u"longlong"_s, Qt::CaseInsensitive)) {
                setElementLongLong(reader.readElementText().toLongLong());
                continue;
            }
            if (!tag.compare(u"char"_s, Qt::CaseInsensitive)) {
                auto *v = new DomChar();
                v->read(reader);
                setElementChar(v);
                continue;
            }
            if (!tag.compare(u"url"_s, Qt::CaseInsensitive)) {
                auto *v = new DomUrl();
                v->read(reader);
                setElementUrl(v);
                continue;
            }
            if (!tag.compare(u"uint"_s, Qt::CaseInsensitive)) {
                setElementUInt(reader.readElementText().toUInt());
                continue;
            }
            if (!tag.compare(u"ulonglong"_s, Qt::CaseInsensitive)) {
                setElementULongLong(reader.readElementText().toULongLong());
                continue;
            }
            if (!tag.compare(u"brush"_s, Qt::CaseInsensitive)) {
                auto *v = new DomBrush();
                v->read(reader);
                setElementBrush(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomProperty::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("property") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    if (hasAttributeStdset())
        writer.writeAttribute(u"stdset"_s, QString::number(attributeStdset()));

    switch (kind()) {
    case Bool:
        writer.writeTextElement(u"bool"_s, elementBool());
        break;

    case Color:
        if (m_color != nullptr)
            m_color->write(writer, u"color"_s);
        break;

    case Cstring:
        writer.writeTextElement(u"cstring"_s, elementCstring());
        break;

    case Cursor:
        writer.writeTextElement(u"cursor"_s, QString::number(elementCursor()));
        break;

    case CursorShape:
        writer.writeTextElement(u"cursorShape"_s, elementCursorShape());
        break;

    case Enum:
        writer.writeTextElement(u"enum"_s, elementEnum());
        break;

    case Font:
        if (m_font != nullptr)
            m_font->write(writer, u"font"_s);
        break;

    case IconSet:
        if (m_iconSet != nullptr)
            m_iconSet->write(writer, u"iconset"_s);
        break;

    case Pixmap:
        if (m_pixmap != nullptr)
            m_pixmap->write(writer, u"pixmap"_s);
        break;

    case Palette:
        if (m_palette != nullptr)
            m_palette->write(writer, u"palette"_s);
        break;

    case Point:
        if (m_point != nullptr)
            m_point->write(writer, u"point"_s);
        break;

    case Rect:
        if (m_rect != nullptr)
            m_rect->write(writer, u"rect"_s);
        break;

    case Set:
        writer.writeTextElement(u"set"_s, elementSet());
        break;

    case Locale:
        if (m_locale != nullptr)
            m_locale->write(writer, u"locale"_s);
        break;

    case SizePolicy:
        if (m_sizePolicy != nullptr)
            m_sizePolicy->write(writer, u"sizepolicy"_s);
        break;

    case Size:
        if (m_size != nullptr)
            m_size->write(writer, u"size"_s);
        break;

    case String:
        if (m_string != nullptr)
            m_string->write(writer, u"string"_s);
        break;

    case StringList:
        if (m_stringList != nullptr)
            m_stringList->write(writer, u"stringlist"_s);
        break;

    case Number:
        writer.writeTextElement(u"number"_s, QString::number(elementNumber()));
        break;

    case Float:
        writer.writeTextElement(u"float"_s, QString::number(elementFloat(), 'f', 8));
        break;

    case Double:
        writer.writeTextElement(u"double"_s, QString::number(elementDouble(), 'f', 15));
        break;

    case Date:
        if (m_date != nullptr)
            m_date->write(writer, u"date"_s);
        break;

    case Time:
        if (m_time != nullptr)
            m_time->write(writer, u"time"_s);
        break;

    case DateTime:
        if (m_dateTime != nullptr)
            m_dateTime->write(writer, u"datetime"_s);
        break;

    case PointF:
        if (m_pointF != nullptr)
            m_pointF->write(writer, u"pointf"_s);
        break;

    case RectF:
        if (m_rectF != nullptr)
            m_rectF->write(writer, u"rectf"_s);
        break;

    case SizeF:
        if (m_sizeF != nullptr)
            m_sizeF->write(writer, u"sizef"_s);
        break;

    case LongLong:
        writer.writeTextElement(u"longLong"_s, QString::number(elementLongLong()));
        break;

    case Char:
        if (m_char != nullptr)
            m_char->write(writer, u"char"_s);
        break;

    case Url:
        if (m_url != nullptr)
            m_url->write(writer, u"url"_s);
        break;

    case UInt:
        writer.writeTextElement(u"UInt"_s, QString::number(elementUInt()));
        break;

    case ULongLong:
        writer.writeTextElement(u"uLongLong"_s, QString::number(elementULongLong()));
        break;

    case Brush:
        if (m_brush != nullptr)
            m_brush->write(writer, u"brush"_s);
        break;

    default:
        break;
    }
    writer.writeEndElement();
}

void DomProperty::setElementBool(const QString &a)
{
    clear();
    m_kind = Bool;
    m_bool = a;
}

DomColor *DomProperty::takeElementColor()
{
    DomColor *a = m_color;
    m_color = nullptr;
    return a;
}

void DomProperty::setElementColor(DomColor *a)
{
    clear();
    m_kind = Color;
    m_color = a;
}

void DomProperty::setElementCstring(const QString &a)
{
    clear();
    m_kind = Cstring;
    m_cstring = a;
}

void DomProperty::setElementCursor(int a)
{
    clear();
    m_kind = Cursor;
    m_cursor = a;
}

void DomProperty::setElementCursorShape(const QString &a)
{
    clear();
    m_kind = CursorShape;
    m_cursorShape = a;
}

void DomProperty::setElementEnum(const QString &a)
{
    clear();
    m_kind = Enum;
    m_enum = a;
}

DomFont *DomProperty::takeElementFont()
{
    DomFont *a = m_font;
    m_font = nullptr;
    return a;
}

void DomProperty::setElementFont(DomFont *a)
{
    clear();
    m_kind = Font;
    m_font = a;
}

DomResourceIcon *DomProperty::takeElementIconSet()
{
    DomResourceIcon *a = m_iconSet;
    m_iconSet = nullptr;
    return a;
}

void DomProperty::setElementIconSet(DomResourceIcon *a)
{
    clear();
    m_kind = IconSet;
    m_iconSet = a;
}

DomResourcePixmap *DomProperty::takeElementPixmap()
{
    DomResourcePixmap *a = m_pixmap;
    m_pixmap = nullptr;
    return a;
}

void DomProperty::setElementPixmap(DomResourcePixmap *a)
{
    clear();
    m_kind = Pixmap;
    m_pixmap = a;
}

DomPalette *DomProperty::takeElementPalette()
{
    DomPalette *a = m_palette;
    m_palette = nullptr;
    return a;
}

void DomProperty::setElementPalette(DomPalette *a)
{
    clear();
    m_kind = Palette;
    m_palette = a;
}

DomPoint *DomProperty::takeElementPoint()
{
    DomPoint *a = m_point;
    m_point = nullptr;
    return a;
}

void DomProperty::setElementPoint(DomPoint *a)
{
    clear();
    m_kind = Point;
    m_point = a;
}

DomRect *DomProperty::takeElementRect()
{
    DomRect *a = m_rect;
    m_rect = nullptr;
    return a;
}

void DomProperty::setElementRect(DomRect *a)
{
    clear();
    m_kind = Rect;
    m_rect = a;
}

void DomProperty::setElementSet(const QString &a)
{
    clear();
    m_kind = Set;
    m_set = a;
}

DomLocale *DomProperty::takeElementLocale()
{
    DomLocale *a = m_locale;
    m_locale = nullptr;
    return a;
}

void DomProperty::setElementLocale(DomLocale *a)
{
    clear();
    m_kind = Locale;
    m_locale = a;
}

DomSizePolicy *DomProperty::takeElementSizePolicy()
{
    DomSizePolicy *a = m_sizePolicy;
    m_sizePolicy = nullptr;
    return a;
}

void DomProperty::setElementSizePolicy(DomSizePolicy *a)
{
    clear();
    m_kind = SizePolicy;
    m_sizePolicy = a;
}

DomSize *DomProperty::takeElementSize()
{
    DomSize *a = m_size;
    m_size = nullptr;
    return a;
}

void DomProperty::setElementSize(DomSize *a)
{
    clear();
    m_kind = Size;
    m_size = a;
}

DomString *DomProperty::takeElementString()
{
    DomString *a = m_string;
    m_string = nullptr;
    return a;
}

void DomProperty::setElementString(DomString *a)
{
    clear();
    m_kind = String;
    m_string = a;
}

DomStringList *DomProperty::takeElementStringList()
{
    DomStringList *a = m_stringList;
    m_stringList = nullptr;
    return a;
}

void DomProperty::setElementStringList(DomStringList *a)
{
    clear();
    m_kind = StringList;
    m_stringList = a;
}

void DomProperty::setElementNumber(int a)
{
    clear();
    m_kind = Number;
    m_number = a;
}

void DomProperty::setElementFloat(float a)
{
    clear();
    m_kind = Float;
    m_float = a;
}

void DomProperty::setElementDouble(double a)
{
    clear();
    m_kind = Double;
    m_double = a;
}

DomDate *DomProperty::takeElementDate()
{
    DomDate *a = m_date;
    m_date = nullptr;
    return a;
}

void DomProperty::setElementDate(DomDate *a)
{
    clear();
    m_kind = Date;
    m_date = a;
}

DomTime *DomProperty::takeElementTime()
{
    DomTime *a = m_time;
    m_time = nullptr;
    return a;
}

void DomProperty::setElementTime(DomTime *a)
{
    clear();
    m_kind = Time;
    m_time = a;
}

DomDateTime *DomProperty::takeElementDateTime()
{
    DomDateTime *a = m_dateTime;
    m_dateTime = nullptr;
    return a;
}

void DomProperty::setElementDateTime(DomDateTime *a)
{
    clear();
    m_kind = DateTime;
    m_dateTime = a;
}

DomPointF *DomProperty::takeElementPointF()
{
    DomPointF *a = m_pointF;
    m_pointF = nullptr;
    return a;
}

void DomProperty::setElementPointF(DomPointF *a)
{
    clear();
    m_kind = PointF;
    m_pointF = a;
}

DomRectF *DomProperty::takeElementRectF()
{
    DomRectF *a = m_rectF;
    m_rectF = nullptr;
    return a;
}

void DomProperty::setElementRectF(DomRectF *a)
{
    clear();
    m_kind = RectF;
    m_rectF = a;
}

DomSizeF *DomProperty::takeElementSizeF()
{
    DomSizeF *a = m_sizeF;
    m_sizeF = nullptr;
    return a;
}

void DomProperty::setElementSizeF(DomSizeF *a)
{
    clear();
    m_kind = SizeF;
    m_sizeF = a;
}

void DomProperty::setElementLongLong(qlonglong a)
{
    clear();
    m_kind = LongLong;
    m_longLong = a;
}

DomChar *DomProperty::takeElementChar()
{
    DomChar *a = m_char;
    m_char = nullptr;
    return a;
}

void DomProperty::setElementChar(DomChar *a)
{
    clear();
    m_kind = Char;
    m_char = a;
}

DomUrl *DomProperty::takeElementUrl()
{
    DomUrl *a = m_url;
    m_url = nullptr;
    return a;
}

void DomProperty::setElementUrl(DomUrl *a)
{
    clear();
    m_kind = Url;
    m_url = a;
}

void DomProperty::setElementUInt(uint a)
{
    clear();
    m_kind = UInt;
    m_UInt = a;
}

void DomProperty::setElementULongLong(qulonglong a)
{
    clear();
    m_kind = ULongLong;
    m_uLongLong = a;
}

DomBrush *DomProperty::takeElementBrush()
{
    DomBrush *a = m_brush;
    m_brush = nullptr;
    return a;
}

void DomProperty::setElementBrush(DomBrush *a)
{
    clear();
    m_kind = Brush;
    m_brush = a;
}

DomConnections::~DomConnections()
{
    qDeleteAll(m_connection);
    m_connection.clear();
}

void DomConnections::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"connection"_s, Qt::CaseInsensitive)) {
                auto *v = new DomConnection();
                v->read(reader);
                m_connection.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomConnections::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("connections") : tagName.toLower());

    for (DomConnection *v : m_connection)
        v->write(writer, u"connection"_s);

    writer.writeEndElement();
}

void DomConnections::setElementConnection(const QList<DomConnection *> &a)
{
    m_children |= Connection;
    m_connection = a;
}

DomConnection::~DomConnection()
{
    delete m_hints;
}

void DomConnection::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"sender"_s, Qt::CaseInsensitive)) {
                setElementSender(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"signal"_s, Qt::CaseInsensitive)) {
                setElementSignal(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"receiver"_s, Qt::CaseInsensitive)) {
                setElementReceiver(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"slot"_s, Qt::CaseInsensitive)) {
                setElementSlot(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"hints"_s, Qt::CaseInsensitive)) {
                auto *v = new DomConnectionHints();
                v->read(reader);
                setElementHints(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomConnection::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("connection") : tagName.toLower());

    if (m_children & Sender)
        writer.writeTextElement(u"sender"_s, m_sender);

    if (m_children & Signal)
        writer.writeTextElement(u"signal"_s, m_signal);

    if (m_children & Receiver)
        writer.writeTextElement(u"receiver"_s, m_receiver);

    if (m_children & Slot)
        writer.writeTextElement(u"slot"_s, m_slot);

    if (m_children & Hints)
        m_hints->write(writer, u"hints"_s);

    writer.writeEndElement();
}

void DomConnection::setElementSender(const QString &a)
{
    m_children |= Sender;
    m_sender = a;
}

void DomConnection::setElementSignal(const QString &a)
{
    m_children |= Signal;
    m_signal = a;
}

void DomConnection::setElementReceiver(const QString &a)
{
    m_children |= Receiver;
    m_receiver = a;
}

void DomConnection::setElementSlot(const QString &a)
{
    m_children |= Slot;
    m_slot = a;
}

DomConnectionHints *DomConnection::takeElementHints()
{
    DomConnectionHints *a = m_hints;
    m_hints = nullptr;
    m_children ^= Hints;
    return a;
}

void DomConnection::setElementHints(DomConnectionHints *a)
{
    delete m_hints;
    m_children |= Hints;
    m_hints = a;
}

void DomConnection::clearElementSender()
{
    m_children &= ~Sender;
}

void DomConnection::clearElementSignal()
{
    m_children &= ~Signal;
}

void DomConnection::clearElementReceiver()
{
    m_children &= ~Receiver;
}

void DomConnection::clearElementSlot()
{
    m_children &= ~Slot;
}

void DomConnection::clearElementHints()
{
    delete m_hints;
    m_hints = nullptr;
    m_children &= ~Hints;
}

DomConnectionHints::~DomConnectionHints()
{
    qDeleteAll(m_hint);
    m_hint.clear();
}

void DomConnectionHints::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"hint"_s, Qt::CaseInsensitive)) {
                auto *v = new DomConnectionHint();
                v->read(reader);
                m_hint.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomConnectionHints::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("connectionhints") : tagName.toLower());

    for (DomConnectionHint *v : m_hint)
        v->write(writer, u"hint"_s);

    writer.writeEndElement();
}

void DomConnectionHints::setElementHint(const QList<DomConnectionHint *> &a)
{
    m_children |= Hint;
    m_hint = a;
}

DomConnectionHint::~DomConnectionHint() = default;

void DomConnectionHint::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"type"_s) {
            setAttributeType(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"x"_s, Qt::CaseInsensitive)) {
                setElementX(reader.readElementText().toInt());
                continue;
            }
            if (!tag.compare(u"y"_s, Qt::CaseInsensitive)) {
                setElementY(reader.readElementText().toInt());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomConnectionHint::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("connectionhint") : tagName.toLower());

    if (hasAttributeType())
        writer.writeAttribute(u"type"_s, attributeType());

    if (m_children & X)
        writer.writeTextElement(u"x"_s, QString::number(m_x));

    if (m_children & Y)
        writer.writeTextElement(u"y"_s, QString::number(m_y));

    writer.writeEndElement();
}

void DomConnectionHint::setElementX(int a)
{
    m_children |= X;
    m_x = a;
}

void DomConnectionHint::setElementY(int a)
{
    m_children |= Y;
    m_y = a;
}

void DomConnectionHint::clearElementX()
{
    m_children &= ~X;
}

void DomConnectionHint::clearElementY()
{
    m_children &= ~Y;
}

DomDesignerData::~DomDesignerData()
{
    qDeleteAll(m_property);
    m_property.clear();
}

void DomDesignerData::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"property"_s, Qt::CaseInsensitive)) {
                auto *v = new DomProperty();
                v->read(reader);
                m_property.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomDesignerData::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("designerdata") : tagName.toLower());

    for (DomProperty *v : m_property)
        v->write(writer, u"property"_s);

    writer.writeEndElement();
}

void DomDesignerData::setElementProperty(const QList<DomProperty *> &a)
{
    m_children |= Property;
    m_property = a;
}

DomSlots::~DomSlots()
{
    m_signal.clear();
    m_slot.clear();
}

void DomSlots::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"signal"_s, Qt::CaseInsensitive)) {
                m_signal.append(reader.readElementText());
                continue;
            }
            if (!tag.compare(u"slot"_s, Qt::CaseInsensitive)) {
                m_slot.append(reader.readElementText());
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomSlots::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("slots") : tagName.toLower());

    for (const QString &v : m_signal)
        writer.writeTextElement(u"signal"_s, v);

    for (const QString &v : m_slot)
        writer.writeTextElement(u"slot"_s, v);

    writer.writeEndElement();
}

void DomSlots::setElementSignal(const QStringList &a)
{
    m_children |= Signal;
    m_signal = a;
}

void DomSlots::setElementSlot(const QStringList &a)
{
    m_children |= Slot;
    m_slot = a;
}

DomPropertySpecifications::~DomPropertySpecifications()
{
    qDeleteAll(m_tooltip);
    m_tooltip.clear();
    qDeleteAll(m_stringpropertyspecification);
    m_stringpropertyspecification.clear();
}

void DomPropertySpecifications::read(QXmlStreamReader &reader)
{
    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            if (!tag.compare(u"tooltip"_s, Qt::CaseInsensitive)) {
                auto *v = new DomPropertyToolTip();
                v->read(reader);
                m_tooltip.append(v);
                continue;
            }
            if (!tag.compare(u"stringpropertyspecification"_s, Qt::CaseInsensitive)) {
                auto *v = new DomStringPropertySpecification();
                v->read(reader);
                m_stringpropertyspecification.append(v);
                continue;
            }
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomPropertySpecifications::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("propertyspecifications") : tagName.toLower());

    for (DomPropertyToolTip *v : m_tooltip)
        v->write(writer, u"tooltip"_s);

    for (DomStringPropertySpecification *v : m_stringpropertyspecification)
        v->write(writer, u"stringpropertyspecification"_s);

    writer.writeEndElement();
}

void DomPropertySpecifications::setElementTooltip(const QList<DomPropertyToolTip *> &a)
{
    m_children |= Tooltip;
    m_tooltip = a;
}

void DomPropertySpecifications::setElementStringpropertyspecification(const QList<DomStringPropertySpecification *> &a)
{
    m_children |= Stringpropertyspecification;
    m_stringpropertyspecification = a;
}

DomPropertyToolTip::~DomPropertyToolTip() = default;

void DomPropertyToolTip::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomPropertyToolTip::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("propertytooltip") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    writer.writeEndElement();
}

DomStringPropertySpecification::~DomStringPropertySpecification() = default;

void DomStringPropertySpecification::read(QXmlStreamReader &reader)
{
    const QXmlStreamAttributes &attributes = reader.attributes();
    for (const QXmlStreamAttribute &attribute : attributes) {
        const auto name = attribute.name();
        if (name == u"name"_s) {
            setAttributeName(attribute.value().toString());
            continue;
        }
        if (name == u"type"_s) {
            setAttributeType(attribute.value().toString());
            continue;
        }
        if (name == u"notr"_s) {
            setAttributeNotr(attribute.value().toString());
            continue;
        }
        reader.raiseError("Unexpected attribute "_L1 + name);
    }

    while (!reader.hasError()) {
        switch (reader.readNext()) {
        case QXmlStreamReader::StartElement : {
            const auto tag = reader.name();
            reader.raiseError("Unexpected element "_L1 + tag);
        }
            break;
        case QXmlStreamReader::EndElement :
            return;
        default :
            break;
        }
    }
}

void DomStringPropertySpecification::write(QXmlStreamWriter &writer, const QString &tagName) const
{
    writer.writeStartElement(tagName.isEmpty() ? QStringLiteral("stringpropertyspecification") : tagName.toLower());

    if (hasAttributeName())
        writer.writeAttribute(u"name"_s, attributeName());

    if (hasAttributeType())
        writer.writeAttribute(u"type"_s, attributeType());

    if (hasAttributeNotr())
        writer.writeAttribute(u"notr"_s, attributeNotr());

    writer.writeEndElement();
}

QT_END_NAMESPACE

