/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Wasm is 'TP' before Qt 6.4.0 (in Qt6 series)
    if (typeof(692) == 'number' && 692 < 640) {
        var dynamicDisplayName = component.value("DisplayName");
        var dynamicDescription = component.value("Description") + "&lt;br&gt;&lt;br&gt;The release of " + dynamicDisplayName + " with Qt 6.9 is a Technology Preview.";
        dynamicDisplayName = dynamicDisplayName + " (TP)";
        component.setValue("DisplayName", dynamicDisplayName);
        component.setValue("Description", dynamicDescription);
    }

    // Wasm requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";

    // Linux desktop component naming was changed in Qt 6.7.0 from gcc_64 to linux_gcc_64
    if (installer.componentByName("qt.qt6.692.gcc_64")) {
        hostDependencyStr = "qt.qt6.692.gcc_64"
    }
    else if (installer.componentByName("qt.qt6.692.linux_gcc_64")) {
        hostDependencyStr = "qt.qt6.692.linux_gcc_64"
    }
    // Linux on ARM supported from Qt 6.7 onward
    else if (installer.componentByName("qt.qt6.692.linux_gcc_arm64")) {
        hostDependencyStr = "qt.qt6.692.linux_gcc_arm64"
    }
    // Windows on ARM is supported from 6.7 onwards
    else if (installer.componentByName("qt.qt6.692.win64_msvc2022_arm64")) {
        hostDependencyStr = "qt.qt6.692.win64_msvc2022_arm64"
    }
    else if (installer.componentByName("qt.qt6.692.win64_mingw")) {
        hostDependencyStr = "qt.qt6.692.win64_mingw"
    }
    else if (installer.componentByName("qt.qt6.692.clang_64")) {
        hostDependencyStr = "qt.qt6.692.clang_64"
    }
    else {
        console.log("Warning: no host dependencies added");
    }
    component.addDependency(hostDependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    qtExecuteGenericPatching_692("Linux-openSUSE_15_6-GCC-Linux-WebAssembly-X86_64", "multithread", "/6.9.2/wasm_multithread", component.value("Name"));

    qtExecuteWasmThreadingPatching_692(component.value("Name"), "multi-threaded", "/6.9.2/wasm_multithread");
}

