/****************************************************************************
**
** Copyright (C) 2015 Klaralvdalens Datakonsult AB (KDAB).
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of Qt 3D Studio.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QT3DRENDER_DRAGON_RENDERTARGETOUTPUT_H
#define QT3DRENDER_DRAGON_RENDERTARGETOUTPUT_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/dragonbackendnode_p.h>
#include <private/dragonimmutable_p.h>

#include <Qt3DRender/qrendertargetoutput.h>

// TODO only for Attachment, should be in separate file

QT_BEGIN_NAMESPACE

namespace Qt3DRender {

class QRenderTargetOutput;

namespace Dragon {

class RenderTargetOutput : public BackendNode
{
public:
    RenderTargetOutput();

    void sceneChangeEvent(const Qt3DCore::QSceneChangePtr &e) override;
    void initializeFromPeer(const Qt3DCore::QNodeCreatedChangeBasePtr &change) final;

    QString name;
    int mipLevel;
    int layer;
    Qt3DCore::QNodeId textureUuid;
    QRenderTargetOutput::AttachmentPoint point;
    QAbstractTexture::CubeMapFace face;
};

struct RenderTargetOutputData
{
    Qt3DCore::QNodeId textureId;
    QRenderTargetOutput::AttachmentPoint attachmentPoint;
    int mipLevel;
    int layer;
    QAbstractTexture::CubeMapFace face;
};

struct AttachmentPack
{
    QVector<Immutable<RenderTargetOutput>> outputs;
    QVector<int> drawBuffers;
};

//AttachmentPack attachmentPackFromTarget(const Value<RenderTarget> &target, const ValueContainer<RenderTarget> &renderTargets)
//{
//    AttachmentPack result;
//    // Copy attachments
//    const auto outputIds = target->renderOutputs();
//    for (Qt3DCore::QNodeId outputId : outputIds) {
//        const RenderTargetOutput *output = attachmentManager->lookupResource(outputId);
//        if (output)
//            result.outputs.append(*output->attachment());
//    }

//    // Create actual DrawBuffers list that is used for glDrawBuffers

//    // If nothing is specified, use all the attachments as draw buffers
//    if (drawBuffers.isEmpty()) {
//        m_drawBuffers.reserve(m_attachments.size());
//        for (const Attachment &attachment : qAsConst(m_attachments))
//            // only consider Color Attachments
//            if (attachment.m_point <= QRenderTargetOutput::Color15)
//                m_drawBuffers.push_back((int) attachment.m_point);
//    } else {
//        m_drawBuffers.reserve(drawBuffers.size());
//        for (QRenderTargetOutput::AttachmentPoint drawBuffer : drawBuffers)
//            if (drawBuffer <= QRenderTargetOutput::Color15)
//                m_drawBuffers.push_back((int) drawBuffer);
//    }
//}

} // namespace Dragon

} // namespace Qt3DRender

QT_END_NAMESPACE

#endif // QT3DRENDER_DRAGON_RENDERTARGETOUTPUT_H
