/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer mBuffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.mBuffer.hasRemaining()) {
            return -1;
        }
        return this.mBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > bytes.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int length = Math.min(this.mBuffer.remaining(), len);
        if (length == 0) {
            return -1;
        }
        this.mBuffer.get(bytes, off, length);
        return length;
    }
}

