/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;

public class MemberClassAccessFilter
implements MemberVisitor {
    private final Clazz referencingClass;
    private final MemberVisitor memberVisitor;

    public MemberClassAccessFilter(Clazz clazz, MemberVisitor memberVisitor) {
        this.referencingClass = clazz;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programClass, programField.getAccessFlags())) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programClass, programMethod.getAccessFlags())) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryClass, libraryField.getAccessFlags())) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryClass, libraryMethod.getAccessFlags())) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(Clazz clazz, int n) {
        int n2 = AccessUtil.accessLevel(n);
        return n2 >= 3 || n2 >= 0 && this.referencingClass.equals(clazz) || n2 >= 1 && ClassUtil.internalPackageName(this.referencingClass.getName()).equals(ClassUtil.internalPackageName(clazz.getName())) || n2 >= 2 && (this.referencingClass.extends_(clazz) || this.referencingClass.extendsOrImplements(clazz));
    }
}

