/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.AutoValue_Es6RewriteClass_ClassDeclarationMetadata;
import com.google.javascript.jscomp.AutoValue_Es6RewriteClass_ClassProperty;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Es6RewriteClass
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES, FeatureSet.Feature.CLASS_EXTENDS, FeatureSet.Feature.CLASS_GETTER_SETTER, FeatureSet.Feature.NEW_TARGET);
    static final DiagnosticType DYNAMIC_EXTENDS_TYPE = DiagnosticType.error("JSC_DYNAMIC_EXTENDS_TYPE", "The class in an extends clause must be a qualified name.");
    static final DiagnosticType CLASS_REASSIGNMENT = DiagnosticType.error("CLASS_REASSIGNMENT", "Class names defined inside a function cannot be reassigned.");
    static final DiagnosticType CONFLICTING_GETTER_SETTER_TYPE = DiagnosticType.error("CONFLICTING_GETTER_SETTER_TYPE", "The types of the getter and setter for property ''{0}'' do not match.");
    static final String INHERITS = "$jscomp.inherits";
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final AstFactory astFactory;
    private final JSType objectPropertyDescriptorType;

    public Es6RewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.astFactory = compiler.createAstFactory();
        JSType actualObjectPropertyDescriptorType = this.registry.getGlobalType("ObjectPropertyDescriptor");
        this.objectPropertyDescriptorType = actualObjectPropertyDescriptorType != null ? actualObjectPropertyDescriptorType : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this);
        TranspilationPasses.processTranspile(this.compiler, root, features, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, features);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, features, this);
        if (!this.compiler.hasHaltingErrors()) {
            TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, features);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case NEW_TARGET: {
                Es6ToEs3Util.cannotConvertYet(this.compiler, n, "new.target");
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CLASS: {
                this.visitClass(t, n, parent);
                break;
            }
        }
    }

    private void checkClassReassignment(Node clazz) {
        Node name = NodeUtil.getNameNode(clazz);
        Node enclosingFunction = NodeUtil.getEnclosingFunction(clazz);
        if (enclosingFunction == null) {
            return;
        }
        CheckClassAssignments checkAssigns = new CheckClassAssignments(name);
        NodeTraversal.traverse(this.compiler, enclosingFunction, checkAssigns);
    }

    private void visitClass(NodeTraversal t, Node classNode, Node parent) {
        Node var;
        Node definePropsCall;
        this.checkClassReassignment(classNode);
        ClassDeclarationMetadata metadata = ClassDeclarationMetadata.create(classNode, parent, this.astFactory);
        if (metadata == null) {
            throw new IllegalStateException("Can only convert classes that are declarations or the right hand side of a simple assignment: " + classNode);
        }
        if (metadata.hasSuperClass() && !metadata.getSuperClassNameNode().isQualifiedName()) {
            this.compiler.report(JSError.make(metadata.getSuperClassNameNode(), DYNAMIC_EXTENDS_TYPE, new String[0]));
            return;
        }
        Preconditions.checkState(NodeUtil.isStatement(metadata.getInsertionPoint().getNode()), "insertion point must be a statement: %s", (Object)metadata.getInsertionPoint().getNode());
        Node constructor = null;
        JSDocInfo ctorJSDocInfo = null;
        Node classMembers = classNode.getLastChild();
        for (Node member : classMembers.children()) {
            if (member.isComputedProp() && (member.getBooleanProp(Node.COMPUTED_PROP_GETTER) || member.getBooleanProp(Node.COMPUTED_PROP_SETTER)) || member.isGetterDef() || member.isSetterDef()) {
                this.visitNonMethodMember(member, metadata);
                continue;
            }
            if (NodeUtil.isEs6ConstructorMemberFunctionDef(member)) {
                ctorJSDocInfo = member.getJSDocInfo();
                constructor = member.getFirstChild().detach().setJSType(classNode.getJSType());
                constructor.setJSTypeBeforeCast(classNode.getJSTypeBeforeCast());
                if (metadata.isAnonymous()) continue;
                constructor.replaceChild(constructor.getFirstChild(), metadata.getClassNameNode().cloneNode());
                continue;
            }
            if (member.isEmpty()) continue;
            Preconditions.checkState(member.isMemberFunctionDef() || member.isComputedProp(), "Unexpected class member:", (Object)member);
            Preconditions.checkState(!member.getBooleanProp(Node.COMPUTED_PROP_VARIABLE), "Member variables should have been transpiled earlier:", (Object)member);
            this.visitMethod(member, metadata);
        }
        Preconditions.checkNotNull(constructor, "Es6RewriteClasses expects all classes to have (possibly synthetic) constructors");
        if (metadata.getDefinePropertiesObjForPrototype().hasChildren()) {
            definePropsCall = IR.exprResult(this.astFactory.createCall(this.createObjectDotDefineProperties(t.getScope()), metadata.getClassPrototypeNode().cloneTree(), metadata.getDefinePropertiesObjForPrototype()));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        if (metadata.getDefinePropertiesObjForClass().hasChildren()) {
            definePropsCall = IR.exprResult(this.astFactory.createCall(this.createObjectDotDefineProperties(t.getScope()), metadata.getFullClassNameNode().cloneTree(), metadata.getDefinePropertiesObjForClass()));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        JSDocInfo classJSDoc = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfoBuilder newInfo = JSDocInfoBuilder.maybeCopyFrom(classJSDoc);
        newInfo.recordConstructor();
        Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
        if (metadata.hasSuperClass()) {
            String superClassString = metadata.getSuperClassNameNode().getQualifiedName();
            if (newInfo.isInterfaceRecorded()) {
                newInfo.recordExtendedInterface(new JSTypeExpression(new Node(Token.BANG, IR.string(superClassString)).srcrefTree(metadata.getSuperClassNameNode()), metadata.getSuperClassNameNode().getSourceFileName()));
            } else {
                newInfo.recordBaseType(new JSTypeExpression(new Node(Token.BANG, IR.string(superClassString)).srcrefTree(metadata.getSuperClassNameNode()), metadata.getSuperClassNameNode().getSourceFileName()));
            }
            if (!classNode.isFromExterns()) {
                Node inheritsCall = IR.exprResult(this.astFactory.createCall(this.astFactory.createQName(t.getScope(), INHERITS), metadata.getFullClassNameNode().cloneTree(), metadata.getSuperClassNameNode().cloneTree())).useSourceInfoIfMissingFromForTree(metadata.getSuperClassNameNode());
                enclosingStatement.getParent().addChildAfter(inheritsCall, enclosingStatement);
            }
        }
        this.addTypeDeclarations(t.getScope(), metadata, enclosingStatement);
        this.updateClassJsDoc(ctorJSDocInfo, newInfo);
        if (NodeUtil.isStatement(classNode)) {
            constructor.getFirstChild().setString("");
            Node ctorVar = IR.let(metadata.getClassNameNode().cloneNode(), constructor);
            ctorVar.useSourceInfoIfMissingFromForTree(classNode);
            parent.replaceChild(classNode, ctorVar);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS);
        } else {
            parent.replaceChild(classNode, constructor);
        }
        NodeUtil.markFunctionsDeleted(classNode, this.compiler);
        if (NodeUtil.isStatement(constructor)) {
            constructor.setJSDocInfo(newInfo.build());
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(newInfo.build());
        } else if (constructor.getParent().isName()) {
            var = constructor.getGrandparent();
            var.setJSDocInfo(newInfo.build());
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(newInfo.build());
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        FunctionType classType = JSType.toMaybeFunctionType(classNode.getJSType());
        if (classType != null) {
            classType.setSource(constructor);
        }
        t.reportCodeChange();
    }

    private Node createObjectDotDefineProperties(Scope scope) {
        return this.astFactory.createQName(scope, "$jscomp.global.Object.defineProperties");
    }

    private void updateClassJsDoc(@Nullable JSDocInfo ctorInfo, JSDocInfoBuilder newInfo) {
        if (!(newInfo.isUnrestrictedRecorded() || newInfo.isDictRecorded() || newInfo.isStructRecorded())) {
            newInfo.recordStruct();
        }
        if (ctorInfo != null) {
            if (!ctorInfo.getSuppressions().isEmpty()) {
                newInfo.recordSuppressions(ctorInfo.getSuppressions());
            }
            for (String param : ctorInfo.getParameterNames()) {
                newInfo.recordParameter(param, ctorInfo.getParameterType(param));
                newInfo.recordParameterDescription(param, ctorInfo.getDescriptionForParameter(param));
            }
            for (JSTypeExpression thrown : ctorInfo.getThrownTypes()) {
                newInfo.recordThrowType(thrown);
                newInfo.recordThrowDescription(thrown, ctorInfo.getThrowsDescriptionForType(thrown));
            }
            JSDocInfo.Visibility visibility = ctorInfo.getVisibility();
            if (visibility != null && visibility != JSDocInfo.Visibility.INHERITED) {
                newInfo.recordVisibility(visibility);
            }
            if (ctorInfo.isDeprecated()) {
                newInfo.recordDeprecated();
            }
            if (ctorInfo.getDeprecationReason() != null && !newInfo.isDeprecationReasonRecorded()) {
                newInfo.recordDeprecationReason(ctorInfo.getDeprecationReason());
            }
            newInfo.mergePropertyBitfieldFrom(ctorInfo);
            for (Map.Entry entry : ctorInfo.getTemplateTypes().entrySet()) {
                newInfo.recordTemplateTypeName((String)entry.getKey(), (JSTypeExpression)entry.getValue());
            }
        }
    }

    @Nullable
    private JSTypeExpression getTypeFromGetterOrSetter(Node node) {
        JSDocInfo info = node.getJSDocInfo();
        if (info != null) {
            JSTypeExpression paramType;
            boolean getter;
            boolean bl = getter = node.isGetterDef() || node.getBooleanProp(Node.COMPUTED_PROP_GETTER);
            if (getter && info.getReturnType() != null) {
                return info.getReturnType();
            }
            Set<String> paramNames = info.getParameterNames();
            if (paramNames.size() == 1 && (paramType = info.getParameterType(Iterables.getOnlyElement(info.getParameterNames()))) != null) {
                return paramType;
            }
        }
        return null;
    }

    private void addToDefinePropertiesObject(ClassDeclarationMetadata metadata, Node member) {
        Node prop;
        Node obj = member.isStaticMember() ? metadata.getDefinePropertiesObjForClass() : metadata.getDefinePropertiesObjForPrototype();
        Node node = prop = member.isComputedProp() ? NodeUtil.getFirstComputedPropMatchingKey(obj, member.getFirstChild()) : NodeUtil.getFirstPropMatchingKey(obj, member.getString());
        if (prop == null) {
            prop = this.createPropertyDescriptor();
            if (member.isComputedProp()) {
                obj.addChildToBack(this.astFactory.createComputedProperty(member.getFirstChild().cloneTree(), prop));
            } else {
                Node stringKey = this.astFactory.createStringKey(member.getString(), prop);
                if (member.isQuotedString()) {
                    stringKey.putBooleanProp(Node.QUOTED_PROP, true);
                }
                obj.addChildToBack(stringKey);
            }
        }
        Node function = member.getLastChild();
        JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(NodeUtil.getBestJSDocInfo(function));
        info.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(metadata.getFullClassNameNode().getQualifiedName())).srcrefTree(member), member.getSourceFileName()));
        Node stringKey = this.astFactory.createStringKey(member.isGetterDef() || member.getBooleanProp(Node.COMPUTED_PROP_GETTER) ? "get" : "set", function.detach());
        stringKey.setJSDocInfo(info.build());
        prop.addChildToBack(stringKey);
        prop.useSourceInfoIfMissingFromForTree(member);
    }

    private void visitNonMethodMember(Node member, ClassDeclarationMetadata metadata) {
        JSTypeExpression existingType;
        String memberName;
        if (member.isComputedProp() && member.isStaticMember()) {
            Es6ToEs3Util.cannotConvertYet(this.compiler, member, "Static computed property");
            return;
        }
        if (member.isComputedProp() && !member.getFirstChild().isQualifiedName()) {
            Es6ToEs3Util.cannotConvert(this.compiler, member.getFirstChild(), "Computed property with non-qualified-name key");
            return;
        }
        JSTypeExpression typeExpr = this.getTypeFromGetterOrSetter(member);
        this.addToDefinePropertiesObject(metadata, member);
        Map<String, ClassProperty> membersToDeclare = member.isStaticMember() ? metadata.getClassMembersToDeclare() : metadata.getPrototypeMembersToDeclare();
        ClassProperty.Builder builder = ClassProperty.builder();
        if (member.isComputedProp()) {
            Preconditions.checkState(!member.isStaticMember());
            memberName = member.getFirstChild().getQualifiedName();
            builder.kind(ClassProperty.PropertyKind.COMPUTED_PROPERTY);
        } else if (member.isQuotedString()) {
            memberName = member.getString();
            builder.kind(ClassProperty.PropertyKind.QUOTED_PROPERTY);
        } else {
            memberName = member.getString();
            builder.kind(ClassProperty.PropertyKind.NORMAL_PROPERTY);
        }
        builder.propertyKey(memberName);
        ClassProperty existingProperty = membersToDeclare.get(memberName);
        JSTypeExpression jSTypeExpression = existingType = existingProperty == null ? null : existingProperty.jsDocInfo().getType();
        if (existingProperty != null && typeExpr != null && !existingType.equals(typeExpr)) {
            this.compiler.report(JSError.make(member, CONFLICTING_GETTER_SETTER_TYPE, memberName));
        } else {
            JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
            if (member.getJSDocInfo() != null && member.getJSDocInfo().isExport()) {
                jsDoc.recordExport();
                jsDoc.recordVisibility(JSDocInfo.Visibility.PUBLIC);
            }
            if (member.getJSDocInfo() != null && member.getJSDocInfo().isOverride()) {
                jsDoc.recordOverride();
            } else if (typeExpr == null) {
                typeExpr = new JSTypeExpression(new Node(Token.QMARK).srcref(member), member.getSourceFileName());
            }
            if (typeExpr != null) {
                jsDoc.recordType(typeExpr.copy());
            }
            if (member.isStaticMember() && !member.isComputedProp()) {
                jsDoc.recordNoCollapse();
            }
            builder.jsDocInfo(jsDoc.build());
            membersToDeclare.put(memberName, builder.build());
        }
    }

    private void visitMethod(Node member, ClassDeclarationMetadata metadata) {
        Node qualifiedMemberAccess = this.getQualifiedMemberAccess(member, metadata);
        Node method = member.getLastChild().detach();
        Node assign = this.astFactory.createAssign(qualifiedMemberAccess, method).useSourceInfoIfMissingFrom(method);
        JSDocInfo info = member.getJSDocInfo();
        if (member.isStaticMember() && NodeUtil.referencesThis(assign.getLastChild())) {
            JSDocInfoBuilder memberDoc = JSDocInfoBuilder.maybeCopyFrom(info);
            memberDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, new Node(Token.QMARK)).srcrefTree(member), member.getSourceFileName()));
            info = memberDoc.build();
        }
        if (info != null) {
            assign.setJSDocInfo(info);
        }
        Node newNode = NodeUtil.newExpr(assign);
        metadata.insertNodeAndAdvance(newNode);
    }

    private void addTypeDeclarations(Scope scope, ClassDeclarationMetadata metadata, Node insertionPoint) {
        Node declaration;
        for (ClassProperty property : metadata.getPrototypeMembersToDeclare().values()) {
            declaration = property.getDeclaration(this.astFactory, scope, metadata.getClassPrototypeNode().cloneTree());
            declaration.useSourceInfoIfMissingFromForTree(metadata.getClassNameNode());
            insertionPoint.getParent().addChildAfter(declaration, insertionPoint);
            insertionPoint = declaration;
        }
        for (ClassProperty property : metadata.getClassMembersToDeclare().values()) {
            declaration = property.getDeclaration(this.astFactory, scope, metadata.getFullClassNameNode().cloneTree());
            declaration.useSourceInfoIfMissingFromForTree(metadata.getClassNameNode());
            insertionPoint.getParent().addChildAfter(declaration, insertionPoint);
            insertionPoint = declaration;
        }
    }

    private Node getQualifiedMemberAccess(Node member, ClassDeclarationMetadata metadata) {
        Node context = member.isStaticMember() ? metadata.getFullClassNameNode().cloneTree() : metadata.getClassPrototypeNode().cloneTree();
        context.makeNonIndexableRecursive();
        if (member.isComputedProp()) {
            return this.astFactory.createGetElem(context, member.removeFirstChild()).useSourceInfoIfMissingFromForTree(member);
        }
        Node methodName = member.getFirstFirstChild();
        return this.astFactory.createGetProp(context, member.getString()).useSourceInfoFromForTree(methodName);
    }

    private Node createPropertyDescriptor() {
        return IR.objectlit(this.astFactory.createStringKey("configurable", this.astFactory.createBoolean(true)), this.astFactory.createStringKey("enumerable", this.astFactory.createBoolean(true))).setJSType(this.objectPropertyDescriptorType);
    }

    static class InsertionPoint {
        private Node insertionPoint;

        private InsertionPoint(Node insertionPoint) {
            this.insertionPoint = insertionPoint;
        }

        void insertNodeAndAdvance(Node newNode) {
            this.insertionPoint.getParent().addChildAfter(newNode, this.insertionPoint);
            this.insertionPoint = newNode;
        }

        static InsertionPoint from(Node start) {
            return new InsertionPoint(start);
        }

        Node getNode() {
            return this.insertionPoint;
        }
    }

    static abstract class ClassDeclarationMetadata {
        ClassDeclarationMetadata() {
        }

        abstract InsertionPoint getInsertionPoint();

        abstract Node getDefinePropertiesObjForPrototype();

        abstract Node getDefinePropertiesObjForClass();

        abstract Map<String, ClassProperty> getPrototypeMembersToDeclare();

        abstract Map<String, ClassProperty> getClassMembersToDeclare();

        abstract Node getFullClassNameNode();

        abstract Node getClassPrototypeNode();

        abstract boolean isAnonymous();

        abstract Node getClassNameNode();

        abstract Node getSuperClassNameNode();

        public static Builder builder() {
            return new AutoValue_Es6RewriteClass_ClassDeclarationMetadata.Builder().setPrototypeMembersToDeclare(new LinkedHashMap<String, ClassProperty>()).setClassMembersToDeclare(new LinkedHashMap<String, ClassProperty>());
        }

        @Nullable
        static ClassDeclarationMetadata create(Node classNode, Node parent) {
            return ClassDeclarationMetadata.create(classNode, parent, AstFactory.createFactoryWithoutTypes());
        }

        private static ClassDeclarationMetadata create(Node classNode, Node parent, AstFactory astFactory) {
            Node classNameNode = classNode.getFirstChild();
            Node superClassNameNode = classNameNode.getNext();
            Builder builder = ClassDeclarationMetadata.builder().setSuperClassNameNode(superClassNameNode).setClassNameNode(classNameNode);
            if (NodeUtil.isClassDeclaration(classNode)) {
                builder.setInsertionPoint(InsertionPoint.from(classNode)).setFullClassNameNode(classNameNode).setAnonymous(false);
            } else if (parent.isAssign() && parent.getParent().isExprResult()) {
                Node fullClassNameNode = parent.getFirstChild();
                if (!fullClassNameNode.isQualifiedName()) {
                    return null;
                }
                builder.setInsertionPoint(InsertionPoint.from(parent.getParent())).setFullClassNameNode(fullClassNameNode).setAnonymous(true);
            } else if (parent.isExport()) {
                builder.setInsertionPoint(InsertionPoint.from(classNode)).setFullClassNameNode(classNameNode).setAnonymous(false);
            } else if (parent.isName()) {
                builder.setInsertionPoint(InsertionPoint.from(parent.getParent())).setFullClassNameNode(parent.cloneNode()).setAnonymous(true);
            } else {
                return null;
            }
            JSType classType = builder.getFullClassNameNode().getJSType();
            builder.setClassPrototypeNode(astFactory.createGetProp(builder.getFullClassNameNode().cloneTree(), "prototype"));
            builder.setDefinePropertiesObjForClass(IR.objectlit(new Node[0]).setJSType(classType));
            builder.setDefinePropertiesObjForPrototype(IR.objectlit(new Node[0]).setJSType(classType));
            return builder.build();
        }

        void insertNodeAndAdvance(Node newNode) {
            this.getInsertionPoint().insertNodeAndAdvance(newNode);
        }

        boolean hasSuperClass() {
            return !this.getSuperClassNameNode().isEmpty();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setInsertionPoint(InsertionPoint var1);

            abstract Builder setFullClassNameNode(Node var1);

            abstract Node getFullClassNameNode();

            abstract Builder setPrototypeMembersToDeclare(Map<String, ClassProperty> var1);

            abstract Builder setClassMembersToDeclare(Map<String, ClassProperty> var1);

            abstract Builder setAnonymous(boolean var1);

            abstract Builder setClassNameNode(Node var1);

            abstract Builder setSuperClassNameNode(Node var1);

            abstract Builder setClassPrototypeNode(Node var1);

            abstract Builder setDefinePropertiesObjForClass(Node var1);

            abstract Builder setDefinePropertiesObjForPrototype(Node var1);

            abstract ClassDeclarationMetadata build();
        }
    }

    static abstract class ClassProperty {
        ClassProperty() {
        }

        abstract String propertyKey();

        abstract PropertyKind kind();

        abstract JSDocInfo jsDocInfo();

        final Node getDeclaration(AstFactory astFactory, Scope scope, Node toDeclareOn) {
            Node decl = null;
            switch (this.kind()) {
                case QUOTED_PROPERTY: {
                    decl = astFactory.createGetElem(toDeclareOn, astFactory.createString(this.propertyKey()));
                    break;
                }
                case COMPUTED_PROPERTY: {
                    decl = astFactory.createGetElem(toDeclareOn, astFactory.createQName(scope, this.propertyKey()));
                    break;
                }
                case NORMAL_PROPERTY: {
                    decl = astFactory.createGetProp(toDeclareOn, this.propertyKey());
                }
            }
            decl.setJSDocInfo(this.jsDocInfo());
            decl = astFactory.exprResult(decl);
            return decl;
        }

        static Builder builder() {
            return new AutoValue_Es6RewriteClass_ClassProperty.Builder();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder propertyKey(String var1);

            abstract Builder kind(PropertyKind var1);

            abstract Builder jsDocInfo(JSDocInfo var1);

            abstract ClassProperty build();
        }

        static enum PropertyKind {
            QUOTED_PROPERTY,
            COMPUTED_PROPERTY,
            NORMAL_PROPERTY;

        }
    }

    private class CheckClassAssignments
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Node className;

        public CheckClassAssignments(Node className) {
            this.className = className;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isAssign() || n.getFirstChild() == this.className) {
                return;
            }
            if (this.className.matchesQualifiedName(n.getFirstChild())) {
                Es6RewriteClass.this.compiler.report(JSError.make(n, CLASS_REASSIGNMENT, new String[0]));
            }
        }
    }
}

