/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.ClipboardManager;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import java.io.File;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.qtproject.qt5.android.QtActivityDelegate;
import org.qtproject.qt5.android.QtServiceDelegate;

public class QtNative {
    private static Activity m_activity = null;
    private static boolean m_activityPaused = false;
    private static Service m_service = null;
    private static QtActivityDelegate m_activityDelegate = null;
    private static QtServiceDelegate m_serviceDelegate = null;
    public static Object m_mainActivityMutex = new Object();
    public static final String QtTAG = "Qt JAVA";
    private static ArrayList<Runnable> m_lostActions = new ArrayList();
    private static boolean m_started = false;
    private static int m_displayMetricsScreenWidthPixels = 0;
    private static int m_displayMetricsScreenHeightPixels = 0;
    private static int m_displayMetricsDesktopWidthPixels = 0;
    private static int m_displayMetricsDesktopHeightPixels = 0;
    private static double m_displayMetricsXDpi = 0.0;
    private static double m_displayMetricsYDpi = 0.0;
    private static double m_displayMetricsScaledDensity = 1.0;
    private static double m_displayMetricsDensity = 1.0;
    private static int m_oldx;
    private static int m_oldy;
    private static final int m_moveThreshold = 0;
    private static ClipboardManager m_clipboardManager;
    private static Method m_checkSelfPermissionMethod;
    private static Boolean m_tabletEventSupported;
    private static final Runnable runPendingCppRunnablesRunnable;
    private static ClassLoader m_classLoader;
    public static final int IdCursorHandle = 1;
    public static final int IdLeftHandle = 2;
    public static final int IdRightHandle = 3;

    public static ClassLoader classLoader() {
        return m_classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        m_classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Activity activity() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service service() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QtActivityDelegate activityDelegate() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activityDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QtServiceDelegate serviceDelegate() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_serviceDelegate;
        }
    }

    public static boolean openURL(String string2, String string3) {
        boolean bl = true;
        try {
            Uri uri = Uri.parse((String)string2);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!string3.isEmpty()) {
                intent.setDataAndType(uri, string3);
            }
            QtNative.activity().startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static void loadQtLibraries(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (String string2 : arrayList) {
            try {
                File file = new File(string2);
                if (!file.exists()) continue;
                System.load(string2);
            }
            catch (SecurityException securityException) {
                Log.i((String)QtTAG, (String)("Can't load '" + string2 + "'"), (Throwable)securityException);
            }
            catch (Exception exception) {
                Log.i((String)QtTAG, (String)("Can't load '" + string2 + "'"), (Throwable)exception);
            }
        }
    }

    public static void loadBundledLibraries(ArrayList<String> arrayList, String string2) {
        if (arrayList == null) {
            return;
        }
        for (String string3 : arrayList) {
            try {
                File file = new File(string2 + "lib" + string3 + ".so");
                if (file.exists()) {
                    System.load(file.getAbsolutePath());
                    continue;
                }
                Log.i((String)QtTAG, (String)("Can't find '" + file.getAbsolutePath()));
            }
            catch (Exception exception) {
                Log.i((String)QtTAG, (String)("Can't load '" + string3 + "'"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActivity(Activity activity, QtActivityDelegate qtActivityDelegate) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_activity = activity;
            m_activityDelegate = qtActivityDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setService(Service service, QtServiceDelegate qtServiceDelegate) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_service = service;
            m_serviceDelegate = qtServiceDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationState(int n) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            switch (n) {
                case 4: {
                    m_activityPaused = false;
                    Iterator<Runnable> iterator = m_lostActions.iterator();
                    while (iterator.hasNext()) {
                        QtNative.runAction(iterator.next());
                    }
                    m_lostActions.clear();
                    break;
                }
                default: {
                    m_activityPaused = true;
                }
            }
        }
        QtNative.updateApplicationState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAction(Runnable runnable) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            boolean bl;
            Looper looper = Looper.getMainLooper();
            Handler handler = new Handler(looper);
            boolean bl2 = bl = !m_activityPaused && m_activity != null && looper != null && handler.post(runnable);
            if (!bl) {
                m_lostActions.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runPendingCppRunnablesOnAndroidThread() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_activity != null) {
                if (!m_activityPaused) {
                    m_activity.runOnUiThread(runPendingCppRunnablesRunnable);
                } else {
                    QtNative.runAction(runPendingCppRunnablesRunnable);
                }
            } else {
                Looper looper = Looper.getMainLooper();
                Thread thread = looper.getThread();
                if (thread.equals(Thread.currentThread())) {
                    runPendingCppRunnablesRunnable.run();
                } else {
                    Handler handler = new Handler(looper);
                    handler.post(runPendingCppRunnablesRunnable);
                }
            }
        }
    }

    private static void setViewVisibility(final View view, final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(bl ? 0 : 8);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startApplication(String string2, String string3, String string4, String string5) throws Exception {
        File file = new File(string5 + "lib" + string4 + ".so");
        if (!file.exists()) {
            throw new Exception("Can't find main library '" + string4 + "'");
        }
        if (string2 == null) {
            string2 = "-platform\tandroid";
        }
        boolean bl = false;
        Object object = m_mainActivityMutex;
        synchronized (object) {
            bl = QtNative.startQtAndroidPlugin();
            QtNative.setDisplayMetrics(m_displayMetricsScreenWidthPixels, m_displayMetricsScreenHeightPixels, m_displayMetricsDesktopWidthPixels, m_displayMetricsDesktopHeightPixels, m_displayMetricsXDpi, m_displayMetricsYDpi, m_displayMetricsScaledDensity, m_displayMetricsDensity);
            if (string2.length() > 0 && !string2.startsWith("\t")) {
                string2 = "\t" + string2;
            }
            QtNative.startQtApplication(file.getAbsolutePath() + string2, string3);
            m_started = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationDisplayMetrics(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
        if (d < 120.0) {
            d = 120.0;
        }
        if (d2 < 120.0) {
            d2 = 120.0;
        }
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_started) {
                QtNative.setDisplayMetrics(n, n2, n3, n4, d, d2, d3, d4);
            } else {
                m_displayMetricsScreenWidthPixels = n;
                m_displayMetricsScreenHeightPixels = n2;
                m_displayMetricsDesktopWidthPixels = n3;
                m_displayMetricsDesktopHeightPixels = n4;
                m_displayMetricsXDpi = d;
                m_displayMetricsYDpi = d2;
                m_displayMetricsScaledDensity = d3;
                m_displayMetricsDensity = d4;
            }
        }
    }

    public static native void startQtApplication(String var0, String var1);

    public static native boolean startQtAndroidPlugin();

    public static native void quitQtCoreApplication();

    public static native void quitQtAndroidPlugin();

    public static native void terminateQt();

    private static void quitApp() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                QtNative.quitQtAndroidPlugin();
                if (m_activity != null) {
                    m_activity.finish();
                }
                if (m_service != null) {
                    m_service.stopSelf();
                }
            }
        });
    }

    private static int getAction(int n, MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 2) {
            int n3 = motionEvent.getHistorySize();
            if (n3 > 0) {
                float f = motionEvent.getX(n);
                float f2 = motionEvent.getY(n);
                for (int i = 0; i < n3; ++i) {
                    if (motionEvent.getHistoricalX(n, i) == f && motionEvent.getHistoricalY(n, i) == f2) continue;
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        if (n2 == 0 || n2 == 5 && n == motionEvent.getActionIndex()) {
            return 0;
        }
        if (n2 == 1 || n2 == 6 && n == motionEvent.getActionIndex()) {
            return 3;
        }
        return 2;
    }

    public static void sendTouchEvent(MotionEvent motionEvent, int n) {
        int n2 = 0;
        if (m_tabletEventSupported == null) {
            m_tabletEventSupported = QtNative.isTabletEventSupported();
        }
        switch (motionEvent.getToolType(0)) {
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        if (m_tabletEventSupported.booleanValue() && n2 != 0) {
            QtNative.tabletEvent(n, motionEvent.getDeviceId(), motionEvent.getEventTime(), motionEvent.getAction(), n2, motionEvent.getButtonState(), motionEvent.getX(), motionEvent.getY(), motionEvent.getPressure());
        } else {
            QtNative.touchBegin(n);
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                QtNative.touchAdd(n, motionEvent.getPointerId(i), QtNative.getAction(i, motionEvent), i == 0, (int)motionEvent.getX(i), (int)motionEvent.getY(i), motionEvent.getTouchMajor(i), motionEvent.getTouchMinor(i), motionEvent.getOrientation(i), motionEvent.getPressure(i));
            }
            switch (motionEvent.getAction()) {
                case 0: {
                    QtNative.touchEnd(n, 0);
                    break;
                }
                case 1: {
                    QtNative.touchEnd(n, 2);
                    break;
                }
                default: {
                    QtNative.touchEnd(n, 1);
                }
            }
        }
    }

    public static void sendTrackballEvent(MotionEvent motionEvent, int n) {
        switch (motionEvent.getAction()) {
            case 1: {
                QtNative.mouseUp(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                break;
            }
            case 0: {
                QtNative.mouseDown(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
                break;
            }
            case 2: {
                int n2 = (int)(motionEvent.getX() - (float)m_oldx);
                int n3 = (int)(motionEvent.getY() - (float)m_oldy);
                if (Math.abs(n2) <= 5 && Math.abs(n3) <= 5) break;
                QtNative.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
            }
        }
    }

    public static Context getContext() {
        if (m_activity != null) {
            return m_activity;
        }
        return m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkSelfPermission(String string2) {
        int n = -1;
        Object object = m_mainActivityMutex;
        synchronized (object) {
            Context context = QtNative.getContext();
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (m_checkSelfPermissionMethod == null) {
                        m_checkSelfPermissionMethod = Context.class.getMethod("checkSelfPermission", String.class);
                    }
                    n = (Integer)m_checkSelfPermissionMethod.invoke((Object)context, string2);
                } else {
                    PackageManager packageManager = context.getPackageManager();
                    n = packageManager.checkPermission(string2, context.getApplicationContext().getPackageName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private static void updateSelection(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.updateSelection(n, n2, n3, n4);
                }
            }
        });
    }

    private static void updateHandles(final int n, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.updateHandles(n, n2, n3, n4, n5);
            }
        });
    }

    private static void showSoftwareKeyboard(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.showSoftwareKeyboard(n, n2, n3, n4, n5, n6);
                }
            }
        });
    }

    private static void resetSoftwareKeyboard() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.resetSoftwareKeyboard();
                }
            }
        });
    }

    private static void hideSoftwareKeyboard() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.hideSoftwareKeyboard();
                }
            }
        });
    }

    private static void setFullScreen(final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.setFullScreen(bl);
                }
                QtNative.updateWindow();
            }
        });
    }

    private static void registerClipboardManager() {
        if (m_service == null || m_activity != null) {
            final Semaphore semaphore = new Semaphore(0);
            QtNative.runAction(new Runnable(){

                @Override
                public void run() {
                    if (m_activity != null) {
                        m_clipboardManager = (ClipboardManager)m_activity.getSystemService("clipboard");
                    }
                    semaphore.release();
                }
            });
            try {
                semaphore.acquire();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void setClipboardText(String string2) {
        if (m_clipboardManager != null) {
            m_clipboardManager.setText((CharSequence)string2);
        }
    }

    public static boolean hasClipboardText() {
        if (m_clipboardManager != null) {
            return m_clipboardManager.hasText();
        }
        return false;
    }

    private static String getClipboardText() {
        if (m_clipboardManager != null) {
            return m_clipboardManager.getText().toString();
        }
        return "";
    }

    private static void openContextMenu(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.openContextMenu(n, n2, n3, n4);
                }
            }
        });
    }

    private static void closeContextMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.closeContextMenu();
                }
            }
        });
    }

    private static void resetOptionsMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.resetOptionsMenu();
                }
            }
        });
    }

    private static void openOptionsMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activity != null) {
                    m_activity.openOptionsMenu();
                }
            }
        });
    }

    private static byte[][] getSSLCertificates() {
        Object object;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init((KeyStore)null);
            for (TrustManager trustManager : ((TrustManagerFactory)object).getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                    byte[] byArray = x509Certificate.getEncoded();
                    arrayList.add(byArray);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get certificates", (Throwable)exception);
        }
        object = new byte[arrayList.size()][];
        object = (byte[][])arrayList.toArray((T[])object);
        return object;
    }

    private static void createSurface(final int n, final boolean bl, final int n2, final int n3, final int n4, final int n5, final int n6) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.createSurface(n, bl, n2, n3, n4, n5, n6);
                }
            }
        });
    }

    private static void insertNativeView(final int n, final View view, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.insertNativeView(n, view, n2, n3, n4, n5);
                }
            }
        });
    }

    private static void setSurfaceGeometry(final int n, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.setSurfaceGeometry(n, n2, n3, n4, n5);
                }
            }
        });
    }

    private static void bringChildToFront(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.bringChildToFront(n);
                }
            }
        });
    }

    private static void bringChildToBack(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.bringChildToBack(n);
                }
            }
        });
    }

    private static void destroySurface(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.destroySurface(n);
                }
            }
        });
    }

    private static void initializeAccessibility() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.initializeAccessibility();
            }
        });
    }

    private static void hideSplashScreen() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.hideSplashScreen();
                }
            }
        });
    }

    public static native void setDisplayMetrics(int var0, int var1, int var2, int var3, double var4, double var6, double var8, double var10);

    public static native void handleOrientationChanged(int var0, int var1);

    public static native void mouseDown(int var0, int var1, int var2);

    public static native void mouseUp(int var0, int var1, int var2);

    public static native void mouseMove(int var0, int var1, int var2);

    public static native void touchBegin(int var0);

    public static native void touchAdd(int var0, int var1, int var2, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9);

    public static native void touchEnd(int var0, int var1);

    public static native void longPress(int var0, int var1, int var2);

    public static native boolean isTabletEventSupported();

    public static native void tabletEvent(int var0, int var1, long var2, int var4, int var5, int var6, float var7, float var8, float var9);

    public static native void keyDown(int var0, int var1, int var2, boolean var3);

    public static native void keyUp(int var0, int var1, int var2, boolean var3);

    public static native void keyboardVisibilityChanged(boolean var0);

    public static native void keyboardGeometryChanged(int var0, int var1, int var2, int var3);

    public static native void handleLocationChanged(int var0, int var1, int var2);

    public static native boolean dispatchGenericMotionEvent(MotionEvent var0);

    public static native boolean dispatchKeyEvent(KeyEvent var0);

    public static native void setSurface(int var0, Object var1, int var2, int var3);

    public static native void updateWindow();

    public static native void updateApplicationState(int var0);

    public static native boolean onPrepareOptionsMenu(Menu var0);

    public static native boolean onOptionsItemSelected(int var0, boolean var1);

    public static native void onOptionsMenuClosed(Menu var0);

    public static native void onCreateContextMenu(ContextMenu var0);

    public static native void fillContextMenu(Menu var0);

    public static native boolean onContextItemSelected(int var0, boolean var1);

    public static native void onContextMenuClosed(Menu var0);

    public static native void onActivityResult(int var0, int var1, Intent var2);

    public static native void onNewIntent(Intent var0);

    public static native void runPendingCppRunnables();

    public static native void sendRequestPermissionsResult(int var0, String[] var1, int[] var2);

    private static native void setNativeActivity(Activity var0);

    private static native void setNativeService(Service var0);

    static {
        m_clipboardManager = null;
        m_checkSelfPermissionMethod = null;
        m_tabletEventSupported = null;
        runPendingCppRunnablesRunnable = new Runnable(){

            @Override
            public void run() {
                QtNative.runPendingCppRunnables();
            }
        };
        m_classLoader = null;
    }
}

