/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.qtproject.qt.android.bluetooth.QtBluetoothGattCharacteristic;

public class QtBluetoothLEServer {
    private static final String TAG = "QtBluetoothGattServer";
    long qtObject = 0L;
    private Context qtContext = null;
    private final BluetoothAdapter mBluetoothAdapter;
    private BluetoothManager mBluetoothManager = null;
    private BluetoothGattServer mGattServer = null;
    private BluetoothLeAdvertiser mLeAdvertiser = null;
    private ArrayList<BluetoothGattService> mPendingServiceAdditions = new ArrayList();
    private String mRemoteName = "";
    private String mRemoteAddress = "";
    private static final int DEFAULT_LE_ATT_MTU = 23;
    private int mSupportedMtu = 23;
    private static final int MAX_PENDING_WRITE_COUNT = 1024;
    private static final int GATT_ERROR_PREPARE_QUEUE_FULL = 9;
    private static final int BTLE_MAX_ATTRIBUTE_VALUE_SIZE = 512;
    private final List<WriteEntry> mPendingPreparedWrites = new ArrayList<WriteEntry>();
    private static final UUID CLIENT_CHARACTERISTIC_CONFIGURATION_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    ClientCharacteristicManager clientCharacteristicManager = new ClientCharacteristicManager();
    private BluetoothGattServerCallback mGattServerListener = new BluetoothGattServerCallback(){

        public void onConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
            super.onConnectionStateChange(bluetoothDevice, n, n2);
            QtBluetoothLEServer.this.handleOnConnectionStateChange(bluetoothDevice, n, n2);
        }

        public void onServiceAdded(int n, BluetoothGattService bluetoothGattService) {
            super.onServiceAdded(n, bluetoothGattService);
            QtBluetoothLEServer.this.handleOnServiceAdded(n, bluetoothGattService);
        }

        public void onCharacteristicReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            super.onCharacteristicReadRequest(bluetoothDevice, n, n2, bluetoothGattCharacteristic);
            QtBluetoothLEServer.this.handleOnCharacteristicReadRequest(bluetoothDevice, n, n2, bluetoothGattCharacteristic);
        }

        public void onCharacteristicWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl, boolean bl2, int n2, byte[] byArray) {
            super.onCharacteristicWriteRequest(bluetoothDevice, n, bluetoothGattCharacteristic, bl, bl2, n2, byArray);
            QtBluetoothLEServer.this.handleOnCharacteristicWriteRequest(bluetoothDevice, n, bluetoothGattCharacteristic, bl, bl2, n2, byArray);
        }

        public void onDescriptorReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattDescriptor bluetoothGattDescriptor) {
            super.onDescriptorReadRequest(bluetoothDevice, n, n2, bluetoothGattDescriptor);
            QtBluetoothLEServer.this.handleOnDescriptorReadRequest(bluetoothDevice, n, n2, bluetoothGattDescriptor);
        }

        public void onDescriptorWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattDescriptor bluetoothGattDescriptor, boolean bl, boolean bl2, int n2, byte[] byArray) {
            super.onDescriptorWriteRequest(bluetoothDevice, n, bluetoothGattDescriptor, bl, bl2, n2, byArray);
            QtBluetoothLEServer.this.handleOnDescriptorWriteRequest(bluetoothDevice, n, bluetoothGattDescriptor, bl, bl2, n2, byArray);
        }

        public void onExecuteWrite(BluetoothDevice bluetoothDevice, int n, boolean bl) {
            super.onExecuteWrite(bluetoothDevice, n, bl);
            QtBluetoothLEServer.this.handleOnExecuteWrite(bluetoothDevice, n, bl);
        }

        public void onNotificationSent(BluetoothDevice bluetoothDevice, int n) {
            super.onNotificationSent(bluetoothDevice, n);
            Log.w((String)QtBluetoothLEServer.TAG, (String)("onNotificationSent" + bluetoothDevice + " " + n));
        }

        public void onMtuChanged(BluetoothDevice bluetoothDevice, int n) {
            QtBluetoothLEServer.this.handleOnMtuChanged(bluetoothDevice, n);
        }
    };
    private AdvertiseCallback mAdvertiseListener = new AdvertiseCallback(){

        public void onStartSuccess(AdvertiseSettings advertiseSettings) {
            super.onStartSuccess(advertiseSettings);
        }

        public void onStartFailure(int n) {
            Log.e((String)QtBluetoothLEServer.TAG, (String)("Advertising failure: " + n));
            super.onStartFailure(n);
            int n2 = 0;
            switch (n) {
                case 3: {
                    return;
                }
                case 1: {
                    Log.e((String)QtBluetoothLEServer.TAG, (String)"Please reduce size of advertising data.");
                    n2 = 1;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 4;
                }
            }
            if (n2 > 0) {
                QtBluetoothLEServer.this.leServerAdvertisementError(QtBluetoothLEServer.this.qtObject, n2);
            }
        }
    };

    public synchronized String remoteName() {
        return this.mRemoteName;
    }

    public synchronized String remoteAddress() {
        return this.mRemoteAddress;
    }

    private void clearPendingPreparedWrites(Object object) {
        if (object == null) {
            this.mPendingPreparedWrites.clear();
        }
        ListIterator<WriteEntry> listIterator = this.mPendingPreparedWrites.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().remoteDevice.equals(object)) continue;
            listIterator.remove();
        }
    }

    private int addPendingPreparedWrite(BluetoothDevice bluetoothDevice, Object object, int n, byte[] byArray) {
        WriteEntry writeEntry = null;
        int n2 = 0;
        for (WriteEntry writeEntry2 : this.mPendingPreparedWrites) {
            if (writeEntry2.match(bluetoothDevice, object)) {
                writeEntry = writeEntry2;
            }
            n2 += writeEntry2.writes.size();
        }
        if (n2 > 1024) {
            Log.w((String)TAG, (String)"Prepared write queue is full, returning an error.");
            return 9;
        }
        if (writeEntry == null) {
            writeEntry = new WriteEntry(bluetoothDevice, object);
            this.mPendingPreparedWrites.add(writeEntry);
        }
        writeEntry.writes.add((Pair<byte[], Integer>)new Pair((Object)byArray, (Object)n));
        return 0;
    }

    public QtBluetoothLEServer(Context context) {
        this.qtContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null || this.qtContext == null) {
            Log.w((String)TAG, (String)"Missing Bluetooth adapter or Qt context. Peripheral role disabled.");
            return;
        }
        this.mBluetoothManager = (BluetoothManager)this.qtContext.getSystemService("bluetooth");
        if (this.mBluetoothManager == null) {
            Log.w((String)TAG, (String)"Bluetooth service not available.");
            return;
        }
        Log.w((String)TAG, (String)"Let's do BTLE Peripheral.");
    }

    public synchronized void handleOnConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
        int n3;
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring connection state event, server is disconnected");
            return;
        }
        List list = this.mBluetoothManager.getConnectedDevices(8);
        Log.w((String)TAG, (String)("Device " + bluetoothDevice + " connection state: " + n2 + ", status: " + n + ", connected devices: " + list));
        int n4 = list.size() > 0 ? 2 : 0;
        switch (n2) {
            case 2: {
                this.clientCharacteristicManager.markDeviceConnectivity(bluetoothDevice, true);
                this.mRemoteName = bluetoothDevice.getName();
                this.mRemoteAddress = bluetoothDevice.getAddress();
                break;
            }
            case 0: {
                this.clientCharacteristicManager.markDeviceConnectivity(bluetoothDevice, false);
                this.clearPendingPreparedWrites(bluetoothDevice);
                if (!bluetoothDevice.getAddress().equals(this.mRemoteAddress) || list.isEmpty()) break;
                this.mRemoteName = ((BluetoothDevice)list.get(0)).getName();
                this.mRemoteAddress = ((BluetoothDevice)list.get(0)).getAddress();
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unhandled connection state change: " + n2));
                return;
            }
        }
        if (n4 == 0) {
            this.mPendingServiceAdditions.clear();
            this.mGattServer.close();
            this.mGattServer = null;
            this.mRemoteName = "";
            this.mRemoteAddress = "";
            this.mSupportedMtu = 23;
        }
        switch (n) {
            case 0: {
                n3 = 0;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unhandled error code on peripheral connectionStateChanged: " + n + " " + n2));
                n3 = n;
            }
        }
        this.leServerConnectionStateChange(this.qtObject, n3, n4);
    }

    public synchronized void handleOnServiceAdded(int n, BluetoothGattService bluetoothGattService) {
        BluetoothGattService bluetoothGattService2;
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring service addition event, server is disconnected");
            return;
        }
        Log.d((String)TAG, (String)("Service " + bluetoothGattService.getUuid().toString() + " addition result: " + n));
        ListIterator<BluetoothGattService> listIterator = this.mPendingServiceAdditions.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().getUuid().equals(bluetoothGattService.getUuid())) continue;
            listIterator.remove();
            break;
        }
        listIterator = this.mPendingServiceAdditions.listIterator();
        while (listIterator.hasNext() && !this.mGattServer.addService(bluetoothGattService2 = listIterator.next())) {
            Log.w((String)TAG, (String)("Adding service " + bluetoothGattService2.getUuid().toString() + " failed"));
            listIterator.remove();
        }
    }

    public synchronized void handleOnCharacteristicReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring characteristic read, server is disconnected");
            return;
        }
        try {
            byte[] byArray = Arrays.copyOfRange(bluetoothGattCharacteristic.getValue(), n2, bluetoothGattCharacteristic.getValue().length);
            this.mGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("onCharacteristicReadRequest: " + n + " " + n2 + " " + bluetoothGattCharacteristic.getValue().length));
            exception.printStackTrace();
            this.mGattServer.sendResponse(bluetoothDevice, n, 257, n2, null);
        }
    }

    public synchronized void handleOnCharacteristicWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl, boolean bl2, int n2, byte[] byArray) {
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring characteristic write, server is disconnected");
            return;
        }
        Log.w((String)TAG, (String)("onCharacteristicWriteRequest " + bl + " " + n2 + " " + byArray.length));
        int n3 = ((QtBluetoothGattCharacteristic)bluetoothGattCharacteristic).minValueLength;
        int n4 = ((QtBluetoothGattCharacteristic)bluetoothGattCharacteristic).maxValueLength;
        int n5 = 0;
        boolean bl3 = false;
        if (!bl) {
            if (byArray.length < n3 || byArray.length > n4) {
                Log.w((String)TAG, (String)("onCharacteristicWriteRequest invalid char value length: " + byArray.length + ", min: " + n3 + ", max: " + n4));
                n5 = 13;
            } else if (n2 == 0) {
                bluetoothGattCharacteristic.setValue(byArray);
                this.leServerCharacteristicChanged(this.qtObject, bluetoothGattCharacteristic, byArray);
                bl3 = true;
            } else {
                Log.w((String)TAG, (String)("onCharacteristicWriteRequest: !preparedWrite, offset " + n2 + ", Not supported"));
                n5 = 7;
            }
        } else {
            n5 = this.addPendingPreparedWrite(bluetoothDevice, bluetoothGattCharacteristic, n2, byArray);
        }
        if (bl2) {
            this.mGattServer.sendResponse(bluetoothDevice, n, n5, n2, byArray);
        }
        if (bl3) {
            this.sendNotificationsOrIndications(bluetoothGattCharacteristic);
        }
    }

    public synchronized void handleOnDescriptorReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring descriptor read, server is disconnected");
            return;
        }
        byte[] byArray = bluetoothGattDescriptor.getValue();
        try {
            if (bluetoothGattDescriptor.getUuid().equals(CLIENT_CHARACTERISTIC_CONFIGURATION_UUID) && (byArray = this.clientCharacteristicManager.valueFor(bluetoothGattDescriptor.getCharacteristic(), bluetoothDevice)) == null) {
                byArray = bluetoothGattDescriptor.getValue();
            }
            byArray = Arrays.copyOfRange(byArray, n2, byArray.length);
            this.mGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("onDescriptorReadRequest: " + n + " " + n2 + " " + byArray.length));
            exception.printStackTrace();
            this.mGattServer.sendResponse(bluetoothDevice, n, 257, n2, null);
        }
    }

    public synchronized void handleOnDescriptorWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattDescriptor bluetoothGattDescriptor, boolean bl, boolean bl2, int n2, byte[] byArray) {
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring descriptor write, server is disconnected");
            return;
        }
        Log.w((String)TAG, (String)("onDescriptorWriteRequest " + bl + " " + n2 + " " + byArray.length));
        int n3 = 0;
        if (!bl) {
            if (n2 == 0) {
                if (bluetoothGattDescriptor.getUuid().equals(CLIENT_CHARACTERISTIC_CONFIGURATION_UUID)) {
                    if (byArray[0] == 3) {
                        Log.w((String)TAG, (String)("Warning: In CCC of characteristic: " + bluetoothGattDescriptor.getCharacteristic().getUuid() + " enabling both NTF & IND requested, enabling NTF only."));
                        byArray = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
                    }
                    this.clientCharacteristicManager.insertOrUpdate(bluetoothGattDescriptor.getCharacteristic(), bluetoothDevice, byArray);
                }
                bluetoothGattDescriptor.setValue(byArray);
                this.leServerDescriptorWritten(this.qtObject, bluetoothGattDescriptor, byArray);
            } else {
                Log.w((String)TAG, (String)("onDescriptorWriteRequest: !preparedWrite, offset " + n2 + ", Not supported"));
                n3 = 6;
            }
        } else {
            n3 = this.addPendingPreparedWrite(bluetoothDevice, bluetoothGattDescriptor, n2, byArray);
        }
        if (bl2) {
            this.mGattServer.sendResponse(bluetoothDevice, n, n3, n2, byArray);
        }
    }

    public synchronized void handleOnExecuteWrite(BluetoothDevice bluetoothDevice, int n, boolean bl) {
        if (this.mGattServer == null) {
            Log.w((String)TAG, (String)"Ignoring execute write, server is disconnected");
            return;
        }
        Log.w((String)TAG, (String)("onExecuteWrite " + bluetoothDevice + " " + n + " " + bl));
        if (bl) {
            for (WriteEntry writeEntry : this.mPendingPreparedWrites) {
                if (!writeEntry.remoteDevice.equals((Object)bluetoothDevice)) continue;
                byte[] byArray = null;
                byte[] byArray2 = writeEntry.target instanceof BluetoothGattCharacteristic ? ((BluetoothGattCharacteristic)writeEntry.target).getValue() : ((BluetoothGattDescriptor)writeEntry.target).getValue();
                for (Pair<byte[], Integer> pair : writeEntry.writes) {
                    if ((Integer)pair.second > byArray2.length) {
                        this.clearPendingPreparedWrites(bluetoothDevice);
                        this.mGattServer.sendResponse(bluetoothDevice, n, 7, 0, null);
                        return;
                    }
                    if (writeEntry.target instanceof QtBluetoothGattCharacteristic && (Integer)pair.second + ((byte[])pair.first).length > ((QtBluetoothGattCharacteristic)((Object)writeEntry.target)).maxValueLength) {
                        this.clearPendingPreparedWrites(bluetoothDevice);
                        this.mGattServer.sendResponse(bluetoothDevice, n, 13, 0, null);
                        return;
                    }
                    byArray = new byte[Math.max((Integer)pair.second + ((byte[])pair.first).length, byArray2.length)];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    System.arraycopy(pair.first, 0, byArray, (Integer)pair.second, ((byte[])pair.first).length);
                    byArray2 = byArray;
                }
                if (writeEntry.target instanceof BluetoothGattCharacteristic) {
                    ((BluetoothGattCharacteristic)writeEntry.target).setValue(byArray);
                    this.leServerCharacteristicChanged(this.qtObject, (BluetoothGattCharacteristic)writeEntry.target, byArray);
                    continue;
                }
                ((BluetoothGattDescriptor)writeEntry.target).setValue(byArray);
                this.leServerDescriptorWritten(this.qtObject, (BluetoothGattDescriptor)writeEntry.target, byArray);
            }
        }
        this.clearPendingPreparedWrites(bluetoothDevice);
        this.mGattServer.sendResponse(bluetoothDevice, n, 0, 0, null);
    }

    public synchronized void handleOnMtuChanged(BluetoothDevice bluetoothDevice, int n) {
        if (this.mSupportedMtu == n) {
            return;
        }
        this.mSupportedMtu = n;
        this.leMtuChanged(this.qtObject, this.mSupportedMtu);
    }

    public synchronized int mtu() {
        return this.mSupportedMtu;
    }

    public synchronized boolean connectServer() {
        if (this.mGattServer != null) {
            return true;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)this.qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            Log.w((String)TAG, (String)"Bluetooth service not available.");
            return false;
        }
        this.mGattServer = bluetoothManager.openGattServer(this.qtContext, this.mGattServerListener);
        return this.mGattServer != null;
    }

    public synchronized void disconnectServer() {
        if (this.mGattServer == null) {
            return;
        }
        this.clearPendingPreparedWrites(null);
        this.mPendingServiceAdditions.clear();
        this.mGattServer.close();
        this.mGattServer = null;
        this.mRemoteAddress = "";
        this.mRemoteName = "";
        this.leServerConnectionStateChange(this.qtObject, 0, 0);
    }

    public boolean startAdvertising(AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings) {
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            Log.w((String)TAG, (String)"StartAdvertising: Bluetooth not available or offline");
            return false;
        }
        if (this.mLeAdvertiser == null && this.mBluetoothAdapter.isMultipleAdvertisementSupported()) {
            this.mLeAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
        }
        if (this.mLeAdvertiser == null) {
            Log.w((String)TAG, (String)"StartAdvertising: LE advertisement not supported");
            return false;
        }
        if (!this.connectServer()) {
            Log.w((String)TAG, (String)"Server::startAdvertising: Cannot open GATT server");
            return false;
        }
        Log.w((String)TAG, (String)"Starting to advertise.");
        this.mLeAdvertiser.startAdvertising(advertiseSettings, advertiseData, advertiseData2, this.mAdvertiseListener);
        return true;
    }

    public void stopAdvertising() {
        if (this.mLeAdvertiser == null) {
            return;
        }
        this.mLeAdvertiser.stopAdvertising(this.mAdvertiseListener);
        Log.w((String)TAG, (String)"Advertisement stopped.");
    }

    public synchronized void addService(BluetoothGattService bluetoothGattService) {
        if (!this.connectServer()) {
            Log.w((String)TAG, (String)"Server::addService: Cannot open GATT server");
            return;
        }
        if (this.mPendingServiceAdditions.isEmpty()) {
            if (this.mGattServer.addService(bluetoothGattService)) {
                this.mPendingServiceAdditions.add(bluetoothGattService);
            } else {
                Log.w((String)TAG, (String)("Adding service " + bluetoothGattService.getUuid().toString() + " failed."));
            }
        } else {
            this.mPendingServiceAdditions.add(bluetoothGattService);
        }
    }

    private void sendNotificationsOrIndications(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        ListIterator<BluetoothDevice> listIterator = this.clientCharacteristicManager.getToBeUpdatedDevices(bluetoothGattCharacteristic).listIterator();
        while (listIterator.hasNext()) {
            BluetoothDevice bluetoothDevice = listIterator.next();
            byte[] byArray = this.clientCharacteristicManager.valueFor(bluetoothGattCharacteristic, bluetoothDevice);
            if (byArray == null) continue;
            if (Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                this.mGattServer.notifyCharacteristicChanged(bluetoothDevice, bluetoothGattCharacteristic, false);
                continue;
            }
            if (!Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) continue;
            this.mGattServer.notifyCharacteristicChanged(bluetoothDevice, bluetoothGattCharacteristic, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, byte[] byArray) {
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        List list = bluetoothGattService.getCharacteristics();
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : list) {
            if (bluetoothGattCharacteristic2.getUuid().equals(uUID) && bluetoothGattCharacteristic == null) {
                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                continue;
            }
            if (!bluetoothGattCharacteristic2.getUuid().equals(uUID)) continue;
            Log.w((String)TAG, (String)"Found second char with same UUID. Wrong char may have been selected.");
            break;
        }
        if (bluetoothGattCharacteristic == null) {
            Log.w((String)TAG, (String)"writeCharacteristic: update for unknown characteristic failed");
            return false;
        }
        int n = ((QtBluetoothGattCharacteristic)bluetoothGattCharacteristic).minValueLength;
        int n2 = ((QtBluetoothGattCharacteristic)bluetoothGattCharacteristic).maxValueLength;
        if (byArray.length < n || byArray.length > n2) {
            Log.w((String)TAG, (String)("writeCharacteristic: invalid value length: " + byArray.length + ", min: " + n + ", max: " + n2));
            return false;
        }
        QtBluetoothLEServer qtBluetoothLEServer = this;
        synchronized (qtBluetoothLEServer) {
            bluetoothGattCharacteristic.setValue(byArray);
            if (this.mGattServer != null) {
                this.sendNotificationsOrIndications(bluetoothGattCharacteristic);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDescriptor(BluetoothGattService bluetoothGattService, UUID uUID, UUID uUID2, byte[] byArray) {
        BluetoothGattDescriptor bluetoothGattDescriptor = null;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        List list = bluetoothGattService.getCharacteristics();
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : list) {
            if (!bluetoothGattCharacteristic2.getUuid().equals(uUID)) continue;
            if (bluetoothGattCharacteristic == null) {
                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                continue;
            }
            Log.w((String)TAG, (String)"Found second char with same UUID. Wrong char may have been selected.");
            break;
        }
        if (bluetoothGattCharacteristic != null) {
            bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(uUID2);
        }
        if (bluetoothGattCharacteristic == null || bluetoothGattDescriptor == null) {
            Log.w((String)TAG, (String)("writeDescriptor: update for unknown char or desc failed (" + bluetoothGattCharacteristic + ")"));
            return false;
        }
        QtBluetoothLEServer qtBluetoothLEServer = this;
        synchronized (qtBluetoothLEServer) {
            bluetoothGattDescriptor.setValue(byArray);
        }
        return true;
    }

    public native void leServerConnectionStateChange(long var1, int var3, int var4);

    public native void leMtuChanged(long var1, int var3);

    public native void leServerAdvertisementError(long var1, int var3);

    public native void leServerCharacteristicChanged(long var1, BluetoothGattCharacteristic var3, byte[] var4);

    public native void leServerDescriptorWritten(long var1, BluetoothGattDescriptor var3, byte[] var4);

    private class ClientCharacteristicManager {
        private final HashMap<BluetoothGattCharacteristic, List<Entry>> notificationStore = new HashMap();

        private ClientCharacteristicManager() {
        }

        public void insertOrUpdate(BluetoothGattCharacteristic bluetoothGattCharacteristic, BluetoothDevice bluetoothDevice, byte[] byArray) {
            if (this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get((int)i).device.equals((Object)bluetoothDevice)) continue;
                    Entry entry = list.get(i);
                    entry.value = byArray;
                    list.set(i, entry);
                    return;
                }
                Entry entry = new Entry();
                entry.device = bluetoothDevice;
                entry.value = byArray;
                entry.isConnected = true;
                list.add(entry);
                return;
            }
            Entry entry = new Entry();
            entry.device = bluetoothDevice;
            entry.value = byArray;
            entry.isConnected = true;
            LinkedList<Entry> linkedList = new LinkedList<Entry>();
            linkedList.add(entry);
            this.notificationStore.put(bluetoothGattCharacteristic, linkedList);
        }

        public void markDeviceConnectivity(BluetoothDevice bluetoothDevice, boolean bl) {
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : this.notificationStore.keySet()) {
                List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
                if (list == null) continue;
                ListIterator<Entry> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    Entry entry = listIterator.next();
                    if (!entry.device.equals((Object)bluetoothDevice)) continue;
                    entry.isConnected = bl;
                }
            }
        }

        List<BluetoothDevice> getToBeUpdatedDevices(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            if (!this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                return arrayList;
            }
            ListIterator<Entry> listIterator = this.notificationStore.get(bluetoothGattCharacteristic).listIterator();
            while (listIterator.hasNext()) {
                arrayList.add(listIterator.next().device);
            }
            return arrayList;
        }

        byte[] valueFor(BluetoothGattCharacteristic bluetoothGattCharacteristic, BluetoothDevice bluetoothDevice) {
            if (!this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                return null;
            }
            List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
            for (int i = 0; i < list.size(); ++i) {
                Entry entry = list.get(i);
                if (!entry.device.equals((Object)bluetoothDevice) || !entry.isConnected) continue;
                return list.get((int)i).value;
            }
            return null;
        }

        private class Entry {
            BluetoothDevice device = null;
            byte[] value = null;
            boolean isConnected = false;

            private Entry() {
            }
        }
    }

    private class WriteEntry {
        public final BluetoothDevice remoteDevice;
        public final Object target;
        public final List<Pair<byte[], Integer>> writes;

        WriteEntry(BluetoothDevice bluetoothDevice, Object object) {
            this.remoteDevice = bluetoothDevice;
            this.target = object;
            this.writes = new ArrayList<Pair<byte[], Integer>>();
        }

        public boolean match(BluetoothDevice bluetoothDevice, Object object) {
            return this.remoteDevice.equals((Object)bluetoothDevice) && object.equals(object);
        }
    }
}

