/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * This file was autogenerated from GrUnpremulInputFragmentProcessor.fp; do not modify.
 */
#ifndef GrUnpremulInputFragmentProcessor_DEFINED
#define GrUnpremulInputFragmentProcessor_DEFINED
#include "SkTypes.h"
#if SK_SUPPORT_GPU
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
class GrUnpremulInputFragmentProcessor : public GrFragmentProcessor {
public:
    GrColor4f constantOutputForConstantInput(GrColor4f input) const override {
        return input.unpremul();
    }
    static std::unique_ptr<GrFragmentProcessor> Make() {
        return std::unique_ptr<GrFragmentProcessor>(new GrUnpremulInputFragmentProcessor());
    }
    GrUnpremulInputFragmentProcessor(const GrUnpremulInputFragmentProcessor& src);
    std::unique_ptr<GrFragmentProcessor> clone() const override;
    const char* name() const override { return "UnpremulInputFragmentProcessor"; }

private:
    GrUnpremulInputFragmentProcessor()
            : INHERITED(kGrUnpremulInputFragmentProcessor_ClassID,
                        (OptimizationFlags)kPreservesOpaqueInput_OptimizationFlag |
                                kConstantOutputForConstantInput_OptimizationFlag) {}
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    typedef GrFragmentProcessor INHERITED;
};
#endif
#endif
