/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint16 languageId;
    quint16 countryId;
    QLocale::MeasurementSystem system;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { QLocale::English, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedStatesMinorOutlyingIslands, QLocale::ImperialUSSystem },
    { QLocale::Spanish, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::Hawaiian, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedKingdom, QLocale::ImperialUKSystem }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2018-08-13 from the
    Common Locale Data Repository v33.1

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/local_database/.
*/

static const QLocaleId likely_subtags[] = {
    {   4,   0,   0 }, {   4,   7,  69 }, // aa -> aa_Latn_ET
    {   2,   0,   0 }, {   2,   2,  81 }, // ab -> ab_Cyrl_GE
    { 255,   0,   0 }, { 255,  36, 102 }, // ae -> ae_Avst_IR
    {   5,   0,   0 }, {   5,   7, 195 }, // af -> af_Latn_ZA
    { 237,   0,   0 }, { 237,   7,  37 }, // agq -> agq_Latn_CM
    { 340,   0,   0 }, { 340, 128, 100 }, // aho -> aho_Ahom_IN
    { 146,   0,   0 }, { 146,   7,  83 }, // ak -> ak_Latn_GH
    { 262,   0,   0 }, { 262,  94, 103 }, // akk -> akk_Xsux_IQ
    {   7,   0,   0 }, {   7,  14,  69 }, // am -> am_Ethi_ET
    {   8,   0,   0 }, {   8,   1,  64 }, // ar -> ar_Arab_EG
    { 265,   0,   0 }, { 265,  57, 102 }, // arc -> arc_Armi_IR
    { 265, 119,   0 }, { 265, 119, 109 }, // arc_Nbat -> arc_Nbat_JO
    { 265, 120,   0 }, { 265, 120, 207 }, // arc_Palm -> arc_Palm_SY
    { 315,   0,   0 }, { 315,   7,  43 }, // arn -> arn_Latn_CL
    {  10,   0,   0 }, {  10,  11, 100 }, // as -> as_Beng_IN
    { 205,   0,   0 }, { 205,   7, 210 }, // asa -> asa_Latn_TZ
    { 341,   0,   0 }, { 341, 133, 225 }, // ase -> ase_Sgnw_US
    { 256,   0,   0 }, { 256,   7, 197 }, // ast -> ast_Latn_ES
    { 216,   0,   0 }, { 216,   2, 178 }, // av -> av_Cyrl_RU
    {  11,   0,   0 }, {  11,   7,  26 }, // ay -> ay_Latn_BO
    {  12,   0,   0 }, {  12,   7,  15 }, // az -> az_Latn_AZ
    {  12,   0, 103 }, {  12,   1, 103 }, // az_IQ -> az_Arab_IQ
    {  12,   0, 102 }, {  12,   1, 102 }, // az_IR -> az_Arab_IR
    {  12,   0, 178 }, {  12,   2, 178 }, // az_RU -> az_Cyrl_RU
    {  12,   1,   0 }, {  12,   1, 102 }, // az_Arab -> az_Arab_IR
    {  13,   0,   0 }, {  13,   2, 178 }, // ba -> ba_Cyrl_RU
    { 266,   0,   0 }, { 266,   7, 101 }, // ban -> ban_Latn_ID
    { 238,   0,   0 }, { 238,   7,  37 }, // bas -> bas_Latn_CM
    { 267,   0,   0 }, { 267,  38,  37 }, // bax -> bax_Bamu_CM
    { 268,   0,   0 }, { 268,   7, 101 }, // bbc -> bbc_Latn_ID
    {  22,   0,   0 }, {  22,   2,  20 }, // be -> be_Cyrl_BY
    { 195,   0,   0 }, { 195,   7, 239 }, // bem -> bem_Latn_ZM
    { 186,   0,   0 }, { 186,   7, 210 }, // bez -> bez_Latn_TZ
    {  20,   0,   0 }, {  20,   2,  33 }, // bg -> bg_Cyrl_BG
    { 343,   0,   0 }, { 343,  13, 100 }, // bho -> bho_Deva_IN
    {  18,   0,   0 }, {  18,   7, 229 }, // bi -> bi_Latn_VU
    { 270,   0,   0 }, { 270,   7, 170 }, // bku -> bku_Latn_PH
    { 309,   0,   0 }, { 309, 100, 232 }, // blt -> blt_Tavt_VN
    { 188,   0,   0 }, { 188,   7, 132 }, // bm -> bm_Latn_ML
    {  15,   0,   0 }, {  15,  11,  18 }, // bn -> bn_Beng_BD
    { 121,   0,   0 }, { 121,  31,  44 }, // bo -> bo_Tibt_CN
    {  19,   0,   0 }, {  19,   7,  74 }, // br -> br_Latn_FR
    { 215,   0,   0 }, { 215,  13, 100 }, // brx -> brx_Deva_IN
    { 142,   0,   0 }, { 142,   7,  27 }, // bs -> bs_Latn_BA
    { 336,   0,   0 }, { 336, 106, 121 }, // bsq -> bsq_Bass_LR
    { 312,   0,   0 }, { 312,   7,  37 }, // bss -> bss_Latn_CM
    { 269,   0,   0 }, { 269,   7, 101 }, // bug -> bug_Latn_ID
    { 152,   0,   0 }, { 152,  14,  67 }, // byn -> byn_Ethi_ER
    {  24,   0,   0 }, {  24,   7, 197 }, // ca -> ca_Latn_ES
    { 156,   0,   0 }, { 156,   7, 157 }, // cch -> cch_Latn_NG
    { 272,   0,   0 }, { 272,  46,  18 }, // ccp -> ccp_Cakm_BD
    { 218,   0,   0 }, { 218,   2, 178 }, // ce -> ce_Cyrl_RU
    { 211,   0,   0 }, { 211,   7, 221 }, // cgg -> cgg_Latn_UG
    { 217,   0,   0 }, { 217,   7,  89 }, // ch -> ch_Latn_GU
    { 190,   0,   0 }, { 190,  12, 225 }, // chr -> chr_Cher_US
    { 276,   0,   0 }, { 276,  47, 232 }, // cjm -> cjm_Cham_VN
    { 316,   0,   0 }, { 316,   1, 103 }, // ckb -> ckb_Arab_IQ
    {  26,   0,   0 }, {  26,   7,  74 }, // co -> co_Latn_FR
    { 274,   0,   0 }, { 274,  48,  64 }, // cop -> cop_Copt_EG
    { 221,   0,   0 }, { 221,  44,  38 }, // cr -> cr_Cans_CA
    {  28,   0,   0 }, {  28,   7,  57 }, // cs -> cs_Latn_CZ
    { 338,   0,   0 }, { 338, 121, 147 }, // ctd -> ctd_Pauc_MM
    { 219,   0,   0 }, { 219,   2, 178 }, // cu -> cu_Cyrl_RU
    { 219,  52,   0 }, { 219,  52,  33 }, // cu_Glag -> cu_Glag_BG
    { 220,   0,   0 }, { 220,   2, 178 }, // cv -> cv_Cyrl_RU
    { 134,   0,   0 }, { 134,   7, 224 }, // cy -> cy_Latn_GB
    {  29,   0,   0 }, {  29,   7,  58 }, // da -> da_Latn_DK
    { 176,   0,   0 }, { 176,   7, 111 }, // dav -> dav_Latn_KE
    {  42,   0,   0 }, {  42,   7,  82 }, // de -> de_Latn_DE
    { 239,   0,   0 }, { 239,   7, 156 }, // dje -> dje_Latn_NE
    { 275,   0,   0 }, { 275,   1, 100 }, // doi -> doi_Arab_IN
    { 317,   0,   0 }, { 317,   7,  82 }, // dsb -> dsb_Latn_DE
    { 240,   0,   0 }, { 240,   7,  37 }, // dua -> dua_Latn_CM
    { 143,   0,   0 }, { 143,  29, 131 }, // dv -> dv_Thaa_MV
    { 241,   0,   0 }, { 241,   7, 187 }, // dyo -> dyo_Latn_SN
    {  16,   0,   0 }, {  16,  31,  25 }, // dz -> dz_Tibt_BT
    { 189,   0,   0 }, { 189,   7, 111 }, // ebu -> ebu_Latn_KE
    { 161,   0,   0 }, { 161,   7,  83 }, // ee -> ee_Latn_GH
    { 263,   0,   0 }, { 263,  50,  64 }, // egy -> egy_Egyp_EG
    { 277,   0,   0 }, { 277,  63, 147 }, // eky -> eky_Kali_MM
    {  43,   0,   0 }, {  43,  16,  85 }, // el -> el_Grek_GR
    {  31,   0,   0 }, {  31,   7, 225 }, // en -> en_Latn_US
    {  31,  92,   0 }, {  31,  92, 224 }, // en_Shaw -> en_Shaw_GB
    {  32,   0,   0 }, {  32,   7, 260 }, // eo -> eo_Latn_001
    { 111,   0,   0 }, { 111,   7, 197 }, // es -> es_Latn_ES
    {  33,   0,   0 }, {  33,   7,  68 }, // et -> et_Latn_EE
    { 278,   0,   0 }, { 278,  79, 106 }, // ett -> ett_Ital_IT
    {  14,   0,   0 }, {  14,   7, 197 }, // eu -> eu_Latn_ES
    { 242,   0,   0 }, { 242,   7,  37 }, // ewo -> ewo_Latn_CM
    {  89,   0,   0 }, {  89,   1, 102 }, // fa -> fa_Arab_IR
    { 177,   0,   0 }, { 177,   7, 187 }, // ff -> ff_Latn_SN
    { 177, 134,   0 }, { 177, 134,  91 }, // ff_Adlm -> ff_Adlm_GN
    {  36,   0,   0 }, {  36,   7,  73 }, // fi -> fi_Latn_FI
    { 166,   0,   0 }, { 166,   7, 170 }, // fil -> fil_Latn_PH
    {  35,   0,   0 }, {  35,   7,  72 }, // fj -> fj_Latn_FJ
    {  34,   0,   0 }, {  34,   7,  71 }, // fo -> fo_Latn_FO
    {  37,   0,   0 }, {  37,   7,  74 }, // fr -> fr_Latn_FR
    { 159,   0,   0 }, { 159,   7, 106 }, // fur -> fur_Latn_IT
    {  38,   0,   0 }, {  38,   7, 151 }, // fy -> fy_Latn_NL
    {  57,   0,   0 }, {  57,   7, 104 }, // ga -> ga_Latn_IE
    { 148,   0,   0 }, { 148,   7,  83 }, // gaa -> gaa_Latn_GH
    {  39,   0,   0 }, {  39,   7, 224 }, // gd -> gd_Latn_GB
    { 153,   0,   0 }, { 153,  14,  69 }, // gez -> gez_Ethi_ET
    {  40,   0,   0 }, {  40,   7, 197 }, // gl -> gl_Latn_ES
    {  45,   0,   0 }, {  45,   7, 168 }, // gn -> gn_Latn_PY
    { 279,   0,   0 }, { 279,  53, 222 }, // got -> got_Goth_UA
    { 264,   0,   0 }, { 264,  49,  56 }, // grc -> grc_Cprt_CY
    { 264,  68,   0 }, { 264,  68,  85 }, // grc_Linb -> grc_Linb_GR
    { 167,   0,   0 }, { 167,   7, 206 }, // gsw -> gsw_Latn_CH
    {  46,   0,   0 }, {  46,  17, 100 }, // gu -> gu_Gujr_IN
    { 175,   0,   0 }, { 175,   7, 111 }, // guz -> guz_Latn_KE
    { 144,   0,   0 }, { 144,   7, 251 }, // gv -> gv_Latn_IM
    {  47,   0,   0 }, {  47,   7, 157 }, // ha -> ha_Latn_NG
    {  47,   0,  37 }, {  47,   1,  37 }, // ha_CM -> ha_Arab_CM
    {  47,   0, 201 }, {  47,   1, 201 }, // ha_SD -> ha_Arab_SD
    { 163,   0,   0 }, { 163,   7, 225 }, // haw -> haw_Latn_US
    {  48,   0,   0 }, {  48,  18, 105 }, // he -> he_Hebr_IL
    {  49,   0,   0 }, {  49,  13, 100 }, // hi -> hi_Deva_IN
    { 344,   0,   0 }, { 344, 129, 217 }, // hlu -> hlu_Hluw_TR
    { 282,   0,   0 }, { 282,  86,  44 }, // hmd -> hmd_Plrd_CN
    { 333,   0,   0 }, { 333, 110, 117 }, // hnj -> hnj_Hmng_LA
    { 280,   0,   0 }, { 280,   7, 170 }, // hnn -> hnn_Latn_PH
    { 224,   0,   0 }, { 224,   7, 167 }, // ho -> ho_Latn_PG
    { 334,   0,   0 }, { 334,  13, 100 }, // hoc -> hoc_Deva_IN
    {  27,   0,   0 }, {  27,   7,  54 }, // hr -> hr_Latn_HR
    { 318,   0,   0 }, { 318,   7,  82 }, // hsb -> hsb_Latn_DE
    { 222,   0,   0 }, { 222,   7,  94 }, // ht -> ht_Latn_HT
    {  50,   0,   0 }, {  50,   7,  98 }, // hu -> hu_Latn_HU
    {   9,   0,   0 }, {   9,  10,  11 }, // hy -> hy_Armn_AM
    { 223,   0,   0 }, { 223,   7, 148 }, // hz -> hz_Latn_NA
    {  53,   0,   0 }, {  53,   7,  74 }, // ia -> ia_Latn_FR
    {  52,   0,   0 }, {  52,   7, 101 }, // id -> id_Latn_ID
    { 149,   0,   0 }, { 149,   7, 157 }, // ig -> ig_Latn_NG
    { 168,   0,   0 }, { 168,  34,  44 }, // ii -> ii_Yiii_CN
    {  56,   0,   0 }, {  56,   7, 225 }, // ik -> ik_Latn_US
    { 281,   0,   0 }, { 281,   2, 178 }, // inh -> inh_Cyrl_RU
    {  51,   0,   0 }, {  51,   7,  99 }, // is -> is_Latn_IS
    {  58,   0,   0 }, {  58,   7, 106 }, // it -> it_Latn_IT
    {  55,   0,   0 }, {  55,  44,  38 }, // iu -> iu_Cans_CA
    {  59,   0,   0 }, {  59,  19, 108 }, // ja -> ja_Jpan_JP
    { 257,   0,   0 }, { 257,   7,  37 }, // jgo -> jgo_Latn_CM
    { 200,   0,   0 }, { 200,   7, 210 }, // jmc -> jmc_Latn_TZ
    {  60,   0,   0 }, {  60,   7, 101 }, // jv -> jv_Latn_ID
    {  41,   0,   0 }, {  41,  15,  81 }, // ka -> ka_Geor_GE
    { 184,   0,   0 }, { 184,   7,   3 }, // kab -> kab_Latn_DZ
    { 158,   0,   0 }, { 158,   7, 157 }, // kaj -> kaj_Latn_NG
    { 150,   0,   0 }, { 150,   7, 111 }, // kam -> kam_Latn_KE
    { 164,   0,   0 }, { 164,   7, 157 }, // kcg -> kcg_Latn_NG
    { 192,   0,   0 }, { 192,   7, 210 }, // kde -> kde_Latn_TZ
    { 196,   0,   0 }, { 196,   7,  39 }, // kea -> kea_Latn_CV
    { 319,   0,   0 }, { 319,   7,  37 }, // ken -> ken_Latn_CM
    { 154,   0,   0 }, { 154,   7,  53 }, // kfo -> kfo_Latn_CI
    { 227,   0,   0 }, { 227,   7,  49 }, // kg -> kg_Latn_CD
    { 286,   0,   0 }, { 286,  76,  44 }, // khb -> khb_Talu_CN
    { 208,   0,   0 }, { 208,   7, 132 }, // khq -> khq_Latn_ML
    { 178,   0,   0 }, { 178,   7, 111 }, // ki -> ki_Latn_KE
    { 228,   0,   0 }, { 228,   7, 148 }, // kj -> kj_Latn_NA
    {  63,   0,   0 }, {  63,   2, 110 }, // kk -> kk_Cyrl_KZ
    {  63,   0,   1 }, {  63,   1,   1 }, // kk_AF -> kk_Arab_AF
    {  63,   0,  44 }, {  63,   1,  44 }, // kk_CN -> kk_Arab_CN
    {  63,   0, 102 }, {  63,   1, 102 }, // kk_IR -> kk_Arab_IR
    {  63,   0, 143 }, {  63,   1, 143 }, // kk_MN -> kk_Arab_MN
    {  63,   1,   0 }, {  63,   1,  44 }, // kk_Arab -> kk_Arab_CN
    { 258,   0,   0 }, { 258,   7,  37 }, // kkj -> kkj_Latn_CM
    {  44,   0,   0 }, {  44,   7,  86 }, // kl -> kl_Latn_GL
    { 198,   0,   0 }, { 198,   7, 111 }, // kln -> kln_Latn_KE
    {  23,   0,   0 }, {  23,  20,  36 }, // km -> km_Khmr_KH
    {  61,   0,   0 }, {  61,  21, 100 }, // kn -> kn_Knda_IN
    {  66,   0,   0 }, {  66,  22, 114 }, // ko -> ko_Kore_KR
    { 147,   0,   0 }, { 147,  13, 100 }, // kok -> kok_Deva_IN
    { 169,   0,   0 }, { 169,   7, 121 }, // kpe -> kpe_Latn_LR
    { 225,   0,   0 }, { 225,   7,   0 }, // kr -> kr_Latn
    {  62,   0,   0 }, {  62,   1, 100 }, // ks -> ks_Arab_IN
    { 214,   0,   0 }, { 214,   7, 210 }, // ksb -> ksb_Latn_TZ
    { 243,   0,   0 }, { 243,   7,  37 }, // ksf -> ksf_Latn_CM
    { 201,   0,   0 }, { 201,   7,  82 }, // ksh -> ksh_Latn_DE
    {  67,   0,   0 }, {  67,   7, 217 }, // ku -> ku_Latn_TR
    {  67,   0, 119 }, {  67,   1, 119 }, // ku_LB -> ku_Arab_LB
    {  67,   1,   0 }, {  67,   1, 103 }, // ku_Arab -> ku_Arab_IQ
    { 226,   0,   0 }, { 226,   2, 178 }, // kv -> kv_Cyrl_RU
    { 145,   0,   0 }, { 145,   7, 224 }, // kw -> kw_Latn_GB
    {  65,   0,   0 }, {  65,   2, 116 }, // ky -> ky_Cyrl_KG
    {  65,   0,  44 }, {  65,   1,  44 }, // ky_CN -> ky_Arab_CN
    {  65,   0, 217 }, {  65,   7, 217 }, // ky_TR -> ky_Latn_TR
    {  65,   1,   0 }, {  65,   1,  44 }, // ky_Arab -> ky_Arab_CN
    {  65,   7,   0 }, {  65,   7, 217 }, // ky_Latn -> ky_Latn_TR
    {  70,   0,   0 }, {  70,   7, 230 }, // la -> la_Latn_VA
    { 332,   0,   0 }, { 332, 112,  85 }, // lab -> lab_Lina_GR
    { 193,   0,   0 }, { 193,   7, 210 }, // lag -> lag_Latn_TZ
    { 231,   0,   0 }, { 231,   7, 125 }, // lb -> lb_Latn_LU
    { 283,   0,   0 }, { 283,  66, 100 }, // lep -> lep_Lepc_IN
    { 335,   0,   0 }, { 335,   2, 178 }, // lez -> lez_Cyrl_RU
    { 194,   0,   0 }, { 194,   7, 221 }, // lg -> lg_Latn_UG
    { 229,   0,   0 }, { 229,   7, 151 }, // li -> li_Latn_NL
    { 284,   0,   0 }, { 284,  13, 150 }, // lif -> lif_Deva_NP
    { 284,  67,   0 }, { 284,  67, 100 }, // lif_Limb -> lif_Limb_IN
    { 285,   0,   0 }, { 285,  51,  44 }, // lis -> lis_Lisu_CN
    { 313,   0,   0 }, { 313,   7, 225 }, // lkt -> lkt_Latn_US
    {  72,   0,   0 }, {  72,   7,  49 }, // ln -> ln_Latn_CD
    {  69,   0,   0 }, {  69,  23, 117 }, // lo -> lo_Laoo_LA
    { 349,   0,   0 }, { 349,   1, 102 }, // lrc -> lrc_Arab_IR
    {  73,   0,   0 }, {  73,   7, 124 }, // lt -> lt_Latn_LT
    { 230,   0,   0 }, { 230,   7,  49 }, // lu -> lu_Latn_CD
    { 210,   0,   0 }, { 210,   7, 111 }, // luo -> luo_Latn_KE
    { 204,   0,   0 }, { 204,   7, 111 }, // luy -> luy_Latn_KE
    {  71,   0,   0 }, {  71,   7, 118 }, // lv -> lv_Latn_LV
    { 345,   0,   0 }, { 345,   5,  44 }, // lzh -> lzh_Hans_CN
    { 339,   0,   0 }, { 339,  13, 100 }, // mai -> mai_Deva_IN
    { 289,   0,   0 }, { 289,   7,  80 }, // man -> man_Latn_GM
    { 289,   0,  91 }, { 289,  75,  91 }, // man_GN -> man_Nkoo_GN
    { 289,  75,   0 }, { 289,  75,  91 }, // man_Nkoo -> man_Nkoo_GN
    { 202,   0,   0 }, { 202,   7, 111 }, // mas -> mas_Latn_KE
    { 330,   0,   0 }, { 330,   7, 189 }, // men -> men_Latn_SL
    { 197,   0,   0 }, { 197,   7, 111 }, // mer -> mer_Latn_KE
    { 191,   0,   0 }, { 191,   7, 137 }, // mfe -> mfe_Latn_MU
    {  75,   0,   0 }, {  75,   7, 128 }, // mg -> mg_Latn_MG
    { 244,   0,   0 }, { 244,   7, 146 }, // mgh -> mgh_Latn_MZ
    { 259,   0,   0 }, { 259,   7,  37 }, // mgo -> mgo_Latn_CM
    {  81,   0,   0 }, {  81,   7, 134 }, // mh -> mh_Latn_MH
    {  79,   0,   0 }, {  79,   7, 154 }, // mi -> mi_Latn_NZ
    { 356,   0,   0 }, { 356, 130, 103 }, // mis -> mis_Hatr_IQ
    {  74,   0,   0 }, {  74,   2, 127 }, // mk -> mk_Cyrl_MK
    {  77,   0,   0 }, {  77,  24, 100 }, // ml -> ml_Mlym_IN
    {  82,   0,   0 }, {  82,   2, 143 }, // mn -> mn_Cyrl_MN
    {  82,   0,  44 }, {  82,   8,  44 }, // mn_CN -> mn_Mong_CN
    {  82,   8,   0 }, {  82,   8,  44 }, // mn_Mong -> mn_Mong_CN
    { 290,   0,   0 }, { 290,  11, 100 }, // mni -> mni_Beng_IN
    { 320,   0,   0 }, { 320,   7,  38 }, // moh -> moh_Latn_CA
    {  80,   0,   0 }, {  80,  13, 100 }, // mr -> mr_Deva_IN
    { 347,   0,   0 }, { 347, 117,  18 }, // mro -> mro_Mroo_BD
    {  76,   0,   0 }, {  76,   7, 130 }, // ms -> ms_Latn_MY
    {  76,   0,  46 }, {  76,   1,  46 }, // ms_CC -> ms_Arab_CC
    {  76,   0, 101 }, {  76,   1, 101 }, // ms_ID -> ms_Arab_ID
    {  78,   0,   0 }, {  78,   7, 133 }, // mt -> mt_Latn_MT
    { 245,   0,   0 }, { 245,   7,  37 }, // mua -> mua_Latn_CM
    {  21,   0,   0 }, {  21,  25, 147 }, // my -> my_Mymr_MM
    { 273,   0,   0 }, { 273,  71, 102 }, // myz -> myz_Mand_IR
    { 346,   0,   0 }, { 346,   1, 102 }, // mzn -> mzn_Arab_IR
    {  83,   0,   0 }, {  83,   7, 149 }, // na -> na_Latn_NR
    { 199,   0,   0 }, { 199,   7, 148 }, // naq -> naq_Latn_NA
    {  85,   0,   0 }, {  85,   7, 161 }, // nb -> nb_Latn_NO
    { 181,   0,   0 }, { 181,   7, 240 }, // nd -> nd_Latn_ZW
    { 170,   0,   0 }, { 170,   7,  82 }, // nds -> nds_Latn_DE
    {  84,   0,   0 }, {  84,  13, 150 }, // ne -> ne_Deva_NP
    { 348,   0,   0 }, { 348,  13, 150 }, // new -> new_Deva_NP
    { 233,   0,   0 }, { 233,   7, 148 }, // ng -> ng_Latn_NA
    {  30,   0,   0 }, {  30,   7, 151 }, // nl -> nl_Latn_NL
    { 246,   0,   0 }, { 246,   7,  37 }, // nmg -> nmg_Latn_CM
    { 141,   0,   0 }, { 141,   7, 161 }, // nn -> nn_Latn_NO
    { 260,   0,   0 }, { 260,   7,  37 }, // nnh -> nnh_Latn_CM
    { 292,   0,   0 }, { 292,  65, 211 }, // nod -> nod_Lana_TH
    { 294,   0,   0 }, { 294,  88, 205 }, // non -> non_Runr_SE
    { 321,   0,   0 }, { 321,  75,  91 }, // nqo -> nqo_Nkoo_GN
    { 171,   0,   0 }, { 171,   7, 195 }, // nr -> nr_Latn_ZA
    { 172,   0,   0 }, { 172,   7, 195 }, // nso -> nso_Latn_ZA
    { 247,   0,   0 }, { 247,   7, 254 }, // nus -> nus_Latn_SS
    { 232,   0,   0 }, { 232,   7, 225 }, // nv -> nv_Latn_US
    { 165,   0,   0 }, { 165,   7, 129 }, // ny -> ny_Latn_MW
    { 185,   0,   0 }, { 185,   7, 221 }, // nyn -> nyn_Latn_UG
    {  86,   0,   0 }, {  86,   7,  74 }, // oc -> oc_Latn_FR
    {   3,   0,   0 }, {   3,   7,  69 }, // om -> om_Latn_ET
    {  87,   0,   0 }, {  87,  26, 100 }, // or -> or_Orya_IN
    { 101,   0,   0 }, { 101,   2,  81 }, // os -> os_Cyrl_GE
    { 358,   0,   0 }, { 358, 138, 225 }, // osa -> osa_Osge_US
    { 296,   0,   0 }, { 296,  82, 143 }, // otk -> otk_Orkh_MN
    {  92,   0,   0 }, {  92,   4, 100 }, // pa -> pa_Guru_IN
    {  92,   0, 163 }, {  92,   1, 163 }, // pa_PK -> pa_Arab_PK
    {  92,   1,   0 }, {  92,   1, 163 }, // pa_Arab -> pa_Arab_PK
    { 297,   0,   0 }, { 297,  58, 102 }, // pal -> pal_Phli_IR
    { 297, 123,   0 }, { 297, 123,  44 }, // pal_Phlp -> pal_Phlp_CN
    { 351,   0,   0 }, { 351,   7,  12 }, // pap -> pap_Latn_AW
    { 350,   0,   0 }, { 350,   7, 164 }, // pau -> pau_Latn_PW
    { 295,   0,   0 }, { 295,  80, 102 }, // peo -> peo_Xpeo_IR
    { 299,   0,   0 }, { 299,  85, 119 }, // phn -> phn_Phnx_LB
    { 342,   0,   0 }, { 342,  41, 100 }, // pka -> pka_Brah_IN
    {  90,   0,   0 }, {  90,   7, 172 }, // pl -> pl_Latn_PL
    { 300,   0,   0 }, { 300,  64, 163 }, // pra -> pra_Khar_PK
    { 322,   0,   0 }, { 322,   7, 260 }, // prg -> prg_Latn_001
    {  88,   0,   0 }, {  88,   1,   1 }, // ps -> ps_Arab_AF
    {  91,   0,   0 }, {  91,   7,  30 }, // pt -> pt_Latn_BR
    {  93,   0,   0 }, {  93,   7, 169 }, // qu -> qu_Latn_PE
    { 323,   0,   0 }, { 323,   7,  90 }, // quc -> quc_Latn_GT
    { 301,   0,   0 }, { 301,   7, 101 }, // rej -> rej_Latn_ID
    {  94,   0,   0 }, {  94,   7, 206 }, // rm -> rm_Latn_CH
    {  68,   0,   0 }, {  68,   7,  35 }, // rn -> rn_Latn_BI
    {  95,   0,   0 }, {  95,   7, 177 }, // ro -> ro_Latn_RO
    { 182,   0,   0 }, { 182,   7, 210 }, // rof -> rof_Latn_TZ
    {  96,   0,   0 }, {  96,   2, 178 }, // ru -> ru_Cyrl_RU
    {  64,   0,   0 }, {  64,   7, 179 }, // rw -> rw_Latn_RW
    { 209,   0,   0 }, { 209,   7, 210 }, // rwk -> rwk_Latn_TZ
    {  99,   0,   0 }, {  99,  13, 100 }, // sa -> sa_Deva_IN
    { 248,   0,   0 }, { 248,   2, 178 }, // sah -> sah_Cyrl_RU
    { 179,   0,   0 }, { 179,   7, 111 }, // saq -> saq_Latn_KE
    { 304,   0,   0 }, { 304,   7, 100 }, // sat -> sat_Latn_IN
    { 305,   0,   0 }, { 305,  90, 100 }, // saz -> saz_Saur_IN
    { 249,   0,   0 }, { 249,   7, 210 }, // sbp -> sbp_Latn_TZ
    { 115,   0,   0 }, { 115,   7, 106 }, // sc -> sc_Latn_IT
    { 105,   0,   0 }, { 105,   1, 163 }, // sd -> sd_Arab_PK
    { 105,  13,   0 }, { 105,  13, 100 }, // sd_Deva -> sd_Deva_IN
    { 105, 111,   0 }, { 105, 111, 100 }, // sd_Khoj -> sd_Khoj_IN
    { 105, 125,   0 }, { 105, 125, 100 }, // sd_Sind -> sd_Sind_IN
    { 173,   0,   0 }, { 173,   7, 161 }, // se -> se_Latn_NO
    { 180,   0,   0 }, { 180,   7, 146 }, // seh -> seh_Latn_MZ
    { 213,   0,   0 }, { 213,   7, 132 }, // ses -> ses_Latn_ML
    {  98,   0,   0 }, {  98,   7,  41 }, // sg -> sg_Latn_CF
    { 293,   0,   0 }, { 293,  77, 104 }, // sga -> sga_Ogam_IE
    { 183,   0,   0 }, { 183,   9, 145 }, // shi -> shi_Tfng_MA
    { 106,   0,   0 }, { 106,  32, 198 }, // si -> si_Sinh_LK
    { 155,   0,   0 }, { 155,   7,  69 }, // sid -> sid_Latn_ET
    { 108,   0,   0 }, { 108,   7, 191 }, // sk -> sk_Latn_SK
    { 352,   0,   0 }, { 352,   1, 163 }, // skr -> skr_Arab_PK
    { 109,   0,   0 }, { 109,   7, 192 }, // sl -> sl_Latn_SI
    {  97,   0,   0 }, {  97,   7, 183 }, // sm -> sm_Latn_WS
    { 324,   0,   0 }, { 324,   7, 205 }, // sma -> sma_Latn_SE
    { 325,   0,   0 }, { 325,   7, 205 }, // smj -> smj_Latn_SE
    { 326,   0,   0 }, { 326,   7,  73 }, // smn -> smn_Latn_FI
    { 303,   0,   0 }, { 303,  89, 105 }, // smp -> smp_Samr_IL
    { 327,   0,   0 }, { 327,   7,  73 }, // sms -> sms_Latn_FI
    { 104,   0,   0 }, { 104,   7, 240 }, // sn -> sn_Latn_ZW
    { 110,   0,   0 }, { 110,   7, 194 }, // so -> so_Latn_SO
    {   6,   0,   0 }, {   6,   7,   2 }, // sq -> sq_Latn_AL
    { 100,   0,   0 }, { 100,   2, 243 }, // sr -> sr_Cyrl_RS
    { 100,   0, 242 }, { 100,   7, 242 }, // sr_ME -> sr_Latn_ME
    { 100,   0, 177 }, { 100,   7, 177 }, // sr_RO -> sr_Latn_RO
    { 100,   0, 178 }, { 100,   7, 178 }, // sr_RU -> sr_Latn_RU
    { 100,   0, 217 }, { 100,   7, 217 }, // sr_TR -> sr_Latn_TR
    { 306,   0,   0 }, { 306,  93, 100 }, // srb -> srb_Sora_IN
    { 107,   0,   0 }, { 107,   7, 195 }, // ss -> ss_Latn_ZA
    { 207,   0,   0 }, { 207,   7,  67 }, // ssy -> ssy_Latn_ER
    { 102,   0,   0 }, { 102,   7, 195 }, // st -> st_Latn_ZA
    { 112,   0,   0 }, { 112,   7, 101 }, // su -> su_Latn_ID
    { 114,   0,   0 }, { 114,   7, 205 }, // sv -> sv_Latn_SE
    { 113,   0,   0 }, { 113,   7, 210 }, // sw -> sw_Latn_TZ
    { 250,   0,   0 }, { 250,   7,  49 }, // swc -> swc_Latn_CD
    { 307,   0,   0 }, { 307,  11,  18 }, // syl -> syl_Beng_BD
    { 151,   0,   0 }, { 151,  33, 103 }, // syr -> syr_Syrc_IQ
    { 117,   0,   0 }, { 117,  27, 100 }, // ta -> ta_Taml_IN
    { 308,   0,   0 }, { 308,   7, 170 }, // tbw -> tbw_Latn_PH
    { 310,   0,   0 }, { 310,  99,  44 }, // tdd -> tdd_Tale_CN
    { 119,   0,   0 }, { 119,  28, 100 }, // te -> te_Telu_IN
    { 206,   0,   0 }, { 206,   7, 221 }, // teo -> teo_Latn_UG
    { 116,   0,   0 }, { 116,   2, 209 }, // tg -> tg_Cyrl_TJ
    { 116,   0, 163 }, { 116,   1, 163 }, // tg_PK -> tg_Arab_PK
    { 116,   1,   0 }, { 116,   1, 163 }, // tg_Arab -> tg_Arab_PK
    { 120,   0,   0 }, { 120,  30, 211 }, // th -> th_Thai_TH
    { 122,   0,   0 }, { 122,  14,  69 }, // ti -> ti_Ethi_ET
    { 157,   0,   0 }, { 157,  14,  67 }, // tig -> tig_Ethi_ER
    { 126,   0,   0 }, { 126,   7, 218 }, // tk -> tk_Latn_TM
    { 353,   0,   0 }, { 353,   7, 213 }, // tkl -> tkl_Latn_TK
    { 103,   0,   0 }, { 103,   7, 195 }, // tn -> tn_Latn_ZA
    { 123,   0,   0 }, { 123,   7, 214 }, // to -> to_Latn_TO
    { 354,   0,   0 }, { 354,   7, 167 }, // tpi -> tpi_Latn_PG
    { 125,   0,   0 }, { 125,   7, 217 }, // tr -> tr_Latn_TR
    { 174,   0,   0 }, { 174,   7, 208 }, // trv -> trv_Latn_TW
    { 124,   0,   0 }, { 124,   7, 195 }, // ts -> ts_Latn_ZA
    { 118,   0,   0 }, { 118,   2, 178 }, // tt -> tt_Cyrl_RU
    { 355,   0,   0 }, { 355,   7, 220 }, // tvl -> tvl_Latn_TV
    { 251,   0,   0 }, { 251,   7, 156 }, // twq -> twq_Latn_NE
    { 359,   0,   0 }, { 359, 139,  44 }, // txg -> txg_Tang_CN
    { 127,   0,   0 }, { 127,   7,  77 }, // ty -> ty_Latn_PF
    { 212,   0,   0 }, { 212,   7, 145 }, // tzm -> tzm_Latn_MA
    { 128,   0,   0 }, { 128,   1,  44 }, // ug -> ug_Arab_CN
    { 128,   0, 110 }, { 128,   2, 110 }, // ug_KZ -> ug_Cyrl_KZ
    { 128,   0, 143 }, { 128,   2, 143 }, // ug_MN -> ug_Cyrl_MN
    { 128,   2,   0 }, { 128,   2, 110 }, // ug_Cyrl -> ug_Cyrl_KZ
    { 311,   0,   0 }, { 311, 102, 207 }, // uga -> uga_Ugar_SY
    { 129,   0,   0 }, { 129,   2, 222 }, // uk -> uk_Cyrl_UA
    { 130,   0,   0 }, { 130,   1, 163 }, // ur -> ur_Arab_PK
    { 131,   0,   0 }, { 131,   7, 228 }, // uz -> uz_Latn_UZ
    { 131,   0,   1 }, { 131,   1,   1 }, // uz_AF -> uz_Arab_AF
    { 131,   0,  44 }, { 131,   2,  44 }, // uz_CN -> uz_Cyrl_CN
    { 131,   1,   0 }, { 131,   1,   1 }, // uz_Arab -> uz_Arab_AF
    { 252,   0,   0 }, { 252,  35, 121 }, // vai -> vai_Vaii_LR
    { 160,   0,   0 }, { 160,   7, 195 }, // ve -> ve_Latn_ZA
    { 132,   0,   0 }, { 132,   7, 232 }, // vi -> vi_Latn_VN
    { 133,   0,   0 }, { 133,   7, 260 }, // vo -> vo_Latn_001
    { 187,   0,   0 }, { 187,   7, 210 }, // vun -> vun_Latn_TZ
    { 236,   0,   0 }, { 236,   7,  21 }, // wa -> wa_Latn_BE
    { 253,   0,   0 }, { 253,   7, 206 }, // wae -> wae_Latn_CH
    { 162,   0,   0 }, { 162,  14,  69 }, // wal -> wal_Ethi_ET
    { 328,   0,   0 }, { 328,   7,  13 }, // wbp -> wbp_Latn_AU
    { 135,   0,   0 }, { 135,   7, 187 }, // wo -> wo_Latn_SN
    { 271,   0,   0 }, { 271,  45, 217 }, // xcr -> xcr_Cari_TR
    { 136,   0,   0 }, { 136,   7, 195 }, // xh -> xh_Latn_ZA
    { 287,   0,   0 }, { 287,  69, 217 }, // xlc -> xlc_Lyci_TR
    { 288,   0,   0 }, { 288,  70, 217 }, // xld -> xld_Lydi_TR
    { 329,   0,   0 }, { 329, 114,  44 }, // xmn -> xmn_Mani_CN
    { 291,   0,   0 }, { 291,  74, 201 }, // xmr -> xmr_Merc_SD
    { 331,   0,   0 }, { 331, 118, 186 }, // xna -> xna_Narb_SA
    { 203,   0,   0 }, { 203,   7, 221 }, // xog -> xog_Latn_UG
    { 298,   0,   0 }, { 298,  59, 102 }, // xpr -> xpr_Prti_IR
    { 302,   0,   0 }, { 302,  81, 237 }, // xsa -> xsa_Sarb_YE
    { 254,   0,   0 }, { 254,   7,  37 }, // yav -> yav_Latn_CM
    { 137,   0,   0 }, { 137,  18, 260 }, // yi -> yi_Hebr_001
    { 138,   0,   0 }, { 138,   7, 157 }, // yo -> yo_Latn_NG
    { 357,   0,   0 }, { 357,   6,  97 }, // yue -> yue_Hant_HK
    { 357,   0,  44 }, { 357,   5,  44 }, // yue_CN -> yue_Hans_CN
    { 357,   5,   0 }, { 357,   5,  44 }, // yue_Hans -> yue_Hans_CN
    { 139,   0,   0 }, { 139,   7,  44 }, // za -> za_Latn_CN
    { 314,   0,   0 }, { 314,   9, 145 }, // zgh -> zgh_Tfng_MA
    {  25,   0,   0 }, {  25,   5,  44 }, // zh -> zh_Hans_CN
    {  25,   0,  13 }, {  25,   6,  13 }, // zh_AU -> zh_Hant_AU
    {  25,   0,  32 }, {  25,   6,  32 }, // zh_BN -> zh_Hant_BN
    {  25,   0, 224 }, {  25,   6, 224 }, // zh_GB -> zh_Hant_GB
    {  25,   0,  76 }, {  25,   6,  76 }, // zh_GF -> zh_Hant_GF
    {  25,   0,  97 }, {  25,   6,  97 }, // zh_HK -> zh_Hant_HK
    {  25,   0, 101 }, {  25,   6, 101 }, // zh_ID -> zh_Hant_ID
    {  25,   0, 126 }, {  25,   6, 126 }, // zh_MO -> zh_Hant_MO
    {  25,   0, 130 }, {  25,   6, 130 }, // zh_MY -> zh_Hant_MY
    {  25,   0, 166 }, {  25,   6, 166 }, // zh_PA -> zh_Hant_PA
    {  25,   0,  77 }, {  25,   6,  77 }, // zh_PF -> zh_Hant_PF
    {  25,   0, 170 }, {  25,   6, 170 }, // zh_PH -> zh_Hant_PH
    {  25,   0, 202 }, {  25,   6, 202 }, // zh_SR -> zh_Hant_SR
    {  25,   0, 211 }, {  25,   6, 211 }, // zh_TH -> zh_Hant_TH
    {  25,   0, 208 }, {  25,   6, 208 }, // zh_TW -> zh_Hant_TW
    {  25,   0, 225 }, {  25,   6, 225 }, // zh_US -> zh_Hant_US
    {  25,   0, 232 }, {  25,   6, 232 }, // zh_VN -> zh_Hant_VN
    {  25,  40,   0 }, {  25,  40, 208 }, // zh_Bopo -> zh_Bopo_TW
    {  25, 140,   0 }, {  25, 140, 208 }, // zh_Hanb -> zh_Hanb_TW
    {  25,   6,   0 }, {  25,   6, 208 }, // zh_Hant -> zh_Hant_TW
    { 140,   0,   0 }, { 140,   7, 195 }, // zu -> zu_Latn_ZA
    {   0,   0, 261 }, {  96,   2, 178 }, // und_150 -> ru_Cyrl_RU
    {   0,   0, 246 }, { 111,   7, 246 }, // und_419 -> es_Latn_419
    {   0,   0,   5 }, {  24,   7,   5 }, // und_AD -> ca_Latn_AD
    {   0,   0, 223 }, {   8,   1, 223 }, // und_AE -> ar_Arab_AE
    {   0,   0,   1 }, {  89,   1,   1 }, // und_AF -> fa_Arab_AF
    {   0,   0,   2 }, {   6,   7,   2 }, // und_AL -> sq_Latn_AL
    {   0,   0,  11 }, {   9,  10,  11 }, // und_AM -> hy_Armn_AM
    {   0,   0,   6 }, {  91,   7,   6 }, // und_AO -> pt_Latn_AO
    {   0,   0,   8 }, {   0,   7,   8 }, // und_AQ -> und_Latn_AQ
    {   0,   0,  10 }, { 111,   7,  10 }, // und_AR -> es_Latn_AR
    {   0,   0,   4 }, {  97,   7,   4 }, // und_AS -> sm_Latn_AS
    {   0,   0,  14 }, {  42,   7,  14 }, // und_AT -> de_Latn_AT
    {   0,   0,  12 }, {  30,   7,  12 }, // und_AW -> nl_Latn_AW
    {   0,   0, 248 }, { 114,   7, 248 }, // und_AX -> sv_Latn_AX
    {   0,   0,  15 }, {  12,   7,  15 }, // und_AZ -> az_Latn_AZ
    {   0,   0,  27 }, { 142,   7,  27 }, // und_BA -> bs_Latn_BA
    {   0,   0,  18 }, {  15,  11,  18 }, // und_BD -> bn_Beng_BD
    {   0,   0,  21 }, {  30,   7,  21 }, // und_BE -> nl_Latn_BE
    {   0,   0,  34 }, {  37,   7,  34 }, // und_BF -> fr_Latn_BF
    {   0,   0,  33 }, {  20,   2,  33 }, // und_BG -> bg_Cyrl_BG
    {   0,   0,  17 }, {   8,   1,  17 }, // und_BH -> ar_Arab_BH
    {   0,   0,  35 }, {  68,   7,  35 }, // und_BI -> rn_Latn_BI
    {   0,   0,  23 }, {  37,   7,  23 }, // und_BJ -> fr_Latn_BJ
    {   0,   0, 244 }, {  37,   7, 244 }, // und_BL -> fr_Latn_BL
    {   0,   0,  32 }, {  76,   7,  32 }, // und_BN -> ms_Latn_BN
    {   0,   0,  26 }, { 111,   7,  26 }, // und_BO -> es_Latn_BO
    {   0,   0, 255 }, { 351,   7, 255 }, // und_BQ -> pap_Latn_BQ
    {   0,   0,  30 }, {  91,   7,  30 }, // und_BR -> pt_Latn_BR
    {   0,   0,  25 }, {  16,  31,  25 }, // und_BT -> dz_Tibt_BT
    {   0,   0,  29 }, {   0,   7,  29 }, // und_BV -> und_Latn_BV
    {   0,   0,  20 }, {  22,   2,  20 }, // und_BY -> be_Cyrl_BY
    {   0,   0,  49 }, { 113,   7,  49 }, // und_CD -> sw_Latn_CD
    {   0,   0,  41 }, {  37,   7,  41 }, // und_CF -> fr_Latn_CF
    {   0,   0,  50 }, {  37,   7,  50 }, // und_CG -> fr_Latn_CG
    {   0,   0, 206 }, {  42,   7, 206 }, // und_CH -> de_Latn_CH
    {   0,   0,  53 }, {  37,   7,  53 }, // und_CI -> fr_Latn_CI
    {   0,   0,  43 }, { 111,   7,  43 }, // und_CL -> es_Latn_CL
    {   0,   0,  37 }, {  37,   7,  37 }, // und_CM -> fr_Latn_CM
    {   0,   0,  44 }, {  25,   5,  44 }, // und_CN -> zh_Hans_CN
    {   0,   0,  47 }, { 111,   7,  47 }, // und_CO -> es_Latn_CO
    {   0,   0, 241 }, {   0,   7, 241 }, // und_CP -> und_Latn_CP
    {   0,   0,  52 }, { 111,   7,  52 }, // und_CR -> es_Latn_CR
    {   0,   0,  55 }, { 111,   7,  55 }, // und_CU -> es_Latn_CU
    {   0,   0,  39 }, {  91,   7,  39 }, // und_CV -> pt_Latn_CV
    {   0,   0, 152 }, { 351,   7, 152 }, // und_CW -> pap_Latn_CW
    {   0,   0,  56 }, {  43,  16,  56 }, // und_CY -> el_Grek_CY
    {   0,   0,  57 }, {  28,   7,  57 }, // und_CZ -> cs_Latn_CZ
    {   0,   0,  82 }, {  42,   7,  82 }, // und_DE -> de_Latn_DE
    {   0,   0,  59 }, {   4,   7,  59 }, // und_DJ -> aa_Latn_DJ
    {   0,   0,  58 }, {  29,   7,  58 }, // und_DK -> da_Latn_DK
    {   0,   0,  61 }, { 111,   7,  61 }, // und_DO -> es_Latn_DO
    {   0,   0,   3 }, {   8,   1,   3 }, // und_DZ -> ar_Arab_DZ
    {   0,   0, 250 }, { 111,   7, 250 }, // und_EA -> es_Latn_EA
    {   0,   0,  63 }, { 111,   7,  63 }, // und_EC -> es_Latn_EC
    {   0,   0,  68 }, {  33,   7,  68 }, // und_EE -> et_Latn_EE
    {   0,   0,  64 }, {   8,   1,  64 }, // und_EG -> ar_Arab_EG
    {   0,   0, 236 }, {   8,   1, 236 }, // und_EH -> ar_Arab_EH
    {   0,   0,  67 }, { 122,  14,  67 }, // und_ER -> ti_Ethi_ER
    {   0,   0, 197 }, { 111,   7, 197 }, // und_ES -> es_Latn_ES
    {   0,   0,  69 }, {   7,  14,  69 }, // und_ET -> am_Ethi_ET
    {   0,   0, 258 }, {  31,   7, 224 }, // und_EU -> en_Latn_GB
    {   0,   0,  73 }, {  36,   7,  73 }, // und_FI -> fi_Latn_FI
    {   0,   0,  71 }, {  34,   7,  71 }, // und_FO -> fo_Latn_FO
    {   0,   0,  74 }, {  37,   7,  74 }, // und_FR -> fr_Latn_FR
    {   0,   0,  79 }, {  37,   7,  79 }, // und_GA -> fr_Latn_GA
    {   0,   0,  81 }, {  41,  15,  81 }, // und_GE -> ka_Geor_GE
    {   0,   0,  76 }, {  37,   7,  76 }, // und_GF -> fr_Latn_GF
    {   0,   0,  83 }, { 146,   7,  83 }, // und_GH -> ak_Latn_GH
    {   0,   0,  86 }, {  44,   7,  86 }, // und_GL -> kl_Latn_GL
    {   0,   0,  91 }, {  37,   7,  91 }, // und_GN -> fr_Latn_GN
    {   0,   0,  88 }, {  37,   7,  88 }, // und_GP -> fr_Latn_GP
    {   0,   0,  66 }, { 111,   7,  66 }, // und_GQ -> es_Latn_GQ
    {   0,   0,  85 }, {  43,  16,  85 }, // und_GR -> el_Grek_GR
    {   0,   0, 196 }, {   0,   7, 196 }, // und_GS -> und_Latn_GS
    {   0,   0,  90 }, { 111,   7,  90 }, // und_GT -> es_Latn_GT
    {   0,   0,  92 }, {  91,   7,  92 }, // und_GW -> pt_Latn_GW
    {   0,   0,  97 }, {  25,   6,  97 }, // und_HK -> zh_Hant_HK
    {   0,   0,  95 }, {   0,   7,  95 }, // und_HM -> und_Latn_HM
    {   0,   0,  96 }, { 111,   7,  96 }, // und_HN -> es_Latn_HN
    {   0,   0,  54 }, {  27,   7,  54 }, // und_HR -> hr_Latn_HR
    {   0,   0,  94 }, { 222,   7,  94 }, // und_HT -> ht_Latn_HT
    {   0,   0,  98 }, {  50,   7,  98 }, // und_HU -> hu_Latn_HU
    {   0,   0, 238 }, { 111,   7, 238 }, // und_IC -> es_Latn_IC
    {   0,   0, 101 }, {  52,   7, 101 }, // und_ID -> id_Latn_ID
    {   0,   0, 105 }, {  48,  18, 105 }, // und_IL -> he_Hebr_IL
    {   0,   0, 100 }, {  49,  13, 100 }, // und_IN -> hi_Deva_IN
    {   0,   0, 103 }, {   8,   1, 103 }, // und_IQ -> ar_Arab_IQ
    {   0,   0, 102 }, {  89,   1, 102 }, // und_IR -> fa_Arab_IR
    {   0,   0,  99 }, {  51,   7,  99 }, // und_IS -> is_Latn_IS
    {   0,   0, 106 }, {  58,   7, 106 }, // und_IT -> it_Latn_IT
    {   0,   0, 109 }, {   8,   1, 109 }, // und_JO -> ar_Arab_JO
    {   0,   0, 108 }, {  59,  19, 108 }, // und_JP -> ja_Jpan_JP
    {   0,   0, 111 }, { 113,   7, 111 }, // und_KE -> sw_Latn_KE
    {   0,   0, 116 }, {  65,   2, 116 }, // und_KG -> ky_Cyrl_KG
    {   0,   0,  36 }, {  23,  20,  36 }, // und_KH -> km_Khmr_KH
    {   0,   0,  48 }, {   8,   1,  48 }, // und_KM -> ar_Arab_KM
    {   0,   0, 113 }, {  66,  22, 113 }, // und_KP -> ko_Kore_KP
    {   0,   0, 114 }, {  66,  22, 114 }, // und_KR -> ko_Kore_KR
    {   0,   0, 115 }, {   8,   1, 115 }, // und_KW -> ar_Arab_KW
    {   0,   0, 110 }, {  96,   2, 110 }, // und_KZ -> ru_Cyrl_KZ
    {   0,   0, 117 }, {  69,  23, 117 }, // und_LA -> lo_Laoo_LA
    {   0,   0, 119 }, {   8,   1, 119 }, // und_LB -> ar_Arab_LB
    {   0,   0, 123 }, {  42,   7, 123 }, // und_LI -> de_Latn_LI
    {   0,   0, 198 }, { 106,  32, 198 }, // und_LK -> si_Sinh_LK
    {   0,   0, 120 }, { 102,   7, 120 }, // und_LS -> st_Latn_LS
    {   0,   0, 124 }, {  73,   7, 124 }, // und_LT -> lt_Latn_LT
    {   0,   0, 125 }, {  37,   7, 125 }, // und_LU -> fr_Latn_LU
    {   0,   0, 118 }, {  71,   7, 118 }, // und_LV -> lv_Latn_LV
    {   0,   0, 122 }, {   8,   1, 122 }, // und_LY -> ar_Arab_LY
    {   0,   0, 145 }, {   8,   1, 145 }, // und_MA -> ar_Arab_MA
    {   0,   0, 142 }, {  37,   7, 142 }, // und_MC -> fr_Latn_MC
    {   0,   0, 141 }, {  95,   7, 141 }, // und_MD -> ro_Latn_MD
    {   0,   0, 242 }, { 100,   7, 242 }, // und_ME -> sr_Latn_ME
    {   0,   0, 245 }, {  37,   7, 245 }, // und_MF -> fr_Latn_MF
    {   0,   0, 128 }, {  75,   7, 128 }, // und_MG -> mg_Latn_MG
    {   0,   0, 127 }, {  74,   2, 127 }, // und_MK -> mk_Cyrl_MK
    {   0,   0, 132 }, { 188,   7, 132 }, // und_ML -> bm_Latn_ML
    {   0,   0, 147 }, {  21,  25, 147 }, // und_MM -> my_Mymr_MM
    {   0,   0, 143 }, {  82,   2, 143 }, // und_MN -> mn_Cyrl_MN
    {   0,   0, 126 }, {  25,   6, 126 }, // und_MO -> zh_Hant_MO
    {   0,   0, 135 }, {  37,   7, 135 }, // und_MQ -> fr_Latn_MQ
    {   0,   0, 136 }, {   8,   1, 136 }, // und_MR -> ar_Arab_MR
    {   0,   0, 133 }, {  78,   7, 133 }, // und_MT -> mt_Latn_MT
    {   0,   0, 137 }, { 191,   7, 137 }, // und_MU -> mfe_Latn_MU
    {   0,   0, 131 }, { 143,  29, 131 }, // und_MV -> dv_Thaa_MV
    {   0,   0, 139 }, { 111,   7, 139 }, // und_MX -> es_Latn_MX
    {   0,   0, 130 }, {  76,   7, 130 }, // und_MY -> ms_Latn_MY
    {   0,   0, 146 }, {  91,   7, 146 }, // und_MZ -> pt_Latn_MZ
    {   0,   0, 148 }, {   5,   7, 148 }, // und_NA -> af_Latn_NA
    {   0,   0, 153 }, {  37,   7, 153 }, // und_NC -> fr_Latn_NC
    {   0,   0, 156 }, {  47,   7, 156 }, // und_NE -> ha_Latn_NE
    {   0,   0, 155 }, { 111,   7, 155 }, // und_NI -> es_Latn_NI
    {   0,   0, 151 }, {  30,   7, 151 }, // und_NL -> nl_Latn_NL
    {   0,   0, 161 }, {  85,   7, 161 }, // und_NO -> nb_Latn_NO
    {   0,   0, 150 }, {  84,  13, 150 }, // und_NP -> ne_Deva_NP
    {   0,   0, 162 }, {   8,   1, 162 }, // und_OM -> ar_Arab_OM
    {   0,   0, 166 }, { 111,   7, 166 }, // und_PA -> es_Latn_PA
    {   0,   0, 169 }, { 111,   7, 169 }, // und_PE -> es_Latn_PE
    {   0,   0,  77 }, {  37,   7,  77 }, // und_PF -> fr_Latn_PF
    {   0,   0, 167 }, { 354,   7, 167 }, // und_PG -> tpi_Latn_PG
    {   0,   0, 170 }, { 166,   7, 170 }, // und_PH -> fil_Latn_PH
    {   0,   0, 163 }, { 130,   1, 163 }, // und_PK -> ur_Arab_PK
    {   0,   0, 172 }, {  90,   7, 172 }, // und_PL -> pl_Latn_PL
    {   0,   0, 200 }, {  37,   7, 200 }, // und_PM -> fr_Latn_PM
    {   0,   0, 174 }, { 111,   7, 174 }, // und_PR -> es_Latn_PR
    {   0,   0, 165 }, {   8,   1, 165 }, // und_PS -> ar_Arab_PS
    {   0,   0, 173 }, {  91,   7, 173 }, // und_PT -> pt_Latn_PT
    {   0,   0, 164 }, { 350,   7, 164 }, // und_PW -> pau_Latn_PW
    {   0,   0, 168 }, {  45,   7, 168 }, // und_PY -> gn_Latn_PY
    {   0,   0, 175 }, {   8,   1, 175 }, // und_QA -> ar_Arab_QA
    {   0,   0, 259 }, {  31,   7, 249 }, // und_QO -> en_Latn_DG
    {   0,   0, 176 }, {  37,   7, 176 }, // und_RE -> fr_Latn_RE
    {   0,   0, 177 }, {  95,   7, 177 }, // und_RO -> ro_Latn_RO
    {   0,   0, 243 }, { 100,   2, 243 }, // und_RS -> sr_Cyrl_RS
    {   0,   0, 178 }, {  96,   2, 178 }, // und_RU -> ru_Cyrl_RU
    {   0,   0, 179 }, {  64,   7, 179 }, // und_RW -> rw_Latn_RW
    {   0,   0, 186 }, {   8,   1, 186 }, // und_SA -> ar_Arab_SA
    {   0,   0, 188 }, {  37,   7, 188 }, // und_SC -> fr_Latn_SC
    {   0,   0, 201 }, {   8,   1, 201 }, // und_SD -> ar_Arab_SD
    {   0,   0, 205 }, { 114,   7, 205 }, // und_SE -> sv_Latn_SE
    {   0,   0, 192 }, { 109,   7, 192 }, // und_SI -> sl_Latn_SI
    {   0,   0, 203 }, {  85,   7, 203 }, // und_SJ -> nb_Latn_SJ
    {   0,   0, 191 }, { 108,   7, 191 }, // und_SK -> sk_Latn_SK
    {   0,   0, 184 }, {  58,   7, 184 }, // und_SM -> it_Latn_SM
    {   0,   0, 187 }, {  37,   7, 187 }, // und_SN -> fr_Latn_SN
    {   0,   0, 194 }, { 110,   7, 194 }, // und_SO -> so_Latn_SO
    {   0,   0, 202 }, {  30,   7, 202 }, // und_SR -> nl_Latn_SR
    {   0,   0, 185 }, {  91,   7, 185 }, // und_ST -> pt_Latn_ST
    {   0,   0,  65 }, { 111,   7,  65 }, // und_SV -> es_Latn_SV
    {   0,   0, 207 }, {   8,   1, 207 }, // und_SY -> ar_Arab_SY
    {   0,   0,  42 }, {  37,   7,  42 }, // und_TD -> fr_Latn_TD
    {   0,   0,  78 }, {  37,   7,  78 }, // und_TF -> fr_Latn_TF
    {   0,   0, 212 }, {  37,   7, 212 }, // und_TG -> fr_Latn_TG
    {   0,   0, 211 }, { 120,  30, 211 }, // und_TH -> th_Thai_TH
    {   0,   0, 209 }, { 116,   2, 209 }, // und_TJ -> tg_Cyrl_TJ
    {   0,   0, 213 }, { 353,   7, 213 }, // und_TK -> tkl_Latn_TK
    {   0,   0,  62 }, {  91,   7,  62 }, // und_TL -> pt_Latn_TL
    {   0,   0, 218 }, { 126,   7, 218 }, // und_TM -> tk_Latn_TM
    {   0,   0, 216 }, {   8,   1, 216 }, // und_TN -> ar_Arab_TN
    {   0,   0, 214 }, { 123,   7, 214 }, // und_TO -> to_Latn_TO
    {   0,   0, 217 }, { 125,   7, 217 }, // und_TR -> tr_Latn_TR
    {   0,   0, 220 }, { 355,   7, 220 }, // und_TV -> tvl_Latn_TV
    {   0,   0, 208 }, {  25,   6, 208 }, // und_TW -> zh_Hant_TW
    {   0,   0, 210 }, { 113,   7, 210 }, // und_TZ -> sw_Latn_TZ
    {   0,   0, 222 }, { 129,   2, 222 }, // und_UA -> uk_Cyrl_UA
    {   0,   0, 221 }, { 113,   7, 221 }, // und_UG -> sw_Latn_UG
    {   0,   0, 227 }, { 111,   7, 227 }, // und_UY -> es_Latn_UY
    {   0,   0, 228 }, { 131,   7, 228 }, // und_UZ -> uz_Latn_UZ
    {   0,   0, 230 }, {  58,   7, 230 }, // und_VA -> it_Latn_VA
    {   0,   0, 231 }, { 111,   7, 231 }, // und_VE -> es_Latn_VE
    {   0,   0, 232 }, { 132,   7, 232 }, // und_VN -> vi_Latn_VN
    {   0,   0, 229 }, {  18,   7, 229 }, // und_VU -> bi_Latn_VU
    {   0,   0, 235 }, {  37,   7, 235 }, // und_WF -> fr_Latn_WF
    {   0,   0, 183 }, {  97,   7, 183 }, // und_WS -> sm_Latn_WS
    {   0,   0, 257 }, {   6,   7, 257 }, // und_XK -> sq_Latn_XK
    {   0,   0, 237 }, {   8,   1, 237 }, // und_YE -> ar_Arab_YE
    {   0,   0, 138 }, {  37,   7, 138 }, // und_YT -> fr_Latn_YT
    {   0,   0, 240 }, { 104,   7, 240 }, // und_ZW -> sn_Latn_ZW
    {   0, 134,   0 }, { 177, 134,  91 }, // und_Adlm -> ff_Adlm_GN
    {   0, 105,   0 }, { 335, 105, 178 }, // und_Aghb -> lez_Aghb_RU
    {   0, 128,   0 }, { 340, 128, 100 }, // und_Ahom -> aho_Ahom_IN
    {   0,   1,   0 }, {   8,   1,  64 }, // und_Arab -> ar_Arab_EG
    {   0,   1,  46 }, {  76,   1,  46 }, // und_Arab_CC -> ms_Arab_CC
    {   0,   1,  44 }, { 128,   1,  44 }, // und_Arab_CN -> ug_Arab_CN
    {   0,   1, 224 }, {  62,   1, 224 }, // und_Arab_GB -> ks_Arab_GB
    {   0,   1, 101 }, {  76,   1, 101 }, // und_Arab_ID -> ms_Arab_ID
    {   0,   1, 100 }, { 130,   1, 100 }, // und_Arab_IN -> ur_Arab_IN
    {   0,   1, 143 }, {  63,   1, 143 }, // und_Arab_MN -> kk_Arab_MN
    {   0,   1, 137 }, { 130,   1, 137 }, // und_Arab_MU -> ur_Arab_MU
    {   0,   1, 157 }, {  47,   1, 157 }, // und_Arab_NG -> ha_Arab_NG
    {   0,   1, 163 }, { 130,   1, 163 }, // und_Arab_PK -> ur_Arab_PK
    {   0,   1, 209 }, {  89,   1, 209 }, // und_Arab_TJ -> fa_Arab_TJ
    {   0,   1, 217 }, {  12,   1, 217 }, // und_Arab_TR -> az_Arab_TR
    {   0,  57,   0 }, { 265,  57, 102 }, // und_Armi -> arc_Armi_IR
    {   0,  10,   0 }, {   9,  10,  11 }, // und_Armn -> hy_Armn_AM
    {   0,  36,   0 }, { 255,  36, 102 }, // und_Avst -> ae_Avst_IR
    {   0,  37,   0 }, { 266,  37, 101 }, // und_Bali -> ban_Bali_ID
    {   0,  38,   0 }, { 267,  38,  37 }, // und_Bamu -> bax_Bamu_CM
    {   0, 106,   0 }, { 336, 106, 121 }, // und_Bass -> bsq_Bass_LR
    {   0,  39,   0 }, { 268,  39, 101 }, // und_Batk -> bbc_Batk_ID
    {   0,  11,   0 }, {  15,  11,  18 }, // und_Beng -> bn_Beng_BD
    {   0, 135,   0 }, {  99, 135, 100 }, // und_Bhks -> sa_Bhks_IN
    {   0,  40,   0 }, {  25,  40, 208 }, // und_Bopo -> zh_Bopo_TW
    {   0,  41,   0 }, { 342,  41, 100 }, // und_Brah -> pka_Brah_IN
    {   0, 103,   0 }, {  37, 103,  74 }, // und_Brai -> fr_Brai_FR
    {   0,  42,   0 }, { 269,  42, 101 }, // und_Bugi -> bug_Bugi_ID
    {   0,  43,   0 }, { 270,  43, 170 }, // und_Buhd -> bku_Buhd_PH
    {   0,  46,   0 }, { 272,  46,  18 }, // und_Cakm -> ccp_Cakm_BD
    {   0,  44,   0 }, { 221,  44,  38 }, // und_Cans -> cr_Cans_CA
    {   0,  45,   0 }, { 271,  45, 217 }, // und_Cari -> xcr_Cari_TR
    {   0,  47,   0 }, { 276,  47, 232 }, // und_Cham -> cjm_Cham_VN
    {   0,  12,   0 }, { 190,  12, 225 }, // und_Cher -> chr_Cher_US
    {   0,  48,   0 }, { 274,  48,  64 }, // und_Copt -> cop_Copt_EG
    {   0,  49,   0 }, { 264,  49,  56 }, // und_Cprt -> grc_Cprt_CY
    {   0,   2,   0 }, {  96,   2, 178 }, // und_Cyrl -> ru_Cyrl_RU
    {   0,   2,   2 }, {  74,   2,   2 }, // und_Cyrl_AL -> mk_Cyrl_AL
    {   0,   2,  27 }, { 100,   2,  27 }, // und_Cyrl_BA -> sr_Cyrl_BA
    {   0,   2,  81 }, {   2,   2,  81 }, // und_Cyrl_GE -> ab_Cyrl_GE
    {   0,   2,  85 }, {  74,   2,  85 }, // und_Cyrl_GR -> mk_Cyrl_GR
    {   0,   2, 141 }, { 129,   2, 141 }, // und_Cyrl_MD -> uk_Cyrl_MD
    {   0,   2, 177 }, {  20,   2, 177 }, // und_Cyrl_RO -> bg_Cyrl_RO
    {   0,   2, 191 }, { 129,   2, 191 }, // und_Cyrl_SK -> uk_Cyrl_SK
    {   0,   2, 257 }, { 100,   2, 257 }, // und_Cyrl_XK -> sr_Cyrl_XK
    {   0,  13,   0 }, {  49,  13, 100 }, // und_Deva -> hi_Deva_IN
    {   0,  13,  25 }, {  84,  13,  25 }, // und_Deva_BT -> ne_Deva_BT
    {   0,  13, 137 }, { 343,  13, 137 }, // und_Deva_MU -> bho_Deva_MU
    {   0, 107,   0 }, {  37, 107,  74 }, // und_Dupl -> fr_Dupl_FR
    {   0,  50,   0 }, { 263,  50,  64 }, // und_Egyp -> egy_Egyp_EG
    {   0, 108,   0 }, {   6, 108,   2 }, // und_Elba -> sq_Elba_AL
    {   0,  14,   0 }, {   7,  14,  69 }, // und_Ethi -> am_Ethi_ET
    {   0,  15,   0 }, {  41,  15,  81 }, // und_Geor -> ka_Geor_GE
    {   0,  52,   0 }, { 219,  52,  33 }, // und_Glag -> cu_Glag_BG
    {   0,  53,   0 }, { 279,  53, 222 }, // und_Goth -> got_Goth_UA
    {   0, 109,   0 }, {  99, 109, 100 }, // und_Gran -> sa_Gran_IN
    {   0,  16,   0 }, {  43,  16,  85 }, // und_Grek -> el_Grek_GR
    {   0,  17,   0 }, {  46,  17, 100 }, // und_Gujr -> gu_Gujr_IN
    {   0,   4,   0 }, {  92,   4, 100 }, // und_Guru -> pa_Guru_IN
    {   0, 140,   0 }, {  25, 140, 208 }, // und_Hanb -> zh_Hanb_TW
    {   0,  55,   0 }, {  66,  55, 114 }, // und_Hang -> ko_Hang_KR
    {   0,  54,   0 }, {  25,  54,  44 }, // und_Hani -> zh_Hani_CN
    {   0,  56,   0 }, { 280,  56, 170 }, // und_Hano -> hnn_Hano_PH
    {   0,   5,   0 }, {  25,   5,  44 }, // und_Hans -> zh_Hans_CN
    {   0,   6,   0 }, {  25,   6, 208 }, // und_Hant -> zh_Hant_TW
    {   0, 130,   0 }, { 356, 130, 103 }, // und_Hatr -> mis_Hatr_IQ
    {   0,  18,   0 }, {  48,  18, 105 }, // und_Hebr -> he_Hebr_IL
    {   0,  18,  38 }, { 137,  18,  38 }, // und_Hebr_CA -> yi_Hebr_CA
    {   0,  18, 224 }, { 137,  18, 224 }, // und_Hebr_GB -> yi_Hebr_GB
    {   0,  18, 205 }, { 137,  18, 205 }, // und_Hebr_SE -> yi_Hebr_SE
    {   0,  18, 222 }, { 137,  18, 222 }, // und_Hebr_UA -> yi_Hebr_UA
    {   0,  18, 225 }, { 137,  18, 225 }, // und_Hebr_US -> yi_Hebr_US
    {   0, 104,   0 }, {  59, 104, 108 }, // und_Hira -> ja_Hira_JP
    {   0, 129,   0 }, { 344, 129, 217 }, // und_Hluw -> hlu_Hluw_TR
    {   0, 110,   0 }, { 333, 110, 117 }, // und_Hmng -> hnj_Hmng_LA
    {   0, 132,   0 }, {  50, 132,  98 }, // und_Hung -> hu_Hung_HU
    {   0,  79,   0 }, { 278,  79, 106 }, // und_Ital -> ett_Ital_IT
    {   0, 141,   0 }, {  66, 141, 114 }, // und_Jamo -> ko_Jamo_KR
    {   0,  60,   0 }, {  60,  60, 101 }, // und_Java -> jv_Java_ID
    {   0,  19,   0 }, {  59,  19, 108 }, // und_Jpan -> ja_Jpan_JP
    {   0,  63,   0 }, { 277,  63, 147 }, // und_Kali -> eky_Kali_MM
    {   0,  62,   0 }, {  59,  62, 108 }, // und_Kana -> ja_Kana_JP
    {   0,  64,   0 }, { 300,  64, 163 }, // und_Khar -> pra_Khar_PK
    {   0,  20,   0 }, {  23,  20,  36 }, // und_Khmr -> km_Khmr_KH
    {   0, 111,   0 }, { 105, 111, 100 }, // und_Khoj -> sd_Khoj_IN
    {   0,  21,   0 }, {  61,  21, 100 }, // und_Knda -> kn_Knda_IN
    {   0,  22,   0 }, {  66,  22, 114 }, // und_Kore -> ko_Kore_KR
    {   0,  61,   0 }, { 343,  61, 100 }, // und_Kthi -> bho_Kthi_IN
    {   0,  65,   0 }, { 292,  65, 211 }, // und_Lana -> nod_Lana_TH
    {   0,  23,   0 }, {  69,  23, 117 }, // und_Laoo -> lo_Laoo_LA
    {   0,   7,   1 }, { 126,   7,   1 }, // und_Latn_AF -> tk_Latn_AF
    {   0,   7,  11 }, {  67,   7,  11 }, // und_Latn_AM -> ku_Latn_AM
    {   0,   7,  44 }, { 139,   7,  44 }, // und_Latn_CN -> za_Latn_CN
    {   0,   7,  56 }, { 125,   7,  56 }, // und_Latn_CY -> tr_Latn_CY
    {   0,   7,   3 }, {  37,   7,   3 }, // und_Latn_DZ -> fr_Latn_DZ
    {   0,   7,  69 }, {  31,   7,  69 }, // und_Latn_ET -> en_Latn_ET
    {   0,   7,  81 }, {  67,   7,  81 }, // und_Latn_GE -> ku_Latn_GE
    {   0,   7, 102 }, { 126,   7, 102 }, // und_Latn_IR -> tk_Latn_IR
    {   0,   7,  48 }, {  37,   7,  48 }, // und_Latn_KM -> fr_Latn_KM
    {   0,   7, 145 }, {  37,   7, 145 }, // und_Latn_MA -> fr_Latn_MA
    {   0,   7, 127 }, {   6,   7, 127 }, // und_Latn_MK -> sq_Latn_MK
    {   0,   7, 126 }, {  91,   7, 126 }, // und_Latn_MO -> pt_Latn_MO
    {   0,   7, 136 }, {  37,   7, 136 }, // und_Latn_MR -> fr_Latn_MR
    {   0,   7, 207 }, {  37,   7, 207 }, // und_Latn_SY -> fr_Latn_SY
    {   0,   7, 216 }, {  37,   7, 216 }, // und_Latn_TN -> fr_Latn_TN
    {   0,   7, 208 }, { 174,   7, 208 }, // und_Latn_TW -> trv_Latn_TW
    {   0,   7, 222 }, {  90,   7, 222 }, // und_Latn_UA -> pl_Latn_UA
    {   0,  66,   0 }, { 283,  66, 100 }, // und_Lepc -> lep_Lepc_IN
    {   0,  67,   0 }, { 284,  67, 100 }, // und_Limb -> lif_Limb_IN
    {   0, 112,   0 }, { 332, 112,  85 }, // und_Lina -> lab_Lina_GR
    {   0,  68,   0 }, { 264,  68,  85 }, // und_Linb -> grc_Linb_GR
    {   0,  51,   0 }, { 285,  51,  44 }, // und_Lisu -> lis_Lisu_CN
    {   0,  69,   0 }, { 287,  69, 217 }, // und_Lyci -> xlc_Lyci_TR
    {   0,  70,   0 }, { 288,  70, 217 }, // und_Lydi -> xld_Lydi_TR
    {   0, 113,   0 }, {  49, 113, 100 }, // und_Mahj -> hi_Mahj_IN
    {   0,  71,   0 }, { 273,  71, 102 }, // und_Mand -> myz_Mand_IR
    {   0, 114,   0 }, { 329, 114,  44 }, // und_Mani -> xmn_Mani_CN
    {   0, 136,   0 }, { 121, 136,  44 }, // und_Marc -> bo_Marc_CN
    {   0, 115,   0 }, { 330, 115, 189 }, // und_Mend -> men_Mend_SL
    {   0,  74,   0 }, { 291,  74, 201 }, // und_Merc -> xmr_Merc_SD
    {   0,  73,   0 }, { 291,  73, 201 }, // und_Mero -> xmr_Mero_SD
    {   0,  24,   0 }, {  77,  24, 100 }, // und_Mlym -> ml_Mlym_IN
    {   0, 116,   0 }, {  80, 116, 100 }, // und_Modi -> mr_Modi_IN
    {   0,   8,   0 }, {  82,   8,  44 }, // und_Mong -> mn_Mong_CN
    {   0, 117,   0 }, { 347, 117,  18 }, // und_Mroo -> mro_Mroo_BD
    {   0,  72,   0 }, { 290,  72, 100 }, // und_Mtei -> mni_Mtei_IN
    {   0, 131,   0 }, { 352, 131, 163 }, // und_Mult -> skr_Mult_PK
    {   0,  25,   0 }, {  21,  25, 147 }, // und_Mymr -> my_Mymr_MM
    {   0, 118,   0 }, { 331, 118, 186 }, // und_Narb -> xna_Narb_SA
    {   0, 119,   0 }, { 265, 119, 109 }, // und_Nbat -> arc_Nbat_JO
    {   0, 137,   0 }, { 348, 137, 150 }, // und_Newa -> new_Newa_NP
    {   0,  75,   0 }, { 289,  75,  91 }, // und_Nkoo -> man_Nkoo_GN
    {   0,  77,   0 }, { 293,  77, 104 }, // und_Ogam -> sga_Ogam_IE
    {   0,  78,   0 }, { 304,  78, 100 }, // und_Olck -> sat_Olck_IN
    {   0,  82,   0 }, { 296,  82, 143 }, // und_Orkh -> otk_Orkh_MN
    {   0,  26,   0 }, {  87,  26, 100 }, // und_Orya -> or_Orya_IN
    {   0, 138,   0 }, { 358, 138, 225 }, // und_Osge -> osa_Osge_US
    {   0,  83,   0 }, { 110,  83, 194 }, // und_Osma -> so_Osma_SO
    {   0, 120,   0 }, { 265, 120, 207 }, // und_Palm -> arc_Palm_SY
    {   0, 121,   0 }, { 338, 121, 147 }, // und_Pauc -> ctd_Pauc_MM
    {   0, 122,   0 }, { 226, 122, 178 }, // und_Perm -> kv_Perm_RU
    {   0,  84,   0 }, { 345,  84,  44 }, // und_Phag -> lzh_Phag_CN
    {   0,  58,   0 }, { 297,  58, 102 }, // und_Phli -> pal_Phli_IR
    {   0, 123,   0 }, { 297, 123,  44 }, // und_Phlp -> pal_Phlp_CN
    {   0,  85,   0 }, { 299,  85, 119 }, // und_Phnx -> phn_Phnx_LB
    {   0,  86,   0 }, { 282,  86,  44 }, // und_Plrd -> hmd_Plrd_CN
    {   0,  59,   0 }, { 298,  59, 102 }, // und_Prti -> xpr_Prti_IR
    {   0,  87,   0 }, { 301,  87, 101 }, // und_Rjng -> rej_Rjng_ID
    {   0,  88,   0 }, { 294,  88, 205 }, // und_Runr -> non_Runr_SE
    {   0,  89,   0 }, { 303,  89, 105 }, // und_Samr -> smp_Samr_IL
    {   0,  81,   0 }, { 302,  81, 237 }, // und_Sarb -> xsa_Sarb_YE
    {   0,  90,   0 }, { 305,  90, 100 }, // und_Saur -> saz_Saur_IN
    {   0, 133,   0 }, { 341, 133, 225 }, // und_Sgnw -> ase_Sgnw_US
    {   0,  92,   0 }, {  31,  92, 224 }, // und_Shaw -> en_Shaw_GB
    {   0,  91,   0 }, {  99,  91, 100 }, // und_Shrd -> sa_Shrd_IN
    {   0, 124,   0 }, {  99, 124, 100 }, // und_Sidd -> sa_Sidd_IN
    {   0, 125,   0 }, { 105, 125, 100 }, // und_Sind -> sd_Sind_IN
    {   0,  32,   0 }, { 106,  32, 198 }, // und_Sinh -> si_Sinh_LK
    {   0,  93,   0 }, { 306,  93, 100 }, // und_Sora -> srb_Sora_IN
    {   0,  95,   0 }, { 112,  95, 101 }, // und_Sund -> su_Sund_ID
    {   0,  96,   0 }, { 307,  96,  18 }, // und_Sylo -> syl_Sylo_BD
    {   0,  33,   0 }, { 151,  33, 103 }, // und_Syrc -> syr_Syrc_IQ
    {   0,  98,   0 }, { 308,  98, 170 }, // und_Tagb -> tbw_Tagb_PH
    {   0, 101,   0 }, { 275, 101, 100 }, // und_Takr -> doi_Takr_IN
    {   0,  99,   0 }, { 310,  99,  44 }, // und_Tale -> tdd_Tale_CN
    {   0,  76,   0 }, { 286,  76,  44 }, // und_Talu -> khb_Talu_CN
    {   0,  27,   0 }, { 117,  27, 100 }, // und_Taml -> ta_Taml_IN
    {   0, 139,   0 }, { 359, 139,  44 }, // und_Tang -> txg_Tang_CN
    {   0, 100,   0 }, { 309, 100, 232 }, // und_Tavt -> blt_Tavt_VN
    {   0,  28,   0 }, { 119,  28, 100 }, // und_Telu -> te_Telu_IN
    {   0,   9,   0 }, { 314,   9, 145 }, // und_Tfng -> zgh_Tfng_MA
    {   0,  97,   0 }, { 166,  97, 170 }, // und_Tglg -> fil_Tglg_PH
    {   0,  29,   0 }, { 143,  29, 131 }, // und_Thaa -> dv_Thaa_MV
    {   0,  30,   0 }, { 120,  30, 211 }, // und_Thai -> th_Thai_TH
    {   0,  31,   0 }, { 121,  31,  44 }, // und_Tibt -> bo_Tibt_CN
    {   0, 126,   0 }, { 339, 126, 100 }, // und_Tirh -> mai_Tirh_IN
    {   0, 102,   0 }, { 311, 102, 207 }, // und_Ugar -> uga_Ugar_SY
    {   0,  35,   0 }, { 252,  35, 121 }, // und_Vaii -> vai_Vaii_LR
    {   0, 127,   0 }, { 334, 127, 100 }, // und_Wara -> hoc_Wara_IN
    {   0,  80,   0 }, { 295,  80, 102 }, // und_Xpeo -> peo_Xpeo_IR
    {   0,  94,   0 }, { 262,  94, 103 }, // und_Xsux -> akk_Xsux_IQ
    {   0,  34,   0 }, { 168,  34,  44 }  // und_Yiii -> ii_Yiii_CN
};

static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abkhazian
     1, // Oromo
     3, // Afar
     4, // Afrikaans
     6, // Albanian
     9, // Amharic
    10, // Arabic
    38, // Armenian
    39, // Assamese
     0, // Aymara
    40, // Azerbaijani
    43, // Bashkir
    44, // Basque
    45, // Bengali
    47, // Dzongkha
     0, // Bihari
     0, // Bislama
    48, // Breton
    49, // Bulgarian
    50, // Burmese
    51, // Belarusian
    52, // Khmer
    53, // Catalan
    57, // Chinese
    64, // Corsican
    65, // Croatian
    67, // Czech
    68, // Danish
    70, // Dutch
    77, // English
   182, // Esperanto
   183, // Estonian
   184, // Faroese
     0, // Fijian
   186, // Finnish
   187, // French
   233, // Western Frisian
   234, // Gaelic
   235, // Galician
   236, // Georgian
   237, // German
   244, // Greek
   246, // Greenlandic
   247, // Guarani
   248, // Gujarati
   249, // Hausa
   253, // Hebrew
   254, // Hindi
   255, // Hungarian
   256, // Icelandic
   257, // Indonesian
   258, // Interlingua
     0, // Interlingue
   259, // Inuktitut
     0, // Inupiak
   261, // Irish
   262, // Italian
   266, // Japanese
   267, // Javanese
   268, // Kannada
   269, // Kashmiri
   270, // Kazakh
   271, // Kinyarwanda
   272, // Kirghiz
   273, // Korean
   275, // Kurdish
   276, // Rundi
   277, // Lao
     0, // Latin
   278, // Latvian
   279, // Lingala
   283, // Lithuanian
   284, // Macedonian
   285, // Malagasy
   286, // Malay
   290, // Malayalam
   291, // Maltese
   292, // Maori
   293, // Marathi
     0, // Marshallese
   294, // Mongolian
     0, // Nauru
   296, // Nepali
   298, // Norwegian Bokmal
   300, // Occitan
   301, // Oriya
   302, // Pashto
   303, // Persian
   305, // Polish
   306, // Portuguese
   318, // Punjabi
   320, // Quechua
   323, // Romansh
   324, // Romanian
   326, // Russian
     0, // Samoan
   332, // Sango
   333, // Sanskrit
   334, // Serbian
   342, // Ossetic
   344, // Southern Sotho
   345, // Tswana
   346, // Shona
   347, // Sindhi
   348, // Sinhala
   349, // Swati
   350, // Slovak
   351, // Slovenian
   352, // Somali
   356, // Spanish
     0, // Sundanese
   384, // Swahili
   388, // Swedish
     0, // Sardinian
   391, // Tajik
   392, // Tamil
   396, // Tatar
   397, // Telugu
   398, // Thai
   399, // Tibetan
   401, // Tigrinya
   403, // Tongan
   404, // Tsonga
   405, // Turkish
   407, // Turkmen
     0, // Tahitian
   408, // Uighur
   409, // Ukrainian
   410, // Urdu
   412, // Uzbek
   415, // Vietnamese
   416, // Volapuk
   417, // Welsh
   418, // Wolof
   419, // Xhosa
   420, // Yiddish
   421, // Yoruba
     0, // Zhuang
   423, // Zulu
   424, // Norwegian Nynorsk
   425, // Bosnian
   427, // Divehi
   428, // Manx
   429, // Cornish
   430, // Akan
   431, // Konkani
   432, // Ga
   433, // Igbo
   434, // Kamba
   435, // Syriac
   436, // Blin
   437, // Geez
     0, // Koro
   438, // Sidamo
   439, // Atsam
   440, // Tigre
   441, // Jju
   442, // Friulian
   443, // Venda
   444, // Ewe
   446, // Walamo
   447, // Hawaiian
   448, // Tyap
   449, // Nyanja
   450, // Filipino
   451, // Swiss German
   454, // Sichuan Yi
   455, // Kpelle
   456, // Low German
   458, // South Ndebele
   459, // Northern Sotho
   460, // Northern Sami
   463, // Taroko
   464, // Gusii
   465, // Taita
   466, // Fulah
   470, // Kikuyu
   471, // Samburu
   472, // Sena
   473, // North Ndebele
   474, // Rombo
   475, // Tachelhit
   477, // Kabyle
   478, // Nyankole
   479, // Bena
   480, // Vunjo
   481, // Bambara
   483, // Embu
   484, // Cherokee
   485, // Morisyen
   486, // Makonde
   487, // Langi
   488, // Ganda
   489, // Bemba
   490, // Kabuverdianu
   491, // Meru
   492, // Kalenjin
   493, // Nama
   494, // Machame
   495, // Colognian
   496, // Masai
   498, // Soga
   499, // Luyia
   500, // Asu
   501, // Teso
   503, // Saho
   504, // Koyra Chiini
   505, // Rwa
   506, // Luo
   507, // Chiga
   508, // Central Morocco Tamazight
   509, // Koyraboro Senni
   510, // Shambala
   511, // Bodo
     0, // Avaric
     0, // Chamorro
   512, // Chechen
   513, // Church
   514, // Chuvash
     0, // Cree
     0, // Haitian
     0, // Herero
     0, // Hiri Motu
     0, // Kanuri
     0, // Komi
     0, // Kongo
     0, // Kwanyama
     0, // Limburgish
   515, // Luba Katanga
   516, // Luxembourgish
     0, // Navaho
     0, // Ndonga
     0, // Ojibwa
     0, // Pali
   517, // Walloon
   518, // Aghem
   519, // Basaa
   520, // Zarma
   521, // Duala
   522, // Jola Fonyi
   523, // Ewondo
   524, // Bafia
   525, // Makhuwa Meetto
   526, // Mundang
   527, // Kwasio
   528, // Nuer
   529, // Sakha
   530, // Sangu
     0, // Congo Swahili
   531, // Tasawaq
   532, // Vai
   534, // Walser
   535, // Yangben
     0, // Avestan
   536, // Asturian
   537, // Ngomba
   538, // Kako
   539, // Meta
   540, // Ngiemboon
     0, // Aragonese
     0, // Akkadian
     0, // Ancient Egyptian
     0, // Ancient Greek
     0, // Aramaic
     0, // Balinese
     0, // Bamun
     0, // Batak Toba
     0, // Buginese
     0, // Buhid
     0, // Carian
     0, // Chakma
     0, // Classical Mandaic
     0, // Coptic
     0, // Dogri
     0, // Eastern Cham
     0, // Eastern Kayah
     0, // Etruscan
     0, // Gothic
     0, // Hanunoo
     0, // Ingush
     0, // Large Flowery Miao
     0, // Lepcha
     0, // Limbu
     0, // Lisu
     0, // Lu
     0, // Lycian
     0, // Lydian
     0, // Mandingo
   541, // Manipuri
     0, // Meroitic
     0, // Northern Thai
     0, // Old Irish
     0, // Old Norse
     0, // Old Persian
     0, // Old Turkish
     0, // Pahlavi
     0, // Parthian
     0, // Phoenician
     0, // Prakrit Language
     0, // Rejang
     0, // Sabaean
     0, // Samaritan
     0, // Santali
     0, // Saurashtra
     0, // Sora
     0, // Sylheti
     0, // Tagbanwa
   542, // Tai Dam
     0, // Tai Nua
     0, // Ugaritic
   543, // Akoose
   544, // Lakota
   545, // Standard Moroccan Tamazight
   546, // Mapuche
   547, // Central Kurdish
   549, // Lower Sorbian
   550, // Upper Sorbian
   551, // Kenyang
   552, // Mohawk
   553, // Nko
   554, // Prussian
   555, // Kiche
   556, // Southern Sami
   557, // Lule Sami
   558, // Inari Sami
   559, // Skolt Sami
   560, // Warlpiri
     0, // Manichaean Middle Persian
     0, // Mende
     0, // Ancient North Arabian
     0, // Linear A
     0, // Hmong Njua
     0, // Ho
     0, // Lezghian
     0, // Bassa
     0, // Mono
     0, // Tedim Chin
     0, // Maithili
     0, // Ahom
     0, // American Sign Language
     0, // Ardhamagadhi Prakrit
     0, // Bhojpuri
     0, // Hieroglyphic Luwian
     0, // Literary Chinese
   561, // Mazanderani
     0, // Mru
     0, // Newari
   562, // Northern Luri
     0, // Palauan
     0, // Papiamento
     0, // Saraiki
     0, // Tokelau
     0, // Tok Pisin
     0, // Tuvalu
     0, // Uncoded Languages
   564, // Cantonese
     0, // Osage
     0, // Tangut
     0 // trailing 0
};

static const QLocaleData locale_data[] = {
   //  lang  script   terr   dec   group  list   prcnt   zero  minus  plus    exp   quotOpn  quotEnd altQtOpn altQtEnd   lpStart      lpMid       lpEnd       lpTwo       sDtFmt      lDtFmt      sTmFmt      lTmFmt     ssMonth     slMonth     snMonth      sMonth      lMonth      nMonth      ssDays      slDays      snDays       sDays       lDays       nDays        am          pm       byte    siQuant iecQuant    currISO     currSym    currDsply    currFmt    currFmtNeg   endoLang    endoCntry curDgt curRnd dow1st  wknd+  wknd-
    {      1,     0,     0,    46,    44,    59,    37,    48,    45,    43,   101,      34,      34,      39,      39,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      0,10 ,     10,17 ,       0,8 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    158,27 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     99,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,       0,7 ,       0,4 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // C/AnyScript/AnyCountry
    {      3,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     35,18 ,      18,7 ,     25,12 ,    185,48 ,   233,111 ,    134,24 ,    185,48 ,   233,111 ,    134,24 ,    113,28 ,    141,55 ,     85,14 ,    113,28 ,    141,55 ,     85,14 ,       2,2 ,       2,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,2 ,      7,24 ,       4,4 ,       4,0 ,       0,6 ,      6,10 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Ethiopia
    {      3,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     35,18 ,      37,5 ,      8,10 ,    185,48 ,   233,111 ,    344,24 ,    185,48 ,   233,111 ,    134,24 ,    113,28 ,    141,55 ,    196,14 ,    113,28 ,    141,55 ,    196,14 ,       2,2 ,       2,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,       0,7 ,       4,4 ,       4,0 ,       0,6 ,      16,8 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Kenya
    {      4,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Afar/Latin/Ethiopia
    {      5,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     53,10 ,     80,18 ,      37,5 ,      8,10 ,    416,59 ,    475,92 ,    134,24 ,    416,59 ,    475,92 ,    134,24 ,    210,28 ,    238,58 ,    296,14 ,    210,28 ,    238,58 ,    296,14 ,       4,3 ,       4,3 ,   49,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,     31,67 ,       4,4 ,       4,0 ,      24,9 ,     33,11 ,     2,     1,     7,     6,     7 }, // Afrikaans/Latin/South Africa
    {      5,     7,   148,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     53,10 ,     98,16 ,      37,5 ,      8,10 ,    416,59 ,    475,92 ,    134,24 ,    416,59 ,    475,92 ,    134,24 ,    210,28 ,    238,58 ,    296,14 ,    210,28 ,    238,58 ,    296,14 ,       4,3 ,       4,3 ,   49,5 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,     98,55 ,       4,4 ,       4,0 ,      24,9 ,      44,7 ,     2,     1,     1,     6,     7 }, // Afrikaans/Latin/Namibia
    {      6,     7,     2,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     114,6 ,     10,17 ,      18,7 ,     42,13 ,    567,50 ,    617,78 ,    695,27 ,    722,50 ,    772,78 ,    850,27 ,    310,28 ,    338,58 ,    396,15 ,    310,28 ,    411,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {65,76,76},        7,4 ,    153,45 ,      13,5 ,       4,0 ,      51,5 ,      56,8 ,     0,     0,     1,     6,     7 }, // Albanian/Latin/Albania
    {      6,     7,   127,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     114,6 ,     10,17 ,      37,5 ,      8,10 ,    567,50 ,    617,78 ,    695,27 ,    722,50 ,    772,78 ,    850,27 ,    310,28 ,    338,58 ,    396,15 ,    310,28 ,    411,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {77,75,68},       11,3 ,    198,54 ,      13,5 ,       4,0 ,      51,5 ,      64,8 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Macedonia
    {      6,     7,   257,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     114,6 ,     10,17 ,      37,5 ,      8,10 ,    567,50 ,    617,78 ,    695,27 ,    722,50 ,    772,78 ,    850,27 ,    310,28 ,    338,58 ,    396,15 ,    310,28 ,    411,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,    252,21 ,      13,5 ,       4,0 ,      51,5 ,      72,6 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Kosovo
    {      7,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,      23,6 ,      23,6 ,      29,9 ,      38,8 ,    120,10 ,    130,17 ,      18,7 ,     25,12 ,    877,46 ,    923,61 ,    984,24 ,    877,46 ,    923,61 ,    984,24 ,    469,27 ,    496,28 ,    524,14 ,    469,27 ,    496,28 ,    524,14 ,      18,3 ,      17,4 ,   58,3 ,  61,23 ,  22,23 , {69,84,66},       15,2 ,    273,34 ,       4,4 ,       4,0 ,      78,4 ,      82,5 ,     2,     1,     7,     6,     7 }, // Amharic/Ethiopic/Ethiopia
    {      8,     1,    64,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {69,71,80},       17,5 ,    307,81 ,      13,5 ,       4,0 ,      87,7 ,      94,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Egypt
    {      8,     1,     3,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1107,71 ,   1107,71 ,   1178,24 ,   1107,71 ,   1107,71 ,   1178,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {68,90,68},       22,5 ,   388,102 ,      13,5 ,       4,0 ,      87,7 ,      97,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Algeria
    {      8,     1,    17,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {66,72,68},       27,5 ,    490,91 ,      13,5 ,       4,0 ,      87,7 ,     104,7 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Bahrain
    {      8,     1,    42,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {88,65,70},       32,4 ,   581,112 ,      13,5 ,       4,0 ,      87,7 ,     111,4 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Chad
    {      8,     1,    48,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      37,5 ,      8,10 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {75,77,70},       36,2 ,   693,105 ,      13,5 ,       4,0 ,      87,7 ,     115,9 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Comoros
    {      8,     1,    59,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {68,74,70},       38,3 ,    798,84 ,      13,5 ,       4,0 ,      87,7 ,     124,6 ,     0,     0,     6,     6,     7 }, // Arabic/Arabic/Djibouti
    {      8,     1,    67,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {69,82,78},       41,3 ,    882,91 ,      13,5 ,       4,0 ,      87,7 ,     130,7 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Eritrea
    {      8,     1,   103,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1202,92 ,   1202,92 ,   1294,24 ,   1318,92 ,   1202,92 ,   1294,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {73,81,68},       44,5 ,    973,84 ,      13,5 ,       4,0 ,      87,7 ,     137,6 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Iraq
    {      8,     1,   105,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      55,4 ,      59,9 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {73,76,83},       49,1 ,  1057,133 ,      13,5 ,       4,0 ,      87,7 ,     143,7 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Israel
    {      8,     1,   109,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1202,92 ,   1202,92 ,   1294,24 ,   1202,92 ,   1202,92 ,   1294,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {74,79,68},       50,5 ,   1190,84 ,      13,5 ,       4,0 ,      87,7 ,     150,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Jordan
    {      8,     1,   115,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {75,87,68},       55,5 ,   1274,84 ,      13,5 ,       4,0 ,      87,7 ,     156,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Kuwait
    {      8,     1,   119,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1202,92 ,   1202,92 ,   1294,24 ,   1202,92 ,   1202,92 ,   1294,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {76,66,80},       60,5 ,   1358,84 ,      13,5 ,       4,0 ,      87,7 ,     162,5 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Lebanon
    {      8,     1,   122,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {76,89,68},       65,5 ,   1442,88 ,      13,5 ,       4,0 ,      87,7 ,     167,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Libya
    {      8,     1,   136,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1410,72 ,   1410,72 ,   1482,24 ,   1410,72 ,   1410,72 ,   1482,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {77,82,85},        0,0 ,  1530,112 ,      13,5 ,       4,0 ,      87,7 ,     172,9 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Mauritania
    {      8,     1,   145,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      37,5 ,      8,10 ,   1506,70 ,   1506,70 ,   1576,24 ,   1506,70 ,   1506,70 ,   1576,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {77,65,68},       70,5 ,   1642,87 ,      13,5 ,       4,0 ,      87,7 ,     181,6 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Morocco
    {      8,     1,   162,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {79,77,82},       75,5 ,   1729,77 ,      13,5 ,       4,0 ,      87,7 ,     187,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Oman
    {      8,     1,   165,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1202,92 ,   1202,92 ,   1294,24 ,   1202,92 ,   1202,92 ,   1294,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {73,76,83},       49,1 ,  1057,133 ,      13,5 ,       4,0 ,      87,7 ,    192,18 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Palestinian Territories
    {      8,     1,   175,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {81,65,82},       80,5 ,   1806,70 ,      13,5 ,       4,0 ,      87,7 ,     210,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Qatar
    {      8,     1,   186,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {83,65,82},       85,5 ,   1876,77 ,      13,5 ,       4,0 ,      87,7 ,    213,24 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Saudi Arabia
    {      8,     1,   194,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {83,79,83},       90,1 ,   1953,77 ,      13,5 ,       4,0 ,      87,7 ,     237,7 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Somalia
    {      8,     1,   201,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {83,68,71},       91,4 ,   2030,91 ,      13,5 ,       4,0 ,      87,7 ,     244,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Sudan
    {      8,     1,   207,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1202,92 ,   1202,92 ,   1294,24 ,   1202,92 ,   1202,92 ,   1294,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {83,89,80},       95,5 ,   2121,77 ,      13,5 ,       4,0 ,      87,7 ,     251,5 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Syria
    {      8,     1,   216,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1107,71 ,   1107,71 ,   1178,24 ,   1107,71 ,   1107,71 ,   1178,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {84,78,68},      100,5 ,   2198,95 ,      13,5 ,       4,0 ,      87,7 ,     256,4 ,     3,     0,     7,     5,     6 }, // Arabic/Arabic/Tunisia
    {      8,     1,   223,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {65,69,68},      105,5 ,   2293,91 ,      13,5 ,       4,0 ,      87,7 ,    260,24 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/United Arab Emirates
    {      8,     1,   236,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {77,65,68},       70,5 ,   1642,87 ,      13,5 ,       4,0 ,      87,7 ,    284,15 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Western Sahara
    {      8,     1,   237,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {89,69,82},      110,5 ,   2384,70 ,      13,5 ,       4,0 ,      87,7 ,     299,5 ,     0,     0,     7,     5,     6 }, // Arabic/Arabic/Yemen
    {      8,     1,   254,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 , {83,83,80},      115,1 ,  2454,132 ,      13,5 ,       4,0 ,      87,7 ,    304,12 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/South Sudan
    {      8,     1,   260,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      52,7 ,      59,6 ,    147,10 ,    157,17 ,      18,7 ,     25,12 ,   1008,75 ,   1008,75 ,   1083,24 ,   1008,75 ,   1008,75 ,   1083,24 ,    538,52 ,    538,52 ,    590,14 ,    538,52 ,    538,52 ,    590,14 ,      21,1 ,      21,1 ,   84,4 ,  88,41 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,    316,23 ,     339,6 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/World
    {      9,    10,    11,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,      65,7 ,      65,7 ,     174,8 ,    182,20 ,      37,5 ,      8,10 ,   1600,48 ,   1648,94 ,   1742,24 ,   1600,48 ,  1766,106 ,   1742,24 ,    604,28 ,    632,62 ,    694,14 ,    604,28 ,    632,62 ,    694,14 ,      22,2 ,      22,2 ,  129,6 , 135,17 ,  22,23 , {65,77,68},      116,1 ,   2586,46 ,      13,5 ,       4,0 ,     345,7 ,     352,8 ,     0,     0,     1,     6,     7 }, // Armenian/Armenian/Armenia
    {     10,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      72,9 ,      72,9 ,     202,8 ,    210,18 ,      68,7 ,     75,12 ,   1872,64 ,   1936,89 ,   2025,24 ,   1872,64 ,   1936,89 ,   2025,24 ,    708,32 ,    740,58 ,    798,14 ,    708,32 ,    740,58 ,    798,14 ,      24,9 ,      24,7 ,  152,4 , 156,37 ,  22,23 , {73,78,82},      117,1 ,   2632,43 ,       8,5 ,       4,0 ,     360,7 ,     367,4 ,     2,     1,     7,     7,     7 }, // Assamese/Bengali/India
    {     12,     7,    15,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      81,8 ,      81,8 ,     174,8 ,    228,17 ,      37,5 ,      8,10 ,   2049,48 ,   2097,77 ,    158,27 ,   2049,48 ,   2174,77 ,    158,27 ,    812,27 ,    839,67 ,     99,14 ,    812,27 ,    839,67 ,     99,14 ,       0,2 ,       0,2 ,  193,4 ,   5,17 ,  22,23 , {65,90,78},      118,1 ,   2675,58 ,       8,5 ,       4,0 ,    371,10 ,    381,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Latin/Azerbaijan
    {     12,     1,   102,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     6,     5,     5 }, // Azerbaijani/Arabic/Iran
    {     12,     2,    15,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     174,8 ,    228,17 ,      37,5 ,      8,10 ,   2251,48 ,   2299,77 ,    158,27 ,   2251,48 ,   2376,77 ,    158,27 ,    906,27 ,    933,67 ,     99,14 ,    906,27 ,    933,67 ,     99,14 ,      33,2 ,      31,2 ,   45,4 ,   5,17 ,  22,23 , {65,90,78},      118,1 ,   2733,12 ,       8,5 ,       4,0 ,    391,10 ,    401,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     13,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Bashkir/Cyrillic/Russia
    {     14,     7,   197,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8220,    8221,       0,6 ,       0,6 ,      89,9 ,      89,9 ,     245,6 ,    251,36 ,      37,5 ,     87,12 ,   2453,60 ,   2513,93 ,   2606,24 ,   2453,60 ,   2630,93 ,   2606,24 ,   1000,28 ,   1028,68 ,   1096,14 ,   1000,28 ,   1110,68 ,   1096,14 ,       0,2 ,       0,2 ,  197,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   2745,20 ,      13,5 ,       4,0 ,     411,7 ,     418,8 ,     2,     1,     1,     6,     7 }, // Basque/Latin/Spain
    {     15,    11,    18,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      98,9 ,      98,9 ,     287,6 ,    210,18 ,      18,7 ,     25,12 ,   2723,90 ,   2723,90 ,   2813,33 ,   2846,77 ,   2723,90 ,   2813,33 ,   1178,37 ,   1215,58 ,   1273,18 ,   1178,37 ,   1291,58 ,   1273,18 ,       0,2 ,       0,2 ,  152,4 ,   5,17 ,  22,23 , {66,68,84},      120,1 ,   2765,49 ,       0,4 ,       4,0 ,     426,5 ,     431,8 ,     2,     1,     7,     6,     7 }, // Bengali/Bengali/Bangladesh
    {     15,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      98,9 ,      98,9 ,     287,6 ,    210,18 ,      18,7 ,     25,12 ,   2723,90 ,   2723,90 ,   2813,33 ,   2846,77 ,   2723,90 ,   2813,33 ,   1178,37 ,   1215,58 ,   1273,18 ,   1178,37 ,   1291,58 ,   1273,18 ,       0,2 ,       0,2 ,  152,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   2814,43 ,       0,4 ,       4,0 ,     426,5 ,     439,4 ,     2,     1,     7,     7,     7 }, // Bengali/Bengali/India
    {     16,    31,    25,    46,    44,    59,    37,  3872,    45,    43,   101,    8220,    8221,    8216,    8217,     107,9 ,     107,9 ,     107,9 ,     107,9 ,     53,10 ,    293,30 ,     99,22 ,    121,27 ,   2923,63 ,  2986,191 ,   3177,27 ,   3204,27 ,  3231,132 ,   3363,27 ,   1349,34 ,   1383,79 ,   1462,27 ,   1349,34 ,   1383,79 ,   1462,27 ,      35,5 ,      33,6 ,   45,4 ,   5,17 ,  22,23 , {66,84,78},      121,3 ,   2857,15 ,       4,4 ,       4,0 ,     443,6 ,     449,5 ,     2,     1,     7,     6,     7 }, // Dzongkha/Tibetan/Bhutan
    {     19,     7,    74,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   3390,63 ,   3453,78 ,   3531,36 ,   3390,63 ,   3453,78 ,   3531,36 ,   1489,33 ,   1522,43 ,   1565,18 ,   1489,33 ,   1522,43 ,   1565,18 ,      40,4 ,      39,4 ,  204,7 , 211,17 , 228,23 , {69,85,82},       14,1 ,   2872,36 ,      13,5 ,       4,0 ,     454,9 ,     463,5 ,     2,     1,     1,     6,     7 }, // Breton/Latin/France
    {     20,     2,    33,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    323,12 ,    335,22 ,     148,9 ,    157,14 ,   3567,49 ,   3616,82 ,   3698,24 ,   3567,49 ,   3616,82 ,   3698,24 ,   1583,21 ,   1604,55 ,   1659,14 ,   1583,21 ,   1604,55 ,   1659,14 ,      44,6 ,      43,6 ,  251,7 ,   5,17 ,  22,23 , {66,71,78},      124,3 ,   2908,47 ,      13,5 ,       4,0 ,     468,9 ,     477,8 ,     2,     1,     1,     6,     7 }, // Bulgarian/Cyrillic/Bulgaria
    {     21,    25,   147,    46,    44,  4170,    37,  4160,    45,    43,   101,    8220,    8221,    8216,    8217,     123,5 ,     123,5 ,    128,10 ,    128,10 ,     357,8 ,    365,18 ,     171,6 ,    177,10 ,   3722,43 ,   3765,88 ,   3853,24 ,   3722,43 ,   3765,88 ,   3853,24 ,   1673,54 ,   1673,54 ,   1727,14 ,   1673,54 ,   1673,54 ,   1727,14 ,      50,5 ,      49,3 ,  258,5 ,   5,17 ,  22,23 , {77,77,75},      127,1 ,   2955,29 ,      13,5 ,       4,0 ,     485,6 ,     485,6 ,     0,     0,     7,     6,     7 }, // Burmese/Myanmar/Myanmar
    {     22,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     138,7 ,     138,7 ,     383,7 ,    335,22 ,      37,5 ,    187,11 ,   3877,48 ,   3925,95 ,   4020,24 ,   4044,48 ,   4092,98 ,   4020,24 ,   1741,21 ,   1762,56 ,   1818,14 ,   1741,21 ,   1762,56 ,   1818,14 ,       0,2 ,       0,2 ,  263,5 , 268,17 ,  22,23 , {66,89,78},        0,2 ,   2984,89 ,      13,5 ,       4,0 ,    491,10 ,     501,8 ,     2,     0,     1,     6,     7 }, // Belarusian/Cyrillic/Belarus
    {     23,    20,    36,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     145,9 ,     154,9 ,     287,6 ,     98,16 ,      18,7 ,     25,12 ,   4190,71 ,   4190,71 ,   4261,24 ,   4190,71 ,   4190,71 ,   4261,24 ,   1832,47 ,   1832,47 ,   1879,14 ,   1832,47 ,   1832,47 ,   1879,14 ,       0,2 ,       0,2 ,  285,2 ,   5,17 ,  22,23 , {75,72,82},      128,1 ,   3073,29 ,       0,4 ,       4,0 ,     509,5 ,     514,7 ,     2,     1,     7,     6,     7 }, // Khmer/Khmer/Cambodia
    {     24,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     287,6 ,    390,22 ,      55,4 ,      59,9 ,   4285,60 ,   4345,82 ,   4427,36 ,   4463,93 ,  4556,115 ,   4427,36 ,   1893,28 ,   1921,60 ,   1981,21 ,   1893,28 ,   1921,60 ,   1981,21 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     521,6 ,     527,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Spain
    {     24,     7,     5,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     287,6 ,    390,22 ,      55,4 ,      59,9 ,   4285,60 ,   4345,82 ,   4427,36 ,   4463,93 ,  4556,115 ,   4427,36 ,   1893,28 ,   1921,60 ,   1981,21 ,   1893,28 ,   1921,60 ,   1981,21 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     521,6 ,     534,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Andorra
    {     24,     7,    74,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     287,6 ,    390,22 ,      55,4 ,      59,9 ,   4285,60 ,   4345,82 ,   4427,36 ,   4463,93 ,  4556,115 ,   4427,36 ,   1893,28 ,   1921,60 ,   1981,21 ,   1893,28 ,   1921,60 ,   1981,21 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     521,6 ,     541,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/France
    {     24,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     287,6 ,    390,22 ,      55,4 ,      59,9 ,   4285,60 ,   4345,82 ,   4427,36 ,   4463,93 ,  4556,115 ,   4427,36 ,   1893,28 ,   1921,60 ,   1981,21 ,   1893,28 ,   1921,60 ,   1981,21 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     521,6 ,     547,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Italy
    {     25,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     170,5 ,     170,5 ,     175,5 ,     175,5 ,     412,8 ,    420,13 ,     198,6 ,    204,11 ,   4671,39 ,   4710,38 ,    158,27 ,   4671,39 ,   4710,38 ,    158,27 ,   2002,21 ,   2023,28 ,   2051,14 ,   2002,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  287,2 , 289,21 ,  22,23 , {67,78,89},      129,1 ,   3122,13 ,       4,4 ,       4,0 ,     553,4 ,     557,2 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/China
    {     25,     5,    97,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     170,5 ,     170,5 ,     175,5 ,     175,5 ,     287,6 ,    420,13 ,     198,6 ,    204,11 ,   4671,39 ,   4710,38 ,    158,27 ,   4671,39 ,   4710,38 ,    158,27 ,   2002,21 ,   2023,28 ,   2051,14 ,   2002,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  287,2 , 289,21 ,  22,23 , {72,75,68},      130,3 ,   3135,11 ,       4,4 ,       4,0 ,     553,4 ,     559,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Hong Kong
    {     25,     5,   126,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     170,5 ,     170,5 ,     175,5 ,     175,5 ,     287,6 ,    420,13 ,     198,6 ,    204,11 ,   4671,39 ,   4710,38 ,    158,27 ,   4671,39 ,   4710,38 ,    158,27 ,   2002,21 ,   2023,28 ,   2051,14 ,   2002,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  287,2 , 289,21 ,  22,23 , {77,79,80},      133,4 ,   3146,13 ,       4,4 ,       4,0 ,     553,4 ,     568,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Macau
    {     25,     5,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     170,5 ,     170,5 ,     175,5 ,     175,5 ,      27,8 ,    420,13 ,     198,6 ,    204,11 ,   4671,39 ,   4710,38 ,    158,27 ,   4671,39 ,   4710,38 ,    158,27 ,   2002,21 ,   2023,28 ,   2051,14 ,   2002,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  287,2 , 289,21 ,  22,23 , {83,71,68},        6,1 ,   3159,15 ,       4,4 ,       4,0 ,     553,4 ,     577,3 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Singapore
    {     25,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     170,5 ,     170,5 ,     180,5 ,     180,5 ,     433,8 ,    420,13 ,     198,6 ,    215,13 ,   4671,39 ,   4671,39 ,    158,27 ,   4671,39 ,   4671,39 ,    158,27 ,   2065,21 ,   2023,28 ,   2051,14 ,   2065,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  310,3 ,   5,17 ,  22,23 , {72,75,68},      130,3 ,   3135,11 ,      18,5 ,       4,0 ,     580,4 ,     584,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Hong Kong
    {     25,     6,   126,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     170,5 ,     170,5 ,     180,5 ,     180,5 ,     433,8 ,    420,13 ,     198,6 ,    215,13 ,   4671,39 ,   4671,39 ,    158,27 ,   4671,39 ,   4671,39 ,    158,27 ,   2065,21 ,   2023,28 ,   2051,14 ,   2065,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,  310,3 ,   5,17 ,  22,23 , {77,79,80},      133,4 ,   3174,13 ,      18,5 ,       4,0 ,     580,4 ,     593,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Macau
    {     25,     6,   208,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     170,5 ,     170,5 ,     175,5 ,     175,5 ,     412,8 ,    441,14 ,     198,6 ,    215,13 ,   4671,39 ,   4671,39 ,    158,27 ,   4671,39 ,   4671,39 ,    158,27 ,   2065,21 ,   2023,28 ,   2051,14 ,   2065,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,   45,4 ,   5,17 ,  22,23 , {84,87,68},        6,1 ,   3187,13 ,       4,4 ,       4,0 ,     580,4 ,     602,2 ,     2,     0,     7,     6,     7 }, // Chinese/Traditional Han/Taiwan
    {     26,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Corsican/Latin/France
    {     27,     7,    54,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    455,13 ,    468,19 ,      37,5 ,     87,12 ,   4748,49 ,   4797,94 ,   4891,39 ,   4748,49 ,   4930,98 ,   4891,39 ,   2086,28 ,   2114,58 ,   2172,14 ,   2086,28 ,   2114,58 ,   2186,14 ,       0,2 ,       0,2 ,  313,7 ,   5,17 ,  22,23 , {72,82,75},      137,3 ,   3200,60 ,      13,5 ,       4,0 ,     604,8 ,     612,8 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Croatia
    {     27,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     487,9 ,    468,19 ,      37,5 ,     87,12 ,   4748,49 ,   4797,94 ,   4891,39 ,   4748,49 ,   4930,98 ,   4891,39 ,   2086,28 ,   2114,58 ,   2186,14 ,   2086,28 ,   2114,58 ,   2186,14 ,       0,2 ,       0,2 ,  313,7 ,   5,17 ,  22,23 , {66,65,77},      140,2 ,   3260,85 ,      13,5 ,       4,0 ,     604,8 ,    620,19 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Bosnia And Herzegowina
    {     28,     7,    57,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     185,7 ,     185,7 ,     174,8 ,    496,17 ,      55,4 ,      59,9 ,   5028,48 ,   5076,82 ,    158,27 ,   5028,48 ,   5158,84 ,    158,27 ,   2200,21 ,   2221,49 ,   2270,14 ,   2200,21 ,   2221,49 ,   2270,14 ,      62,4 ,      59,4 ,  320,5 ,   5,17 ,  22,23 , {67,90,75},      142,2 ,   3345,68 ,      13,5 ,       4,0 ,     639,7 ,     646,5 ,     2,     0,     1,     6,     7 }, // Czech/Latin/Czech Republic
    {     29,     7,    58,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,    120,10 ,    513,23 ,     228,5 ,    233,10 ,   5242,59 ,   5301,84 ,    134,24 ,   5242,59 ,   5301,84 ,    134,24 ,   2284,28 ,   2312,51 ,   2363,14 ,   2377,35 ,   2312,51 ,   2363,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {68,75,75},      144,3 ,   3413,42 ,      13,5 ,       4,0 ,     651,5 ,     656,7 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Denmark
    {     29,     7,    86,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,    120,10 ,    513,23 ,     228,5 ,    233,10 ,   5242,59 ,   5301,84 ,    134,24 ,   5242,59 ,   5301,84 ,    134,24 ,   2284,28 ,   2312,51 ,   2363,14 ,   2377,35 ,   2312,51 ,   2363,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {68,75,75},      144,3 ,   3413,42 ,      13,5 ,       4,0 ,     651,5 ,     663,8 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Greenland
    {     30,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,      13,5 ,       4,0 ,    671,10 ,     681,9 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Netherlands
    {     30,     7,    12,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {65,87,71},      147,4 ,   3474,55 ,      13,5 ,       4,0 ,    671,10 ,     690,5 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Aruba
    {     30,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     536,7 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,      13,5 ,       4,0 ,    671,10 ,     695,6 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Belgium
    {     30,     7,   152,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {65,78,71},      151,4 ,   3529,97 ,      13,5 ,       4,0 ,    671,10 ,     701,7 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Cura Sao
    {     30,     7,   202,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {83,82,68},        6,1 ,   3626,58 ,      13,5 ,       4,0 ,    671,10 ,     708,8 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Suriname
    {     30,     7,   255,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3684,61 ,      13,5 ,       4,0 ,    671,10 ,    716,19 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Bonaire
    {     30,     7,   256,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   5385,59 ,   5444,88 ,    134,24 ,   5385,59 ,   5444,88 ,    134,24 ,   2412,21 ,   2433,59 ,   2492,14 ,   2412,21 ,   2433,59 ,   2492,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {65,78,71},      151,4 ,   3529,97 ,      13,5 ,       4,0 ,    671,10 ,    735,12 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Sint Maarten
    {     31,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,    747,16 ,    763,13 ,     2,     1,     7,     6,     7 }, // English/Latin/United States
    {     31,     3,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // English/Deseret/United States
    {     31,     7,     4,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,    783,14 ,     2,     1,     7,     6,     7 }, // English/Latin/American Samoa
    {     31,     7,     7,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,     797,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Anguilla
    {     31,     7,     9,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,    805,17 ,     2,     1,     7,     6,     7 }, // English/Latin/Antigua And Barbuda
    {     31,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     210,9 ,     210,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,   5532,59 ,     48,86 ,    134,24 ,   5532,59 ,     48,86 ,    134,24 ,   2506,35 ,     28,57 ,   2541,25 ,   2506,35 ,     28,57 ,   2541,25 ,      70,2 ,      67,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,    822,18 ,     840,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Australia
    {     31,     7,    14,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       8,5 ,       4,0 ,     776,7 ,     849,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Austria
    {     31,     7,    16,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,83,68},        6,1 ,   3930,53 ,       4,4 ,       4,0 ,     776,7 ,     856,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Bahamas
    {     31,     7,    19,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,66,68},        6,1 ,   3983,56 ,       4,4 ,       4,0 ,     776,7 ,     863,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Barbados
    {     31,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,      27,8 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     776,7 ,     871,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Belgium
    {     31,     7,    22,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,      27,8 ,     80,18 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,90,68},        6,1 ,   4039,47 ,       4,4 ,       4,0 ,     776,7 ,     878,6 ,     2,     1,     7,     6,     7 }, // English/Latin/Belize
    {     31,     7,    24,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,77,68},        6,1 ,   4086,53 ,       4,4 ,       4,0 ,     776,7 ,     884,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Bermuda
    {     31,     7,    28,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,      27,8 ,     80,18 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,87,80},      158,1 ,   4139,50 ,       4,4 ,       4,0 ,     776,7 ,     891,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Botswana
    {     31,     7,    31,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,    899,30 ,     2,     1,     1,     6,     7 }, // English/Latin/British Indian Ocean Territory
    {     31,     7,    35,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,73,70},      159,3 ,   4189,53 ,       4,4 ,       4,0 ,     776,7 ,     929,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Burundi
    {     31,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   4242,83 ,       4,4 ,       4,0 ,     776,7 ,     936,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Cameroon
    {     31,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     53,10 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,   5532,59 ,     48,86 ,    134,24 ,   2506,35 ,     28,57 ,     85,14 ,   2506,35 ,     28,57 ,     85,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {67,65,68},        6,1 ,   4325,53 ,       4,4 ,       4,0 ,    944,16 ,     960,6 ,     2,     0,     7,     6,     7 }, // English/Latin/Canada
    {     31,     7,    40,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {75,89,68},        6,1 ,   4378,71 ,       4,4 ,       4,0 ,     776,7 ,    966,14 ,     2,     1,     1,     6,     7 }, // English/Latin/Cayman Islands
    {     31,     7,    45,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,    980,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Christmas Island
    {     31,     7,    46,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,    996,23 ,     2,     1,     1,     6,     7 }, // English/Latin/Cocos Islands
    {     31,     7,    51,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     776,7 ,   1019,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Cook Islands
    {     31,     7,    56,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     776,7 ,    1031,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Cyprus
    {     31,     7,    58,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,     228,5 ,    233,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {68,75,75},      144,3 ,   4511,44 ,      13,5 ,       4,0 ,     776,7 ,    1037,7 ,     2,     0,     1,     6,     7 }, // English/Latin/Denmark
    {     31,     7,    60,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,    1044,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Dominica
    {     31,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,82,78},       41,3 ,   4555,50 ,       4,4 ,       4,0 ,     776,7 ,    1052,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Eritrea
    {     31,     7,    70,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {70,75,80},      115,1 ,   4605,74 ,       4,4 ,       4,0 ,     776,7 ,   1059,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Falkland Islands
    {     31,     7,    72,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {70,74,68},        6,1 ,   4679,47 ,       4,4 ,       4,0 ,     776,7 ,    1075,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Fiji
    {     31,     7,    73,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,     243,4 ,     247,9 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     776,7 ,    1079,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Finland
    {     31,     7,    75,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,   4726,32 ,       4,4 ,       4,0 ,     776,7 ,    1086,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Guernsey
    {     31,     7,    80,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,77,68},      162,1 ,   4758,50 ,       4,4 ,       4,0 ,     776,7 ,    1094,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Gambia
    {     31,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     776,7 ,    1100,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Germany
    {     31,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,72,83},      163,3 ,   4808,47 ,       4,4 ,       4,0 ,     776,7 ,    1107,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Ghana
    {     31,     7,    84,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,73,80},      115,1 ,   4855,53 ,       4,4 ,       4,0 ,     776,7 ,    1112,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Gibraltar
    {     31,     7,    87,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,    1121,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Grenada
    {     31,     7,    89,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,    1128,4 ,     2,     1,     7,     6,     7 }, // English/Latin/Guam
    {     31,     7,    93,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,89,68},        6,1 ,   4908,56 ,       4,4 ,       4,0 ,     776,7 ,    1132,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Guyana
    {     31,     7,    97,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     433,8 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {72,75,68},      130,3 ,   4964,56 ,       4,4 ,       4,0 ,     776,7 ,   1138,19 ,     2,     1,     7,     6,     7 }, // English/Latin/Hong Kong
    {     31,     7,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,      27,8 ,    210,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   5020,44 ,       8,5 ,       4,0 ,     776,7 ,    1157,5 ,     2,     1,     7,     7,     7 }, // English/Latin/India
    {     31,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     776,7 ,    1162,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Ireland
    {     31,     7,   105,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      55,4 ,      59,9 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {73,76,83},       49,1 ,   5064,62 ,       4,4 ,       4,0 ,     776,7 ,    1169,6 ,     2,     1,     7,     5,     6 }, // English/Latin/Israel
    {     31,     7,   107,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {74,77,68},        6,1 ,   5126,53 ,       4,4 ,       4,0 ,     776,7 ,    1175,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Jamaica
    {     31,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,   5179,53 ,       4,4 ,       4,0 ,     776,7 ,    1182,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Kenya
    {     31,     7,   112,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,    1187,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Kiribati
    {     31,     7,   120,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,   5232,61 ,       4,4 ,       4,0 ,     776,7 ,    1195,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Lesotho
    {     31,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,   5293,53 ,       4,4 ,       4,0 ,     776,7 ,    1202,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Liberia
    {     31,     7,   126,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {77,79,80},      133,4 ,   5346,53 ,       4,4 ,       4,0 ,     776,7 ,   1209,15 ,     2,     1,     7,     6,     7 }, // English/Latin/Macau
    {     31,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {77,71,65},      166,2 ,   5399,54 ,       4,4 ,       4,0 ,     776,7 ,   1224,10 ,     0,     0,     1,     6,     7 }, // English/Latin/Madagascar
    {     31,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {77,87,75},      168,2 ,   5453,53 ,       4,4 ,       4,0 ,     776,7 ,    1234,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Malawi
    {     31,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {77,89,82},      170,2 ,   5506,59 ,       4,4 ,       4,0 ,     776,7 ,    1240,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Malaysia
    {     31,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     776,7 ,    1248,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Malta
    {     31,     7,   134,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1253,16 ,     2,     1,     7,     6,     7 }, // English/Latin/Marshall Islands
    {     31,     7,   137,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {77,85,82},      172,2 ,   5565,53 ,       4,4 ,       4,0 ,     776,7 ,    1269,9 ,     0,     0,     1,     6,     7 }, // English/Latin/Mauritius
    {     31,     7,   140,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1278,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Micronesia
    {     31,     7,   144,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,   1288,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Montserrat
    {     31,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,   5618,53 ,       4,4 ,       4,0 ,     776,7 ,    1298,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Namibia
    {     31,     7,   149,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,    1305,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Nauru
    {     31,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       8,5 ,      23,6 ,     776,7 ,   1310,11 ,     2,     1,     1,     6,     7 }, // English/Latin/Netherlands
    {     31,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     536,7 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     776,7 ,   1321,11 ,     2,     1,     1,     6,     7 }, // English/Latin/New Zealand
    {     31,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,   5671,50 ,       4,4 ,       4,0 ,     776,7 ,    1332,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Nigeria
    {     31,     7,   158,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     776,7 ,    1339,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Niue
    {     31,     7,   159,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,   1343,14 ,     2,     1,     1,     6,     7 }, // English/Latin/Norfolk Island
    {     31,     7,   160,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1357,24 ,     2,     1,     1,     6,     7 }, // English/Latin/Northern Mariana Islands
    {     31,     7,   163,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {80,75,82},      172,2 ,   5721,53 ,       4,4 ,       4,0 ,     776,7 ,    1381,8 ,     0,     0,     7,     6,     7 }, // English/Latin/Pakistan
    {     31,     7,   164,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,    1389,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Palau
    {     31,     7,   167,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {80,71,75},      127,1 ,   5774,73 ,       4,4 ,       4,0 ,     776,7 ,   1394,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Papua New Guinea
    {     31,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      175,1 ,   5847,53 ,       4,4 ,       4,0 ,     776,7 ,   1410,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Philippines
    {     31,     7,   171,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     776,7 ,   1421,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Pitcairn
    {     31,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1437,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Puerto Rico
    {     31,     7,   179,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {82,87,70},      176,2 ,   5900,47 ,       4,4 ,       4,0 ,     776,7 ,    1448,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Rwanda
    {     31,     7,   180,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,   1454,17 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Kitts And Nevis
    {     31,     7,   181,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,    1471,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Lucia
    {     31,     7,   182,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     776,7 ,   1480,24 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Vincent And The Grenadines
    {     31,     7,   183,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {87,83,84},      178,3 ,   5947,40 ,       4,4 ,       4,0 ,     776,7 ,    1504,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Samoa
    {     31,     7,   188,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,67,82},      181,2 ,   5987,59 ,       4,4 ,       4,0 ,     776,7 ,   1509,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Seychelles
    {     31,     7,   189,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,76,76},      183,2 ,   6046,68 ,       4,4 ,       4,0 ,     776,7 ,   1519,12 ,     0,     0,     1,     6,     7 }, // English/Latin/Sierra Leone
    {     31,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,   6114,56 ,       4,4 ,       4,0 ,     776,7 ,    1531,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Singapore
    {     31,     7,   192,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,      29,7 ,     776,7 ,    1540,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Slovenia
    {     31,     7,   193,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,66,68},        6,1 ,   6170,74 ,       4,4 ,       4,0 ,     776,7 ,   1548,15 ,     2,     1,     1,     6,     7 }, // English/Latin/Solomon Islands
    {     31,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    549,10 ,     80,18 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,   5232,61 ,       4,4 ,       4,0 ,     776,7 ,   1563,12 ,     2,     1,     7,     6,     7 }, // English/Latin/South Africa
    {     31,     7,   199,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,72,80},      115,1 ,   6244,56 ,       4,4 ,       4,0 ,     776,7 ,   1575,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Helena
    {     31,     7,   201,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,68,71},        0,0 ,   6300,50 ,       4,4 ,       4,0 ,     776,7 ,    1585,5 ,     2,     1,     6,     5,     6 }, // English/Latin/Sudan
    {     31,     7,   204,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,90,76},      185,1 ,   6350,53 ,       4,4 ,       4,0 ,     776,7 ,    1590,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Swaziland
    {     31,     7,   205,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     53,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,69,75},      186,2 ,   6403,47 ,      13,5 ,       4,0 ,     776,7 ,    1599,6 ,     2,     0,     1,     6,     7 }, // English/Latin/Sweden
    {     31,     7,   206,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {67,72,70},        0,0 ,   6450,41 ,       8,5 ,      36,5 ,     776,7 ,   1605,11 ,     2,     0,     1,     6,     7 }, // English/Latin/Switzerland
    {     31,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,   6491,62 ,       4,4 ,       4,0 ,     776,7 ,    1616,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Tanzania
    {     31,     7,   213,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     776,7 ,    1624,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Tokelau
    {     31,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {84,79,80},      191,2 ,   6553,49 ,       4,4 ,       4,0 ,     776,7 ,    1631,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Tonga
    {     31,     7,   215,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {84,84,68},        6,1 ,   6602,80 ,       4,4 ,       4,0 ,     776,7 ,   1636,17 ,     2,     1,     7,     6,     7 }, // English/Latin/Trinidad And Tobago
    {     31,     7,   219,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1653,22 ,     2,     1,     1,     6,     7 }, // English/Latin/Turks And Caicos Islands
    {     31,     7,   220,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     776,7 ,    1675,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Tuvalu
    {     31,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,   6682,56 ,       4,4 ,       4,0 ,     776,7 ,    1681,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Uganda
    {     31,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     210,9 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      70,2 ,      67,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,   6738,47 ,       4,4 ,       4,0 ,   1687,15 ,   1702,14 ,     2,     1,     1,     6,     7 }, // English/Latin/United Kingdom
    {     31,     7,   226,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1716,21 ,     2,     1,     7,     6,     7 }, // English/Latin/United States Minor Outlying Islands
    {     31,     7,   229,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {86,85,86},      196,2 ,   6785,44 ,       4,4 ,       4,0 ,     776,7 ,    1737,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Vanuatu
    {     31,     7,   233,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1744,22 ,     2,     1,     1,     6,     7 }, // English/Latin/British Virgin Islands
    {     31,     7,   234,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1766,19 ,     2,     1,     7,     6,     7 }, // English/Latin/United States Virgin Islands
    {     31,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {90,77,87},      127,1 ,   6829,50 ,       4,4 ,       4,0 ,     776,7 ,    1785,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Zambia
    {     31,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     433,8 ,     80,18 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,    1791,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Zimbabwe
    {     31,     7,   249,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,   3745,35 ,       4,4 ,       4,0 ,     776,7 ,   1799,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Diego Garcia
    {     31,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,   4726,32 ,       4,4 ,       4,0 ,     776,7 ,   1811,11 ,     2,     1,     1,     6,     7 }, // English/Latin/Isle Of Man
    {     31,     7,   252,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,   4726,32 ,       4,4 ,       4,0 ,     776,7 ,    1822,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Jersey
    {     31,     7,   254,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {83,83,80},      115,1 ,   6879,68 ,       4,4 ,       4,0 ,     776,7 ,   1828,11 ,     2,     1,     1,     6,     7 }, // English/Latin/South Sudan
    {     31,     7,   256,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,78,71},      151,4 ,   6947,95 ,       4,4 ,       4,0 ,     776,7 ,   1839,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Sint Maarten
    {     31,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       4,4 ,       4,0 ,     776,7 ,    1851,5 ,     2,     1,     1,     6,     7 }, // English/Latin/World
    {     31,     7,   261,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    200,10 ,     210,9 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,      0,48 ,     48,86 ,    134,24 ,      0,48 ,     48,86 ,    134,24 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,     776,7 ,    1856,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Europe
    {     32,     7,   260,    44,   160,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     219,9 ,     219,9 ,     559,8 ,    567,26 ,      37,5 ,    256,25 ,   5591,48 ,   5639,91 ,    134,24 ,   5591,48 ,   5639,91 ,    134,24 ,   2566,21 ,   2587,51 ,   2638,14 ,   2566,21 ,   2587,51 ,   2638,14 ,      72,3 ,      69,3 ,  325,6 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      41,6 ,       4,0 ,    1862,9 ,       0,0 ,     2,     1,     1,     6,     7 }, // Esperanto/Latin/World
    {     33,     7,    68,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     228,8 ,     228,8 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   5730,59 ,   5789,91 ,   5880,24 ,   5730,59 ,   5789,91 ,   5880,24 ,   2652,14 ,   2666,63 ,   2652,14 ,   2652,14 ,   2666,63 ,   2652,14 ,       0,2 ,       0,2 ,  331,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   7042,20 ,      13,5 ,       4,0 ,    1871,5 ,    1876,5 ,     2,     1,     1,     6,     7 }, // Estonian/Latin/Estonia
    {     34,     7,    71,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   5904,48 ,   5952,83 ,    134,24 ,   6035,59 ,   5952,83 ,    134,24 ,   2729,28 ,   2757,74 ,   2831,14 ,   2845,35 ,   2757,74 ,   2831,14 ,       0,2 ,       0,2 ,  337,3 , 340,17 ,  22,23 , {68,75,75},      186,2 ,   7062,43 ,      13,5 ,       4,0 ,    1881,8 ,    1889,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/Faroe Islands
    {     34,     7,    58,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   5904,48 ,   5952,83 ,    134,24 ,   6035,59 ,   5952,83 ,    134,24 ,   2729,28 ,   2757,74 ,   2831,14 ,   2845,35 ,   2757,74 ,   2831,14 ,       0,2 ,       0,2 ,  337,3 , 340,17 ,  22,23 , {68,75,75},      144,3 ,   7062,43 ,      13,5 ,       4,0 ,    1881,8 ,     656,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/Denmark
    {     36,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     228,8 ,     228,8 ,     611,8 ,    496,17 ,     243,4 ,     247,9 ,   6094,69 ,  6163,105 ,   6268,24 ,   6292,93 ,  6385,129 ,   6268,24 ,   2880,21 ,   2901,67 ,   2968,14 ,   2880,21 ,   2982,81 ,   2968,14 ,      75,3 ,      72,3 ,  357,5 , 362,17 , 379,23 , {69,85,82},       14,1 ,   7105,20 ,      13,5 ,       4,0 ,    1896,5 ,    1901,5 ,     2,     1,     1,     6,     7 }, // Finnish/Latin/Finland
    {     37,     7,    74,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,    1914,6 ,     2,     1,     1,     6,     7 }, // French/Latin/France
    {     37,     7,     3,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {68,90,68},      198,2 ,   7125,51 ,      13,5 ,       4,0 ,    1906,8 ,    1920,7 ,     2,     1,     6,     5,     6 }, // French/Latin/Algeria
    {     37,     7,    21,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,     536,7 ,     98,16 ,      37,5 ,    281,23 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,    1927,8 ,     2,     1,     1,     6,     7 }, // French/Latin/Belgium
    {     37,     7,    23,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,    1935,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Benin
    {     37,     7,    34,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,   1940,12 ,     0,     0,     1,     6,     7 }, // French/Latin/Burkina Faso
    {     37,     7,    35,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {66,73,70},      159,3 ,   7235,53 ,      13,5 ,       4,0 ,    1906,8 ,     929,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Burundi
    {     37,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,      78,5 ,      75,4 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,    1952,8 ,     0,     0,     1,     6,     7 }, // French/Latin/Cameroon
    {     37,     7,    38,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8221,    8220,       0,6 ,       0,6 ,     236,8 ,     236,8 ,     559,8 ,     98,16 ,     304,9 ,    313,24 ,   6662,64 ,   6577,85 ,    134,24 ,   6662,64 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,      66,4 ,      63,4 ,  402,6 , 211,17 , 228,23 , {67,65,68},        6,1 ,   7344,54 ,      47,6 ,       4,0 ,   1960,17 ,     960,6 ,     2,     0,     7,     6,     7 }, // French/Latin/Canada
    {     37,     7,    41,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,   1977,25 ,     0,     0,     1,     6,     7 }, // French/Latin/Central African Republic
    {     37,     7,    42,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,    2002,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Chad
    {     37,     7,    48,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {75,77,70},       36,2 ,   7398,51 ,      13,5 ,       4,0 ,    1906,8 ,    2007,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Comoros
    {     37,     7,    49,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {67,68,70},      203,2 ,   7449,53 ,      13,5 ,       4,0 ,    1906,8 ,   2014,14 ,     2,     1,     1,     6,     7 }, // French/Latin/Congo Kinshasa
    {     37,     7,    50,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,   2028,17 ,     0,     0,     1,     6,     7 }, // French/Latin/Congo Brazzaville
    {     37,     7,    53,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,   2045,13 ,     0,     0,     1,     6,     7 }, // French/Latin/Ivory Coast
    {     37,     7,    59,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {68,74,70},       38,3 ,   7502,57 ,      13,5 ,       4,0 ,    1906,8 ,    2058,8 ,     0,     0,     6,     6,     7 }, // French/Latin/Djibouti
    {     37,     7,    66,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,   2066,18 ,     0,     0,     1,     6,     7 }, // French/Latin/Equatorial Guinea
    {     37,     7,    76,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2084,16 ,     2,     1,     1,     6,     7 }, // French/Latin/French Guiana
    {     37,     7,    77,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,80,70},      205,4 ,   7559,35 ,      13,5 ,       4,0 ,    1906,8 ,   2100,19 ,     0,     0,     1,     6,     7 }, // French/Latin/French Polynesia
    {     37,     7,    79,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,65,70},       32,4 ,   7288,56 ,      13,5 ,       4,0 ,    1906,8 ,    2119,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Gabon
    {     37,     7,    88,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2124,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Guadeloupe
    {     37,     7,    91,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {71,78,70},      209,2 ,   7594,48 ,      13,5 ,       4,0 ,    1906,8 ,    2134,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Guinea
    {     37,     7,    94,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {72,84,71},      211,1 ,   7642,57 ,      13,5 ,       4,0 ,    1906,8 ,    2140,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Haiti
    {     37,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2145,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Luxembourg
    {     37,     7,   128,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {77,71,65},      166,2 ,   7699,54 ,      13,5 ,       4,0 ,    1906,8 ,   1224,10 ,     0,     0,     1,     6,     7 }, // French/Latin/Madagascar
    {     37,     7,   132,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,    2155,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Mali
    {     37,     7,   135,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2159,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Martinique
    {     37,     7,   136,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {77,82,85},      212,2 ,   7753,66 ,      13,5 ,       4,0 ,    1906,8 ,   2169,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Mauritania
    {     37,     7,   137,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {77,85,82},      172,2 ,   7819,63 ,      13,5 ,       4,0 ,    1906,8 ,    2179,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Mauritius
    {     37,     7,   138,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,    2186,7 ,     2,     1,     1,     6,     7 }, // French/Latin/Mayotte
    {     37,     7,   142,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,    2193,6 ,     2,     1,     1,     6,     7 }, // French/Latin/Monaco
    {     37,     7,   145,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6726,61 ,   6577,85 ,    134,24 ,   6726,61 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,      66,4 ,      63,4 ,  402,6 , 211,17 , 228,23 , {77,65,68},      214,3 ,   7882,54 ,      13,5 ,       4,0 ,    1906,8 ,    2199,5 ,     2,     1,     6,     5,     6 }, // French/Latin/Morocco
    {     37,     7,   153,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,80,70},      205,4 ,   7559,35 ,      13,5 ,       4,0 ,    1906,8 ,   2204,18 ,     0,     0,     1,     6,     7 }, // French/Latin/New Caledonia
    {     37,     7,   156,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,    2222,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Niger
    {     37,     7,   176,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2227,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Reunion
    {     37,     7,   179,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {82,87,70},      176,2 ,   7936,50 ,      13,5 ,       4,0 ,    1906,8 ,    1448,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Rwanda
    {     37,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,    2237,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Senegal
    {     37,     7,   188,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {83,67,82},      181,2 ,   7986,71 ,      13,5 ,       4,0 ,    1906,8 ,   1509,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Seychelles
    {     37,     7,   200,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2244,24 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Pierre And Miquelon
    {     37,     7,   206,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     236,8 ,     236,8 ,     174,8 ,     10,17 ,      37,5 ,    337,14 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {67,72,70},      217,3 ,   8057,45 ,      13,5 ,      53,6 ,   2268,15 ,    2283,6 ,     2,     0,     1,     6,     7 }, // French/Latin/Switzerland
    {     37,     7,   207,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {83,89,80},      220,2 ,   8102,51 ,      13,5 ,       4,0 ,    1906,8 ,    2289,5 ,     0,     0,     6,     5,     6 }, // French/Latin/Syria
    {     37,     7,   212,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,79,70},      200,3 ,   7176,59 ,      13,5 ,       4,0 ,    1906,8 ,    2294,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Togo
    {     37,     7,   216,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {84,78,68},      222,2 ,   8153,51 ,      13,5 ,       4,0 ,    1906,8 ,    2298,7 ,     3,     0,     7,     5,     6 }, // French/Latin/Tunisia
    {     37,     7,   229,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      18,7 ,     25,12 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {86,85,86},      196,2 ,   8204,51 ,      13,5 ,       4,0 ,    1906,8 ,    1737,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Vanuatu
    {     37,     7,   235,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {88,80,70},      205,4 ,   7559,35 ,      13,5 ,       4,0 ,    1906,8 ,   2305,16 ,     0,     0,     1,     6,     7 }, // French/Latin/Wallis And Futuna Islands
    {     37,     7,   244,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2321,16 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Barthelemy
    {     37,     7,   245,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     236,8 ,     236,8 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   6514,63 ,   6577,85 ,    134,24 ,   6514,63 ,   6577,85 ,    134,24 ,   3063,35 ,   3098,52 ,   3150,14 ,   3063,35 ,   3098,52 ,   3150,14 ,       0,2 ,       0,2 ,  402,6 , 211,17 , 228,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1906,8 ,   2337,12 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Martin
    {     38,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     357,8 ,     98,16 ,      37,5 ,      8,10 ,   6787,48 ,   6835,95 ,    134,24 ,   6787,48 ,   6835,95 ,    134,24 ,   3164,21 ,   3185,54 ,     85,14 ,   3164,21 ,   3185,54 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,       8,5 ,      59,6 ,    2349,5 ,    2354,8 ,     2,     1,     1,     6,     7 }, // Western Frisian/Latin/Netherlands
    {     39,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    244,10 ,    244,10 ,    120,10 ,    619,21 ,      37,5 ,      8,10 ,   6930,61 ,  6991,142 ,   7133,24 ,   6930,61 ,  7157,167 ,   7133,24 ,   3239,28 ,   3267,69 ,   3336,14 ,   3239,28 ,   3267,69 ,   3336,14 ,      83,1 ,      79,1 ,  408,6 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,   8255,86 ,       4,4 ,       4,0 ,    2362,8 ,   2370,22 ,     2,     1,     1,     6,     7 }, // Gaelic/Latin/United Kingdom
    {     40,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,   7324,60 ,   7384,87 ,   7471,24 ,   7495,60 ,   7555,87 ,   7642,36 ,   3350,35 ,   3385,49 ,   3434,14 ,   3448,35 ,   3483,49 ,   3532,21 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,    2392,6 ,    2398,6 ,     2,     1,     1,     6,     7 }, // Galician/Latin/Spain
    {     41,    15,    81,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,     171,     187,       0,6 ,       0,6 ,     261,8 ,     261,8 ,     174,8 ,    667,19 ,      37,5 ,      8,10 ,   7678,48 ,   7726,99 ,   7825,24 ,   7678,48 ,   7726,99 ,   7825,24 ,   3553,28 ,   3581,62 ,   3643,14 ,   3553,28 ,   3581,62 ,   3643,14 ,       0,2 ,       0,2 ,  414,5 , 419,33 ,  22,23 , {71,69,76},      224,1 ,   8341,43 ,      13,5 ,       4,0 ,    2404,7 ,   2411,10 ,     2,     1,     1,     6,     7 }, // Georgian/Georgian/Georgia
    {     42,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,   7897,83 ,    134,24 ,   7980,59 ,   7897,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,    2421,7 ,   2428,11 ,     2,     1,     1,     6,     7 }, // German/Latin/Germany
    {     42,     7,    14,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   8039,48 ,   8087,83 ,    134,24 ,   8170,59 ,   8087,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,       8,5 ,       4,0 ,   2439,24 ,   2463,10 ,     2,     1,     1,     6,     7 }, // German/Latin/Austria
    {     42,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,   7897,83 ,    134,24 ,   7980,59 ,   7897,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,    2421,7 ,    2473,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Belgium
    {     42,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   8039,48 ,   8087,83 ,    134,24 ,   8170,59 ,   8087,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,    2421,7 ,    2480,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Italy
    {     42,     7,   123,    46,  8217,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,   7897,83 ,    134,24 ,   7980,59 ,   7897,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,   8403,58 ,       8,5 ,       4,0 ,    2421,7 ,   2487,13 ,     2,     0,     1,     6,     7 }, // German/Latin/Liechtenstein
    {     42,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,   7897,83 ,    134,24 ,   7980,59 ,   7897,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,    2421,7 ,    2500,9 ,     2,     1,     1,     6,     7 }, // German/Latin/Luxembourg
    {     42,     7,   206,    46,  8217,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,   7897,83 ,    134,24 ,   7980,59 ,   7897,83 ,    134,24 ,   3657,21 ,   3678,60 ,   3738,14 ,   3752,28 ,   3678,60 ,   3738,14 ,       0,2 ,       0,2 ,  452,5 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,   8403,58 ,       8,5 ,      36,5 ,   2509,21 ,    2530,7 ,     2,     0,     1,     6,     7 }, // German/Latin/Switzerland
    {     43,    16,    85,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     278,9 ,     278,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,   8229,50 ,  8279,115 ,   8394,24 ,   8418,50 ,  8468,115 ,   8394,24 ,   3780,28 ,   3808,55 ,   3863,14 ,   3780,28 ,   3808,55 ,   3863,14 ,      84,4 ,      80,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8461,19 ,      13,5 ,       4,0 ,    2537,8 ,    2545,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Greece
    {     43,    16,    56,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     278,9 ,     278,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,   8229,50 ,  8279,115 ,   8394,24 ,   8418,50 ,  8468,115 ,   8394,24 ,   3780,28 ,   3808,55 ,   3863,14 ,   3780,28 ,   3808,55 ,   3863,14 ,      84,4 ,      80,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8461,19 ,      13,5 ,       4,0 ,    2537,8 ,    2551,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Cyprus
    {     44,     7,    86,    44,    46,    59,    37,    48,  8722,    43,   101,     187,     171,    8250,    8249,       0,6 ,       0,6 ,    287,11 ,    287,11 ,     53,10 ,    686,17 ,     228,5 ,    233,10 ,   8583,48 ,   8631,96 ,    134,24 ,   8583,48 ,   8631,96 ,    134,24 ,   3877,28 ,   3905,98 ,   4003,14 ,   3877,28 ,   3905,98 ,   4003,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {68,75,75},      144,3 ,   8480,62 ,       4,4 ,      65,5 ,   2557,11 ,   2568,16 ,     2,     0,     1,     6,     7 }, // Greenlandic/Latin/Greenland
    {     45,     7,   168,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,89,71},      225,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     7,     6,     7 }, // Guarani/Latin/Paraguay
    {     46,    17,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     298,9 ,     298,9 ,     287,6 ,    210,18 ,     351,8 ,    359,13 ,   8727,67 ,   8794,87 ,   8881,31 ,   8727,67 ,   8794,87 ,   8881,31 ,   4017,32 ,   4049,53 ,   4102,19 ,   4017,32 ,   4049,53 ,   4102,19 ,       0,2 ,       0,2 ,  457,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   8542,46 ,       4,4 ,       4,0 ,    2584,7 ,    2591,4 ,     2,     1,     7,     7,     7 }, // Gujarati/Gujarati/India
    {     47,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     287,6 ,    210,18 ,      37,5 ,      8,10 ,   8912,48 ,   8960,85 ,   9045,24 ,   8912,48 ,   8960,85 ,   9045,24 ,   4121,28 ,   4149,52 ,   4201,14 ,   4121,28 ,   4149,52 ,   4201,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,   8588,12 ,       8,5 ,       4,0 ,    2595,5 ,    2600,8 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Nigeria
    {     47,     1,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Hausa/Arabic/Nigeria
    {     47,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     287,6 ,    210,18 ,      37,5 ,      8,10 ,   8912,48 ,   8960,85 ,   9045,24 ,   8912,48 ,   8960,85 ,   9045,24 ,   4121,28 ,   4149,52 ,   4201,14 ,   4121,28 ,   4149,52 ,   4201,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      163,3 ,       0,7 ,       8,5 ,       4,0 ,    2595,5 ,    2608,4 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Ghana
    {     47,     7,   156,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     287,6 ,    210,18 ,      37,5 ,      8,10 ,   8912,48 ,   8960,85 ,   9045,24 ,   8912,48 ,   8960,85 ,   9045,24 ,   4121,28 ,   4149,52 ,   4201,14 ,   4121,28 ,   4149,52 ,   4201,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,   8600,36 ,       8,5 ,       4,0 ,    2595,5 ,    2612,5 ,     0,     0,     1,     6,     7 }, // Hausa/Latin/Niger
    {     48,    18,   105,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     307,6 ,     307,6 ,     611,8 ,    703,18 ,      55,4 ,      59,9 ,   9069,58 ,   9127,72 ,    158,27 ,   9069,58 ,   9127,72 ,    158,27 ,   4215,46 ,   4261,65 ,   4326,21 ,   4215,46 ,   4261,65 ,   4326,21 ,      88,6 ,      84,5 ,  461,4 ,   5,17 ,  22,23 , {73,76,83},       49,1 ,   8636,54 ,      70,6 ,      76,8 ,    2617,5 ,    2622,5 ,     2,     1,     7,     5,     6 }, // Hebrew/Hebrew/Israel
    {     49,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     313,9 ,     322,8 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,   9199,59 ,   9258,73 ,   9331,30 ,   9199,59 ,   9258,73 ,   9331,30 ,   4347,32 ,   4379,53 ,   4432,19 ,   4347,32 ,   4379,53 ,   4432,19 ,      94,9 ,      89,7 ,  465,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   8690,42 ,       4,4 ,       4,0 ,    2627,6 ,    2633,4 ,     2,     1,     7,     7,     7 }, // Hindi/Devanagari/India
    {     50,     7,    98,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     187,     171,       0,6 ,       0,6 ,     330,8 ,     330,8 ,    721,13 ,    734,19 ,      55,4 ,      59,9 ,   9361,64 ,   9425,98 ,   9523,25 ,   9361,64 ,   9425,98 ,   9523,25 ,   4451,19 ,   4470,52 ,   4522,17 ,   4451,19 ,   4470,52 ,   4522,17 ,     103,3 ,      96,3 ,  469,4 ,   5,17 ,  22,23 , {72,85,70},      226,2 ,   8732,46 ,      13,5 ,       4,0 ,    2637,6 ,   2643,12 ,     2,     0,     1,     6,     7 }, // Hungarian/Latin/Hungary
    {     51,     7,    99,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     192,8 ,     192,8 ,     611,8 ,    593,18 ,      37,5 ,      8,10 ,   9548,59 ,   9607,82 ,   9689,24 ,   9548,59 ,   9607,82 ,   9689,24 ,   4539,35 ,   4574,81 ,   4655,14 ,   4539,35 ,   4574,81 ,   4655,14 ,     106,4 ,      99,4 ,  473,4 ,   5,17 ,  22,23 , {73,83,75},      228,3 ,   8778,49 ,      13,5 ,       4,0 ,    2655,8 ,    2663,6 ,     0,     0,     1,     6,     7 }, // Icelandic/Latin/Iceland
    {     52,     7,   101,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    338,10 ,     348,9 ,      27,8 ,     80,18 ,     228,5 ,    233,10 ,   9713,48 ,   9761,87 ,    134,24 ,   9713,48 ,   9761,87 ,    134,24 ,   4669,28 ,   4697,43 ,   4740,14 ,   4669,28 ,   4697,43 ,   4740,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,68,82},      231,2 ,   8827,39 ,       4,4 ,       4,0 ,    2669,9 ,    2669,9 ,     0,     0,     7,     6,     7 }, // Indonesian/Latin/Indonesia
    {     53,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Interlingua/Latin/France
    {     55,    44,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      233,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Canadian Aboriginal/Canada
    {     55,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      233,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Latin/Canada
    {     57,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    357,11 ,    244,10 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,   9848,62 ,  9910,107 ,  10017,24 ,   9848,62 ,  9910,107 ,  10017,24 ,   4754,37 ,   4791,75 ,   4866,14 ,   4754,37 ,   4791,75 ,   4866,14 ,     110,4 ,     103,4 ,  477,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8866,31 ,       4,4 ,       4,0 ,    2678,7 ,    2685,4 ,     2,     1,     7,     6,     7 }, // Irish/Latin/Ireland
    {     58,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,     98,16 ,      37,5 ,      8,10 ,  10041,48 ,  10089,94 ,  10183,24 ,  10041,48 ,  10089,94 ,  10183,24 ,   4880,28 ,   4908,57 ,   4965,14 ,   4880,28 ,   4908,57 ,   4965,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8897,19 ,      13,5 ,       4,0 ,    2689,8 ,    2697,6 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Italy
    {     58,     7,   184,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,     98,16 ,      37,5 ,      8,10 ,  10041,48 ,  10089,94 ,  10183,24 ,  10041,48 ,  10089,94 ,  10183,24 ,   4880,28 ,   4908,57 ,   4965,14 ,   4880,28 ,   4908,57 ,   4965,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8897,19 ,      13,5 ,       4,0 ,    2689,8 ,   2703,10 ,     2,     1,     1,     6,     7 }, // Italian/Latin/San Marino
    {     58,     7,   206,    46,  8217,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     254,7 ,     254,7 ,     174,8 ,     10,17 ,      37,5 ,      8,10 ,  10041,48 ,  10089,94 ,  10183,24 ,  10041,48 ,  10089,94 ,  10183,24 ,   4880,28 ,   4908,57 ,   4965,14 ,   4880,28 ,   4908,57 ,   4965,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,   8916,53 ,       8,5 ,      36,5 ,    2689,8 ,    2713,8 ,     2,     0,     1,     6,     7 }, // Italian/Latin/Switzerland
    {     58,     7,   230,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,     98,16 ,      37,5 ,      8,10 ,  10041,48 ,  10089,94 ,  10183,24 ,  10041,48 ,  10089,94 ,  10183,24 ,   4880,28 ,   4908,57 ,   4965,14 ,   4880,28 ,   4908,57 ,   4965,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8897,19 ,      13,5 ,       4,0 ,    2689,8 ,   2721,18 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Vatican City State
    {     59,    19,   108,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     170,5 ,     170,5 ,     170,5 ,     170,5 ,    549,10 ,    420,13 ,      55,4 ,    372,10 ,   4671,39 ,   4671,39 ,    158,27 ,   4671,39 ,   4671,39 ,    158,27 ,   4979,14 ,   4993,28 ,   4979,14 ,   4979,14 ,   4993,28 ,   4979,14 ,     114,2 ,     107,2 ,  483,3 , 340,17 ,  22,23 , {74,80,89},      129,1 ,   8969,11 ,       4,4 ,       4,0 ,    2739,3 ,    2742,2 ,     0,     0,     7,     6,     7 }, // Japanese/Japanese/Japan
    {     60,     7,   101,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,68,82},      231,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     7,     6,     7 }, // Javanese/Latin/Indonesia
    {     61,    21,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    368,12 ,    380,11 ,     287,6 ,     35,18 ,     351,8 ,    359,13 ,  10207,63 ,  10270,87 ,  10357,31 ,  10388,69 ,  10270,87 ,  10357,31 ,   5021,33 ,   5054,54 ,   5108,20 ,   5021,33 ,   5054,54 ,   5108,20 ,     116,9 ,     109,7 ,  486,8 , 494,33 ,  22,23 , {73,78,82},      117,1 ,   8980,49 ,       4,4 ,       4,0 ,    2744,5 ,    2749,4 ,     2,     1,     7,     7,     7 }, // Kannada/Kannada/India
    {     62,     1,   100,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,  10457,72 ,  10457,72 ,  10529,24 ,  10457,72 ,  10457,72 ,  10529,24 ,   5128,54 ,   5182,56 ,   5238,14 ,   5128,54 ,   5182,56 ,   5238,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   9029,23 ,       8,5 ,       4,0 ,    2753,5 ,   2758,10 ,     2,     1,     7,     7,     7 }, // Kashmiri/Arabic/India
    {     63,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,    391,10 ,     174,8 ,    753,22 ,      37,5 ,      8,10 ,  10553,60 ,  10613,83 ,  10696,24 ,  10720,60 ,  10780,83 ,  10696,24 ,   5252,21 ,   5273,56 ,   5329,14 ,   5252,21 ,   5343,56 ,   5329,14 ,       0,2 ,       0,2 ,  527,4 , 531,17 , 548,23 , {75,90,84},      236,1 ,   9052,58 ,      13,5 ,       4,0 ,   2768,10 ,    2778,9 ,     2,     1,     1,     6,     7 }, // Kazakh/Cyrillic/Kazakhstan
    {     64,     7,   179,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  10863,60 , 10923,101 ,    158,27 ,  10863,60 , 10923,101 ,    158,27 ,   5399,35 ,   5434,84 ,     85,14 ,   5399,35 ,   5434,84 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,87,70},      176,2 ,       0,7 ,       8,5 ,       4,0 ,   2787,11 ,    2798,8 ,     0,     0,     1,     6,     7 }, // Kinyarwanda/Latin/Rwanda
    {     65,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,    401,10 ,    401,10 ,     287,6 ,    775,23 ,      37,5 ,      8,10 ,  11024,48 ,  11072,80 ,  11152,24 ,  11176,59 ,  11235,80 ,  11152,24 ,   5518,38 ,   5556,57 ,   5613,14 ,   5518,38 ,   5556,57 ,   5613,14 ,     125,5 ,    116,14 ,  527,4 , 571,17 ,  22,23 , {75,71,83},      237,3 ,   9110,52 ,      13,5 ,       4,0 ,    2806,8 ,   2814,10 ,     2,     1,     1,     6,     7 }, // Kirghiz/Cyrillic/Kyrgyzstan
    {     66,    22,   114,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     411,7 ,     411,7 ,     798,9 ,    807,16 ,     382,7 ,    389,13 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,   5627,14 ,   5641,28 ,   5627,14 ,   5627,14 ,   5641,28 ,   5627,14 ,     130,2 ,     130,2 ,  588,3 ,   5,17 ,  22,23 , {75,82,87},      240,1 ,   9162,19 ,       4,4 ,       4,0 ,    2824,3 ,    2827,4 ,     0,     0,     7,     6,     7 }, // Korean/Korean/South Korea
    {     66,    22,   113,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     411,7 ,     411,7 ,     798,9 ,    807,16 ,     382,7 ,    389,13 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,  11315,39 ,   5627,14 ,   5641,28 ,   5627,14 ,   5627,14 ,   5641,28 ,   5627,14 ,     130,2 ,     130,2 ,  588,3 ,   5,17 ,  22,23 , {75,80,87},      241,3 ,   9181,39 ,       4,4 ,       4,0 ,    2824,3 ,   2831,11 ,     0,     0,     1,     6,     7 }, // Korean/Korean/North Korea
    {     67,     7,   217,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {84,82,89},      244,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Kurdish/Latin/Turkey
    {     68,     7,    35,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  11354,60 , 11414,106 ,    158,27 ,  11354,60 , 11414,106 ,    158,27 ,   5669,34 ,   5703,89 ,     85,14 ,   5669,34 ,   5703,89 ,     85,14 ,     132,5 ,     132,5 ,   45,4 ,   5,17 ,  22,23 , {66,73,70},      159,3 ,   9220,27 ,       0,4 ,       4,0 ,    2842,8 ,    2850,8 ,     0,     0,     1,     6,     7 }, // Rundi/Latin/Burundi
    {     69,    23,   117,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,     418,9 ,     433,8 ,    823,19 ,      55,4 ,    402,24 ,  11520,61 ,  11581,75 ,    158,27 ,  11520,61 ,  11581,75 ,    158,27 ,   5792,36 ,   5828,57 ,   5885,17 ,   5792,36 ,   5828,57 ,   5885,17 ,     137,8 ,     137,8 ,   45,4 ,   5,17 ,  22,23 , {76,65,75},      245,1 ,   9247,21 ,       4,4 ,      36,5 ,    2858,3 ,    2858,3 ,     0,     0,     7,     6,     7 }, // Lao/Lao/Laos
    {     71,     7,   118,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     427,8 ,     427,8 ,     174,8 ,    842,26 ,      37,5 ,      8,10 ,  11656,65 , 11721,101 ,    134,24 ,  11656,65 , 11721,101 ,    134,24 ,   5902,51 ,   5953,72 ,   6025,14 ,   6039,51 ,   6090,72 ,   6025,14 ,    145,14 ,    145,11 ,  591,5 , 340,17 ,  22,23 , {69,85,82},       14,1 ,   9268,23 ,      13,5 ,       4,0 ,    2861,8 ,    2869,7 ,     2,     1,     1,     6,     7 }, // Latvian/Latin/Latvia
    {     72,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     435,9 ,     435,9 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  11822,48 , 11870,203 ,  12073,24 ,  11822,48 , 11870,203 ,  12073,24 ,   6162,28 ,  6190,100 ,   6290,14 ,   6162,28 ,  6190,100 ,   6290,14 ,     159,8 ,     156,6 ,   45,4 ,   5,17 ,  22,23 , {67,68,70},      203,2 ,   9291,23 ,      13,5 ,       4,0 ,    2876,7 ,   2883,30 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Congo Kinshasa
    {     72,     7,     6,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     435,9 ,     435,9 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  11822,48 , 11870,203 ,  12073,24 ,  11822,48 , 11870,203 ,  12073,24 ,   6162,28 ,  6190,100 ,   6290,14 ,   6162,28 ,  6190,100 ,   6290,14 ,     159,8 ,     156,6 ,   45,4 ,   5,17 ,  22,23 , {65,79,65},      246,2 ,   9314,23 ,      13,5 ,       4,0 ,    2876,7 ,    2913,6 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Angola
    {     72,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     435,9 ,     435,9 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  11822,48 , 11870,203 ,  12073,24 ,  11822,48 , 11870,203 ,  12073,24 ,   6162,28 ,  6190,100 ,   6290,14 ,   6162,28 ,  6190,100 ,   6290,14 ,     159,8 ,     156,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   9337,23 ,      13,5 ,       4,0 ,    2876,7 ,   2919,26 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/Central African Republic
    {     72,     7,    50,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     435,9 ,     435,9 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  11822,48 , 11870,203 ,  12073,24 ,  11822,48 , 11870,203 ,  12073,24 ,   6162,28 ,  6190,100 ,   6290,14 ,   6162,28 ,  6190,100 ,   6290,14 ,     159,8 ,     156,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   9337,23 ,      13,5 ,       4,0 ,    2876,7 ,    2945,5 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/Congo Brazzaville
    {     73,     7,   124,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,     444,8 ,     444,8 ,     53,10 ,    868,27 ,      37,5 ,      8,10 ,  12097,70 ,  12167,96 ,  12263,24 ,  12097,70 ,  12287,98 ,  12263,24 ,   6304,21 ,   6325,89 ,   6414,14 ,   6304,21 ,   6325,89 ,   6414,14 ,     167,9 ,     162,6 ,  596,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9360,30 ,      13,5 ,       4,0 ,    2950,8 ,    2958,7 ,     2,     1,     1,     6,     7 }, // Lithuanian/Latin/Lithuania
    {     74,     2,   127,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,     895,7 ,     80,18 ,      37,5 ,      8,10 ,  12385,61 ,  12446,85 ,  12531,24 ,  12385,61 ,  12446,85 ,  12531,24 ,   6428,35 ,   6463,54 ,   1659,14 ,   6517,34 ,   6463,54 ,   1659,14 ,    176,10 ,     168,8 ,  602,5 ,   5,17 ,  22,23 , {77,75,68},      248,3 ,   9390,56 ,      13,5 ,       4,0 ,   2965,10 ,   2975,10 ,     2,     1,     1,     6,     7 }, // Macedonian/Cyrillic/Macedonia
    {     75,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     98,16 ,      37,5 ,      8,10 ,  12555,48 ,  12603,92 ,    134,24 ,  12555,48 ,  12603,92 ,    134,24 ,   6551,34 ,   6585,60 ,   6645,14 ,   6551,34 ,   6585,60 ,   6645,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,71,65},      166,2 ,   9446,13 ,       8,5 ,       4,0 ,    2985,8 ,   2993,12 ,     0,     0,     1,     6,     7 }, // Malagasy/Latin/Madagascar
    {     76,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     348,9 ,     348,9 ,     536,7 ,     10,17 ,      18,7 ,     25,12 ,  12695,48 ,  12743,82 ,  12825,24 ,  12695,48 ,  12743,82 ,  12825,24 ,   6659,28 ,   6687,43 ,   6730,14 ,   6659,28 ,   6687,43 ,   6730,14 ,     186,2 ,     176,3 ,  607,4 ,   5,17 ,  22,23 , {77,89,82},      170,2 ,   9459,39 ,       4,4 ,       4,0 ,    3005,6 ,    1240,8 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Malaysia
    {     76,     1,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,89,82},      170,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Malay/Arabic/Malaysia
    {     76,     7,    32,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     348,9 ,     348,9 ,     536,7 ,    902,12 ,      18,7 ,     25,12 ,  12695,48 ,  12743,82 ,  12825,24 ,  12695,48 ,  12743,82 ,  12825,24 ,   6659,28 ,   6687,43 ,   6730,14 ,   6659,28 ,   6687,43 ,   6730,14 ,     186,2 ,     176,3 ,  607,4 ,   5,17 ,  22,23 , {66,78,68},        6,1 ,   9498,31 ,       8,5 ,       4,0 ,    3005,6 ,    3011,6 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Brunei
    {     76,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     348,9 ,     348,9 ,     536,7 ,     10,17 ,      18,7 ,     25,12 ,  12695,48 ,  12743,82 ,  12825,24 ,  12695,48 ,  12743,82 ,  12825,24 ,   6659,28 ,   6687,43 ,   6730,14 ,   6659,28 ,   6687,43 ,   6730,14 ,     186,2 ,     176,3 ,  607,4 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,   9529,37 ,       4,4 ,       4,0 ,    3005,6 ,    3017,9 ,     2,     1,     7,     6,     7 }, // Malay/Latin/Singapore
    {     77,    24,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    452,13 ,    465,12 ,     287,6 ,    914,18 ,      18,7 ,     25,12 ,  12849,62 ,  12911,88 ,  12999,32 ,  12849,62 ,  12911,88 ,  12999,32 ,   6744,41 ,   6785,77 ,   6862,22 ,   6744,41 ,   6884,76 ,   6960,21 ,       0,2 ,       0,2 ,  611,6 , 617,31 ,  22,23 , {73,78,82},      117,1 ,   9566,40 ,       4,4 ,       4,0 ,    3026,6 ,    3032,6 ,     2,     1,     7,     7,     7 }, // Malayalam/Malayalam/India
    {     78,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     477,8 ,     485,7 ,    120,10 ,    932,23 ,      37,5 ,      8,10 ,  13031,48 ,  13079,86 ,  13165,36 ,  13031,48 ,  13079,86 ,  13201,24 ,   6981,28 ,   7009,63 ,   7072,21 ,   6981,28 ,   7009,63 ,   7093,20 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9606,27 ,       4,4 ,       4,0 ,    3038,5 ,    1248,5 ,     2,     1,     7,     6,     7 }, // Maltese/Latin/Malta
    {     79,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,90,68},      251,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Maori/Latin/New Zealand
    {     80,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     492,9 ,     492,9 ,     287,6 ,    210,18 ,      18,7 ,     25,12 ,  13225,66 ,  13291,86 ,  13377,32 ,  13225,66 ,  13291,86 ,  13377,32 ,   7113,32 ,   7145,53 ,   4432,19 ,   7113,32 ,   7145,53 ,   4432,19 ,     188,5 ,     179,4 ,  465,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   9633,43 ,       4,4 ,       4,0 ,    3043,5 ,    2633,4 ,     2,     1,     7,     7,     7 }, // Marathi/Devanagari/India
    {     82,     2,   143,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    955,10 ,    965,16 ,      37,5 ,     87,12 ,  13409,99 , 13508,190 ,  13698,38 ,  13409,99 , 13508,190 ,  13698,38 ,   7198,21 ,   7219,43 ,   7198,21 ,   7198,21 ,   7219,43 ,   7198,21 ,     193,3 ,     183,3 ,  527,4 , 571,17 ,  22,23 , {77,78,84},      254,1 ,   9676,25 ,       8,5 ,       4,0 ,    3048,6 ,    3054,6 ,     0,     0,     1,     6,     7 }, // Mongolian/Cyrillic/Mongolia
    {     82,     8,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      255,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Mongolian/Mongolian/China
    {     84,    13,   150,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,     501,5 ,       0,6 ,     506,7 ,     506,7 ,     245,6 ,     63,17 ,      37,5 ,      8,10 ,  13736,85 ,  13736,85 ,  13821,53 ,  13736,85 ,  13736,85 ,  13874,52 ,   7262,33 ,   7295,54 ,   7349,18 ,   7262,33 ,   7295,54 ,   7349,18 ,      94,9 ,      89,7 ,  465,4 ,   5,17 ,  22,23 , {78,80,82},      258,4 ,   9701,49 ,       8,5 ,       4,0 ,    3060,6 ,    3066,5 ,     2,     1,     7,     6,     7 }, // Nepali/Devanagari/Nepal
    {     84,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,     501,5 ,       0,6 ,     506,7 ,     506,7 ,     245,6 ,     63,17 ,      18,7 ,     25,12 ,  13736,85 ,  13736,85 ,  13821,53 ,  13736,85 ,  13736,85 ,  13874,52 ,   7262,33 ,   7295,54 ,   7349,18 ,   7262,33 ,   7295,54 ,   7349,18 ,      94,9 ,      89,7 ,  465,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   9750,49 ,       8,5 ,       4,0 ,    3060,6 ,    2633,4 ,     2,     1,     7,     7,     7 }, // Nepali/Devanagari/India
    {     85,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,    981,10 ,    496,17 ,      37,5 ,      8,10 ,   5904,48 ,  13926,83 ,    134,24 ,   6035,59 ,  13926,83 ,    134,24 ,   2377,35 ,   2312,51 ,   2363,14 ,   2377,35 ,   2312,51 ,   2363,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      186,2 ,   9799,44 ,       8,5 ,       4,0 ,   3071,12 ,    3083,5 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/Norway
    {     85,     7,   203,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,    981,10 ,    496,17 ,      37,5 ,      8,10 ,   5904,48 ,  13926,83 ,    134,24 ,   6035,59 ,  13926,83 ,    134,24 ,   2377,35 ,   2312,51 ,   2363,14 ,   2377,35 ,   2312,51 ,   2363,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      186,2 ,   9799,44 ,       8,5 ,       4,0 ,   3071,12 ,   3088,21 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/Svalbard And Jan Mayen Islands
    {     86,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Occitan/Latin/France
    {     87,    26,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     513,8 ,     521,7 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,  14009,86 ,  14009,86 ,  14095,32 ,  14009,86 ,  14009,86 ,  14095,32 ,   7367,33 ,   7400,54 ,   7454,18 ,   7367,33 ,   7400,54 ,   7454,18 ,       0,2 ,       0,2 ,  648,5 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,   9843,43 ,       8,5 ,       4,0 ,    3109,5 ,    3114,4 ,     2,     1,     7,     7,     7 }, // Oriya/Oriya/India
    {     88,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,      46,6 ,      46,6 ,     528,9 ,     537,8 ,     412,8 ,    991,20 ,      55,4 ,    426,11 ,  14127,68 ,  14195,69 ,    158,27 ,  14264,69 ,  14264,69 ,  14333,24 ,   7472,39 ,   7472,39 ,     85,14 ,   7472,39 ,   7472,39 ,     85,14 ,     196,4 ,     186,4 ,    0,5 ,   5,17 ,  22,23 , {65,70,78},      262,1 ,   9886,25 ,      13,5 ,       4,0 ,    3118,4 ,    3122,9 ,     0,     0,     6,     4,     5 }, // Pashto/Arabic/Afghanistan
    {     89,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,     545,7 ,     545,7 ,     552,8 ,     560,7 ,     412,8 ,     98,16 ,      55,4 ,    426,11 ,  14357,70 ,  14357,70 ,  14427,24 ,  14451,74 ,  14451,74 ,  14427,24 ,   7511,49 ,   7511,49 ,   7560,14 ,   7511,49 ,   7511,49 ,   7560,14 ,     200,9 ,     190,8 ,  653,4 , 657,39 ,  22,23 , {73,82,82},      263,4 ,   9911,37 ,      84,5 ,       4,0 ,    3131,5 ,    3136,5 ,     0,     0,     6,     5,     5 }, // Persian/Arabic/Iran
    {     89,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,     545,7 ,     545,7 ,     552,8 ,     560,7 ,     412,8 ,     98,16 ,      55,4 ,    426,11 ,  14525,68 ,  14525,68 ,  14333,24 ,  14593,62 ,  14525,68 ,  14333,24 ,   7511,49 ,   7511,49 ,   7560,14 ,   7511,49 ,   7511,49 ,   7560,14 ,     200,9 ,     190,8 ,  653,4 , 657,39 ,  22,23 , {65,70,78},      262,1 ,   9948,55 ,       8,5 ,       4,0 ,    3141,3 ,    3122,9 ,     0,     0,     6,     4,     5 }, // Persian/Arabic/Afghanistan
    {     90,     7,   172,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    981,10 ,     10,17 ,      37,5 ,      8,10 ,  14655,48 ,  14703,97 ,  14800,24 ,  14655,48 ,  14824,99 ,  14923,24 ,   7574,34 ,   7608,59 ,   7667,14 ,   7574,34 ,   7608,59 ,   7681,14 ,       0,2 ,       0,2 ,  320,5 ,   5,17 ,  22,23 , {80,76,78},      267,2 ,  10003,77 ,      13,5 ,       4,0 ,    3144,6 ,    3150,6 ,     2,     1,     1,     6,     7 }, // Polish/Latin/Poland
    {     91,     7,    30,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     254,7 ,     254,7 ,    120,10 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7695,28 ,   7723,79 ,   7802,14 ,   7695,28 ,   7723,79 ,   7802,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,82,76},      269,2 ,  10080,54 ,       8,5 ,       4,0 ,    3156,9 ,    3165,6 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Brazil
    {     91,     7,     6,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {65,79,65},      246,2 ,  10134,54 ,      13,5 ,       4,0 ,    3156,9 ,    3171,6 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Angola
    {     91,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {67,86,69},      271,1 ,  10188,69 ,      13,5 ,       4,0 ,    3156,9 ,   3177,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Cape Verde
    {     91,     7,    62,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,  10257,81 ,      13,5 ,       4,0 ,    3156,9 ,   3187,11 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/East Timor
    {     91,     7,    66,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  10338,59 ,      13,5 ,       4,0 ,    3156,9 ,   3198,16 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/Equatorial Guinea
    {     91,     7,    92,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  10397,62 ,      13,5 ,       4,0 ,    3156,9 ,   3214,12 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/Guinea Bissau
    {     91,     7,   125,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3156,9 ,   3226,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Luxembourg
    {     91,     7,   126,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      18,7 ,     25,12 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {77,79,80},      133,4 ,  10459,53 ,      13,5 ,       4,0 ,    3156,9 ,   3236,19 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Macau
    {     91,     7,   146,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {77,90,78},      272,3 ,  10512,72 ,      13,5 ,       4,0 ,    3156,9 ,   3255,10 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Mozambique
    {     91,     7,   173,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,   3265,17 ,    3282,8 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Portugal
    {     91,     7,   185,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {83,84,78},      275,2 , 10584,104 ,      13,5 ,       4,0 ,    3156,9 ,   3290,19 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Sao Tome And Principe
    {     91,     7,   206,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,    640,27 ,      37,5 ,      8,10 ,  14947,48 ,  14995,89 ,    134,24 ,  14947,48 ,  14995,89 ,    134,24 ,   7816,49 ,   7723,79 ,   7802,14 ,   7816,49 ,   7723,79 ,   7802,14 ,     209,8 ,     198,8 ,    0,5 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,  10688,45 ,      13,5 ,       4,0 ,    3156,9 ,    3309,5 ,     2,     0,     1,     6,     7 }, // Portuguese/Latin/Switzerland
    {     92,     4,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     567,9 ,     567,9 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,  15084,50 ,  15134,68 ,  15202,28 ,  15084,50 ,  15134,68 ,  15202,28 ,   7865,36 ,   7901,57 ,   7958,23 ,   7865,36 ,   7901,57 ,   7958,23 ,     217,6 ,     206,6 ,  696,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  10733,39 ,       4,4 ,       4,0 ,    3314,6 ,    3320,4 ,     2,     1,     7,     7,     7 }, // Punjabi/Gurmukhi/India
    {     92,     1,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     80,18 ,      18,7 ,     25,12 ,  15230,67 ,  15230,67 ,    158,27 ,  15230,67 ,  15230,67 ,    158,27 ,   7981,37 ,   7981,37 ,     85,14 ,   7981,37 ,   7981,37 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,75,82},      277,1 ,  10772,13 ,      41,6 ,       4,0 ,    3324,6 ,    3330,7 ,     0,     0,     7,     6,     7 }, // Punjabi/Arabic/Pakistan
    {     93,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,    210,18 ,      37,5 ,      8,10 ,  15297,48 ,  15345,88 ,    158,27 ,  15297,48 ,  15345,88 ,    158,27 ,   8018,28 ,   8046,53 ,   8099,14 ,   8018,28 ,   8046,53 ,   8099,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {80,69,78},      278,2 ,       0,7 ,       8,5 ,       4,0 ,    3337,8 ,    3345,4 ,     2,     1,     7,     6,     7 }, // Quechua/Latin/Peru
    {     93,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,    210,18 ,      37,5 ,      8,10 ,  15297,48 ,  15345,88 ,    158,27 ,  15297,48 ,  15345,88 ,    158,27 ,   8018,28 ,   8046,53 ,   8099,14 ,   8018,28 ,   8046,53 ,   8099,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {66,79,66},      280,2 ,       0,7 ,       8,5 ,       4,0 ,    3337,8 ,    3349,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Bolivia
    {     93,     7,    63,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,    210,18 ,      37,5 ,      8,10 ,  15297,48 ,  15345,88 ,    158,27 ,  15297,48 ,  15345,88 ,    158,27 ,   8018,28 ,   8046,53 ,   8099,14 ,   8018,28 ,   8046,53 ,   8099,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,       0,7 ,       8,5 ,       4,0 ,    3337,8 ,    3356,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Ecuador
    {     94,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     357,8 ,   1011,28 ,      37,5 ,      8,10 ,  15433,67 ,  15500,92 ,  15592,24 ,  15433,67 ,  15500,92 ,  15592,24 ,   8113,23 ,   8136,56 ,   8192,14 ,   8113,23 ,   8136,56 ,   8192,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,  10785,46 ,      13,5 ,       4,0 ,    3363,9 ,    3372,6 ,     2,     0,     1,     6,     7 }, // Romansh/Latin/Switzerland
    {     95,     7,   177,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     576,8 ,     576,8 ,    981,10 ,     10,17 ,      37,5 ,      8,10 ,  15616,60 ,  15676,98 ,  15774,24 ,  15616,60 ,  15676,98 ,  15774,24 ,   8206,34 ,   8240,48 ,   3150,14 ,   8206,34 ,   8240,48 ,   3150,14 ,      66,4 ,      63,4 ,  700,4 ,   5,17 ,  22,23 , {82,79,78},      282,3 ,  10831,57 ,      13,5 ,       4,0 ,    3378,6 ,    3384,7 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Romania
    {     95,     7,   141,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     576,8 ,     576,8 ,    981,10 ,     10,17 ,      37,5 ,      8,10 ,  15616,60 ,  15676,98 ,  15774,24 ,  15616,60 ,  15676,98 ,  15774,24 ,   8288,28 ,   8240,48 ,   8316,16 ,   8288,28 ,   8240,48 ,   8316,16 ,      66,4 ,      63,4 ,  700,4 ,   5,17 ,  22,23 , {77,68,76},      285,1 ,  10888,69 ,      13,5 ,       4,0 ,    3378,6 ,   3391,17 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Moldova
    {     96,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      55,4 ,      59,9 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {82,85,66},      119,1 ,  10957,89 ,      13,5 ,       4,0 ,    3408,7 ,    3415,6 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Russia
    {     96,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      55,4 ,      59,9 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {66,89,78},        0,2 ,  11046,94 ,      13,5 ,       4,0 ,    3408,7 ,     501,8 ,     2,     0,     1,     6,     7 }, // Russian/Cyrillic/Belarus
    {     96,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      55,4 ,      59,9 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {75,90,84},      236,1 ,  11140,83 ,      13,5 ,       4,0 ,    3408,7 ,    3421,9 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kazakhstan
    {     96,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      55,4 ,      59,9 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {75,71,83},      237,3 ,  11223,82 ,      13,5 ,       4,0 ,    3408,7 ,    3430,8 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kyrgyzstan
    {     96,     2,   141,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      55,4 ,      59,9 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {77,68,76},      285,1 ,  11305,79 ,      13,5 ,       4,0 ,    3408,7 ,    3438,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Moldova
    {     96,     2,   222,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    981,10 ,    335,22 ,      37,5 ,      8,10 ,  15798,62 ,  11235,80 ,  11152,24 ,  15860,62 ,  15922,82 ,  11152,24 ,   8332,21 ,   8353,62 ,   8415,14 ,   8332,21 ,   8353,62 ,   8332,21 ,       0,2 ,       0,2 ,  263,5 , 571,17 ,  22,23 , {85,65,72},      286,1 ,  11384,92 ,      13,5 ,       4,0 ,    3408,7 ,    3445,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Ukraine
    {     98,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  16004,48 ,  16052,91 ,  16143,24 ,  16004,48 ,  16052,91 ,  16143,24 ,   8429,28 ,   8457,66 ,   8523,14 ,   8429,28 ,   8457,66 ,   8523,14 ,     223,2 ,     212,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  11476,25 ,       4,4 ,      36,5 ,    3452,5 ,   3457,22 ,     0,     0,     1,     6,     7 }, // Sango/Latin/Central African Republic
    {     99,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     7,     7 }, // Sanskrit/Devanagari/India
    {    100,     2,   243,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16167,48 ,  16215,81 ,  12531,24 ,  16167,48 ,  16215,81 ,  12531,24 ,   8537,28 ,   8565,52 ,   8617,14 ,   8537,28 ,   8565,52 ,   8617,14 ,     225,9 ,     214,8 ,  704,7 ,   5,17 ,  22,23 , {82,83,68},      287,3 ,  11501,58 ,      13,5 ,       4,0 ,    3479,6 ,    3485,6 ,     0,     0,     1,     6,     7 }, // Serbian/Cyrillic/Serbia
    {    100,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16296,58 ,  16354,81 ,  16435,24 ,  16296,58 ,  16354,81 ,  16435,24 ,   8631,33 ,   8664,57 ,   2172,14 ,   8631,33 ,   8664,57 ,   2172,14 ,    234,11 ,     222,8 ,  313,7 ,   5,17 ,  22,23 , {66,65,77},      140,2 , 11559,174 ,      13,5 ,       4,0 ,    3491,6 ,    620,19 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Bosnia And Herzegowina
    {    100,     7,   242,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16296,58 ,  16354,81 ,  16435,24 ,  16296,58 ,  16354,81 ,  16435,24 ,   8631,33 ,   8664,57 ,   2172,14 ,   8631,33 ,   8664,57 ,   2172,14 ,    234,11 ,     222,8 ,  313,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  11733,23 ,      13,5 ,       4,0 ,    3491,6 ,    3497,9 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Montenegro
    {    100,     7,   243,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16459,48 ,  16354,81 ,  16435,24 ,  16459,48 ,  16354,81 ,  16435,24 ,   8721,28 ,   8749,54 ,   2172,14 ,   8721,28 ,   8749,54 ,   2172,14 ,     245,9 ,     222,8 ,  313,7 ,   5,17 ,  22,23 , {82,83,68},      287,3 ,  11756,58 ,      13,5 ,       4,0 ,    3491,6 ,    3506,6 ,     0,     0,     1,     6,     7 }, // Serbian/Latin/Serbia
    {    100,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16507,58 ,  16215,81 ,  12531,24 ,  16507,58 ,  16215,81 ,  12531,24 ,   8803,33 ,   8836,55 ,   8617,14 ,   8803,33 ,   8836,55 ,   8617,14 ,    254,11 ,     214,8 ,  704,7 ,   5,17 ,  22,23 , {66,65,77},      290,2 , 11814,174 ,      13,5 ,       4,0 ,    3479,6 ,   3512,19 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Bosnia And Herzegowina
    {    100,     2,   242,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16507,58 ,  16215,81 ,  12531,24 ,  16507,58 ,  16215,81 ,  12531,24 ,   8803,33 ,   8836,55 ,   8617,14 ,   8803,33 ,   8836,55 ,   8617,14 ,    254,11 ,     214,8 ,  704,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  11988,23 ,      13,5 ,       4,0 ,    3479,6 ,    3531,9 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Montenegro
    {    100,     2,   257,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16507,58 ,  16215,81 ,  12531,24 ,  16507,58 ,  16215,81 ,  12531,24 ,   8803,33 ,   8565,52 ,   8617,14 ,   8803,33 ,   8565,52 ,   8617,14 ,     225,9 ,     214,8 ,  704,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  11988,23 ,      13,5 ,       4,0 ,    3479,6 ,    3540,6 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Kosovo
    {    100,     7,   257,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  16296,58 ,  16354,81 ,  16435,24 ,  16296,58 ,  16354,81 ,  16435,24 ,   8631,33 ,   8749,54 ,   2172,14 ,   8631,33 ,   8749,54 ,   2172,14 ,     245,9 ,     222,8 ,  313,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  11733,23 ,      13,5 ,       4,0 ,    3491,6 ,    3546,6 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Kosovo
    {    101,     2,    81,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     584,9 ,     584,9 ,     174,8 ,   1066,23 ,      37,5 ,      8,10 ,  16565,63 ,  16628,82 ,  11152,24 ,  16710,60 ,  16770,86 ,  11152,24 ,   8891,28 ,   8919,61 ,   8980,14 ,   8994,28 ,   9022,61 ,   8980,14 ,    265,15 ,    230,15 ,   45,4 ,   5,17 ,  22,23 , {71,69,76},      224,1 ,  12011,17 ,       8,5 ,       4,0 ,    3552,4 ,   3556,11 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Georgia
    {    101,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     584,9 ,     584,9 ,     174,8 ,   1066,23 ,      37,5 ,      8,10 ,  16565,63 ,  16628,82 ,  11152,24 ,  16710,60 ,  16770,86 ,  11152,24 ,   8891,28 ,   8919,61 ,   8980,14 ,   8994,28 ,   9022,61 ,   8980,14 ,    265,15 ,    230,15 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,  12028,17 ,       8,5 ,       4,0 ,    3552,4 ,    3567,6 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Russia
    {    102,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Southern Sotho/Latin/South Africa
    {    103,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Tswana/Latin/South Africa
    {    104,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  16856,48 , 16904,100 ,  17004,24 ,  16856,48 , 16904,100 ,  17004,24 ,   9083,28 ,   9111,55 ,   9166,14 ,   9083,28 ,   9111,55 ,   9166,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,  12045,22 ,       4,4 ,       4,0 ,    3573,8 ,    1791,8 ,     2,     1,     7,     6,     7 }, // Shona/Latin/Zimbabwe
    {    105,     1,   163,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,  17028,72 ,  17028,72 ,    158,27 ,  17028,72 ,  17028,72 ,    158,27 ,   9180,35 ,   9180,35 ,   9215,21 ,   9180,35 ,   9180,35 ,   9236,31 ,    280,11 ,    245,11 ,  711,6 , 717,52 ,  22,23 , {80,75,82},      172,2 ,  12067,43 ,       8,5 ,       4,0 ,    3581,4 ,    3585,7 ,     0,     0,     7,     6,     7 }, // Sindhi/Arabic/Pakistan
    {    106,    32,   198,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     593,9 ,     602,8 ,     53,10 ,     63,17 ,     228,5 ,    233,10 ,  17100,59 ,  17159,96 ,  17255,32 ,  17287,61 ,  17159,96 ,  17255,32 ,   9267,39 ,   9306,62 ,   9368,19 ,   9267,39 ,   9306,62 ,   9368,19 ,     291,5 ,     256,4 ,  769,5 , 774,37 ,  22,23 , {76,75,82},      292,3 ,  12110,58 ,       4,4 ,       4,0 ,    3592,5 ,   3597,11 ,     2,     1,     1,     6,     7 }, // Sinhala/Sinhala/Sri Lanka
    {    107,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Swati/Latin/South Africa
    {    108,     7,   191,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     185,7 ,     610,7 ,   1089,10 ,    496,17 ,      55,4 ,      59,9 ,  17348,48 ,  17396,82 ,  16435,24 ,  17348,48 ,  17478,89 ,  16435,24 ,   9387,21 ,   9408,52 ,   9460,14 ,   9387,21 ,   9408,52 ,   9460,14 ,       0,2 ,       0,2 ,  320,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12168,26 ,      13,5 ,       4,0 ,   3608,10 ,    3618,9 ,     2,     1,     1,     6,     7 }, // Slovak/Latin/Slovakia
    {    109,     7,   192,    44,    46,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     617,8 ,     617,8 ,    1099,9 ,   1108,19 ,      37,5 ,      8,10 ,  17567,59 ,  17626,86 ,  16435,24 ,  17567,59 ,  17626,86 ,  16435,24 ,   9474,35 ,   9509,52 ,   9561,14 ,   9474,35 ,   9509,52 ,   9561,14 ,      62,4 ,     260,4 ,   54,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12194,28 ,      13,5 ,       4,0 ,   3627,11 ,    3638,9 ,     2,     1,     1,     6,     7 }, // Slovenian/Latin/Slovenia
    {    110,     7,   194,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1127,19 ,      18,7 ,     25,12 ,  17712,48 , 17760,189 ,  17949,24 ,  17712,48 , 17760,189 ,  17949,24 ,   9575,28 ,   9603,47 ,   9650,15 ,   9575,28 ,   9603,47 ,   9650,15 ,     296,3 ,     264,3 ,   45,4 ,   5,17 ,  22,23 , {83,79,83},       90,1 ,  12222,22 ,       4,4 ,       4,0 ,    3647,8 ,   3655,10 ,     0,     0,     1,     6,     7 }, // Somali/Latin/Somalia
    {    110,     7,    59,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1127,19 ,      18,7 ,     25,12 ,  17712,48 , 17760,189 ,  17949,24 ,  17712,48 , 17760,189 ,  17949,24 ,   9575,28 ,   9603,47 ,   9650,15 ,   9575,28 ,   9603,47 ,   9650,15 ,     296,3 ,     264,3 ,   45,4 ,   5,17 ,  22,23 , {68,74,70},       38,3 ,  12244,21 ,       4,4 ,       4,0 ,    3647,8 ,    3665,7 ,     0,     0,     6,     6,     7 }, // Somali/Latin/Djibouti
    {    110,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1127,19 ,      18,7 ,     25,12 ,  17712,48 , 17760,189 ,  17949,24 ,  17712,48 , 17760,189 ,  17949,24 ,   9575,28 ,   9603,47 ,   9650,15 ,   9575,28 ,   9603,47 ,   9650,15 ,     296,3 ,     264,3 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,2 ,  12265,22 ,       4,4 ,       4,0 ,    3647,8 ,    3672,8 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Ethiopia
    {    110,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1127,19 ,      37,5 ,      8,10 ,  17712,48 , 17760,189 ,  17949,24 ,  17712,48 , 17760,189 ,  17949,24 ,   9575,28 ,   9603,47 ,   9650,15 ,   9575,28 ,   9603,47 ,   9650,15 ,     296,3 ,     264,3 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,       0,7 ,       4,4 ,       4,0 ,    3647,8 ,    3680,7 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Kenya
    {    111,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      55,4 ,    426,11 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   8099,14 ,   9665,35 ,   9700,53 ,   8099,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,   3687,17 ,    2398,6 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Spain
    {    111,     7,    10,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   3150,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {65,82,83},        6,1 ,  12287,51 ,       8,5 ,       4,0 ,    3704,7 ,    3711,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Argentina
    {    111,     7,    22,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {66,90,68},        6,1 ,  12338,52 ,       4,4 ,       4,0 ,    3704,7 ,    3720,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Belize
    {    111,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {66,79,66},      280,2 ,  12390,35 ,       4,4 ,       4,0 ,    3704,7 ,    3349,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Bolivia
    {    111,     7,    30,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {66,82,76},      269,2 ,  12425,52 ,       4,4 ,       4,0 ,    3704,7 ,    3165,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Brazil
    {    111,     7,    43,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     357,8 ,    640,27 ,      37,5 ,      8,10 ,  17973,61 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {67,76,80},        6,1 ,  12477,45 ,       4,4 ,      36,5 ,    3704,7 ,    3726,5 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Chile
    {    111,     7,    47,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     536,7 ,    640,27 ,      18,7 ,     25,12 ,  17973,61 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   9753,14 ,   9665,35 ,   9700,53 ,   3150,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {67,79,80},        6,1 ,  12522,54 ,       8,5 ,       4,0 ,    3704,7 ,    3731,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Colombia
    {    111,     7,    52,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {67,82,67},      295,1 ,  12576,67 ,       4,4 ,       4,0 ,    3704,7 ,   3739,10 ,     2,     0,     1,     6,     7 }, // Spanish/Latin/Costa Rica
    {    111,     7,    55,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 , {67,85,80},        6,1 ,  12643,42 ,       4,4 ,       4,0 ,    3704,7 ,    3749,4 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Cuba
    {    111,     7,    61,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      18,7 ,     25,12 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   3150,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {68,79,80},      296,3 ,  12685,54 ,       4,4 ,      89,6 ,    3704,7 ,   3753,20 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Dominican Republic
    {    111,     7,    63,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  12739,70 ,       4,4 ,      36,5 ,    3704,7 ,    3356,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ecuador
    {    111,     7,    65,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  12739,70 ,       4,4 ,       4,0 ,    3704,7 ,   3773,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/El Salvador
    {    111,     7,    66,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      55,4 ,    426,11 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   8099,14 ,   9665,35 ,   9700,53 ,   8099,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  12809,92 ,       4,4 ,       4,0 ,    3704,7 ,   3784,17 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Equatorial Guinea
    {    111,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     536,7 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {71,84,81},      299,1 ,  12901,30 ,      18,5 ,       4,0 ,    3704,7 ,    3801,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Guatemala
    {    111,     7,    96,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,   1146,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {72,78,76},      285,1 ,  12931,60 ,       4,4 ,       4,0 ,    3704,7 ,    3810,8 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Honduras
    {    111,     7,   139,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,      27,8 ,    640,27 ,      55,4 ,      59,9 ,  18147,60 ,  18034,89 ,  18123,24 ,  18207,48 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   3150,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {77,88,78},        6,1 ,  12991,48 ,      47,6 ,       4,0 ,   3818,17 ,    3835,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Mexico
    {    111,     7,   155,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {78,73,79},      300,2 ,  13039,69 ,       4,4 ,       4,0 ,    3704,7 ,    3841,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Nicaragua
    {    111,     7,   166,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,    1173,8 ,    640,27 ,      18,7 ,     25,12 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {80,65,66},      302,3 ,  13108,54 ,       4,4 ,       4,0 ,    3704,7 ,    3850,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Panama
    {    111,     7,   168,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {80,89,71},      305,3 ,  13162,61 ,       8,5 ,      23,6 ,    3704,7 ,    3856,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Paraguay
    {    111,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     536,7 ,    640,27 ,      37,5 ,      8,10 ,  18255,60 ,  15345,88 ,  18123,24 ,  18315,60 ,  18375,88 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {80,69,78},      278,2 ,  13223,43 ,       4,4 ,       4,0 ,    3704,7 ,    3345,4 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Peru
    {    111,     7,   170,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      18,7 ,     25,12 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   8099,14 ,   9665,35 ,   9700,53 ,   8099,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      175,1 ,  13266,48 ,      13,5 ,       4,0 ,    3704,7 ,    3864,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Philippines
    {    111,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,    1173,8 ,    640,27 ,      18,7 ,     25,12 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  12739,70 ,       4,4 ,       4,0 ,    3704,7 ,   1437,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Puerto Rico
    {    111,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     433,8 ,    640,27 ,      18,7 ,     25,12 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   3150,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  12739,70 ,      95,7 ,       4,0 ,    3704,7 ,   3873,14 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/United States
    {    111,     7,   227,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18255,60 ,  15345,88 ,  18123,24 ,  18315,60 ,  18375,88 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {85,89,85},        6,1 ,  13314,48 ,       8,5 ,       4,0 ,    3704,7 ,    3887,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Uruguay
    {    111,     7,   231,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      18,7 ,     25,12 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {86,69,70},      308,3 ,  13362,64 ,       4,4 ,      36,5 ,    3704,7 ,    3894,9 ,     2,     0,     7,     6,     7 }, // Spanish/Latin/Venezuela
    {    111,     7,   238,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      55,4 ,    426,11 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   8099,14 ,   9665,35 ,   9700,53 ,   8099,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3704,7 ,    3903,8 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Canary Islands
    {    111,     7,   246,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      37,5 ,      8,10 ,  18147,60 ,  18034,89 ,  18123,24 ,  18147,60 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   3150,14 ,   9665,35 ,   9700,53 ,   9753,14 ,      66,4 ,      63,4 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       4,4 ,       4,0 ,   3911,23 ,   3934,13 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Latin America
    {    111,     7,   250,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    640,27 ,      55,4 ,    426,11 ,  17973,61 ,  18034,89 ,  18123,24 ,  17973,61 ,  18034,89 ,  18123,24 ,   9665,35 ,   9700,53 ,   8099,14 ,   9665,35 ,   9700,53 ,   8099,14 ,      55,5 ,      52,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3704,7 ,   3947,15 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ceuta And Melilla
    {    113,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  18511,84 ,    134,24 ,  18463,48 ,  18511,84 ,    134,24 ,   9767,60 ,   9767,60 ,     85,14 ,   9767,60 ,   9767,60 ,     85,14 ,       0,2 ,       0,2 ,  591,5 , 811,47 ,  22,23 , {84,90,83},      188,3 ,  13426,67 ,       4,4 ,       4,0 ,    3962,9 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Swahili/Latin/Tanzania
    {    113,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  18511,84 ,    134,24 ,  18463,48 ,  18511,84 ,    134,24 ,   9767,60 ,   9767,60 ,     85,14 ,   9767,60 ,   9767,60 ,     85,14 ,       0,2 ,       0,2 ,  591,5 , 811,47 ,  22,23 , {67,68,70},      203,2 ,  13493,55 ,       4,4 ,       4,0 ,    3971,8 ,   3979,32 ,     2,     1,     1,     6,     7 }, // Swahili/Latin/Congo Kinshasa
    {    113,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  18511,84 ,    134,24 ,  18463,48 ,  18511,84 ,    134,24 ,   9767,60 ,   9767,60 ,     85,14 ,   9767,60 ,   9767,60 ,     85,14 ,       0,2 ,       0,2 ,  591,5 , 811,47 ,  22,23 , {75,69,83},        2,3 ,  13548,58 ,       4,4 ,       4,0 ,    3962,9 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Swahili/Latin/Kenya
    {    113,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  18511,84 ,    134,24 ,  18463,48 ,  18511,84 ,    134,24 ,   9767,60 ,   9767,60 ,     85,14 ,   9767,60 ,   9767,60 ,     85,14 ,       0,2 ,       0,2 ,  591,5 , 811,47 ,  22,23 , {85,71,88},      193,3 ,  13606,61 ,       4,4 ,       4,0 ,    3962,9 ,    1681,6 ,     0,     0,     1,     6,     7 }, // Swahili/Latin/Uganda
    {    114,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     640,9 ,     640,9 ,     53,10 ,     98,16 ,      37,5 ,    437,16 ,  18595,59 ,  18654,86 ,    134,24 ,  18595,59 ,  18654,86 ,    134,24 ,   9827,29 ,   9856,50 ,   2363,14 ,   9827,29 ,   9856,50 ,   2363,14 ,     299,2 ,     267,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      186,2 ,  13667,45 ,      13,5 ,       4,0 ,    4011,7 ,    4018,7 ,     2,     0,     1,     6,     7 }, // Swedish/Latin/Sweden
    {    114,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     640,9 ,     640,9 ,   1181,10 ,     98,16 ,      37,5 ,    437,16 ,  18595,59 ,  18654,86 ,    134,24 ,  18595,59 ,  18654,86 ,    134,24 ,   9827,29 ,   9856,50 ,   2363,14 ,   9827,29 ,   9856,50 ,   2363,14 ,     299,2 ,     267,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8897,19 ,      13,5 ,       4,0 ,    4011,7 ,    1079,7 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Finland
    {    114,     7,   248,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     640,9 ,     640,9 ,     53,10 ,     98,16 ,      37,5 ,    437,16 ,  18595,59 ,  18654,86 ,    134,24 ,  18595,59 ,  18654,86 ,    134,24 ,   9827,29 ,   9856,50 ,   2363,14 ,   9827,29 ,   9856,50 ,   2363,14 ,     299,2 ,     267,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8897,19 ,      13,5 ,       4,0 ,    4011,7 ,    4025,5 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Aland Islands
    {    116,     2,   209,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     80,18 ,      37,5 ,      8,10 ,  11024,48 ,  18740,71 ,  11152,24 ,  11024,48 ,  18740,71 ,  11152,24 ,   9906,28 ,   9934,55 ,   9989,14 ,   9906,28 ,   9934,55 ,   9989,14 ,     301,7 ,     269,7 ,   45,4 ,   5,17 ,  22,23 , {84,74,83},      311,4 ,  13712,19 ,      13,5 ,       4,0 ,    4030,6 ,   4036,10 ,     2,     1,     1,     6,     7 }, // Tajik/Cyrillic/Tajikistan
    {    117,    27,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    649,13 ,    649,13 ,     287,6 ,    210,18 ,     382,7 ,    453,12 ,  18811,58 ,  18869,86 ,  18955,31 ,  18811,58 ,  18869,86 ,  18955,31 ,  10003,39 ,  10042,49 ,  10091,20 ,  10003,39 ,  10042,49 ,  10091,20 ,     308,8 ,     276,8 ,  858,7 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  13731,49 ,       8,5 ,       4,0 ,    4046,5 ,    4051,7 ,     2,     1,     7,     7,     7 }, // Tamil/Tamil/India
    {    117,    27,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    649,13 ,    649,13 ,     287,6 ,    210,18 ,     382,7 ,    453,12 ,  18811,58 ,  18869,86 ,  18955,31 ,  18811,58 ,  18869,86 ,  18955,31 ,  10003,39 ,  10042,49 ,  10091,20 ,  10003,39 ,  10042,49 ,  10091,20 ,     308,8 ,     276,8 ,  858,7 ,   5,17 ,  22,23 , {77,89,82},      170,2 ,  13780,61 ,       8,5 ,       4,0 ,    4046,5 ,    4058,7 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Malaysia
    {    117,    27,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    649,13 ,    649,13 ,     287,6 ,    210,18 ,     382,7 ,    453,12 ,  18811,58 ,  18869,86 ,  18955,31 ,  18811,58 ,  18869,86 ,  18955,31 ,  10003,39 ,  10042,49 ,  10091,20 ,  10003,39 ,  10042,49 ,  10091,20 ,     308,8 ,     276,8 ,  858,7 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,  13841,61 ,       8,5 ,       4,0 ,    4046,5 ,   4065,11 ,     2,     1,     7,     6,     7 }, // Tamil/Tamil/Singapore
    {    117,    27,   198,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    649,13 ,    649,13 ,     287,6 ,    210,18 ,      37,5 ,      8,10 ,  18811,58 ,  18869,86 ,  18955,31 ,  18811,58 ,  18869,86 ,  18955,31 ,  10003,39 ,  10042,49 ,  10091,20 ,  10003,39 ,  10042,49 ,  10091,20 ,     308,8 ,     276,8 ,  858,7 ,   5,17 ,  22,23 , {76,75,82},      315,3 ,  13902,49 ,       8,5 ,       4,0 ,    4046,5 ,    4076,6 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Sri Lanka
    {    118,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     662,9 ,     662,9 ,    981,10 ,   1191,23 ,      55,4 ,      59,9 ,  18986,62 ,  19048,81 ,    158,27 ,  18986,62 ,  19048,81 ,    158,27 ,  10111,36 ,  10147,56 ,  10203,14 ,  10111,36 ,  10147,56 ,  10203,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,  13951,21 ,       0,4 ,       4,0 ,    4082,5 ,    3415,6 ,     2,     1,     1,     6,     7 }, // Tatar/Cyrillic/Russia
    {    119,    28,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    671,11 ,    671,11 ,     357,8 ,   1214,18 ,      18,7 ,     25,12 ,  19129,62 ,  19191,86 ,  19277,31 ,  19129,62 ,  19191,86 ,  19277,31 ,  10217,32 ,  10249,60 ,  10309,18 ,  10217,32 ,  10249,60 ,  10309,18 ,       0,2 ,       0,2 ,  865,7 , 872,27 ,  22,23 , {73,78,82},      117,1 ,  13972,26 ,       4,4 ,       4,0 ,    4087,6 ,    4093,8 ,     2,     1,     7,     7,     7 }, // Telugu/Telugu/India
    {    120,    30,   211,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     123,5 ,     123,5 ,     682,8 ,     690,7 ,     287,6 ,   1232,19 ,      37,5 ,    465,28 ,  19308,63 ,  19371,98 ,  19308,63 ,  19308,63 ,  19371,98 ,  19308,63 ,  10327,23 ,  10350,68 ,  10418,16 ,  10327,23 ,  10350,68 ,  10418,16 ,    316,10 ,    284,10 ,  899,4 ,   5,17 ,  22,23 , {84,72,66},      318,3 ,  13998,16 ,       4,4 ,       4,0 ,    4101,3 ,    4101,3 ,     2,     1,     7,     6,     7 }, // Thai/Thai/Thailand
    {    121,    31,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1251,23 ,      18,7 ,     25,12 ,   2923,63 , 19469,159 ,    158,27 ,   2923,63 , 19628,147 ,    158,27 ,  10434,51 ,  10485,79 ,  10564,27 ,  10434,51 ,  10485,79 ,  10564,27 ,     326,7 ,     294,8 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      321,1 ,  14014,13 ,       8,5 ,       4,0 ,    4104,8 ,    4112,6 ,     2,     1,     7,     6,     7 }, // Tibetan/Tibetan/China
    {    121,    31,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1251,23 ,      18,7 ,     25,12 ,   2923,63 , 19469,159 ,    158,27 ,   2923,63 , 19628,147 ,    158,27 ,  10434,51 ,  10485,79 ,  10564,27 ,  10434,51 ,  10485,79 ,  10564,27 ,     326,7 ,     294,8 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  14027,19 ,       8,5 ,       4,0 ,    4104,8 ,    4118,7 ,     2,     1,     7,     7,     7 }, // Tibetan/Tibetan/India
    {    122,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1274,23 ,      18,7 ,     25,12 ,  19775,36 ,  19811,54 ,  19865,24 ,  19775,36 ,  19811,54 ,  19865,24 ,  10591,21 ,  10612,29 ,  10641,14 ,  10591,21 ,  10655,29 ,  10684,14 ,     333,7 ,     302,7 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,2 ,  14046,16 ,       4,4 ,       4,0 ,    4125,4 ,      82,5 ,     2,     1,     7,     6,     7 }, // Tigrinya/Ethiopic/Ethiopia
    {    122,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1274,23 ,      18,7 ,     25,12 ,  19775,36 ,  19811,54 ,  19865,24 ,  19775,36 ,  19811,54 ,  19865,24 ,  10591,21 ,  10612,29 ,  10684,14 ,  10591,21 ,  10655,29 ,  10684,14 ,     333,7 ,     302,7 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},       41,3 ,       0,7 ,       4,4 ,       4,0 ,    4125,4 ,    4129,4 ,     2,     1,     1,     6,     7 }, // Tigrinya/Ethiopic/Eritrea
    {    123,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     697,8 ,     697,8 ,     697,8 ,     697,8 ,     287,6 ,     98,16 ,      18,7 ,     25,12 ,  19889,51 ,  19940,87 ,  20027,24 ,  19889,51 ,  19940,87 ,  20027,24 ,  10698,29 ,  10727,60 ,  10787,14 ,  10698,29 ,  10727,60 ,  10787,14 ,    340,10 ,     309,6 ,  903,5 , 908,59 , 967,65 , {84,79,80},      191,2 ,  14062,41 ,      13,5 ,       4,0 ,   4133,13 ,    1631,5 ,     2,     1,     1,     6,     7 }, // Tongan/Latin/Tonga
    {    124,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Tsonga/Latin/South Africa
    {    125,     7,   217,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,8 ,     705,8 ,    1297,9 ,   1306,16 ,      37,5 ,      8,10 ,  20051,48 ,  20099,75 ,  20174,24 ,  20051,48 ,  20099,75 ,  20174,24 ,  10801,28 ,  10829,54 ,  10883,14 ,  10801,28 ,  10829,54 ,  10883,14 ,     350,2 ,     315,2 ,  193,4 ,   5,17 ,  22,23 , {84,82,89},      244,1 ,  14103,40 ,       4,4 ,       4,0 ,    4146,6 ,    4152,7 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Turkey
    {    125,     7,    56,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,8 ,     705,8 ,    1297,9 ,   1306,16 ,      18,7 ,     25,12 ,  20051,48 ,  20099,75 ,  20174,24 ,  20051,48 ,  20099,75 ,  20174,24 ,  10801,28 ,  10829,54 ,  10883,14 ,  10801,28 ,  10829,54 ,  10883,14 ,     350,2 ,     315,2 ,  193,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,       4,4 ,       4,0 ,    4146,6 ,    4159,6 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Cyprus
    {    126,     7,   218,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8220,    8221,       0,6 ,       0,6 ,     713,8 ,     713,8 ,    981,10 ,   1306,16 ,      37,5 ,      8,10 ,  20198,51 ,  20249,77 ,  20326,24 ,  20350,51 ,  20401,77 ,  20326,24 ,  10897,28 ,  10925,54 ,  10979,14 ,  10993,28 ,  11021,54 ,  10979,14 ,    352,13 ,    317,14 , 1032,4 ,   5,17 ,  22,23 , {84,77,84},      322,3 ,  14143,49 ,      13,5 ,       4,0 ,   4165,12 ,   4177,12 ,     2,     1,     1,     6,     7 }, // Turkmen/Latin/Turkmenistan
    {    128,     1,    44,    46,    44,    59,    37,    48,    45,    43,   101,     187,     171,    8250,    8249,       0,6 ,       0,6 ,    200,10 ,     210,9 ,     53,10 ,   1322,17 ,      18,7 ,     25,12 ,  20478,84 ,  20478,84 ,    158,27 ,  20478,84 ,  20478,84 ,    158,27 ,  11075,21 ,  11096,55 ,  11151,14 ,  11075,21 ,  11096,55 ,  11151,14 ,    365,12 ,    331,12 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      129,1 ,  14192,40 ,       4,4 ,       4,0 ,    4189,8 ,    4197,5 ,     2,     1,     7,     6,     7 }, // Uighur/Arabic/China
    {    129,     2,   222,    44,   160,    59,    37,    48,    45,    43,  1077,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     138,7 ,     138,7 ,     174,8 ,   1339,22 ,      37,5 ,      8,10 ,  20562,48 ,  20610,95 ,  20705,24 ,  20729,67 ,  20796,87 ,  20883,24 ,   1583,21 ,  11165,56 ,  11221,14 ,   1583,21 ,  11165,56 ,  11221,14 ,     377,2 ,     343,2 , 1036,5 , 571,17 ,  22,23 , {85,65,72},      286,1 ,  14232,49 ,      13,5 ,       4,0 ,   4202,10 ,    4212,7 ,     2,     1,     1,     6,     7 }, // Ukrainian/Cyrillic/Ukraine
    {    130,     1,   163,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,    721,10 ,     731,9 ,     287,6 ,   1361,18 ,      18,7 ,     25,12 ,  20907,68 ,  20907,68 ,    134,24 ,  20907,68 ,  20907,68 ,    134,24 ,  11235,36 ,  11235,36 ,     85,14 ,  11235,36 ,  11235,36 ,     85,14 ,       0,2 ,       0,2 , 1041,4 ,   5,17 ,  22,23 , {80,75,82},      172,2 ,  14281,49 ,       4,4 ,       4,0 ,    4219,4 ,    3330,7 ,     0,     0,     7,     6,     7 }, // Urdu/Arabic/Pakistan
    {    130,     1,   100,  1643,  1644,    59,    37,  1776,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,     740,6 ,     740,6 ,     287,6 ,   1361,18 ,      18,7 ,     25,12 ,  20907,68 ,  20907,68 ,    134,24 ,  20907,68 ,  20907,68 ,    134,24 ,  11235,36 ,  11235,36 ,     85,14 ,  11235,36 ,  11235,36 ,     85,14 ,       0,2 ,       0,2 , 1041,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  14330,42 ,       8,5 ,       4,0 ,    4219,4 ,    4223,5 ,     2,     1,     7,     7,     7 }, // Urdu/Arabic/India
    {    131,     7,   228,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8217,    8216,       0,6 ,       0,6 ,     746,8 ,     746,8 ,      27,8 ,   1379,18 ,      37,5 ,    426,11 ,  20975,48 ,  21023,75 ,  21098,24 ,  21122,48 ,  21170,75 ,  21098,24 ,  11271,32 ,  11303,61 ,  11364,14 ,  11271,32 ,  11303,61 ,  11364,14 ,     379,2 ,     345,2 ,  193,4 , 340,17 ,  22,23 , {85,90,83},      325,4 ,  14372,58 ,      13,5 ,       4,0 ,    4228,6 ,   4234,11 ,     0,     0,     1,     6,     7 }, // Uzbek/Latin/Uzbekistan
    {    131,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     412,8 ,   1397,33 ,      55,4 ,    426,11 ,  21245,47 ,  14525,68 ,    158,27 ,  21245,47 ,  14525,68 ,    158,27 ,  11378,21 ,   7511,49 ,     85,14 ,  11378,21 ,   7511,49 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {65,70,78},      262,1 ,  14430,13 ,      13,5 ,       4,0 ,    4245,6 ,    3122,9 ,     0,     0,     6,     4,     5 }, // Uzbek/Arabic/Afghanistan
    {    131,     2,   228,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,    667,19 ,      37,5 ,     87,12 ,  11024,48 ,  18740,71 ,  11152,24 ,  21292,48 ,  21340,71 ,  11152,24 ,  11399,28 ,  11427,53 ,  11480,14 ,  11494,28 ,  11522,53 ,  11480,14 ,     381,2 ,     347,2 ,   45,4 ,   5,17 ,  22,23 , {85,90,83},      329,3 ,  14443,49 ,      13,5 ,       4,0 ,    4251,7 ,   4258,10 ,     0,     0,     1,     6,     7 }, // Uzbek/Cyrillic/Uzbekistan
    {    132,     7,   232,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     754,8 ,     754,8 ,    120,10 ,    210,18 ,      37,5 ,      8,10 ,  21411,75 ,  21486,99 ,    158,27 ,  21585,75 ,  21660,99 ,    158,27 ,  11575,33 ,  11608,55 ,  11663,21 ,  11575,33 ,  11608,55 ,  11663,21 ,     383,2 ,     349,2 ,   45,4 ,   5,17 ,  22,23 , {86,78,68},      332,1 ,  14492,33 ,      13,5 ,       4,0 ,   4268,10 ,    4278,8 ,     0,     0,     1,     6,     7 }, // Vietnamese/Latin/Vietnam
    {    133,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1430,23 ,      37,5 ,      8,10 ,  21759,48 ,  21807,74 ,  21881,24 ,  21905,48 ,  21807,74 ,  21881,24 ,  11684,21 ,  11705,43 ,  11748,14 ,  11762,28 ,  11705,43 ,  11748,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       8,5 ,       4,0 ,    4286,7 ,       0,0 ,     2,     1,     1,     6,     7 }, // Volapuk/Latin/World
    {    134,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    762,11 ,    773,10 ,      27,8 ,     10,17 ,      37,5 ,      8,10 ,  21953,52 ,  22005,87 ,  22092,26 ,  22118,59 ,  22005,87 ,  22092,26 ,  11790,29 ,  11819,77 ,  11896,15 ,  11911,30 ,  11819,77 ,  11896,15 ,     385,2 ,     351,2 , 1045,7 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,  14525,92 ,       4,4 ,       4,0 ,    4293,7 ,   4300,16 ,     2,     1,     1,     6,     7 }, // Welsh/Latin/United Kingdom
    {    135,     7,   187,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,   1181,10 ,   1453,17 ,      37,5 ,      8,10 ,  22177,47 ,  22224,84 ,    158,27 ,  22177,47 ,  22224,84 ,    158,27 ,  11941,28 ,  11969,50 ,  11941,28 ,  11941,28 ,  11969,50 ,  11941,28 ,     387,3 ,     353,3 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  14617,65 ,       8,5 ,       4,0 ,    4316,5 ,    4321,8 ,     0,     0,     1,     6,     7 }, // Wolof/Latin/Senegal
    {    136,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Xhosa/Latin/South Africa
    {    137,    18,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     783,9 ,     783,9 ,      27,8 ,   1470,19 ,      37,5 ,      8,10 ,  22308,58 ,  22366,92 ,    158,27 ,  22366,92 ,  22366,92 ,    158,27 ,  12019,54 ,  12019,54 ,     85,14 ,  12019,54 ,  12019,54 ,     85,14 ,    390,11 ,    356,10 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      41,6 ,       4,0 ,    4329,6 ,    4335,5 ,     2,     1,     1,     6,     7 }, // Yiddish/Hebrew/World
    {    138,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  22458,73 , 22531,121 ,    158,27 ,  22458,73 , 22531,121 ,    158,27 ,  12073,44 ,  12117,69 ,     85,14 ,  12073,44 ,  12117,69 ,     85,14 ,     401,5 ,     366,5 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,  14682,34 ,       4,4 ,       4,0 ,   4340,10 ,   4350,18 ,     2,     1,     1,     6,     7 }, // Yoruba/Latin/Nigeria
    {    138,     7,    23,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  22652,74 , 22726,134 ,    158,27 ,  22652,74 , 22726,134 ,    158,27 ,  12186,44 ,  12230,69 ,     85,14 ,  12186,44 ,  12230,69 ,     85,14 ,     406,5 ,     371,5 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  14716,34 ,       4,4 ,       4,0 ,   4340,10 ,   4368,16 ,     0,     0,     1,     6,     7 }, // Yoruba/Latin/Benin
    {    140,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     792,9 ,     801,8 ,     543,6 ,     35,18 ,      37,5 ,      8,10 ,  22860,48 ,  22908,91 ,    134,24 ,  22860,48 ,  22908,91 ,  22999,24 ,  12299,28 ,  12327,74 ,  12401,14 ,  12299,28 ,  12327,74 ,  12401,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,  14750,67 ,       4,4 ,       4,0 ,    4384,7 ,   4391,17 ,     2,     1,     7,     6,     7 }, // Zulu/Latin/South Africa
    {    141,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     192,8 ,     192,8 ,    981,10 ,    496,17 ,      37,5 ,    437,16 ,   5904,48 ,  13926,83 ,    134,24 ,  23023,59 ,  13926,83 ,    134,24 ,  12415,28 ,  12443,51 ,   2363,14 ,  12494,28 ,  12443,51 ,   2363,14 ,     411,9 ,    376,11 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      186,2 ,   9799,44 ,      13,5 ,       4,0 ,    4408,7 ,    4415,5 ,     2,     0,     1,     6,     7 }, // Norwegian Nynorsk/Latin/Norway
    {    142,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,    8216,    8217,       0,6 ,       0,6 ,     163,7 ,     163,7 ,    1039,7 ,    468,19 ,      37,5 ,      8,10 ,  16459,48 ,  23082,83 ,  16435,24 ,  16459,48 ,  23082,83 ,  16435,24 ,   2086,28 ,   2114,58 ,   2172,14 ,   2086,28 ,   2114,58 ,   2186,14 ,    420,10 ,     387,7 ,  313,7 ,   5,17 ,  22,23 , {66,65,77},      140,2 , 14817,170 ,      13,5 ,       4,0 ,    4420,8 ,    620,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Latin/Bosnia And Herzegowina
    {    142,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     116,7 ,     116,7 ,    1039,7 ,   1046,20 ,      37,5 ,      8,10 ,  23165,48 ,  23213,83 ,  12531,24 ,  23165,48 ,  23213,83 ,  12531,24 ,  12522,28 ,  12550,56 ,   8617,14 ,  12522,28 ,  12550,56 ,   8617,14 ,     225,9 ,     394,7 ,   45,4 ,   5,17 ,  22,23 , {66,65,77},      290,2 , 14987,151 ,      13,5 ,       4,0 ,    4428,8 ,   3512,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Cyrillic/Bosnia And Herzegowina
    {    143,    29,   131,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,86,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     5,     6,     7 }, // Divehi/Thaana/Maldives
    {    144,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,    686,17 ,      37,5 ,      8,10 , 23296,102 , 23398,140 ,    158,27 , 23296,102 , 23398,140 ,    158,27 ,  12606,30 ,  12636,57 ,     85,14 ,  12606,30 ,  12636,57 ,     85,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,       0,7 ,       4,4 ,       4,0 ,    4436,5 ,   4441,12 ,     2,     1,     1,     6,     7 }, // Manx/Latin/Isle Of Man
    {    145,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     98,16 ,      37,5 ,      8,10 ,  23538,46 , 23584,130 ,    158,27 ,  23538,46 , 23584,130 ,    158,27 ,  12693,28 ,  12721,61 ,     85,14 ,  12693,28 ,  12721,61 ,     85,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {71,66,80},      115,1 ,       0,7 ,       4,4 ,       4,0 ,    4453,8 ,   4461,14 ,     2,     1,     1,     6,     7 }, // Cornish/Latin/United Kingdom
    {    146,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    1489,8 ,   1497,18 ,      18,7 ,     25,12 ,  23714,48 , 23762,192 ,    158,27 ,  23714,48 , 23762,192 ,    158,27 ,  12782,28 ,  12810,49 ,  12859,14 ,  12782,28 ,  12810,49 ,  12859,14 ,     430,2 ,     401,2 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      163,3 ,  15138,17 ,       4,4 ,       4,0 ,    4475,4 ,    4479,5 ,     2,     1,     1,     6,     7 }, // Akan/Latin/Ghana
    {    147,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    1515,6 ,     98,16 ,      18,7 ,     25,12 ,  23954,88 ,  23954,88 ,    158,27 ,  23954,88 ,  23954,88 ,    158,27 ,  12873,49 ,  12873,49 ,  12922,20 ,  12873,49 ,  12873,49 ,  12922,20 ,     188,5 ,     403,5 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  15155,13 ,       8,5 ,       4,0 ,    4484,6 ,    2633,4 ,     2,     1,     7,     7,     7 }, // Konkani/Devanagari/India
    {    148,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Ga/Latin/Ghana
    {    149,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  24042,48 ,  24090,86 ,    158,27 ,  24042,48 ,  24090,86 ,    158,27 ,  12942,29 ,  12971,57 ,     85,14 ,  12942,29 ,  12971,57 ,     85,14 ,      40,4 ,     408,4 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,  15168,12 ,       4,4 ,       4,0 ,    4490,4 ,    4494,8 ,     2,     1,     1,     6,     7 }, // Igbo/Latin/Nigeria
    {    150,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  24176,48 , 24224,189 ,  24413,24 ,  24176,48 , 24224,189 ,  24413,24 ,  13028,28 ,  13056,74 ,  13130,14 ,  13028,28 ,  13056,74 ,  13130,14 ,     432,9 ,     412,7 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15180,23 ,       4,4 ,       4,0 ,    4502,7 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Kamba/Latin/Kenya
    {    151,    33,   103,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     6,     5,     6 }, // Syriac/Syriac/Iraq
    {    152,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Blin/Ethiopic/Eritrea
    {    153,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Geez/Ethiopic/Ethiopia
    {    155,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Sidamo/Latin/Ethiopia
    {    156,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Atsam/Latin/Nigeria
    {    157,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Tigre/Ethiopic/Eritrea
    {    158,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Jju/Latin/Nigeria
    {    159,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,     254,7 ,     254,7 ,      27,8 ,   1521,27 ,      37,5 ,      8,10 ,  24437,48 ,  24485,77 ,  24562,24 ,  24437,48 ,  24485,77 ,  24562,24 ,  13144,28 ,  13172,50 ,   3150,14 ,  13144,28 ,  13172,50 ,   3150,14 ,     441,2 ,     419,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,       8,5 ,       4,0 ,    4509,6 ,    4515,6 ,     2,     1,     1,     6,     7 }, // Friulian/Latin/Italy
    {    160,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Venda/Latin/South Africa
    {    161,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    809,11 ,    820,10 ,     543,6 ,   1548,23 ,    493,12 ,    505,17 ,  24586,48 ,  24634,87 ,  24721,24 ,  24586,48 ,  24634,87 ,  24721,24 ,  13222,28 ,  13250,44 ,  13294,14 ,  13222,28 ,  13250,44 ,  13294,14 ,     443,3 ,     421,5 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      163,3 ,  15203,37 ,       4,4 ,       4,0 ,    4521,6 ,   4527,12 ,     2,     1,     1,     6,     7 }, // Ewe/Latin/Ghana
    {    161,     7,   212,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    809,11 ,    820,10 ,     543,6 ,   1548,23 ,      37,5 ,      8,10 ,  24586,48 ,  24634,87 ,  24721,24 ,  24586,48 ,  24634,87 ,  24721,24 ,  13222,28 ,  13250,44 ,  13294,14 ,  13222,28 ,  13250,44 ,  13294,14 ,     443,3 ,     421,5 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 , 15240,106 ,       4,4 ,       4,0 ,    4521,6 ,   4539,11 ,     0,     0,     1,     6,     7 }, // Ewe/Latin/Togo
    {    162,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Walamo/Ethiopic/Ethiopia
    {    163,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     287,6 ,     10,17 ,      18,7 ,     25,12 ,  24745,59 ,  24804,95 ,    158,27 ,  24745,59 ,  24804,95 ,    158,27 ,  13308,21 ,  13329,57 ,     85,14 ,  13308,21 ,  13329,57 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,       0,7 ,       4,4 ,       4,0 ,   4550,14 ,   4564,19 ,     2,     1,     7,     6,     7 }, // Hawaiian/Latin/United States
    {    164,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      174,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Tyap/Latin/Nigeria
    {    165,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,87,75},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Nyanja/Latin/Malawi
    {    166,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     830,9 ,     839,8 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,  24899,48 ,  24947,88 ,  25035,38 ,  24899,48 ,  24947,88 ,  24899,48 ,  13386,28 ,  13414,55 ,  13386,28 ,  13386,28 ,  13414,55 ,  13386,28 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      175,1 ,  15346,58 ,       4,4 ,       4,0 ,    4583,8 ,    4591,9 ,     2,     1,     7,     6,     7 }, // Filipino/Latin/Philippines
    {    167,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,  25073,86 ,    134,24 ,   7849,48 ,  25073,86 ,    134,24 ,  13469,28 ,  13497,63 ,   3738,14 ,  13469,28 ,  13497,63 ,   3738,14 ,    446,12 ,    426,11 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,  15404,55 ,      13,5 ,       4,0 ,   4600,16 ,    4616,7 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Switzerland
    {    167,     7,    74,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,  25073,86 ,    134,24 ,   7849,48 ,  25073,86 ,    134,24 ,  13469,28 ,  13497,63 ,   3738,14 ,  13469,28 ,  13497,63 ,   3738,14 ,    446,12 ,    426,11 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,   4600,16 ,   4623,10 ,     2,     1,     1,     6,     7 }, // Swiss German/Latin/France
    {    167,     7,   123,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,   7849,48 ,  25073,86 ,    134,24 ,   7849,48 ,  25073,86 ,    134,24 ,  13469,28 ,  13497,63 ,   3738,14 ,  13469,28 ,  13497,63 ,   3738,14 ,    446,12 ,    426,11 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      217,3 ,  15404,55 ,      13,5 ,       4,0 ,   4600,16 ,   4633,13 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Liechtenstein
    {    168,    34,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,  25159,38 ,  25159,38 ,    158,27 ,  25159,38 ,  25159,38 ,    158,27 ,  13560,21 ,  13581,28 ,  13609,14 ,  13560,21 ,  13581,28 ,  13609,14 ,     458,2 ,     437,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      321,1 ,       0,7 ,       8,5 ,       4,0 ,    4646,3 ,    4649,2 ,     2,     1,     7,     6,     7 }, // Sichuan Yi/Yi/China
    {    169,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Kpelle/Latin/Liberia
    {    170,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     427,8 ,     427,8 ,     383,7 ,   1571,23 ,    522,10 ,    532,19 ,   7980,59 ,  25197,85 ,    134,24 ,   7980,59 ,  25197,85 ,    134,24 ,  13623,28 ,  13651,65 ,   3738,14 ,  13623,28 ,  13651,65 ,   3738,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  15459,15 ,      13,5 ,       4,0 ,   4651,14 ,   4665,11 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Germany
    {    170,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     427,8 ,     427,8 ,     383,7 ,   1571,23 ,    522,10 ,    532,19 ,   7980,59 ,  25197,85 ,    134,24 ,   7980,59 ,  25197,85 ,    134,24 ,  13623,28 ,  13651,65 ,   3738,14 ,  13623,28 ,  13651,65 ,   3738,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  15459,15 ,      13,5 ,       4,0 ,   4651,14 ,   4676,12 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Netherlands
    {    171,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // South Ndebele/Latin/South Africa
    {    172,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Northern Sotho/Latin/South Africa
    {    173,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     228,8 ,     228,8 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  25282,59 , 25341,145 ,  25486,24 ,  25282,59 , 25341,145 ,  25486,24 ,  13716,33 ,  13749,75 ,  13824,14 ,  13716,33 ,  13749,75 ,  13824,14 ,    460,11 ,    439,13 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      186,2 ,  15474,63 ,      13,5 ,       4,0 ,   4688,15 ,    4703,5 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Norway
    {    173,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     228,8 ,     228,8 ,    981,10 ,     98,16 ,      37,5 ,      8,10 ,  25510,60 , 25341,145 ,  25486,24 ,  25510,60 , 25341,145 ,  25486,24 ,  13838,21 ,  13859,70 ,  13929,14 ,  13838,21 ,  13859,70 ,  13929,14 ,     471,2 ,     452,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  15537,23 ,      13,5 ,       4,0 ,   4688,15 ,    4708,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Finland
    {    173,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     228,8 ,     228,8 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  25282,59 , 25341,145 ,  25486,24 ,  25282,59 , 25341,145 ,  25486,24 ,  13716,33 ,  13749,75 ,  13824,14 ,  13716,33 ,  13749,75 ,  13824,14 ,    460,11 ,    439,13 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      186,2 ,  15560,63 ,      13,5 ,       4,0 ,   4688,15 ,    4714,6 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Sweden
    {    174,     7,   208,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {84,87,68},      333,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Taroko/Latin/Taiwan
    {    175,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  25570,48 ,  25618,88 ,  25706,24 ,  25570,48 ,  25618,88 ,  25706,24 ,  13943,28 ,  13971,62 ,  14033,14 ,  13943,28 ,  13971,62 ,  14033,14 ,     473,6 ,     454,3 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15623,24 ,       4,4 ,       4,0 ,    4720,8 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Gusii/Latin/Kenya
    {    176,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  25730,48 , 25778,221 ,  25999,24 ,  25730,48 , 25778,221 ,  25999,24 ,  14047,28 , 14075,105 ,  14180,14 ,  14047,28 , 14075,105 ,  14180,14 ,    479,10 ,    457,10 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15623,24 ,       4,4 ,       4,0 ,    4728,7 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Taita/Latin/Kenya
    {    177,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  26023,48 ,  26071,77 ,  26148,24 ,  26023,48 ,  26071,77 ,  26148,24 ,  14194,28 ,  14222,59 ,  14281,14 ,  14194,28 ,  14222,59 ,  14281,14 ,     489,6 ,     467,7 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  15647,26 ,      13,5 ,       4,0 ,    4735,6 ,    4321,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Senegal
    {    177,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  26023,48 ,  26071,77 ,  26148,24 ,  26023,48 ,  26071,77 ,  26148,24 ,  14194,28 ,  14222,59 ,  14281,14 ,  14194,28 ,  14222,59 ,  14281,14 ,     489,6 ,     467,7 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  15673,25 ,      13,5 ,       4,0 ,    4735,6 ,    4741,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Cameroon
    {    177,     7,    91,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  26023,48 ,  26071,77 ,  26148,24 ,  26023,48 ,  26071,77 ,  26148,24 ,  14194,28 ,  14222,59 ,  14281,14 ,  14194,28 ,  14222,59 ,  14281,14 ,     489,6 ,     467,7 ,   45,4 ,   5,17 ,  22,23 , {71,78,70},      209,2 ,       0,7 ,      13,5 ,       4,0 ,    4735,6 ,    4749,4 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Guinea
    {    177,     7,   136,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      18,7 ,     25,12 ,  26023,48 ,  26071,77 ,  26148,24 ,  26023,48 ,  26071,77 ,  26148,24 ,  14194,28 ,  14222,59 ,  14281,14 ,  14194,28 ,  14222,59 ,  14281,14 ,     489,6 ,     467,7 ,   45,4 ,   5,17 ,  22,23 , {77,82,85},      212,2 ,  15698,22 ,      13,5 ,       4,0 ,    4735,6 ,    4753,8 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Mauritania
    {    178,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  26172,48 , 26220,185 ,  26405,24 ,  26172,48 , 26220,185 ,  26405,24 ,  14295,28 ,  14323,63 ,  14386,14 ,  14295,28 ,  14323,63 ,  14386,14 ,     495,6 ,     474,8 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15720,23 ,       4,4 ,       4,0 ,    4761,6 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Kikuyu/Latin/Kenya
    {    179,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  26429,48 , 26477,173 ,  26650,24 ,  26429,48 , 26477,173 ,  26650,24 ,  14400,28 , 14428,105 ,  14533,14 ,  14400,28 , 14428,105 ,  14533,14 ,     501,7 ,     482,5 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15743,25 ,       4,4 ,       4,0 ,    4767,8 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Samburu/Latin/Kenya
    {    180,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,    640,27 ,      37,5 ,      8,10 ,  26674,48 ,  26722,88 ,    134,24 ,  26674,48 ,  26722,88 ,    134,24 ,  14547,28 ,  14575,55 ,  14630,14 ,  14547,28 ,  14575,55 ,  14630,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,90,78},      272,3 ,  15768,28 ,       0,4 ,       4,0 ,    4775,4 ,   3255,10 ,     2,     1,     7,     6,     7 }, // Sena/Latin/Mozambique
    {    181,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  26810,52 , 26862,112 ,  26974,24 ,  26810,52 , 26862,112 ,  26974,24 ,  14644,28 ,  14672,50 ,  14722,14 ,  14644,28 ,  14672,50 ,  14722,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      155,3 ,  15796,24 ,       4,4 ,       4,0 ,   4779,10 ,    1791,8 ,     2,     1,     7,     6,     7 }, // North Ndebele/Latin/Zimbabwe
    {    182,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  26998,39 , 27037,194 ,  27231,24 ,  26998,39 , 27037,194 ,  27231,24 ,  14736,29 ,  14765,65 ,  14830,14 ,  14736,29 ,  14765,65 ,  14830,14 ,     508,8 ,     487,7 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15820,25 ,       4,4 ,       4,0 ,    4789,9 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Rombo/Latin/Tanzania
    {    183,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  27255,48 ,  27303,81 ,  27384,24 ,  27255,48 ,  27303,81 ,  27384,24 ,  14844,30 ,  14874,47 ,     85,14 ,  14844,30 ,  14874,47 ,     85,14 ,     516,6 ,     494,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  15845,21 ,       0,4 ,       4,0 ,    4798,7 ,    4805,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Tifinagh/Morocco
    {    183,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  27408,48 ,  27456,81 ,  27537,24 ,  27408,48 ,  27456,81 ,  27537,24 ,  14921,30 ,  14951,48 ,     85,14 ,  14921,30 ,  14951,48 ,     85,14 ,     522,6 ,     502,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  15866,21 ,       0,4 ,       4,0 ,   4811,10 ,    4821,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Latin/Morocco
    {    184,     7,     3,    44,   160,    59,    37,    48,    45,    43,   122,     171,     187,    8220,    8221,       0,6 ,       0,6 ,    847,12 ,    859,11 ,     433,8 ,     98,16 ,      18,7 ,     25,12 ,  27561,48 ,  27609,82 ,  27691,24 ,  27715,48 ,  27763,84 ,  27847,24 ,  14999,28 ,  15027,34 ,  15061,14 ,  15075,30 ,  15105,51 ,  15156,14 ,     528,7 ,     510,9 , 1052,7 , 1059,23 , 1082,29 , {68,90,68},      198,2 ,  15887,53 ,       0,4 ,       4,0 ,    4827,9 ,    4836,8 ,     2,     1,     6,     5,     6 }, // Kabyle/Latin/Algeria
    {    185,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  27871,48 , 27919,152 ,    134,24 ,  27871,48 , 27919,152 ,    134,24 ,  15170,28 ,  15198,74 ,  15272,14 ,  15170,28 ,  15198,74 ,  15272,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,  15940,26 ,       4,4 ,       4,0 ,   4844,10 ,    1681,6 ,     0,     0,     1,     6,     7 }, // Nyankole/Latin/Uganda
    {    186,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  28071,48 , 28119,254 ,  28373,24 ,  28071,48 , 28119,254 ,  28373,24 ,  15286,28 ,  15314,82 ,  15396,14 ,  15286,28 ,  15314,82 ,  15396,14 ,     535,7 ,     519,7 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15966,29 ,       0,4 ,       4,0 ,    4854,6 ,   4860,10 ,     0,     0,     1,     6,     7 }, // Bena/Latin/Tanzania
    {    187,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  28397,87 ,    134,24 ,  18463,48 ,  28397,87 ,    134,24 ,  15410,28 ,  15438,62 ,  15500,14 ,  15410,28 ,  15438,62 ,  15500,14 ,     542,5 ,     526,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15995,27 ,       4,4 ,       4,0 ,    4870,8 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Vunjo/Latin/Tanzania
    {    188,     7,   132,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  28484,47 ,  28531,92 ,  28623,24 ,  28484,47 ,  28531,92 ,  28623,24 ,  15514,28 ,  15542,44 ,  15586,14 ,  15514,28 ,  15542,44 ,  15586,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16022,24 ,       4,4 ,       4,0 ,    4878,9 ,    2155,4 ,     0,     0,     1,     6,     7 }, // Bambara/Latin/Mali
    {    188,    75,   132,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Bambara/Nko/Mali
    {    189,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  28647,48 , 28695,207 ,  28902,24 ,  28647,48 , 28695,207 ,  28902,24 ,  15600,28 ,  15628,64 ,  15692,14 ,  15600,28 ,  15628,64 ,  15692,14 ,     547,2 ,     535,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15623,24 ,       4,4 ,       4,0 ,    4887,6 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Embu/Latin/Kenya
    {    190,    12,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     870,8 ,     870,8 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,  28926,36 ,  28962,58 ,  29020,24 ,  28926,36 ,  28962,58 ,  29020,24 ,  15706,28 ,  15734,49 ,  15783,14 ,  15706,28 ,  15734,49 ,  15783,14 ,     549,3 ,     537,6 , 1111,6 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  16046,25 ,       4,4 ,       4,0 ,    4893,3 ,   4896,15 ,     2,     1,     7,     6,     7 }, // Cherokee/Cherokee/United States
    {    191,     7,   137,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  29044,47 ,  29091,68 ,  29159,24 ,  29044,47 ,  29091,68 ,  29159,24 ,  15797,27 ,  15824,48 ,  15872,14 ,  15797,27 ,  15824,48 ,  15872,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,85,82},      172,2 ,  16071,21 ,      41,6 ,       4,0 ,   4911,14 ,    4925,5 ,     0,     0,     1,     6,     7 }, // Morisyen/Latin/Mauritius
    {    192,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 , 29183,264 ,    134,24 ,  18463,48 , 29183,264 ,    134,24 ,  15886,28 , 15914,133 ,  14830,14 ,  15886,28 , 15914,133 ,  14830,14 ,     552,4 ,     543,5 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15995,27 ,       4,4 ,       4,0 ,   4930,10 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Makonde/Latin/Tanzania
    {    193,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  29447,83 , 29530,111 ,  29641,24 ,  29447,83 , 29530,111 ,  29641,24 ,  16047,36 ,  16083,63 ,  16146,14 ,  16047,36 ,  16083,63 ,  16146,14 ,     556,3 ,     548,3 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  16092,29 ,      41,6 ,       4,0 ,    4940,8 ,    4948,9 ,     0,     0,     1,     6,     7 }, // Langi/Latin/Tanzania
    {    194,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  29665,48 ,  29713,97 ,    134,24 ,  29665,48 ,  29713,97 ,    134,24 ,  16160,28 ,  16188,66 ,  16254,14 ,  16160,28 ,  16188,66 ,  16254,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,  16121,26 ,       0,4 ,       4,0 ,    4957,7 ,    4964,7 ,     0,     0,     1,     6,     7 }, // Ganda/Latin/Uganda
    {    195,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,  29810,48 ,  29858,83 ,  29941,24 ,  29810,48 ,  29858,83 ,  29941,24 ,  16268,80 ,  16268,80 ,     85,14 ,  16268,80 ,  16268,80 ,     85,14 ,     559,8 ,     551,7 ,   45,4 ,   5,17 ,  22,23 , {90,77,87},      127,1 ,       0,7 ,       4,4 ,       4,0 ,    4971,9 ,    1785,6 ,     2,     1,     1,     6,     7 }, // Bemba/Latin/Zambia
    {    196,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     163,7 ,     163,7 ,     433,8 ,   1594,27 ,      37,5 ,      8,10 ,  29965,48 ,  30013,85 ,    134,24 ,  29965,48 ,  30013,85 ,    134,24 ,  16348,28 ,  16376,73 ,  16449,14 ,  16348,28 ,  16463,73 ,  16449,14 ,      70,2 ,      67,2 ,   45,4 , 340,17 ,  22,23 , {67,86,69},      271,1 ,  16147,43 ,      13,5 ,       4,0 ,   4980,12 ,   4992,10 ,     2,     1,     1,     6,     7 }, // Kabuverdianu/Latin/Cape Verde
    {    197,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  30098,48 ,  30146,86 ,  30232,24 ,  30098,48 ,  30146,86 ,  30232,24 ,  16536,28 ,  16564,51 ,  16615,14 ,  16536,28 ,  16564,51 ,  16615,14 ,     567,2 ,     558,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15623,24 ,       4,4 ,       4,0 ,    5002,6 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Meru/Latin/Kenya
    {    198,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  30256,49 , 30305,121 ,  30426,24 ,  30256,49 , 30305,121 ,  30426,24 ,  16629,28 ,  16657,53 ,  16710,14 ,  16629,28 ,  16657,53 ,  16710,14 ,     569,6 ,    560,10 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16190,26 ,       4,4 ,       4,0 ,    5008,8 ,   5016,12 ,     2,     1,     7,     6,     7 }, // Kalenjin/Latin/Kenya
    {    199,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,      0,48 , 30450,136 ,    134,24 ,      0,48 , 30450,136 ,    134,24 ,  16724,23 ,  16747,92 ,  16839,14 ,  16724,23 ,  16747,92 ,  16839,14 ,     575,7 ,     570,5 ,   45,4 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,  16216,22 ,       4,4 ,       4,0 ,   5028,13 ,    5041,8 ,     2,     1,     1,     6,     7 }, // Nama/Latin/Namibia
    {    200,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  28397,87 ,    134,24 ,  18463,48 ,  28397,87 ,    134,24 ,  15410,28 ,  15438,62 ,  15500,14 ,  15410,28 ,  15438,62 ,  15500,14 ,     542,5 ,     526,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15995,27 ,       4,4 ,       4,0 ,    5049,9 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Machame/Latin/Tanzania
    {    201,     7,    82,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     427,8 ,     427,8 ,   1089,10 ,   1621,23 ,      37,5 ,      8,10 ,  30586,59 ,  30645,87 ,  12825,24 ,  30732,48 ,  30645,87 ,  12825,24 ,  16853,28 ,  16881,72 ,   3738,14 ,  16853,28 ,  16881,72 ,   3738,14 ,    582,16 ,    575,16 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16238,11 ,      13,5 ,       4,0 ,    5058,6 ,   5064,11 ,     2,     1,     1,     6,     7 }, // Colognian/Latin/Germany
    {    202,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  30780,51 , 30831,132 ,    158,27 ,  30780,51 , 30831,132 ,    158,27 ,  15410,28 ,  16953,58 ,  14830,14 ,  15410,28 ,  16953,58 ,  14830,14 ,     598,9 ,     591,6 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16249,25 ,       4,4 ,       4,0 ,    5075,3 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Masai/Latin/Kenya
    {    202,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  30780,51 , 30831,132 ,    158,27 ,  30780,51 , 30831,132 ,    158,27 ,  15410,28 ,  16953,58 ,  14830,14 ,  15410,28 ,  16953,58 ,  14830,14 ,     598,9 ,     591,6 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  16274,28 ,       4,4 ,       4,0 ,    5075,3 ,    5078,8 ,     0,     0,     1,     6,     7 }, // Masai/Latin/Tanzania
    {    203,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  29665,48 ,  29713,97 ,    134,24 ,  29665,48 ,  29713,97 ,    134,24 ,  17011,35 ,  17046,65 ,  17111,14 ,  17011,35 ,  17046,65 ,  17111,14 ,     607,6 ,     597,6 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,  16121,26 ,      13,5 ,       4,0 ,    5086,7 ,    4964,7 ,     0,     0,     1,     6,     7 }, // Soga/Latin/Uganda
    {    204,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  30963,48 ,  18511,84 ,    134,24 ,  30963,48 ,  18511,84 ,    134,24 ,  17125,21 ,  17146,75 ,     85,14 ,  17125,21 ,  17146,75 ,     85,14 ,      66,4 ,      63,4 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16302,23 ,       4,4 ,     102,6 ,    5093,7 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Luyia/Latin/Kenya
    {    205,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  31011,48 ,  18511,84 ,    134,24 ,  31011,48 ,  18511,84 ,    134,24 ,  17221,28 ,   9767,60 ,  15500,14 ,  17221,28 ,   9767,60 ,  15500,14 ,     613,9 ,     603,8 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  16325,28 ,      13,5 ,       4,0 ,    5100,6 ,    5106,8 ,     0,     0,     1,     6,     7 }, // Asu/Latin/Tanzania
    {    206,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  31059,48 ,  31107,94 ,  31201,24 ,  31059,48 ,  31107,94 ,  31201,24 ,  17249,28 ,  17277,69 ,  17346,14 ,  17249,28 ,  17277,69 ,  17346,14 ,     622,9 ,     611,6 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,  16353,28 ,       4,4 ,       4,0 ,    5114,6 ,    1681,6 ,     0,     0,     1,     6,     7 }, // Teso/Latin/Uganda
    {    206,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  31059,48 ,  31107,94 ,  31201,24 ,  31059,48 ,  31107,94 ,  31201,24 ,  17249,28 ,  17277,69 ,  17346,14 ,  17249,28 ,  17277,69 ,  17346,14 ,     622,9 ,     611,6 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16381,27 ,       4,4 ,       4,0 ,    5114,6 ,    5120,5 ,     2,     1,     7,     6,     7 }, // Teso/Latin/Kenya
    {    207,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Saho/Latin/Eritrea
    {    208,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  31225,46 ,  31271,88 ,  31359,24 ,  31225,46 ,  31271,88 ,  31359,24 ,  17360,28 ,  17388,53 ,  17441,14 ,  17360,28 ,  17388,53 ,  17441,14 ,     631,6 ,     617,6 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16408,23 ,       0,4 ,       4,0 ,   5125,11 ,    5136,5 ,     0,     0,     1,     6,     7 }, // Koyra Chiini/Latin/Mali
    {    209,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  28397,87 ,    134,24 ,  18463,48 ,  28397,87 ,    134,24 ,  15410,28 ,  15438,62 ,  15500,14 ,  15410,28 ,  15438,62 ,  15500,14 ,     542,5 ,     526,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  15995,27 ,       0,4 ,       4,0 ,    5141,6 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Rwa/Latin/Tanzania
    {    210,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  31383,48 , 31431,186 ,  31617,24 ,  31383,48 , 31431,186 ,  31617,24 ,  17455,28 ,  17483,69 ,  17552,14 ,  17455,28 ,  17483,69 ,  17552,14 ,     637,2 ,     623,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16431,23 ,       0,4 ,       4,0 ,    5147,6 ,    1182,5 ,     2,     1,     7,     6,     7 }, // Luo/Latin/Kenya
    {    211,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  27871,48 , 27919,152 ,    134,24 ,  27871,48 , 27919,152 ,    134,24 ,  15170,28 ,  15198,74 ,  15272,14 ,  15170,28 ,  15198,74 ,  15272,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      193,3 ,  15940,26 ,       4,4 ,       4,0 ,    5153,6 ,    1681,6 ,     0,     0,     1,     6,     7 }, // Chiga/Latin/Uganda
    {    212,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  31641,48 ,  31689,86 ,  31775,24 ,  31641,48 ,  31689,86 ,  31775,24 ,  17566,28 ,  17594,48 ,  17642,14 ,  17566,28 ,  17594,48 ,  17642,14 ,     639,9 ,    625,10 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  16454,22 ,      13,5 ,       4,0 ,   5159,17 ,    5176,6 ,     2,     1,     6,     5,     6 }, // Central Morocco Tamazight/Latin/Morocco
    {    213,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  31225,46 ,  31271,88 ,  31359,24 ,  31225,46 ,  31271,88 ,  31359,24 ,  17656,28 ,  17684,54 ,  17441,14 ,  17656,28 ,  17684,54 ,  17441,14 ,     631,6 ,     617,6 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16408,23 ,       0,4 ,       4,0 ,   5182,15 ,    5136,5 ,     0,     0,     1,     6,     7 }, // Koyraboro Senni/Latin/Mali
    {    214,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  18463,48 ,  31799,84 ,    134,24 ,  18463,48 ,  31799,84 ,    134,24 ,  17738,28 ,  17766,63 ,  17829,14 ,  17738,28 ,  17766,63 ,  17829,14 ,     648,5 ,     635,8 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  16476,27 ,       0,4 ,       4,0 ,    5197,9 ,    1616,8 ,     0,     0,     1,     6,     7 }, // Shambala/Latin/Tanzania
    {    215,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     543,6 ,     35,18 ,      18,7 ,     25,12 ,  31883,88 ,  31883,88 ,  31971,31 ,  31883,88 ,  31883,88 ,  31971,31 ,  17843,33 ,  17876,54 ,  17930,19 ,  17843,33 ,  17876,54 ,  17930,19 ,     653,3 ,     643,6 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,  16503,10 ,       8,5 ,       4,0 ,    5206,4 ,    2633,4 ,     2,     1,     7,     7,     7 }, // Bodo/Devanagari/India
    {    218,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  21292,48 ,  11235,80 ,  11152,24 ,  21292,48 ,  11235,80 ,  11152,24 ,  17949,25 ,  17974,45 ,  18019,17 ,  17949,25 ,  17974,45 ,  17949,25 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,  16513,43 ,      13,5 ,       4,0 ,    5210,7 ,    5217,5 ,     2,     1,     1,     6,     7 }, // Chechen/Cyrillic/Russia
    {    219,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     878,8 ,     878,8 ,    955,10 ,   1644,23 ,      37,5 ,      8,10 ,  32002,65 , 32067,117 ,  32184,30 ,  32002,65 , 32214,117 ,  32184,30 ,  18036,37 ,  18073,68 ,  11221,14 ,  18036,37 ,  18073,68 ,  11221,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,  16556,44 ,      13,5 ,       4,0 ,   5222,19 ,    5241,7 ,     2,     1,     1,     6,     7 }, // Church/Cyrillic/Russia
    {    220,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      119,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Chuvash/Cyrillic/Russia
    {    230,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  32331,49 ,  32380,99 ,  32479,24 ,  32331,49 ,  32380,99 ,  32479,24 ,  18141,28 ,  18169,50 ,  18219,14 ,  18141,28 ,  18169,50 ,  18219,14 ,     656,5 ,     649,6 ,   45,4 ,   5,17 ,  22,23 , {67,68,70},      203,2 ,  16600,24 ,       0,4 ,       4,0 ,    5248,8 ,   5256,16 ,     2,     1,     1,     6,     7 }, // Luba Katanga/Latin/Congo Kinshasa
    {    231,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,    886,10 ,    886,10 ,     174,8 ,    593,18 ,      37,5 ,      8,10 ,  32503,48 ,  32551,85 ,    134,24 ,  32636,59 ,  32551,85 ,    134,24 ,  18233,28 ,  18261,65 ,   3738,14 ,  18326,35 ,  18261,65 ,   3738,14 ,     661,5 ,     655,8 ,  452,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8384,19 ,      13,5 ,       4,0 ,   5272,14 ,   5286,10 ,     2,     1,     1,     6,     7 }, // Luxembourgish/Latin/Luxembourg
    {    236,     7,    21,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Walloon/Latin/Belgium
    {    237,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  32695,48 , 32743,195 ,  32938,24 ,  32695,48 , 32743,195 ,  32938,24 ,  18361,28 ,  18389,72 ,  18461,14 ,  18361,28 ,  18389,72 ,  18461,14 ,     666,3 ,     663,3 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16624,21 ,       0,4 ,       4,0 ,    5296,5 ,    5301,7 ,     0,     0,     1,     6,     7 }, // Aghem/Latin/Cameroon
    {    238,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  32962,48 ,  33010,90 ,  33100,24 ,  32962,48 ,  33010,90 ,  33100,24 ,  18475,28 ,  18503,70 ,  18573,14 ,  18475,28 ,  18503,70 ,  18573,14 ,    669,10 ,     666,9 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16645,22 ,      13,5 ,       4,0 ,    5308,5 ,    5313,8 ,     0,     0,     1,     6,     7 }, // Basaa/Latin/Cameroon
    {    239,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  31225,46 ,  31271,88 ,  31359,24 ,  31225,46 ,  31271,88 ,  31359,24 ,  17656,28 ,  18587,53 ,  18640,14 ,  17656,28 ,  18587,53 ,  18640,14 ,     679,8 ,    675,10 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16408,23 ,       0,4 ,       4,0 ,   5321,10 ,    5331,5 ,     0,     0,     1,     6,     7 }, // Zarma/Latin/Niger
    {    240,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  33124,49 ,  33173,99 ,  33272,24 ,  33124,49 ,  33173,99 ,  33272,24 ,  18654,28 ,  18682,45 ,  18727,14 ,  18654,28 ,  18682,45 ,  18727,14 ,     687,5 ,     685,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,      13,5 ,       4,0 ,    5336,5 ,    1952,8 ,     0,     0,     1,     6,     7 }, // Duala/Latin/Cameroon
    {    241,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  33296,36 ,  33332,82 ,  33414,24 ,  33296,36 ,  33332,82 ,  33414,24 ,  18741,28 ,  18769,50 ,  18819,14 ,  18741,28 ,  18769,50 ,  18819,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16667,23 ,      13,5 ,       4,0 ,    5341,5 ,    5346,7 ,     0,     0,     1,     6,     7 }, // Jola Fonyi/Latin/Senegal
    {    242,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  33438,50 , 33488,141 ,  33629,24 ,  33438,50 , 33488,141 ,  33629,24 ,  18833,30 ,  18863,85 ,  18948,14 ,  18833,30 ,  18863,85 ,  18948,14 ,     692,7 ,     691,9 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16690,23 ,      13,5 ,       4,0 ,    5353,6 ,    5359,7 ,     0,     0,     1,     6,     7 }, // Ewondo/Latin/Cameroon
    {    243,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  33653,39 , 33692,191 ,    158,27 ,  33653,39 , 33692,191 ,    158,27 ,  18962,29 ,  18991,45 ,  19036,14 ,  18962,29 ,  18991,45 ,  19036,14 ,     699,6 ,     700,7 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16713,11 ,      13,5 ,       4,0 ,    5366,5 ,    5371,7 ,     0,     0,     1,     6,     7 }, // Bafia/Latin/Cameroon
    {    244,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  33883,48 , 33931,213 ,  34144,24 ,  33883,48 , 33931,213 ,  34144,24 ,  19050,28 ,  19078,59 ,  19137,14 ,  19050,28 ,  19078,59 ,  19137,14 ,     705,8 ,    707,10 ,   45,4 ,   5,17 ,  22,23 , {77,90,78},      272,3 ,       0,7 ,      41,6 ,       4,0 ,    5378,5 ,   5383,10 ,     2,     1,     7,     6,     7 }, // Makhuwa Meetto/Latin/Mozambique
    {    245,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  34168,48 , 34216,139 ,  34355,24 ,  34168,48 , 34216,139 ,  34355,24 ,  19151,28 ,  19179,74 ,  19253,14 ,  19151,28 ,  19179,74 ,  19253,14 ,     713,5 ,     717,5 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16724,17 ,       4,4 ,       4,0 ,    5393,6 ,    5399,7 ,     0,     0,     1,     6,     7 }, // Mundang/Latin/Cameroon
    {    246,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  34379,51 , 34430,143 ,    158,27 ,  34379,51 , 34430,143 ,    158,27 ,  19267,30 ,  19297,89 ,  19386,14 ,  19267,30 ,  19297,89 ,  19386,14 ,     718,4 ,     722,4 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16741,20 ,      13,5 ,       4,0 ,    5406,6 ,    5412,7 ,     0,     0,     1,     6,     7 }, // Kwasio/Latin/Cameroon
    {    247,     7,   254,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    1667,9 ,     98,16 ,      18,7 ,    551,12 ,  34573,54 ,  34627,96 ,  34723,24 ,  34573,54 ,  34627,96 ,  34723,24 ,  19400,38 ,  19438,79 ,  19517,14 ,  19400,38 ,  19438,79 ,  19517,14 ,     722,2 ,     726,2 ,   45,4 ,   5,17 ,  22,23 , {83,83,80},      115,1 ,       0,7 ,       4,4 ,       4,0 ,    5419,9 ,       0,0 ,     2,     1,     1,     6,     7 }, // Nuer/Latin/South Sudan
    {    248,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,    896,11 ,    896,11 ,     245,6 ,   1676,30 ,      37,5 ,      8,10 ,  34747,50 , 34797,116 ,  34913,24 ,  34747,50 , 34937,121 ,  34913,24 ,  19531,21 ,  19552,71 ,  19623,14 ,  19531,21 ,  19552,71 ,  19623,14 ,     724,2 ,     728,2 , 1117,5 , 1122,17 ,  22,23 , {82,85,66},      119,1 ,  16761,47 ,      13,5 ,       4,0 ,    5428,9 ,    5437,9 ,     2,     1,     1,     6,     7 }, // Sakha/Cyrillic/Russia
    {    249,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      37,5 ,      8,10 ,  35058,48 , 35106,117 ,    158,27 ,  35058,48 , 35106,117 ,    158,27 ,  19637,28 ,  19665,60 ,  19725,14 ,  19637,28 ,  19665,60 ,  19725,14 ,     726,9 ,     730,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      188,3 ,  16808,25 ,       0,4 ,       4,0 ,    5446,9 ,    5455,9 ,     0,     0,     1,     6,     7 }, // Sangu/Latin/Tanzania
    {    251,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  31225,46 ,  31271,88 ,  31359,24 ,  31225,46 ,  31271,88 ,  31359,24 ,  17656,28 ,  17684,54 ,  17441,14 ,  17656,28 ,  17684,54 ,  17441,14 ,     679,8 ,    675,10 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      200,3 ,  16408,23 ,       0,4 ,       4,0 ,   5464,13 ,    5331,5 ,     0,     0,     1,     6,     7 }, // Tasawaq/Latin/Niger
    {    252,    35,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,  35223,38 ,  35261,61 ,    158,27 ,  35223,38 ,  35261,61 ,    158,27 ,  19739,30 ,  19739,30 ,     85,14 ,  19739,30 ,  19739,30 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,  16833,15 ,       4,4 ,       4,0 ,    5477,2 ,    5479,4 ,     2,     1,     1,     6,     7 }, // Vai/Vai/Liberia
    {    252,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    120,10 ,     10,17 ,      18,7 ,     25,12 ,  35322,81 ,  35322,81 ,    158,27 ,  35322,81 ,  35322,81 ,    158,27 ,  19769,48 ,  19769,48 ,     85,14 ,  19769,48 ,  19769,48 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,  16848,20 ,       4,4 ,       4,0 ,    5483,3 ,    5486,8 ,     2,     1,     1,     6,     7 }, // Vai/Latin/Liberia
    {    253,     7,   206,    44,  8217,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     269,9 ,     269,9 ,     53,10 ,    593,18 ,      37,5 ,      8,10 ,  35403,48 ,  35451,99 ,  35550,24 ,  35403,48 ,  35451,99 ,  35550,24 ,  19817,28 ,  19845,53 ,  19898,14 ,  19817,28 ,  19845,53 ,  19898,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},        0,0 ,       0,7 ,      41,6 ,       4,0 ,    5494,6 ,    5500,6 ,     2,     0,     1,     6,     7 }, // Walser/Latin/Switzerland
    {    254,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  35574,51 , 35625,191 ,    158,27 ,  35574,51 , 35625,191 ,    158,27 ,  19912,21 ,  19933,71 ,  20004,14 ,  19912,21 ,  19933,71 ,  20004,14 ,     735,8 ,     739,8 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,      13,5 ,       4,0 ,    5506,6 ,    5512,7 ,     0,     0,     1,     6,     7 }, // Yangben/Latin/Cameroon
    {    256,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     625,7 ,     625,7 ,     287,6 ,    390,22 ,      37,5 ,      8,10 ,  35816,48 ,  35864,85 ,  35949,24 ,  35973,48 , 36021,117 ,  35949,24 ,  20018,28 ,  20046,54 ,   3434,14 ,  20018,28 ,  20046,54 ,   3434,14 ,    743,12 ,    747,11 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    5519,9 ,    2398,6 ,     2,     1,     1,     6,     7 }, // Asturian/Latin/Spain
    {    257,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,    907,11 ,    907,11 ,    918,16 ,     934,9 ,     53,10 ,   1497,18 ,      37,5 ,      8,10 , 36138,174 , 36138,174 ,    158,27 , 36138,174 , 36138,174 ,    158,27 ,  20100,60 ,  20100,60 ,  20160,25 ,  20100,60 ,  20100,60 ,  20160,25 ,     755,8 ,    758,13 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16868,12 ,       8,5 ,       4,0 ,    5528,5 ,    5533,7 ,     0,     0,     1,     6,     7 }, // Ngomba/Latin/Cameroon
    {    258,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,   1706,10 ,    686,17 ,      37,5 ,      8,10 , 36312,102 , 36312,102 ,    158,27 , 36312,102 , 36312,102 ,    158,27 ,  20185,54 ,  20185,54 ,  20239,21 ,  20185,54 ,  20185,54 ,  20239,21 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16880,16 ,      41,6 ,       4,0 ,    5540,4 ,    5544,7 ,     0,     0,     1,     6,     7 }, // Kako/Latin/Cameroon
    {    259,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1497,18 ,      37,5 ,      8,10 , 36414,137 , 36551,142 ,  36693,36 , 36414,137 , 36551,142 ,  36693,36 ,  20260,49 ,  20260,49 ,  20309,21 ,  20260,49 ,  20260,49 ,  20309,21 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16896,12 ,       8,5 ,       4,0 ,    5551,5 ,    5556,7 ,     0,     0,     1,     6,     7 }, // Meta/Latin/Cameroon
    {    260,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1716,32 ,      37,5 ,      8,10 , 36729,165 , 36729,165 ,    158,27 , 36729,165 , 36729,165 ,    158,27 , 20330,111 , 20330,111 ,     85,14 , 20330,111 , 20330,111 ,     85,14 ,     763,9 ,     771,8 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16908,16 ,       8,5 ,       4,0 ,   5563,16 ,    5579,7 ,     0,     0,     1,     6,     7 }, // Ngiemboon/Latin/Cameroon
    {    290,    11,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      117,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     7,     7 }, // Manipuri/Bengali/India
    {    309,   100,   232,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {86,78,68},      332,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Tai Dam/Tai Viet/Vietnam
    {    312,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Akoose/Latin/Cameroon
    {    313,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     543,6 ,     35,18 ,      18,7 ,     25,12 , 36894,180 , 36894,180 ,    158,27 , 36894,180 , 36894,180 ,    158,27 ,  20441,87 ,  20441,87 ,     85,14 ,  20441,87 ,  20441,87 ,  20528,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,       0,7 ,      41,6 ,       4,0 ,   5586,12 ,   5598,22 ,     2,     1,     7,     6,     7 }, // Lakota/Latin/United States
    {    314,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     433,8 ,     98,16 ,      37,5 ,      8,10 ,  27255,48 ,  27303,81 ,  27384,24 ,  27255,48 ,  27303,81 ,  27384,24 ,  14844,30 ,  20542,48 ,     85,14 ,  14844,30 ,  20542,48 ,     85,14 ,     516,6 ,     494,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  15845,21 ,       0,4 ,       4,0 ,    5620,8 ,    4805,6 ,     2,     1,     6,     5,     6 }, // Standard Moroccan Tamazight/Tifinagh/Morocco
    {    315,     7,    43,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,76,80},        6,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Mapuche/Latin/Chile
    {    316,     1,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 , 37074,105 , 37074,105 ,  37179,24 , 37074,105 , 37074,105 ,  37179,24 ,  20590,58 ,  20590,58 ,  20648,14 ,  20590,58 ,  20590,58 ,  20648,14 ,     772,3 ,     779,3 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},       44,5 ,  16924,20 ,      13,5 ,       4,0 ,   5628,14 ,    5642,5 ,     0,     0,     6,     5,     6 }, // Central Kurdish/Arabic/Iraq
    {    316,     1,   102,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 , 37074,105 , 37074,105 ,  37179,24 , 37074,105 , 37074,105 ,  37179,24 ,  20590,58 ,  20590,58 ,  20648,14 ,  20590,58 ,  20590,58 ,  20648,14 ,     772,3 ,     779,3 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,  16944,19 ,      13,5 ,       4,0 ,   5628,14 ,    5647,5 ,     0,     0,     6,     5,     5 }, // Central Kurdish/Arabic/Iran
    {    317,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     185,7 ,     185,7 ,     114,6 ,    593,18 ,      55,4 ,      59,9 ,  37203,48 ,  37251,85 ,  16435,24 ,  37336,60 ,  37396,93 ,  16435,24 ,  20662,28 ,  20690,53 ,  20743,14 ,  20662,28 ,  20690,53 ,  20743,14 ,     775,9 ,    782,10 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16963,27 ,      13,5 ,       4,0 ,   5652,14 ,    5666,6 ,     2,     1,     1,     6,     7 }, // Lower Sorbian/Latin/Germany
    {    318,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     185,7 ,     185,7 ,     114,6 ,    593,18 ,    563,12 ,      59,9 ,  37489,48 ,  37537,86 ,  16435,24 ,  37623,60 ,  37683,93 ,  16435,24 ,  20757,28 ,  20785,53 ,  20838,14 ,  20757,28 ,  20785,53 ,  20838,14 ,     775,9 ,     792,9 , 1139,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16990,29 ,      13,5 ,       4,0 ,   5672,15 ,    5687,6 ,     2,     1,     1,     6,     7 }, // Upper Sorbian/Latin/Germany
    {    319,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Kenyang/Latin/Cameroon
    {    320,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      233,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Mohawk/Latin/Canada
    {    321,    75,    91,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,78,70},      209,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Nko/Nko/Guinea
    {    322,     7,   260,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,     943,8 ,     943,8 ,     174,8 ,   1748,27 ,      37,5 ,      8,10 ,  37776,48 ,  37824,91 ,  37915,24 ,  37776,48 ,  37824,91 ,  37915,24 ,  20852,28 ,  20880,69 ,  20949,14 ,  20852,28 ,  20880,69 ,  20949,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,    5693,9 ,    5702,6 ,     2,     1,     1,     6,     7 }, // Prussian/Latin/World
    {    323,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,84,81},      299,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Kiche/Latin/Guatemala
    {    324,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      186,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     1,     6,     7 }, // Southern Sami/Latin/Sweden
    {    325,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      186,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     1,     6,     7 }, // Lule Sami/Latin/Sweden
    {    326,     7,    73,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     611,8 ,   1775,18 ,     243,4 ,     247,9 ,  37939,77 , 38016,140 ,  38156,25 ,  37939,77 , 38016,140 ,  38156,25 ,  20963,28 ,  20991,70 ,     85,14 ,  20963,28 ,  21061,73 ,  21134,14 ,     784,3 ,     801,3 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  17019,11 ,      13,5 ,       4,0 ,   5708,11 ,    5719,5 ,     2,     1,     1,     6,     7 }, // Inari Sami/Latin/Finland
    {    327,     7,    73,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Skolt Sami/Latin/Finland
    {    328,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,    368,48 ,    368,48 ,    158,27 ,    368,48 ,    368,48 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {65,85,68},      336,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Warlpiri/Latin/Australia
    {    346,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  14357,70 ,  14357,70 ,    158,27 ,  14357,70 ,  14357,70 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,  653,4 , 657,39 ,  22,23 , {73,82,82},      338,3 ,  17030,27 ,       8,5 ,       4,0 ,    5724,7 ,    3136,5 ,     0,     0,     6,     5,     5 }, // Mazanderani/Arabic/Iran
    {    349,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  38181,77 ,  38181,77 ,    158,27 ,  38181,77 ,  38181,77 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,   5731,11 ,       0,0 ,     0,     0,     6,     5,     5 }, // Northern Luri/Arabic/Iran
    {    349,     1,   103,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,  38181,77 ,  38181,77 ,    158,27 ,  38181,77 ,  38181,77 ,    158,27 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},       44,5 ,       0,7 ,       8,5 ,       4,0 ,   5731,11 ,       0,0 ,     0,     0,     6,     5,     6 }, // Northern Luri/Arabic/Iraq
    {    357,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     170,5 ,     170,5 ,     951,5 ,     951,5 ,     412,8 ,    441,14 ,     198,6 ,    215,13 ,   4671,39 ,   4671,39 ,    158,27 ,   4671,39 ,   4671,39 ,    158,27 ,   2023,28 ,   2023,28 ,   2051,14 ,   2023,28 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,   45,4 ,   5,17 ,  22,23 , {72,75,68},      130,3 ,  17057,11 ,       4,4 ,       4,0 ,    5742,2 ,   5744,14 ,     2,     1,     7,     6,     7 }, // Cantonese/Traditional Han/Hong Kong
    {    357,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     170,5 ,     170,5 ,     951,5 ,     951,5 ,     412,8 ,    420,13 ,     198,6 ,    204,11 ,   4671,39 ,   4710,38 ,    158,27 ,   4671,39 ,   4710,38 ,    158,27 ,   2002,21 ,   2023,28 ,   2051,14 ,   2002,21 ,   2023,28 ,   2051,14 ,      60,2 ,      57,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      129,1 ,   3122,13 ,       4,4 ,       4,0 ,    5758,2 ,    5760,7 ,     2,     1,     7,     6,     7 }, // Cantonese/Simplified Han/China
    {      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,       0,       0,       0,       0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,     0,0,     0,0,     0,0,    {0,0,0},         0,0,        0,0,        0,0,        0,0,        0,0,        0,0,     0,     0,     0,     0,     0 } // trailing 0s
};

static const ushort list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x68, 0x65,
0x20, 0x25, 0x32, 0x25, 0x31, 0x1363, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x25, 0x32, 0x25,
0x31, 0x20, 0x648, 0x25, 0x32, 0x25, 0x31, 0x20, 0x587, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x986, 0x9f0, 0x9c1, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x76, 0x259, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xf51, 0xf44, 0xf0b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x25, 0x32, 0x25, 0x31, 0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x456, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784,
0x200b, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x3001, 0x25, 0x32, 0x25, 0x31, 0x548c, 0x25, 0x32,
0x25, 0x31, 0x53ca, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x67, 0x20, 0x25, 0x32,
0x25, 0x31, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x6b, 0x61, 0x6a, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65,
0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x10d3, 0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x3ba, 0x3b1, 0x3b9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xa85, 0xaa8, 0xac7, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x914, 0x930, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x4d9, 0x43d, 0x435, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x436, 0x430, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xec1, 0xea5, 0xeb0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x70,
0xe9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e,
0xd28, 0xd4d, 0xd28, 0xd3f, 0xd35, 0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f, 0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c,
0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x906, 0x923, 0x93f, 0x20, 0x25,
0x32, 0x25, 0x31, 0x2c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xb13, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x200f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa05, 0xa24, 0xa47, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x219,
0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x4d5, 0x43c, 0x4d5, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xdc3, 0xdc4, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0xa0, 0x25, 0x32, 0x25, 0x31, 0x20,
0x69, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x79, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x6f, 0x63, 0x68, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbae, 0xbb1, 0xbcd, 0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x4bb, 0x4d9, 0x43c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0x20,
0x6d, 0x6f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x77, 0x65, 0x20, 0x25,
0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32,
0x25, 0x32, 0x60c, 0x20, 0x25, 0x31, 0x25, 0x31, 0x20, 0x76, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0, 0x20,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x28, 0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x63, 0x29,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d0, 0x5d5, 0x5df, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x65, 0x2d, 0x25,
0x32, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x6b, 0x6b, 0x65, 0x64, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0x6b, 0x6b, 0x65, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x438, 0x486, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x6e, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x443,
0x43e, 0x43d, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x1e3f, 0x62, 0x25b, 0x6e, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x254, 0x70,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x62, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x540c, 0x25, 0x32
};

static const ushort date_format_data[] = {
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d,
0x2d, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79,
0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x1363, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d, 0x200f, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x569, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64,
0x64, 0x64, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c,
0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x28, 0x27, 0x65, 0x27, 0x29,
0x27, 0x6b, 0x6f, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x72, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x28, 0x27, 0x61, 0x27,
0x29, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf63, 0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0xf5a, 0xf7a, 0xf66,
0xf0b, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x2d,
0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x104a, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x104a, 0x20, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64,
0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x20, 0x4d,
0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64,
0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x64,
0x65, 0x6e, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d,
0x2f, 0x79, 0x79, 0x4d, 0x2f, 0x64, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x79,
0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x27, 0x61, 0x27, 0x20, 0x27,
0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x27, 0x6d, 0x68, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64,
0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x64, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x436,
0x27, 0x2e, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2d,
0x27, 0x436, 0x27, 0x2e, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79,
0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d, 0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0xe97, 0xeb5, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27,
0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x64, 0x27, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x2e,
0x79, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x27, 0x74, 0x61, 0x27, 0x2019, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e,
0x4d, 0x4d, 0x2e, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x4d, 0x4d, 0x2e, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x62f, 0x20, 0x79, 0x79,
0x79, 0x79, 0x20, 0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x69, 0x6c,
0x73, 0x27, 0x20, 0x64, 0x20, 0x27, 0x64, 0x61, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20,
0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x430, 0x437, 0x27, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64,
0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79,
0x79, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79,
0x79, 0x79, 0x79, 0x20, 0x27, 0x435, 0x43b, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0xe17, 0xe35, 0xe48, 0x20,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0xf60, 0xf72, 0xf0b, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x1363, 0x20,
0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d,
0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x64,
0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x440, 0x27,
0x2e, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x79, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20, 0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27,
0x61, 0x27, 0x20, 0x27, 0x64, 0x27, 0x2e, 0x20, 0x64, 0x27, 0x69, 0x64, 0x27, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x5d8, 0x5df, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x2d, 0x4d, 0x2d, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64,
0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64,
0x20, 0x27, 0x6c, 0x69, 0x61, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0x65,
0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0xe4, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x43b, 0x27,
0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
0x20, 0x27, 0x441, 0x44b, 0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x43a, 0x4af, 0x43d, 0x44d, 0x27,
0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x20, 0x2c, 0x20, 0x27, 0x6c, 0x79, 0x25b, 0x27, 0x30c, 0x2bc, 0x20, 0x64, 0x20, 0x27, 0x6e, 0x61, 0x27, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27,
0x6d, 0x65, 0x74, 0x74, 0x61, 0x73, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79
};

static const ushort time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x68, 0x3a,
0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a,
0x6d, 0x6d, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x2c, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x48,
0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0x2e,
0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0xf46,
0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41,
0x50, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x447, 0x27, 0x2e, 0x48, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x447, 0x27, 0x2e, 0x20, 0x74, 0x42, 0x20, 0x48, 0x3a, 0x6d, 0x6d, 0x74, 0x20, 0x48,
0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x41, 0x50,
0x68, 0x3a, 0x6d, 0x6d, 0x74, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x41, 0x50, 0x68, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x5b, 0x74, 0x5d, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73,
0x73, 0x20, 0x74, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x2d, 0x27, 0x61,
0x27, 0x20, 0x27, 0x68, 0x6f, 0x72, 0x6f, 0x27, 0x20, 0x27, 0x6b, 0x61, 0x6a, 0x27, 0x20, 0x6d, 0x3a, 0x73, 0x73, 0x20,
0x74, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27,
0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20,
0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x2e,
0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x27, 0x68, 0x27, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68,
0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x6642, 0x6d, 0x6d, 0x5206, 0x73, 0x73, 0x79d2,
0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d, 0xbd84, 0x20, 0x73, 0xcd08,
0x20, 0x74, 0x48, 0x20, 0xec2, 0xea1, 0xe87, 0x20, 0x6d, 0x20, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73, 0x20, 0xea7, 0xeb4,
0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x27, 0x6b, 0x6c,
0x27, 0x2e, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0xe19, 0xe32, 0xe2c, 0xe34, 0xe01, 0xe32, 0x20, 0x6d, 0x6d, 0x20, 0xe19, 0xe32, 0xe17,
0xe35, 0x20, 0x73, 0x73, 0x20, 0xe27, 0xe34, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x74, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27,
0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x74, 0x27, 0x4b, 0x6c, 0x27, 0x2e, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x27, 0x4b, 0x6c, 0x6f, 0x63, 0x6b, 0x27, 0x20,
0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x41, 0x50, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x68, 0x6f, 0x64, 0x17a, 0x27, 0x2e
};

static const ushort months_data[] = {
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x31, 0x3b,
0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31,
0x31, 0x3b, 0x31, 0x32, 0x3b, 0x41, 0x6d, 0x61, 0x3b, 0x47, 0x75, 0x72, 0x3b, 0x42, 0x69, 0x74, 0x3b, 0x45, 0x6c, 0x62,
0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x57, 0x61, 0x78, 0x3b, 0x41, 0x64, 0x6f, 0x3b, 0x48, 0x61, 0x67, 0x3b, 0x46, 0x75, 0x6c,
0x3b, 0x4f, 0x6e, 0x6b, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x41, 0x6d, 0x61, 0x6a, 0x6a, 0x69, 0x69,
0x3b, 0x47, 0x75, 0x72, 0x61, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x42, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x65,
0x65, 0x73, 0x73, 0x61, 0x3b, 0x45, 0x6c, 0x62, 0x61, 0x3b, 0x43, 0x61, 0x61, 0x6d, 0x73, 0x61, 0x3b, 0x57, 0x61, 0x78,
0x61, 0x62, 0x61, 0x6a, 0x6a, 0x69, 0x69, 0x3b, 0x41, 0x64, 0x6f, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x48,
0x61, 0x67, 0x61, 0x79, 0x79, 0x61, 0x3b, 0x46, 0x75, 0x75, 0x6c, 0x62, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6e, 0x6b, 0x6f,
0x6c, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x53, 0x61, 0x64, 0x61, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x64,
0x64, 0x65, 0x65, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x43, 0x3b, 0x57, 0x3b, 0x41, 0x3b, 0x48, 0x3b,
0x46, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x4d, 0x30, 0x31, 0x3b, 0x4d, 0x30, 0x32, 0x3b, 0x4d, 0x30, 0x33, 0x3b,
0x4d, 0x30, 0x34, 0x3b, 0x4d, 0x30, 0x35, 0x3b, 0x4d, 0x30, 0x36, 0x3b, 0x4d, 0x30, 0x37, 0x3b, 0x4d, 0x30, 0x38, 0x3b,
0x4d, 0x30, 0x39, 0x3b, 0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4a, 0x61, 0x6e, 0x2e,
0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x72, 0x74, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b,
0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x73, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x69, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x69,
0x65, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65,
0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x6b, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x50,
0x72, 0x69, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x3b, 0x4b, 0x6f, 0x72, 0x72, 0x3b, 0x47, 0x75, 0x73, 0x68,
0x3b, 0x53, 0x68, 0x74, 0x3b, 0x54, 0x65, 0x74, 0x3b, 0x4e, 0xeb, 0x6e, 0x3b, 0x44, 0x68, 0x6a, 0x3b, 0x4a, 0x61, 0x6e,
0x61, 0x72, 0x3b, 0x53, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x50, 0x72, 0x69, 0x6c, 0x6c,
0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x3b, 0x4b, 0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b,
0x47, 0x75, 0x73, 0x68, 0x74, 0x3b, 0x53, 0x68, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x3b, 0x54, 0x65, 0x74, 0x6f, 0x72, 0x3b,
0x4e, 0xeb, 0x6e, 0x74, 0x6f, 0x72, 0x3b, 0x44, 0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x4a, 0x3b, 0x53, 0x68, 0x3b,
0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x51, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x68, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44,
0x68, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x73, 0x68, 0x6b, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x72, 0x69, 0x3b, 0x6d, 0x61,
0x6a, 0x3b, 0x71, 0x65, 0x72, 0x3b, 0x6b, 0x6f, 0x72, 0x72, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x3b, 0x73, 0x68, 0x74, 0x3b,
0x74, 0x65, 0x74, 0x3b, 0x6e, 0xeb, 0x6e, 0x3b, 0x64, 0x68, 0x6a, 0x3b, 0x6a, 0x61, 0x6e, 0x61, 0x72, 0x3b, 0x73, 0x68,
0x6b, 0x75, 0x72, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x71, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x3b, 0x6b, 0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x74,
0x3b, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x3b, 0x74, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x6e, 0xeb, 0x6e, 0x74, 0x6f,
0x72, 0x3b, 0x64, 0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x6a, 0x3b, 0x73, 0x68, 0x3b, 0x6d, 0x3b, 0x70, 0x3b, 0x6d,
0x3b, 0x71, 0x3b, 0x6b, 0x3b, 0x67, 0x3b, 0x73, 0x68, 0x3b, 0x74, 0x3b, 0x6e, 0x3b, 0x64, 0x68, 0x3b, 0x1303, 0x1295, 0x12e9,
0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x122a, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301,
0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1276, 0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2,
0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4,
0x1355, 0x122a, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234,
0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1276, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c, 0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234,
0x121d, 0x1260, 0x122d, 0x3b, 0x1303, 0x3b, 0x134c, 0x3b, 0x121b, 0x3b, 0x12a4, 0x3b, 0x121c, 0x3b, 0x1301, 0x3b, 0x1301, 0x3b, 0x12a6, 0x3b,
0x1234, 0x3b, 0x12a6, 0x3b, 0x1296, 0x3b, 0x12f2, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631,
0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646,
0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x633, 0x637, 0x633, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628,
0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645,
0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x648, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x633,
0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x62c, 0x627, 0x646, 0x641, 0x64a, 0x3b, 0x641, 0x64a, 0x641, 0x631, 0x64a, 0x3b, 0x645,
0x627, 0x631, 0x633, 0x3b, 0x623, 0x641, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x62c, 0x648, 0x627, 0x646, 0x3b, 0x62c,
0x648, 0x64a, 0x644, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x62a, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a,
0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b,
0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x623, 0x3b, 0x633, 0x3b, 0x623, 0x3b, 0x646, 0x3b,
0x62f, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b,
0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631,
0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631,
0x64a, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646,
0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x643, 0x3b, 0x634, 0x3b, 0x622, 0x3b,
0x646, 0x3b, 0x623, 0x3b, 0x62d, 0x3b, 0x62a, 0x3b, 0x622, 0x3b, 0x623, 0x3b, 0x62a, 0x3b, 0x62a, 0x3b, 0x643, 0x3b, 0x643, 0x627,
0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631,
0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a,
0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0xa0, 0x627,
0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627,
0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627,
0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x625, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a,
0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x634, 0x62a, 0x3b, 0x634, 0x62a, 0x645, 0x628,
0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x62c, 0x645, 0x628,
0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x625, 0x3b, 0x648, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b,
0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645,
0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b,
0x64a, 0x648, 0x644, 0x64a, 0x648, 0x632, 0x3b, 0x63a, 0x634, 0x62a, 0x3b, 0x634, 0x62a, 0x646, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a,
0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x646, 0x628, 0x631, 0x3b, 0x62f, 0x62c, 0x646, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b,
0x645, 0x3b, 0x623, 0x3b, 0x645, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x634, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b,
0x570, 0x576, 0x57e, 0x3b, 0x583, 0x57f, 0x57e, 0x3b, 0x574, 0x580, 0x57f, 0x3b, 0x561, 0x57a, 0x580, 0x3b, 0x574, 0x575, 0x57d, 0x3b,
0x570, 0x576, 0x57d, 0x3b, 0x570, 0x56c, 0x57d, 0x3b, 0x585, 0x563, 0x57d, 0x3b, 0x57d, 0x565, 0x57a, 0x3b, 0x570, 0x578, 0x56f, 0x3b,
0x576, 0x578, 0x575, 0x3b, 0x564, 0x565, 0x56f, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e, 0x561, 0x580, 0x3b, 0x583, 0x565, 0x57f, 0x580,
0x57e, 0x561, 0x580, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x3b, 0x561, 0x57a, 0x580, 0x56b, 0x56c, 0x3b, 0x574, 0x561, 0x575, 0x56b, 0x57d,
0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x3b, 0x570, 0x578, 0x582, 0x56c, 0x56b, 0x57d, 0x3b, 0x585, 0x563, 0x578, 0x57d, 0x57f,
0x578, 0x57d, 0x3b, 0x57d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x570, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562,
0x565, 0x580, 0x3b, 0x576, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x564, 0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565,
0x580, 0x3b, 0x540, 0x3b, 0x553, 0x3b, 0x544, 0x3b, 0x531, 0x3b, 0x544, 0x3b, 0x540, 0x3b, 0x540, 0x3b, 0x555, 0x3b, 0x54d, 0x3b,
0x540, 0x3b, 0x546, 0x3b, 0x534, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x57e, 0x561, 0x580, 0x56b, 0x3b, 0x583, 0x565, 0x57f, 0x580, 0x57e,
0x561, 0x580, 0x56b, 0x3b, 0x574, 0x561, 0x580, 0x57f, 0x56b, 0x3b, 0x561, 0x57a, 0x580, 0x56b, 0x56c, 0x56b, 0x3b, 0x574, 0x561, 0x575,
0x56b, 0x57d, 0x56b, 0x3b, 0x570, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x56b, 0x3b, 0x570, 0x578, 0x582, 0x56c, 0x56b, 0x57d, 0x56b, 0x3b,
0x585, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x56b, 0x3b, 0x57d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b,
0x570, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x576, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b,
0x3b, 0x564, 0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x56b, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac,
0x9cd, 0x9f0, 0x9c1, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x2019,
0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7,
0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x3b, 0x9a8, 0x9f1, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x99a, 0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1,
0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd,
0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x2019, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2,
0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b7, 0x9cd, 0x99f, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b,
0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9f0, 0x3b, 0x9a8, 0x9f1, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x9a1, 0x9bf, 0x99a, 0x9c7,
0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x99c, 0x3b, 0x9ab, 0x3b, 0x9ae, 0x3b, 0x98f, 0x3b, 0x9ae, 0x3b, 0x99c, 0x3b, 0x99c, 0x3b, 0x986,
0x3b, 0x99b, 0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72,
0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79, 0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x71,
0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e,
0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65,
0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x130, 0x79, 0x75, 0x6e, 0x3b, 0x130, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x71, 0x75,
0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b,
0x4e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x79, 0x61, 0x6e, 0x76, 0x61, 0x72,
0x3b, 0x66, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d,
0x61, 0x79, 0x3b, 0x69, 0x79, 0x75, 0x6e, 0x3b, 0x69, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x75, 0x73, 0x74, 0x3b,
0x73, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0x79,
0x61, 0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x432, 0x3b, 0x43c,
0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x458, 0x43d, 0x3b, 0x438, 0x458, 0x43b, 0x3b, 0x430,
0x432, 0x433, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x458, 0x3b, 0x434, 0x435, 0x43a, 0x3b, 0x408,
0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f,
0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x458, 0x443, 0x43d, 0x3b, 0x418, 0x458, 0x443, 0x43b, 0x3b, 0x410, 0x432,
0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x458, 0x430, 0x431,
0x440, 0x3b, 0x41d, 0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0x458, 0x430, 0x43d, 0x432,
0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b,
0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x458, 0x443, 0x43d, 0x3b, 0x438, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441,
0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43d,
0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0x75, 0x72, 0x74, 0x2e, 0x3b, 0x6f, 0x74,
0x73, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x69, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x2e, 0x3b, 0x65, 0x6b,
0x61, 0x2e, 0x3b, 0x75, 0x7a, 0x74, 0x2e, 0x3b, 0x61, 0x62, 0x75, 0x2e, 0x3b, 0x69, 0x72, 0x61, 0x2e, 0x3b, 0x75, 0x72,
0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x61, 0x2e, 0x3b, 0x61, 0x62, 0x65, 0x2e, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69,
0x6c, 0x61, 0x3b, 0x4f, 0x74, 0x73, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x41,
0x70, 0x69, 0x72, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x45, 0x6b, 0x61, 0x69, 0x6e,
0x61, 0x3b, 0x55, 0x7a, 0x74, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x41, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x49, 0x72,
0x61, 0x69, 0x6c, 0x61, 0x3b, 0x55, 0x72, 0x72, 0x69, 0x61, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x41, 0x62,
0x65, 0x6e, 0x64, 0x75, 0x61, 0x3b, 0x55, 0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b,
0x41, 0x3b, 0x49, 0x3b, 0x55, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x3b,
0x6f, 0x74, 0x73, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x61, 0x70, 0x69, 0x72,
0x69, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x65, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x75,
0x7a, 0x74, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x61, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x69, 0x72, 0x61, 0x69, 0x6c,
0x61, 0x3b, 0x75, 0x72, 0x72, 0x69, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x6e, 0x64,
0x75, 0x61, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0, 0x9c1, 0x9af,
0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7,
0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa,
0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x9ae,
0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7, 0x3b, 0x9ae,
0x9be, 0x3b, 0x98f, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7, 0x3b, 0x985,
0x3b, 0x9a8, 0x3b, 0x9a1, 0x9bf, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a,
0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987,
0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995,
0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd,
0x9ac, 0x9b0, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf22, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf23, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf25, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf27, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf29, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf21, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf22, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b,
0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf5e, 0xf72, 0xf0b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62,
0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1,
0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1,
0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22,
0x3b, 0xf23, 0x3b, 0xf24, 0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21,
0x3b, 0xf21, 0xf22, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0xf24, 0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b,
0xf29, 0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0x31, 0x32, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b,
0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf21, 0x3b, 0xf22, 0x3b, 0xf23, 0x3b, 0x34, 0x3b, 0xf25, 0x3b, 0xf26, 0x3b, 0xf27, 0x3b, 0xf28, 0x3b, 0x39,
0x3b, 0xf21, 0xf20, 0x3b, 0xf21, 0xf21, 0x3b, 0xf21, 0xf22, 0x3b, 0x47, 0x65, 0x6e, 0x2e, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65,
0x2e, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x2e, 0x3b, 0x45, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a,
0x68, 0x2e, 0x3b, 0x47, 0x6f, 0x75, 0x65, 0x2e, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x2e, 0x3b,
0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x7a, 0x75, 0x2e, 0x3b, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b,
0x43, 0x2bc, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x45, 0x62, 0x72,
0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x47, 0x6f, 0x75, 0x65,
0x72, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x48, 0x65, 0x72,
0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x7a, 0x75, 0x3b, 0x30, 0x31, 0x3b, 0x30, 0x32, 0x3b, 0x30, 0x33, 0x3b,
0x30, 0x34, 0x3b, 0x30, 0x35, 0x3b, 0x30, 0x36, 0x3b, 0x30, 0x37, 0x3b, 0x30, 0x38, 0x3b, 0x30, 0x39, 0x3b, 0x31, 0x30,
0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x44f, 0x43d, 0x443, 0x3b, 0x444, 0x435, 0x432, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b,
0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x3b,
0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x435, 0x3b, 0x434, 0x435, 0x43a, 0x3b, 0x44f, 0x43d, 0x443, 0x430,
0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440,
0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441,
0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432, 0x440, 0x438,
0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x44f, 0x3b,
0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x44e, 0x3b, 0x44e, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b,
0x434, 0x3b, 0x1007, 0x1014, 0x103a, 0x3b, 0x1016, 0x1031, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x3b, 0x1019, 0x1031, 0x3b, 0x1007, 0x103d,
0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x3b, 0x1029, 0x3b, 0x1005, 0x1000, 0x103a, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x3b, 0x1014, 0x102d,
0x102f, 0x3b, 0x1012, 0x102e, 0x3b, 0x1007, 0x1014, 0x103a, 0x1014, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1016, 0x1031, 0x1016, 0x1031, 0x102c, 0x103a,
0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031, 0x3b, 0x1007, 0x103d, 0x1014,
0x103a, 0x3b, 0x1007, 0x1030, 0x101c, 0x102d, 0x102f, 0x1004, 0x103a, 0x3b, 0x1029, 0x1002, 0x102f, 0x1010, 0x103a, 0x3b, 0x1005, 0x1000, 0x103a, 0x1010,
0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x1010, 0x102d, 0x102f, 0x1018, 0x102c, 0x3b, 0x1014, 0x102d, 0x102f, 0x101d,
0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1012, 0x102e, 0x1007, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1007, 0x3b, 0x1016, 0x3b, 0x1019, 0x3b, 0x1027,
0x3b, 0x1019, 0x3b, 0x1007, 0x3b, 0x1007, 0x3b, 0x1029, 0x3b, 0x1005, 0x3b, 0x1021, 0x3b, 0x1014, 0x3b, 0x1012, 0x3b, 0x441, 0x442, 0x443,
0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440,
0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441, 0x3b, 0x43b, 0x456, 0x441,
0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x44e, 0x442, 0x44b, 0x3b, 0x441,
0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43c, 0x430, 0x439, 0x3b,
0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x436, 0x43d, 0x456, 0x432, 0x435,
0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x430, 0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d,
0x456, 0x43a, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x3b, 0x441, 0x43d, 0x435, 0x436, 0x430, 0x43d, 0x44c, 0x3b,
0x441, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x43a, 0x3b, 0x43c, 0x3b, 0x447, 0x3b, 0x43b, 0x3b, 0x436, 0x3b, 0x432, 0x3b, 0x43a, 0x3b,
0x43b, 0x3b, 0x441, 0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b,
0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b,
0x43a, 0x430, 0x441, 0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44f,
0x3b, 0x43b, 0x44e, 0x442, 0x430, 0x433, 0x430, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x430, 0x3b, 0x43a, 0x440, 0x430,
0x441, 0x430, 0x432, 0x456, 0x43a, 0x430, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44f, 0x3b, 0x43b,
0x456, 0x43f, 0x435, 0x43d, 0x44f, 0x3b, 0x436, 0x43d, 0x456, 0x45e, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x43d, 0x44f,
0x3b, 0x43a, 0x430, 0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x430, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430,
0x434, 0x430, 0x3b, 0x441, 0x43d, 0x435, 0x436, 0x43d, 0x44f, 0x3b, 0x1798, 0x1780, 0x179a, 0x17b6, 0x3b, 0x1780, 0x17bb, 0x1798, 0x17d2, 0x1797,
0x17c8, 0x3b, 0x1798, 0x17b8, 0x1793, 0x17b6, 0x3b, 0x1798, 0x17c1, 0x179f, 0x17b6, 0x3b, 0x17a7, 0x179f, 0x1797, 0x17b6, 0x3b, 0x1798, 0x17b7, 0x1790,
0x17bb, 0x1793, 0x17b6, 0x3b, 0x1780, 0x1780, 0x17d2, 0x1780, 0x178a, 0x17b6, 0x3b, 0x179f, 0x17b8, 0x17a0, 0x17b6, 0x3b, 0x1780, 0x1789, 0x17d2, 0x1789,
0x17b6, 0x3b, 0x178f, 0x17bb, 0x179b, 0x17b6, 0x3b, 0x179c, 0x17b7, 0x1785, 0x17d2, 0x1786, 0x17b7, 0x1780, 0x17b6, 0x3b, 0x1792, 0x17d2, 0x1793, 0x17bc,
0x3b, 0x1798, 0x3b, 0x1780, 0x3b, 0x1798, 0x3b, 0x1798, 0x3b, 0x17a7, 0x3b, 0x1798, 0x3b, 0x1780, 0x3b, 0x179f, 0x3b, 0x1780, 0x3b, 0x178f,
0x3b, 0x179c, 0x3b, 0x1792, 0x3b, 0x67, 0x65, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0xe7,
0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x2e,
0x3b, 0x61, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0x65, 0x73, 0x2e, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61,
0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x6a,
0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65,
0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47, 0x4e, 0x3b, 0x46, 0x42, 0x3b, 0x4d, 0xc7, 0x3b, 0x41, 0x42, 0x3b, 0x4d,
0x47, 0x3b, 0x4a, 0x4e, 0x3b, 0x4a, 0x4c, 0x3b, 0x41, 0x47, 0x3b, 0x53, 0x54, 0x3b, 0x4f, 0x43, 0x3b, 0x4e, 0x56, 0x3b,
0x44, 0x53, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b,
0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61,
0x69, 0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x64,
0x2019, 0x61, 0x67, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x74, 0x2e, 0x3b,
0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x67,
0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61,
0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x64,
0x65, 0x20, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x64, 0x2019, 0x61,
0x67, 0x6f, 0x73, 0x74, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f,
0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64,
0x65, 0x20, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b,
0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30,
0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db,
0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b,
0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x73, 0x69, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x3b, 0x6f, 0x17e, 0x75,
0x3b, 0x74, 0x72, 0x61, 0x3b, 0x73, 0x76, 0x69, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x72, 0x70, 0x3b, 0x6b, 0x6f, 0x6c,
0x3b, 0x72, 0x75, 0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x73, 0x74, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x73, 0x69, 0x6a,
0x65, 0x10d, 0x61, 0x6e, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x61, 0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x61, 0x6b,
0x3b, 0x74, 0x72, 0x61, 0x76, 0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x76, 0x69, 0x62, 0x61, 0x6e, 0x6a, 0x3b, 0x6c, 0x69, 0x70,
0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x72, 0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x6b, 0x6f, 0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x3b, 0x72,
0x75, 0x6a, 0x61, 0x6e, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e,
0x69, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x61, 0x63, 0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b,
0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30,
0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x6e, 0x6a, 0x61, 0x3b, 0x76,
0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x65, 0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x6b, 0x61, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x6e, 0x6a,
0x61, 0x3b, 0x73, 0x76, 0x69, 0x62, 0x6e, 0x6a, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x72, 0x70,
0x6e, 0x6a, 0x61, 0x3b, 0x6b, 0x6f, 0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x61, 0x3b, 0x72, 0x75, 0x6a, 0x6e, 0x61, 0x3b, 0x6c,
0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x61, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x6f, 0x67, 0x61, 0x3b, 0x70,
0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63, 0x61, 0x3b, 0x6c, 0x65, 0x64, 0x3b, 0xfa, 0x6e, 0x6f, 0x3b, 0x62, 0x159, 0x65, 0x3b,
0x64, 0x75, 0x62, 0x3b, 0x6b, 0x76, 0x11b, 0x3b, 0x10d, 0x76, 0x6e, 0x3b, 0x10d, 0x76, 0x63, 0x3b, 0x73, 0x72, 0x70, 0x3b,
0x7a, 0xe1, 0x159, 0x3b, 0x159, 0xed, 0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x70, 0x72, 0x6f, 0x3b, 0x6c, 0x65, 0x64, 0x65,
0x6e, 0x3b, 0xfa, 0x6e, 0x6f, 0x72, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x65, 0x6e, 0x3b, 0x64, 0x75, 0x62, 0x65, 0x6e, 0x3b,
0x6b, 0x76, 0x11b, 0x74, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e,
0x65, 0x63, 0x3b, 0x73, 0x72, 0x70, 0x65, 0x6e, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x65, 0x6e, 0x3b,
0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x65, 0x63, 0x3b, 0x6c, 0x65,
0x64, 0x6e, 0x61, 0x3b, 0xfa, 0x6e, 0x6f, 0x72, 0x61, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x6e, 0x61, 0x3b, 0x64, 0x75, 0x62,
0x6e, 0x61, 0x3b, 0x6b, 0x76, 0x11b, 0x74, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72,
0x76, 0x65, 0x6e, 0x63, 0x65, 0x3b, 0x73, 0x72, 0x70, 0x6e, 0x61, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a,
0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63,
0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72,
0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e,
0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e,
0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74,
0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f,
0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x72, 0x74, 0x2e, 0x3b,
0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61,
0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64,
0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,
0x3b, 0x6d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e,
0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62,
0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x2e,
0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x63, 0x74, 0x2e,
0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d,
0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61,
0x16d, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x74,
0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x6f, 0x3b, 0x6d, 0x61, 0x6a, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b,
0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x16d, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f,
0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x3b, 0x76, 0x65, 0x65, 0x62, 0x72,
0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69,
0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x6b, 0x74, 0x3b,
0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x76, 0x65, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d,
0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x4a, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b,
0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b,
0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61,
0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a,
0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f,
0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x3b,
0x68, 0x65, 0x6c, 0x6d, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x3b, 0x74,
0x6f, 0x75, 0x6b, 0x6f, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x3b, 0x65, 0x6c, 0x6f, 0x3b,
0x73, 0x79, 0x79, 0x73, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x3b, 0x6a, 0x6f, 0x75,
0x6c, 0x75, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75,
0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x3b,
0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x69,
0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75, 0x75, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75,
0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6a,
0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75, 0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x4b, 0x3b,
0x48, 0x3b, 0x45, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x2e, 0x3b,
0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x2e, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x2e, 0x3b, 0x68, 0x75, 0x68,
0x74, 0x69, 0x6b, 0x2e, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x2e, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x2e, 0x3b,
0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x2e, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x2e, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x2e,
0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x2e, 0x3b, 0x6a, 0x6f, 0x75,
0x6c, 0x75, 0x6b, 0x2e, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x6c, 0x6d,
0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68,
0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75, 0x74, 0x61,
0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x74,
0x61, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61,
0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75,
0x74, 0x61, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b,
0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e,
0x76, 0x69, 0x65, 0x72, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x69, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x65, 0x74,
0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f,
0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0xe9, 0x63, 0x65, 0x6d, 0x62, 0x72,
0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61,
0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x2e, 0x3b,
0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e,
0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e,
0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x2e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e,
0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76,
0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x72, 0x74, 0x3b, 0x41,
0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53,
0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65,
0x77, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x77, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x61,
0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x61, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x79, 0x3b,
0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x69, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x44, 0x65, 0x73, 0x69, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x46, 0x61, 0x6f, 0x69, 0x3b, 0x47, 0x65, 0x61, 0x72, 0x72,
0x3b, 0x4d, 0xe0, 0x72, 0x74, 0x3b, 0x47, 0x69, 0x62, 0x6c, 0x3b, 0x43, 0xe8, 0x69, 0x74, 0x3b, 0xd2, 0x67, 0x6d, 0x68,
0x3b, 0x49, 0x75, 0x63, 0x68, 0x3b, 0x4c, 0xf9, 0x6e, 0x61, 0x3b, 0x53, 0x75, 0x6c, 0x74, 0x3b, 0x44, 0xe0, 0x6d, 0x68,
0x3b, 0x53, 0x61, 0x6d, 0x68, 0x3b, 0x44, 0xf9, 0x62, 0x68, 0x3b, 0x41, 0x6d, 0x20, 0x46, 0x61, 0x6f, 0x69, 0x6c, 0x6c,
0x65, 0x61, 0x63, 0x68, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b, 0x41, 0x6d, 0x20, 0x4d,
0xe0, 0x72, 0x74, 0x3b, 0x41, 0x6e, 0x20, 0x47, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x43, 0xe8,
0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0xd2, 0x67, 0x6d, 0x68, 0x69, 0x6f, 0x73, 0x3b, 0x41,
0x6e, 0x20, 0x74, 0x2d, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x4c, 0xf9, 0x6e, 0x61, 0x73, 0x74,
0x61, 0x6c, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c, 0x74, 0x61, 0x69, 0x6e, 0x3b, 0x41, 0x6e, 0x20, 0x44,
0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x41, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b,
0x41, 0x6e, 0x20, 0x44, 0xf9, 0x62, 0x68, 0x6c, 0x61, 0x63, 0x68, 0x64, 0x3b, 0x46, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x47,
0x3b, 0x43, 0x3b, 0xd2, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x64, 0x68, 0x65,
0x6e, 0x20, 0x46, 0x68, 0x61, 0x6f, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x63, 0x68, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x47,
0x68, 0x65, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x4d, 0x68, 0xe0, 0x72, 0x74, 0x3b, 0x64,
0x68, 0x65, 0x6e, 0x20, 0x47, 0x68, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x43, 0x68,
0xe8, 0x69, 0x74, 0x65, 0x61, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0xd2, 0x67, 0x6d, 0x68, 0x69, 0x6f, 0x73, 0x3b,
0x64, 0x68, 0x65, 0x6e, 0x20, 0x49, 0x75, 0x63, 0x68, 0x61, 0x72, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x4c, 0xf9, 0x6e,
0x61, 0x73, 0x74, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x2d, 0x53, 0x75, 0x6c, 0x74, 0x61, 0x69, 0x6e,
0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xe0, 0x6d, 0x68, 0x61, 0x69, 0x72, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x74,
0x2d, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b, 0x64, 0x68, 0x65, 0x6e, 0x20, 0x44, 0xf9, 0x62, 0x68, 0x6c, 0x61,
0x63, 0x68, 0x64, 0x3b, 0x58, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41,
0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c, 0x2e, 0x3b, 0x41,
0x67, 0x6f, 0x2e, 0x3b, 0x53, 0x65, 0x74, 0x2e, 0x3b, 0x4f, 0x75, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44,
0x65, 0x63, 0x2e, 0x3b, 0x58, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f,
0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x58, 0x75,
0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c, 0x6c, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72,
0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x78, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b,
0x78, 0x75, 0xf1, 0x6f, 0x3b, 0x78, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b,
0x6f, 0x75, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x78, 0x61, 0x6e, 0x65, 0x69,
0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x78, 0x75, 0xf1, 0x6f, 0x3b, 0x78, 0x75, 0x6c, 0x6c, 0x6f, 0x3b,
0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75, 0x74, 0x75,
0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72,
0x6f, 0x3b, 0x78, 0x2e, 0x3b, 0x66, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x61, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x78, 0x2e, 0x3b,
0x78, 0x2e, 0x3b, 0x61, 0x2e, 0x3b, 0x73, 0x2e, 0x3b, 0x6f, 0x2e, 0x3b, 0x6e, 0x2e, 0x3b, 0x64, 0x2e, 0x3b, 0x10d8, 0x10d0,
0x10dc, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x3b, 0x10db, 0x10d0, 0x10d8, 0x3b, 0x10d8, 0x10d5,
0x10dc, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x3b, 0x10dc, 0x10dd,
0x10d4, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x10d4, 0x10e0, 0x10d5,
0x10d0, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x10e2, 0x10d8, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x10d8, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10d8,
0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d0, 0x10d2, 0x10d5,
0x10d8, 0x10e1, 0x10e2, 0x10dd, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x10e2, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x10dd,
0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x10d4, 0x10db,
0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d7, 0x3b, 0x10db, 0x3b, 0x10d0, 0x3b, 0x10db, 0x3b, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d0,
0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10dc, 0x3b, 0x10d3, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72,
0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67,
0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72,
0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67,
0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65,
0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b,
0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53,
0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a,
0xe4, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e,
0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0xe4, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0xe4, 0x6e, 0x2e, 0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b,
0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e,
0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3ac, 0x3c1,
0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bb, 0x3b, 0x391,
0x3cd, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b, 0x399,
0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf,
0x3c2, 0x3b, 0x39c, 0x3ac, 0x3c1, 0x3c4, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3af, 0x3bb, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39c,
0x3ac, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bb, 0x3b9, 0x3bf, 0x3c2,
0x3b, 0x391, 0x3cd, 0x3b3, 0x3bf, 0x3c5, 0x3c3, 0x3c4, 0x3bf, 0x3c2, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9,
0x3bf, 0x3c2, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3ce, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9,
0x3bf, 0x3c2, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3b, 0x3a6, 0x3b, 0x39c, 0x3b,
0x391, 0x3b, 0x39c, 0x3b, 0x399, 0x3b, 0x399, 0x3b, 0x391, 0x3b, 0x3a3, 0x3b, 0x39f, 0x3b, 0x39d, 0x3b, 0x394, 0x3b, 0x399, 0x3b1,
0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3b1, 0x390, 0x3b, 0x399, 0x3bf,
0x3c5, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3b,
0x39d, 0x3bf, 0x3b5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x3a6,
0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3c4, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x391,
0x3c0, 0x3c1, 0x3b9, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x390, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bd, 0x3af, 0x3bf,
0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3bf, 0x3cd, 0x3c3, 0x3c4, 0x3bf, 0x3c5, 0x3b,
0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3c9, 0x3b2, 0x3c1, 0x3af, 0x3bf,
0x3c5, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af,
0x3bf, 0x3c5, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c,
0x69, 0x3b, 0x6d, 0x61, 0x6a, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67,
0x75, 0x73, 0x74, 0x75, 0x73, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x64, 0x65, 0x63,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1,
0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8,
0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91,
0xa95, 0xacd, 0xa9f, 0xacb, 0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1,
0xa86, 0xab0, 0xac0, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b,
0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b,
0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f,
0xacb, 0xaac, 0xab0, 0x3b, 0xaa8, 0xab5, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0,
0x3b, 0xa9c, 0xabe, 0x3b, 0xaab, 0xac7, 0x3b, 0xaae, 0xabe, 0x3b, 0xa8f, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0x3b, 0xa9c, 0xac1,
0x3b, 0xa91, 0x3b, 0xab8, 0x3b, 0xa91, 0x3b, 0xaa8, 0x3b, 0xaa1, 0xabf, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x61, 0x62, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x66, 0x69, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x75, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x75, 0x77, 0x3b, 0x44, 0x69, 0x73, 0x3b,
0x4a, 0x61, 0x6e, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x46, 0x61, 0x62, 0x75, 0x72, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x4d, 0x61,
0x72, 0x69, 0x73, 0x3b, 0x41, 0x66, 0x69, 0x72, 0x69, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e,
0x69, 0x3b, 0x59, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x74, 0x75, 0x6d, 0x62,
0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x75, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73,
0x61, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x41,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5f3, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5f3, 0x3b, 0x5de,
0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5f3, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc,
0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5f3, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5f3, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5f3, 0x3b, 0x5e0, 0x5d5, 0x5d1,
0x5f3, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5f3, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5e8, 0x3b,
0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9,
0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d0, 0x5d5,
0x5e7, 0x5d8, 0x5d5, 0x5d1, 0x5e8, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x91c,
0x928, 0x970, 0x3b, 0x92b, 0x93c, 0x930, 0x970, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932,
0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x970, 0x3b, 0x905, 0x917, 0x970, 0x3b, 0x938, 0x93f, 0x924,
0x970, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x970, 0x3b, 0x928, 0x935, 0x970, 0x3b, 0x926, 0x93f, 0x938, 0x970, 0x3b, 0x91c, 0x928,
0x935, 0x930, 0x940, 0x3b, 0x92b, 0x93c, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d,
0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938,
0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x902, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935,
0x902, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x93e, 0x3b, 0x905,
0x3b, 0x92e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f,
0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x2e, 0x3b, 0xe1, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x6a, 0x2e, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b, 0x61, 0x75,
0x67, 0x2e, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b,
0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73, 0x3b, 0xe1, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0xe1, 0x6a, 0x75,
0x73, 0x3b, 0x6a, 0xfa, 0x6e, 0x69, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6c, 0x69, 0x75, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x7a, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0xc1, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53,
0x7a, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61,
0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c,
0x2e, 0x3b, 0xe1, 0x67, 0xfa, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0xf3, 0x76,
0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0xfa, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0xfa, 0x61,
0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e,
0xed, 0x3b, 0x6a, 0xfa, 0x6c, 0xed, 0x3b, 0xe1, 0x67, 0xfa, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0xc1, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62,
0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c,
0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73,
0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61,
0x72, 0x65, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44,
0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x45, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x3b, 0x4d, 0xe1,
0x72, 0x74, 0x61, 0x3b, 0x41, 0x69, 0x62, 0x3b, 0x42, 0x65, 0x61, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x3b, 0x49,
0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa, 0x6e, 0x3b, 0x4d, 0x46, 0xf3, 0x6d, 0x68, 0x3b, 0x44, 0x46, 0xf3, 0x6d, 0x68, 0x3b,
0x53, 0x61, 0x6d, 0x68, 0x3b, 0x4e, 0x6f, 0x6c, 0x6c, 0x3b, 0x45, 0x61, 0x6e, 0xe1, 0x69, 0x72, 0x3b, 0x46, 0x65, 0x61,
0x62, 0x68, 0x72, 0x61, 0x3b, 0x4d, 0xe1, 0x72, 0x74, 0x61, 0x3b, 0x41, 0x69, 0x62, 0x72, 0x65, 0xe1, 0x6e, 0x3b, 0x42,
0x65, 0x61, 0x6c, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x74, 0x68, 0x65, 0x61, 0x6d, 0x68, 0x3b, 0x49,
0xfa, 0x69, 0x6c, 0x3b, 0x4c, 0xfa, 0x6e, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x65, 0xe1, 0x6e, 0x20, 0x46, 0xf3, 0x6d, 0x68,
0x61, 0x69, 0x72, 0x3b, 0x44, 0x65, 0x69, 0x72, 0x65, 0x61, 0x64, 0x68, 0x20, 0x46, 0xf3, 0x6d, 0x68, 0x61, 0x69, 0x72,
0x3b, 0x53, 0x61, 0x6d, 0x68, 0x61, 0x69, 0x6e, 0x3b, 0x4e, 0x6f, 0x6c, 0x6c, 0x61, 0x69, 0x67, 0x3b, 0x45, 0x3b, 0x46,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x42, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x4e,
0x3b, 0x67, 0x65, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x67,
0x3b, 0x67, 0x69, 0x75, 0x3b, 0x6c, 0x75, 0x67, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x74, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x67, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x66, 0x65, 0x62,
0x62, 0x72, 0x61, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x6d,
0x61, 0x67, 0x67, 0x69, 0x6f, 0x3b, 0x67, 0x69, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x6c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b,
0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x74, 0x74,
0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xc9c, 0xca8, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd,
0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2,
0xcc8, 0x3b, 0xc86, 0xc97, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0x3b, 0xca8,
0xcb5, 0xcc6, 0xc82, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0x3b, 0xc9c, 0xca8, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd,
0xcb0, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0xcb2, 0xccd, 0x3b,
0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b,
0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0xcac, 0xcb0, 0xccd, 0x3b,
0xca8, 0xcb5, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc9c, 0x3b, 0xcab,
0xcc6, 0x3b, 0xcae, 0xcbe, 0x3b, 0xc8f, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0x3b, 0xc9c, 0xcc1, 0x3b, 0xc86, 0x3b, 0xcb8, 0xcc6,
0x3b, 0xc85, 0x3b, 0xca8, 0x3b, 0xca1, 0xcbf, 0x3b, 0xc9c, 0xca8, 0xcb5, 0xcb0, 0xcbf, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5,
0xcb0, 0xcbf, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8f, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c,
0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0x3b, 0xcb8, 0xcc6, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0x3b,
0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0x3b, 0x62c, 0x646, 0x624,
0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x624, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x655, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644,
0x3b, 0x645, 0x6cc, 0x654, 0x3b, 0x62c, 0x648, 0x657, 0x646, 0x3b, 0x62c, 0x648, 0x657, 0x644, 0x627, 0x6cc, 0x6cc, 0x3b, 0x627, 0x6af,
0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x657, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645,
0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627, 0x3b, 0x645, 0x3b, 0x62c,
0x3b, 0x62c, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x49a, 0x430, 0x4a3, 0x2e, 0x3b, 0x410, 0x49b,
0x43f, 0x2e, 0x3b, 0x41d, 0x430, 0x443, 0x2e, 0x3b, 0x421, 0x4d9, 0x443, 0x2e, 0x3b, 0x41c, 0x430, 0x43c, 0x2e, 0x3b, 0x41c, 0x430,
0x443, 0x2e, 0x3b, 0x428, 0x456, 0x43b, 0x2e, 0x3b, 0x422, 0x430, 0x43c, 0x2e, 0x3b, 0x49a, 0x44b, 0x440, 0x2e, 0x3b, 0x49a, 0x430,
0x437, 0x2e, 0x3b, 0x49a, 0x430, 0x440, 0x2e, 0x3b, 0x416, 0x435, 0x43b, 0x2e, 0x3b, 0x49a, 0x430, 0x4a3, 0x442, 0x430, 0x440, 0x3b,
0x410, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x41d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b, 0x421, 0x4d9, 0x443, 0x456, 0x440, 0x3b, 0x41c,
0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x41c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x428, 0x456, 0x43b, 0x434, 0x435, 0x3b, 0x422, 0x430,
0x43c, 0x44b, 0x437, 0x3b, 0x49a, 0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x49a,
0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x416, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441, 0x430, 0x43d, 0x3b, 0x49a, 0x3b, 0x410, 0x3b,
0x41d, 0x3b, 0x421, 0x3b, 0x41c, 0x3b, 0x41c, 0x3b, 0x428, 0x3b, 0x422, 0x3b, 0x49a, 0x3b, 0x49a, 0x3b, 0x49a, 0x3b, 0x416, 0x3b,
0x49b, 0x430, 0x4a3, 0x2e, 0x3b, 0x430, 0x49b, 0x43f, 0x2e, 0x3b, 0x43d, 0x430, 0x443, 0x2e, 0x3b, 0x441, 0x4d9, 0x443, 0x2e, 0x3b,
0x43c, 0x430, 0x43c, 0x2e, 0x3b, 0x43c, 0x430, 0x443, 0x2e, 0x3b, 0x448, 0x456, 0x43b, 0x2e, 0x3b, 0x442, 0x430, 0x43c, 0x2e, 0x3b,
0x49b, 0x44b, 0x440, 0x2e, 0x3b, 0x49b, 0x430, 0x437, 0x2e, 0x3b, 0x49b, 0x430, 0x440, 0x2e, 0x3b, 0x436, 0x435, 0x43b, 0x2e, 0x3b,
0x49b, 0x430, 0x4a3, 0x442, 0x430, 0x440, 0x3b, 0x430, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x43d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b,
0x441, 0x4d9, 0x443, 0x456, 0x440, 0x3b, 0x43c, 0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x43c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x448,
0x456, 0x43b, 0x434, 0x435, 0x3b, 0x442, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49b, 0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b,
0x49b, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x49b, 0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441,
0x430, 0x43d, 0x3b, 0x6d, 0x75, 0x74, 0x2e, 0x3b, 0x67, 0x61, 0x73, 0x2e, 0x3b, 0x77, 0x65, 0x72, 0x2e, 0x3b, 0x6d, 0x61,
0x74, 0x2e, 0x3b, 0x67, 0x69, 0x63, 0x2e, 0x3b, 0x6b, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x79, 0x61, 0x2e, 0x3b, 0x6b, 0x61,
0x6e, 0x2e, 0x3b, 0x6e, 0x7a, 0x65, 0x2e, 0x3b, 0x75, 0x6b, 0x77, 0x2e, 0x3b, 0x75, 0x67, 0x75, 0x2e, 0x3b, 0x75, 0x6b,
0x75, 0x2e, 0x3b, 0x4d, 0x75, 0x74, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x47, 0x61, 0x73, 0x68, 0x79, 0x61, 0x6e, 0x74,
0x61, 0x72, 0x65, 0x3b, 0x57, 0x65, 0x72, 0x75, 0x72, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x74, 0x61, 0x3b, 0x47, 0x69, 0x63,
0x75, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x65, 0x6e, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e,
0x67, 0x61, 0x3b, 0x4b, 0x61, 0x6e, 0x61, 0x6d, 0x61, 0x3b, 0x4e, 0x7a, 0x65, 0x6c, 0x69, 0x3b, 0x55, 0x6b, 0x77, 0x61,
0x6b, 0x69, 0x72, 0x61, 0x3b, 0x55, 0x67, 0x75, 0x73, 0x68, 0x79, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x55, 0x6b, 0x75, 0x62,
0x6f, 0x7a, 0x61, 0x3b, 0x42f, 0x43d, 0x432, 0x3b, 0x424, 0x435, 0x432, 0x3b, 0x41c, 0x430, 0x440, 0x3b, 0x410, 0x43f, 0x440, 0x3b,
0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x3b, 0x421, 0x435, 0x43d, 0x3b,
0x41e, 0x43a, 0x442, 0x3b, 0x41d, 0x43e, 0x44f, 0x3b, 0x414, 0x435, 0x43a, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x424,
0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x41c,
0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b,
0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41d, 0x43e, 0x44f,
0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x42f, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x3b,
0x41c, 0x3b, 0x418, 0x3b, 0x418, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x41e, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x44f, 0x43d, 0x432, 0x2e,
0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b,
0x438, 0x44e, 0x43d, 0x2e, 0x3b, 0x438, 0x44e, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x2e, 0x3b,
0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440,
0x44c, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b,
0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b,
0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x31, 0xc6d4, 0x3b, 0x32, 0xc6d4,
0x3b, 0x33, 0xc6d4, 0x3b, 0x34, 0xc6d4, 0x3b, 0x35, 0xc6d4, 0x3b, 0x36, 0xc6d4, 0x3b, 0x37, 0xc6d4, 0x3b, 0x38, 0xc6d4, 0x3b, 0x39,
0xc6d4, 0x3b, 0x31, 0x30, 0xc6d4, 0x3b, 0x31, 0x31, 0xc6d4, 0x3b, 0x31, 0x32, 0xc6d4, 0x3b, 0x4d, 0x75, 0x74, 0x2e, 0x3b, 0x47,
0x61, 0x73, 0x2e, 0x3b, 0x57, 0x65, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x74, 0x2e, 0x3b, 0x47, 0x69, 0x63, 0x2e, 0x3b, 0x4b,
0x61, 0x6d, 0x2e, 0x3b, 0x4e, 0x79, 0x61, 0x2e, 0x3b, 0x4b, 0x61, 0x6e, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x2e, 0x3b, 0x55,
0x6b, 0x77, 0x2e, 0x3b, 0x55, 0x67, 0x75, 0x2e, 0x3b, 0x55, 0x6b, 0x75, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x72, 0x6f, 0x3b,
0x52, 0x75, 0x68, 0x75, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x74, 0x77, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x3b, 0x4e,
0x64, 0x61, 0x6d, 0x75, 0x6b, 0x69, 0x7a, 0x61, 0x3b, 0x52, 0x75, 0x73, 0x61, 0x6d, 0x61, 0x3b, 0x52, 0x75, 0x68, 0x65,
0x73, 0x68, 0x69, 0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x6b, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6e, 0x64, 0x61, 0x67,
0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x47, 0x69, 0x74, 0x75, 0x67, 0x75, 0x74,
0x75, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x6f, 0x6e, 0x79, 0x6f, 0x3b, 0x4b, 0x69, 0x67, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b,
0xea1, 0x2e, 0xe81, 0x2e, 0x3b, 0xe81, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0x2e, 0xe99, 0x2e, 0x3b, 0xea1, 0x2e, 0xeaa, 0x2e, 0x3b,
0xe9e, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb4, 0x2e, 0xe96, 0x2e, 0x3b, 0xe81, 0x2e, 0xea5, 0x2e, 0x3b, 0xeaa, 0x2e, 0xeab, 0x2e,
0x3b, 0xe81, 0x2e, 0xe8d, 0x2e, 0x3b, 0xe95, 0x2e, 0xea5, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe88, 0x2e, 0x3b, 0xe97, 0x2e, 0xea7, 0x2e,
0x3b, 0xea1, 0xeb1, 0xe87, 0xe81, 0xead, 0xe99, 0x3b, 0xe81, 0xeb8, 0xea1, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb5, 0xe99, 0xeb2, 0x3b, 0xec0,
0xea1, 0xeaa, 0xeb2, 0x3b, 0xe9e, 0xeb6, 0xe94, 0xeaa, 0xeb0, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb4, 0xe96, 0xeb8, 0xe99, 0xeb2, 0x3b, 0xe81,
0xecd, 0xea5, 0xeb0, 0xe81, 0xebb, 0xe94, 0x3b, 0xeaa, 0xeb4, 0xe87, 0xeab, 0xeb2, 0x3b, 0xe81, 0xeb1, 0xe99, 0xe8d, 0xeb2, 0x3b, 0xe95,
0xeb8, 0xea5, 0xeb2, 0x3b, 0xe9e, 0xeb0, 0xe88, 0xeb4, 0xe81, 0x3b, 0xe97, 0xeb1, 0xe99, 0xea7, 0xeb2, 0x3b, 0x6a, 0x61, 0x6e, 0x76,
0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d,
0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x2e, 0x3b, 0x6a, 0x16b, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e,
0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x101, 0x72, 0x69, 0x73, 0x3b,
0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x12b, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b,
0x6a, 0x16b, 0x6e, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6c, 0x69, 0x6a, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74,
0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x69,
0x73, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69,
0x73, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x6c, 0x3b, 0x6d, 0x61,
0x69, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x74, 0x3b, 0x73, 0x74, 0x62, 0x3b, 0x254, 0x74,
0x62, 0x3b, 0x6e, 0x76, 0x62, 0x3b, 0x64, 0x73, 0x62, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x79,
0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9,
0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x73, 0xe1, 0x6e,
0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0x65, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61,
0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x6f, 0x74,
0xf3, 0x62, 0xe1, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6e, 0x73, 0x61, 0x6d, 0x62, 0x6f, 0x3b,
0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x77, 0x61, 0x6d, 0x62, 0x65, 0x3b, 0x73, 0xe1, 0x6e, 0x7a,
0xe1, 0x20, 0x79, 0x61, 0x20, 0x6c, 0x69, 0x62, 0x77, 0x61, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20,
0x7a, 0xf3, 0x6d, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e,
0x61, 0x20, 0x6d, 0x254, 0x30c, 0x6b, 0x254, 0x301, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61,
0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x254, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x73, 0x61, 0x75,
0x73, 0x2e, 0x3b, 0x76, 0x61, 0x73, 0x2e, 0x3b, 0x6b, 0x6f, 0x76, 0x2e, 0x3b, 0x62, 0x61, 0x6c, 0x2e, 0x3b, 0x67, 0x65,
0x67, 0x2e, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x2e, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x2e, 0x3b, 0x72, 0x75, 0x67, 0x70, 0x2e,
0x3b, 0x72, 0x75, 0x67, 0x73, 0x2e, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x2e, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x2e, 0x3b,
0x67, 0x72, 0x75, 0x6f, 0x64, 0x2e, 0x3b, 0x73, 0x61, 0x75, 0x73, 0x69, 0x73, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69,
0x73, 0x3b, 0x6b, 0x6f, 0x76, 0x61, 0x73, 0x3b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x3b, 0x67, 0x65, 0x67,
0x75, 0x17e, 0x117, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x61, 0x3b, 0x72,
0x75, 0x67, 0x70, 0x6a, 0x16b, 0x74, 0x69, 0x73, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x69, 0x73, 0x3b, 0x73, 0x70,
0x61, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x69, 0x74, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x6f, 0x64,
0x69, 0x73, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x42, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x52, 0x3b, 0x52,
0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x47, 0x3b, 0x73, 0x61, 0x75, 0x73, 0x69, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0x61, 0x72, 0x69,
0x6f, 0x3b, 0x6b, 0x6f, 0x76, 0x6f, 0x3b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x67, 0x65, 0x67,
0x75, 0x17e, 0x117, 0x73, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65, 0x6c, 0x69, 0x6f, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x6f, 0x73,
0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x10d, 0x69, 0x6f, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x6f, 0x3b, 0x73,
0x70, 0x61, 0x6c, 0x69, 0x6f, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x69, 0x10d, 0x69, 0x6f, 0x3b, 0x67, 0x72, 0x75, 0x6f,
0x64, 0x17e, 0x69, 0x6f, 0x3b, 0x458, 0x430, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b,
0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x2e, 0x3b, 0x458, 0x443, 0x43b, 0x2e, 0x3b, 0x430,
0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e,
0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430,
0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443,
0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435,
0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440,
0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x458, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c,
0x3b, 0x458, 0x3b, 0x458, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e, 0x3b, 0x4a,
0x6f, 0x6c, 0x3b, 0x41, 0x6f, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44,
0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x6f, 0x61, 0x72, 0x79, 0x3b,
0x4d, 0x61, 0x72, 0x74, 0x73, 0x61, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f,
0x6e, 0x61, 0x3b, 0x4a, 0x6f, 0x6c, 0x61, 0x79, 0x3b, 0x41, 0x6f, 0x67, 0x6f, 0x73, 0x69, 0x74, 0x72, 0x61, 0x3b, 0x53,
0x65, 0x70, 0x74, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x4e, 0x6f, 0x76,
0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44,
0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b,
0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xd1c, 0xd28, 0xd41, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0x3b,
0xd2e, 0xd3e, 0xd7c, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c,
0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f,
0xd4b, 0x3b, 0xd28, 0xd35, 0xd02, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0x3b, 0xd1c, 0xd28, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2b, 0xd46,
0xd2c, 0xd4d, 0xd30, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2e, 0xd3e, 0xd7c, 0xd1a, 0xd4d, 0xd1a, 0xd4d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30,
0xd3f, 0xd7d, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0xd38,
0xd4d, 0xd31, 0xd4d, 0xd31, 0xd4d, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd12, 0xd15, 0xd4d,
0x200c, 0xd1f, 0xd4b, 0xd2c, 0xd7c, 0x3b, 0xd28, 0xd35, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0xd2c, 0xd7c, 0x3b, 0xd1c,
0x3b, 0xd2b, 0xd46, 0x3b, 0xd2e, 0xd3e, 0x3b, 0xd0f, 0x3b, 0xd2e, 0xd46, 0x3b, 0xd1c, 0xd42, 0xd7a, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd13,
0x3b, 0xd38, 0xd46, 0x3b, 0xd12, 0x3b, 0xd28, 0x3b, 0xd21, 0xd3f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x72, 0x61, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x6a, 0x3b, 0x120, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x6c, 0x3b, 0x41,
0x77, 0x77, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x10b, 0x3b, 0x4a,
0x61, 0x6e, 0x6e, 0x61, 0x72, 0x3b, 0x46, 0x72, 0x61, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x41, 0x70, 0x72,
0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x6a, 0x6a, 0x75, 0x3b, 0x120, 0x75, 0x6e, 0x6a, 0x75, 0x3b, 0x4c, 0x75, 0x6c, 0x6a, 0x75,
0x3b, 0x41, 0x77, 0x77, 0x69, 0x73, 0x73, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4f,
0x74, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x10b, 0x65,
0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x6e, 0x3b, 0x46, 0x72, 0x3b, 0x4d, 0x7a, 0x3b, 0x41, 0x70, 0x3b, 0x4d, 0x6a, 0x3b,
0x120, 0x6e, 0x3b, 0x4c, 0x6a, 0x3b, 0x41, 0x77, 0x3b, 0x53, 0x74, 0x3b, 0x4f, 0x62, 0x3b, 0x4e, 0x76, 0x3b, 0x44, 0x10b,
0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x120, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x3b, 0x92e, 0x93e, 0x930,
0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948,
0x3b, 0x911, 0x917, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x935,
0x94d, 0x939, 0x947, 0x902, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b,
0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d,
0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x938, 0x94d,
0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928,
0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x93e, 0x3b,
0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x911, 0x3b, 0x938,
0x3b, 0x911, 0x3b, 0x928, 0x94b, 0x3b, 0x921, 0x93f, 0x3b, 0x31, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x32, 0x2d, 0x440,
0x20, 0x441, 0x430, 0x440, 0x3b, 0x33, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x34, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440,
0x3b, 0x35, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x36, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x37, 0x2d, 0x440,
0x20, 0x441, 0x430, 0x440, 0x3b, 0x38, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x39, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440,
0x3b, 0x31, 0x30, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31, 0x31, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x31,
0x32, 0x2d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x41d, 0x44d, 0x433, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x425, 0x43e, 0x451, 0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x413, 0x443, 0x440,
0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x414, 0x4e9, 0x440, 0x4e9, 0x432, 0x434, 0x4af,
0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x422, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441,
0x430, 0x440, 0x3b, 0x417, 0x443, 0x440, 0x433, 0x430, 0x430, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b,
0x414, 0x43e, 0x43b, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x41d, 0x430, 0x439, 0x43c, 0x434, 0x443,
0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x415, 0x441, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430,
0x440, 0x3b, 0x410, 0x440, 0x430, 0x432, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432,
0x430, 0x43d, 0x20, 0x43d, 0x44d, 0x433, 0x434, 0x4af, 0x433, 0x44d, 0x44d, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x410, 0x440, 0x432,
0x430, 0x43d, 0x20, 0x445, 0x43e, 0x451, 0x440, 0x434, 0x443, 0x433, 0x430, 0x430, 0x440, 0x20, 0x441, 0x430, 0x440, 0x3b, 0x49, 0x3b,
0x49, 0x49, 0x3b, 0x49, 0x49, 0x49, 0x3b, 0x49, 0x56, 0x3b, 0x56, 0x3b, 0x56, 0x49, 0x3b, 0x56, 0x49, 0x49, 0x3b, 0x56,
0x49, 0x49, 0x49, 0x3b, 0x49, 0x58, 0x3b, 0x58, 0x3b, 0x58, 0x49, 0x3b, 0x58, 0x49, 0x49, 0x3b, 0x91c, 0x928, 0x935, 0x930,
0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x905, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a,
0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917,
0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b,
0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930,
0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x947, 0x92c, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x3b,
0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x3b, 0x905, 0x915,
0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x92c,
0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c,
0x941, 0x932, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x92d, 0x947,
0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69,
0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xb1c, 0xb3e, 0xb28, 0xb41, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2b, 0xb47, 0xb2c,
0xb43, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2e, 0xb3e, 0xb30, 0xb4d, 0xb1a, 0xb4d, 0xb1a, 0x3b, 0xb05, 0xb2a, 0xb4d, 0xb30, 0xb47, 0xb32, 0x3b,
0xb2e, 0xb07, 0x3b, 0xb1c, 0xb41, 0xb28, 0x3b, 0xb1c, 0xb41, 0xb32, 0xb3e, 0xb07, 0x3b, 0xb05, 0xb17, 0xb37, 0xb4d, 0xb1f, 0x3b, 0xb38,
0xb47, 0xb2a, 0xb4d, 0xb1f, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb05, 0xb15, 0xb4d, 0xb1f, 0xb4b, 0xb2c, 0xb30, 0x3b, 0xb28, 0xb2d,
0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb21, 0xb3f, 0xb38, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb1c, 0xb3e, 0x3b, 0xb2b, 0xb47,
0x3b, 0xb2e, 0xb3e, 0x3b, 0xb05, 0x3b, 0xb2e, 0xb07, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb05, 0x3b, 0xb38, 0xb47, 0x3b,
0xb05, 0x3b, 0xb28, 0x3b, 0xb21, 0xb3f, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b,
0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cd, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648,
0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648,
0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a,
0x3b, 0x641, 0x6d0, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b,
0x645, 0x6cd, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e,
0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633,
0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631,
0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cd, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc,
0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631,
0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627,
0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x698, 0x627, 0x646,
0x648, 0x6cc, 0x647, 0x3b, 0x641, 0x648, 0x631, 0x6cc, 0x647, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644,
0x3b, 0x645, 0x647, 0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633,
0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b,
0x62f, 0x633, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x645, 0x3b, 0x698, 0x3b, 0x698,
0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc, 0x647, 0x654, 0x3b, 0x641,
0x648, 0x631, 0x6cc, 0x647, 0x654, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x647, 0x654,
0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x654, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633,
0x627, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627,
0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627,
0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631,
0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631,
0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648,
0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9,
0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c,
0x75, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6b, 0x77, 0x69, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x3b, 0x6c,
0x69, 0x70, 0x3b, 0x73, 0x69, 0x65, 0x3b, 0x77, 0x72, 0x7a, 0x3b, 0x70, 0x61, 0x17a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67,
0x72, 0x75, 0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x65, 0x144, 0x3b, 0x6c, 0x75, 0x74, 0x79, 0x3b, 0x6d, 0x61, 0x72, 0x7a,
0x65, 0x63, 0x3b, 0x6b, 0x77, 0x69, 0x65, 0x63, 0x69, 0x65, 0x144, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x72,
0x77, 0x69, 0x65, 0x63, 0x3b, 0x6c, 0x69, 0x70, 0x69, 0x65, 0x63, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x69, 0x65, 0x144,
0x3b, 0x77, 0x72, 0x7a, 0x65, 0x73, 0x69, 0x65, 0x144, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69,
0x6b, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x7a, 0x69, 0x65, 0x144, 0x3b,
0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x57, 0x3b, 0x50, 0x3b,
0x4c, 0x3b, 0x47, 0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x6e, 0x69, 0x61, 0x3b, 0x6c, 0x75, 0x74, 0x65, 0x67, 0x6f, 0x3b,
0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x6b, 0x77, 0x69, 0x65, 0x74, 0x6e, 0x69, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b,
0x63, 0x7a, 0x65, 0x72, 0x77, 0x63, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x63, 0x61, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x6e,
0x69, 0x61, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x15b, 0x6e, 0x69, 0x61, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72,
0x6e, 0x69, 0x6b, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x61, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x6e,
0x69, 0x61, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x63, 0x3b, 0x6c, 0x3b, 0x73, 0x3b, 0x77,
0x3b, 0x70, 0x3b, 0x6c, 0x3b, 0x67, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73,
0x65, 0x74, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x7a, 0x3b, 0x6a, 0x61, 0x6e, 0x65, 0x69,
0x72, 0x6f, 0x3b, 0x66, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x61,
0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x68,
0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75,
0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x64, 0x65, 0x7a, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0xa1c, 0xa28, 0x3b, 0xa2b, 0xa3c, 0xa30, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30,
0xa48, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0x3b, 0xa05, 0xa17, 0x3b, 0xa38, 0xa24, 0xa70,
0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0x3b, 0xa28, 0xa35, 0xa70, 0x3b, 0xa26, 0xa38, 0xa70, 0x3b, 0xa1c, 0xa28, 0xa35, 0xa30, 0xa40, 0x3b,
0xa2b, 0xa3c, 0xa30, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0xa32, 0x3b, 0xa2e,
0xa08, 0x3b, 0xa1c, 0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0xa08, 0x3b, 0xa05, 0xa17, 0xa38, 0xa24, 0x3b, 0xa38, 0xa24, 0xa70,
0xa2c, 0xa30, 0x3b, 0xa05, 0xa15, 0xa24, 0xa42, 0xa2c, 0xa30, 0x3b, 0xa28, 0xa35, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa26, 0xa38, 0xa70, 0xa2c,
0xa30, 0x3b, 0xa1c, 0x3b, 0xa2b, 0xa3c, 0x3b, 0xa2e, 0xa3e, 0x3b, 0xa05, 0x3b, 0xa2e, 0x3b, 0xa1c, 0xa42, 0x3b, 0xa1c, 0xa41, 0x3b,
0xa05, 0x3b, 0xa38, 0x3b, 0xa05, 0x3b, 0xa28, 0x3b, 0xa26, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631,
0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648, 0x646, 0x3b,
0x62c, 0x648, 0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9,
0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x45, 0x6e, 0x65,
0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x63, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x69, 0x63, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d,
0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x69,
0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x67,
0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x2e, 0x3b, 0x66, 0x61, 0x6e, 0x2e, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x74, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b,
0x73, 0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b,
0x61, 0x76, 0x72, 0x69, 0x67, 0x6c, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x61, 0x64, 0x75,
0x72, 0x3b, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x69, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x69, 0x75, 0x6e, 0x2e, 0x3b, 0x69, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e,
0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x69, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69,
0x65, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69, 0x75, 0x6e, 0x69, 0x65, 0x3b,
0x69, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x72, 0x69, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6e, 0x6f, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x69, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x44f, 0x43d,
0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c,
0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435,
0x43d, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b,
0x44f, 0x43d, 0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e,
0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x2e, 0x3b, 0x438, 0x44e, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b,
0x441, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a,
0x2e, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44f, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x430, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d, 0x44f, 0x3b, 0x438,
0x44e, 0x43b, 0x44f, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44f,
0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x434, 0x435, 0x43a, 0x430,
0x431, 0x440, 0x44f, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4d, 0x62, 0xe4, 0x3b, 0x4e, 0x67, 0x75, 0x3b,
0x42, 0xea, 0x6c, 0x3b, 0x46, 0xf6, 0x6e, 0x3b, 0x4c, 0x65, 0x6e, 0x3b, 0x4b, 0xfc, 0x6b, 0x3b, 0x4d, 0x76, 0x75, 0x3b,
0x4e, 0x67, 0x62, 0x3b, 0x4e, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6b, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x65, 0x3b, 0x46,
0x75, 0x6c, 0x75, 0x6e, 0x64, 0xef, 0x67, 0x69, 0x3b, 0x4d, 0x62, 0xe4, 0x6e, 0x67, 0xfc, 0x3b, 0x4e, 0x67, 0x75, 0x62,
0xf9, 0x65, 0x3b, 0x42, 0xea, 0x6c, 0xe4, 0x77, 0xfc, 0x3b, 0x46, 0xf6, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x65, 0x6e, 0x67,
0x75, 0x61, 0x3b, 0x4b, 0xfc, 0x6b, 0xfc, 0x72, 0xfc, 0x3b, 0x4d, 0x76, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x67, 0x62, 0x65,
0x72, 0x65, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x62, 0xe4, 0x6e, 0x64, 0xfc, 0x72, 0x75, 0x3b, 0x4b, 0x61, 0x6b, 0x61, 0x75,
0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4d,
0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430,
0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441,
0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430,
0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b,
0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b,
0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e,
0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x6a, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f,
0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b,
0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a, 0x3b, 0x66, 0x3b, 0x6d,
0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x458, 0x430, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x431, 0x2e, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430,
0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x432, 0x2e, 0x3b,
0x434, 0x435, 0x446, 0x2e, 0x3b, 0x42f, 0x43d, 0x432, 0x2e, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x41c, 0x430, 0x440, 0x442,
0x2e, 0x3b, 0x410, 0x43f, 0x440, 0x2e, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c,
0x3b, 0x410, 0x432, 0x433, 0x2e, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x41e, 0x43a, 0x442, 0x2e, 0x3b, 0x41d, 0x43e, 0x44f,
0x431, 0x2e, 0x3b, 0x414, 0x435, 0x43a, 0x2e, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430,
0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x44a, 0x438, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x439,
0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435,
0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440,
0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0x44f, 0x43d, 0x432, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b,
0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x44b, 0x3b, 0x438, 0x44e, 0x43d, 0x44b, 0x3b,
0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b,
0x43d, 0x43e, 0x44f, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44b, 0x3b, 0x444, 0x435, 0x432,
0x440, 0x430, 0x43b, 0x44b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x44a, 0x438, 0x439, 0x44b, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44b,
0x3b, 0x43c, 0x430, 0x439, 0x44b, 0x3b, 0x438, 0x44e, 0x43d, 0x44b, 0x3b, 0x438, 0x44e, 0x43b, 0x44b, 0x3b, 0x430, 0x432, 0x433, 0x443,
0x441, 0x442, 0x44b, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44b,
0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44b, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44b, 0x3b, 0x4e, 0x64, 0x69, 0x3b,
0x4b, 0x75, 0x6b, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x4b, 0x75, 0x62, 0x3b, 0x43, 0x68, 0x76, 0x3b, 0x43, 0x68, 0x6b, 0x3b,
0x43, 0x68, 0x67, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x47, 0x75, 0x6e, 0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x4d, 0x62, 0x75, 0x3b,
0x5a, 0x76, 0x69, 0x3b, 0x4e, 0x64, 0x69, 0x72, 0x61, 0x3b, 0x4b, 0x75, 0x6b, 0x61, 0x64, 0x7a, 0x69, 0x3b, 0x4b, 0x75,
0x72, 0x75, 0x6d, 0x65, 0x3b, 0x4b, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x76, 0x61, 0x62,
0x76, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6e, 0x67, 0x75, 0x72,
0x75, 0x3b, 0x4e, 0x79, 0x61, 0x6d, 0x61, 0x76, 0x68, 0x75, 0x76, 0x68, 0x75, 0x3b, 0x47, 0x75, 0x6e, 0x79, 0x61, 0x6e,
0x61, 0x3b, 0x47, 0x75, 0x6d, 0x69, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4d, 0x62, 0x75, 0x64, 0x7a, 0x69, 0x3b, 0x5a, 0x76,
0x69, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4e, 0x3b,
0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x64a, 0x628, 0x631, 0x648, 0x631,
0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x626, 0x64a, 0x3b, 0x62c, 0x648, 0x646,
0x3b, 0x62c, 0x648, 0x644, 0x627, 0x621, 0x650, 0x3b, 0x622, 0x6af, 0x633, 0x67d, 0x3b, 0x633, 0x64a, 0x67e, 0x67d, 0x645, 0x628, 0x631,
0x3b, 0x622, 0x6aa, 0x67d, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x68a, 0x633, 0x645, 0x628, 0x631, 0x3b,
0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca,
0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b,
0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0xda2,
0xdb1, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0xdbb, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad,
0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2,
0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0xdc3, 0xdca, 0xdad, 0xdd4, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0xdad, 0xdd0,
0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0xdad, 0xddd, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0xdb8,
0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xda2, 0x3b, 0xdb4, 0xdd9, 0x3b,
0xdb8, 0xdcf, 0x3b, 0xd85, 0x3b, 0xdb8, 0xdd0, 0x3b, 0xda2, 0xdd6, 0x3b, 0xda2, 0xdd6, 0x3b, 0xd85, 0x3b, 0xdc3, 0xdd0, 0x3b, 0xd94,
0x3b, 0xdb1, 0xdd9, 0x3b, 0xdaf, 0xdd9, 0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4,
0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b,
0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc,
0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b,
0x61, 0x70, 0x72, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b,
0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75,
0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70, 0x72,
0xed, 0x6c, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b,
0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0xe1, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61,
0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x61, 0x3b, 0x6d, 0xe1, 0x6a, 0x61, 0x3b, 0x6a, 0xfa, 0x6e, 0x61, 0x3b, 0x6a, 0xfa,
0x6c, 0x61, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61,
0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65,
0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72,
0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e,
0x3b, 0x61, 0x76, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e,
0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e,
0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4b, 0x6f, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b,
0x53, 0x61, 0x64, 0x3b, 0x41, 0x66, 0x72, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x4c, 0x69, 0x78, 0x3b, 0x54, 0x6f, 0x64, 0x3b,
0x53, 0x69, 0x64, 0x3b, 0x53, 0x61, 0x67, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x4b, 0x49, 0x54, 0x3b, 0x4c, 0x49, 0x54, 0x3b,
0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20,
0x4c, 0x61, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x64, 0x64, 0x65, 0x78, 0x61,
0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x41, 0x66, 0x72, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68,
0x61, 0x20, 0x53, 0x68, 0x61, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x69, 0x78, 0x61,
0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x64, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69,
0x73, 0x68, 0x61, 0x20, 0x53, 0x69, 0x64, 0x65, 0x65, 0x64, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20,
0x53, 0x61, 0x67, 0x61, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x62, 0x6e,
0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x77, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f,
0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x20, 0x69, 0x79, 0x6f,
0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4c,
0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x65, 0x6e, 0x65, 0x2e, 0x3b, 0x66, 0x65,
0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79, 0x2e, 0x3b, 0x6a, 0x75,
0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f,
0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x3b,
0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b,
0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f,
0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x65, 0x6e, 0x65, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72,
0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c,
0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76,
0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b, 0x65, 0x6e, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73,
0x65, 0x70, 0x3b, 0x6f, 0x63, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x45, 0x6e, 0x65, 0x2e, 0x3b,
0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x79, 0x2e, 0x3b,
0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x41, 0x67, 0x6f, 0x2e, 0x3b, 0x53, 0x65, 0x74, 0x2e, 0x3b,
0x4f, 0x63, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x69, 0x63, 0x2e, 0x3b, 0x65, 0x6e, 0x65, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x79, 0x2e, 0x3b,
0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x6f, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b,
0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x69, 0x63, 0x2e, 0x3b, 0x65, 0x6e, 0x65, 0x72, 0x6f,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73,
0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f,
0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65,
0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x42f, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f,
0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41d, 0x43e,
0x44f, 0x431, 0x440, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0xb9c, 0xba9, 0x2e, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0x2e,
0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b,
0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xb85, 0xb95, 0xbcd, 0x2e, 0x3b,
0xba8, 0xbb5, 0x2e, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0x2e, 0x3b, 0xb9c, 0xba9, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0xbb0,
0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0xb9a, 0xbcd, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b, 0xbae, 0xbc7,
0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbcd, 0x3b, 0xb9a, 0xbc6,
0xbaa, 0xbcd, 0xb9f, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xb95, 0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xba8, 0xbb5,
0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9c, 0x3b, 0xbaa, 0xbbf, 0x3b,
0xbae, 0xbbe, 0x3b, 0xb8f, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb86, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xb85,
0x3b, 0xba8, 0x3b, 0xb9f, 0xbbf, 0x3b, 0x433, 0x44b, 0x439, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440,
0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c,
0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x44f,
0x431, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b, 0x433, 0x44b, 0x439, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440,
0x430, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x43c, 0x430, 0x439, 0x3b,
0x438, 0x44e, 0x43d, 0x44c, 0x3b, 0x438, 0x44e, 0x43b, 0x44c, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d,
0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44c,
0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b, 0xc1c, 0xc28, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e,
0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c,
0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b,
0x3b, 0xc28, 0xc35, 0xc02, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0x3b, 0xc1c, 0xc28, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2b, 0xc3f, 0xc2c,
0xc4d, 0xc30, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0xc32, 0xc4d,
0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc41, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41,
0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c, 0xc30, 0xc4d,
0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c, 0x3b, 0xc2b,
0xc3f, 0x3b, 0xc2e, 0xc3e, 0x3b, 0xc0f, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0x3b, 0xc1c, 0xc41, 0x3b, 0xc06, 0x3b, 0xc38, 0xc46,
0x3b, 0xc05, 0x3b, 0xc28, 0x3b, 0xc21, 0xc3f, 0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe1e, 0x2e, 0x3b, 0xe21, 0xe35,
0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21, 0x2e, 0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe34, 0x2e, 0xe22, 0x2e,
0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b, 0xe2a, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe22, 0x2e, 0x3b, 0xe15, 0x2e, 0xe04, 0x2e,
0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b, 0xe18, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe01, 0xe23, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe38,
0xe21, 0xe20, 0xe32, 0xe1e, 0xe31, 0xe19, 0xe18, 0xe4c, 0x3b, 0xe21, 0xe35, 0xe19, 0xe32, 0xe04, 0xe21, 0x3b, 0xe40, 0xe21, 0xe29, 0xe32,
0xe22, 0xe19, 0x3b, 0xe1e, 0xe24, 0xe29, 0xe20, 0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0xe34, 0xe16, 0xe38, 0xe19, 0xe32, 0xe22, 0xe19, 0x3b,
0xe01, 0xe23, 0xe01, 0xe0e, 0xe32, 0xe04, 0xe21, 0x3b, 0xe2a, 0xe34, 0xe07, 0xe2b, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe31, 0xe19, 0xe22,
0xe32, 0xe22, 0xe19, 0x3b, 0xe15, 0xe38, 0xe25, 0xe32, 0xe04, 0xe21, 0x3b, 0xe1e, 0xe24, 0xe28, 0xe08, 0xe34, 0xe01, 0xe32, 0xe22, 0xe19,
0x3b, 0xe18, 0xe31, 0xe19, 0xe27, 0xe32, 0xe04, 0xe21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0xf0b,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42,
0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56,
0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b,
0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58,
0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63,
0xf94, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74,
0xf0b, 0xf54, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab,
0x3b, 0x1218, 0x130b, 0x3b, 0x121a, 0x12eb, 0x3b, 0x130d, 0x1295, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x3b, 0x1290, 0x1213, 0x3b, 0x1218,
0x1235, 0x3b, 0x1325, 0x1245, 0x3b, 0x1215, 0x12f3, 0x3b, 0x1273, 0x1215, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272, 0x1275, 0x3b, 0x1218,
0x130b, 0x1262, 0x1275, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x12eb, 0x3b, 0x130d, 0x1295, 0x1266, 0x1275, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x1208,
0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x1228, 0x121d, 0x3b, 0x1325, 0x1245, 0x121d, 0x1272, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b,
0x1273, 0x1215, 0x1233, 0x1235, 0x3b, 0x1325, 0x3b, 0x1208, 0x3b, 0x1218, 0x3b, 0x121a, 0x3b, 0x130d, 0x3b, 0x1230, 0x3b, 0x1213, 0x3b, 0x1290,
0x3b, 0x1218, 0x3b, 0x1325, 0x3b, 0x1215, 0x3b, 0x1273, 0x3b, 0x53, 0x101, 0x6e, 0x3b, 0x46, 0x113, 0x70, 0x3b, 0x4d, 0x61, 0x2bb,
0x61, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x53, 0x69, 0x75, 0x3b, 0x2bb, 0x41,
0x6f, 0x6b, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x3b, 0x4e, 0x14d, 0x76, 0x3b, 0x54, 0x12b, 0x73, 0x3b,
0x53, 0x101, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x113, 0x70, 0x75, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x2bb, 0x61,
0x73, 0x69, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x6c, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x65, 0x3b,
0x53, 0x69, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x69, 0x74,
0x65, 0x6d, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x14d, 0x76, 0x65, 0x6d, 0x61, 0x3b,
0x54, 0x12b, 0x73, 0x65, 0x6d, 0x61, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53,
0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4f, 0x63, 0x61, 0x3b, 0x15e, 0x75, 0x62, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x4e, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x61, 0x7a, 0x3b, 0x54, 0x65, 0x6d, 0x3b, 0x41,
0x11f, 0x75, 0x3b, 0x45, 0x79, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x4f,
0x63, 0x61, 0x6b, 0x3b, 0x15e, 0x75, 0x62, 0x61, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x4e, 0x69, 0x73, 0x61, 0x6e,
0x3b, 0x4d, 0x61, 0x79, 0x131, 0x73, 0x3b, 0x48, 0x61, 0x7a, 0x69, 0x72, 0x61, 0x6e, 0x3b, 0x54, 0x65, 0x6d, 0x6d, 0x75,
0x7a, 0x3b, 0x41, 0x11f, 0x75, 0x73, 0x74, 0x6f, 0x73, 0x3b, 0x45, 0x79, 0x6c, 0xfc, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x6d,
0x3b, 0x4b, 0x61, 0x73, 0x131, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6c, 0x131, 0x6b, 0x3b, 0x4f, 0x3b, 0x15e, 0x3b, 0x4d, 0x3b,
0x4e, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x41, 0x3b, 0xdd, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x77, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0xfd, 0x3b, 0x49,
0xfd, 0x75, 0x6e, 0x3b, 0x49, 0xfd, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0xfd, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0xdd, 0x61, 0x6e, 0x77, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x77, 0x72,
0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0xfd, 0x3b, 0x49, 0xfd,
0x75, 0x6e, 0x3b, 0x49, 0xfd, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0xfd,
0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x44,
0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0xdd, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b,
0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xfd, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x77, 0x3b, 0x6d, 0x61,
0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0xfd, 0x3b, 0x69, 0xfd, 0x75, 0x6e, 0x3b, 0x69, 0xfd, 0x75, 0x6c,
0x3b, 0x61, 0x77, 0x67, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0xfd, 0x3b, 0x64, 0x65, 0x6b,
0x3b, 0xfd, 0x61, 0x6e, 0x77, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x77, 0x72, 0x61, 0x6c, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b,
0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61, 0xfd, 0x3b, 0x69, 0xfd, 0x75, 0x6e, 0x3b, 0x69, 0xfd, 0x75, 0x6c, 0x3b,
0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x6e, 0x74, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xfd,
0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0xfd, 0x61, 0x62, 0x72, 0x3b, 0x64, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x64a, 0x627,
0x646, 0x6cb, 0x627, 0x631, 0x3b, 0x641, 0x6d0, 0x6cb, 0x631, 0x627, 0x644, 0x3b, 0x645, 0x627, 0x631, 0x62a, 0x3b, 0x626, 0x627, 0x67e,
0x631, 0x6d0, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x646, 0x3b, 0x626, 0x649, 0x64a, 0x6c7, 0x644, 0x3b,
0x626, 0x627, 0x6cb, 0x63a, 0x6c7, 0x633, 0x62a, 0x3b, 0x633, 0x6d0, 0x646, 0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x626, 0x6c6, 0x643,
0x62a, 0x6d5, 0x628, 0x649, 0x631, 0x3b, 0x646, 0x648, 0x64a, 0x627, 0x628, 0x649, 0x631, 0x3b, 0x62f, 0x6d0, 0x643, 0x627, 0x628, 0x649,
0x631, 0x3b, 0x441, 0x456, 0x447, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x431, 0x435, 0x440, 0x3b, 0x43a, 0x432, 0x456, 0x3b, 0x442, 0x440,
0x430, 0x3b, 0x447, 0x435, 0x440, 0x3b, 0x43b, 0x438, 0x43f, 0x3b, 0x441, 0x435, 0x440, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x436, 0x43e,
0x432, 0x3b, 0x43b, 0x438, 0x441, 0x3b, 0x433, 0x440, 0x443, 0x3b, 0x441, 0x456, 0x447, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x44e, 0x442,
0x438, 0x439, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x435, 0x43d, 0x44c, 0x3b,
0x442, 0x440, 0x430, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x438, 0x43f, 0x435,
0x43d, 0x44c, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x3b,
0x436, 0x43e, 0x432, 0x442, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x3b, 0x433, 0x440, 0x443,
0x434, 0x435, 0x43d, 0x44c, 0x3b, 0x421, 0x3b, 0x41b, 0x3b, 0x411, 0x3b, 0x41a, 0x3b, 0x422, 0x3b, 0x427, 0x3b, 0x41b, 0x3b, 0x421,
0x3b, 0x412, 0x3b, 0x416, 0x3b, 0x41b, 0x3b, 0x413, 0x3b, 0x441, 0x456, 0x447, 0x2e, 0x3b, 0x43b, 0x44e, 0x442, 0x2e, 0x3b, 0x431,
0x435, 0x440, 0x2e, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x2e, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x2e, 0x3b, 0x447, 0x435, 0x440, 0x432,
0x2e, 0x3b, 0x43b, 0x438, 0x43f, 0x2e, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x2e, 0x3b, 0x432, 0x435, 0x440, 0x2e, 0x3b, 0x436, 0x43e,
0x432, 0x442, 0x2e, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x2e, 0x3b, 0x433, 0x440, 0x443, 0x434, 0x2e, 0x3b, 0x441, 0x456, 0x447, 0x43d,
0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x43e, 0x433, 0x43e, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x43d, 0x44f, 0x3b, 0x43a, 0x432, 0x456,
0x442, 0x43d, 0x44f, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x43d, 0x44f, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x43d, 0x44f, 0x3b, 0x43b, 0x438,
0x43f, 0x43d, 0x44f, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441, 0x43d, 0x44f, 0x3b, 0x436,
0x43e, 0x432, 0x442, 0x43d, 0x44f, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x430, 0x3b, 0x433, 0x440, 0x443, 0x434,
0x43d, 0x44f, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x431, 0x3b, 0x43a, 0x3b, 0x442, 0x3b, 0x447, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x432,
0x3b, 0x436, 0x3b, 0x43b, 0x3b, 0x433, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645,
0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648,
0x644, 0x627, 0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648,
0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x6e, 0x3b, 0x49,
0x79, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x79, 0x3b, 0x44,
0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72,
0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75,
0x6c, 0x3b, 0x41, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74,
0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x59, 0x3b,
0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b,
0x44, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x69, 0x79, 0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b,
0x74, 0x3b, 0x6e, 0x6f, 0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x79, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x76,
0x72, 0x61, 0x6c, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69,
0x79, 0x75, 0x6e, 0x3b, 0x69, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x6e, 0x74,
0x61, 0x62, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x61, 0x62, 0x72, 0x3b, 0x6e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x64, 0x65,
0x6b, 0x61, 0x62, 0x72, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e, 0x631,
0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x3b, 0x633, 0x67e, 0x62a, 0x3b,
0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x648, 0x645, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x44f, 0x43d, 0x432, 0x3b, 0x444, 0x435, 0x432, 0x3b,
0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x3b, 0x438, 0x44e, 0x43b, 0x3b,
0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x44f, 0x3b, 0x434, 0x435, 0x43a, 0x3b,
0x44f, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f,
0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x44e, 0x43d, 0x3b, 0x438, 0x44e, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x43d, 0x43e,
0x44f, 0x431, 0x440, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x3b, 0x54, 0x68, 0x67,
0x20, 0x32, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x35,
0x3b, 0x54, 0x68, 0x67, 0x20, 0x36, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x38, 0x3b, 0x54,
0x68, 0x67, 0x20, 0x39, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x54, 0x68, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x54,
0x68, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x32, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x33, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x34, 0x3b, 0x54, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x35, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x36, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20,
0x37, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x38, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x39, 0x3b, 0x54, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x54, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x54, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0x67,
0x20, 0x33, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x36,
0x3b, 0x74, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x38, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x74,
0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b,
0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x35, 0x3b,
0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0xe1, 0x6e,
0x67, 0x20, 0x38, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x30,
0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x31, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x79,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0xe4, 0x7a, 0x3b, 0x70, 0x72, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79,
0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x67, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x74, 0x6f, 0x62, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x79, 0x61, 0x6e, 0x75, 0x6c, 0x3b, 0x66, 0x65, 0x62, 0x75, 0x6c, 0x3b, 0x6d,
0xe4, 0x7a, 0x75, 0x6c, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x75, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x75, 0x6c, 0x3b, 0x79, 0x75,
0x6e, 0x75, 0x6c, 0x3b, 0x79, 0x75, 0x6c, 0x75, 0x6c, 0x3b, 0x67, 0x75, 0x73, 0x74, 0x75, 0x6c, 0x3b, 0x73, 0x65, 0x74,
0x75, 0x6c, 0x3b, 0x74, 0x6f, 0x62, 0x75, 0x6c, 0x3b, 0x6e, 0x6f, 0x76, 0x75, 0x6c, 0x3b, 0x64, 0x65, 0x6b, 0x75, 0x6c,
0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0xe4, 0x7a, 0x3b, 0x70, 0x72, 0x6c,
0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x67, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74,
0x3b, 0x74, 0x6f, 0x6e, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x49, 0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77,
0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72,
0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b,
0x52, 0x68, 0x61, 0x67, 0x3b, 0x49, 0x6f, 0x6e, 0x61, 0x77, 0x72, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x72, 0x6f, 0x72,
0x3b, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d,
0x65, 0x68, 0x65, 0x66, 0x69, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x65, 0x6e, 0x6e, 0x61, 0x66, 0x3b, 0x41, 0x77,
0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x72, 0x65, 0x66, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x77,
0x65, 0x64, 0x64, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x66, 0x79, 0x72, 0x3b, 0x49, 0x3b, 0x43, 0x68, 0x3b, 0x4d, 0x3b, 0x45,
0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x52, 0x68, 0x3b, 0x49, 0x6f,
0x6e, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d,
0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65,
0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d,
0x3b, 0x46, 0x65, 0x77, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x77,
0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0xe0, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x77, 0x3b,
0x44, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x77, 0x69, 0x79, 0x65, 0x65, 0x3b, 0x46, 0x65, 0x77, 0x72, 0x69, 0x79, 0x65,
0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x77, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x77,
0x65, 0x3b, 0x53, 0x75, 0x6c, 0x65, 0x74, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0xe0, 0x74, 0x74, 0x75, 0x6d, 0x62, 0x61, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x77, 0xe0, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44,
0x65, 0x73, 0xe0, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x5d9, 0x5d0, 0x5b7, 0x5e0, 0x3b, 0x5e4, 0x5bf, 0x5e2, 0x5d1, 0x3b, 0x5de, 0x5e2,
0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5b7, 0x5e4, 0x5bc, 0x5e8, 0x3b, 0x5de, 0x5d9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5,
0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d9, 0x5d2, 0x3b, 0x5e1, 0x5e2, 0x5e4, 0x5bc, 0x3b, 0x5d0, 0x5e7, 0x5d8, 0x3b, 0x5e0, 0x5d0, 0x5d5,
0x5d5, 0x3b, 0x5d3, 0x5e2, 0x5e6, 0x3b, 0x5d9, 0x5d0, 0x5b7, 0x5e0, 0x5d5, 0x5d0, 0x5b7, 0x5e8, 0x3b, 0x5e4, 0x5bf, 0x5e2, 0x5d1, 0x5e8,
0x5d5, 0x5d0, 0x5b7, 0x5e8, 0x3b, 0x5de, 0x5e2, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5b7, 0x5e4, 0x5bc, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d9,
0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d9, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b,
0x5e1, 0x5e2, 0x5e4, 0x5bc, 0x5d8, 0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5d0, 0x5e7, 0x5d8, 0x5d0, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5e0,
0x5d0, 0x5d5, 0x5d5, 0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x5d3, 0x5e2, 0x5e6, 0x5e2, 0x5de, 0x5d1, 0x5e2, 0x5e8, 0x3b, 0x1e62, 0x1eb9,
0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67,
0x62, 0xe9, 0x3b, 0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x1eb9, 0x6d,
0x1ecd, 0x3b, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b,
0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9,
0x301, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x72, 0x1eb9, 0x300,
0x6e, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x300, 0x62, 0x69,
0x62, 0x69, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x41, 0x67, 0x1eb9,
0x6d, 0x1ecd, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x4f, 0x77, 0x65, 0x77,
0x65, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x42, 0xe9, 0x6c,
0xfa, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b, 0x301, 0x3b,
0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x190, 0x72, 0x25b, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x190, 0x300,
0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0xd2, 0x67, 0xfa,
0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x186, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c, 0xfa, 0x3b,
0x186, 0x300, 0x70, 0x25b, 0x300, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x53, 0x68, 0x25b, 0x301, 0x72, 0x25b, 0x301, 0x3b, 0x4f,
0x73, 0x68, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x190, 0x72, 0x25b, 0x300, 0x6e,
0xe0, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x190, 0x300, 0x62,
0x69, 0x62, 0x69, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20,
0x41, 0x67, 0x25b, 0x6d, 0x254, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x73, 0x68, 0xf9,
0x20, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f,
0x73, 0x68, 0xf9, 0x20, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x73, 0x68, 0xf9, 0x20, 0x186, 0x300, 0x70, 0x25b, 0x300, 0x3b,
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x45, 0x70, 0x68, 0x3b, 0x4d, 0x65, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x68, 0x72, 0x65, 0x6c, 0x69,
0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x67,
0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x68, 0x6f,
0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a,
0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67,
0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73,
0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72,
0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f,
0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440,
0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x443, 0x433, 0x3b, 0x441, 0x435, 0x43f,
0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b,
0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c,
0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x443, 0x433, 0x443, 0x441, 0x442, 0x3b,
0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e,
0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x4a, 0x2d, 0x67, 0x75,
0x65, 0x72, 0x3b, 0x54, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76,
0x72, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65,
0x65, 0x3b, 0x4a, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e,
0x3b, 0x4d, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d,
0x2d, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x2d, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x4a, 0x65,
0x72, 0x72, 0x65, 0x79, 0x2d, 0x67, 0x65, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x54, 0x6f, 0x73, 0x68, 0x69, 0x61, 0x67, 0x68,
0x74, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x65, 0x72, 0x69,
0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65,
0x65, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e,
0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x65,
0x72, 0x72, 0x65, 0x79, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e,
0x65, 0x79, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x6e, 0x79, 0x20, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x47, 0x65,
0x6e, 0x3b, 0x48, 0x77, 0x65, 0x3b, 0x4d, 0x65, 0x75, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x4d, 0x65, 0x74,
0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x6e, 0x3b, 0x48, 0x65, 0x64, 0x3b, 0x44, 0x75, 0x3b,
0x4b, 0x65, 0x76, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x48,
0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4d, 0x65, 0x75, 0x72, 0x74, 0x68, 0x3b, 0x6d, 0x69,
0x73, 0x20, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4d, 0x65, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4d,
0x65, 0x74, 0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x47, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65,
0x6e, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x45, 0x73, 0x74, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x47, 0x77, 0x79, 0x6e, 0x6e, 0x67,
0x61, 0x6c, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x48, 0x65, 0x64, 0x72, 0x61, 0x3b, 0x6d, 0x69, 0x73, 0x20, 0x44, 0x75,
0x3b, 0x6d, 0x69, 0x73, 0x20, 0x4b, 0x65, 0x76, 0x61, 0x72, 0x64, 0x68, 0x75, 0x3b, 0x53, 0x2d, 0x186, 0x3b, 0x4b, 0x2d,
0x186, 0x3b, 0x45, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x4f, 0x3b, 0x45, 0x2d, 0x4b, 0x3b, 0x4f, 0x2d, 0x41, 0x3b, 0x41, 0x2d,
0x4b, 0x3b, 0x44, 0x2d, 0x186, 0x3b, 0x46, 0x2d, 0x190, 0x3b, 0x186, 0x2d, 0x41, 0x3b, 0x186, 0x2d, 0x4f, 0x3b, 0x4d, 0x2d,
0x186, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x61, 0x2d, 0x186, 0x70, 0x25b, 0x70, 0x254, 0x6e, 0x3b, 0x4b, 0x77, 0x61, 0x6b, 0x77,
0x61, 0x72, 0x2d, 0x186, 0x67, 0x79, 0x65, 0x66, 0x75, 0x6f, 0x3b, 0x45, 0x62, 0x254, 0x77, 0x2d, 0x186, 0x62, 0x65, 0x6e,
0x65, 0x6d, 0x3b, 0x45, 0x62, 0x254, 0x62, 0x69, 0x72, 0x61, 0x2d, 0x4f, 0x66, 0x6f, 0x72, 0x69, 0x73, 0x75, 0x6f, 0x3b,
0x45, 0x73, 0x75, 0x73, 0x6f, 0x77, 0x20, 0x41, 0x6b, 0x65, 0x74, 0x73, 0x65, 0x61, 0x62, 0x61, 0x2d, 0x4b, 0x254, 0x74,
0x254, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x62, 0x69, 0x72, 0x61, 0x64, 0x65, 0x2d, 0x41, 0x79, 0x25b, 0x77, 0x6f,
0x68, 0x6f, 0x6d, 0x75, 0x6d, 0x75, 0x3b, 0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x2d, 0x4b, 0x69, 0x74, 0x61, 0x77,
0x6f, 0x6e, 0x73, 0x61, 0x3b, 0x44, 0x69, 0x66, 0x75, 0x75, 0x2d, 0x186, 0x73, 0x61, 0x6e, 0x64, 0x61, 0x61, 0x3b, 0x46,
0x61, 0x6e, 0x6b, 0x77, 0x61, 0x2d, 0x190, 0x62, 0x254, 0x3b, 0x186, 0x62, 0x25b, 0x73, 0x25b, 0x2d, 0x41, 0x68, 0x69, 0x6e,
0x69, 0x6d, 0x65, 0x3b, 0x186, 0x62, 0x65, 0x72, 0x25b, 0x66, 0x25b, 0x77, 0x2d, 0x4f, 0x62, 0x75, 0x62, 0x75, 0x6f, 0x3b,
0x4d, 0x75, 0x6d, 0x75, 0x2d, 0x186, 0x70, 0x25b, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b,
0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x92f, 0x3b,
0x906, 0x917, 0x94b, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f,
0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c,
0x930, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65,
0x65, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x1ecc, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x65, 0x6e, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x4d, 0x61, 0x61, 0x63, 0x68, 0x1ecb, 0x3b, 0x45, 0x70, 0x72, 0x65,
0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x1ecb, 0x3b, 0x1ecc, 0x67, 0x1ecd,
0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x1ecc, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b,
0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4d, 0x62, 0x65, 0x3b,
0x4b, 0x65, 0x6c, 0x3b, 0x4b, 0x74, 0x169, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x74, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b,
0x4d, 0x6f, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x4b, 0x6e, 0x64, 0x3b, 0x128, 0x6b, 0x75, 0x3b, 0x128, 0x6b, 0x6d, 0x3b,
0x128, 0x6b, 0x6c, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x65, 0x3b, 0x4d, 0x77, 0x61,
0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77,
0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61,
0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d,
0x75, 0x6f, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x79, 0x61, 0x61, 0x6e, 0x79,
0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69,
0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x129, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20,
0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6c, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x5a, 0x65, 0x6e,
0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x76, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67,
0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x69, 0x63, 0x3b, 0x5a, 0x65, 0x6e, 0xe2, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0xe2, 0x72, 0x3b, 0x4d, 0x61,
0x72, 0xe7, 0x3b, 0x41, 0x76, 0x72, 0xee, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x6e, 0x3b, 0x4c, 0x75,
0x69, 0x3b, 0x41, 0x76, 0x6f, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x74, 0x75,
0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b,
0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66,
0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e,
0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b,
0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x129, 0x65,
0x3b, 0x64, 0x61, 0x6d, 0x61, 0x3b, 0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64,
0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65,
0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65,
0x3b, 0x64, 0x3b, 0x64, 0x3b, 0x74, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6b,
0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x49, 0x61, 0x6e, 0x2e, 0x3b, 0x50, 0x65, 0x70, 0x2e, 0x3b, 0x4d, 0x61, 0x6c, 0x2e, 0x3b,
0x2bb, 0x41, 0x70, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x2e, 0x3b, 0x49, 0x75, 0x6c, 0x2e, 0x3b, 0x2bb,
0x41, 0x75, 0x2e, 0x3b, 0x4b, 0x65, 0x70, 0x2e, 0x3b, 0x2bb, 0x4f, 0x6b, 0x2e, 0x3b, 0x4e, 0x6f, 0x77, 0x2e, 0x3b, 0x4b,
0x65, 0x6b, 0x2e, 0x3b, 0x49, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x50, 0x65, 0x70, 0x65, 0x6c, 0x75, 0x61, 0x6c,
0x69, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x6b, 0x69, 0x3b, 0x2bb, 0x41, 0x70, 0x65, 0x6c, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x49, 0x75, 0x6e, 0x65, 0x3b, 0x49, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x75, 0x6b, 0x61, 0x6b, 0x65,
0x3b, 0x4b, 0x65, 0x70, 0x61, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x6b, 0x6f, 0x70, 0x61,
0x3b, 0x4e, 0x6f, 0x77, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4b, 0x65, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x45,
0x6e, 0x65, 0x3b, 0x50, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48,
0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e,
0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x50, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f,
0x3b, 0x4d, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x48, 0x75,
0x6e, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6c, 0x79, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x62, 0x79, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x4d,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d,
0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x63, 0x68,
0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72,
0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xa2cd,
0xa1aa, 0x3b, 0xa44d, 0xa1aa, 0x3b, 0xa315, 0xa1aa, 0x3b, 0xa1d6, 0xa1aa, 0x3b, 0xa26c, 0xa1aa, 0x3b, 0xa0d8, 0xa1aa, 0x3b, 0xa3c3, 0xa1aa, 0x3b,
0xa246, 0xa1aa, 0x3b, 0xa22c, 0xa1aa, 0x3b, 0xa2b0, 0xa1aa, 0x3b, 0xa2b0, 0xa2aa, 0xa1aa, 0x3b, 0xa2b0, 0xa44b, 0xa1aa, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x61, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41,
0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41,
0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f,
0x76, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f,
0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67,
0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76,
0x3b, 0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76,
0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x63,
0x75, 0x6f, 0x14b, 0x6f, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e,
0x75, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e,
0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x10d, 0x61,
0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xe1, 0x6e, 0x6e,
0x75, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61,
0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x4f, 0x3b, 0x47, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x53, 0x3b,
0x42, 0x3b, 0x10c, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b,
0x6e, 0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b,
0x73, 0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b,
0x73, 0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x3b, 0x43, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x43, 0x75, 0x6c, 0x3b, 0x41, 0x67,
0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x43, 0x68,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68,
0x69, 0x3b, 0x41, 0x70, 0x69, 0x72, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x43,
0x68, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69,
0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x43, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x43, 0x3b,
0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x49, 0x6d, 0x62, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61,
0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4b, 0x61, 0x72, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x57, 0x75,
0x6e, 0x3b, 0x49, 0x6b, 0x65, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x77, 0x69, 0x3b, 0x4d, 0x6f,
0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6d, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20,
0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20,
0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e,
0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4d,
0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x72, 0x61, 0x6e, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d,
0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6d, 0x66, 0x75, 0x6e, 0x67, 0x61, 0x64, 0x65, 0x3b, 0x4d, 0x6f,
0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x77, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x6f, 0x72,
0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67,
0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69,
0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x77, 0x69, 0x3b, 0x49,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49,
0x3b, 0x49, 0x3b, 0x73, 0x69, 0x69, 0x3b, 0x63, 0x6f, 0x6c, 0x3b, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x64,
0x75, 0x75, 0x3b, 0x6b, 0x6f, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x3b, 0x6a, 0x75, 0x6b, 0x3b, 0x73, 0x6c, 0x74, 0x3b, 0x79,
0x61, 0x72, 0x3b, 0x6a, 0x6f, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x6f, 0x3b, 0x63, 0x6f, 0x6c,
0x74, 0x65, 0x3b, 0x6d, 0x62, 0x6f, 0x6f, 0x79, 0x3b, 0x73, 0x65, 0x65, 0x257, 0x74, 0x6f, 0x3b, 0x64, 0x75, 0x75, 0x6a,
0x61, 0x6c, 0x3b, 0x6b, 0x6f, 0x72, 0x73, 0x65, 0x3b, 0x6d, 0x6f, 0x72, 0x73, 0x6f, 0x3b, 0x6a, 0x75, 0x6b, 0x6f, 0x3b,
0x73, 0x69, 0x69, 0x6c, 0x74, 0x6f, 0x3b, 0x79, 0x61, 0x72, 0x6b, 0x6f, 0x6d, 0x61, 0x61, 0x3b, 0x6a, 0x6f, 0x6c, 0x61,
0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x74, 0x65, 0x3b, 0x73, 0x3b, 0x63, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x6b, 0x3b,
0x6d, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x79, 0x3b, 0x6a, 0x3b, 0x62, 0x3b, 0x4a, 0x45, 0x4e, 0x3b, 0x57, 0x4b, 0x52, 0x3b,
0x57, 0x47, 0x54, 0x3b, 0x57, 0x4b, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x57, 0x54, 0x44, 0x3b, 0x57, 0x4d, 0x4a, 0x3b,
0x57, 0x4e, 0x4e, 0x3b, 0x57, 0x4b, 0x44, 0x3b, 0x57, 0x49, 0x4b, 0x3b, 0x57, 0x4d, 0x57, 0x3b, 0x44, 0x49, 0x54, 0x3b,
0x4e, 0x6a, 0x65, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65,
0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d,
0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77,
0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61,
0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67,
0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e,
0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61,
0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4e, 0x64, 0x69, 0x74, 0x68,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x44, 0x3b, 0x4f, 0x62, 0x6f, 0x3b, 0x57, 0x61, 0x61, 0x3b, 0x4f, 0x6b, 0x75,
0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6d, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x49, 0x73, 0x69,
0x3b, 0x53, 0x61, 0x61, 0x3b, 0x54, 0x6f, 0x6d, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x54, 0x6f, 0x77, 0x3b, 0x4c, 0x61, 0x70,
0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x77, 0x61, 0x61,
0x72, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4c, 0x61, 0x70,
0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65,
0x20, 0x69, 0x6d, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4c, 0x61,
0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69,
0x73, 0x69, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x61, 0x6c, 0x3b, 0x4c, 0x61,
0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20,
0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f,
0x6d, 0x6f, 0x6e, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4f, 0x3b, 0x57, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x49, 0x3b,
0x49, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65,
0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75,
0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65,
0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d,
0x61, 0x72, 0x63, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x68,
0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f,
0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x5a, 0x69, 0x62, 0x3b, 0x4e, 0x68, 0x6c, 0x6f, 0x3b, 0x4d,
0x62, 0x69, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x77, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x3b, 0x4e, 0x74, 0x75, 0x3b,
0x4e, 0x63, 0x77, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x4d, 0x70, 0x61,
0x6c, 0x3b, 0x5a, 0x69, 0x62, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x6c, 0x61, 0x3b, 0x4e, 0x68, 0x6c, 0x6f, 0x6c, 0x61, 0x6e,
0x6a, 0x61, 0x3b, 0x4d, 0x62, 0x69, 0x6d, 0x62, 0x69, 0x74, 0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x62, 0x61, 0x73, 0x61, 0x3b,
0x4e, 0x6b, 0x77, 0x65, 0x6e, 0x6b, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61,
0x3b, 0x4e, 0x74, 0x75, 0x6c, 0x69, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4e, 0x63, 0x77, 0x61, 0x62, 0x61, 0x6b, 0x61, 0x7a,
0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x64, 0x75, 0x6c, 0x61, 0x3b, 0x4d, 0x66, 0x75, 0x6d, 0x66, 0x75, 0x3b, 0x4c, 0x77,
0x65, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6c, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x5a, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b,
0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x31,
0x3b, 0x4d, 0x32, 0x3b, 0x4d, 0x33, 0x3b, 0x4d, 0x34, 0x3b, 0x4d, 0x35, 0x3b, 0x4d, 0x36, 0x3b, 0x4d, 0x37, 0x3b, 0x4d,
0x38, 0x3b, 0x4d, 0x39, 0x3b, 0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4d,
0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b,
0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e,
0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d,
0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x3b, 0x2d31,
0x2d55, 0x2d30, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x3b, 0x2d49, 0x2d31, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x3b, 0x2d62,
0x2d53, 0x2d4d, 0x3b, 0x2d56, 0x2d53, 0x2d5b, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x3b, 0x2d37,
0x2d53, 0x2d4a, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x2d30, 0x2d62, 0x2d54, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x2d62, 0x2d55, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x2d5a,
0x3b, 0x2d49, 0x2d31, 0x2d54, 0x2d49, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x2d62, 0x2d53, 0x3b, 0x2d62,
0x2d53, 0x2d4d, 0x2d62, 0x2d53, 0x2d63, 0x3b, 0x2d56, 0x2d53, 0x2d5b, 0x2d5c, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b,
0x2d3d, 0x2d5c, 0x2d53, 0x2d31, 0x2d54, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x2d30, 0x2d4f,
0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d49, 0x3b, 0x2d31, 0x3b, 0x2d4e, 0x3b, 0x2d49, 0x3b, 0x2d4e, 0x3b, 0x2d62, 0x3b, 0x2d62, 0x3b, 0x2d56, 0x3b,
0x2d5b, 0x3b, 0x2d3d, 0x3b, 0x2d4f, 0x3b, 0x2d37, 0x3b, 0x69, 0x6e, 0x6e, 0x3b, 0x62, 0x1e5b, 0x61, 0x3b, 0x6d, 0x61, 0x1e5b, 0x3b,
0x69, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x263, 0x75, 0x63, 0x3b,
0x63, 0x75, 0x74, 0x3b, 0x6b, 0x74, 0x75, 0x3b, 0x6e, 0x75, 0x77, 0x3b, 0x64, 0x75, 0x6a, 0x3b, 0x69, 0x6e, 0x6e, 0x61,
0x79, 0x72, 0x3b, 0x62, 0x1e5b, 0x61, 0x79, 0x1e5b, 0x3b, 0x6d, 0x61, 0x1e5b, 0x1e63, 0x3b, 0x69, 0x62, 0x72, 0x69, 0x72, 0x3b,
0x6d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x263,
0x75, 0x63, 0x74, 0x3b, 0x63, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x3b, 0x6e,
0x75, 0x77, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x64, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x69, 0x3b, 0x62,
0x3b, 0x6d, 0x3b, 0x69, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x263, 0x3b, 0x63, 0x3b, 0x6b, 0x3b, 0x6e, 0x3b, 0x64,
0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46, 0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x74, 0x65, 0x3b, 0x54, 0x75, 0x62,
0x3b, 0x57, 0x61, 0x6d, 0x3b, 0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x46, 0x75,
0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61,
0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x3b, 0x194, 0x75, 0x63, 0x74,
0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65, 0x1e5b, 0x3b, 0x57, 0x61, 0x6d, 0x62, 0x65,
0x1e5b, 0x3b, 0x44, 0x75, 0x6a, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x4d,
0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46,
0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59,
0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x74, 0x65, 0x3b, 0x54, 0x75, 0x62, 0x3b, 0x4e, 0x75, 0x6e, 0x3b, 0x44,
0x75, 0x1e7, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x46, 0x75, 0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65,
0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75,
0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65, 0x1e5b, 0x3b, 0x4e, 0x75, 0x6e, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x44, 0x75,
0x1e7, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x194, 0x3b, 0x42, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4c,
0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x52, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x4b, 0x42, 0x5a, 0x3b, 0x4b, 0x42, 0x52, 0x3b, 0x4b,
0x53, 0x54, 0x3b, 0x4b, 0x4b, 0x4e, 0x3b, 0x4b, 0x54, 0x4e, 0x3b, 0x4b, 0x4d, 0x4b, 0x3b, 0x4b, 0x4d, 0x53, 0x3b, 0x4b,
0x4d, 0x4e, 0x3b, 0x4b, 0x4d, 0x57, 0x3b, 0x4b, 0x4b, 0x4d, 0x3b, 0x4b, 0x4e, 0x4b, 0x3b, 0x4b, 0x4e, 0x42, 0x3b, 0x4f,
0x6b, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72,
0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61,
0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d,
0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x6a, 0x75, 0x3b,
0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6e, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x77, 0x65, 0x6e,
0x64, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x77, 0x65, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d,
0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x48, 0x75, 0x74, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x44,
0x61, 0x74, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x48, 0x61, 0x6e, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e,
0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4b, 0x6d, 0x6a, 0x3b, 0x4b, 0x6d, 0x62, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x68, 0x75, 0x74, 0x61, 0x6c, 0x61, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x76, 0x69, 0x6c, 0x69,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x64, 0x61, 0x74,
0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x74, 0x61,
0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74,
0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b,
0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x70,
0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x70, 0x61,
0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x48, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x54,
0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x79, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x77, 0x69, 0x3b,
0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x3b, 0x7a, 0x75, 0x6c, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x3b, 0x254,
0x6b, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x77, 0x75, 0x79, 0x65, 0x3b, 0x66,
0x65, 0x62, 0x75, 0x72, 0x75, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x61, 0x77, 0x69, 0x72, 0x69,
0x6c, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x25b, 0x6e, 0x3b, 0x7a, 0x75, 0x6c, 0x75, 0x79, 0x65, 0x3b, 0x75,
0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x254, 0x6b, 0x75, 0x74, 0x254, 0x62, 0x75,
0x72, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75,
0x72, 0x75, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x5a, 0x3b, 0x55, 0x3b, 0x53,
0x3b, 0x186, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x61, 0x69, 0x3b, 0x4b, 0x61, 0x74, 0x3b, 0x4b,
0x61, 0x6e, 0x3b, 0x47, 0x61, 0x74, 0x3b, 0x47, 0x61, 0x6e, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x4b, 0x6e, 0x6e, 0x3b, 0x4b,
0x65, 0x6e, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x67, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x129, 0x72, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x68, 0x61, 0x74,
0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61,
0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x4b, 0x61, 0x129, 0x72,
0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x13a4, 0x13c3, 0x3b, 0x13a7, 0x13a6, 0x3b, 0x13a0, 0x13c5, 0x3b, 0x13a7, 0x13ec, 0x3b, 0x13a0, 0x13c2,
0x3b, 0x13d5, 0x13ad, 0x3b, 0x13ab, 0x13f0, 0x3b, 0x13a6, 0x13b6, 0x3b, 0x13da, 0x13b5, 0x3b, 0x13da, 0x13c2, 0x3b, 0x13c5, 0x13d3, 0x3b, 0x13a5,
0x13cd, 0x3b, 0x13a4, 0x13c3, 0x13b8, 0x13d4, 0x13c5, 0x3b, 0x13a7, 0x13a6, 0x13b5, 0x3b, 0x13a0, 0x13c5, 0x13f1, 0x3b, 0x13a7, 0x13ec, 0x13c2, 0x3b,
0x13a0, 0x13c2, 0x13cd, 0x13ac, 0x13d8, 0x3b, 0x13d5, 0x13ad, 0x13b7, 0x13f1, 0x3b, 0x13ab, 0x13f0, 0x13c9, 0x13c2, 0x3b, 0x13a6, 0x13b6, 0x13c2, 0x3b,
0x13da, 0x13b5, 0x13cd, 0x13d7, 0x3b, 0x13da, 0x13c2, 0x13c5, 0x13d7, 0x3b, 0x13c5, 0x13d3, 0x13d5, 0x13c6, 0x3b, 0x13a5, 0x13cd, 0x13a9, 0x13f1, 0x3b,
0x13a4, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13d5, 0x3b, 0x13ab, 0x3b, 0x13a6, 0x3b, 0x13da, 0x3b, 0x13da, 0x3b,
0x13c5, 0x3b, 0x13a5, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x76, 0x72, 0x3b,
0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x66, 0x65,
0x76, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x3b,
0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x79, 0x65, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x61, 0x6d,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x3b, 0x6e, 0x6f, 0x76, 0x61, 0x6d, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6d, 0x3b, 0x7a,
0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x7a, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e,
0x3b, 0x64, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x4e, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x77, 0x61, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x54,
0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69,
0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65,
0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x6d, 0x6f, 0x3b,
0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d,
0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61,
0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d,
0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e,
0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x3b, 0x46, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4e, 0x61, 0x61, 0x6e, 0x268,
0x3b, 0x4b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x49, 0x6b, 0xfa, 0x6d, 0x69, 0x3b, 0x49, 0x6e, 0x79, 0x61, 0x6d, 0x62,
0x61, 0x6c, 0x61, 0x3b, 0x49, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b,
0x56, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x53, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x49, 0x6e, 0x79, 0x69, 0x3b, 0x53, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0x53, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x289, 0x66, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b,
0x4b, 0x289, 0x6e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x289, 0x6b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4b, 0x77, 0x69,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x4b,
0x77, 0x69, 0x69, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4b, 0x289, 0x6d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b,
0x4b, 0x289, 0x76, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x77, 0x69, 0x69,
0x6e, 0x79, 0x69, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x73, 0x61, 0x74, 0x289,
0x3b, 0x46, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x49,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x75,
0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x62,
0x3b, 0x4f, 0x6b, 0x69, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x77, 0x61, 0x6c, 0x69,
0x79, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b,
0x41, 0x70, 0x75, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x69, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x62, 0x75, 0x74, 0x74,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x63, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67,
0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61,
0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69,
0x3b, 0x45, 0x70, 0x72, 0x65, 0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61,
0x69, 0x3b, 0x4f, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72,
0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74,
0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x75, 0x76, 0x3b, 0x44, 0x69, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x72, 0x75, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x75, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b,
0x4d, 0x61, 0x69, 0x75, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x75, 0x3b, 0x41, 0x67, 0x6f,
0x73, 0x74, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b,
0x4e, 0x75, 0x76, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x7a, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x41,
0x4e, 0x3b, 0x46, 0x45, 0x42, 0x3b, 0x4d, 0x41, 0x43, 0x3b, 0x128, 0x50, 0x55, 0x3b, 0x4d, 0x128, 0x128, 0x3b, 0x4e, 0x4a,
0x55, 0x3b, 0x4e, 0x4a, 0x52, 0x3b, 0x41, 0x47, 0x41, 0x3b, 0x53, 0x50, 0x54, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4e, 0x4f,
0x56, 0x3b, 0x44, 0x45, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x75,
0x61, 0x72, 0x129, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x128, 0x70, 0x75, 0x72, 0x169, 0x3b, 0x4d, 0x129, 0x129, 0x3b,
0x4e, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x72, 0x61, 0x129, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b,
0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x169, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x128, 0x3b,
0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x75, 0x6c, 0x3b,
0x4e, 0x67, 0x61, 0x74, 0x3b, 0x54, 0x61, 0x61, 0x3b, 0x49, 0x77, 0x6f, 0x3b, 0x4d, 0x61, 0x6d, 0x3b, 0x50, 0x61, 0x61,
0x3b, 0x4e, 0x67, 0x65, 0x3b, 0x52, 0x6f, 0x6f, 0x3b, 0x42, 0x75, 0x72, 0x3b, 0x45, 0x70, 0x65, 0x3b, 0x4b, 0x70, 0x74,
0x3b, 0x4b, 0x70, 0x61, 0x3b, 0x4d, 0x75, 0x6c, 0x67, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x2019, 0x61, 0x74, 0x79, 0x61, 0x61,
0x74, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x74, 0x61, 0x61, 0x6d, 0x6f, 0x3b, 0x49, 0x77, 0x6f, 0x6f, 0x74, 0x6b, 0x75, 0x75,
0x74, 0x3b, 0x4d, 0x61, 0x6d, 0x75, 0x75, 0x74, 0x3b, 0x50, 0x61, 0x61, 0x67, 0x69, 0x3b, 0x4e, 0x67, 0x2019, 0x65, 0x69,
0x79, 0x65, 0x65, 0x74, 0x3b, 0x52, 0x6f, 0x6f, 0x70, 0x74, 0x75, 0x69, 0x3b, 0x42, 0x75, 0x72, 0x65, 0x65, 0x74, 0x3b,
0x45, 0x70, 0x65, 0x65, 0x73, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x20,
0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x62, 0x6f, 0x20,
0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4e, 0x3b,
0x52, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x6e, 0x69, 0x3b, 0x1c3, 0x4b,
0x68, 0x61, 0x6e, 0x1c0, 0x67, 0xf4, 0x61, 0x62, 0x3b, 0x1c0, 0x4b, 0x68, 0x75, 0x75, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b,
0x1c3, 0x48, 0xf4, 0x61, 0x1c2, 0x6b, 0x68, 0x61, 0x69, 0x62, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x69, 0x74, 0x73, 0xe2, 0x62,
0x3b, 0x47, 0x61, 0x6d, 0x61, 0x1c0, 0x61, 0x65, 0x62, 0x3b, 0x1c2, 0x4b, 0x68, 0x6f, 0x65, 0x73, 0x61, 0x6f, 0x62, 0x3b,
0x41, 0x6f, 0x1c1, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x54, 0x61, 0x72, 0x61, 0x1c0,
0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c2, 0x4e, 0xfb, 0x1c1, 0x6e, 0xe2, 0x69, 0x73,
0x65, 0x62, 0x3b, 0x1c0, 0x48, 0x6f, 0x6f, 0x1c2, 0x67, 0x61, 0x65, 0x62, 0x3b, 0x48, 0xf4, 0x61, 0x73, 0x6f, 0x72, 0x65,
0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0xe4, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x7a, 0x2e,
0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b,
0x4f, 0x75, 0x6a, 0x2e, 0x3b, 0x53, 0xe4, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b,
0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x3b, 0x46, 0xe4, 0x62, 0x72, 0x6f, 0x77, 0x61,
0x3b, 0x4d, 0xe4, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x75,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x6a, 0x6f, 0xdf, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x68, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0xe4, 0x62, 0x3b,
0x4d, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x4f, 0x75, 0x6a, 0x3b, 0x53, 0xe4, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b,
0x44, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0xe1, 0x3b, 0x186, 0x25b, 0x6e, 0x3b, 0x44, 0x6f, 0x79, 0x3b, 0x4c, 0xe9, 0x70, 0x3b,
0x52, 0x6f, 0x6b, 0x3b, 0x53, 0xe1, 0x73, 0x3b, 0x42, 0x254, 0x301, 0x72, 0x3b, 0x4b, 0xfa, 0x73, 0x3b, 0x47, 0xed, 0x73,
0x3b, 0x53, 0x68, 0x289, 0x301, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x3b, 0x4f, 0x6c, 0x61, 0x64, 0x61, 0x6c, 0x289, 0x301, 0x3b,
0x41, 0x72, 0xe1, 0x74, 0x3b, 0x186, 0x25b, 0x6e, 0x268, 0x301, 0x254, 0x268, 0x14b, 0x254, 0x6b, 0x3b, 0x4f, 0x6c, 0x6f, 0x64,
0x6f, 0x79, 0xed, 0xf3, 0x72, 0xed, 0xea, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4f, 0x6c, 0x6f, 0x69,
0x6c, 0xe9, 0x70, 0x16b, 0x6e, 0x79, 0x12b, 0x113, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4b, 0xfa, 0x6a,
0xfa, 0x254, 0x72, 0x254, 0x6b, 0x3b, 0x4d, 0xf3, 0x72, 0x75, 0x73, 0xe1, 0x73, 0x69, 0x6e, 0x3b, 0x186, 0x6c, 0x254, 0x301,
0x268, 0x301, 0x62, 0x254, 0x301, 0x72, 0xe1, 0x72, 0x25b, 0x3b, 0x4b, 0xfa, 0x73, 0x68, 0xee, 0x6e, 0x3b, 0x4f, 0x6c, 0x67,
0xed, 0x73, 0x61, 0x6e, 0x3b, 0x50, 0x289, 0x73, 0x68, 0x289, 0x301, 0x6b, 0x61, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x14b, 0x289,
0x301, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x52,
0x61, 0x72, 0x3b, 0x4d, 0x75, 0x6b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d,
0x6f, 0x64, 0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x50, 0x65, 0x64, 0x3b, 0x53, 0x6f, 0x6b, 0x3b, 0x54, 0x69, 0x62, 0x3b, 0x4c,
0x61, 0x62, 0x3b, 0x50, 0x6f, 0x6f, 0x3b, 0x4f, 0x72, 0x61, 0x72, 0x61, 0x3b, 0x4f, 0x6d, 0x75, 0x6b, 0x3b, 0x4f, 0x6b,
0x77, 0x61, 0x6d, 0x67, 0x2019, 0x3b, 0x4f, 0x64, 0x75, 0x6e, 0x67, 0x2019, 0x65, 0x6c, 0x3b, 0x4f, 0x6d, 0x61, 0x72, 0x75,
0x6b, 0x3b, 0x4f, 0x6d, 0x6f, 0x64, 0x6f, 0x6b, 0x2019, 0x6b, 0x69, 0x6e, 0x67, 0x2019, 0x6f, 0x6c, 0x3b, 0x4f, 0x6a, 0x6f,
0x6c, 0x61, 0x3b, 0x4f, 0x70, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x4f, 0x73, 0x6f, 0x6b, 0x6f, 0x73, 0x6f, 0x6b, 0x6f, 0x6d,
0x61, 0x3b, 0x4f, 0x74, 0x69, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x3b, 0x4f, 0x70, 0x6f, 0x6f,
0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x4c, 0x3b, 0x50, 0x3b, 0x17d, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x69,
0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x3b, 0x17d, 0x75, 0x79, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x6f, 0x3b, 0x44, 0x65, 0x65, 0x3b, 0x17d, 0x61, 0x6e, 0x77, 0x69, 0x79, 0x65, 0x3b, 0x46,
0x65, 0x65, 0x77, 0x69, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x69, 0x3b, 0x41, 0x77, 0x69, 0x72, 0x69,
0x6c, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x65, 0x14b, 0x3b, 0x17d, 0x75, 0x79, 0x79, 0x65, 0x3b, 0x55, 0x74, 0x3b,
0x53, 0x65, 0x6b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x75, 0x72, 0x3b, 0x4e,
0x6f, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x44, 0x65, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x17d,
0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x17d, 0x3b, 0x17d, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x44, 0x41, 0x43, 0x3b, 0x44, 0x41, 0x52, 0x3b, 0x44, 0x41, 0x44, 0x3b, 0x44, 0x41, 0x4e, 0x3b, 0x44,
0x41, 0x48, 0x3b, 0x44, 0x41, 0x55, 0x3b, 0x44, 0x41, 0x4f, 0x3b, 0x44, 0x41, 0x42, 0x3b, 0x44, 0x4f, 0x43, 0x3b, 0x44,
0x41, 0x50, 0x3b, 0x44, 0x47, 0x49, 0x3b, 0x44, 0x41, 0x47, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41,
0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b,
0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72,
0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69,
0x63, 0x68, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x75, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44,
0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x62, 0x6f, 0x72, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4f, 0x63, 0x68,
0x69, 0x6b, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x3b, 0x44, 0x77, 0x65,
0x20, 0x6d, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x43, 0x3b, 0x52,
0x3b, 0x44, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x55, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x50,
0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x49, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x75, 0x74, 0x3b, 0x4b, 0x1e6d, 0x75,
0x3b, 0x4e, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x59, 0x65,
0x62, 0x72, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61,
0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x194, 0x75, 0x63,
0x74, 0x3b, 0x43, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x4b, 0x1e6d, 0x75, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x77,
0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x44, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x4d,
0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a,
0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68,
0x69, 0x3b, 0x41, 0x70, 0x6c, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75,
0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x938, 0x3b, 0x90f, 0x92b, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x907, 0x3b, 0x906, 0x917, 0x938, 0x94d, 0x925, 0x3b, 0x938, 0x947, 0x92c, 0x925, 0x947,
0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x905, 0x916, 0x925, 0x92c, 0x930, 0x3b, 0x928, 0x92c, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930,
0x3b, 0x926, 0x93f, 0x938, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f,
0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x3b, 0x91c, 0x941, 0x3b, 0x906, 0x3b, 0x938, 0x947, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926,
0x93f, 0x3b, 0x456, 0x486, 0x430, 0x2de9, 0x487, 0x3b, 0x444, 0x435, 0x2de1, 0x487, 0x3b, 0x43c, 0x430, 0x2dec, 0x487, 0x3b, 0x430, 0x486,
0x43f, 0x2dec, 0x487, 0x3b, 0x43c, 0x430, 0xa675, 0x3b, 0x456, 0x486, 0xa64b, 0x2de9, 0x487, 0x3b, 0x456, 0x486, 0xa64b, 0x2de7, 0x487, 0x3b,
0x430, 0x486, 0x301, 0x475, 0x2de2, 0x487, 0x3b, 0x441, 0x435, 0x2deb, 0x487, 0x3b, 0x47b, 0x486, 0x43a, 0x2dee, 0x3b, 0x43d, 0x43e, 0x435,
0x2de8, 0x3b, 0x434, 0x435, 0x2de6, 0x487, 0x3b, 0x456, 0x486, 0x430, 0x43d, 0x43d, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x439, 0x3b, 0x444,
0x435, 0x432, 0x440, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x439, 0x3b, 0x43c, 0x430, 0x301, 0x440, 0x442, 0x44a, 0x3b, 0x430, 0x486, 0x43f,
0x440, 0x456, 0x301, 0x43b, 0x43b, 0x457, 0x439, 0x3b, 0x43c, 0x430, 0x301, 0x457, 0x439, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43d, 0x457,
0x439, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43b, 0x457, 0x439, 0x3b, 0x430, 0x486, 0x301, 0x475, 0x433, 0xa64b, 0x441, 0x442, 0x44a, 0x3b,
0x441, 0x435, 0x43f, 0x442, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x47b, 0x486, 0x43a, 0x442, 0x461, 0x301, 0x432, 0x440,
0x457, 0x439, 0x3b, 0x43d, 0x43e, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x439, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x301, 0x43c, 0x432,
0x440, 0x457, 0x439, 0x3b, 0x406, 0x486, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x486, 0x3b, 0x41c, 0x3b, 0x406, 0x486, 0x3b, 0x406,
0x486, 0x3b, 0x410, 0x486, 0x3b, 0x421, 0x3b, 0x47a, 0x486, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x456, 0x486, 0x430, 0x43d, 0x43d, 0xa64b,
0x430, 0x301, 0x440, 0x457, 0x430, 0x3b, 0x444, 0x435, 0x432, 0x440, 0xa64b, 0x430, 0x301, 0x440, 0x457, 0x430, 0x3b, 0x43c, 0x430, 0x301,
0x440, 0x442, 0x430, 0x3b, 0x430, 0x486, 0x43f, 0x440, 0x456, 0x301, 0x43b, 0x43b, 0x457, 0x430, 0x3b, 0x43c, 0x430, 0x301, 0x457, 0x430,
0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43d, 0x457, 0x430, 0x3b, 0x456, 0x486, 0xa64b, 0x301, 0x43b, 0x457, 0x430, 0x3b, 0x430, 0x486, 0x301,
0x475, 0x433, 0xa64b, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x430, 0x3b, 0x47b,
0x486, 0x43a, 0x442, 0x461, 0x301, 0x432, 0x440, 0x457, 0x430, 0x3b, 0x43d, 0x43e, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x430, 0x3b,
0x434, 0x435, 0x43a, 0x435, 0x301, 0x43c, 0x432, 0x440, 0x457, 0x430, 0x3b, 0x43, 0x69, 0x6f, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x4c,
0x75, 0x73, 0x3b, 0x4d, 0x75, 0x75, 0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x66, 0x3b, 0x4b, 0x61, 0x62, 0x3b, 0x4c,
0x75, 0x73, 0x68, 0x3b, 0x4c, 0x75, 0x74, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x43, 0x69, 0x73, 0x3b,
0x43, 0x69, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0xf9, 0x69, 0x73, 0x68, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0xf2, 0x6c, 0x6f,
0x3b, 0x4d, 0xf9, 0x75, 0x79, 0xe0, 0x3b, 0x4c, 0x75, 0x6d, 0xf9, 0x6e, 0x67, 0xf9, 0x6c, 0xf9, 0x3b, 0x4c, 0x75, 0x66,
0x75, 0x69, 0x6d, 0x69, 0x3b, 0x4b, 0x61, 0x62, 0xe0, 0x6c, 0xe0, 0x73, 0x68, 0xec, 0x70, 0xf9, 0x3b, 0x4c, 0xf9, 0x73,
0x68, 0xec, 0x6b, 0xe0, 0x3b, 0x4c, 0x75, 0x74, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x67, 0xf9,
0x64, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x77, 0xe8, 0x6b, 0xe8, 0x73, 0xe8, 0x3b, 0x43, 0x69, 0x73, 0x77, 0xe0, 0x3b, 0x43,
0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b,
0x3b, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d,
0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x65, 0x72, 0x7a, 0x3b, 0x41, 0x62, 0x72, 0xeb, 0x6c, 0x6c, 0x3b, 0x4d,
0x65, 0x65, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b,
0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x2e,
0x3b, 0x46, 0x65, 0x62, 0x2e, 0x3b, 0x4d, 0xe4, 0x65, 0x2e, 0x3b, 0x41, 0x62, 0x72, 0x2e, 0x3b, 0x4d, 0x65, 0x65, 0x3b,
0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0x65, 0x70, 0x2e, 0x3b,
0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x6e, 0xf9, 0x6d, 0x3b, 0x6b,
0x268, 0x7a, 0x3b, 0x74, 0x268, 0x64, 0x3b, 0x74, 0x61, 0x61, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x6e, 0x7a, 0x75, 0x3b, 0x64,
0x75, 0x6d, 0x3b, 0x66, 0x254, 0x65, 0x3b, 0x64, 0x7a, 0x75, 0x3b, 0x6c, 0x254, 0x6d, 0x3b, 0x6b, 0x61, 0x61, 0x3b, 0x66,
0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0xf9, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300,
0x14b, 0x254, 0x300, 0x6b, 0x197, 0x300, 0x7a, 0xf9, 0x294, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197,
0x300, 0x64, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x1ce, 0x61, 0x66,
0x289, 0x304, 0x67, 0x68, 0x101, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x73, 0xe8, 0x65, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0x7a, 0xf9, 0x67, 0x68, 0xf2, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300,
0x64, 0xf9, 0x6d, 0x6c, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x77, 0xee, 0x66, 0x254, 0x300,
0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x66, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x64,
0x7a, 0x75, 0x67, 0x68, 0xf9, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x67, 0x68, 0x1d4, 0x75, 0x77, 0x65,
0x6c, 0x254, 0x300, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x63, 0x68, 0x77, 0x61, 0x294, 0xe0, 0x6b,
0x61, 0x61, 0x20, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x66, 0x77, 0xf2, 0x6f, 0x3b, 0x6e, 0x3b,
0x6b, 0x3b, 0x74, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x63, 0x3b,
0x66, 0x3b, 0x6b, 0x254, 0x6e, 0x3b, 0x6d, 0x61, 0x63, 0x3b, 0x6d, 0x61, 0x74, 0x3b, 0x6d, 0x74, 0x6f, 0x3b, 0x6d, 0x70,
0x75, 0x3b, 0x68, 0x69, 0x6c, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x68, 0x69, 0x6b, 0x3b, 0x64, 0x69, 0x70, 0x3b, 0x62, 0x69,
0x6f, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6c, 0x69, 0x253, 0x3b, 0x4b, 0x254, 0x6e, 0x64, 0x254, 0x14b, 0x3b, 0x4d, 0xe0, 0x63,
0x25b, 0x302, 0x6c, 0x3b, 0x4d, 0xe0, 0x74, 0xf9, 0x6d, 0x62, 0x3b, 0x4d, 0xe0, 0x74, 0x6f, 0x70, 0x3b, 0x4d, 0x300, 0x70,
0x75, 0x79, 0x25b, 0x3b, 0x48, 0xec, 0x6c, 0xf2, 0x6e, 0x64, 0x25b, 0x300, 0x3b, 0x4e, 0x6a, 0xe8, 0x62, 0xe0, 0x3b, 0x48,
0xec, 0x6b, 0x61, 0x14b, 0x3b, 0x44, 0xec, 0x70, 0x254, 0x300, 0x73, 0x3b, 0x42, 0xec, 0xf2, 0xf4, 0x6d, 0x3b, 0x4d, 0xe0,
0x79, 0x25b, 0x73, 0xe8, 0x70, 0x3b, 0x4c, 0xec, 0x62, 0x75, 0x79, 0x20, 0x6c, 0x69, 0x20, 0x144, 0x79, 0xe8, 0x65, 0x3b,
0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x6e, 0x3b, 0x68, 0x3b, 0x64, 0x3b, 0x62, 0x3b,
0x6d, 0x3b, 0x6c, 0x3b, 0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x3b, 0x73, 0x254, 0x14b, 0x3b, 0x64, 0x69, 0x253, 0x3b,
0x65, 0x6d, 0x69, 0x3b, 0x65, 0x73, 0x254, 0x3b, 0x6d, 0x61, 0x64, 0x3b, 0x64, 0x69, 0x14b, 0x3b, 0x6e, 0x79, 0x25b, 0x74,
0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x74, 0x69, 0x6e, 0x3b, 0x65, 0x6c, 0xe1, 0x3b, 0x64, 0x69, 0x6d, 0x254, 0x301, 0x64, 0x69,
0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x64, 0x25b, 0x3b, 0x73, 0x254, 0x14b, 0x25b, 0x3b, 0x64, 0x69, 0x253, 0xe1, 0x253, 0xe1, 0x3b,
0x65, 0x6d, 0x69, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x3b, 0x65, 0x73, 0x254, 0x70, 0x25b, 0x73, 0x254, 0x70, 0x25b, 0x3b, 0x6d,
0x61, 0x64, 0x69, 0x253, 0x25b, 0x301, 0x64, 0xed, 0x253, 0x25b, 0x301, 0x3b, 0x64, 0x69, 0x14b, 0x67, 0x69, 0x6e, 0x64, 0x69,
0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x25b, 0x6b, 0x69, 0x3b, 0x6d, 0x61, 0x79, 0xe9, 0x73, 0x25b, 0x301, 0x3b, 0x74, 0x69, 0x6e,
0xed, 0x6e, 0xed, 0x3b, 0x65, 0x6c, 0xe1, 0x14b, 0x67, 0x25b, 0x301, 0x3b, 0x64, 0x3b, 0x14b, 0x3b, 0x73, 0x3b, 0x64, 0x3b,
0x65, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x64, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x65, 0x3b, 0x53, 0x61, 0x3b, 0x46,
0x65, 0x3b, 0x4d, 0x61, 0x3b, 0x41, 0x62, 0x3b, 0x4d, 0x65, 0x3b, 0x53, 0x75, 0x3b, 0x53, 0xfa, 0x3b, 0x55, 0x74, 0x3b,
0x53, 0x65, 0x3b, 0x4f, 0x6b, 0x3b, 0x4e, 0x6f, 0x3b, 0x44, 0x65, 0x3b, 0x53, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x46,
0xe9, 0x62, 0x69, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x62, 0x75, 0x72, 0x69, 0x6c, 0x3b, 0x4d,
0x65, 0x65, 0x3b, 0x53, 0x75, 0x65, 0x14b, 0x3b, 0x53, 0xfa, 0x75, 0x79, 0x65, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65,
0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6e, 0x67,
0x6f, 0x3b, 0x6e, 0x67, 0x62, 0x3b, 0x6e, 0x67, 0x6c, 0x3b, 0x6e, 0x67, 0x6e, 0x3b, 0x6e, 0x67, 0x74, 0x3b, 0x6e, 0x67,
0x73, 0x3b, 0x6e, 0x67, 0x7a, 0x3b, 0x6e, 0x67, 0x6d, 0x3b, 0x6e, 0x67, 0x65, 0x3b, 0x6e, 0x67, 0x61, 0x3b, 0x6e, 0x67,
0x61, 0x64, 0x3b, 0x6e, 0x67, 0x61, 0x62, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6f, 0x73, 0xfa, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6c, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e,
0x20, 0x6e, 0x79, 0x69, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x74, 0xe1, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x73, 0x61, 0x6d, 0x259, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x7a, 0x61, 0x6d, 0x67, 0x62, 0xe1,
0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6d, 0x77, 0x6f, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x65, 0x62,
0x75, 0x6c, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61,
0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x64, 0x7a, 0x69, 0xe1, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3,
0x6d, 0x20, 0x61, 0x69, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6f, 0x3b, 0x62, 0x3b, 0x6c, 0x3b, 0x6e, 0x3b, 0x74, 0x3b, 0x73,
0x3b, 0x7a, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x14b, 0x31, 0x3b, 0x14b, 0x32, 0x3b, 0x14b,
0x33, 0x3b, 0x14b, 0x34, 0x3b, 0x14b, 0x35, 0x3b, 0x14b, 0x36, 0x3b, 0x14b, 0x37, 0x3b, 0x14b, 0x38, 0x3b, 0x14b, 0x39, 0x3b,
0x14b, 0x31, 0x30, 0x3b, 0x14b, 0x31, 0x31, 0x3b, 0x14b, 0x31, 0x32, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x20, 0x6e,
0x74, 0x254, 0x301, 0x6e, 0x74, 0x254, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x62, 0x25b, 0x301, 0x25b,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x72, 0xe1, 0xe1, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61,
0x6b, 0x1dd, 0x20, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x66, 0x254, 0x6b, 0x3b, 0x14b, 0x77, 0xed,
0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x62, 0x25b, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x72, 0x61, 0x61, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1,
0x61, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x3b, 0x14b,
0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x254, 0x301, 0x6b,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x25b,
0x301, 0x25b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x55, 0x6e, 0x61, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x43, 0x68, 0x65, 0x3b, 0x54,
0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x63, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b,
0x75, 0x6d, 0x3b, 0x4d, 0x6f, 0x6a, 0x3b, 0x59, 0x65, 0x6c, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20,
0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x61, 0x79,
0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x72, 0x61, 0x72, 0x75,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x63, 0x68, 0x65, 0x73, 0x68, 0x65, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x63, 0x68,
0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x6f, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74,
0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x79, 0x65, 0x6c,
0x2019, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x55, 0x3b, 0x52, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x4e, 0x3b,
0x54, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x46, 0x4c, 0x4f, 0x3b, 0x43, 0x4c, 0x41, 0x3b, 0x43, 0x4b, 0x49, 0x3b,
0x46, 0x4d, 0x46, 0x3b, 0x4d, 0x41, 0x44, 0x3b, 0x4d, 0x42, 0x49, 0x3b, 0x4d, 0x4c, 0x49, 0x3b, 0x4d, 0x41, 0x4d, 0x3b,
0x46, 0x44, 0x45, 0x3b, 0x46, 0x4d, 0x55, 0x3b, 0x46, 0x47, 0x57, 0x3b, 0x46, 0x59, 0x55, 0x3b, 0x46, 0x129, 0x69, 0x20,
0x4c, 0x6f, 0x6f, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x61, 0x14b, 0x6e, 0x65, 0x3b, 0x43, 0x6f, 0x6b,
0x63, 0x77, 0x61, 0x6b, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x61, 0x72, 0x66, 0x6f, 0x6f, 0x3b, 0x4d,
0x61, 0x64, 0x1dd, 0x1dd, 0x75, 0x75, 0x74, 0x1dd, 0x62, 0x69, 0x6a, 0x61, 0x14b, 0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67,
0x77, 0xe3, 0x61, 0x66, 0x61, 0x68, 0x62, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x6c,
0x69, 0x69, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x6d, 0x62, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x44, 0x1dd, 0x253, 0x6c,
0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x75, 0x6e, 0x64, 0x61, 0x14b, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x47, 0x77,
0x61, 0x68, 0x6c, 0x6c, 0x65, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x59, 0x75, 0x72, 0x75, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49,
0x3b, 0x46, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x6e,
0x67, 0x31, 0x3b, 0x6e, 0x67, 0x32, 0x3b, 0x6e, 0x67, 0x33, 0x3b, 0x6e, 0x67, 0x34, 0x3b, 0x6e, 0x67, 0x35, 0x3b, 0x6e,
0x67, 0x36, 0x3b, 0x6e, 0x67, 0x37, 0x3b, 0x6e, 0x67, 0x38, 0x3b, 0x6e, 0x67, 0x39, 0x3b, 0x6e, 0x67, 0x31, 0x30, 0x3b,
0x6e, 0x67, 0x31, 0x31, 0x3b, 0x6b, 0x72, 0x69, 0x73, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6d, 0x61, 0x74, 0xe1,
0x68, 0x72, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6d, 0x62, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e,
0x20, 0x144, 0x6c, 0x61, 0x6c, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b,
0x6e, 0x20, 0x144, 0x74, 0x61, 0x6e, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x75, 0xf3, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x68, 0x25b, 0x6d, 0x62, 0x75, 0x25b, 0x72, 0xed, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6c,
0x254, 0x6d, 0x62, 0x69, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x72, 0x25b, 0x62, 0x76, 0x75, 0xe2, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x20, 0x6e, 0x61,
0x76, 0x1d4, 0x72, 0x3b, 0x6b, 0x72, 0xed, 0x73, 0x69, 0x6d, 0x69, 0x6e, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x50, 0x25b,
0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x3b, 0x4b, 0x6f,
0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x54, 0x68, 0x6f, 0x6f, 0x3b, 0x54, 0x25b, 0x25b, 0x3b, 0x4c, 0x61, 0x61, 0x3b, 0x4b,
0x75, 0x72, 0x3b, 0x54, 0x69, 0x64, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x20, 0x74, 0x68, 0x61, 0x72, 0x20, 0x70, 0x25b, 0x74,
0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x14b, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75,
0xe4, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x6e, 0x79, 0x6f, 0x6f, 0x74, 0x3b, 0x50, 0x61, 0x79, 0x20, 0x79, 0x69, 0x65, 0x331,
0x74, 0x6e, 0x69, 0x3b, 0x54, 0x68, 0x6f, 0x331, 0x6f, 0x331, 0x72, 0x3b, 0x54, 0x25b, 0x25b, 0x72, 0x3b, 0x4c, 0x61, 0x61,
0x74, 0x68, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x6f, 0x331, 0x70, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x331, 0x69,
0x331, 0x74, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x54,
0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x3b, 0x41a, 0x43b, 0x43d,
0x3b, 0x41c, 0x441, 0x443, 0x3b, 0x42b, 0x430, 0x43c, 0x3b, 0x411, 0x44d, 0x441, 0x3b, 0x41e, 0x442, 0x439, 0x3b, 0x410, 0x442, 0x440,
0x3b, 0x411, 0x43b, 0x495, 0x3b, 0x410, 0x43b, 0x442, 0x3b, 0x421, 0x44d, 0x442, 0x3b, 0x410, 0x445, 0x441, 0x3b, 0x442, 0x43e, 0x445,
0x441, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x43e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x43a, 0x443, 0x43b, 0x443, 0x43d,
0x20, 0x442, 0x443, 0x442, 0x430, 0x440, 0x3b, 0x43c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x44b, 0x430,
0x43c, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x431, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x43e, 0x442, 0x20, 0x44b, 0x439, 0x430,
0x3b, 0x430, 0x442, 0x44b, 0x440, 0x434, 0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x431, 0x430, 0x43b, 0x430, 0x495, 0x430,
0x43d, 0x20, 0x44b, 0x439, 0x430, 0x3b, 0x430, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x441, 0x44d, 0x442, 0x438, 0x43d,
0x43d, 0x44c, 0x438, 0x3b, 0x430, 0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x422, 0x3b, 0x41e, 0x3b, 0x41a, 0x3b, 0x41c,
0x3b, 0x42b, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x410, 0x3b, 0x411, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x410, 0x3b, 0x422, 0x43e, 0x445,
0x441, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41a, 0x443, 0x43b, 0x443, 0x43d,
0x20, 0x442, 0x443, 0x442, 0x430, 0x440, 0x3b, 0x41c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x42b, 0x430,
0x43c, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x41e, 0x442, 0x20, 0x44b,
0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x442, 0x44b, 0x440, 0x434, 0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x430,
0x43b, 0x430, 0x495, 0x430, 0x43d, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b,
0x421, 0x44d, 0x442, 0x438, 0x43d, 0x43d, 0x44c, 0x438, 0x3b, 0x430, 0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x4d, 0x75,
0x70, 0x3b, 0x4d, 0x77, 0x69, 0x3b, 0x4d, 0x73, 0x68, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x67, 0x3b, 0x4d, 0x75,
0x6a, 0x3b, 0x4d, 0x73, 0x70, 0x3b, 0x4d, 0x70, 0x67, 0x3b, 0x4d, 0x79, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x4d, 0x75,
0x73, 0x3b, 0x4d, 0x75, 0x68, 0x3b, 0x4d, 0x75, 0x70, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x77, 0x61, 0x3b, 0x4d,
0x77, 0x69, 0x74, 0x6f, 0x70, 0x65, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x75, 0x6e, 0x79,
0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x67, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x75,
0x6a, 0x69, 0x6d, 0x62, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x69, 0x70, 0x65, 0x70, 0x6f, 0x3b, 0x4d, 0x75, 0x70, 0x75,
0x67, 0x75, 0x74, 0x6f, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x68, 0x75, 0x3b,
0x4d, 0x75, 0x73, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x6d, 0x62, 0x77, 0x65, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0xa5a8, 0xa595, 0xa51e, 0x3b, 0xa552, 0xa561, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595, 0x3b, 0xa591, 0xa571, 0x3b, 0xa5b1,
0xa60b, 0x3b, 0xa5b1, 0xa55e, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0x3b, 0xa5a8, 0xa595, 0xa5cf,
0x3b, 0xa5a8, 0xa595, 0x20, 0xa56a, 0xa574, 0x20, 0xa51e, 0xa500, 0xa56e, 0xa54a, 0x3b, 0xa552, 0xa561, 0xa59d, 0xa595, 0x3b, 0xa57e, 0xa5ba, 0x3b,
0xa5a2, 0xa595, 0x3b, 0xa591, 0xa571, 0x3b, 0xa5b1, 0xa60b, 0x3b, 0xa5b1, 0xa55e, 0xa524, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d,
0xa583, 0x3b, 0xa51e, 0xa60b, 0xa554, 0xa57f, 0x20, 0xa578, 0xa583, 0xa5cf, 0x3b, 0xa5a8, 0xa595, 0x20, 0xa56a, 0xa574, 0x20, 0xa5cf, 0xa5ba, 0xa56e,
0xa54a, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20, 0x6b, 0x65, 0x6d, 0xe3, 0x3b, 0x253, 0x61, 0x6e, 0x64, 0x61, 0x253,
0x75, 0x3b, 0x76, 0x254, 0x254, 0x3b, 0x66, 0x75, 0x6c, 0x75, 0x3b, 0x67, 0x6f, 0x6f, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x6b,
0x254, 0x6e, 0x64, 0x65, 0x3b, 0x73, 0x61, 0x61, 0x68, 0x3b, 0x67, 0x61, 0x6c, 0x6f, 0x3b, 0x6b, 0x65, 0x6e, 0x70, 0x6b,
0x61, 0x74, 0x6f, 0x20, 0x253, 0x6f, 0x6c, 0x6f, 0x6c, 0x254, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20, 0x6c, 0x254,
0x6d, 0x61, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x48, 0x6f, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x42, 0x72, 0xe1, 0x3b, 0x48, 0x65, 0x69, 0x3b, 0xd6, 0x69, 0x67, 0x3b, 0x48, 0x65, 0x72, 0x3b, 0x57,
0xed, 0x6d, 0x3b, 0x57, 0x69, 0x6e, 0x3b, 0x43, 0x68, 0x72, 0x3b, 0x4a, 0x65, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x48, 0x6f,
0x72, 0x6e, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x65, 0x3b, 0x4d,
0x65, 0x69, 0x6a, 0x65, 0x3b, 0x42, 0x72, 0xe1, 0x10d, 0x65, 0x74, 0x3b, 0x48, 0x65, 0x69, 0x77, 0x65, 0x74, 0x3b, 0xd6,
0x69, 0x67, 0x161, 0x74, 0x65, 0x3b, 0x48, 0x65, 0x72, 0x62, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0xed,
0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x43, 0x68,
0x72, 0x69, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x42, 0x3b, 0x48, 0x3b, 0xd6, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x43, 0x3b, 0x6f, 0x2e, 0x31, 0x3b, 0x6f, 0x2e,
0x32, 0x3b, 0x6f, 0x2e, 0x33, 0x3b, 0x6f, 0x2e, 0x34, 0x3b, 0x6f, 0x2e, 0x35, 0x3b, 0x6f, 0x2e, 0x36, 0x3b, 0x6f, 0x2e,
0x37, 0x3b, 0x6f, 0x2e, 0x38, 0x3b, 0x6f, 0x2e, 0x39, 0x3b, 0x6f, 0x2e, 0x31, 0x30, 0x3b, 0x6f, 0x2e, 0x31, 0x31, 0x3b,
0x6f, 0x2e, 0x31, 0x32, 0x3b, 0x70, 0x69, 0x6b, 0xed, 0x74, 0xed, 0x6b, 0xed, 0x74, 0x69, 0x65, 0x2c, 0x20, 0x6f, 0xf3,
0x6c, 0xed, 0x20, 0xfa, 0x20, 0x6b, 0x75, 0x74, 0xfa, 0x61, 0x6e, 0x3b, 0x73, 0x69, 0x25b, 0x79, 0x25b, 0x301, 0x2c, 0x20,
0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x6e, 0x64, 0xed, 0x25b, 0x3b, 0x254, 0x6e, 0x73, 0xfa, 0x6d, 0x62,
0x254, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x74, 0xfa, 0x25b, 0x3b, 0x6d,
0x65, 0x73, 0x69, 0x14b, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe9, 0x6e, 0x69, 0x65, 0x3b, 0x65,
0x6e, 0x73, 0x69, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x6e, 0x75, 0x25b,
0x3b, 0x254, 0x73, 0x254, 0x6e, 0x3b, 0x65, 0x66, 0x75, 0x74, 0x65, 0x3b, 0x70, 0x69, 0x73, 0x75, 0x79, 0xfa, 0x3b, 0x69,
0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x254, 0x73, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75,
0x74, 0xfa, 0x6b, 0x2c, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xed, 0x25b, 0x3b, 0x6d, 0x61, 0x6b,
0x61, 0x6e, 0x64, 0x69, 0x6b, 0x25b, 0x3b, 0x70, 0x69, 0x6c, 0x254, 0x6e, 0x64, 0x254, 0x301, 0x3b, 0x58, 0x69, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x58, 0x75, 0x6e, 0x3b,
0x58, 0x6e, 0x74, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x63, 0x68, 0x3b, 0x50, 0x61, 0x79, 0x3b,
0x41, 0x76, 0x69, 0x3b, 0x78, 0x69, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x6d,
0x61, 0x72, 0x7a, 0x75, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x78, 0x75, 0x6e, 0x75,
0x3b, 0x78, 0x75, 0x6e, 0x65, 0x74, 0x75, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x73, 0x65, 0x74, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x68, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73,
0x3b, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58,
0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x78, 0x69, 0x6e, 0x3b, 0x66, 0x65, 0x62,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x78, 0x75, 0x6e, 0x3b, 0x78, 0x6e, 0x74,
0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x63, 0x68, 0x3b, 0x70, 0x61, 0x79, 0x3b, 0x61, 0x76, 0x69,
0x3b, 0x64, 0x65, 0x20, 0x78, 0x69, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72,
0x75, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64,
0x65, 0x20, 0x6d, 0x61, 0x79, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x75, 0x6e, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x78, 0x75,
0x6e, 0x65, 0x74, 0x75, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74,
0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x2019, 0x6f, 0x63, 0x68, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20,
0x70, 0x61, 0x79, 0x61, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x2019, 0x61, 0x76, 0x69, 0x65, 0x6e, 0x74, 0x75, 0x3b, 0x4e, 0x64,
0x75, 0x14b, 0x6d, 0x62, 0x69, 0x20, 0x53, 0x61, 0x14b, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x70,
0xe1, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x74, 0xe1, 0x74, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b,
0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6b, 0x77, 0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x61, 0x74,
0x61, 0x61, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x6e, 0x74, 0xfa, 0x6b, 0xfa,
0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x53, 0x61, 0x61, 0x6d, 0x62, 0xe1, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20,
0x50, 0x25b, 0x301, 0x6e, 0x25b, 0x301, 0x66, 0x254, 0x6d, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x50, 0x25b, 0x301, 0x6e,
0x25b, 0x301, 0x70, 0x66, 0xfa, 0xa78b, 0xfa, 0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x25b, 0x67, 0x25b, 0x301, 0x6d,
0x3b, 0x50, 0x25b, 0x73, 0x61, 0x14b, 0x20, 0x4e, 0x74, 0x73, 0x254, 0x30c, 0x70, 0x6d, 0x254, 0x301, 0x3b, 0x50, 0x25b, 0x73,
0x61, 0x14b, 0x20, 0x4e, 0x74, 0x73, 0x254, 0x30c, 0x70, 0x70, 0xe1, 0x3b, 0x70, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x77, 0x61,
0x6e, 0x6a, 0x61, 0x3b, 0x6d, 0x62, 0x69, 0x79, 0x254, 0x20, 0x6d, 0x25b, 0x6e, 0x64, 0x6f, 0x14b, 0x67, 0x254, 0x3b, 0x4e,
0x79, 0x254, 0x6c, 0x254, 0x6d, 0x62, 0x254, 0x14b, 0x67, 0x254, 0x3b, 0x4d, 0x254, 0x6e, 0x254, 0x20, 0x14b, 0x67, 0x62, 0x61,
0x6e, 0x6a, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x14b, 0x67, 0x77, 0x25b, 0x20, 0x14b, 0x67, 0x62, 0x61, 0x6e, 0x6a, 0x61, 0x3b,
0x6b, 0x75, 0x14b, 0x67, 0x77, 0x25b, 0x3b, 0x66, 0x25b, 0x3b, 0x6e, 0x6a, 0x61, 0x70, 0x69, 0x3b, 0x6e, 0x79, 0x75, 0x6b,
0x75, 0x6c, 0x3b, 0x31, 0x31, 0x3b, 0x253, 0x75, 0x6c, 0x253, 0x75, 0x73, 0x25b, 0x3b, 0x6d, 0x62, 0x65, 0x67, 0x74, 0x75,
0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0xe0, 0x62, 0xf9, 0x62, 0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0x6d, 0x62,
0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300, 0x74, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f, 0x67, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x69, 0x62,
0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0xe0, 0x64, 0xf9, 0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69, 0x6d, 0x259,
0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b, 0x61, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b, 0x69, 0x6d,
0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69, 0x2bc, 0x65, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b, 0x69, 0x6d,
0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a, 0x6d, 0x65, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6d, 0x62, 0x65, 0x67,
0x74, 0x75, 0x67, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20, 0xe0, 0x62, 0xf9, 0x62, 0xec, 0x3b, 0x69, 0x6d, 0x65, 0x67, 0x20,
0x6d, 0x62, 0x259, 0x14b, 0x63, 0x68, 0x75, 0x62, 0x69, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6e, 0x67, 0x77, 0x259, 0x300,
0x74, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x66, 0x6f, 0x67, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69,
0x69, 0x62, 0x254, 0x64, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0xe0, 0x64, 0xf9, 0x6d, 0x62, 0x259, 0x300, 0x14b, 0x3b, 0x69,
0x6d, 0x259, 0x67, 0x20, 0x69, 0x63, 0x68, 0x69, 0x6b, 0x61, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x75, 0x64, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x74, 0xe8, 0x73, 0x69, 0x2bc, 0x65, 0x3b, 0x69, 0x6d, 0x259, 0x67, 0x20, 0x7a, 0xf2, 0x3b,
0x69, 0x6d, 0x259, 0x67, 0x20, 0x6b, 0x72, 0x69, 0x7a, 0x6d, 0x65, 0x64, 0x3b, 0x4d, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x4d,
0x33, 0x3b, 0x4e, 0x34, 0x3b, 0x46, 0x35, 0x3b, 0x49, 0x36, 0x3b, 0x41, 0x37, 0x3b, 0x49, 0x38, 0x3b, 0x4b, 0x39, 0x3b,
0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0x25b, 0x300,
0x25b, 0x20, 0x6c, 0xf9, 0x6d, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6b, 0xe0, 0x67, 0x20, 0x6e, 0x67, 0x77, 0xf3, 0x14b, 0x3b,
0x73, 0x61, 0x14b, 0x20, 0x6c, 0x65, 0x70, 0x79, 0xe8, 0x20, 0x73, 0x68, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x63,
0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x63, 0xff, 0xf3, 0x3b, 0x73, 0x61, 0x14b,
0x20, 0x6e, 0x6a, 0xff, 0x6f, 0x6c, 0xe1, 0x2bc, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x74, 0x79, 0x25b, 0x300, 0x62, 0x20, 0x74,
0x79, 0x25b, 0x300, 0x62, 0x20, 0x6d, 0x62, 0x289, 0x300, 0x14b, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6d, 0x62, 0x289, 0x300, 0x14b,
0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6e, 0x67, 0x77, 0x254, 0x300, 0x2bc, 0x20, 0x6d, 0x62, 0xff, 0x25b, 0x3b, 0x73, 0x61, 0x14b,
0x20, 0x74, 0xe0, 0x14b, 0x61, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0xe1, 0x2bc, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6d, 0x65,
0x6a, 0x77, 0x6f, 0x14b, 0xf3, 0x3b, 0x73, 0x61, 0x14b, 0x20, 0x6c, 0xf9, 0x6d, 0x3b, 0x57, 0x69, 0xf3, 0x74, 0x68, 0x65,
0x21f, 0x69, 0x6b, 0x61, 0x20, 0x57, 0xed, 0x3b, 0x54, 0x68, 0x69, 0x79, 0xf3, 0x21f, 0x65, 0x79, 0x75, 0x14b, 0x6b, 0x61,
0x20, 0x57, 0xed, 0x3b, 0x49, 0x161, 0x74, 0xe1, 0x77, 0x69, 0x10d, 0x68, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x14b, 0x20, 0x57,
0xed, 0x3b, 0x50, 0x21f, 0x65, 0x17e, 0xed, 0x74, 0x21f, 0x6f, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1,
0x70, 0x65, 0x74, 0x21f, 0x6f, 0x20, 0x57, 0xed, 0x3b, 0x57, 0xed, 0x70, 0x61, 0x7a, 0x75, 0x6b, 0x21f, 0x61, 0x2d, 0x77,
0x61, 0x161, 0x74, 0xe9, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x70, 0x21f, 0xe1, 0x73, 0x61, 0x70, 0x61, 0x20,
0x57, 0xed, 0x3b, 0x57, 0x61, 0x73, 0xfa, 0x74, 0x21f, 0x75, 0x14b, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77,
0xe1, 0x70, 0x65, 0x1e7, 0x69, 0x20, 0x57, 0xed, 0x3b, 0x10c, 0x68, 0x61, 0x14b, 0x77, 0xe1, 0x70, 0x65, 0x2d, 0x6b, 0x61,
0x73, 0x6e, 0xe1, 0x20, 0x57, 0xed, 0x3b, 0x57, 0x61, 0x6e, 0xed, 0x79, 0x65, 0x74, 0x75, 0x20, 0x57, 0xed, 0x3b, 0x54,
0x21f, 0x61, 0x68, 0xe9, 0x6b, 0x61, 0x70, 0x161, 0x75, 0x14b, 0x20, 0x57, 0xed, 0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x648, 0x646,
0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x634, 0x648, 0x628, 0x627, 0x62a, 0x3b, 0x626, 0x627, 0x632, 0x627, 0x631, 0x3b,
0x646, 0x6cc, 0x633, 0x627, 0x646, 0x3b, 0x626, 0x627, 0x6cc, 0x627, 0x631, 0x3b, 0x62d, 0x648, 0x632, 0x6d5, 0x6cc, 0x631, 0x627, 0x646,
0x3b, 0x62a, 0x6d5, 0x645, 0x648, 0x648, 0x632, 0x3b, 0x626, 0x627, 0x628, 0x3b, 0x626, 0x6d5, 0x6cc, 0x644, 0x648, 0x648, 0x644, 0x3b,
0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20,
0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x6a9,
0x3b, 0x634, 0x3b, 0x626, 0x3b, 0x646, 0x3b, 0x626, 0x3b, 0x62d, 0x3b, 0x62a, 0x3b, 0x626, 0x3b, 0x626, 0x3b, 0x62a, 0x3b, 0x62a,
0x3b, 0x6a9, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x3b, 0x6d, 0x61, 0x6a,
0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f,
0x77, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x2e,
0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x77, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e,
0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b, 0x61,
0x70, 0x72, 0x79, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a, 0x75,
0x6c, 0x69, 0x6a, 0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b,
0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x11b, 0x72,
0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x65, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x77, 0x67,
0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x11b, 0x72, 0x63, 0x3b, 0x61, 0x70, 0x72,
0x79, 0x6c, 0x3b, 0x6d, 0x65, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b,
0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x77, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x11b, 0x72, 0x2e, 0x3b, 0x61, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x6a, 0x2e, 0x3b, 0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x77,
0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x77, 0x2e, 0x3b, 0x64, 0x65,
0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x61, 0x3b,
0x6d, 0x11b, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0x79, 0x6c, 0x61, 0x3b, 0x6d, 0x65, 0x6a, 0x65, 0x3b, 0x6a, 0x75,
0x6e, 0x69, 0x6a, 0x61, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x61, 0x3b, 0x61, 0x77, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f,
0x77, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x72, 0x61, 0x67, 0x3b,
0x77, 0x61, 0x73, 0x3b, 0x70, 0x16b, 0x6c, 0x3b, 0x73, 0x61, 0x6b, 0x3b, 0x7a, 0x61, 0x6c, 0x3b, 0x73, 0x12b, 0x6d, 0x3b,
0x6c, 0x12b, 0x70, 0x3b, 0x64, 0x61, 0x67, 0x3b, 0x73, 0x69, 0x6c, 0x3b, 0x73, 0x70, 0x61, 0x3b, 0x6c, 0x61, 0x70, 0x3b,
0x73, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x67, 0x73, 0x3b, 0x77, 0x61, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6e, 0x73, 0x3b, 0x70,
0x16b, 0x6c, 0x69, 0x73, 0x3b, 0x73, 0x61, 0x6b, 0x6b, 0x69, 0x73, 0x3b, 0x7a, 0x61, 0x6c, 0x6c, 0x61, 0x77, 0x73, 0x3b,
0x73, 0x12b, 0x6d, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x6c, 0x12b, 0x70, 0x61, 0x3b, 0x64, 0x61, 0x67, 0x67, 0x69, 0x73, 0x3b,
0x73, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x73, 0x3b, 0x73, 0x70, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x73, 0x3b, 0x6c, 0x61, 0x70,
0x6b, 0x72, 0x16b, 0x74, 0x69, 0x73, 0x3b, 0x73, 0x61, 0x6c, 0x6c, 0x61, 0x77, 0x73, 0x3b, 0x52, 0x3b, 0x57, 0x3b, 0x50,
0x3b, 0x53, 0x3b, 0x5a, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x75,
0x111, 0x69, 0x76, 0x3b, 0x6b, 0x75, 0x6f, 0x76, 0xe2, 0x3b, 0x6e, 0x6a, 0x75, 0x68, 0x10d, 0xe2, 0x3b, 0x63, 0x75, 0xe1,
0x14b, 0x75, 0x69, 0x3b, 0x76, 0x79, 0x65, 0x73, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x69, 0x3b, 0x73, 0x79, 0x65, 0x69, 0x6e,
0x69, 0x3b, 0x70, 0x6f, 0x72, 0x67, 0x65, 0x3b, 0x10d, 0x6f, 0x68, 0x10d, 0xe2, 0x3b, 0x72, 0x6f, 0x6f, 0x76, 0x76, 0xe2,
0x64, 0x3b, 0x73, 0x6b, 0x61, 0x6d, 0x6d, 0xe2, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0xe2, 0x3b, 0x75, 0x111, 0x111, 0xe2,
0x69, 0x76, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6b, 0x75, 0x6f, 0x76, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b,
0x6e, 0x6a, 0x75, 0x68, 0x10d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x63, 0x75, 0xe1, 0x14b, 0x75, 0x69, 0x6d, 0xe1,
0xe1, 0x6e, 0x75, 0x3b, 0x76, 0x79, 0x65, 0x73, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x6b, 0x65, 0x73, 0x69, 0x6d,
0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x79, 0x65, 0x69, 0x6e, 0x69, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x70, 0x6f, 0x72,
0x67, 0x65, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x10d, 0x6f, 0x68, 0x10d, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x72,
0x6f, 0x6f, 0x76, 0x76, 0xe2, 0x64, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x73, 0x6b, 0x61, 0x6d, 0x6d, 0xe2, 0x6d, 0xe1,
0xe1, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0xe2, 0x6d, 0xe1, 0xe1, 0x6e, 0x75, 0x3b, 0x55, 0x3b, 0x4b, 0x3b,
0x4e, 0x4a, 0x3b, 0x43, 0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x10c, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4a,
0x3b, 0x62c, 0x627, 0x646, 0x6a4, 0x6cc, 0x6d5, 0x3b, 0x641, 0x626, 0x6a4, 0x631, 0x6cc, 0x6d5, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b,
0x622, 0x6a4, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x6cc, 0x3b, 0x62c, 0x648, 0x659, 0x623, 0x646, 0x3b, 0x62c, 0x648, 0x659, 0x644,
0x627, 0x3b, 0x622, 0x6af, 0x648, 0x633, 0x62a, 0x3b, 0x633, 0x626, 0x67e, 0x62a, 0x627, 0x645, 0x631, 0x3b, 0x626, 0x648, 0x6a9, 0x62a,
0x648, 0x6a4, 0x631, 0x3b, 0x646, 0x648, 0x6a4, 0x627, 0x645, 0x631, 0x3b, 0x62f, 0x626, 0x633, 0x627, 0x645, 0x631, 0x3b
};

static const ushort days_data[] = {
0x53, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b,
0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61,
0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b,
0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75,
0x72, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x37,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78,
0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e,
0x3b, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69, 0x69, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x69, 0x62,
0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b,
0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x44, 0x3b, 0x57, 0x3b,
0x51, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69,
0x2e, 0x3b, 0x57, 0x6f, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x56, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x6f,
0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67,
0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b,
0x56, 0x72, 0x79, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b,
0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d, 0x61,
0x72, 0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45, 0x6e, 0x6a, 0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x45, 0x20,
0x64, 0x69, 0x65, 0x6c, 0x3b, 0x45, 0x20, 0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x45, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b,
0x45, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x3b, 0x45, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x45, 0x20,
0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x45, 0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x44, 0x3b, 0x48, 0x3b,
0x4d, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x53, 0x68, 0x3b, 0x65, 0x20, 0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20,
0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75,
0x72, 0xeb, 0x3b, 0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b,
0x65, 0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b,
0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b,
0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x129e, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b,
0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x3b, 0x1230, 0x3b, 0x121b, 0x3b, 0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x3b, 0x627, 0x644,
0x623, 0x62d, 0x62f, 0x3b, 0x627, 0x644, 0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621,
0x3b, 0x627, 0x644, 0x623, 0x631, 0x628, 0x639, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c,
0x645, 0x639, 0x629, 0x3b, 0x627, 0x644, 0x633, 0x628, 0x62a, 0x3b, 0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b,
0x62c, 0x3b, 0x633, 0x3b, 0x56f, 0x56b, 0x580, 0x3b, 0x565, 0x580, 0x56f, 0x3b, 0x565, 0x580, 0x584, 0x3b, 0x579, 0x580, 0x584, 0x3b,
0x570, 0x576, 0x563, 0x3b, 0x578, 0x582, 0x580, 0x3b, 0x577, 0x562, 0x569, 0x3b, 0x56f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x565,
0x580, 0x56f, 0x578, 0x582, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x565, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b,
0x579, 0x578, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x570, 0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b,
0x3b, 0x578, 0x582, 0x580, 0x562, 0x561, 0x569, 0x3b, 0x577, 0x561, 0x562, 0x561, 0x569, 0x3b, 0x53f, 0x3b, 0x535, 0x3b, 0x535, 0x3b,
0x549, 0x3b, 0x540, 0x3b, 0x548, 0x3b, 0x547, 0x3b, 0x9a6, 0x9c7, 0x993, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997,
0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b,
0x9a6, 0x9c7, 0x993, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac,
0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be,
0x9f0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9a6, 0x3b,
0x9b8, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x3b, 0x9ac, 0x3b, 0x9b6, 0x3b, 0x9b6, 0x3b, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x45, 0x2e, 0x3b,
0xc7, 0x2e, 0x41, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e, 0x41, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x3b, 0x62,
0x61, 0x7a, 0x61, 0x72, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x20, 0x65, 0x72, 0x74, 0x259, 0x73, 0x69, 0x3b, 0xe7, 0x259,
0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e,
0x62, 0x259, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x3b,
0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x411, 0x2e, 0x3b, 0x411, 0x2e, 0x415, 0x2e, 0x3b, 0x427, 0x2e, 0x410, 0x2e, 0x3b, 0x427,
0x2e, 0x3b, 0x4b8, 0x2e, 0x410, 0x2e, 0x3b, 0x4b8, 0x2e, 0x3b, 0x428, 0x2e, 0x3b, 0x431, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x431,
0x430, 0x437, 0x430, 0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9,
0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x4b9, 0x4af, 0x43c,
0x4d9, 0x20, 0x430, 0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b,
0x69, 0x67, 0x2e, 0x3b, 0x61, 0x6c, 0x2e, 0x3b, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x2e, 0x3b, 0x6f, 0x67, 0x2e, 0x3b,
0x6f, 0x72, 0x2e, 0x3b, 0x6c, 0x72, 0x2e, 0x3b, 0x49, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x41, 0x73, 0x74, 0x65,
0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x41, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x41, 0x73, 0x74,
0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x73, 0x74,
0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x49, 0x3b, 0x41, 0x3b,
0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x4c, 0x3b, 0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x73,
0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x61,
0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x6f,
0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x6c, 0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x9b0, 0x9ac,
0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8,
0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1,
0x9a7, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995,
0x9cd, 0x9b0, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b,
0x9ac, 0x9c1, 0x3b, 0x9ac, 0x9c3, 0x3b, 0x9b6, 0x9c1, 0x3b, 0x9b6, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb,
0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0,
0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7,
0xf42, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49,
0xf72, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42,
0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58,
0xf0b, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf62, 0x3b, 0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xfb6,
0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0xf49, 0xf72, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75,
0x2e, 0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x59, 0x61, 0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x64,
0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72,
0x63, 0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61, 0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61,
0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x3b, 0x4c, 0x3b, 0x4d, 0x7a, 0x3b, 0x4d, 0x63, 0x3b, 0x59, 0x3b, 0x47, 0x3b,
0x53, 0x61, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442,
0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438,
0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432,
0x44a, 0x440, 0x442, 0x44a, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d,
0x3b, 0x43f, 0x3b, 0x432, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014,
0x103d, 0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c, 0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f,
0x1012, 0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c, 0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000,
0x103c, 0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x3b, 0x1010, 0x3b, 0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005,
0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430, 0x45e, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b, 0x441,
0x431, 0x3b, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430, 0x43a,
0x3b, 0x430, 0x45e, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446, 0x432,
0x435, 0x440, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x456, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b,
0x43f, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b,
0x1785, 0x17d0, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a,
0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x17a2,
0x3b, 0x1785, 0x3b, 0x17a2, 0x3b, 0x1796, 0x3b, 0x1796, 0x3b, 0x179f, 0x3b, 0x179f, 0x3b, 0x64, 0x67, 0x2e, 0x3b, 0x64, 0x6c, 0x2e,
0x3b, 0x64, 0x74, 0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64, 0x6a, 0x2e, 0x3b, 0x64, 0x76, 0x2e, 0x3b, 0x64, 0x73, 0x2e,
0x3b, 0x64, 0x69, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69, 0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69,
0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65, 0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75,
0x73, 0x3b, 0x64, 0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65,
0x3b, 0x64, 0x67, 0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b, 0x64, 0x63, 0x3b, 0x64, 0x6a, 0x3b, 0x64, 0x76, 0x3b, 0x64,
0x73, 0x3b, 0x5468, 0x65e5, 0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c, 0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94, 0x3b,
0x5468, 0x516d, 0x3b, 0x661f, 0x671f, 0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00, 0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b, 0x661f,
0x671f, 0x56db, 0x3b, 0x661f, 0x671f, 0x4e94, 0x3b, 0x661f, 0x671f, 0x516d, 0x3b, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b, 0x56db,
0x3b, 0x4e94, 0x3b, 0x516d, 0x3b, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00, 0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09, 0x3b, 0x9031, 0x56db, 0x3b,
0x9031, 0x4e94, 0x3b, 0x9031, 0x516d, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72,
0x69, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c,
0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61,
0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70,
0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b,
0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x3b,
0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0xfa, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73, 0x6f,
0x3b, 0x6e, 0x65, 0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x11b, 0x6c, 0xed, 0x3b, 0xfa, 0x74, 0x65, 0x72,
0xfd, 0x3b, 0x73, 0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x74, 0x76, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0xe1, 0x74,
0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0xda, 0x3b, 0x53, 0x3b, 0x10c, 0x3b,
0x50, 0x3b, 0x53, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0x61, 0x6e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6f, 0x6e, 0x73, 0x3b,
0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf8, 0x72, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d,
0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67,
0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72, 0x64,
0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73, 0xf8, 0x6e,
0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x2e, 0x3b, 0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72,
0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72, 0x2e, 0x3b, 0x7a, 0x6f, 0x3b, 0x6d, 0x61, 0x3b, 0x64, 0x69,
0x3b, 0x77, 0x6f, 0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72, 0x3b, 0x7a, 0x61, 0x3b, 0x7a, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b,
0x6d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x77, 0x6f, 0x65, 0x6e,
0x73, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x76, 0x72, 0x69, 0x6a, 0x64,
0x61, 0x67, 0x3b, 0x7a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b,
0x44, 0x3b, 0x56, 0x3b, 0x5a, 0x3b, 0x53, 0x75, 0x6e, 0x2e, 0x3b, 0x4d, 0x6f, 0x6e, 0x2e, 0x3b, 0x54, 0x75, 0x65, 0x2e,
0x3b, 0x57, 0x65, 0x64, 0x2e, 0x3b, 0x54, 0x68, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x69, 0x2e, 0x3b, 0x53, 0x61, 0x74, 0x2e,
0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x2e, 0x3b, 0x54, 0x75, 0x2e, 0x3b, 0x57, 0x2e, 0x3b, 0x54, 0x68, 0x2e, 0x3b, 0x46,
0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x135, 0x61,
0x3b, 0x76, 0x65, 0x3b, 0x73, 0x61, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x109, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x6f,
0x3b, 0x6d, 0x61, 0x72, 0x64, 0x6f, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x135, 0x61, 0x16d, 0x64,
0x6f, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x44, 0x3b,
0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x134, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x4b, 0x3b,
0x4e, 0x3b, 0x52, 0x3b, 0x4c, 0x3b, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65, 0x73, 0x6d, 0x61, 0x73,
0x70, 0xe4, 0x65, 0x76, 0x3b, 0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x6f, 0x6c, 0x6d, 0x61,
0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72, 0x65, 0x65, 0x64, 0x65,
0x3b, 0x6c, 0x61, 0x75, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0x74, 0xfd, 0x73,
0x3b, 0x6d, 0x69, 0x6b, 0x3b, 0x68, 0xf3, 0x73, 0x3b, 0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79, 0x3b, 0x73, 0x75, 0x6e,
0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x74, 0xfd,
0x73, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x68, 0xf3, 0x73,
0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x72, 0xed, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c,
0x65, 0x79, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x48,
0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0x74, 0xfd, 0x73, 0x2e, 0x3b,
0x6d, 0x69, 0x6b, 0x2e, 0x3b, 0x68, 0xf3, 0x73, 0x2e, 0x3b, 0x66, 0x72, 0xed, 0x2e, 0x3b, 0x6c, 0x65, 0x79, 0x2e, 0x3b,
0x73, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c, 0x61,
0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f,
0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c,
0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b,
0x4c, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e,
0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b,
0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b,
0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x6e, 0x61, 0x3b, 0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65,
0x72, 0x2e, 0x3b, 0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x3b, 0x64, 0x69,
0x6d, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d,
0x65, 0x72, 0x63, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65, 0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65,
0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b,
0x56, 0x3b, 0x53, 0x3b, 0x73, 0x69, 0x3b, 0x6d, 0x6f, 0x3b, 0x74, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x74, 0x6f, 0x3b, 0x66,
0x72, 0x3b, 0x73, 0x6f, 0x3b, 0x73, 0x6e, 0x65, 0x69, 0x6e, 0x3b, 0x6d, 0x6f, 0x61, 0x6e, 0x64, 0x65, 0x69, 0x3b, 0x74,
0x69, 0x69, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x77, 0x6f, 0x61, 0x6e, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x6f, 0x6e, 0x67,
0x65, 0x72, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x66, 0x72, 0x65, 0x65, 0x64, 0x3b, 0x73, 0x6e, 0x65, 0x6f, 0x6e, 0x3b, 0x44,
0x69, 0x44, 0x3b, 0x44, 0x69, 0x4c, 0x3b, 0x44, 0x69, 0x4d, 0x3b, 0x44, 0x69, 0x43, 0x3b, 0x44, 0x69, 0x61, 0x3b, 0x44,
0x69, 0x68, 0x3b, 0x44, 0x69, 0x53, 0x3b, 0x44, 0x69, 0x44, 0xf2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x3b, 0x44,
0x69, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x4d, 0xe0, 0x69, 0x72, 0x74, 0x3b, 0x44, 0x69, 0x43, 0x69, 0x61,
0x64, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x61, 0x72, 0x44, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x68, 0x41, 0x6f,
0x69, 0x6e, 0x65, 0x3b, 0x44, 0x69, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x65, 0x3b, 0x44, 0x3b, 0x4c, 0x3b,
0x4d, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b,
0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x4d, 0xe9, 0x72, 0x2e, 0x3b, 0x58, 0x6f, 0x76, 0x2e, 0x3b, 0x56, 0x65, 0x6e, 0x2e, 0x3b,
0x53, 0xe1, 0x62, 0x2e, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61,
0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73, 0x3b,
0x56, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b,
0x4d, 0x3b, 0x58, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61,
0x72, 0x2e, 0x3b, 0x6d, 0xe9, 0x72, 0x2e, 0x3b, 0x78, 0x6f, 0x76, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0xe1,
0x62, 0x2e, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74,
0x65, 0x73, 0x3b, 0x6d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x78, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x65,
0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x64, 0x2e, 0x3b, 0x6c, 0x2e, 0x3b, 0x6d, 0x2e,
0x3b, 0x6d, 0x2e, 0x3b, 0x78, 0x2e, 0x3b, 0x76, 0x2e, 0x3b, 0x73, 0x2e, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x3b, 0x10dd, 0x10e0, 0x10e8,
0x3b, 0x10e1, 0x10d0, 0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x3b, 0x10e8, 0x10d0, 0x10d1,
0x3b, 0x10d9, 0x10d5, 0x10d8, 0x10e0, 0x10d0, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x10e8,
0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x10e8,
0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4, 0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x10d0,
0x10d7, 0x10d8, 0x3b, 0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b, 0x10de, 0x3b, 0x10e8, 0x3b, 0x53, 0x6f, 0x3b,
0x4d, 0x6f, 0x3b, 0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53, 0x6f,
0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x65, 0x6e, 0x73, 0x74, 0x61,
0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x61,
0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b,
0x4d, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b,
0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b,
0x39a, 0x3c5, 0x3c1, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3b,
0x3a0, 0x3b1, 0x3c1, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3c4,
0x3ad, 0x3c1, 0x3b1, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3ad,
0x3bc, 0x3c0, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b2, 0x3b1,
0x3c4, 0x3bf, 0x3b, 0x39a, 0x3b, 0x394, 0x3b, 0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0x3b, 0x73, 0x61, 0x62,
0x3b, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x69, 0x6e, 0x3b, 0x73, 0x69, 0x73, 0x3b, 0x74, 0x61, 0x6c,
0x3b, 0x61, 0x72, 0x66, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x61, 0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e, 0x6e,
0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71,
0x3b, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69, 0x73,
0x61, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61, 0x6e,
0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e,
0x65, 0x71, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0xab0, 0xab5, 0xabf,
0x3b, 0xab8, 0xacb, 0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0x3b, 0xaac, 0xac1, 0xaa7, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b, 0xab6,
0xac1, 0xa95, 0xacd, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0x3b, 0xab0, 0xab5, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae, 0xab5,
0xabe, 0xab0, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0, 0x3b, 0xaac, 0xac1, 0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97, 0xac1,
0xab0, 0xac1, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5, 0xabe,
0xab0, 0x3b, 0xab0, 0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b, 0xaac, 0xac1, 0x3b, 0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b, 0xab6,
0x3b, 0x4c, 0x61, 0x68, 0x3b, 0x4c, 0x69, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x68,
0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x4c, 0x69, 0x74, 0x69,
0x6e, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x41, 0x6c,
0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x6d, 0x61, 0x2bc, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72,
0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d0,
0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d1, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20,
0x5d3, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d4, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5d1, 0x5ea,
0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d0, 0x5e9, 0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5e0, 0x5d9, 0x3b, 0x5d9,
0x5d5, 0x5dd, 0x20, 0x5e9, 0x5dc, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x5d9, 0x3b, 0x5d9,
0x5d5, 0x5dd, 0x20, 0x5d7, 0x5de, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5,
0x5dd, 0x20, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d0, 0x5f3, 0x3b, 0x5d1, 0x5f3, 0x3b, 0x5d2, 0x5f3, 0x3b, 0x5d3, 0x5f3, 0x3b, 0x5d4, 0x5f3,
0x3b, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5f3, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b,
0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930,
0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930,
0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d,
0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b,
0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65,
0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0xe1, 0x72, 0x6e, 0x61, 0x70, 0x3b, 0x68,
0xe9, 0x74, 0x66, 0x151, 0x3b, 0x6b, 0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72, 0x64, 0x61, 0x3b, 0x63, 0x73, 0xfc,
0x74, 0xf6, 0x72, 0x74, 0xf6, 0x6b, 0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x7a, 0x6f, 0x6d, 0x62, 0x61,
0x74, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x3b, 0x73,
0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0xfe, 0x72, 0x69, 0x2e, 0x3b, 0x6d, 0x69, 0xf0, 0x2e, 0x3b, 0x66,
0x69, 0x6d, 0x2e, 0x3b, 0x66, 0xf6, 0x73, 0x2e, 0x3b, 0x6c, 0x61, 0x75, 0x2e, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64,
0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a,
0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b,
0x66, 0x69, 0x6d, 0x6d, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6, 0x73, 0x74, 0x75, 0x64, 0x61, 0x67,
0x75, 0x72, 0x3b, 0x6c, 0x61, 0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xde,
0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c,
0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4d, 0x69, 0x6e,
0x67, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62,
0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b,
0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x68, 0x3b, 0x4c,
0x75, 0x61, 0x6e, 0x3b, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x43, 0xe9, 0x61, 0x64, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x3b,
0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x68, 0x3b, 0x44, 0xe9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61,
0x69, 0x67, 0x68, 0x3b, 0x44, 0xe9, 0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x4d, 0xe1, 0x69, 0x72,
0x74, 0x3b, 0x44, 0xe9, 0x20, 0x43, 0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61,
0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74,
0x68, 0x61, 0x69, 0x72, 0x6e, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x44, 0x3b, 0x41, 0x3b, 0x53, 0x3b,
0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b,
0x76, 0x65, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e,
0x65, 0x64, 0xec, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64,
0xec, 0x3b, 0x67, 0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x73, 0x61,
0x62, 0x61, 0x74, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x65e5,
0x3b, 0x6708, 0x3b, 0x706b, 0x3b, 0x6c34, 0x3b, 0x6728, 0x3b, 0x91d1, 0x3b, 0x571f, 0x3b, 0x65e5, 0x66dc, 0x65e5, 0x3b, 0x6708, 0x66dc, 0x65e5,
0x3b, 0x706b, 0x66dc, 0x65e5, 0x3b, 0x6c34, 0x66dc, 0x65e5, 0x3b, 0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b, 0x571f, 0x66dc, 0x65e5,
0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0x3b, 0xcb8, 0xccb, 0xcae, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0x3b, 0xcac, 0xcc1, 0xca7, 0x3b, 0xc97,
0xcc1, 0xcb0, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0xcb5, 0xcbe,
0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7,
0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0,
0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcad, 0xcbe, 0x3b, 0xcb8, 0xccb, 0x3b, 0xcae, 0xc82, 0x3b, 0xcac, 0xcc1, 0x3b,
0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x3b, 0x622, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x65b, 0x62f,
0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x65a, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631,
0x3b, 0x628, 0x631, 0x65b, 0x66e, 0x6ea, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627,
0x631, 0x3b, 0x627, 0x64e, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x65b, 0x62f, 0x631, 0x655, 0x631, 0x648, 0x627,
0x631, 0x3b, 0x628, 0x648, 0x65a, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x65b,
0x66e, 0x6ea, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x3b,
0x698, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x62c, 0x3b, 0x628, 0x3b, 0x416, 0x441, 0x3b, 0x414, 0x441, 0x3b, 0x421, 0x441,
0x3b, 0x421, 0x440, 0x3b, 0x411, 0x441, 0x3b, 0x416, 0x43c, 0x3b, 0x421, 0x431, 0x3b, 0x416, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431,
0x456, 0x3b, 0x414, 0x4af, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x421, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b,
0x421, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x411, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x416, 0x4b1,
0x43c, 0x430, 0x3b, 0x421, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x421, 0x3b, 0x411, 0x3b, 0x416,
0x3b, 0x421, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x431,
0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x63,
0x79, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b,
0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x63, 0x79, 0x75,
0x6d, 0x77, 0x65, 0x72, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75,
0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61,
0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x436, 0x435,
0x43a, 0x2e, 0x3b, 0x434, 0x4af, 0x439, 0x2e, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x2e, 0x3b,
0x431, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x43c, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x448,
0x435, 0x43c, 0x431, 0x438, 0x3b, 0x434, 0x4af, 0x439, 0x448, 0x4e9, 0x43c, 0x431, 0x4af, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x435, 0x43c,
0x431, 0x438, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438,
0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x428, 0x3b, 0x428,
0x3b, 0x411, 0x3b, 0x416, 0x3b, 0x418, 0x3b, 0xc77c, 0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08, 0x3b, 0xd1a0,
0x3b, 0xc77c, 0xc694, 0xc77c, 0x3b, 0xc6d4, 0xc694, 0xc77c, 0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694, 0xc77c,
0x3b, 0xae08, 0xc694, 0xc77c, 0x3b, 0xd1a0, 0xc694, 0xc77c, 0x3b, 0x63, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61,
0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e,
0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x2019, 0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b,
0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77,
0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xe88, 0xeb1,
0xe99, 0x3b, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xeaa,
0xeb8, 0xe81, 0x3b, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99,
0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb8, 0xe94,
0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xea7, 0xeb1, 0xe99,
0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xead, 0xeb2, 0x3b, 0xe88, 0x3b, 0xead, 0x3b, 0xe9e, 0x3b, 0xe9e, 0xeab, 0x3b, 0xeaa, 0xeb8, 0x3b,
0xeaa, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x4f, 0x74, 0x72, 0x64,
0x2e, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69,
0x65, 0x6b, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65,
0x6e, 0x61, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69,
0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64,
0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73,
0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x2e, 0x3b, 0x74,
0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74,
0x64, 0x2e, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x2e, 0x3b, 0x73, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b,
0x70, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x74,
0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61,
0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x3b, 0x65, 0x79, 0x65, 0x3b, 0x79, 0x62, 0x6f, 0x3b, 0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x69,
0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70, 0x73, 0x3b, 0x65, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x6d, 0x6f, 0x6b,
0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254,
0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d,
0x77, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20,
0x6d, 0xed, 0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1,
0x6e, 0x6f, 0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73, 0x254, 0x3b, 0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x6d, 0x3b, 0x70, 0x3b, 0x73, 0x6b, 0x3b, 0x70, 0x72, 0x3b, 0x61, 0x6e, 0x3b, 0x74, 0x72, 0x3b, 0x6b, 0x74, 0x3b, 0x70,
0x6e, 0x3b, 0x161, 0x74, 0x3b, 0x73, 0x65, 0x6b, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x69, 0x72,
0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x61, 0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73,
0x3b, 0x74, 0x72, 0x65, 0x10d, 0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76, 0x69, 0x72,
0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69,
0x73, 0x3b, 0x161, 0x65, 0x161, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x41, 0x3b,
0x54, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x3b, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442,
0x43e, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430,
0x431, 0x2e, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a,
0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440,
0x442, 0x43e, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x43e, 0x43a, 0x3b, 0x441, 0x430, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x435, 0x434,
0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e,
0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41, 0x6c, 0x61, 0x74,
0x73, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a, 0x6f, 0x6d, 0x3b,
0x41, 0x73, 0x61, 0x62, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x79, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x69, 0x6e,
0x61, 0x69, 0x6e, 0x79, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x6f, 0x62, 0x69, 0x61,
0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x61, 0x6d, 0x69, 0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62,
0x6f, 0x74, 0x73, 0x79, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b, 0x41, 0x3b, 0x41,
0x68, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a,
0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65,
0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b,
0x4a, 0x3b, 0x53, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd7c, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd7e, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d,
0xd35, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd7b, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd02, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f,
0x3b, 0xd36, 0xd28, 0xd3f, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15,
0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd2c, 0xd41,
0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35,
0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c,
0xd1a, 0x3b, 0xd1e, 0xd3e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35,
0xd46, 0x3b, 0xd36, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33,
0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28,
0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33,
0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b,
0xd1e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36,
0x3b, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65, 0x3b, 0x54, 0x6c, 0x69, 0x3b, 0x45, 0x72, 0x62, 0x3b, 0x126, 0x61, 0x6d,
0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x64, 0x64, 0x3b, 0x49, 0x74, 0x2d,
0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6c, 0x69, 0x65, 0x74, 0x61, 0x3b, 0x4c, 0x2d, 0x45, 0x72,
0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x49, 0x6c, 0x2d, 0x120, 0x69, 0x6d,
0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53, 0x69, 0x62, 0x74, 0x3b, 0x126, 0x64, 0x3b, 0x54, 0x6e, 0x3b, 0x54, 0x6c,
0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62, 0x3b, 0x126, 0x64, 0x3b, 0x54, 0x3b, 0x54, 0x6c,
0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120, 0x6d, 0x3b, 0x53, 0x62, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e,
0x3b, 0x92e, 0x902, 0x917, 0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930,
0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e,
0x902, 0x917, 0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x41d, 0x44f,
0x3b, 0x414, 0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411, 0x44f, 0x3b, 0x43d,
0x44f, 0x43c, 0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x43b, 0x445, 0x430, 0x433,
0x432, 0x430, 0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x431, 0x44f, 0x43c, 0x431,
0x430, 0x3b, 0x906, 0x907, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b,
0x92c, 0x93f, 0x939, 0x93f, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x906, 0x907, 0x924, 0x92c, 0x93e,
0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941,
0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x92c, 0x93e,
0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x3b, 0x92c, 0x941, 0x3b, 0x92c,
0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0xb30, 0xb2c, 0xb3f, 0x3b, 0xb38, 0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33,
0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0x3b,
0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b, 0xb2e, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0xb2c,
0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb41,
0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb30, 0x3b, 0xb38, 0xb4b, 0x3b, 0xb2e,
0x3b, 0xb2c, 0xb41, 0x3b, 0xb17, 0xb41, 0x3b, 0xb36, 0xb41, 0x3b, 0xb36, 0x3b, 0x64a, 0x648, 0x646, 0x6cd, 0x3b, 0x62f, 0x648, 0x646,
0x6cd, 0x3b, 0x62f, 0x631, 0x6d0, 0x646, 0x6cd, 0x3b, 0x685, 0x644, 0x631, 0x646, 0x6cd, 0x3b, 0x67e, 0x64a, 0x646, 0x681, 0x646, 0x6cd,
0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x627, 0x648, 0x646, 0x6cd, 0x3b, 0x6cc, 0x6a9, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62f, 0x648,
0x634, 0x646, 0x628, 0x647, 0x3b, 0x633, 0x647, 0x200c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x686, 0x647, 0x627, 0x631, 0x634, 0x646, 0x628,
0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x634, 0x646, 0x628, 0x647, 0x3b,
0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x2e,
0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74, 0x2e, 0x3b, 0x15b, 0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77, 0x2e, 0x3b, 0x70,
0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x6f,
0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0x142, 0x65, 0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x15b, 0x72,
0x6f, 0x64, 0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74, 0x65, 0x6b, 0x3b,
0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53,
0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x15b, 0x3b, 0x63, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x73,
0x65, 0x67, 0x3b, 0x74, 0x65, 0x72, 0x3b, 0x71, 0x75, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x3b, 0x73, 0x65, 0x78, 0x3b, 0x73,
0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66,
0x65, 0x69, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61,
0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69,
0x72, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64,
0x6f, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x69,
0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x3b, 0x71, 0x75,
0x61, 0x72, 0x74, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x3b, 0x73, 0xe1,
0x62, 0x61, 0x64, 0x6f, 0x3b, 0xa10, 0xa24, 0x3b, 0xa38, 0xa4b, 0xa2e, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0x3b, 0xa2c, 0xa41, 0xa71,
0xa27, 0x3b, 0xa35, 0xa40, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30,
0x3b, 0xa10, 0xa24, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e,
0xa30, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa35, 0xa40, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41,
0xa71, 0xa15, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa10, 0x3b,
0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b, 0xa35, 0xa40, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0x3b, 0xa38, 0xa3c,
0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x64f, 0x62f, 0x6be,
0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x44, 0x6f,
0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0xe9, 0x3b, 0x4a, 0x75, 0x65, 0x3b, 0x56, 0x69,
0x65, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b,
0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x4a, 0x75, 0x65,
0x76, 0x65, 0x73, 0x3b, 0x56, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69, 0x3b,
0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x67, 0x69, 0x65, 0x3b, 0x76, 0x65, 0x3b, 0x73, 0x6f, 0x3b, 0x64, 0x75, 0x6d, 0x65,
0x6e, 0x67, 0x69, 0x61, 0x3b, 0x67, 0x6c, 0x69, 0x6e, 0x64, 0x65, 0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69,
0x3b, 0x6d, 0x65, 0x73, 0x65, 0x6d, 0x6e, 0x61, 0x3b, 0x67, 0x69, 0x65, 0x76, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e,
0x64, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x64, 0x61, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b,
0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x75, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e,
0x3b, 0x6d, 0x69, 0x65, 0x2e, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x2e, 0x3b, 0x73, 0xe2, 0x6d, 0x2e, 0x3b,
0x64, 0x75, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b,
0x6d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b,
0x73, 0xe2, 0x6d, 0x62, 0x103, 0x74, 0x103, 0x3b, 0x44, 0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x4d, 0x69, 0x65, 0x3b, 0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69, 0x6e, 0x3b, 0x53, 0xe2, 0x6d, 0x3b, 0x44, 0x3b, 0x4c, 0x3b,
0x4d, 0x61, 0x3b, 0x4d, 0x69, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x432, 0x441, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442,
0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x432, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441,
0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e,
0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x43f,
0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x412, 0x3b, 0x41f, 0x3b, 0x412,
0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x42, 0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33,
0x3b, 0x42, 0x6b, 0x34, 0x3b, 0x42, 0x6b, 0x35, 0x3b, 0x4c, 0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x3b, 0x42, 0x69, 0x6b,
0x75, 0x61, 0x2d, 0xf4, 0x6b, 0x6f, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0xfb, 0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b,
0x75, 0x61, 0x2d, 0x70, 0x74, 0xe2, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x75, 0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef,
0x6b, 0x75, 0x61, 0x2d, 0x6f, 0x6b, 0xfc, 0x3b, 0x4c, 0xe2, 0x70, 0xf4, 0x73, 0xf6, 0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e,
0x67, 0x61, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x43d, 0x435, 0x434,
0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442,
0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430,
0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440,
0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f,
0x3b, 0x443, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x6e, 0x65, 0x64, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e,
0x3b, 0x75, 0x74, 0x2e, 0x3b, 0x73, 0x72, 0x2e, 0x3b, 0x10d, 0x65, 0x74, 0x2e, 0x3b, 0x70, 0x65, 0x74, 0x2e, 0x3b, 0x73,
0x75, 0x62, 0x2e, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c,
0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d,
0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61,
0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65, 0x3b, 0x10d, 0x65, 0x74,
0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e,
0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61,
0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f,
0x74, 0x61, 0x3b, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x443, 0x442, 0x2e, 0x3b, 0x441, 0x440, 0x2e,
0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x443, 0x431, 0x2e, 0x3b, 0x43d, 0x435, 0x434, 0x458,
0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a,
0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435,
0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x425, 0x446, 0x431, 0x3b, 0x41a, 0x440, 0x441, 0x3b, 0x414,
0x446, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x3b, 0x426, 0x43f, 0x440, 0x3b, 0x41c, 0x440, 0x431, 0x3b, 0x421, 0x431, 0x442, 0x3b, 0x425,
0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x41a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x414,
0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x426, 0x44b, 0x43f, 0x43f, 0x4d5,
0x440, 0x4d5, 0x43c, 0x3b, 0x41c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x421, 0x430, 0x431, 0x430, 0x442, 0x3b,
0x425, 0x3b, 0x41a, 0x3b, 0x414, 0x3b, 0x4d4, 0x3b, 0x426, 0x3b, 0x41c, 0x3b, 0x421, 0x3b, 0x445, 0x446, 0x431, 0x3b, 0x43a, 0x440,
0x441, 0x3b, 0x434, 0x446, 0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x3b, 0x446, 0x43f, 0x440, 0x3b, 0x43c, 0x440, 0x431, 0x3b, 0x441, 0x431,
0x442, 0x3b, 0x445, 0x443, 0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x43a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5,
0x440, 0x3b, 0x434, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x446, 0x44b,
0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b, 0x43c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x441, 0x430, 0x431,
0x430, 0x442, 0x3b, 0x53, 0x76, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x3b, 0x43, 0x68, 0x70, 0x3b, 0x43, 0x68, 0x74, 0x3b, 0x43,
0x68, 0x6e, 0x3b, 0x43, 0x68, 0x73, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x76, 0x6f, 0x6e, 0x64, 0x6f, 0x3b, 0x4d, 0x75,
0x76, 0x68, 0x75, 0x72, 0x6f, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67,
0x6f, 0x76, 0x65, 0x72, 0x61, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0x3b,
0x622, 0x686, 0x631, 0x3b, 0x633, 0x648, 0x645, 0x631, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b,
0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x3b, 0x622, 0x686, 0x3b, 0x633, 0x648,
0x3b, 0x627, 0x6b1, 0x3b, 0x627, 0x631, 0x3b, 0x62e, 0x645, 0x3b, 0x62c, 0x645, 0x3b, 0x687, 0x646, 0x3b, 0x622, 0x686, 0x631, 0x3b,
0x633, 0x648, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b, 0x62e, 0x645, 0x3b, 0x62c, 0x645, 0x639,
0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85,
0xd9f, 0xdc4, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0x3b, 0xdc3, 0xdd2, 0xd9a,
0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f,
0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3,
0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1, 0xdca, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd9,
0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xd89, 0x3b, 0xdc3, 0x3b, 0xd85, 0x3b, 0xdb6, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb,
0x3b, 0xdc3, 0xdd2, 0x3b, 0xdc3, 0xdd9, 0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0x75, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x161,
0x74, 0x3b, 0x70, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x13e, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x65,
0x6c, 0x6f, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b, 0x73, 0x74, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74,
0x76, 0x72, 0x74, 0x6f, 0x6b, 0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b,
0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x65, 0x64, 0x2e, 0x3b, 0x70,
0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b, 0x10d, 0x65, 0x74, 0x2e, 0x3b, 0x70,
0x65, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e,
0x65, 0x64, 0x65, 0x6c, 0x6a, 0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61, 0x3b,
0x10d, 0x65, 0x74, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61,
0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x41, 0x78, 0x64, 0x3b, 0x49,
0x73, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53,
0x61, 0x62, 0x3b, 0x41, 0x78, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61,
0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62, 0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x3b, 0x4a, 0x69,
0x6d, 0x63, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x68,
0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b,
0x6d, 0x69, 0xe9, 0x2e, 0x3b, 0x6a, 0x75, 0x65, 0x2e, 0x3b, 0x76, 0x69, 0x65, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b,
0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73,
0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x6a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69,
0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d,
0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e,
0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74, 0x69, 0x73, 0x3b, 0x6f,
0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf6, 0x72, 0x3b, 0x73, 0xf6, 0x6e, 0x64,
0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c,
0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x42f, 0x448, 0x431, 0x3b, 0x414, 0x448, 0x431, 0x3b, 0x421, 0x448, 0x431, 0x3b, 0x427, 0x448,
0x431, 0x3b, 0x41f, 0x448, 0x431, 0x3b, 0x4b6, 0x43c, 0x44a, 0x3b, 0x428, 0x43d, 0x431, 0x3b, 0x42f, 0x43a, 0x448, 0x430, 0x43d, 0x431,
0x435, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x421, 0x435, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x427, 0x43e,
0x440, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x41f, 0x430, 0x43d, 0x4b7, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x4b6, 0x443, 0x43c,
0x44a, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x4b6,
0x3b, 0x428, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0x2e, 0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0x2e,
0x3b, 0xbaa, 0xbc1, 0xba4, 0x2e, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0x2e, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0x2e, 0x3b, 0xb9a, 0xba9,
0xbbf, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1, 0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5,
0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1, 0xba4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b,
0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xb9e, 0xbbe, 0x3b, 0xba4, 0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b,
0xbaa, 0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x3b, 0x44f, 0x43a, 0x448, 0x2e, 0x3b, 0x434, 0x4af, 0x448, 0x2e,
0x3b, 0x441, 0x438, 0x448, 0x2e, 0x3b, 0x447, 0x4d9, 0x440, 0x2e, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x2e, 0x3b, 0x497, 0x43e, 0x43c,
0x2e, 0x3b, 0x448, 0x438, 0x43c, 0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x434, 0x4af, 0x448, 0x4d9, 0x43c,
0x431, 0x435, 0x3b, 0x441, 0x438, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b,
0x43f, 0x4d9, 0x43d, 0x497, 0x435, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x497, 0x43e, 0x43c, 0x433, 0x430, 0x3b, 0x448, 0x438, 0x43c,
0x431, 0x4d9, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x496, 0x3b, 0x428, 0x3b, 0xc06, 0xc26, 0xc3f,
0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41, 0xc27, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0x3b, 0xc36,
0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0x3b, 0xc06, 0xc26, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc38, 0xc4b, 0xc2e,
0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2c, 0xc41, 0xc27, 0xc35, 0xc3e, 0xc30,
0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0xc35, 0xc3e, 0xc30, 0xc02,
0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc06, 0x3b, 0xc38, 0xc4b, 0x3b, 0xc2e, 0x3b, 0xc2c, 0xc41, 0x3b, 0xc17,
0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x3b, 0xe2d, 0xe32, 0x2e, 0x3b, 0xe08, 0x2e, 0x3b, 0xe2d, 0x2e, 0x3b, 0xe1e, 0x2e, 0x3b,
0xe1e, 0xe24, 0x2e, 0x3b, 0xe28, 0x2e, 0x3b, 0xe2a, 0x2e, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe32, 0xe17, 0xe34, 0xe15, 0xe22, 0xe4c,
0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19, 0xe17, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe31, 0xe07, 0xe04, 0xe32, 0xe23,
0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe24, 0xe2b, 0xe31, 0xe2a, 0xe1a, 0xe14, 0xe35, 0x3b,
0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe40, 0xe2a, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe2d, 0xe32,
0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b, 0xe1e, 0xe24, 0x3b, 0xe28, 0x3b, 0xe2a, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a,
0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b,
0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf42, 0x3b, 0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74,
0xf62, 0x3b, 0xf66, 0xf44, 0xf66, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0x1230, 0x1295, 0x3b, 0x1230, 0x1291, 0x3b, 0x1230, 0x1209, 0x3b,
0x1228, 0x1261, 0x3b, 0x1213, 0x1219, 0x3b, 0x12d3, 0x122d, 0x3b, 0x1240, 0x12f3, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b, 0x1230, 0x1291, 0x12ed,
0x3b, 0x1230, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1213, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b, 0x1240, 0x12f3, 0x121d,
0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b,
0x1230, 0x1291, 0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1283, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b,
0x1240, 0x12f3, 0x121d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x53, 0x101,
0x70, 0x3b, 0x4d, 0x14d, 0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b, 0x50, 0x75, 0x6c, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x3b, 0x46,
0x61, 0x6c, 0x3b, 0x54, 0x6f, 0x6b, 0x3b, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65, 0x3b, 0x4d, 0x14d, 0x6e, 0x69, 0x74, 0x65,
0x3b, 0x54, 0x16b, 0x73, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x54, 0x75, 0x2bb,
0x61, 0x70, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c, 0x61, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x6f,
0x6b, 0x6f, 0x6e, 0x61, 0x6b, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x54,
0x3b, 0x50, 0x61, 0x7a, 0x3b, 0x50, 0x7a, 0x74, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x72,
0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72,
0x74, 0x65, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x6c, 0x131, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50,
0x65, 0x72, 0x15f, 0x65, 0x6d, 0x62, 0x65, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x72, 0x74, 0x65,
0x73, 0x69, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0xdd, 0x65, 0x6b,
0x3b, 0x44, 0x75, 0x15f, 0x3b, 0x53, 0x69, 0x15f, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x3b, 0x41, 0x6e, 0x6e,
0x3b, 0x15e, 0x65, 0x6e, 0x3b, 0xdd, 0x65, 0x6b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x44, 0x75, 0x15f, 0x65, 0x6e, 0x62,
0x65, 0x3b, 0x53, 0x69, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x50,
0x65, 0x6e, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x41, 0x6e, 0x6e, 0x61, 0x3b, 0x15e, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xdd,
0x3b, 0x44, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x15e, 0x3b, 0xfd, 0x65, 0x6b, 0x3b, 0x64, 0x75, 0x15f,
0x3b, 0x73, 0x69, 0x15f, 0x3b, 0xe7, 0x61, 0x72, 0x3b, 0x70, 0x65, 0x6e, 0x3b, 0x61, 0x6e, 0x6e, 0x3b, 0x15f, 0x65, 0x6e,
0x3b, 0xfd, 0x65, 0x6b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x73, 0x69,
0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x70, 0x65, 0x6e, 0x15f, 0x65,
0x6e, 0x62, 0x65, 0x3b, 0x61, 0x6e, 0x6e, 0x61, 0x3b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x64a, 0x6d5, 0x3b, 0x62f, 0x6c8,
0x3b, 0x633, 0x6d5, 0x3b, 0x686, 0x627, 0x3b, 0x67e, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x3b, 0x634, 0x6d5, 0x3b, 0x64a, 0x6d5, 0x643, 0x634,
0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x633, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628,
0x6d5, 0x3b, 0x686, 0x627, 0x631, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x67e, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b,
0x62c, 0x6c8, 0x645, 0x6d5, 0x3b, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x64a, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e,
0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e,
0x43a, 0x3b, 0x432, 0x456, 0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435,
0x442, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x2bc, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x44f, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430,
0x3b, 0x41d, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631,
0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a,
0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x59, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0x73, 0x68, 0x3b,
0x53, 0x65, 0x73, 0x68, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x68,
0x61, 0x6e, 0x3b, 0x79, 0x61, 0x6b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x62,
0x61, 0x3b, 0x73, 0x65, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68, 0x61, 0x6e, 0x62,
0x61, 0x3b, 0x70, 0x61, 0x79, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x68, 0x61,
0x6e, 0x62, 0x61, 0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x6cc, 0x2e,
0x3b, 0x62f, 0x2e, 0x3b, 0x633, 0x2e, 0x3b, 0x686, 0x2e, 0x3b, 0x67e, 0x2e, 0x3b, 0x62c, 0x2e, 0x3b, 0x634, 0x2e, 0x3b, 0x42f,
0x43a, 0x448, 0x3b, 0x414, 0x443, 0x448, 0x3b, 0x421, 0x435, 0x448, 0x3b, 0x427, 0x43e, 0x440, 0x3b, 0x41f, 0x430, 0x439, 0x3b, 0x416,
0x443, 0x43c, 0x3b, 0x428, 0x430, 0x43d, 0x3b, 0x42f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d,
0x431, 0x430, 0x3b, 0x421, 0x435, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x427, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b,
0x41f, 0x430, 0x439, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x416, 0x443, 0x43c, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x430, 0x3b,
0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x416, 0x3b, 0x428, 0x3b, 0x44f, 0x43a, 0x448, 0x3b, 0x434, 0x443,
0x448, 0x3b, 0x441, 0x435, 0x448, 0x3b, 0x447, 0x43e, 0x440, 0x3b, 0x43f, 0x430, 0x439, 0x3b, 0x436, 0x443, 0x43c, 0x3b, 0x448, 0x430,
0x43d, 0x3b, 0x44f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441, 0x435,
0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448, 0x430,
0x43d, 0x431, 0x430, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x68,
0x20, 0x32, 0x3b, 0x54, 0x68, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68,
0x20, 0x36, 0x3b, 0x54, 0x68, 0x20, 0x37, 0x3b, 0x43, 0x68, 0x1ee7, 0x20, 0x4e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68, 0x1ee9,
0x20, 0x48, 0x61, 0x69, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x54, 0x1b0, 0x3b, 0x54,
0x68, 0x1ee9, 0x20, 0x4e, 0x103, 0x6d, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x53, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42,
0x1ea3, 0x79, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x32, 0x3b, 0x54, 0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36,
0x3b, 0x54, 0x37, 0x3b, 0x53, 0x75, 0x3b, 0x4d, 0x75, 0x3b, 0x54, 0x75, 0x3b, 0x56, 0x65, 0x3b, 0x44, 0xf6, 0x3b, 0x46,
0x72, 0x3b, 0x5a, 0xe4, 0x3b, 0x73, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x6d, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x74, 0x75, 0x64,
0x65, 0x6c, 0x3b, 0x76, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x64, 0xf6, 0x64, 0x65, 0x6c, 0x3b, 0x66, 0x72, 0x69, 0x64, 0x65,
0x6c, 0x3b, 0x7a, 0xe4, 0x64, 0x65, 0x6c, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x46, 0x3b,
0x5a, 0x3b, 0x73, 0x75, 0x2e, 0x3b, 0x6d, 0x75, 0x2e, 0x3b, 0x74, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x2e, 0x3b, 0x64, 0xf6,
0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x7a, 0xe4, 0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d,
0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44,
0x79, 0x64, 0x64, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x44, 0x79,
0x64, 0x64, 0x20, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x68,
0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x49, 0x61, 0x75, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x47, 0x77, 0x65,
0x6e, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x61, 0x64, 0x77, 0x72, 0x6e, 0x3b, 0x53, 0x3b, 0x4c, 0x6c,
0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b,
0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x64,
0x3b, 0x44, 0x69, 0x62, 0x3b, 0x41, 0x6c, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0xc0, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x78,
0x3b, 0xc0, 0x6a, 0x6a, 0x3b, 0x41, 0x73, 0x65, 0x3b, 0x44, 0x69, 0x62, 0xe9, 0x65, 0x72, 0x3b, 0x41, 0x6c, 0x74, 0x69,
0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0xc0, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c,
0x78, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0xc0, 0x6a, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x65, 0x65, 0x72, 0x3b, 0x5d6,
0x5d5, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5de, 0x5d0, 0x5b8, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5d3, 0x5d9, 0x5e0, 0x5e1, 0x5d8, 0x5d9,
0x5e7, 0x3b, 0x5de, 0x5d9, 0x5d8, 0x5d5, 0x5d5, 0x5d0, 0x5da, 0x3b, 0x5d3, 0x5d0, 0x5e0, 0x5e2, 0x5e8, 0x5e9, 0x5d8, 0x5d9, 0x5e7, 0x3b,
0x5e4, 0x5bf, 0x5e8, 0x5f2, 0x5b7, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a,
0xe9, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd,
0x301, 0x62, 0x1ecd, 0x3b, 0x1eb8, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0x1ecc, 0x6a, 0x1ecd,
0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301,
0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301,
0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x1eb8, 0x74, 0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0x62, 0xe1,
0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x25b, 0x301, 0x67,
0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x190, 0x74, 0xec,
0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b,
0x186, 0x6a, 0x254, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75,
0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x186, 0x6a, 0x254, 0x301,
0x20, 0x190, 0x74, 0xec, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0x53,
0x6f, 0x6e, 0x3b, 0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48,
0x6c, 0x61, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x49, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x55, 0x4d, 0x73, 0x6f, 0x6d, 0x62,
0x75, 0x6c, 0x75, 0x6b, 0x6f, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x55, 0x4c, 0x77,
0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x55,
0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x55, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f,
0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d,
0xe5, 0x6e, 0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c,
0x61, 0x75, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66,
0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5,
0x2e, 0x3b, 0x74, 0x79, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61,
0x2e, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447, 0x435,
0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e,
0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458,
0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441,
0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x4a, 0x65, 0x64, 0x3b, 0x4a, 0x65, 0x6c, 0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65,
0x72, 0x63, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65, 0x68, 0x3b, 0x4a, 0x65, 0x73, 0x3b, 0x4a, 0x65, 0x64, 0x6f,
0x6f, 0x6e, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74,
0x3b, 0x4a, 0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68,
0x65, 0x69, 0x6e, 0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73, 0x61, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e,
0x3b, 0x4d, 0x74, 0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64,
0x3b, 0x64, 0x79, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x64, 0x79, 0x20, 0x4c, 0x75, 0x6e, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65,
0x75, 0x72, 0x74, 0x68, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x59, 0x6f,
0x77, 0x3b, 0x64, 0x79, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x53, 0x61, 0x64, 0x6f, 0x72,
0x6e, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e, 0x3b, 0x57, 0x75, 0x6b, 0x3b, 0x59, 0x61,
0x77, 0x3b, 0x46, 0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x3b, 0x4b, 0x77, 0x65, 0x73, 0x69, 0x64, 0x61, 0x3b, 0x44, 0x77,
0x6f, 0x77, 0x64, 0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57, 0x75, 0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59,
0x61, 0x77, 0x64, 0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x64, 0x61, 0x3b, 0x4b,
0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x906, 0x92f, 0x924, 0x93e, 0x930, 0x3b, 0x938,
0x94b, 0x92e, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917,
0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x93e, 0x930, 0x3b, 0x936, 0x947, 0x928, 0x935, 0x93e,
0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936,
0x947, 0x3b, 0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x3b, 0x54, 0x1ecd,
0x1ecd, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4d, 0x62, 0x1ecd, 0x73, 0x1ecb, 0x20, 0x1ee4, 0x6b, 0x61,
0x3b, 0x4d, 0x1ecd, 0x6e, 0x64, 0x65, 0x3b, 0x54, 0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x7a,
0x64, 0x65, 0x65, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64, 0x65, 0x65, 0x3b,
0x53, 0x61, 0x74, 0x1ecd, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57, 0x6b, 0x6c, 0x3b,
0x57, 0x74, 0x169, 0x3b, 0x57, 0x6b, 0x6e, 0x3b, 0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x3b, 0x57, 0x61, 0x20, 0x6b,
0x79, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129, 0x6c, 0x79, 0x61,
0x3b, 0x57, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x57,
0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x57, 0x61, 0x20,
0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x59, 0x3b, 0x57, 0x3b, 0x45, 0x3b, 0x41, 0x3b, 0x41, 0x3b,
0x41, 0x3b, 0x41, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b,
0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x65, 0x3b,
0x6c, 0x75, 0x6e, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75,
0x73, 0x3b, 0x6a, 0x6f, 0x69, 0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x69, 0x64,
0x65, 0x3b, 0x6b, 0x254, 0x73, 0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x3b, 0x79, 0x61,
0x77, 0x3b, 0x66, 0x69, 0x256, 0x3b, 0x6d, 0x65, 0x6d, 0x3b, 0x6b, 0x254, 0x73, 0x69, 0x256, 0x61, 0x3b, 0x64, 0x7a, 0x6f,
0x256, 0x61, 0x3b, 0x62, 0x6c, 0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x61, 0x3b, 0x79, 0x61, 0x77, 0x6f, 0x256, 0x61,
0x3b, 0x66, 0x69, 0x256, 0x61, 0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256, 0x61, 0x3b, 0x6b, 0x3b, 0x64, 0x3b, 0x62, 0x3b,
0x6b, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b, 0x50, 0x33, 0x3b,
0x50, 0x34, 0x3b, 0x50, 0x35, 0x3b, 0x50, 0x36, 0x3b, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50, 0x6f, 0x2bb, 0x61,
0x6b, 0x61, 0x68, 0x69, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b, 0x6f, 0x6c,
0x75, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61, 0x3b, 0x50, 0x6f,
0x2bb, 0x61, 0x6f, 0x6e, 0x6f, 0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69,
0x79, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f,
0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b,
0x75, 0x6c, 0x65, 0x73, 0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65,
0x73, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0xe4, 0x2e, 0x3b, 0x5a, 0x69, 0x2e,
0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e,
0x6e, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x5a, 0x69, 0x69, 0x73, 0x63, 0x68, 0x74,
0x69, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x73, 0x63, 0x68, 0x74, 0x69,
0x67, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x74, 0x69, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b,
0xa46d, 0xa18f, 0x3b, 0xa18f, 0xa2cd, 0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315, 0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8,
0x3b, 0xa46d, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6,
0x3b, 0xa18f, 0xa282, 0xa26c, 0x3b, 0xa18f, 0xa282, 0xa0d8, 0x3b, 0xa18f, 0x3b, 0xa2cd, 0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c,
0x3b, 0xa0d8, 0x3b, 0x53, 0xfc, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44,
0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d,
0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x67, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x64, 0x64,
0x65, 0x77, 0x65, 0x6b, 0x65, 0x6e, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x46, 0x72,
0x65, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x61, 0x76, 0x65, 0x6e, 0x64, 0x3b, 0x73, 0x6f, 0x74, 0x6e,
0x3b, 0x76, 0x75, 0x6f, 0x73, 0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x3b,
0x62, 0x65, 0x61, 0x72, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69,
0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65, 0x62, 0xe1, 0x72, 0x67,
0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73,
0x64, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x61, 0x72,
0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x73, 0x6f,
0x3b, 0x6d, 0xe1, 0x3b, 0x64, 0x69, 0x3b, 0x67, 0x61, 0x3b, 0x64, 0x75, 0x3b, 0x62, 0x65, 0x3b, 0x6c, 0xe1, 0x3b, 0x73,
0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x6d, 0xe1, 0x6e, 0x6e, 0x6f, 0x64, 0x61, 0x74, 0x3b,
0x64, 0x69, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64,
0x75, 0x6f, 0x72, 0x61, 0x73, 0x74, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c,
0xe1, 0x76, 0x76, 0x6f, 0x72, 0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42,
0x3b, 0x4c, 0x3b, 0x43, 0x70, 0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d, 0x6e, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x41,
0x72, 0x73, 0x3b, 0x49, 0x63, 0x6d, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69,
0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b,
0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x63,
0x68, 0x75, 0x6d, 0x61, 0x3b, 0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43,
0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x45, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b,
0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x49, 0x74, 0x75, 0x6b, 0x75,
0x20, 0x6a, 0x61, 0x20, 0x6a, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6a,
0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69,
0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75, 0x72,
0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20,
0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61, 0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f, 0x3b,
0x4a, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x64, 0x65, 0x77, 0x3b, 0x61, 0x61,
0x253, 0x3b, 0x6d, 0x61, 0x77, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x3b, 0x6d, 0x77, 0x64, 0x3b, 0x68, 0x62,
0x69, 0x3b, 0x64, 0x65, 0x77, 0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x62, 0x61, 0x61,
0x72, 0x65, 0x3b, 0x6e, 0x6a, 0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x73, 0x61, 0x61, 0x6e,
0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f, 0x72, 0x65, 0x2d, 0x62, 0x69, 0x69, 0x72,
0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x4b, 0x4d, 0x41, 0x3b, 0x4e,
0x54, 0x54, 0x3b, 0x4e, 0x4d, 0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52, 0x54, 0x3b, 0x4e, 0x4d, 0x41, 0x3b, 0x4e,
0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b,
0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41,
0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x6d, 0x6f, 0x74, 0x68, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x41, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b,
0x53, 0x61, 0x70, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72,
0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65,
0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f,
0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6e, 0x65, 0x74, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20,
0x69, 0x6c, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d,
0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x77, 0x65, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49,
0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f, 0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54,
0x61, 0x74, 0x3b, 0x4e, 0x61, 0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x69, 0x6e,
0x67, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43,
0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x53, 0x61, 0x62, 0x75, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b,
0x53, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b,
0x53, 0x69, 0x6e, 0x3b, 0x53, 0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76,
0x75, 0x6c, 0x6f, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x53, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b,
0x53, 0x69, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c,
0x6f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x49, 0x6a, 0x70, 0x3b,
0x49, 0x6a, 0x74, 0x3b, 0x49, 0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75,
0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74,
0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b,
0x37, 0x3b, 0x31, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x3b,
0x2d30, 0x2d3d, 0x2d61, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59,
0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b,
0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59,
0x3b, 0x61, 0x73, 0x61, 0x3b, 0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73, 0x69, 0x3b, 0x61, 0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77,
0x3b, 0x61, 0x73, 0x69, 0x6d, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x3b, 0x61, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79,
0x6e, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77,
0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41,
0x63, 0x65, 0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41, 0x68, 0x61, 0x3b, 0x41, 0x6d, 0x68, 0x3b, 0x53,
0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64, 0x3b, 0x41, 0x63, 0x65, 0x72, 0x3b, 0x41, 0x72, 0x69, 0x6d, 0x3b, 0x41, 0x72, 0x61,
0x6d, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x41, 0x6d, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64,
0x3b, 0x59, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x53,
0x61, 0x6e, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x3b, 0x4b, 0x75, 0x1e93, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x1e0d, 0x69, 0x73,
0x3b, 0x53, 0x61, 0x79, 0x3b, 0x59, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x4b,
0x72, 0x61, 0x1e0d, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x75, 0x1e93, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61, 0x73, 0x73,
0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x61, 0x73, 0x73, 0x3b, 0x43, 0x3b, 0x52, 0x3b,
0x41, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b, 0x4f, 0x4b,
0x42, 0x3b, 0x4f, 0x4b, 0x53, 0x3b, 0x4f, 0x4b, 0x4e, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x3b, 0x53, 0x61,
0x6e, 0x64, 0x65, 0x3b, 0x4f, 0x72, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61,
0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f,
0x72, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b,
0x4f, 0x72, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x52, 0x3b, 0x53, 0x3b,
0x4e, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x48, 0x69, 0x76, 0x3b, 0x48, 0x69,
0x64, 0x3b, 0x48, 0x69, 0x74, 0x3b, 0x48, 0x69, 0x68, 0x3b, 0x4c, 0x65, 0x6d, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x75, 0x6c,
0x75, 0x6e, 0x67, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x76, 0x69, 0x6c, 0x75, 0x68, 0x61, 0x3b,
0x70, 0x61, 0x20, 0x68, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x64, 0x61, 0x74, 0x75, 0x3b,
0x70, 0x61, 0x20, 0x68, 0x69, 0x74, 0x61, 0x79, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x68, 0x61, 0x6e, 0x75, 0x3b,
0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x6c, 0x65, 0x6d, 0x62, 0x65, 0x6c, 0x61, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b,
0x48, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e,
0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x75, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b,
0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x6b, 0x61, 0x72, 0x3b, 0x6e, 0x74,
0x25b, 0x3b, 0x74, 0x61, 0x72, 0x3b, 0x61, 0x72, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x3b, 0x73, 0x69,
0x62, 0x3b, 0x6b, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x74, 0x25b, 0x6e, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x61, 0x74, 0x61, 0x3b,
0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73,
0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x53, 0x3b,
0x4b, 0x6d, 0x61, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72, 0x6d, 0x3b,
0x4d, 0x61, 0x61, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74,
0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b,
0x4e, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x3b, 0x13e6, 0x13a2,
0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c6, 0x13cd,
0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x13a2,
0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c8,
0x13d5, 0x13be, 0x3b, 0x13c6, 0x3b, 0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6, 0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4, 0x3b, 0x64, 0x69, 0x6d,
0x3b, 0x6c, 0x69, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61, 0x6e, 0x3b,
0x73, 0x61, 0x6d, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72,
0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x6e,
0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0x69, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x7a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x4c, 0x6c, 0x32, 0x3b, 0x4c, 0x6c, 0x33, 0x3b, 0x4c, 0x6c, 0x34, 0x3b, 0x4c, 0x6c,
0x35, 0x3b, 0x4c, 0x6c, 0x36, 0x3b, 0x4c, 0x6c, 0x37, 0x3b, 0x4c, 0x6c, 0x31, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61,
0x20, 0x6c, 0x79, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x63, 0x68,
0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4c,
0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6c,
0x69, 0x6e, 0x6a, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c,
0x69, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x50, 0xed, 0x69, 0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75, 0x3b, 0xcd,
0x6e, 0x65, 0x3b, 0x54, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d, 0xf3, 0x6f,
0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74,
0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0xed, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e, 0x6f, 0x3b,
0x41, 0x6c, 0x61, 0x6d, 0xed, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x6d, 0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4d, 0x3b,
0x53, 0x61, 0x62, 0x3b, 0x42, 0x61, 0x6c, 0x3b, 0x4c, 0x77, 0x32, 0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77, 0x34, 0x3b,
0x4c, 0x77, 0x35, 0x3b, 0x4c, 0x77, 0x36, 0x3b, 0x53, 0x61, 0x62, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c,
0x61, 0x7a, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x73,
0x61, 0x74, 0x75, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0x4c, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x4c, 0x3b,
0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x50, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x50,
0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6d, 0x6f, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x62, 0x75, 0x6c, 0x69,
0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69,
0x6e, 0x65, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x6f, 0x3b, 0x50, 0x61, 0x63, 0x68, 0x69,
0x62, 0x65, 0x6c, 0x75, 0x73, 0x68, 0x69, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b, 0x74, 0x65, 0x72, 0x3b,
0x6b, 0x75, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x75, 0x6d, 0x69,
0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72,
0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b,
0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72,
0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53,
0x3b, 0x53, 0x3b, 0x64, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66,
0x65, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74,
0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65,
0x73, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x49, 0x55, 0x3b,
0x4d, 0x52, 0x41, 0x3b, 0x57, 0x41, 0x49, 0x3b, 0x57, 0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b,
0x4a, 0x55, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x6f, 0x3b,
0x57, 0x61, 0x69, 0x72, 0x69, 0x3b, 0x57, 0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x61, 0x3b, 0x57,
0x65, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57,
0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x4b, 0x74, 0x73, 0x3b, 0x4b, 0x6f, 0x74, 0x3b, 0x4b, 0x6f, 0x6f,
0x3b, 0x4b, 0x6f, 0x73, 0x3b, 0x4b, 0x6f, 0x61, 0x3b, 0x4b, 0x6f, 0x6d, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b, 0x4b, 0x6f, 0x74,
0x69, 0x73, 0x61, 0x70, 0x3b, 0x4b, 0x6f, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x6f, 0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b,
0x4b, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x6b, 0x3b, 0x4b, 0x6f, 0x61, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4b, 0x6f,
0x6d, 0x75, 0x75, 0x74, 0x3b, 0x4b, 0x6f, 0x6c, 0x6f, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x4c, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57, 0x75, 0x3b, 0x44, 0x6f, 0x3b,
0x46, 0x72, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x4d,
0x61, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73,
0x65, 0x65, 0x73, 0x3b, 0x57, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x6f, 0x6e,
0x64, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74, 0x61, 0x78, 0x74,
0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53,
0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e,
0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e,
0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x6f, 0x68, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68,
0x3b, 0x44, 0x69, 0x6e, 0x6e, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x65, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b,
0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x64, 0x61, 0x61,
0x63, 0x68, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x6c,
0xed, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x74, 0xe1, 0x6e, 0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0xe1,
0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61,
0x3b, 0x4b, 0x75, 0x62, 0x69, 0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b, 0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x74, 0x61,
0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61,
0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75,
0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x75, 0x3b,
0x4f, 0x6c, 0x6f, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35, 0x3b, 0x41, 0x6c, 0x3b,
0x49, 0x6a, 0x3b, 0x4a, 0x31, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f,
0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4d, 0x75, 0x72, 0x77,
0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69,
0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68,
0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x42, 0x61, 0x72, 0x3b, 0x41, 0x61, 0x72,
0x3b, 0x55, 0x6e, 0x69, 0x3b, 0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6b,
0x61, 0x65, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73, 0x61, 0x3b, 0x4e,
0x61, 0x6b, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75,
0x6e, 0x67, 0x2019, 0x6f, 0x6e, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x73,
0x61, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x53, 0x3b,
0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b,
0x41, 0x6c, 0x6a, 0x3b, 0x41, 0x73, 0x73, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x69,
0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61,
0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x73, 0x61, 0x62, 0x64, 0x75,
0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x4a, 0x4d, 0x50, 0x3b, 0x57,
0x55, 0x54, 0x3b, 0x54, 0x41, 0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41, 0x42, 0x3b, 0x4e,
0x47, 0x53, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54, 0x69, 0x63, 0x68,
0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x64, 0x65,
0x6b, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20,
0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x3b, 0x4a, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x54, 0x3b,
0x54, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73, 0x6e, 0x3b, 0x41, 0x6b,
0x72, 0x3b, 0x41, 0x6b, 0x77, 0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x3b, 0x41, 0x73, 0x61, 0x6d, 0x61, 0x73,
0x3b, 0x41, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x72, 0x61, 0x73, 0x3b,
0x41, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x1e0d, 0x79, 0x61,
0x73, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x6c, 0x68, 0x3b,
0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x7a, 0x3b,
0x41, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74,
0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69,
0x69, 0x73, 0x61, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0x4a, 0x70,
0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a,
0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70, 0x69, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61,
0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x41, 0x3b, 0x49,
0x3b, 0x31, 0x3b, 0x930, 0x92c, 0x93f, 0x3b, 0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x926, 0x3b, 0x92c,
0x93f, 0x938, 0x925, 0x93f, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x3b, 0x930, 0x92c, 0x93f, 0x92c,
0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x926,
0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x92c, 0x93e,
0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b,
0x92c, 0x93f, 0x3b, 0x938, 0x941, 0x3b, 0x938, 0x941, 0x3b, 0x43a, 0x4c0, 0x438, 0x3b, 0x43e, 0x440, 0x3b, 0x448, 0x438, 0x3b, 0x43a,
0x445, 0x430, 0x3b, 0x435, 0x430, 0x3b, 0x43f, 0x4c0, 0x435, 0x3b, 0x448, 0x443, 0x43e, 0x3b, 0x43a, 0x4c0, 0x438, 0x440, 0x430, 0x3b,
0x43e, 0x440, 0x448, 0x43e, 0x442, 0x3b, 0x448, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x43a, 0x445, 0x430, 0x430, 0x440, 0x430, 0x3b,
0x435, 0x430, 0x440, 0x430, 0x3b, 0x43f, 0x4c0, 0x435, 0x440, 0x430, 0x441, 0x43a, 0x430, 0x3b, 0x448, 0x443, 0x43e, 0x442, 0x3b, 0x43a,
0x4c0, 0x3b, 0x43e, 0x3b, 0x448, 0x3b, 0x43a, 0x445, 0x3b, 0x435, 0x3b, 0x43f, 0x4c0, 0x3b, 0x448, 0x3b, 0x43d, 0x434, 0x2de7, 0x487,
0x467, 0x3b, 0x43f, 0x43d, 0x2de3, 0x435, 0x3b, 0x432, 0x442, 0x43e, 0x2dec, 0x487, 0x3b, 0x441, 0x440, 0x2de3, 0x435, 0x3b, 0x447, 0x435,
0x2de6, 0x487, 0x3b, 0x43f, 0x467, 0x2de6, 0x487, 0x3b, 0x441, 0xa64b, 0x2de0, 0x487, 0x3b, 0x43d, 0x435, 0x434, 0x463, 0x301, 0x43b, 0x467,
0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x463, 0x301, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x44a, 0x3b, 0x432, 0x442, 0x43e, 0x301, 0x440,
0x43d, 0x438, 0x43a, 0x44a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x300, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x442, 0x43e,
0x301, 0x43a, 0x44a, 0x3b, 0x43f, 0x467, 0x442, 0x43e, 0x301, 0x43a, 0x44a, 0x3b, 0x441, 0xa64b, 0x431, 0x431, 0x461, 0x301, 0x442, 0x430,
0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4e, 0x6b, 0x6f, 0x3b, 0x4e, 0x64, 0x79, 0x3b, 0x4e, 0x64, 0x67, 0x3b, 0x4e, 0x6a, 0x77,
0x3b, 0x4e, 0x67, 0x76, 0x3b, 0x4c, 0x75, 0x62, 0x3b, 0x4c, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f,
0x64, 0x79, 0x61, 0x3b, 0x4e, 0x64, 0xe0, 0x61, 0x79, 0xe0, 0x3b, 0x4e, 0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a,
0xf2, 0x77, 0x61, 0x3b, 0x4e, 0x67, 0xf2, 0x76, 0x79, 0x61, 0x3b, 0x4c, 0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4c,
0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4c, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0xe9, 0x69,
0x3b, 0x44, 0xeb, 0x6e, 0x3b, 0x4d, 0xeb, 0x74, 0x3b, 0x44, 0x6f, 0x6e, 0x3b, 0x46, 0x72, 0x65, 0x3b, 0x53, 0x61, 0x6d,
0x3b, 0x53, 0x6f, 0x6e, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x4d, 0xe9, 0x69, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x44, 0xeb, 0x6e,
0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x4d, 0xeb, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e,
0x65, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73,
0x63, 0x68, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x6f, 0x6e, 0x2e, 0x3b, 0x4d, 0xe9, 0x69, 0x2e, 0x3b, 0x44, 0xeb, 0x6e, 0x2e,
0x3b, 0x4d, 0xeb, 0x74, 0x2e, 0x3b, 0x44, 0x6f, 0x6e, 0x2e, 0x3b, 0x46, 0x72, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e,
0x3b, 0x6e, 0x74, 0x73, 0x3b, 0x6b, 0x70, 0x61, 0x3b, 0x67, 0x68, 0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65,
0x3b, 0x67, 0x68, 0x268, 0x3b, 0x64, 0x7a, 0x6b, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73,
0x75, 0x294, 0x75, 0x6b, 0x70, 0xe0, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75,
0x294, 0x75, 0x74, 0x254, 0x300, 0x6d, 0x6c, 0xf2, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75,
0x294, 0x75, 0x67, 0x68, 0x268, 0x302, 0x6d, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254,
0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x67, 0x3b, 0x74, 0x3b, 0x75, 0x3b, 0x67, 0x3b, 0x64, 0x3b, 0x6e, 0x254, 0x79, 0x3b, 0x6e,
0x6a, 0x61, 0x3b, 0x75, 0x75, 0x6d, 0x3b, 0x14b, 0x67, 0x65, 0x3b, 0x6d, 0x62, 0x254, 0x3b, 0x6b, 0x254, 0x254, 0x3b, 0x6a,
0x6f, 0x6e, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x254, 0x302, 0x79, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x6a,
0x61, 0x14b, 0x67, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0xfb, 0x6d, 0x3b, 0x14b, 0x67, 0x77, 0xe0,
0x20, 0x14b, 0x67, 0xea, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6d, 0x62, 0x254, 0x6b, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20,
0x6b, 0x254, 0x254, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6a, 0xf4, 0x6e, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x75, 0x3b, 0x14b,
0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6a, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69,
0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68,
0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b,
0x48, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x53, 0x3b, 0xe9, 0x74, 0x3b, 0x6d, 0x254, 0x301,
0x73, 0x3b, 0x6b, 0x77, 0x61, 0x3b, 0x6d, 0x75, 0x6b, 0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b, 0x65, 0x73,
0x61, 0x3b, 0xe9, 0x74, 0x69, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61, 0x73, 0xfa, 0x3b, 0x6d, 0x75,
0x6b, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x14b, 0x67, 0x69, 0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e, 0x25b, 0x73, 0xfa, 0x3b, 0x65,
0x73, 0x61, 0x253, 0x61, 0x73, 0xfa, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257, 0x3b, 0x65,
0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x54, 0x65, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72, 0x61,
0x3b, 0x41, 0x72, 0x6a, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65, 0x14b,
0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x6d,
0x69, 0x73, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x44,
0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254,
0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b, 0x73,
0xe9, 0x72, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301, 0x6e,
0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64,
0x254, 0x20, 0x6d, 0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64, 0xe9,
0x3b, 0x73, 0xe9, 0x72, 0x61, 0x64, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x66, 0x3b,
0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6c, 0x1dd, 0x6e, 0x3b, 0x6d, 0x61, 0x61, 0x3b, 0x6d, 0x25b, 0x6b, 0x3b, 0x6a,
0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c, 0x1dd,
0x6e, 0x64, 0xed, 0x3b, 0x6d, 0x61, 0x61, 0x64, 0xed, 0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a, 0x1dd,
0x1dd, 0x64, 0xed, 0x3b, 0x6a, 0xfa, 0x6d, 0x62, 0xe1, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x3b, 0x73, 0x3b, 0x6c, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e,
0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x53, 0x61,
0x62, 0x61, 0x74, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e,
0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69,
0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x43, 0x79, 0x61, 0x3b, 0x43, 0x6c, 0x61, 0x3b, 0x43,
0x7a, 0x69, 0x3b, 0x43, 0x6b, 0x6f, 0x3b, 0x43, 0x6b, 0x61, 0x3b, 0x43, 0x67, 0x61, 0x3b, 0x43, 0x7a, 0x65, 0x3b, 0x43,
0x6f, 0x6d, 0x2019, 0x79, 0x61, 0x6b, 0x6b, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6c, 0x61, 0x61, 0x257, 0x69, 0x69, 0x3b, 0x43,
0x6f, 0x6d, 0x7a, 0x79, 0x69, 0x69, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x6f, 0x6c, 0x6c, 0x65, 0x3b, 0x43,
0x6f, 0x6d, 0x6b, 0x61, 0x6c, 0x64, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x67, 0x61, 0x69, 0x73, 0x75,
0x75, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x65, 0x253, 0x73, 0x75, 0x75, 0x3b, 0x59, 0x3b, 0x4c, 0x3b, 0x5a, 0x3b, 0x4f,
0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x45, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62,
0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x6d, 0x62, 0x73, 0x3b, 0x73, 0x61, 0x73, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61,
0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x62, 0x61, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20,
0x6d, 0xe1, 0x6c, 0x61, 0x6c, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1,
0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x62, 0xe1, 0x67, 0xe1, 0x20, 0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73,
0xe1, 0x73, 0x61, 0x64, 0x69, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b,
0x43, 0xe4, 0x14b, 0x3b, 0x4a, 0x69, 0x65, 0x63, 0x3b, 0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a,
0x75, 0x61, 0x61, 0x6e, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x3b, 0x43, 0xe4,
0x14b, 0x20, 0x6b, 0x75, 0x254, 0x74, 0x68, 0x3b, 0x4a, 0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b,
0x77, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b,
0x14a, 0x75, 0x61, 0x61, 0x6e, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c,
0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x43, 0x3b, 0x4a,
0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x14a, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x431, 0x441, 0x3b, 0x431, 0x43d, 0x3b, 0x43e, 0x43f, 0x3b,
0x441, 0x44d, 0x3b, 0x447, 0x43f, 0x3b, 0x431, 0x44d, 0x3b, 0x441, 0x431, 0x3b, 0x431, 0x430, 0x441, 0x43a, 0x44b, 0x4bb, 0x44b, 0x430,
0x43d, 0x43d, 0x44c, 0x430, 0x3b, 0x431, 0x44d, 0x43d, 0x438, 0x434, 0x438, 0x44d, 0x43d, 0x43d, 0x44c, 0x438, 0x43a, 0x3b, 0x43e, 0x43f,
0x442, 0x443, 0x43e, 0x440, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x43a, 0x3b, 0x441, 0x44d, 0x440, 0x44d, 0x434, 0x44d, 0x3b, 0x447, 0x44d,
0x43f, 0x43f, 0x438, 0x44d, 0x440, 0x3b, 0x411, 0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x441, 0x443, 0x431, 0x443, 0x43e,
0x442, 0x430, 0x3b, 0x411, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x3b, 0x4d, 0x75, 0x6c,
0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75,
0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41,
0x6c, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0xa55e,
0xa54c, 0xa535, 0x3b, 0xa5f3, 0xa5e1, 0xa609, 0x3b, 0xa55a, 0xa55e, 0xa55a, 0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b,
0xa549, 0xa524, 0xa540, 0xa56e, 0x3b, 0xa53b, 0xa52c, 0xa533, 0x3b, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e,
0x25b, 0x25b, 0x3b, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69,
0x73, 0x61, 0x3b, 0x61, 0x69, 0x6a, 0x69, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x75, 0x6e,
0x3b, 0x4d, 0xe4, 0x6e, 0x3b, 0x5a, 0x69, 0x161, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69,
0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b,
0x5a, 0x69, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74,
0x61, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b,
0x4d, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77,
0x3b, 0x65, 0x74, 0x3b, 0x6b, 0x6c, 0x3b, 0x66, 0x6c, 0x3b, 0x73, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b,
0x3b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x75, 0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69,
0x65, 0x3b, 0x6d, 0x65, 0x74, 0xfa, 0x6b, 0x70, 0xed, 0xe1, 0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d,
0x65, 0x74, 0xfa, 0x6b, 0x70, 0x69, 0x61, 0x70, 0x25b, 0x3b, 0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73,
0x65, 0x6c, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x64, 0x6f,
0x6d, 0x3b, 0x6c, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x78, 0x75, 0x65, 0x3b, 0x76, 0x69,
0x65, 0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x6c, 0x6c, 0x75, 0x6e, 0x65, 0x73,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x78, 0x75,
0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b,
0x53, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0xc1, 0x70, 0x74, 0x61, 0x20, 0x4d,
0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x57, 0x25b, 0x301, 0x6e, 0x25b, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x54, 0x254, 0x301, 0x73,
0x25b, 0x64, 0x25b, 0x3b, 0x46, 0x25b, 0x6c, 0xe2, 0x79, 0x25b, 0x64, 0x25b, 0x3b, 0x53, 0xe1, 0x73, 0x69, 0x64, 0x25b, 0x3b,
0x53, 0x254, 0x301, 0x3b, 0x4d, 0x254, 0x301, 0x3b, 0xc1, 0x4d, 0x3b, 0x57, 0x25b, 0x301, 0x3b, 0x54, 0x254, 0x301, 0x3b, 0x46,
0x25b, 0x3b, 0x53, 0xe1, 0x3b, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72,
0x64, 0x69, 0x3b, 0x6d, 0x25b, 0x72, 0x6b, 0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x79, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61,
0x14b, 0x64, 0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x6d, 0x254, 0x6e, 0x254, 0x20, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x73,
0x6f, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x25b, 0x3b, 0x79, 0x65, 0x3b, 0x76, 0x61, 0x3b, 0x6d, 0x73, 0x3b,
0x41, 0x6e, 0x65, 0x67, 0x20, 0x31, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x32, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x33,
0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x34, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x35, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20,
0x36, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x37, 0x3b, 0x41, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x41, 0x33, 0x3b, 0x41, 0x34,
0x3b, 0x41, 0x35, 0x3b, 0x41, 0x36, 0x3b, 0x41, 0x37, 0x3b, 0x6c, 0x79, 0x25b, 0x2bc, 0x25b, 0x301, 0x20, 0x73, 0x1e85, 0xed,
0x14b, 0x74, 0xe8, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254,
0x6e, 0x74, 0xe8, 0x20, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x74, 0x73, 0xe8, 0x74, 0x73,
0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x74,
0x73, 0x65, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6d,
0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc,
0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x77, 0x61, 0x6b, 0x21f, 0x61, 0x14b, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75,
0x77, 0x61, 0x14b, 0x17e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x6e, 0x75, 0x14b, 0x70, 0x61, 0x3b, 0x41, 0x14b,
0x70, 0xe9, 0x74, 0x75, 0x79, 0x61, 0x6d, 0x6e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x74, 0x6f, 0x70, 0x61,
0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x7a, 0x61, 0x70, 0x74, 0x61, 0x14b, 0x3b, 0x4f, 0x77, 0xe1, 0x14b, 0x67, 0x79,
0x75, 0x17e, 0x61, 0x17e, 0x61, 0x70, 0x69, 0x3b, 0x41, 0x3b, 0x57, 0x3b, 0x4e, 0x3b, 0x59, 0x3b, 0x54, 0x3b, 0x5a, 0x3b,
0x4f, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x6cc, 0x6d5, 0x6a9, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x62f,
0x648, 0x648, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x633, 0x6ce, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x686, 0x648, 0x627, 0x631,
0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x67e, 0x6ce, 0x646, 0x62c, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6be, 0x6d5, 0x6cc, 0x646,
0x6cc, 0x3b, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x6be, 0x3b,
0x634, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x61, 0x142, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x73, 0x74,
0x77, 0x3b, 0x70, 0x11b, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3,
0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x65, 0x3b, 0x77, 0x61, 0x142, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x6f,
0x64, 0x61, 0x3b, 0x73, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x11b, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f,
0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x6a, 0x65,
0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x161, 0x74, 0x77, 0x3b, 0x70, 0x6a, 0x61,
0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x64, 0x17a, 0x65,
0x6c, 0x61, 0x3b, 0x77, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x77,
0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x6a, 0x61, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b,
0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x61, 0x64, 0x3b, 0x70, 0x61, 0x6e, 0x3b,
0x77, 0x69, 0x73, 0x3b, 0x70, 0x75, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x3b, 0x70, 0x113, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b,
0x6e, 0x61, 0x64, 0x12b, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x6e, 0x61, 0x64, 0x12b, 0x6c, 0x69, 0x3b, 0x77, 0x69, 0x73, 0x61,
0x73, 0x12b, 0x64, 0x69, 0x73, 0x3b, 0x70, 0x75, 0x73, 0x73, 0x69, 0x73, 0x61, 0x77, 0x61, 0x69, 0x74, 0x69, 0x3b, 0x6b,
0x65, 0x74, 0x77, 0x69, 0x72, 0x74, 0x69, 0x6b, 0x73, 0x3b, 0x70, 0x113, 0x6e, 0x74, 0x6e, 0x69, 0x6b, 0x73, 0x3b, 0x73,
0x61, 0x62, 0x61, 0x74, 0x74, 0x69, 0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x50, 0x3b, 0x4b, 0x3b, 0x50,
0x3b, 0x53, 0x3b, 0x70, 0x61, 0x73, 0x3b, 0x76, 0x75, 0x6f, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6b, 0x6f, 0x73, 0x3b, 0x74,
0x75, 0x6f, 0x3b, 0x76, 0xe1, 0x73, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x69, 0x76, 0x69,
0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x72, 0x67, 0xe2,
0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0xe2, 0x68, 0x3b,
0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0xe2, 0x68,
0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x61, 0x72,
0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x68,
0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0x75, 0x76, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65,
0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0x75, 0x76, 0x3b, 0x70, 0x3b, 0x56, 0x3b, 0x4d, 0x3b,
0x4b, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x4c, 0x3b
};

static const ushort byte_unit_data[] = {
0x62, 0x79, 0x74, 0x65, 0x73, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b,
0x45, 0x42, 0x4b, 0x69, 0x42, 0x3b, 0x4d, 0x69, 0x42, 0x3b, 0x47, 0x69, 0x42, 0x3b, 0x54, 0x69, 0x42, 0x3b, 0x50, 0x69,
0x42, 0x3b, 0x45, 0x69, 0x42, 0x62, 0x79, 0x74, 0x65, 0x67, 0x72, 0x65, 0x70, 0x65, 0x62, 0x61, 0x6a, 0x74, 0x1263, 0x12ed,
0x1275, 0x12aa, 0x1263, 0x3b, 0x121c, 0x130b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x130a, 0x1263, 0x3b, 0x1274, 0x122b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x50,
0x42, 0x3b, 0x45, 0x42, 0x628, 0x627, 0x64a, 0x62a, 0x643, 0x64a, 0x644, 0x648, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x645, 0x64a, 0x63a,
0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x63a, 0x64a, 0x63a, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x62a, 0x64a, 0x631, 0x627, 0x628,
0x627, 0x64a, 0x62a, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x562, 0x561, 0x575, 0x569, 0x565, 0x580, 0x56f, 0x532, 0x3b, 0x544, 0x532,
0x3b, 0x533, 0x532, 0x3b, 0x54f, 0x532, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x9ac, 0x9be, 0x987, 0x99f, 0x995, 0x9bf, 0x983, 0x20,
0x9ac, 0x9be, 0x983, 0x3b, 0x9ae, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x997, 0x9bf, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b,
0x99f, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62, 0x61, 0x79, 0x74, 0x62, 0x79, 0x74,
0x65, 0x2d, 0x61, 0x6b, 0x6f, 0x6b, 0x74, 0x65, 0x64, 0x6f, 0xf9, 0x6b, 0x6f, 0x3b, 0x4d, 0x6f, 0x3b, 0x47, 0x6f, 0x3b,
0x54, 0x6f, 0x3b, 0x50, 0x6f, 0x3b, 0x45, 0x6f, 0x4b, 0x69, 0x6f, 0x3b, 0x4d, 0x69, 0x6f, 0x3b, 0x47, 0x69, 0x6f, 0x3b,
0x54, 0x69, 0x6f, 0x3b, 0x50, 0x69, 0x6f, 0x3b, 0x45, 0x69, 0x6f, 0x431, 0x430, 0x439, 0x442, 0x43e, 0x432, 0x435, 0x1018, 0x102d,
0x102f, 0x1000, 0x103a, 0x431, 0x430, 0x439, 0x442, 0x44b, 0x41a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b, 0x422, 0x411, 0x3b,
0x50, 0x42, 0x3b, 0x45, 0x42, 0x1794, 0x17c3, 0x5b57, 0x8282, 0x5343, 0x5b57, 0x8282, 0x3b, 0x5146, 0x5b57, 0x8282, 0x3b, 0x5409, 0x5b57, 0x8282,
0x3b, 0x592a, 0x5b57, 0x8282, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x4f4d, 0x5143, 0x7d44, 0x62, 0x61, 0x6a, 0x74, 0x6f, 0x76, 0x69,
0x62, 0x61, 0x6a, 0x74, 0x79, 0x62, 0x61, 0x6a, 0x74, 0x6f, 0x6a, 0x62, 0x61, 0x69, 0x64, 0x69, 0x64, 0x62, 0xfd, 0x74,
0x4b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x74, 0x61, 0x76,
0x75, 0x74, 0x6b, 0x74, 0x3b, 0x4d, 0x74, 0x3b, 0x47, 0x74, 0x3b, 0x54, 0x74, 0x3b, 0x50, 0x74, 0x3b, 0x45, 0x74, 0x4b,
0x69, 0x74, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x47, 0x69, 0x74, 0x3b, 0x54, 0x69, 0x74, 0x3b, 0x50, 0x69, 0x74, 0x3b, 0x45,
0x69, 0x74, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x73, 0x62, 0x61, 0x69, 0x64, 0x68, 0x74, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x10d9,
0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10db, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10d2, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b,
0x10e2, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x42, 0x79, 0x74, 0x65, 0x73, 0xaac, 0xabe, 0xa87,
0xa9f, 0x5d1, 0x5d9, 0x5d9, 0x5d8, 0x92c, 0x93e, 0x907, 0x91f, 0x62, 0xe1, 0x6a, 0x74, 0x62, 0xe6, 0x74, 0x69, 0x62, 0x65, 0x61,
0x72, 0x74, 0x61, 0x30d0, 0x30a4, 0x30c8, 0xcac, 0xcc8, 0xc9f, 0xccd, 0x200c, 0xc97, 0xcb3, 0xcc1, 0xc95, 0xcbf, 0x2e, 0xcac, 0xcc8, 0x2e,
0x3b, 0xcae, 0xcc6, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xc97, 0xcbf, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xc9f, 0xcc6, 0x2e, 0xcac, 0xcc8,
0x2e, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x431, 0x430, 0x439, 0x442, 0x43a, 0x411, 0x3b, 0x4d, 0x411, 0x3b, 0x413, 0x411, 0x3b,
0x54, 0x411, 0x3b, 0x50, 0x411, 0x3b, 0x45, 0x411, 0x4b, 0x69, 0x411, 0x3b, 0x4d, 0x69, 0x411, 0x3b, 0x47, 0x69, 0x411, 0x3b,
0x54, 0x69, 0x411, 0x3b, 0x50, 0x69, 0x411, 0x3b, 0x45, 0x69, 0x411, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b,
0x422, 0x411, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xbc14, 0xc774, 0xd2b8, 0x62, 0x61, 0x69, 0x74, 0x69, 0x62, 0x61, 0x69, 0x74,
0x61, 0x69, 0x431, 0x430, 0x458, 0x442, 0x438, 0x62, 0x61, 0x69, 0x74, 0xd2c, 0xd48, 0xd31, 0xd4d, 0xd31, 0xd4d, 0xd15, 0xd3f, 0x2e,
0xd2c, 0xd3f, 0x2e, 0x3b, 0xd2e, 0xd46, 0x2e, 0xd2c, 0xd48, 0x2e, 0x3b, 0xd1c, 0xd3f, 0x2e, 0xd2c, 0xd48, 0x2e, 0x3b, 0xd1f, 0xd3f,
0xd2c, 0xd3f, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xb2c, 0xb3e, 0xb07, 0xb1f, 0xb4d, 0x628, 0x627, 0x6cc, 0x62a, 0x6a9, 0x6cc, 0x644,
0x648, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x645, 0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x6af, 0x6cc, 0x6af, 0x627, 0x628, 0x627,
0x6cc, 0x62a, 0x3b, 0x62a, 0x631, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xa2c, 0xa3e, 0xa07, 0xa1f,
0x62, 0x79, 0x21b, 0x69, 0x431, 0x430, 0x458, 0x442, 0x43e, 0x432, 0x438, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x6aa, 0x644, 0x648,
0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b, 0x645, 0x64a, 0x6af, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b,
0x6af, 0x64a, 0x6af, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b, 0x67d, 0x64a, 0x631, 0x627, 0x20, 0x628, 0x627, 0x626,
0x64a, 0x67d, 0x632, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xdb6, 0xdba, 0xdd2, 0xda7, 0xdca, 0xd9a, 0xdd2, 0xdb6, 0x20, 0x7b, 0x30,
0x7d, 0x3b, 0xdb8, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xd9c, 0xdd2, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xda7, 0xdd9,
0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x6b, 0x69, 0x6c, 0x6f, 0x62, 0x61, 0x69, 0x74, 0x69,
0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x74,
0x65, 0x72, 0x61, 0x62, 0x61, 0x69, 0x74, 0x69, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xbaa, 0xbc8,
0xb9f, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0xc2c, 0xc48, 0xc1f, 0xc4d, 0x200c, 0xc32, 0xc41, 0xc15, 0xc47, 0xc2c, 0xc40, 0x3b, 0xc0e, 0xc2e, 0xc4d,
0x200c, 0xc2c, 0xc3f, 0x3b, 0xc1c, 0xc40, 0xc2c, 0xc40, 0x3b, 0xc1f, 0xc40, 0xc2c, 0xc40, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0xe44,
0xe1a, 0xe15, 0xe4c, 0x70, 0x61, 0x69, 0x74, 0x69, 0x6b, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d, 0x42,
0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x54, 0x42,
0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45, 0x42,
0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x4b, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d, 0x69,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b,
0x54, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30,
0x7d, 0x3b, 0x45, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x62, 0x61, 0xfd, 0x74, 0x431, 0x430, 0x439, 0x442,
0x438, 0x628, 0x627, 0x626, 0x679, 0x62, 0x65, 0x69, 0x74, 0x69, 0x61, 0x75, 0x61, 0x1e6d, 0x61, 0x6d, 0x1e0d, 0x61, 0x6e, 0x6b,
0x41, 0x1e6c, 0x3b, 0x4d, 0x41, 0x1e6c, 0x3b, 0x47, 0x41, 0x1e6c, 0x3b, 0x54, 0x41, 0x1e6c, 0x3b, 0x50, 0x41, 0x1e6c, 0x3b, 0x45,
0x41, 0x1e6c, 0x4b, 0x69, 0x41, 0x1e6c, 0x3b, 0x4d, 0x69, 0x41, 0x1e6c, 0x3b, 0x47, 0x69, 0x41, 0x1e6c, 0x3b, 0x54, 0x69, 0x41,
0x1e6c, 0x3b, 0x50, 0x69, 0x41, 0x1e6c, 0x3b, 0x45, 0x69, 0x41, 0x1e6c, 0x13d7, 0x13d3, 0x13cd, 0x13a6, 0x13b5, 0x13a9, 0x431, 0x430, 0x430,
0x439, 0x442, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62,
0x79, 0x74, 0x65, 0x79
};

static const ushort am_data[] = {
0x41, 0x4d, 0x57, 0x44, 0x76, 0x6d, 0x2e, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x64, 0x69, 0x74, 0x65, 0x73, 0x1325, 0x12cb,
0x1275, 0x635, 0x53f, 0x531, 0x9aa, 0x9c2, 0x9f0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x410, 0x41c, 0xf66, 0xf94, 0xf0b, 0xf46, 0xf0b,
0x41, 0x2e, 0x4d, 0x2e, 0x43f, 0x440, 0x2e, 0x43e, 0x431, 0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x61, 0x2e, 0x20, 0x6d, 0x2e,
0x4e0a, 0x5348, 0x64, 0x6f, 0x70, 0x2e, 0x61, 0x2e, 0x6d, 0x2e, 0x61, 0x6d, 0x61, 0x74, 0x6d, 0x61, 0x70, 0x2e, 0x6d, 0x61,
0x74, 0x69, 0x6e, 0x6d, 0x3c0, 0x2e, 0x3bc, 0x2e, 0x5dc, 0x5e4, 0x5e0, 0x5d4, 0x5f4, 0x5e6, 0x92a, 0x942, 0x930, 0x94d, 0x935, 0x93e,
0x939, 0x94d, 0x928, 0x64, 0x65, 0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x72, 0x2e, 0x6e, 0x2e, 0x5348, 0x524d, 0xcaa, 0xcc2, 0xcb0, 0xccd,
0xcb5, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x442, 0x430, 0x4a3, 0x43a, 0x44b, 0xc624, 0xc804, 0x5a, 0x2e, 0x4d, 0x55, 0x2e, 0xe81, 0xec8, 0xead,
0xe99, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x72, 0x69, 0x65, 0x6b, 0x161, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6e,
0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72, 0x69, 0x65, 0x161, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x440, 0x435, 0x442,
0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x47, 0x92e, 0x2e, 0x92a, 0x942, 0x2e, 0x4af, 0x2e, 0x4e9, 0x63a, 0x2e, 0x645, 0x2e,
0x642, 0x628, 0x644, 0x200c, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61, 0x20, 0x6d, 0x61, 0x6e, 0x68, 0xe3, 0xa2a, 0xa42, 0x2e,
0xa26, 0xa41, 0x2e, 0x4e, 0x44, 0x43f, 0x440, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x20,
0x70, 0x6f, 0x64, 0x6e, 0x65, 0x70, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x440, 0x438, 0x458, 0x435, 0x20,
0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x440, 0x430, 0x437, 0x43c, 0x4d5,
0x635, 0x628, 0x62d, 0x60c, 0x20, 0x645, 0x646, 0x62c, 0x647, 0x646, 0x62f, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x73, 0x6e, 0x2e, 0x66,
0x6d, 0x43f, 0x435, 0x2e, 0x20, 0x447, 0x43e, 0x2e, 0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0xe01, 0xe48, 0xe2d, 0xe19,
0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x1295, 0x1309, 0x1206, 0x20, 0x1230, 0x12d3, 0x1270,
0x68, 0x65, 0x6e, 0x67, 0x69, 0x68, 0x65, 0x6e, 0x67, 0x69, 0xd6, 0xd6, 0x67, 0xfc, 0x6e, 0x6f, 0x72, 0x74, 0x61, 0x64,
0x61, 0x6e, 0x20, 0xf6, 0x148, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x628, 0x6c7, 0x631, 0x6c7, 0x646, 0x434, 0x43f, 0x54,
0x4f, 0x422, 0x41e, 0x53, 0x41, 0x79, 0x62, 0x53, 0x75, 0x62, 0x5e4, 0x5bf, 0x5d0, 0x5b7, 0x5e8, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8,
0x5d2, 0xc0, 0xe1, 0x72, 0x1ecd, 0x300, 0xc0, 0xe1, 0x72, 0x254, 0x300, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67,
0x70, 0x72, 0x69, 0x6a, 0x65, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x41, 0x4e, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79,
0x61, 0x61, 0x2e, 0x14b, 0x64, 0x69, 0x61, 0x6d, 0x20, 0x56, 0x6f, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x61, 0x67, 0xa3b8, 0xa111,
0x69, 0x111, 0x69, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x69, 0x62, 0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x4c,
0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x4b, 0x73, 0x75, 0x62, 0x61, 0x6b, 0x61, 0x4b, 0x69, 0x72, 0x6f, 0x6b,
0x6f, 0x54, 0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x6b, 0x61, 0x6e, 0x67, 0x2019, 0x61, 0x6d, 0x61, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30,
0x2d61, 0x2d5c, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x6e, 0x20, 0x74, 0x75, 0x66, 0x61, 0x74, 0x70, 0x61, 0x6d, 0x69, 0x6c,
0x61, 0x75, 0x75, 0x74, 0x75, 0x6b, 0x6f, 0x4b, 0x49, 0x13cc, 0x13be, 0x13b4, 0x4d, 0x75, 0x68, 0x69, 0x54, 0x4f, 0x4f, 0x75,
0x6c, 0x75, 0x63, 0x68, 0x65, 0x6c, 0x6f, 0x52, 0x168, 0x6b, 0x61, 0x72, 0x6f, 0x6f, 0x6e, 0x1c1, 0x67, 0x6f, 0x61, 0x67,
0x61, 0x73, 0x55, 0x68, 0x72, 0x20, 0x76, 0xf6, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e,
0x6b, 0x61, 0x6b, 0x25b, 0x6e, 0x79, 0xe1, 0x4d, 0x75, 0x6e, 0x6b, 0x79, 0x6f, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61,
0x76, 0x6f, 0x54, 0x61, 0x70, 0x61, 0x72, 0x61, 0x63, 0x68, 0x75, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x4f, 0x44, 0x5a,
0x64, 0x61, 0x74, 0x20, 0x61, 0x7a, 0x61, 0x6c, 0x6d, 0x61, 0x6b, 0x65, 0x6f, 0x92b, 0x941, 0x902, 0x44, 0x69, 0x6e, 0x64,
0x61, 0x6d, 0x6f, 0x69, 0x65, 0x73, 0x61, 0x2e, 0x67, 0x49, 0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x53,
0x75, 0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x69, 0x64, 0x69, 0x253, 0x61, 0x6b, 0xed, 0x6b, 0xed, 0x72, 0xed, 0x67, 0x73,
0xe1, 0x72, 0xfa, 0x77, 0xe1, 0x77, 0x69, 0x63, 0x68, 0x69, 0x73, 0x68, 0x75, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6d, 0x61,
0x6e, 0xe1, 0x52, 0x57, 0x42d, 0x418, 0x4c, 0x77, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x77, 0x75, 0x6b, 0x69, 0x25b, 0x6d, 0x25b,
0x301, 0x25b, 0x6d, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20, 0x6d, 0x61, 0xf1, 0x61, 0x6e, 0x61, 0x6d, 0x62, 0x61, 0xa78c, 0x6d,
0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0x2bc, 0xe1, 0x6d, 0x62, 0x61, 0x2bc, 0x628, 0x2e, 0x646, 0x64, 0x6f, 0x70, 0x6f, 0x142,
0x64, 0x6e, 0x6a, 0x61, 0x69, 0x70, 0x2e
};

static const ushort pm_data[] = {
0x50, 0x4d, 0x57, 0x42, 0x6e, 0x6d, 0x2e, 0x65, 0x20, 0x70, 0x61, 0x73, 0x64, 0x69, 0x74, 0x65, 0x73, 0x12a8, 0x1230, 0x12d3,
0x1275, 0x645, 0x53f, 0x540, 0x985, 0x9aa, 0x9f0, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x41f, 0x41c, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf46, 0xf0b, 0x47,
0x2e, 0x4d, 0x2e, 0x441, 0x43b, 0x2e, 0x43e, 0x431, 0x2e, 0x100a, 0x1014, 0x1031, 0x70, 0x2e, 0x20, 0x6d, 0x2e, 0x4e0b, 0x5348, 0x6f,
0x64, 0x70, 0x2e, 0x70, 0x2e, 0x6d, 0x2e, 0x70, 0x6d, 0x70, 0x74, 0x6d, 0x69, 0x70, 0x2e, 0x73, 0x6f, 0x69, 0x72, 0x66,
0x3bc, 0x2e, 0x3bc, 0x2e, 0x5d0, 0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x905, 0x92a, 0x930, 0x93e, 0x939, 0x94d, 0x928, 0x64, 0x75, 0x2e, 0x65,
0x2e, 0x68, 0x2e, 0x69, 0x2e, 0x6e, 0x2e, 0x5348, 0x5f8c, 0xc85, 0xcaa, 0xcb0, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x442, 0x4af, 0x448, 0x442,
0x4e9, 0x43d, 0x20, 0x43a, 0x438, 0x439, 0x438, 0x43d, 0x43a, 0x438, 0xc624, 0xd6c4, 0x5a, 0x2e, 0x4d, 0x57, 0x2e, 0xeab, 0xebc, 0xeb1,
0xe87, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x113, 0x63, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d, 0x70, 0xf3, 0x6b,
0x77, 0x61, 0x70, 0x6f, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x43e, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x54, 0x47, 0x92e,
0x2e, 0x909, 0x2e, 0x4af, 0x2e, 0x445, 0x63a, 0x2e, 0x648, 0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61,
0x20, 0x74, 0x61, 0x72, 0x64, 0x65, 0xa2c, 0xa3e, 0x2e, 0xa26, 0xa41, 0x2e, 0x4c, 0x4b, 0x43f, 0x43e, 0x20, 0x43f, 0x43e, 0x434,
0x43d, 0x435, 0x70, 0x6f, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20,
0x444, 0x4d5, 0x441, 0x442, 0x4d5, 0x645, 0x646, 0x62c, 0x647, 0x646, 0x62f, 0x60c, 0x20, 0x634, 0x627, 0x645, 0xdb4, 0x2e, 0xdc0, 0x2e,
0x70, 0x6f, 0x70, 0x2e, 0x67, 0x6e, 0x2e, 0x65, 0x6d, 0x43f, 0x430, 0x2e, 0x20, 0x447, 0x43e, 0x2e, 0xbaa, 0xbbf, 0xbb1, 0xbcd,
0xbaa, 0xb95, 0xbb2, 0xbcd, 0xe2b, 0xe25, 0xe31, 0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf51, 0xfb2,
0xf7c, 0xf0b, 0x12f5, 0x1215, 0x122d, 0x20, 0x1230, 0x12d3, 0x1275, 0x65, 0x66, 0x69, 0x61, 0x66, 0x69, 0xd6, 0x53, 0x67, 0xfc, 0x6e,
0x6f, 0x72, 0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x6f, 0x148, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x643, 0x6d0,
0x64a, 0x649, 0x646, 0x43f, 0x43f, 0x54, 0x4b, 0x422, 0x41a, 0x43, 0x48, 0x79, 0x68, 0x4e, 0x67, 0x6f, 0x5e0, 0x5d0, 0x5b8, 0x5db,
0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8, 0x5d2, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x186, 0x300, 0x73, 0xe1, 0x6e, 0x65, 0x74, 0x74, 0x65,
0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x43e, 0x43f, 0x43e, 0x434, 0x43d,
0x435, 0x45, 0x57, 0x92e, 0x2e, 0x928, 0x902, 0x2e, 0x50, 0x2e, 0x4d, 0x2e, 0x128, 0x79, 0x61, 0x77, 0x129, 0x6f, 0x6f, 0x70,
0x2e, 0x263, 0x65, 0x74, 0x72, 0x254, 0x61, 0x6d, 0x20, 0x4e, 0x61, 0x6d, 0x69, 0x74, 0x74, 0x61, 0x67, 0xa06f, 0xa2d2, 0x65,
0x61, 0x68, 0x6b, 0x65, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x65, 0x62, 0x4d, 0x6f, 0x67, 0x6c, 0x75, 0x6d,
0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0x6b, 0x69, 0x6b, 0x69, 0x69, 0x257, 0x65, 0x48, 0x77, 0x61, 0x129, 0x2d, 0x69,
0x6e, 0x129, 0x54, 0x65, 0x69, 0x70, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74, 0x6f, 0x2d5c, 0x2d30, 0x2d37, 0x2d33, 0x2d33, 0x2d6f,
0x2d30, 0x2d5c, 0x74, 0x61, 0x64, 0x67, 0x67, 0x2b7, 0x61, 0x74, 0x6e, 0x20, 0x74, 0x6d, 0x65, 0x64, 0x64, 0x69, 0x74, 0x70,
0x61, 0x6d, 0x75, 0x6e, 0x79, 0x69, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f, 0x6e, 0x79, 0x69, 0x55, 0x54, 0x13d2, 0x13af, 0x13f1,
0x13a2, 0x13d7, 0x13e2, 0x43, 0x68, 0x69, 0x6c, 0x6f, 0x4d, 0x55, 0x55, 0x61, 0x6b, 0x61, 0x73, 0x75, 0x62, 0x61, 0x168, 0x47,
0x6b, 0x6f, 0x6f, 0x73, 0x6b, 0x6f, 0x6c, 0x69, 0x6e, 0x79, 0x1c3, 0x75, 0x69, 0x61, 0x73, 0x55, 0x68, 0x72, 0x20, 0x6e,
0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e, 0x64, 0xe1, 0x6d, 0xe2, 0x45, 0x69, 0x67,
0x75, 0x6c, 0x6f, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x45, 0x62, 0x6f, 0x6e, 0x67, 0x69, 0x41, 0x6c, 0x75,
0x75, 0x6c, 0x61, 0x4f, 0x54, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20, 0x61, 0x7a, 0x61, 0x6e, 0x79, 0x69, 0x61, 0x67,
0x68, 0x75, 0x6f, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x44, 0x69, 0x6c, 0x6f, 0x6c, 0x6f, 0x6e, 0x6f, 0x6d, 0xeb, 0x74,
0x74, 0x65, 0x73, 0x61, 0x2e, 0x6b, 0x49, 0x20, 0x253, 0x75, 0x67, 0x61, 0x6a, 0x254, 0x70, 0x5a, 0x61, 0x61, 0x72, 0x69,
0x6b, 0x61, 0x79, 0x20, 0x62, 0x65, 0x62, 0x79, 0xe1, 0x6d, 0x75, 0x6e, 0x67, 0x259, 0x67, 0xf3, 0x67, 0x259, 0x6c, 0x65,
0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f, 0x6d, 0x63, 0x68, 0x6f, 0x63, 0x68, 0x69, 0x6c, 0x2019, 0x6c, 0x6c, 0x69, 0x6c,
0x6c, 0x69, 0x6b, 0x75, 0x67, 0xfa, 0x54, 0x14a, 0x42d, 0x41a, 0x50, 0x61, 0x73, 0x68, 0x61, 0x6d, 0x69, 0x68, 0x65, 0x6b,
0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64, 0x25b, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20, 0x74, 0x61, 0x72, 0x64, 0x65, 0x14b, 0x6b,
0x61, 0x20, 0x6d, 0x62, 0x254, 0x301, 0x74, 0x20, 0x6e, 0x6a, 0x69, 0x6e, 0x63, 0x77, 0xf2, 0x6e, 0x7a, 0xe9, 0x6d, 0x62f,
0x2e, 0x646, 0x77, 0xf3, 0x74, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x70, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a,
0x75, 0x65, 0x70, 0x2e
};

static const ushort currency_symbol_data[] = {
0x42, 0x72, 0x4b, 0x73, 0x68, 0x52, 0x24, 0x4c, 0x65, 0x6b, 0xeb, 0x64, 0x65, 0x6e, 0x20ac, 0x1265, 0x122d, 0x62c, 0x2e, 0x645,
0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e, 0x628, 0x2e, 0x200f, 0x46, 0x43, 0x46, 0x41, 0x43, 0x46, 0x46, 0x64,
0x6a, 0x4e, 0x66, 0x6b, 0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x20aa, 0x62f, 0x2e, 0x623, 0x2e, 0x200f, 0x62f, 0x2e, 0x643, 0x2e, 0x200f,
0x644, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x645, 0x2e, 0x200f, 0x631, 0x2e, 0x639, 0x2e, 0x200f,
0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x631, 0x2e, 0x633, 0x2e, 0x200f, 0x53, 0x62c, 0x2e, 0x633, 0x2e, 0x644, 0x2e, 0x633, 0x2e, 0x200f,
0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f, 0x631, 0x2e, 0x64a, 0x2e, 0x200f, 0xa3, 0x58f, 0x20b9, 0x20bc, 0x20bd,
0x9f3, 0x4e, 0x75, 0x2e, 0x43b, 0x432, 0x2e, 0x4b, 0x17db, 0xffe5, 0x48, 0x4b, 0x24, 0x4d, 0x4f, 0x50, 0x24, 0x48, 0x52, 0x4b,
0x4b, 0x4d, 0x4b, 0x10d, 0x6b, 0x72, 0x2e, 0x41, 0x66, 0x6c, 0x2e, 0x4e, 0x41, 0x66, 0x2e, 0x55, 0x53, 0x24, 0x50, 0x46,
0x42, 0x75, 0x44, 0x47, 0x48, 0x20b5, 0x41, 0x72, 0x4d, 0x4b, 0x52, 0x4d, 0x52, 0x73, 0x20a6, 0x20b1, 0x52, 0x46, 0x57, 0x53,
0x24, 0x53, 0x52, 0x4c, 0x65, 0x45, 0x6b, 0x72, 0x54, 0x53, 0x68, 0x54, 0x24, 0x55, 0x53, 0x68, 0x56, 0x54, 0x44, 0x41,
0x43, 0x46, 0x41, 0x46, 0x43, 0x46, 0x43, 0x46, 0x50, 0x46, 0x47, 0x47, 0x55, 0x4d, 0x4d, 0x41, 0x44, 0x43, 0x48, 0x46,
0x4c, 0x53, 0x44, 0x54, 0x20be, 0x20b2, 0x46, 0x74, 0x49, 0x53, 0x4b, 0x52, 0x70, 0x43, 0x41, 0x24, 0x20b8, 0x441, 0x43e, 0x43c,
0x20a9, 0x4b, 0x50, 0x57, 0x20ba, 0x20ad, 0x4b, 0x7a, 0x434, 0x435, 0x43d, 0x4e, 0x5a, 0x24, 0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947,
0x930, 0x942, 0x60b, 0x631, 0x6cc, 0x627, 0x644, 0x7a, 0x142, 0x52, 0x24, 0x200b, 0x4d, 0x54, 0x6e, 0x44, 0x62, 0x631, 0x53, 0x2f,
0x42, 0x73, 0x52, 0x4f, 0x4e, 0x4c, 0x20b4, 0x52, 0x53, 0x44, 0x41a, 0x41c, 0xdbb, 0xdd4, 0x2e, 0x20a1, 0x52, 0x44, 0x24, 0x51,
0x43, 0x24, 0x42, 0x2f, 0x2e, 0x47, 0x73, 0x2e, 0x42, 0x73, 0x2e, 0x441, 0x43e, 0x43c, 0x2e, 0x52, 0x73, 0x2e, 0x54, 0x48,
0x42, 0xa5, 0x54, 0x4d, 0x54, 0x73, 0x6f, 0x2bb, 0x6d, 0x441, 0x45e, 0x43c, 0x20ab, 0x4e, 0x54, 0x24, 0x41, 0x24, 0x49, 0x52,
0x52
};

static const ushort currency_display_name_data[] = {
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x20, 0x42, 0x69,
0x72, 0x72, 0x69, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69,
0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x4c, 0x65, 0x6b, 0x75, 0x20, 0x73, 0x68,
0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72,
0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0xeb, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x44, 0x65,
0x6e, 0x61, 0x72, 0x69, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61,
0x72, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61, 0x72,
0xeb, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x6a, 0x61, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20,
0x1265, 0x122d, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275,
0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x627, 0x646, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x645, 0x635,
0x631, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x646, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631,
0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x629, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a,
0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646,
0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633,
0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641,
0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646,
0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642,
0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642,
0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a,
0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c,
0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a,
0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627,
0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a,
0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20,
0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b,
0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639,
0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639,
0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x634, 0x64a, 0x643,
0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644,
0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20,
0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625,
0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633,
0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631,
0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627,
0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644,
0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644,
0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x627, 0x646, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x644, 0x64a,
0x628, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a,
0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648,
0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20,
0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a,
0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a,
0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x627,
0x646, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x631, 0x627, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628,
0x64a, 0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x64b, 0x627, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x631,
0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645,
0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645,
0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635,
0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646,
0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634,
0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646,
0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633,
0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x627, 0x62a, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a,
0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631,
0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633,
0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629,
0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627,
0x646, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x62a, 0x648,
0x646, 0x633, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x64b, 0x627,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645,
0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f,
0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627,
0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631,
0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631,
0x627, 0x62a, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c,
0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648,
0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x646, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b,
0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x3b, 0x3b, 0x570, 0x561,
0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20,
0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b,
0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62,
0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61,
0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62,
0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b,
0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac,
0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af,
0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf,
0x3b, 0x3b, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0xf51, 0xf44, 0xf74,
0xf63, 0xf0b, 0xf40, 0xfb2, 0xf58, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x61, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x69,
0x6f, 0xf9, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435,
0x432, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x3b, 0x3b,
0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x430, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019,
0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000,
0x103b, 0x1015, 0x103a, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c,
0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c, 0x3b, 0x3b,
0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x44f, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x456, 0x3b, 0x431, 0x435, 0x43b,
0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x451, 0x45e, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440,
0x443, 0x441, 0x43a, 0x430, 0x433, 0x430, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2,
0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787,
0x17b6, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x73, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x6fb3, 0x95e8, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x65b0,
0x52a0, 0x5761, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x65b0, 0x53f0, 0x5e63, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x53f0, 0x5e63, 0x3b,
0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74,
0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x65, 0x20, 0x6b,
0x75, 0x6e, 0x65, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b,
0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b,
0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61,
0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b,
0x65, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61,
0x72, 0x61, 0x6b, 0x61, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d,
0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b,
0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d,
0x65, 0x73, 0x6b, 0xfd, 0x63, 0x68, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61,
0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73,
0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73,
0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d,
0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b,
0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61,
0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67,
0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x73, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42,
0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42,
0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x50, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77,
0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e,
0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x73, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46,
0x41, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72,
0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x65,
0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x43, 0x61,
0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61,
0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72,
0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72,
0x65, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20,
0x6e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61,
0x6b, 0x66, 0x61, 0x73, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c,
0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x46,
0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x55, 0x4b, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70,
0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x61,
0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20,
0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x73, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x43, 0x65, 0x64,
0x69, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b,
0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x73, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61,
0x6c, 0x74, 0x61, 0x72, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61,
0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72,
0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70,
0x65, 0x65, 0x73, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x53, 0x68, 0x65, 0x6b,
0x65, 0x6c, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x73, 0x68, 0x65, 0x6b,
0x65, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x73, 0x68,
0x65, 0x6b, 0x65, 0x6c, 0x73, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x61, 0x74, 0x61, 0x63,
0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x73, 0x3b, 0x4d,
0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61,
0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x67,
0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x69, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61,
0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x6b,
0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x6b, 0x77,
0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x69, 0x6e, 0x67,
0x67, 0x69, 0x74, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69, 0x6e, 0x67, 0x67,
0x69, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69, 0x6e, 0x67,
0x67, 0x69, 0x74, 0x73, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65,
0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62,
0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20,
0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72, 0x61, 0x73,
0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x50, 0x61,
0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x6b,
0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20,
0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4b, 0x69, 0x6e, 0x61, 0x3b, 0x3b, 0x50, 0x61,
0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61,
0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x69,
0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x73, 0x3b,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64,
0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x54, 0x61, 0x6c, 0x61, 0x3b, 0x3b,
0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61,
0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x52,
0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72, 0x75,
0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72,
0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e,
0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65,
0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c,
0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70,
0x6f, 0x72, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64,
0x3b, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b,
0x3b, 0x3b, 0x53, 0x74, 0x2e, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b,
0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x64, 0x61,
0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65,
0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x4c, 0x69, 0x6c, 0x61,
0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x6c, 0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65,
0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x65,
0x6e, 0x69, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x53, 0x77,
0x65, 0x64, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69,
0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x46, 0x72, 0x61, 0x6e,
0x63, 0x3b, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77,
0x69, 0x73, 0x73, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e,
0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e,
0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20,
0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61,
0x6e, 0x67, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67,
0x61, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20,
0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54,
0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e,
0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x73, 0x3b, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b,
0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b,
0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x42, 0x72,
0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68,
0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f,
0x75, 0x6e, 0x64, 0x73, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x56, 0x61, 0x74, 0x75, 0x3b, 0x3b, 0x56,
0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61,
0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x73, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61,
0x63, 0x68, 0x61, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x53,
0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b,
0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e,
0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20,
0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41,
0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x47, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x4e, 0x65,
0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20,
0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e,
0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72,
0x73, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x74, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b,
0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72,
0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x61, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b,
0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64,
0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75,
0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x62, 0x75,
0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42,
0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41,
0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45,
0x41, 0x43, 0x29, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b,
0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63,
0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f,
0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69,
0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69,
0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b,
0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9,
0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e,
0x73, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b,
0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x73, 0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x61,
0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61,
0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72,
0x79, 0x73, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x73, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61,
0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79,
0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x6f, 0x75, 0x67,
0x75, 0x69, 0x79, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x72,
0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x72,
0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65,
0x73, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x64,
0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69,
0x72, 0x68, 0x61, 0x6d, 0x73, 0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77,
0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x72, 0x77, 0x61,
0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79,
0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20,
0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65,
0x73, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69,
0x73, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65,
0x73, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x6c, 0x69,
0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72,
0x65, 0x73, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74,
0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73,
0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69,
0x65, 0x6e, 0x73, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b,
0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x76, 0x61,
0x74, 0x75, 0x73, 0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x73, 0x3b, 0x50, 0x75, 0x6e, 0x6e, 0x64,
0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53,
0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61,
0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70, 0x75, 0x69, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x68, 0x61, 0x73, 0x61, 0x6e, 0x6e,
0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68,
0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3,
0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da,
0x10d0, 0x10e0, 0x10d8, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75,
0x72, 0x6f, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e,
0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b,
0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e,
0x3b, 0x395, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b,
0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b,
0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x6e, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x3b,
0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e,
0x69, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0,
0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf,
0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61,
0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x20,
0x5d7, 0x5d3, 0x5e9, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7,
0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x5e9, 0x5e7,
0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a,
0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b,
0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x90f, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66,
0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74,
0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0xed, 0x73,
0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b,
0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20,
0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65,
0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f,
0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20,
0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x20,
0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x69, 0x3b, 0x65e5, 0x672c, 0x5186, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5186, 0x3b,
0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0,
0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0,
0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0xc97, 0xcb3, 0xcc1, 0x3b, 0x6c1, 0x650, 0x646, 0x62f, 0x64f, 0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20,
0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430,
0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d,
0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430,
0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d,
0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e,
0x43c, 0x443, 0x3b, 0x3b, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c,
0x443, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0,
0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b,
0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72, 0x79, 0x2019, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69,
0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x79,
0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61,
0x20, 0x79, 0x61, 0x20, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c,
0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x45, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x69, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x173, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438,
0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434,
0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434,
0x435, 0x43d, 0x430, 0x440, 0x438, 0x3b, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52,
0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x44, 0x6f,
0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61,
0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67, 0x61,
0x70, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67,
0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0xd07,
0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f,
0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x77,
0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b,
0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x947, 0x3b, 0x442, 0x4e9, 0x433, 0x440,
0x4e9, 0x433, 0x3b, 0x3b, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x3b, 0x3b, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433,
0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b, 0x928, 0x947, 0x92a,
0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b, 0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932,
0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a,
0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e,
0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x6e,
0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e,
0x65, 0x72, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x3b, 0xb2d, 0xb3e, 0xb30,
0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x3b, 0x3b, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20,
0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd,
0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627,
0x646, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627,
0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646,
0x633, 0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a,
0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a,
0x627, 0x646, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f,
0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x20, 0x70, 0x6f, 0x6c,
0x73, 0x6b, 0x69, 0x65, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x63, 0x68, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x63,
0x68, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x67, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x67, 0x6f, 0x3b,
0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x52, 0x65, 0x61,
0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x69,
0x73, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x73, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61,
0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e,
0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x73, 0x20, 0x61, 0x6e,
0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d,
0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62,
0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f,
0x73, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c,
0x61, 0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f,
0x73, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73,
0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x64,
0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x46, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x46, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x50,
0x61, 0x74, 0x61, 0x63, 0x61, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x3b, 0x50, 0x61, 0x74, 0x61,
0x63, 0x61, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x74, 0x61, 0x63,
0x61, 0x73, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20,
0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63,
0x61, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69,
0x71, 0x75, 0x65, 0x3b, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x26, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63,
0x69, 0x70, 0x65, 0x20, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x28, 0x32, 0x30, 0x31, 0x38, 0x29, 0x3b, 0x3b, 0x53, 0xe3,
0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x26, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x20, 0x64, 0x6f,
0x62, 0x72, 0x61, 0x20, 0x28, 0x32, 0x30, 0x31, 0x38, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f,
0x6d, 0xe9, 0x20, 0x26, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x20, 0x64, 0x6f, 0x62, 0x72, 0x61, 0x73,
0x20, 0x28, 0x32, 0x30, 0x31, 0x38, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f,
0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x73, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30,
0xa41, 0xa2a, 0xa07, 0xa06, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b, 0x3b, 0x3b,
0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa0f, 0x3b, 0x631, 0x648, 0x67e, 0x626, 0x6cc, 0x6c1, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e,
0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c,
0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f,
0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e,
0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x63,
0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b,
0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x440, 0x43e, 0x441,
0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438,
0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x445,
0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443,
0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b,
0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439,
0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b,
0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437,
0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x445, 0x20,
0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x442, 0x435, 0x43d,
0x433, 0x435, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a,
0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438,
0x437, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438,
0x445, 0x20, 0x441, 0x43e, 0x43c, 0x43e, 0x432, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b,
0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b, 0x3b, 0x43c, 0x43e, 0x43b,
0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a,
0x438, 0x445, 0x20, 0x43b, 0x435, 0x435, 0x432, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x43b, 0x435, 0x44f, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d,
0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x430,
0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x435, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b,
0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x3b, 0x443, 0x43a,
0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x43e, 0x439, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b, 0x66, 0x61, 0x72, 0xe2,
0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x421, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a,
0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x430, 0x20, 0x434, 0x438, 0x43d, 0x430,
0x440, 0x430, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x42,
0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61,
0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61,
0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61,
0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61,
0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67,
0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65,
0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72,
0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62,
0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x45, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x53, 0x72, 0x70, 0x73,
0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e,
0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x61, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x73,
0x72, 0x70, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b, 0x411, 0x43e, 0x441, 0x430, 0x43d, 0x441,
0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432,
0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441,
0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a,
0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b,
0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a,
0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a,
0x65, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432,
0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445,
0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x415, 0x432, 0x440, 0x43e, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x43e, 0x3b, 0x3b,
0x435, 0x432, 0x440, 0x430, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x41b, 0x430, 0x440, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x3b,
0x3b, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x44b, 0x3b, 0x421, 0x43e, 0x43c, 0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b,
0x441, 0x43e, 0x43c, 0x44b, 0x3b, 0x44, 0x6f, 0x72, 0x61, 0x20, 0x72, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x64a, 0x20, 0x631, 0x67e, 0x64a, 0x3b,
0x3b, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x64a, 0x20, 0x631, 0x67e, 0x64a, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6aa,
0x633, 0x62a, 0x627, 0x646, 0x64a, 0x20, 0x631, 0x67e, 0x64a, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf,
0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20,
0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x3b, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf,
0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0xe1, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x65, 0x75, 0x72, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b,
0x65, 0x76, 0x72, 0x6f, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x65, 0x76, 0x72, 0x69, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f,
0x76, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x20, 0x4a, 0x61, 0x62, 0x62, 0x75, 0x75, 0x74, 0x69, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x62, 0x69, 0x79, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e,
0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3,
0x6c, 0x61, 0x72, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20,
0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20,
0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69,
0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0xf1, 0x6f, 0x3b,
0x3b, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x72,
0x65, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x50, 0x65, 0x73,
0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c,
0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f,
0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70,
0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65,
0x73, 0x6f, 0x73, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0x6f, 0x6c, 0xf3,
0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0x6f, 0x6c,
0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x63, 0x6f, 0x6c, 0x6f, 0x6e, 0x65, 0x73, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73,
0x65, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f,
0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x75, 0x62,
0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64,
0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b,
0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73,
0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75,
0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20,
0x64, 0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20,
0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43,
0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c,
0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x3b, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x3b, 0x3b, 0x3b,
0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x65, 0x73, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68,
0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f,
0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x73, 0x20,
0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69,
0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63,
0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b,
0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73,
0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x73, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61,
0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d,
0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x73, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f,
0x73, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b,
0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x65, 0x73, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79,
0x6f, 0x73, 0x3b, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x20,
0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x65, 0x73, 0x20, 0x70, 0x65, 0x72,
0x75, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x3b,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65,
0x73, 0x6f, 0x73, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75,
0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61,
0x79, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f,
0x73, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x65, 0x73, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f,
0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61,
0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20,
0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x7a, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x79,
0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x7a,
0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20,
0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67,
0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67,
0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20,
0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b,
0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x76, 0x65,
0x6e, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0x421, 0x43e, 0x43c, 0x43e, 0x43d, 0x4e3, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x421, 0x43e, 0x43c, 0x43e, 0x43d, 0x4e3, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2,
0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b,
0x3b, 0x3b, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b,
0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd, 0x3b, 0x3b, 0xbae,
0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b,
0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd, 0xb95, 0xbb3, 0xbcd,
0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0x3b, 0x3b,
0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0x3b, 0x3b, 0x3b,
0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd, 0xb95, 0xbb3,
0xbcd, 0x3b, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0xb87, 0xbb2, 0xb99,
0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8,
0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f, 0x20, 0x441, 0x443,
0x43c, 0x44b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x441, 0x443, 0x43c, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x3b, 0x3b,
0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x3b, 0x3b, 0x3b, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc32, 0xc41, 0x3b, 0xe1a, 0xe32,
0xe17, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xe1a, 0xe32, 0xe17, 0xe44, 0xe17, 0xe22, 0x3b, 0xf61, 0xf74, 0xf0b, 0xf68, 0xf53, 0xf0b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0xf66, 0xf92, 0xf7c, 0xf62, 0xf0b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e,
0x67, 0x61, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x4c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x54, 0xfc, 0x72, 0x6b,
0x20, 0x6c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x6c, 0x69, 0x72, 0x61,
0x73, 0x131, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x3b, 0x3b, 0x74,
0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x74, 0xfc, 0x72,
0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8,
0x6d5, 0x646, 0x649, 0x3b, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x3b, 0x3b, 0x3b,
0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c,
0x43a, 0x430, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433,
0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456,
0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9,
0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a,
0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e,
0x6cc, 0x6c1, 0x3b, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b,
0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6d2, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73,
0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74,
0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73,
0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x3b, 0x40e,
0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431,
0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7,
0x74, 0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74,
0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x70, 0x75,
0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x62, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64,
0x61, 0x69, 0x6e, 0x3b, 0x62, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x70, 0x75, 0x6e,
0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64,
0x61, 0x69, 0x6e, 0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x46, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x62, 0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x20, 0x53, 0x6f, 0x77, 0x77,
0x75, 0x2d, 0x6a, 0x61, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46,
0x41, 0x20, 0x79, 0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x20, 0x53, 0x6f, 0x77, 0x77, 0x75, 0x2d, 0x6a, 0x61, 0x6e,
0x74, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x301, 0xe8, 0x64, 0x65,
0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x72, 0x61,
0x6e, 0x73, 0x69, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x42, 0x49, 0x4b,
0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f,
0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x42, 0x6f, 0x73,
0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f,
0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62,
0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20,
0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b,
0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b,
0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b,
0x65, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61,
0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20,
0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x41a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430,
0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440,
0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438,
0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d,
0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442,
0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a,
0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432,
0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x47, 0x68,
0x61, 0x6e, 0x61, 0x20, 0x53, 0x69, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x4e, 0x52, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x4e, 0x52, 0x3b, 0x4e, 0x61, 0x1ecb, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61,
0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b,
0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46,
0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256,
0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65,
0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x50, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69,
0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e,
0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69,
0x6e, 0x61, 0x73, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65,
0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b,
0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x45,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61,
0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75,
0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167,
0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72,
0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64,
0x6e, 0x6f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61,
0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x69, 0x20,
0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67,
0x69, 0x79, 0x79, 0x61, 0x20, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x43, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x4e, 0x6a, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x65, 0x6c, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d,
0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61,
0x20, 0x79, 0x61, 0x73, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x2d30, 0x2d37, 0x2d54, 0x2d49, 0x2d4e, 0x20, 0x2d4f, 0x20, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x64, 0x72, 0x69, 0x6d, 0x20, 0x6e, 0x20, 0x6c, 0x6d, 0x263, 0x72, 0x69, 0x62,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x41, 0x7a, 0x7a, 0x61, 0x79, 0x72,
0x69, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x6e, 0x20, 0x5a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x49, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x65, 0x6e, 0x20, 0x6e, 0x20, 0x5a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x3b,
0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x48, 0x75,
0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3,
0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x20, 0x6d, 0x6f, 0x72,
0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0xed, 0x69, 0x6e, 0x67,
0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x79, 0x61, 0x20, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72,
0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62,
0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x74, 0x61, 0x62,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x61, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75,
0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20,
0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69, 0x79,
0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e,
0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74,
0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x6d, 0x61,
0x72, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x65, 0x72, 0x68, 0x65, 0x6d,
0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c,
0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x930, 0x93e, 0x902, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d,
0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b,
0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x44c, 0x43c, 0x430, 0x448, 0x3b, 0x440, 0x461, 0x441, 0x441,
0x456, 0x301, 0x439, 0x441, 0x43a, 0x457, 0x439, 0x20, 0x440, 0xa64b, 0x301, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x440, 0x461, 0x441, 0x441, 0x456, 0x301, 0x439, 0x441, 0x43a, 0x430, 0x433, 0x461, 0x20, 0x440, 0xa64b, 0x431, 0x43b, 0x467, 0x300, 0x3b,
0x4e, 0x66, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0xe0, 0x6c, 0xe2, 0x14b, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x65, 0x66, 0x61, 0x20, 0x79, 0x61, 0x74, 0x69, 0x20, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x259, 0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20,
0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0xe1, 0x14b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x61, 0x69, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430, 0x20, 0x441, 0x43e, 0x43b, 0x43a, 0x443, 0x43e, 0x431, 0x430, 0x439,
0x430, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430, 0x20, 0x441, 0x43e, 0x43b,
0x43a, 0x443, 0x43e, 0x431, 0x430, 0x439, 0x430, 0x3b, 0x49, 0x68, 0x65, 0x6c, 0x61, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e,
0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x20, 0xa55c, 0xa55e,
0xa54c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x20, 0x44, 0x61, 0x6c,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x25b, 0x6c, 0xe2, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x72,
0xe8, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x65, 0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x62f, 0x6cc, 0x646, 0x627, 0x631, 0x6cc, 0x20, 0x639, 0x6ce, 0x631, 0x627, 0x642, 0x6cc, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x695, 0x6cc, 0x627, 0x6b5, 0x6cc, 0x20, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x65, 0x75, 0x72, 0x61, 0x6a, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x77, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x20, 0x631, 0x6cc, 0x627, 0x644,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x20, 0x631, 0x6cc, 0x627, 0x644, 0x3b, 0x6e2f, 0x5e63, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5e63, 0x3b
};

static const ushort currency_format_data[] = {
0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x25, 0x32,
0x25, 0x31, 0x4b, 0x25, 0x32, 0xa0, 0x2d, 0x25, 0x31, 0x28, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x29, 0x25, 0x32, 0x2d, 0x25,
0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x4b, 0x25, 0x31, 0xa0, 0x6b, 0x25, 0x32, 0x2d, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x25,
0x32, 0xa0, 0x25, 0x31, 0x2d, 0x25, 0x32, 0x2212, 0x25, 0x31, 0x200f, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x200f, 0x200e, 0x2d, 0x25,
0x31, 0xa0, 0x25, 0x32, 0x200e, 0x25, 0x32, 0x25, 0x31, 0x28, 0x25, 0x32, 0x25, 0x31, 0x29, 0x25, 0x31, 0xa0, 0x4b, 0xa0,
0x25, 0x32, 0x25, 0x32, 0x2d, 0xa0, 0x25, 0x31
};

static const ushort endonyms_data[] = {
0x4f, 0x72, 0x6f, 0x6d, 0x6f, 0x6f, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x4b, 0x65, 0x65, 0x6e,
0x69, 0x79, 0x61, 0x61, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0xeb, 0x73, 0x68, 0x71, 0x69, 0x70, 0x53, 0x68, 0x71, 0x69,
0x70, 0xeb, 0x72, 0x69, 0x4d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x69, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0xeb, 0x12a0, 0x121b,
0x122d, 0x129b, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x645, 0x635, 0x631, 0x627, 0x644, 0x62c,
0x632, 0x627, 0x626, 0x631, 0x627, 0x644, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x62a, 0x634, 0x627, 0x62f, 0x62c, 0x632, 0x631, 0x20, 0x627,
0x644, 0x642, 0x645, 0x631, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x625, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x627, 0x627, 0x644, 0x639,
0x631, 0x627, 0x642, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x627, 0x644, 0x623, 0x631, 0x62f, 0x646, 0x627, 0x644, 0x643, 0x648,
0x64a, 0x62a, 0x644, 0x628, 0x646, 0x627, 0x646, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x627, 0x627, 0x644, 0x645, 0x63a, 0x631, 0x628, 0x639, 0x64f, 0x645, 0x627, 0x646, 0x627, 0x644, 0x623, 0x631, 0x627, 0x636, 0x64a, 0x20,
0x627, 0x644, 0x641, 0x644, 0x633, 0x637, 0x64a, 0x646, 0x64a, 0x629, 0x642, 0x637, 0x631, 0x627, 0x644, 0x645, 0x645, 0x644, 0x643, 0x629,
0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x629, 0x627, 0x644, 0x635,
0x648, 0x645, 0x627, 0x644, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x633, 0x648, 0x631, 0x64a, 0x627, 0x62a, 0x648, 0x646, 0x633,
0x627, 0x644, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x645,
0x62a, 0x62d, 0x62f, 0x629, 0x627, 0x644, 0x635, 0x62d, 0x631, 0x627, 0x621, 0x20, 0x627, 0x644, 0x63a, 0x631, 0x628, 0x64a, 0x629, 0x627,
0x644, 0x64a, 0x645, 0x646, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x627, 0x644, 0x639, 0x631,
0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x631, 0x633, 0x645, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x62d, 0x62f, 0x64a, 0x62b, 0x629, 0x627,
0x644, 0x639, 0x627, 0x644, 0x645, 0x570, 0x561, 0x575, 0x565, 0x580, 0x565, 0x576, 0x540, 0x561, 0x575, 0x561, 0x57d, 0x57f, 0x561, 0x576,
0x985, 0x9b8, 0x9ae, 0x9c0, 0x9af, 0x9bc, 0x9be, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x61, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61,
0x6e, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x430, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430,
0x43d, 0x410, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61, 0x45, 0x73,
0x70, 0x61, 0x69, 0x6e, 0x69, 0x61, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9ad,
0x9be, 0x9b0, 0x9a4, 0xf62, 0xfab, 0xf7c, 0xf44, 0xf0b, 0xf41, 0xf60, 0xf56, 0xfb2, 0xf74, 0xf42, 0x62, 0x72, 0x65, 0x7a, 0x68, 0x6f,
0x6e, 0x65, 0x67, 0x46, 0x72, 0x61, 0xf1, 0x73, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x411, 0x44a, 0x43b,
0x433, 0x430, 0x440, 0x438, 0x44f, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x430,
0x44f, 0x411, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x44c, 0x1781, 0x17d2, 0x1798, 0x17c2, 0x179a, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787,
0x17b6, 0x63, 0x61, 0x74, 0x61, 0x6c, 0xe0, 0x45, 0x73, 0x70, 0x61, 0x6e, 0x79, 0x61, 0x41, 0x6e, 0x64, 0x6f, 0x72, 0x72,
0x61, 0x46, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x49, 0x74, 0xe0, 0x6c, 0x69, 0x61, 0x7b80, 0x4f53, 0x4e2d, 0x6587, 0x4e2d, 0x56fd, 0x4e2d,
0x56fd, 0x9999, 0x6e2f, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x4e2d, 0x56fd, 0x6fb3, 0x95e8, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x65b0, 0x52a0, 0x5761,
0x7e41, 0x9ad4, 0x4e2d, 0x6587, 0x4e2d, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x4e2d, 0x570b, 0x6fb3, 0x9580, 0x7279, 0x5225, 0x884c,
0x653f, 0x5340, 0x53f0, 0x7063, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x48, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61,
0x42, 0x6f, 0x73, 0x6e, 0x61, 0x20, 0x69, 0x20, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x69, 0x6e, 0x61, 0x10d,
0x65, 0x161, 0x74, 0x69, 0x6e, 0x61, 0x10c, 0x65, 0x73, 0x6b, 0x6f, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x44, 0x61, 0x6e, 0x6d,
0x61, 0x72, 0x6b, 0x47, 0x72, 0xf8, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x41, 0x72, 0x75, 0x62, 0x61, 0x42, 0x65, 0x6c, 0x67, 0x69,
0xeb, 0x43, 0x75, 0x72, 0x61, 0xe7, 0x61, 0x6f, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x61, 0x72, 0x69,
0x62, 0x69, 0x73, 0x63, 0x68, 0x20, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x53, 0x69, 0x6e, 0x74, 0x2d,
0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c,
0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x67, 0x6c,
0x69, 0x73, 0x68, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x41, 0x6e, 0x67,
0x75, 0x69, 0x6c, 0x6c, 0x61, 0x41, 0x6e, 0x74, 0x69, 0x67, 0x75, 0x61, 0x20, 0x26, 0x20, 0x42, 0x61, 0x72, 0x62, 0x75,
0x64, 0x61, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x41, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61, 0x42, 0x61, 0x68, 0x61,
0x6d, 0x61, 0x73, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x6f, 0x73, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x75, 0x6d, 0x42, 0x65,
0x6c, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x42,
0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e, 0x20,
0x54, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x43, 0x61, 0x6d, 0x65,
0x72, 0x6f, 0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x6d, 0x61, 0x73, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x63, 0x6f,
0x73, 0x20, 0x28, 0x4b, 0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x29, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43,
0x6f, 0x6f, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x79, 0x70, 0x72, 0x75, 0x73, 0x44, 0x65, 0x6e,
0x6d, 0x61, 0x72, 0x6b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x46,
0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x46, 0x69, 0x6a, 0x69, 0x46,
0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x47, 0x75, 0x65, 0x72, 0x6e, 0x73, 0x65, 0x79, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61,
0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x79, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61,
0x72, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x47, 0x75, 0x61, 0x6d, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x48, 0x6f,
0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x53, 0x41, 0x52, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x64,
0x69, 0x61, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x4a, 0x61, 0x6d, 0x61, 0x69,
0x63, 0x61, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x4b, 0x69, 0x72, 0x69, 0x62, 0x61, 0x74, 0x69, 0x4c, 0x65, 0x73, 0x6f, 0x74,
0x68, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x20, 0x53, 0x41, 0x52, 0x20, 0x43,
0x68, 0x69, 0x6e, 0x61, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x63, 0x61, 0x72, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69,
0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x4d, 0x61, 0x6c, 0x74, 0x61, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c,
0x6c, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x75, 0x73, 0x4d, 0x69,
0x63, 0x72, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x4d, 0x6f, 0x6e, 0x74, 0x73, 0x65, 0x72, 0x72, 0x61, 0x74, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x4e, 0x61, 0x75, 0x72, 0x75, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x4e,
0x69, 0x75, 0x65, 0x4e, 0x6f, 0x72, 0x66, 0x6f, 0x6c, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x6f, 0x72,
0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x61, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x50, 0x61, 0x6c, 0x61, 0x75, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20,
0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65,
0x73, 0x50, 0x69, 0x74, 0x63, 0x61, 0x69, 0x72, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x75, 0x65,
0x72, 0x74, 0x6f, 0x20, 0x52, 0x69, 0x63, 0x6f, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x4b, 0x69,
0x74, 0x74, 0x73, 0x20, 0x26, 0x20, 0x4e, 0x65, 0x76, 0x69, 0x73, 0x53, 0x74, 0x2e, 0x20, 0x4c, 0x75, 0x63, 0x69, 0x61,
0x53, 0x74, 0x2e, 0x20, 0x56, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x26, 0x20, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64,
0x69, 0x6e, 0x65, 0x73, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x53,
0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65,
0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x61, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61,
0x6e, 0x64, 0x73, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x53, 0x74, 0x2e, 0x20, 0x48,
0x65, 0x6c, 0x65, 0x6e, 0x61, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x6c, 0x61, 0x6e, 0x64, 0x53,
0x77, 0x65, 0x64, 0x65, 0x6e, 0x53, 0x77, 0x69, 0x74, 0x7a, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x6e, 0x7a,
0x61, 0x6e, 0x69, 0x61, 0x54, 0x6f, 0x6b, 0x65, 0x6c, 0x61, 0x75, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x54, 0x72, 0x69, 0x6e,
0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x54, 0x75, 0x72, 0x6b, 0x73, 0x20, 0x26,
0x20, 0x43, 0x61, 0x69, 0x63, 0x6f, 0x73, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x54, 0x75, 0x76, 0x61, 0x6c,
0x75, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69,
0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x55, 0x2e, 0x53, 0x2e,
0x20, 0x4f, 0x75, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x56, 0x61, 0x6e,
0x75, 0x61, 0x74, 0x75, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x5a, 0x69, 0x6d, 0x62, 0x61, 0x62, 0x77, 0x65, 0x44,
0x69, 0x65, 0x67, 0x6f, 0x20, 0x47, 0x61, 0x72, 0x63, 0x69, 0x61, 0x49, 0x73, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x4d,
0x61, 0x6e, 0x4a, 0x65, 0x72, 0x73, 0x65, 0x79, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x53,
0x69, 0x6e, 0x74, 0x20, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x45, 0x75, 0x72, 0x6f,
0x70, 0x65, 0x65, 0x73, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x74, 0x6f, 0x65, 0x65, 0x73, 0x74, 0x69, 0x45, 0x65, 0x73, 0x74,
0x69, 0x66, 0xf8, 0x72, 0x6f, 0x79, 0x73, 0x6b, 0x74, 0x46, 0xf8, 0x72, 0x6f, 0x79, 0x61, 0x72, 0x73, 0x75, 0x6f, 0x6d,
0x69, 0x53, 0x75, 0x6f, 0x6d, 0x69, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x65,
0x41, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x71, 0x75, 0x65, 0x42, 0xe9, 0x6e, 0x69, 0x6e,
0x42, 0x75, 0x72, 0x6b, 0x69, 0x6e, 0x61, 0x20, 0x46, 0x61, 0x73, 0x6f, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x75, 0x6e,
0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x52, 0xe9, 0x70,
0x75, 0x62, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x66, 0x72, 0x69, 0x63, 0x61, 0x69,
0x6e, 0x65, 0x54, 0x63, 0x68, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x6f, 0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d,
0x4b, 0x69, 0x6e, 0x73, 0x68, 0x61, 0x73, 0x61, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d, 0x42, 0x72, 0x61, 0x7a, 0x7a, 0x61,
0x76, 0x69, 0x6c, 0x6c, 0x65, 0x43, 0xf4, 0x74, 0x65, 0x20, 0x64, 0x2019, 0x49, 0x76, 0x6f, 0x69, 0x72, 0x65, 0x44, 0x6a,
0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x20, 0xe9, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72,
0x69, 0x61, 0x6c, 0x65, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65,
0x50, 0x6f, 0x6c, 0x79, 0x6e, 0xe9, 0x73, 0x69, 0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x47,
0x61, 0x62, 0x6f, 0x6e, 0x47, 0x75, 0x61, 0x64, 0x65, 0x6c, 0x6f, 0x75, 0x70, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65,
0x48, 0x61, 0xef, 0x74, 0x69, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x6f, 0x75, 0x72, 0x67, 0x4d, 0x61, 0x6c, 0x69, 0x4d,
0x61, 0x72, 0x74, 0x69, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x4d,
0x61, 0x75, 0x72, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x79, 0x6f, 0x74, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x4d,
0x61, 0x72, 0x6f, 0x63, 0x4e, 0x6f, 0x75, 0x76, 0x65, 0x6c, 0x6c, 0x65, 0x2d, 0x43, 0x61, 0x6c, 0xe9, 0x64, 0x6f, 0x6e,
0x69, 0x65, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x4c, 0x61, 0x20, 0x52, 0xe9, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0xe9, 0x6e,
0xe9, 0x67, 0x61, 0x6c, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x2d, 0x65, 0x74, 0x2d,
0x4d, 0x69, 0x71, 0x75, 0x65, 0x6c, 0x6f, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x73, 0x75, 0x69,
0x73, 0x73, 0x65, 0x53, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x79, 0x72, 0x69, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x54, 0x75,
0x6e, 0x69, 0x73, 0x69, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x69, 0x73, 0x2d, 0x65, 0x74, 0x2d, 0x46, 0x75, 0x74, 0x75, 0x6e,
0x61, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x42, 0x61, 0x72, 0x74, 0x68, 0xe9, 0x6c, 0x65, 0x6d, 0x79, 0x53, 0x61, 0x69,
0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x46, 0x72, 0x79, 0x73, 0x6b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c,
0xe2, 0x6e, 0x47, 0xe0, 0x69, 0x64, 0x68, 0x6c, 0x69, 0x67, 0x41, 0x6e, 0x20, 0x52, 0xec, 0x6f, 0x67, 0x68, 0x61, 0x63,
0x68, 0x64, 0x20, 0x41, 0x6f, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x74, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x45, 0x73,
0x70, 0x61, 0xf1, 0x61, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x10e1, 0x10d0, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10d5, 0x10d4, 0x10da,
0x10dd, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0xd6,
0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x69, 0x73, 0x63, 0x68, 0x65, 0x73, 0x20, 0x44, 0x65, 0x75, 0x74,
0x73, 0x63, 0x68, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x65, 0x6e,
0x49, 0x74, 0x61, 0x6c, 0x69, 0x65, 0x6e, 0x4c, 0x69, 0x65, 0x63, 0x68, 0x74, 0x65, 0x6e, 0x73, 0x74, 0x65, 0x69, 0x6e,
0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x48,
0x6f, 0x63, 0x68, 0x64, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x395, 0x3bb, 0x3bb,
0x3b7, 0x3bd, 0x3b9, 0x3ba, 0x3ac, 0x395, 0x3bb, 0x3bb, 0x3ac, 0x3b4, 0x3b1, 0x39a, 0x3cd, 0x3c0, 0x3c1, 0x3bf, 0x3c2, 0x6b, 0x61, 0x6c,
0x61, 0x61, 0x6c, 0x6c, 0x69, 0x73, 0x75, 0x74, 0x4b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x74, 0x20, 0x4e, 0x75,
0x6e, 0x61, 0x61, 0x74, 0xa97, 0xac1, 0xa9c, 0xab0, 0xabe, 0xaa4, 0xac0, 0xaad, 0xabe, 0xab0, 0xaa4, 0x48, 0x61, 0x75, 0x73, 0x61,
0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x47, 0x61, 0x6e, 0x61, 0x4e, 0x69, 0x6a, 0x61, 0x72, 0x5e2, 0x5d1, 0x5e8,
0x5d9, 0x5ea, 0x5d9, 0x5e9, 0x5e8, 0x5d0, 0x5dc, 0x939, 0x93f, 0x928, 0x94d, 0x926, 0x940, 0x92d, 0x93e, 0x930, 0x924, 0x6d, 0x61, 0x67,
0x79, 0x61, 0x72, 0x4d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x6f, 0x72, 0x73, 0x7a, 0xe1, 0x67, 0xed, 0x73, 0x6c, 0x65, 0x6e,
0x73, 0x6b, 0x61, 0xcd, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x47, 0x61,
0x65, 0x69, 0x6c, 0x67, 0x65, 0xc9, 0x69, 0x72, 0x65, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x49, 0x74, 0x61,
0x6c, 0x69, 0x61, 0x53, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x6e, 0x6f, 0x53, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72,
0x61, 0x43, 0x69, 0x74, 0x74, 0xe0, 0x20, 0x64, 0x65, 0x6c, 0x20, 0x56, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x65e5,
0x672c, 0x8a9e, 0x65e5, 0x672c, 0xc95, 0xca8, 0xccd, 0xca8, 0xca1, 0xcad, 0xcbe, 0xcb0, 0xca4, 0x6a9, 0x672, 0x634, 0x64f, 0x631, 0x6c1, 0x650,
0x646, 0x65b, 0x62f, 0x648, 0x633, 0x62a, 0x627, 0x646, 0x49b, 0x430, 0x437, 0x430, 0x49b, 0x20, 0x442, 0x456, 0x43b, 0x456, 0x49a, 0x430,
0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x4b, 0x69, 0x6e, 0x79, 0x61, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x55, 0x20,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x43a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x447, 0x430, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437,
0x441, 0x442, 0x430, 0x43d, 0xd55c, 0xad6d, 0xc5b4, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0xc870, 0xc120, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0xc778, 0xbbfc, 0xacf5,
0xd654, 0xad6d, 0x49, 0x6b, 0x69, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0xea5, 0xeb2,
0xea7, 0x6c, 0x61, 0x74, 0x76, 0x69, 0x65, 0x161, 0x75, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x6c, 0x69, 0x6e, 0x67,
0xe1, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0xed, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67,
0xf3, 0x20, 0x44, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0xed, 0x6b, 0x69, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x52,
0x65, 0x70, 0x69, 0x62, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x41, 0x66, 0x72, 0xed, 0x6b, 0x61, 0x20, 0x79, 0x61,
0x20, 0x4b, 0xe1, 0x74, 0x69, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0x173, 0x4c, 0x69,
0x65, 0x74, 0x75, 0x76, 0x61, 0x43c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x41c, 0x430, 0x43a, 0x435, 0x434,
0x43e, 0x43d, 0x438, 0x458, 0x430, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73,
0x69, 0x6b, 0x61, 0x72, 0x61, 0x4d, 0x65, 0x6c, 0x61, 0x79, 0x75, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x53, 0x69, 0x6e,
0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0xd2e, 0xd32, 0xd2f, 0xd3e, 0xd33, 0xd02, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0x4d, 0x61,
0x6c, 0x74, 0x69, 0x92e, 0x930, 0x93e, 0x920, 0x940, 0x43c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b,
0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62, 0x6f, 0x6b,
0x6d, 0xe5, 0x6c, 0x4e, 0x6f, 0x72, 0x67, 0x65, 0x53, 0x76, 0x61, 0x6c, 0x62, 0x61, 0x72, 0x64, 0x20, 0x6f, 0x67, 0x20,
0x4a, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x79, 0x65, 0x6e, 0xb13, 0xb21, 0xb3c, 0xb3f, 0xb06, 0xb2d, 0xb3e, 0xb30, 0xb24, 0x67e, 0x69a,
0x62a, 0x648, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x641, 0x627, 0x631, 0x633, 0x6cc, 0x627, 0x6cc, 0x631, 0x627,
0x646, 0x62f, 0x631, 0x6cc, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x50, 0x6f, 0x6c, 0x73, 0x6b, 0x61, 0x70, 0x6f, 0x72, 0x74,
0x75, 0x67, 0x75, 0xea, 0x73, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x41, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x43, 0x61, 0x62,
0x6f, 0x20, 0x56, 0x65, 0x72, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x6f, 0x72, 0x2d, 0x4c, 0x65, 0x73, 0x74, 0x65, 0x47, 0x75,
0x69, 0x6e, 0xe9, 0x20, 0x45, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x2d,
0x42, 0x69, 0x73, 0x73, 0x61, 0x75, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x6f, 0x4d, 0x61, 0x63, 0x61,
0x75, 0x2c, 0x20, 0x52, 0x41, 0x45, 0x20, 0x64, 0x61, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x6f, 0xe7, 0x61, 0x6d,
0x62, 0x69, 0x71, 0x75, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x70,
0x65, 0x75, 0x50, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x61, 0x6c, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65,
0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x53, 0x75, 0xed, 0xe7, 0x61, 0xa2a, 0xa70, 0xa1c, 0xa3e, 0xa2c, 0xa40,
0xa2d, 0xa3e, 0xa30, 0xa24, 0x67e, 0x646, 0x62c, 0x627, 0x628, 0x6cc, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x52, 0x75, 0x6e,
0x61, 0x73, 0x69, 0x6d, 0x69, 0x50, 0x65, 0x72, 0xfa, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x45, 0x63, 0x75, 0x61,
0x64, 0x6f, 0x72, 0x72, 0x75, 0x6d, 0x61, 0x6e, 0x74, 0x73, 0x63, 0x68, 0x53, 0x76, 0x69, 0x7a, 0x72, 0x61, 0x72, 0x6f,
0x6d, 0xe2, 0x6e, 0x103, 0x52, 0x6f, 0x6d, 0xe2, 0x6e, 0x69, 0x61, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
0x20, 0x4d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x61, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x420, 0x43e, 0x441, 0x441, 0x438,
0x44f, 0x41a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x442, 0x430, 0x43d, 0x41a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x438, 0x44f, 0x41c, 0x43e,
0x43b, 0x434, 0x43e, 0x432, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x430, 0x53, 0xe4, 0x6e, 0x67, 0xf6, 0x4b, 0xf6, 0x64,
0xf6, 0x72, 0xf6, 0x73, 0xea, 0x73, 0x65, 0x20, 0x74, 0xee, 0x20, 0x42, 0xea, 0x61, 0x66, 0x72, 0xee, 0x6b, 0x61, 0x441,
0x440, 0x43f, 0x441, 0x43a, 0x438, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x43, 0x72, 0x6e,
0x61, 0x20, 0x47, 0x6f, 0x72, 0x61, 0x53, 0x72, 0x62, 0x69, 0x6a, 0x61, 0x411, 0x43e, 0x441, 0x43d, 0x430, 0x20, 0x438, 0x20,
0x425, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x438, 0x43d, 0x430, 0x426, 0x440, 0x43d, 0x430, 0x20, 0x413, 0x43e, 0x440, 0x430,
0x41a, 0x43e, 0x441, 0x43e, 0x432, 0x43e, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0x6f, 0x438, 0x440, 0x43e, 0x43d, 0x413, 0x443, 0x44b, 0x440,
0x434, 0x437, 0x44b, 0x441, 0x442, 0x43e, 0x43d, 0x423, 0x4d5, 0x440, 0x4d5, 0x441, 0x435, 0x63, 0x68, 0x69, 0x53, 0x68, 0x6f, 0x6e,
0x61, 0x633, 0x646, 0x68c, 0x64a, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0xdc3, 0xdd2, 0xd82, 0xdc4, 0xdbd, 0xdc1, 0xdca, 0x200d,
0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0xdc0, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c,
0x6f, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x6f, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x161, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c,
0x6f, 0x76, 0x65, 0x6e, 0x69, 0x6a, 0x61, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x53, 0x6f, 0x6f, 0x6d, 0x61,
0x61, 0x6c, 0x69, 0x79, 0x61, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x69, 0x79, 0x61,
0x4b, 0x69, 0x69, 0x6e, 0x69, 0x79, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x45, 0x73,
0x70, 0x61, 0xf1, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x41, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x61,
0x42, 0x65, 0x6c, 0x69, 0x63, 0x65, 0x43, 0x68, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x43,
0x6f, 0x73, 0x74, 0x61, 0x20, 0x52, 0x69, 0x63, 0x61, 0x43, 0x75, 0x62, 0x61, 0x52, 0x65, 0x70, 0xfa, 0x62, 0x6c, 0x69,
0x63, 0x61, 0x20, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x61, 0x45, 0x6c, 0x20, 0x53, 0x61, 0x6c, 0x76,
0x61, 0x64, 0x6f, 0x72, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x20, 0x45, 0x63, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61,
0x6c, 0x47, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x48, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x61, 0x73, 0x65, 0x73,
0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0xe9, 0x78, 0x69, 0x63, 0x6f, 0x4d, 0xe9, 0x78, 0x69, 0x63,
0x6f, 0x4e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x50, 0x61, 0x6e, 0x61, 0x6d, 0xe1, 0x50, 0x61, 0x72, 0x61,
0x67, 0x75, 0x61, 0x79, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73,
0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x55, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x56, 0x65, 0x6e, 0x65, 0x7a, 0x75,
0x65, 0x6c, 0x61, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x69, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x6c,
0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x4c, 0x61, 0x74, 0x69, 0x6e, 0x6f,
0x61, 0x6d, 0xe9, 0x72, 0x69, 0x63, 0x61, 0x43, 0x65, 0x75, 0x74, 0x61, 0x20, 0x79, 0x20, 0x4d, 0x65, 0x6c, 0x69, 0x6c,
0x6c, 0x61, 0x4b, 0x69, 0x73, 0x77, 0x61, 0x68, 0x69, 0x6c, 0x69, 0x4b, 0x69, 0x6e, 0x67, 0x77, 0x61, 0x6e, 0x61, 0x4a,
0x61, 0x6d, 0x68, 0x75, 0x72, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x69, 0x64, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x73,
0x69, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x53, 0x76,
0x65, 0x72, 0x69, 0x67, 0x65, 0xc5, 0x6c, 0x61, 0x6e, 0x64, 0x442, 0x43e, 0x4b7, 0x438, 0x43a, 0x4e3, 0x422, 0x43e, 0x4b7, 0x438,
0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0xba4, 0xbae, 0xbbf, 0xbb4, 0xbcd, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0xbbe, 0xbae, 0xbb2,
0xbc7, 0xb9a, 0xbbf, 0xbaf, 0xbbe, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0xb87, 0xbb2, 0xb99, 0xbcd,
0xb95, 0xbc8, 0x442, 0x430, 0x442, 0x430, 0x440, 0xc24, 0xc46, 0xc32, 0xc41, 0xc17, 0xc41, 0xc2d, 0xc3e, 0xc30, 0xc24, 0xc26, 0xc47, 0xc36,
0xc02, 0xe44, 0xe17, 0xe22, 0xf56, 0xf7c, 0xf51, 0xf0b, 0xf66, 0xf90, 0xf51, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf53, 0xf42, 0xf62, 0xf92,
0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0x1275, 0x130d, 0x122d, 0x129b, 0x12a4, 0x122d, 0x1275, 0x122b, 0x6c, 0x65, 0x61, 0x20, 0x66, 0x61, 0x6b,
0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61, 0x54, 0xfc, 0x72, 0x6b, 0xe7, 0x65, 0x54, 0xfc, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x4b,
0x131, 0x62, 0x72, 0x131, 0x73, 0x74, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x64, 0x69, 0x6c, 0x69, 0x54, 0xfc, 0x72,
0x6b, 0x6d, 0x65, 0x6e, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x626, 0x6c7, 0x64a, 0x63a, 0x6c7, 0x631, 0x686, 0x6d5, 0x62c, 0x6c7, 0x6ad,
0x6af, 0x648, 0x443, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x430, 0x627,
0x631, 0x62f, 0x648, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b,
0x69, 0x73, 0x74, 0x6f, 0x6e, 0x627, 0x648, 0x632, 0x628, 0x6cc, 0x6a9, 0x45e, 0x437, 0x431, 0x435, 0x43a, 0x447, 0x430, 0x40e, 0x437,
0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x54, 0x69, 0x1ebf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x56, 0x69,
0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x56, 0x6f, 0x6c, 0x61, 0x70, 0xfc, 0x6b, 0x43, 0x79, 0x6d, 0x72, 0x61, 0x65, 0x67,
0x59, 0x20, 0x44, 0x65, 0x79, 0x72, 0x6e, 0x61, 0x73, 0x20, 0x55, 0x6e, 0x65, 0x64, 0x69, 0x67, 0x57, 0x6f, 0x6c, 0x6f,
0x66, 0x53, 0x65, 0x6e, 0x65, 0x67, 0x61, 0x61, 0x6c, 0x5d9, 0x5d9, 0x5b4, 0x5d3, 0x5d9, 0x5e9, 0x5d5, 0x5d5, 0x5e2, 0x5dc, 0x5d8,
0xc8, 0x64, 0xe8, 0x20, 0x59, 0x6f, 0x72, 0xf9, 0x62, 0xe1, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x301, 0xe8, 0x64, 0x65, 0x20,
0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x4f, 0x72, 0xed, 0x6c, 0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x42, 0x25b,
0x300, 0x6e, 0x25b, 0x300, 0x69, 0x73, 0x69, 0x5a, 0x75, 0x6c, 0x75, 0x69, 0x4e, 0x69, 0x6e, 0x67, 0x69, 0x7a, 0x69, 0x6d,
0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x6e, 0x79, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x4e, 0x6f, 0x72, 0x65, 0x67,
0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x438, 0x47, 0x61, 0x65, 0x6c,
0x67, 0x45, 0x6c, 0x6c, 0x61, 0x6e, 0x20, 0x56, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x77, 0x65,
0x6b, 0x52, 0x79, 0x77, 0x76, 0x61, 0x6e, 0x65, 0x74, 0x68, 0x20, 0x55, 0x6e, 0x79, 0x73, 0x41, 0x6b, 0x61, 0x6e, 0x47,
0x61, 0x61, 0x6e, 0x61, 0x915, 0x94b, 0x902, 0x915, 0x923, 0x940, 0x49, 0x67, 0x62, 0x6f, 0x4e, 0x61, 0x1ecb, 0x6a, 0x1ecb, 0x72,
0x1ecb, 0x61, 0x4b, 0x69, 0x6b, 0x61, 0x6d, 0x62, 0x61, 0x66, 0x75, 0x72, 0x6c, 0x61, 0x6e, 0x49, 0x74, 0x61, 0x6c, 0x69,
0x65, 0x45, 0x28b, 0x65, 0x67, 0x62, 0x65, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x54,
0x6f, 0x67, 0x6f, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x2bb, 0x14c, 0x6c, 0x65, 0x6c, 0x6f, 0x20, 0x48, 0x61, 0x77,
0x61, 0x69, 0x2bb, 0x69, 0x2bb, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x20, 0x48, 0x75, 0x69, 0x20, 0x50, 0x16b, 0x20,
0x2bb, 0x49, 0x61, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73,
0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x74, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x53, 0x63, 0x68, 0x77,
0x69, 0x69, 0x7a, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x72, 0x69, 0x69, 0x63, 0x68, 0x4c, 0x69, 0xe4, 0x63, 0x68, 0x74, 0x65,
0x73, 0x63, 0x68, 0x74, 0xe4, 0x69, 0xa188, 0xa320, 0xa259, 0xa34f, 0xa1e9, 0x4e, 0x65, 0x64, 0x64, 0x65, 0x72, 0x73, 0x61, 0x73,
0x73, 0x2019, 0x73, 0x63, 0x68, 0x44, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x65, 0x64, 0x64,
0x65, 0x72, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x6e, 0x64, 0x61, 0x76, 0x76, 0x69, 0x73, 0xe1, 0x6d, 0x65, 0x67, 0x69, 0x65,
0x6c, 0x6c, 0x61, 0x4e, 0x6f, 0x72, 0x67, 0x61, 0x53, 0x75, 0x6f, 0x70, 0x6d, 0x61, 0x52, 0x75, 0x6f, 0x167, 0x167, 0x61,
0x45, 0x6b, 0x65, 0x67, 0x75, 0x73, 0x69, 0x69, 0x4b, 0x69, 0x74, 0x61, 0x69, 0x74, 0x61, 0x50, 0x75, 0x6c, 0x61, 0x61,
0x72, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x75, 0x6e, 0x47, 0x69, 0x6e, 0x65, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e,
0x69, 0x47, 0x69, 0x6b, 0x75, 0x79, 0x75, 0x4b, 0x69, 0x73, 0x61, 0x6d, 0x70, 0x75, 0x72, 0x73, 0x65, 0x6e, 0x61, 0x69,
0x73, 0x69, 0x4e, 0x64, 0x65, 0x62, 0x65, 0x6c, 0x65, 0x4b, 0x69, 0x68, 0x6f, 0x72, 0x6f, 0x6d, 0x62, 0x6f, 0x2d5c, 0x2d30,
0x2d5b, 0x2d4d, 0x2d43, 0x2d49, 0x2d5c, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x54, 0x61, 0x73, 0x68, 0x65, 0x6c, 0x1e25, 0x69, 0x79,
0x74, 0x6c, 0x6d, 0x263, 0x72, 0x69, 0x62, 0x54, 0x61, 0x71, 0x62, 0x61, 0x79, 0x6c, 0x69, 0x74, 0x4c, 0x65, 0x7a, 0x7a,
0x61, 0x79, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x6f, 0x72, 0x65, 0x48, 0x69, 0x62, 0x65, 0x6e, 0x61,
0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x79, 0x69, 0x76, 0x75, 0x6e, 0x6a, 0x6f, 0x62, 0x61,
0x6d, 0x61, 0x6e, 0x61, 0x6b, 0x61, 0x6e, 0x4b, 0x129, 0x65, 0x6d, 0x62, 0x75, 0x13e3, 0x13b3, 0x13a9, 0x13cc, 0x13ca, 0x20, 0x13a2,
0x13f3, 0x13be, 0x13b5, 0x13cd, 0x13d4, 0x13c5, 0x20, 0x13cd, 0x13a6, 0x13da, 0x13a9, 0x6b, 0x72, 0x65, 0x6f, 0x6c, 0x20, 0x6d, 0x6f, 0x72,
0x69, 0x73, 0x69, 0x65, 0x6e, 0x4d, 0x6f, 0x72, 0x69, 0x73, 0x43, 0x68, 0x69, 0x6d, 0x61, 0x6b, 0x6f, 0x6e, 0x64, 0x65,
0x4b, 0x268, 0x6c, 0x61, 0x61, 0x6e, 0x67, 0x69, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x4c, 0x75, 0x67,
0x61, 0x6e, 0x64, 0x61, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x49, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6d, 0x62, 0x61,
0x6b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x4b, 0x61, 0x62, 0x75, 0x20, 0x56, 0x65, 0x72,
0x64, 0x69, 0x4b, 0x129, 0x6d, 0x129, 0x72, 0x169, 0x4b, 0x61, 0x6c, 0x65, 0x6e, 0x6a, 0x69, 0x6e, 0x45, 0x6d, 0x65, 0x74,
0x61, 0x62, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x4b, 0x68, 0x6f, 0x65, 0x6b, 0x68, 0x6f, 0x65, 0x67, 0x6f, 0x77, 0x61,
0x62, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x62, 0x4b, 0x69, 0x6d, 0x61, 0x63, 0x68, 0x61, 0x6d, 0x65, 0x4b, 0xf6,
0x6c, 0x73, 0x63, 0x68, 0x44, 0x6f, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x4d, 0x61, 0x61, 0x54, 0x61,
0x6e, 0x73, 0x61, 0x6e, 0x69, 0x61, 0x4f, 0x6c, 0x75, 0x73, 0x6f, 0x67, 0x61, 0x4c, 0x75, 0x6c, 0x75, 0x68, 0x69, 0x61,
0x4b, 0x69, 0x70, 0x61, 0x72, 0x65, 0x54, 0x61, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x69, 0x74, 0x65, 0x73, 0x6f,
0x4b, 0x65, 0x6e, 0x69, 0x61, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x20, 0x63, 0x69, 0x69, 0x6e, 0x69, 0x4d, 0x61, 0x61, 0x6c,
0x69, 0x4b, 0x69, 0x72, 0x75, 0x77, 0x61, 0x44, 0x68, 0x6f, 0x6c, 0x75, 0x6f, 0x52, 0x75, 0x6b, 0x69, 0x67, 0x61, 0x54,
0x61, 0x6d, 0x61, 0x7a, 0x69, 0x263, 0x74, 0x20, 0x6e, 0x20, 0x6c, 0x61, 0x1e6d, 0x6c, 0x61, 0x1e63, 0x4d, 0x65, 0x1e5b, 0x1e5b,
0x75, 0x6b, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x62, 0x6f, 0x72, 0x6f, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0x4b, 0x69, 0x73,
0x68, 0x61, 0x6d, 0x62, 0x61, 0x61, 0x92c, 0x921, 0x93c, 0x94b, 0x43d, 0x43e, 0x445, 0x447, 0x438, 0x439, 0x43d, 0x420, 0x43e, 0x441,
0x441, 0x438, 0x446, 0x435, 0x440, 0x43a, 0x43e, 0x432, 0x43d, 0x43e, 0x441, 0x43b, 0x43e, 0x432, 0x435, 0x301, 0x43d, 0x441, 0x43a, 0x457,
0x439, 0x440, 0x461, 0x441, 0x441, 0x456, 0x301, 0x430, 0x54, 0x73, 0x68, 0x69, 0x6c, 0x75, 0x62, 0x61, 0x44, 0x69, 0x74, 0x75,
0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65,
0x72, 0x67, 0x65, 0x73, 0x63, 0x68, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x41, 0x67, 0x68, 0x65,
0x6d, 0x4b, 0xe0, 0x6d, 0xe0, 0x6c, 0xfb, 0x14b, 0x181, 0xe0, 0x73, 0xe0, 0x61, 0x4b, 0xe0, 0x6d, 0x25b, 0x300, 0x72, 0xfb,
0x6e, 0x5a, 0x61, 0x72, 0x6d, 0x61, 0x63, 0x69, 0x69, 0x6e, 0x65, 0x4e, 0x69, 0x17e, 0x65, 0x72, 0x64, 0x75, 0xe1, 0x6c,
0xe1, 0x6a, 0x6f, 0x6f, 0x6c, 0x61, 0x53, 0x65, 0x6e, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x77, 0x6f, 0x6e, 0x64, 0x6f, 0x4b,
0x61, 0x6d, 0x259, 0x72, 0xfa, 0x6e, 0x72, 0x69, 0x6b, 0x70, 0x61, 0x6b, 0x61, 0x6d, 0x25b, 0x72, 0xfa, 0x6e, 0x4d, 0x61,
0x6b, 0x75, 0x61, 0x55, 0x6d, 0x6f, 0x7a, 0x61, 0x6d, 0x62, 0x69, 0x6b, 0x69, 0x4d, 0x55, 0x4e, 0x44, 0x41, 0x14a, 0x6b,
0x61, 0x6d, 0x65, 0x72, 0x75, 0x14b, 0x4b, 0x77, 0x61, 0x73, 0x69, 0x6f, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x6e, 0x54,
0x68, 0x6f, 0x6b, 0x20, 0x4e, 0x61, 0x74, 0x68, 0x441, 0x430, 0x445, 0x430, 0x20, 0x442, 0x44b, 0x43b, 0x430, 0x410, 0x440, 0x430,
0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430, 0x49, 0x73, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x67, 0x75, 0x54, 0x61, 0x6e, 0x73, 0x61,
0x6e, 0x69, 0x79, 0x61, 0x54, 0x61, 0x73, 0x61, 0x77, 0x61, 0x71, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0xa559, 0xa524, 0xa55e,
0xa524, 0xa52b, 0xa569, 0x56, 0x61, 0x69, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x57, 0x61, 0x6c, 0x73, 0x65, 0x72,
0x53, 0x63, 0x68, 0x77, 0x69, 0x7a, 0x6e, 0x75, 0x61, 0x73, 0x75, 0x65, 0x4b, 0x65, 0x6d, 0x65, 0x6c, 0xfa, 0x6e, 0x61,
0x73, 0x74, 0x75, 0x72, 0x69, 0x61, 0x6e, 0x75, 0x4e, 0x64, 0x61, 0xa78c, 0x61, 0x4b, 0x61, 0x6d, 0x25b, 0x6c, 0xfb, 0x6e,
0x6b, 0x61, 0x6b, 0x254, 0x4b, 0x61, 0x6d, 0x25b, 0x72, 0x75, 0x6e, 0x6d, 0x65, 0x74, 0x61, 0x2bc, 0x4b, 0x61, 0x6d, 0x61,
0x6c, 0x75, 0x6e, 0x53, 0x68, 0x77, 0xf3, 0x14b, 0xf2, 0x20, 0x6e, 0x67, 0x69, 0x65, 0x6d, 0x62, 0x254, 0x254, 0x6e, 0x4b,
0xe0, 0x6d, 0x61, 0x6c, 0xfb, 0x6d, 0x4c, 0x61, 0x6b, 0x21f, 0xf3, 0x6c, 0x2bc, 0x69, 0x79, 0x61, 0x70, 0x69, 0x4d, 0xed,
0x6c, 0x61, 0x68, 0x61, 0x14b, 0x73, 0x6b, 0x61, 0x20, 0x54, 0x21f, 0x61, 0x6d, 0xe1, 0x6b, 0x21f, 0x6f, 0x10d, 0x68, 0x65,
0x2d5c, 0x2d30, 0x2d4e, 0x2d30, 0x2d63, 0x2d49, 0x2d56, 0x2d5c, 0x6a9, 0x648, 0x631, 0x62f, 0x6cc, 0x6cc, 0x20, 0x646, 0x627, 0x648, 0x6d5, 0x646,
0x62f, 0x6cc, 0x639, 0x6ce, 0x631, 0x627, 0x642, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x64, 0x6f, 0x6c, 0x6e, 0x6f, 0x73, 0x65, 0x72,
0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x69, 0x6d, 0x73, 0x6b, 0x61, 0x68, 0x6f, 0x72, 0x6e, 0x6a, 0x6f, 0x73, 0x65,
0x72, 0x62, 0x161, 0x107, 0x69, 0x6e, 0x61, 0x4e, 0x11b, 0x6d, 0x73, 0x6b, 0x61, 0x70, 0x72, 0x16b, 0x73, 0x69, 0x73, 0x6b,
0x61, 0x6e, 0x73, 0x77, 0x12b, 0x74, 0x61, 0x69, 0x61, 0x6e, 0x61, 0x72, 0xe2, 0x161, 0x6b, 0x69, 0x65, 0x6c, 0xe2, 0x53,
0x75, 0x6f, 0x6d, 0xe2, 0x645, 0x627, 0x632, 0x631, 0x648, 0x646, 0x6cc, 0x644, 0x6ca, 0x631, 0x6cc, 0x20, 0x634, 0x648, 0x645, 0x627,
0x644, 0x6cc, 0x7cb5, 0x8a9e, 0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x7ca4, 0x8bed,
0x4e2d, 0x534e, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x56fd
};

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Oromo\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Dzongkha\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Belarusian\0"
"Khmer\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fijian\0"
"Finnish\0"
"French\0"
"Western Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Rundi\0"
"Lao\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Marshallese\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"Norwegian Bokmal\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"Romansh\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sango\0"
"Sanskrit\0"
"Serbian\0"
"Ossetic\0"
"Southern Sotho\0"
"Tswana\0"
"Shona\0"
"Sindhi\0"
"Sinhala\0"
"Swati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Sardinian\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tongan\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Tahitian\0"
"Uighur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"Norwegian Nynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Nyanja\0"
"Filipino\0"
"Swiss German\0"
"Sichuan Yi\0"
"Kpelle\0"
"Low German\0"
"South Ndebele\0"
"Northern Sotho\0"
"Northern Sami\0"
"Taroko\0"
"Gusii\0"
"Taita\0"
"Fulah\0"
"Kikuyu\0"
"Samburu\0"
"Sena\0"
"North Ndebele\0"
"Rombo\0"
"Tachelhit\0"
"Kabyle\0"
"Nyankole\0"
"Bena\0"
"Vunjo\0"
"Bambara\0"
"Embu\0"
"Cherokee\0"
"Morisyen\0"
"Makonde\0"
"Langi\0"
"Ganda\0"
"Bemba\0"
"Kabuverdianu\0"
"Meru\0"
"Kalenjin\0"
"Nama\0"
"Machame\0"
"Colognian\0"
"Masai\0"
"Soga\0"
"Luyia\0"
"Asu\0"
"Teso\0"
"Saho\0"
"Koyra Chiini\0"
"Rwa\0"
"Luo\0"
"Chiga\0"
"Central Morocco Tamazight\0"
"Koyraboro Senni\0"
"Shambala\0"
"Bodo\0"
"Avaric\0"
"Chamorro\0"
"Chechen\0"
"Church\0"
"Chuvash\0"
"Cree\0"
"Haitian\0"
"Herero\0"
"Hiri Motu\0"
"Kanuri\0"
"Komi\0"
"Kongo\0"
"Kwanyama\0"
"Limburgish\0"
"Luba Katanga\0"
"Luxembourgish\0"
"Navaho\0"
"Ndonga\0"
"Ojibwa\0"
"Pali\0"
"Walloon\0"
"Aghem\0"
"Basaa\0"
"Zarma\0"
"Duala\0"
"Jola Fonyi\0"
"Ewondo\0"
"Bafia\0"
"Makhuwa Meetto\0"
"Mundang\0"
"Kwasio\0"
"Nuer\0"
"Sakha\0"
"Sangu\0"
"Congo Swahili\0"
"Tasawaq\0"
"Vai\0"
"Walser\0"
"Yangben\0"
"Avestan\0"
"Asturian\0"
"Ngomba\0"
"Kako\0"
"Meta\0"
"Ngiemboon\0"
"Aragonese\0"
"Akkadian\0"
"Ancient Egyptian\0"
"Ancient Greek\0"
"Aramaic\0"
"Balinese\0"
"Bamun\0"
"Batak Toba\0"
"Buginese\0"
"Buhid\0"
"Carian\0"
"Chakma\0"
"Classical Mandaic\0"
"Coptic\0"
"Dogri\0"
"Eastern Cham\0"
"Eastern Kayah\0"
"Etruscan\0"
"Gothic\0"
"Hanunoo\0"
"Ingush\0"
"Large Flowery Miao\0"
"Lepcha\0"
"Limbu\0"
"Lisu\0"
"Lu\0"
"Lycian\0"
"Lydian\0"
"Mandingo\0"
"Manipuri\0"
"Meroitic\0"
"Northern Thai\0"
"Old Irish\0"
"Old Norse\0"
"Old Persian\0"
"Old Turkish\0"
"Pahlavi\0"
"Parthian\0"
"Phoenician\0"
"Prakrit Language\0"
"Rejang\0"
"Sabaean\0"
"Samaritan\0"
"Santali\0"
"Saurashtra\0"
"Sora\0"
"Sylheti\0"
"Tagbanwa\0"
"Tai Dam\0"
"Tai Nua\0"
"Ugaritic\0"
"Akoose\0"
"Lakota\0"
"Standard Moroccan Tamazight\0"
"Mapuche\0"
"Central Kurdish\0"
"Lower Sorbian\0"
"Upper Sorbian\0"
"Kenyang\0"
"Mohawk\0"
"Nko\0"
"Prussian\0"
"Kiche\0"
"Southern Sami\0"
"Lule Sami\0"
"Inari Sami\0"
"Skolt Sami\0"
"Warlpiri\0"
"Manichaean Middle Persian\0"
"Mende\0"
"Ancient North Arabian\0"
"Linear A\0"
"Hmong Njua\0"
"Ho\0"
"Lezghian\0"
"Bassa\0"
"Mono\0"
"Tedim Chin\0"
"Maithili\0"
"Ahom\0"
"American Sign Language\0"
"Ardhamagadhi Prakrit\0"
"Bhojpuri\0"
"Hieroglyphic Luwian\0"
"Literary Chinese\0"
"Mazanderani\0"
"Mru\0"
"Newari\0"
"Northern Luri\0"
"Palauan\0"
"Papiamento\0"
"Saraiki\0"
"Tokelau\0"
"Tok Pisin\0"
"Tuvalu\0"
"Uncoded Languages\0"
"Cantonese\0"
"Osage\0"
"Tangut\0"
;

static const quint16 language_name_index[] = {
     0, // AnyLanguage
     8, // C
    10, // Abkhazian
    20, // Oromo
    26, // Afar
    31, // Afrikaans
    41, // Albanian
    50, // Amharic
    58, // Arabic
    65, // Armenian
    74, // Assamese
    83, // Aymara
    90, // Azerbaijani
   102, // Bashkir
   110, // Basque
   117, // Bengali
   125, // Dzongkha
   134, // Bihari
   141, // Bislama
   149, // Breton
   156, // Bulgarian
   166, // Burmese
   174, // Belarusian
   185, // Khmer
   191, // Catalan
   199, // Chinese
   207, // Corsican
   216, // Croatian
   225, // Czech
   231, // Danish
   238, // Dutch
   244, // English
   252, // Esperanto
   262, // Estonian
   271, // Faroese
   279, // Fijian
   286, // Finnish
   294, // French
   301, // Western Frisian
   317, // Gaelic
   324, // Galician
   333, // Georgian
   342, // German
   349, // Greek
   355, // Greenlandic
   367, // Guarani
   375, // Gujarati
   384, // Hausa
   390, // Hebrew
   397, // Hindi
   403, // Hungarian
   413, // Icelandic
   423, // Indonesian
   434, // Interlingua
   446, // Interlingue
   458, // Inuktitut
   468, // Inupiak
   476, // Irish
   482, // Italian
   490, // Japanese
   499, // Javanese
   508, // Kannada
   516, // Kashmiri
   525, // Kazakh
   532, // Kinyarwanda
   544, // Kirghiz
   552, // Korean
   559, // Kurdish
   567, // Rundi
   573, // Lao
   577, // Latin
   583, // Latvian
   591, // Lingala
   599, // Lithuanian
   610, // Macedonian
   621, // Malagasy
   630, // Malay
   636, // Malayalam
   646, // Maltese
   654, // Maori
   660, // Marathi
   668, // Marshallese
   680, // Mongolian
   690, // Nauru
   696, // Nepali
   703, // Norwegian Bokmal
   720, // Occitan
   728, // Oriya
   734, // Pashto
   741, // Persian
   749, // Polish
   756, // Portuguese
   767, // Punjabi
   775, // Quechua
   783, // Romansh
   791, // Romanian
   800, // Russian
   808, // Samoan
   815, // Sango
   821, // Sanskrit
   830, // Serbian
   838, // Ossetic
   846, // Southern Sotho
   861, // Tswana
   868, // Shona
   874, // Sindhi
   881, // Sinhala
   889, // Swati
   895, // Slovak
   902, // Slovenian
   912, // Somali
   919, // Spanish
   927, // Sundanese
   937, // Swahili
   945, // Swedish
   953, // Sardinian
   963, // Tajik
   969, // Tamil
   975, // Tatar
   981, // Telugu
   988, // Thai
   993, // Tibetan
  1001, // Tigrinya
  1010, // Tongan
  1017, // Tsonga
  1024, // Turkish
  1032, // Turkmen
  1040, // Tahitian
  1049, // Uighur
  1056, // Ukrainian
  1066, // Urdu
  1071, // Uzbek
  1077, // Vietnamese
  1088, // Volapuk
  1096, // Welsh
  1102, // Wolof
  1108, // Xhosa
  1114, // Yiddish
  1122, // Yoruba
  1129, // Zhuang
  1136, // Zulu
  1141, // Norwegian Nynorsk
  1159, // Bosnian
  1167, // Divehi
  1174, // Manx
  1179, // Cornish
  1187, // Akan
  1192, // Konkani
  1200, // Ga
  1203, // Igbo
  1208, // Kamba
  1214, // Syriac
  1221, // Blin
  1226, // Geez
  1231, // Koro
  1236, // Sidamo
  1243, // Atsam
  1249, // Tigre
  1255, // Jju
  1259, // Friulian
  1268, // Venda
  1274, // Ewe
  1278, // Walamo
  1285, // Hawaiian
  1294, // Tyap
  1299, // Nyanja
  1306, // Filipino
  1315, // Swiss German
  1328, // Sichuan Yi
  1339, // Kpelle
  1346, // Low German
  1357, // South Ndebele
  1371, // Northern Sotho
  1386, // Northern Sami
  1400, // Taroko
  1407, // Gusii
  1413, // Taita
  1419, // Fulah
  1425, // Kikuyu
  1432, // Samburu
  1440, // Sena
  1445, // North Ndebele
  1459, // Rombo
  1465, // Tachelhit
  1475, // Kabyle
  1482, // Nyankole
  1491, // Bena
  1496, // Vunjo
  1502, // Bambara
  1510, // Embu
  1515, // Cherokee
  1524, // Morisyen
  1533, // Makonde
  1541, // Langi
  1547, // Ganda
  1553, // Bemba
  1559, // Kabuverdianu
  1572, // Meru
  1577, // Kalenjin
  1586, // Nama
  1591, // Machame
  1599, // Colognian
  1609, // Masai
  1615, // Soga
  1620, // Luyia
  1626, // Asu
  1630, // Teso
  1635, // Saho
  1640, // Koyra Chiini
  1653, // Rwa
  1657, // Luo
  1661, // Chiga
  1667, // Central Morocco Tamazight
  1693, // Koyraboro Senni
  1709, // Shambala
  1718, // Bodo
  1723, // Avaric
  1730, // Chamorro
  1739, // Chechen
  1747, // Church
  1754, // Chuvash
  1762, // Cree
  1767, // Haitian
  1775, // Herero
  1782, // Hiri Motu
  1792, // Kanuri
  1799, // Komi
  1804, // Kongo
  1810, // Kwanyama
  1819, // Limburgish
  1830, // Luba Katanga
  1843, // Luxembourgish
  1857, // Navaho
  1864, // Ndonga
  1871, // Ojibwa
  1878, // Pali
  1883, // Walloon
  1891, // Aghem
  1897, // Basaa
  1903, // Zarma
  1909, // Duala
  1915, // Jola Fonyi
  1926, // Ewondo
  1933, // Bafia
  1939, // Makhuwa Meetto
  1954, // Mundang
  1962, // Kwasio
  1969, // Nuer
  1974, // Sakha
  1980, // Sangu
  1986, // Congo Swahili
  2000, // Tasawaq
  2008, // Vai
  2012, // Walser
  2019, // Yangben
  2027, // Avestan
  2035, // Asturian
  2044, // Ngomba
  2051, // Kako
  2056, // Meta
  2061, // Ngiemboon
  2071, // Aragonese
  2081, // Akkadian
  2090, // Ancient Egyptian
  2107, // Ancient Greek
  2121, // Aramaic
  2129, // Balinese
  2138, // Bamun
  2144, // Batak Toba
  2155, // Buginese
  2164, // Buhid
  2170, // Carian
  2177, // Chakma
  2184, // Classical Mandaic
  2202, // Coptic
  2209, // Dogri
  2215, // Eastern Cham
  2228, // Eastern Kayah
  2242, // Etruscan
  2251, // Gothic
  2258, // Hanunoo
  2266, // Ingush
  2273, // Large Flowery Miao
  2292, // Lepcha
  2299, // Limbu
  2305, // Lisu
  2310, // Lu
  2313, // Lycian
  2320, // Lydian
  2327, // Mandingo
  2336, // Manipuri
  2345, // Meroitic
  2354, // Northern Thai
  2368, // Old Irish
  2378, // Old Norse
  2388, // Old Persian
  2400, // Old Turkish
  2412, // Pahlavi
  2420, // Parthian
  2429, // Phoenician
  2440, // Prakrit Language
  2457, // Rejang
  2464, // Sabaean
  2472, // Samaritan
  2482, // Santali
  2490, // Saurashtra
  2501, // Sora
  2506, // Sylheti
  2514, // Tagbanwa
  2523, // Tai Dam
  2531, // Tai Nua
  2539, // Ugaritic
  2548, // Akoose
  2555, // Lakota
  2562, // Standard Moroccan Tamazight
  2590, // Mapuche
  2598, // Central Kurdish
  2614, // Lower Sorbian
  2628, // Upper Sorbian
  2642, // Kenyang
  2650, // Mohawk
  2657, // Nko
  2661, // Prussian
  2670, // Kiche
  2676, // Southern Sami
  2690, // Lule Sami
  2700, // Inari Sami
  2711, // Skolt Sami
  2722, // Warlpiri
  2731, // Manichaean Middle Persian
  2757, // Mende
  2763, // Ancient North Arabian
  2785, // Linear A
  2794, // Hmong Njua
  2805, // Ho
  2808, // Lezghian
  2817, // Bassa
  2823, // Mono
  2828, // Tedim Chin
  2839, // Maithili
  2848, // Ahom
  2853, // American Sign Language
  2876, // Ardhamagadhi Prakrit
  2897, // Bhojpuri
  2906, // Hieroglyphic Luwian
  2926, // Literary Chinese
  2943, // Mazanderani
  2955, // Mru
  2959, // Newari
  2966, // Northern Luri
  2980, // Palauan
  2988, // Papiamento
  2999, // Saraiki
  3007, // Tokelau
  3015, // Tok Pisin
  3025, // Tuvalu
  3032, // Uncoded Languages
  3050, // Cantonese
  3060, // Osage
  3066, // Tangut
};

static const char script_name_list[] =
"Default\0"
"Arabic\0"
"Cyrillic\0"
"Deseret\0"
"Gurmukhi\0"
"Simplified Han\0"
"Traditional Han\0"
"Latin\0"
"Mongolian\0"
"Tifinagh\0"
"Armenian\0"
"Bengali\0"
"Cherokee\0"
"Devanagari\0"
"Ethiopic\0"
"Georgian\0"
"Greek\0"
"Gujarati\0"
"Hebrew\0"
"Japanese\0"
"Khmer\0"
"Kannada\0"
"Korean\0"
"Lao\0"
"Malayalam\0"
"Myanmar\0"
"Oriya\0"
"Tamil\0"
"Telugu\0"
"Thaana\0"
"Thai\0"
"Tibetan\0"
"Sinhala\0"
"Syriac\0"
"Yi\0"
"Vai\0"
"Avestan\0"
"Balinese\0"
"Bamum\0"
"Batak\0"
"Bopomofo\0"
"Brahmi\0"
"Buginese\0"
"Buhid\0"
"Canadian Aboriginal\0"
"Carian\0"
"Chakma\0"
"Cham\0"
"Coptic\0"
"Cypriot\0"
"Egyptian Hieroglyphs\0"
"Fraser\0"
"Glagolitic\0"
"Gothic\0"
"Han\0"
"Hangul\0"
"Hanunoo\0"
"Imperial Aramaic\0"
"Inscriptional Pahlavi\0"
"Inscriptional Parthian\0"
"Javanese\0"
"Kaithi\0"
"Katakana\0"
"Kayah Li\0"
"Kharoshthi\0"
"Lanna\0"
"Lepcha\0"
"Limbu\0"
"Linear B\0"
"Lycian\0"
"Lydian\0"
"Mandaean\0"
"Meitei Mayek\0"
"Meroitic\0"
"Meroitic Cursive\0"
"Nko\0"
"New Tai Lue\0"
"Ogham\0"
"Ol Chiki\0"
"Old Italic\0"
"Old Persian\0"
"Old South Arabian\0"
"Orkhon\0"
"Osmanya\0"
"Phags Pa\0"
"Phoenician\0"
"Pollard Phonetic\0"
"Rejang\0"
"Runic\0"
"Samaritan\0"
"Saurashtra\0"
"Sharada\0"
"Shavian\0"
"Sora Sompeng\0"
"Cuneiform\0"
"Sundanese\0"
"Syloti Nagri\0"
"Tagalog\0"
"Tagbanwa\0"
"Tai Le\0"
"Tai Viet\0"
"Takri\0"
"Ugaritic\0"
"Braille\0"
"Hiragana\0"
"Caucasian Albanian\0"
"Bassa Vah\0"
"Duployan\0"
"Elbasan\0"
"Grantha\0"
"Pahawh Hmong\0"
"Khojki\0"
"Linear A\0"
"Mahajani\0"
"Manichaean\0"
"Mende Kikakui\0"
"Modi\0"
"Mro\0"
"Old North Arabian\0"
"Nabataean\0"
"Palmyrene\0"
"Pau Cin Hau\0"
"Old Permic\0"
"Psalter Pahlavi\0"
"Siddham\0"
"Khudawadi\0"
"Tirhuta\0"
"Varang Kshiti\0"
"Ahom\0"
"Anatolian Hieroglyphs\0"
"Hatran\0"
"Multani\0"
"Old Hungarian\0"
"Sign Writing\0"
"Adlam\0"
"Bhaiksuki\0"
"Marchen\0"
"Newa\0"
"Osage\0"
"Tangut\0"
"Han with Bopomofo\0"
"Jamo\0"
;

static const quint16 script_name_index[] = {
     0, // AnyScript
     8, // Arabic
    15, // Cyrillic
    24, // Deseret
    32, // Gurmukhi
    41, // Simplified Han
    56, // Traditional Han
    72, // Latin
    78, // Mongolian
    88, // Tifinagh
    97, // Armenian
   106, // Bengali
   114, // Cherokee
   123, // Devanagari
   134, // Ethiopic
   143, // Georgian
   152, // Greek
   158, // Gujarati
   167, // Hebrew
   174, // Japanese
   183, // Khmer
   189, // Kannada
   197, // Korean
   204, // Lao
   208, // Malayalam
   218, // Myanmar
   226, // Oriya
   232, // Tamil
   238, // Telugu
   245, // Thaana
   252, // Thai
   257, // Tibetan
   265, // Sinhala
   273, // Syriac
   280, // Yi
   283, // Vai
   287, // Avestan
   295, // Balinese
   304, // Bamum
   310, // Batak
   316, // Bopomofo
   325, // Brahmi
   332, // Buginese
   341, // Buhid
   347, // Canadian Aboriginal
   367, // Carian
   374, // Chakma
   381, // Cham
   386, // Coptic
   393, // Cypriot
   401, // Egyptian Hieroglyphs
   422, // Fraser
   429, // Glagolitic
   440, // Gothic
   447, // Han
   451, // Hangul
   458, // Hanunoo
   466, // Imperial Aramaic
   483, // Inscriptional Pahlavi
   505, // Inscriptional Parthian
   528, // Javanese
   537, // Kaithi
   544, // Katakana
   553, // Kayah Li
   562, // Kharoshthi
   573, // Lanna
   579, // Lepcha
   586, // Limbu
   592, // Linear B
   601, // Lycian
   608, // Lydian
   615, // Mandaean
   624, // Meitei Mayek
   637, // Meroitic
   646, // Meroitic Cursive
   663, // Nko
   667, // New Tai Lue
   679, // Ogham
   685, // Ol Chiki
   694, // Old Italic
   705, // Old Persian
   717, // Old South Arabian
   735, // Orkhon
   742, // Osmanya
   750, // Phags Pa
   759, // Phoenician
   770, // Pollard Phonetic
   787, // Rejang
   794, // Runic
   800, // Samaritan
   810, // Saurashtra
   821, // Sharada
   829, // Shavian
   837, // Sora Sompeng
   850, // Cuneiform
   860, // Sundanese
   870, // Syloti Nagri
   883, // Tagalog
   891, // Tagbanwa
   900, // Tai Le
   907, // Tai Viet
   916, // Takri
   922, // Ugaritic
   931, // Braille
   939, // Hiragana
   948, // Caucasian Albanian
   967, // Bassa Vah
   977, // Duployan
   986, // Elbasan
   994, // Grantha
  1002, // Pahawh Hmong
  1015, // Khojki
  1022, // Linear A
  1031, // Mahajani
  1040, // Manichaean
  1051, // Mende Kikakui
  1065, // Modi
  1070, // Mro
  1074, // Old North Arabian
  1092, // Nabataean
  1102, // Palmyrene
  1112, // Pau Cin Hau
  1124, // Old Permic
  1135, // Psalter Pahlavi
  1151, // Siddham
  1159, // Khudawadi
  1169, // Tirhuta
  1177, // Varang Kshiti
  1191, // Ahom
  1196, // Anatolian Hieroglyphs
  1218, // Hatran
  1225, // Multani
  1233, // Old Hungarian
  1247, // Sign Writing
  1260, // Adlam
  1266, // Bhaiksuki
  1276, // Marchen
  1284, // Newa
  1289, // Osage
  1295, // Tangut
  1302, // Han with Bopomofo
  1320, // Jamo
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"American Samoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"Antigua And Barbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"Bosnia And Herzegowina\0"
"Botswana\0"
"Bouvet Island\0"
"Brazil\0"
"British Indian Ocean Territory\0"
"Brunei\0"
"Bulgaria\0"
"Burkina Faso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"Cape Verde\0"
"Cayman Islands\0"
"Central African Republic\0"
"Chad\0"
"Chile\0"
"China\0"
"Christmas Island\0"
"Cocos Islands\0"
"Colombia\0"
"Comoros\0"
"Congo Kinshasa\0"
"Congo Brazzaville\0"
"Cook Islands\0"
"Costa Rica\0"
"Ivory Coast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"Czech Republic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"Dominican Republic\0"
"East Timor\0"
"Ecuador\0"
"Egypt\0"
"El Salvador\0"
"Equatorial Guinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"Falkland Islands\0"
"Faroe Islands\0"
"Fiji\0"
"Finland\0"
"France\0"
"Guernsey\0"
"French Guiana\0"
"French Polynesia\0"
"French Southern Territories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"Guinea Bissau\0"
"Guyana\0"
"Haiti\0"
"Heard And McDonald Islands\0"
"Honduras\0"
"Hong Kong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"North Korea\0"
"South Korea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Laos\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"Libya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"Marshall Islands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"Cura Sao\0"
"New Caledonia\0"
"New Zealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"Norfolk Island\0"
"Northern Mariana Islands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"Palestinian Territories\0"
"Panama\0"
"Papua New Guinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"Puerto Rico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"Russia\0"
"Rwanda\0"
"Saint Kitts And Nevis\0"
"Saint Lucia\0"
"Saint Vincent And The Grenadines\0"
"Samoa\0"
"San Marino\0"
"Sao Tome And Principe\0"
"Saudi Arabia\0"
"Senegal\0"
"Seychelles\0"
"Sierra Leone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"Solomon Islands\0"
"Somalia\0"
"South Africa\0"
"South Georgia And The South Sandwich Islands\0"
"Spain\0"
"Sri Lanka\0"
"Saint Helena\0"
"Saint Pierre And Miquelon\0"
"Sudan\0"
"Suriname\0"
"Svalbard And Jan Mayen Islands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"Syria\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"Trinidad And Tobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"Turks And Caicos Islands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"United Arab Emirates\0"
"United Kingdom\0"
"United States\0"
"United States Minor Outlying Islands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"Vatican City State\0"
"Venezuela\0"
"Vietnam\0"
"British Virgin Islands\0"
"United States Virgin Islands\0"
"Wallis And Futuna Islands\0"
"Western Sahara\0"
"Yemen\0"
"Canary Islands\0"
"Zambia\0"
"Zimbabwe\0"
"Clipperton Island\0"
"Montenegro\0"
"Serbia\0"
"Saint Barthelemy\0"
"Saint Martin\0"
"Latin America\0"
"Ascension Island\0"
"Aland Islands\0"
"Diego Garcia\0"
"Ceuta And Melilla\0"
"Isle Of Man\0"
"Jersey\0"
"Tristan Da Cunha\0"
"South Sudan\0"
"Bonaire\0"
"Sint Maarten\0"
"Kosovo\0"
"European Union\0"
"Outlying Oceania\0"
"World\0"
"Europe\0"
;

static const quint16 country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // American Samoa
    51, // Andorra
    59, // Angola
    66, // Anguilla
    75, // Antarctica
    86, // Antigua And Barbuda
   106, // Argentina
   116, // Armenia
   124, // Aruba
   130, // Australia
   140, // Austria
   148, // Azerbaijan
   159, // Bahamas
   167, // Bahrain
   175, // Bangladesh
   186, // Barbados
   195, // Belarus
   203, // Belgium
   211, // Belize
   218, // Benin
   224, // Bermuda
   232, // Bhutan
   239, // Bolivia
   247, // Bosnia And Herzegowina
   270, // Botswana
   279, // Bouvet Island
   293, // Brazil
   300, // British Indian Ocean Territory
   331, // Brunei
   338, // Bulgaria
   347, // Burkina Faso
   360, // Burundi
   368, // Cambodia
   377, // Cameroon
   386, // Canada
   393, // Cape Verde
   404, // Cayman Islands
   419, // Central African Republic
   444, // Chad
   449, // Chile
   455, // China
   461, // Christmas Island
   478, // Cocos Islands
   492, // Colombia
   501, // Comoros
   509, // Congo Kinshasa
   524, // Congo Brazzaville
   542, // Cook Islands
   555, // Costa Rica
   566, // Ivory Coast
   578, // Croatia
   586, // Cuba
   591, // Cyprus
   598, // Czech Republic
   613, // Denmark
   621, // Djibouti
   630, // Dominica
   639, // Dominican Republic
   658, // East Timor
   669, // Ecuador
   677, // Egypt
   683, // El Salvador
   695, // Equatorial Guinea
   713, // Eritrea
   721, // Estonia
   729, // Ethiopia
   738, // Falkland Islands
   755, // Faroe Islands
   769, // Fiji
   774, // Finland
   782, // France
   789, // Guernsey
   798, // French Guiana
   812, // French Polynesia
   829, // French Southern Territories
   857, // Gabon
   863, // Gambia
   870, // Georgia
   878, // Germany
   886, // Ghana
   892, // Gibraltar
   902, // Greece
   909, // Greenland
   919, // Grenada
   927, // Guadeloupe
   938, // Guam
   943, // Guatemala
   953, // Guinea
   960, // Guinea Bissau
   974, // Guyana
   981, // Haiti
   987, // Heard And McDonald Islands
  1014, // Honduras
  1023, // Hong Kong
  1033, // Hungary
  1041, // Iceland
  1049, // India
  1055, // Indonesia
  1065, // Iran
  1070, // Iraq
  1075, // Ireland
  1083, // Israel
  1090, // Italy
  1096, // Jamaica
  1104, // Japan
  1110, // Jordan
  1117, // Kazakhstan
  1128, // Kenya
  1134, // Kiribati
  1143, // North Korea
  1155, // South Korea
  1167, // Kuwait
  1174, // Kyrgyzstan
  1185, // Laos
  1190, // Latvia
  1197, // Lebanon
  1205, // Lesotho
  1213, // Liberia
  1221, // Libya
  1227, // Liechtenstein
  1241, // Lithuania
  1251, // Luxembourg
  1262, // Macau
  1268, // Macedonia
  1278, // Madagascar
  1289, // Malawi
  1296, // Malaysia
  1305, // Maldives
  1314, // Mali
  1319, // Malta
  1325, // Marshall Islands
  1342, // Martinique
  1353, // Mauritania
  1364, // Mauritius
  1374, // Mayotte
  1382, // Mexico
  1389, // Micronesia
  1400, // Moldova
  1408, // Monaco
  1415, // Mongolia
  1424, // Montserrat
  1435, // Morocco
  1443, // Mozambique
  1454, // Myanmar
  1462, // Namibia
  1470, // Nauru
  1476, // Nepal
  1482, // Netherlands
  1494, // Cura Sao
  1503, // New Caledonia
  1517, // New Zealand
  1529, // Nicaragua
  1539, // Niger
  1545, // Nigeria
  1553, // Niue
  1558, // Norfolk Island
  1573, // Northern Mariana Islands
  1598, // Norway
  1605, // Oman
  1610, // Pakistan
  1619, // Palau
  1625, // Palestinian Territories
  1649, // Panama
  1656, // Papua New Guinea
  1673, // Paraguay
  1682, // Peru
  1687, // Philippines
  1699, // Pitcairn
  1708, // Poland
  1715, // Portugal
  1724, // Puerto Rico
  1736, // Qatar
  1742, // Reunion
  1750, // Romania
  1758, // Russia
  1765, // Rwanda
  1772, // Saint Kitts And Nevis
  1794, // Saint Lucia
  1806, // Saint Vincent And The Grenadines
  1839, // Samoa
  1845, // San Marino
  1856, // Sao Tome And Principe
  1878, // Saudi Arabia
  1891, // Senegal
  1899, // Seychelles
  1910, // Sierra Leone
  1923, // Singapore
  1933, // Slovakia
  1942, // Slovenia
  1951, // Solomon Islands
  1967, // Somalia
  1975, // South Africa
  1988, // South Georgia And The South Sandwich Islands
  2033, // Spain
  2039, // Sri Lanka
  2049, // Saint Helena
  2062, // Saint Pierre And Miquelon
  2088, // Sudan
  2094, // Suriname
  2103, // Svalbard And Jan Mayen Islands
  2134, // Swaziland
  2144, // Sweden
  2151, // Switzerland
  2163, // Syria
  2169, // Taiwan
  2176, // Tajikistan
  2187, // Tanzania
  2196, // Thailand
  2205, // Togo
  2210, // Tokelau
  2218, // Tonga
  2224, // Trinidad And Tobago
  2244, // Tunisia
  2252, // Turkey
  2259, // Turkmenistan
  2272, // Turks And Caicos Islands
  2297, // Tuvalu
  2304, // Uganda
  2311, // Ukraine
  2319, // United Arab Emirates
  2340, // United Kingdom
  2355, // United States
  2369, // United States Minor Outlying Islands
  2406, // Uruguay
  2414, // Uzbekistan
  2425, // Vanuatu
  2433, // Vatican City State
  2452, // Venezuela
  2462, // Vietnam
  2470, // British Virgin Islands
  2493, // United States Virgin Islands
  2522, // Wallis And Futuna Islands
  2548, // Western Sahara
  2563, // Yemen
  2569, // Canary Islands
  2584, // Zambia
  2591, // Zimbabwe
  2600, // Clipperton Island
  2618, // Montenegro
  2629, // Serbia
  2636, // Saint Barthelemy
  2653, // Saint Martin
  2666, // Latin America
  2680, // Ascension Island
  2697, // Aland Islands
  2711, // Diego Garcia
  2724, // Ceuta And Melilla
  2742, // Isle Of Man
  2754, // Jersey
  2761, // Tristan Da Cunha
  2778, // South Sudan
  2790, // Bonaire
  2798, // Sint Maarten
  2811, // Kosovo
  2818, // European Union
  2833, // Outlying Oceania
  2850, // World
  2856, // Europe
};

static const unsigned char language_code_list[] =
"  \0" // AnyLanguage
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Oromo
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Dzongkha
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Belarusian
"km\0" // Khmer
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fijian
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Western Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Rundi
"lo\0" // Lao
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mh\0" // Marshallese
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // Norwegian Bokmal
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // Romansh
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sango
"sa\0" // Sanskrit
"sr\0" // Serbian
"os\0" // Ossetic
"st\0" // Southern Sotho
"tn\0" // Tswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Sinhala
"ss\0" // Swati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"sc\0" // Sardinian
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tongan
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"ty\0" // Tahitian
"ug\0" // Uighur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // Norwegian Nynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wal" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Nyanja
"fil" // Filipino
"gsw" // Swiss German
"ii\0" // Sichuan Yi
"kpe" // Kpelle
"nds" // Low German
"nr\0" // South Ndebele
"nso" // Northern Sotho
"se\0" // Northern Sami
"trv" // Taroko
"guz" // Gusii
"dav" // Taita
"ff\0" // Fulah
"ki\0" // Kikuyu
"saq" // Samburu
"seh" // Sena
"nd\0" // North Ndebele
"rof" // Rombo
"shi" // Tachelhit
"kab" // Kabyle
"nyn" // Nyankole
"bez" // Bena
"vun" // Vunjo
"bm\0" // Bambara
"ebu" // Embu
"chr" // Cherokee
"mfe" // Morisyen
"kde" // Makonde
"lag" // Langi
"lg\0" // Ganda
"bem" // Bemba
"kea" // Kabuverdianu
"mer" // Meru
"kln" // Kalenjin
"naq" // Nama
"jmc" // Machame
"ksh" // Colognian
"mas" // Masai
"xog" // Soga
"luy" // Luyia
"asa" // Asu
"teo" // Teso
"ssy" // Saho
"khq" // Koyra Chiini
"rwk" // Rwa
"luo" // Luo
"cgg" // Chiga
"tzm" // Central Morocco Tamazight
"ses" // Koyraboro Senni
"ksb" // Shambala
"brx" // Bodo
"av\0" // Avaric
"ch\0" // Chamorro
"ce\0" // Chechen
"cu\0" // Church
"cv\0" // Chuvash
"cr\0" // Cree
"ht\0" // Haitian
"hz\0" // Herero
"ho\0" // Hiri Motu
"kr\0" // Kanuri
"kv\0" // Komi
"kg\0" // Kongo
"kj\0" // Kwanyama
"li\0" // Limburgish
"lu\0" // Luba Katanga
"lb\0" // Luxembourgish
"nv\0" // Navaho
"ng\0" // Ndonga
"oj\0" // Ojibwa
"pi\0" // Pali
"wa\0" // Walloon
"agq" // Aghem
"bas" // Basaa
"dje" // Zarma
"dua" // Duala
"dyo" // Jola Fonyi
"ewo" // Ewondo
"ksf" // Bafia
"mgh" // Makhuwa Meetto
"mua" // Mundang
"nmg" // Kwasio
"nus" // Nuer
"sah" // Sakha
"sbp" // Sangu
"swc" // Congo Swahili
"twq" // Tasawaq
"vai" // Vai
"wae" // Walser
"yav" // Yangben
"ae\0" // Avestan
"ast" // Asturian
"jgo" // Ngomba
"kkj" // Kako
"mgo" // Meta
"nnh" // Ngiemboon
"an\0" // Aragonese
"akk" // Akkadian
"egy" // Ancient Egyptian
"grc" // Ancient Greek
"arc" // Aramaic
"ban" // Balinese
"bax" // Bamun
"bbc" // Batak Toba
"bug" // Buginese
"bku" // Buhid
"xcr" // Carian
"ccp" // Chakma
"myz" // Classical Mandaic
"cop" // Coptic
"doi" // Dogri
"cjm" // Eastern Cham
"eky" // Eastern Kayah
"ett" // Etruscan
"got" // Gothic
"hnn" // Hanunoo
"inh" // Ingush
"hmd" // Large Flowery Miao
"lep" // Lepcha
"lif" // Limbu
"lis" // Lisu
"khb" // Lu
"xlc" // Lycian
"xld" // Lydian
"man" // Mandingo
"mni" // Manipuri
"xmr" // Meroitic
"nod" // Northern Thai
"sga" // Old Irish
"non" // Old Norse
"peo" // Old Persian
"otk" // Old Turkish
"pal" // Pahlavi
"xpr" // Parthian
"phn" // Phoenician
"pra" // Prakrit Language
"rej" // Rejang
"xsa" // Sabaean
"smp" // Samaritan
"sat" // Santali
"saz" // Saurashtra
"srb" // Sora
"syl" // Sylheti
"tbw" // Tagbanwa
"blt" // Tai Dam
"tdd" // Tai Nua
"uga" // Ugaritic
"bss" // Akoose
"lkt" // Lakota
"zgh" // Standard Moroccan Tamazight
"arn" // Mapuche
"ckb" // Central Kurdish
"dsb" // Lower Sorbian
"hsb" // Upper Sorbian
"ken" // Kenyang
"moh" // Mohawk
"nqo" // Nko
"prg" // Prussian
"quc" // Kiche
"sma" // Southern Sami
"smj" // Lule Sami
"smn" // Inari Sami
"sms" // Skolt Sami
"wbp" // Warlpiri
"xmn" // Manichaean Middle Persian
"men" // Mende
"xna" // Ancient North Arabian
"lab" // Linear A
"hnj" // Hmong Njua
"hoc" // Ho
"lez" // Lezghian
"bsq" // Bassa
"mru" // Mono
"ctd" // Tedim Chin
"mai" // Maithili
"aho" // Ahom
"ase" // American Sign Language
"pka" // Ardhamagadhi Prakrit
"bho" // Bhojpuri
"hlu" // Hieroglyphic Luwian
"lzh" // Literary Chinese
"mzn" // Mazanderani
"mro" // Mru
"new" // Newari
"lrc" // Northern Luri
"pau" // Palauan
"pap" // Papiamento
"skr" // Saraiki
"tkl" // Tokelau
"tpi" // Tok Pisin
"tvl" // Tuvalu
"mis" // Uncoded Languages
"yue" // Cantonese
"osa" // Osage
"txg" // Tangut
;

static const unsigned char script_code_list[] =
"Zzzz" // AnyScript
"Arab" // Arabic
"Cyrl" // Cyrillic
"Dsrt" // Deseret
"Guru" // Gurmukhi
"Hans" // Simplified Han
"Hant" // Traditional Han
"Latn" // Latin
"Mong" // Mongolian
"Tfng" // Tifinagh
"Armn" // Armenian
"Beng" // Bengali
"Cher" // Cherokee
"Deva" // Devanagari
"Ethi" // Ethiopic
"Geor" // Georgian
"Grek" // Greek
"Gujr" // Gujarati
"Hebr" // Hebrew
"Jpan" // Japanese
"Khmr" // Khmer
"Knda" // Kannada
"Kore" // Korean
"Laoo" // Lao
"Mlym" // Malayalam
"Mymr" // Myanmar
"Orya" // Oriya
"Taml" // Tamil
"Telu" // Telugu
"Thaa" // Thaana
"Thai" // Thai
"Tibt" // Tibetan
"Sinh" // Sinhala
"Syrc" // Syriac
"Yiii" // Yi
"Vaii" // Vai
"Avst" // Avestan
"Bali" // Balinese
"Bamu" // Bamum
"Batk" // Batak
"Bopo" // Bopomofo
"Brah" // Brahmi
"Bugi" // Buginese
"Buhd" // Buhid
"Cans" // Canadian Aboriginal
"Cari" // Carian
"Cakm" // Chakma
"Cham" // Cham
"Copt" // Coptic
"Cprt" // Cypriot
"Egyp" // Egyptian Hieroglyphs
"Lisu" // Fraser
"Glag" // Glagolitic
"Goth" // Gothic
"Hani" // Han
"Hang" // Hangul
"Hano" // Hanunoo
"Armi" // Imperial Aramaic
"Phli" // Inscriptional Pahlavi
"Prti" // Inscriptional Parthian
"Java" // Javanese
"Kthi" // Kaithi
"Kana" // Katakana
"Kali" // Kayah Li
"Khar" // Kharoshthi
"Lana" // Lanna
"Lepc" // Lepcha
"Limb" // Limbu
"Linb" // Linear B
"Lyci" // Lycian
"Lydi" // Lydian
"Mand" // Mandaean
"Mtei" // Meitei Mayek
"Mero" // Meroitic
"Merc" // Meroitic Cursive
"Nkoo" // Nko
"Talu" // New Tai Lue
"Ogam" // Ogham
"Olck" // Ol Chiki
"Ital" // Old Italic
"Xpeo" // Old Persian
"Sarb" // Old South Arabian
"Orkh" // Orkhon
"Osma" // Osmanya
"Phag" // Phags Pa
"Phnx" // Phoenician
"Plrd" // Pollard Phonetic
"Rjng" // Rejang
"Runr" // Runic
"Samr" // Samaritan
"Saur" // Saurashtra
"Shrd" // Sharada
"Shaw" // Shavian
"Sora" // Sora Sompeng
"Xsux" // Cuneiform
"Sund" // Sundanese
"Sylo" // Syloti Nagri
"Tglg" // Tagalog
"Tagb" // Tagbanwa
"Tale" // Tai Le
"Tavt" // Tai Viet
"Takr" // Takri
"Ugar" // Ugaritic
"Brai" // Braille
"Hira" // Hiragana
"Aghb" // Caucasian Albanian
"Bass" // Bassa Vah
"Dupl" // Duployan
"Elba" // Elbasan
"Gran" // Grantha
"Hmng" // Pahawh Hmong
"Khoj" // Khojki
"Lina" // Linear A
"Mahj" // Mahajani
"Mani" // Manichaean
"Mend" // Mende Kikakui
"Modi" // Modi
"Mroo" // Mro
"Narb" // Old North Arabian
"Nbat" // Nabataean
"Palm" // Palmyrene
"Pauc" // Pau Cin Hau
"Perm" // Old Permic
"Phlp" // Psalter Pahlavi
"Sidd" // Siddham
"Sind" // Khudawadi
"Tirh" // Tirhuta
"Wara" // Varang Kshiti
"Ahom" // Ahom
"Hluw" // Anatolian Hieroglyphs
"Hatr" // Hatran
"Mult" // Multani
"Hung" // Old Hungarian
"Sgnw" // Sign Writing
"Adlm" // Adlam
"Bhks" // Bhaiksuki
"Marc" // Marchen
"Newa" // Newa
"Osge" // Osage
"Tang" // Tangut
"Hanb" // Han with Bopomofo
"Jamo" // Jamo
;
static const unsigned char country_code_list[] =
"ZZ\0" // AnyCountry
"AF\0" // Afghanistan
"AL\0" // Albania
"DZ\0" // Algeria
"AS\0" // American Samoa
"AD\0" // Andorra
"AO\0" // Angola
"AI\0" // Anguilla
"AQ\0" // Antarctica
"AG\0" // Antigua And Barbuda
"AR\0" // Argentina
"AM\0" // Armenia
"AW\0" // Aruba
"AU\0" // Australia
"AT\0" // Austria
"AZ\0" // Azerbaijan
"BS\0" // Bahamas
"BH\0" // Bahrain
"BD\0" // Bangladesh
"BB\0" // Barbados
"BY\0" // Belarus
"BE\0" // Belgium
"BZ\0" // Belize
"BJ\0" // Benin
"BM\0" // Bermuda
"BT\0" // Bhutan
"BO\0" // Bolivia
"BA\0" // Bosnia And Herzegowina
"BW\0" // Botswana
"BV\0" // Bouvet Island
"BR\0" // Brazil
"IO\0" // British Indian Ocean Territory
"BN\0" // Brunei
"BG\0" // Bulgaria
"BF\0" // Burkina Faso
"BI\0" // Burundi
"KH\0" // Cambodia
"CM\0" // Cameroon
"CA\0" // Canada
"CV\0" // Cape Verde
"KY\0" // Cayman Islands
"CF\0" // Central African Republic
"TD\0" // Chad
"CL\0" // Chile
"CN\0" // China
"CX\0" // Christmas Island
"CC\0" // Cocos Islands
"CO\0" // Colombia
"KM\0" // Comoros
"CD\0" // Congo Kinshasa
"CG\0" // Congo Brazzaville
"CK\0" // Cook Islands
"CR\0" // Costa Rica
"CI\0" // Ivory Coast
"HR\0" // Croatia
"CU\0" // Cuba
"CY\0" // Cyprus
"CZ\0" // Czech Republic
"DK\0" // Denmark
"DJ\0" // Djibouti
"DM\0" // Dominica
"DO\0" // Dominican Republic
"TL\0" // East Timor
"EC\0" // Ecuador
"EG\0" // Egypt
"SV\0" // El Salvador
"GQ\0" // Equatorial Guinea
"ER\0" // Eritrea
"EE\0" // Estonia
"ET\0" // Ethiopia
"FK\0" // Falkland Islands
"FO\0" // Faroe Islands
"FJ\0" // Fiji
"FI\0" // Finland
"FR\0" // France
"GG\0" // Guernsey
"GF\0" // French Guiana
"PF\0" // French Polynesia
"TF\0" // French Southern Territories
"GA\0" // Gabon
"GM\0" // Gambia
"GE\0" // Georgia
"DE\0" // Germany
"GH\0" // Ghana
"GI\0" // Gibraltar
"GR\0" // Greece
"GL\0" // Greenland
"GD\0" // Grenada
"GP\0" // Guadeloupe
"GU\0" // Guam
"GT\0" // Guatemala
"GN\0" // Guinea
"GW\0" // Guinea Bissau
"GY\0" // Guyana
"HT\0" // Haiti
"HM\0" // Heard And McDonald Islands
"HN\0" // Honduras
"HK\0" // Hong Kong
"HU\0" // Hungary
"IS\0" // Iceland
"IN\0" // India
"ID\0" // Indonesia
"IR\0" // Iran
"IQ\0" // Iraq
"IE\0" // Ireland
"IL\0" // Israel
"IT\0" // Italy
"JM\0" // Jamaica
"JP\0" // Japan
"JO\0" // Jordan
"KZ\0" // Kazakhstan
"KE\0" // Kenya
"KI\0" // Kiribati
"KP\0" // North Korea
"KR\0" // South Korea
"KW\0" // Kuwait
"KG\0" // Kyrgyzstan
"LA\0" // Laos
"LV\0" // Latvia
"LB\0" // Lebanon
"LS\0" // Lesotho
"LR\0" // Liberia
"LY\0" // Libya
"LI\0" // Liechtenstein
"LT\0" // Lithuania
"LU\0" // Luxembourg
"MO\0" // Macau
"MK\0" // Macedonia
"MG\0" // Madagascar
"MW\0" // Malawi
"MY\0" // Malaysia
"MV\0" // Maldives
"ML\0" // Mali
"MT\0" // Malta
"MH\0" // Marshall Islands
"MQ\0" // Martinique
"MR\0" // Mauritania
"MU\0" // Mauritius
"YT\0" // Mayotte
"MX\0" // Mexico
"FM\0" // Micronesia
"MD\0" // Moldova
"MC\0" // Monaco
"MN\0" // Mongolia
"MS\0" // Montserrat
"MA\0" // Morocco
"MZ\0" // Mozambique
"MM\0" // Myanmar
"NA\0" // Namibia
"NR\0" // Nauru
"NP\0" // Nepal
"NL\0" // Netherlands
"CW\0" // Cura Sao
"NC\0" // New Caledonia
"NZ\0" // New Zealand
"NI\0" // Nicaragua
"NE\0" // Niger
"NG\0" // Nigeria
"NU\0" // Niue
"NF\0" // Norfolk Island
"MP\0" // Northern Mariana Islands
"NO\0" // Norway
"OM\0" // Oman
"PK\0" // Pakistan
"PW\0" // Palau
"PS\0" // Palestinian Territories
"PA\0" // Panama
"PG\0" // Papua New Guinea
"PY\0" // Paraguay
"PE\0" // Peru
"PH\0" // Philippines
"PN\0" // Pitcairn
"PL\0" // Poland
"PT\0" // Portugal
"PR\0" // Puerto Rico
"QA\0" // Qatar
"RE\0" // Reunion
"RO\0" // Romania
"RU\0" // Russia
"RW\0" // Rwanda
"KN\0" // Saint Kitts And Nevis
"LC\0" // Saint Lucia
"VC\0" // Saint Vincent And The Grenadines
"WS\0" // Samoa
"SM\0" // San Marino
"ST\0" // Sao Tome And Principe
"SA\0" // Saudi Arabia
"SN\0" // Senegal
"SC\0" // Seychelles
"SL\0" // Sierra Leone
"SG\0" // Singapore
"SK\0" // Slovakia
"SI\0" // Slovenia
"SB\0" // Solomon Islands
"SO\0" // Somalia
"ZA\0" // South Africa
"GS\0" // South Georgia And The South Sandwich Islands
"ES\0" // Spain
"LK\0" // Sri Lanka
"SH\0" // Saint Helena
"PM\0" // Saint Pierre And Miquelon
"SD\0" // Sudan
"SR\0" // Suriname
"SJ\0" // Svalbard And Jan Mayen Islands
"SZ\0" // Swaziland
"SE\0" // Sweden
"CH\0" // Switzerland
"SY\0" // Syria
"TW\0" // Taiwan
"TJ\0" // Tajikistan
"TZ\0" // Tanzania
"TH\0" // Thailand
"TG\0" // Togo
"TK\0" // Tokelau
"TO\0" // Tonga
"TT\0" // Trinidad And Tobago
"TN\0" // Tunisia
"TR\0" // Turkey
"TM\0" // Turkmenistan
"TC\0" // Turks And Caicos Islands
"TV\0" // Tuvalu
"UG\0" // Uganda
"UA\0" // Ukraine
"AE\0" // United Arab Emirates
"GB\0" // United Kingdom
"US\0" // United States
"UM\0" // United States Minor Outlying Islands
"UY\0" // Uruguay
"UZ\0" // Uzbekistan
"VU\0" // Vanuatu
"VA\0" // Vatican City State
"VE\0" // Venezuela
"VN\0" // Vietnam
"VG\0" // British Virgin Islands
"VI\0" // United States Virgin Islands
"WF\0" // Wallis And Futuna Islands
"EH\0" // Western Sahara
"YE\0" // Yemen
"IC\0" // Canary Islands
"ZM\0" // Zambia
"ZW\0" // Zimbabwe
"CP\0" // Clipperton Island
"ME\0" // Montenegro
"RS\0" // Serbia
"BL\0" // Saint Barthelemy
"MF\0" // Saint Martin
"419" // Latin America
"AC\0" // Ascension Island
"AX\0" // Aland Islands
"DG\0" // Diego Garcia
"EA\0" // Ceuta And Melilla
"IM\0" // Isle Of Man
"JE\0" // Jersey
"TA\0" // Tristan Da Cunha
"SS\0" // South Sudan
"BQ\0" // Bonaire
"SX\0" // Sint Maarten
"XK\0" // Kosovo
"EU\0" // European Union
"QO\0" // Outlying Oceania
"001" // World
"150" // Europe
;

// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
