# VoiceOver

VoiceOver is an Accessibility feature available on Apple platforms. It provides
an interface between your app and your blind or low-vision users. In short, it's
a screen reader.

## Overview

[Activating VoiceOver](#Activate-VoiceOver) fundamentally changes the touch
interface of an iOS device, so when you activate it, you need to know these
basic commands to navigate:

-   VoiceOver focuses an item on the screen and speaks it to the user.
-   To navigate between items, you can either flick left/right to go to the
    previous/next item, or you can drag your finger around the screen.
-   Double tapping anywhere on the screen activates the item (no need to double
    tap exactly on the item on the screen).
-   Items have a label (describing the item) and can have among others:
    -   traits (describing the item: a header, a button, selection state, etc.);
    -   a hint (describing how to interact with the item).

The following video is a great summary. The content is succinct, high quality
and up-to-date, even though the video quality is low and the demo is on an
iPhone 3GS.

[![Video screenshot]][Video link]

## Activate VoiceOver

Go to `Settings > General > Accessibility > VoiceOver` and toggle the top
switch.

Alternatively, if you are activating/deactivating VoiceOver often, I'd advise
to set it as the Accessibility Shortcut. When enabled, a triple tap on the Home
button will toggle VoiceOver ON and OFF from anywhere.
```
Settings > General > Accessibility > Accessibility Shortcut
```

## Additional Resources

-   [Apple presentation of VoiceOver]
-   [AppleVis intro to VoiceOver]

[Apple presentation of VoiceOver]: http://www.apple.com/accessibility/osx/voiceover/
[AppleVis intro to VoiceOver]: http://www.applevis.com/guides/ios-miscellaneous-voiceover/intro-ios-accessibility-blind-and-low-vision-users
[Video screenshot]: https://img.youtube.com/vi/WxQ2qKShvmc/0.jpg
[Video link]: https://www.youtube.com/watch?v=WxQ2qKShvmc "iPhone VoiceOver Function For People With Disabilities"
