/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.util.Log;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    public static final String TAG = "Version";
    public final int majorVersion;
    public final int minorVersion;
    public final int patchVersion;

    public Version(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public static Version parse(String versionString) {
        if (versionString == null || versionString.isEmpty()) {
            return null;
        }
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)").matcher(versionString);
        if (!m.matches()) {
            String string = String.valueOf(versionString);
            Log.w((String)TAG, (String)(string.length() != 0 ? "Failed to parse version from: ".concat(string) : new String("Failed to parse version from: ")));
            return null;
        }
        return new Version(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
    }

    public boolean isAtLeast(Version other) {
        if (this.majorVersion > other.majorVersion) {
            return true;
        }
        if (this.majorVersion < other.majorVersion) {
            return false;
        }
        if (this.minorVersion > other.minorVersion) {
            return true;
        }
        if (this.minorVersion < other.minorVersion) {
            return false;
        }
        if (this.patchVersion > other.patchVersion) {
            return true;
        }
        return this.patchVersion >= other.patchVersion;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)other;
        return this.majorVersion == otherVersion.majorVersion && this.minorVersion == otherVersion.minorVersion && this.patchVersion == otherVersion.patchVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }

    public String toString() {
        return String.format("%d.%d.%d", this.majorVersion, this.minorVersion, this.patchVersion);
    }
}

