/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AstUtil {
    private static final String PROTOTYPE_SUFFIX = ".prototype";

    static Node parentOfType(Node node, int n) {
        Node node2 = node.getParent();
        return node2 == null || node2.getType() != n ? null : node2;
    }

    static Node getFunctionNameNode(Node node) {
        Preconditions.checkState(node.isFunction());
        Node node2 = node.getParent();
        if (node2 != null) {
            switch (node2.getType()) {
                case 38: {
                    return node2;
                }
                case 154: {
                    return node2;
                }
                case 39: {
                    return node2;
                }
                case 86: {
                    int n = node2.getFirstChild().getType();
                    return n == 38 || n == 33 ? node2.getFirstChild() : null;
                }
                case 118: {
                    return node2.getFirstChild();
                }
            }
            Node node3 = node.getFirstChild();
            return node3.getString().isEmpty() ? null : node3;
        }
        return null;
    }

    static String getTypeNameFromPrototype(String string) {
        return string.substring(0, string.length() - PROTOTYPE_SUFFIX.length());
    }

    static boolean isPrototypeName(String string) {
        return string.endsWith(PROTOTYPE_SUFFIX);
    }

    static Node getAssignedTypeNameNode(Node node) {
        Preconditions.checkState(node.isAssign() || node.isVar());
        Node node2 = node.getFirstChild();
        if (node2.getType() != 33 && node2.getType() != 38) {
            return null;
        }
        return node2;
    }

    static List<Node> getArguments(Node node) {
        int n = node.getChildCount();
        if (n == 1) {
            return Collections.emptyList();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n - 1);
        for (int i = 1; i < n; ++i) {
            arrayList.add(node.getChildAtIndex(i));
        }
        return arrayList;
    }

    static String getAnnotationTypeString(JSTypeExpression jSTypeExpression) {
        return jSTypeExpression.getRoot().getFirstChild().getString();
    }

    private AstUtil() {
    }
}

