// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_PRINTER_PROVIDER_USB_PRINTER_MANIFEST_HANDLER_H_
#define EXTENSIONS_COMMON_API_PRINTER_PROVIDER_USB_PRINTER_MANIFEST_HANDLER_H_

#include "extensions/common/manifest_handler.h"

namespace extensions {

// Parses the "usb_printers" manifest key.
class UsbPrinterManifestHandler : public ManifestHandler {
 public:
  UsbPrinterManifestHandler();
  ~UsbPrinterManifestHandler() override;

 private:
  // ManifestHandler overrides.
  bool Parse(Extension* extension, base::string16* error) override;
  const std::vector<std::string> Keys() const override;
};

}  // namespace extensions

#endif  // EXTENSIONS_COMMON_API_PRINTER_PROVIDER_USB_PRINTER_MANIFEST_HANDLER_H_
