/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.AbstractMapBasedMultimap;
import com.squareup.haha.guava.collect.AbstractMultimap;
import com.squareup.haha.guava.collect.Collections2;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.Maps;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        Ascii.checkArgument(map.isEmpty());
        this.map = map;
    }

    abstract Collection<V> createCollection();

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean put(@Nullable K key, @Nullable V value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            collection = abstractMapBasedMultimap.createCollection();
            if (collection.add(value)) {
                ++this.totalSize;
                this.map.put(key, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(@Nullable K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            collection = abstractMapBasedMultimap.createCollection();
        }
        return this.wrapCollection(key, collection);
    }

    final Collection<V> wrapCollection(@Nullable K key, Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(this, key, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(this, key, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(key, (List)collection, null);
        }
        return new WrappedCollection(this, key, collection, null);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private List wrapList(@Nullable Object key, List list, @Nullable WrappedCollection ancestor) {
        if (list instanceof RandomAccess) {
            return new RandomAccessWrappedList(this, key, list, ancestor);
        }
        return new WrappedList(this, key, list, ancestor);
    }

    @Override
    final Set<K> createKeySet() {
        if (this.map instanceof SortedMap) {
            return new SortedKeySet(this, (SortedMap)this.map);
        }
        return new KeySet(this.map);
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    final Iterator<V> valueIterator() {
        return new Itr(this){

            final V output(K key, V value) {
                return value;
            }
        };
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    final Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr(this){};
    }

    @Override
    final Map<K, Collection<V>> createAsMap() {
        if (this.map instanceof SortedMap) {
            return new SortedAsMap(this, (SortedMap)this.map);
        }
        return new AsMap(this.map);
    }

    static /* synthetic */ Iterator access$100(AbstractMapBasedMultimap x0, Collection x1) {
        Collection collection = x1;
        if (collection instanceof List) {
            return ((List)collection).listIterator();
        }
        return collection.iterator();
    }

    static /* synthetic */ int access$400(AbstractMapBasedMultimap x0, Object x1) {
        Object object = x1;
        AbstractMapBasedMultimap abstractMapBasedMultimap = x0;
        Collection collection = Maps.safeRemove(abstractMapBasedMultimap.map, object);
        int n = 0;
        if (collection != null) {
            n = collection.size();
            collection.clear();
            abstractMapBasedMultimap.totalSize -= n;
        }
        return n;
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$AsMap, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$AsMap - discarding signature.
     */
    final class SortedAsMap
    extends AsMap
    implements SortedMap {
        private SortedSet<K> sortedKeySet;
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        SortedAsMap(AbstractMapBasedMultimap abstractMapBasedMultimap, SortedMap<K, Collection<V>> submap) {
            this.this$0 = abstractMapBasedMultimap;
            super(submap);
        }

        @Override
        public final Comparator<? super K> comparator() {
            SortedAsMap sortedAsMap = this;
            return ((SortedMap)sortedAsMap.submap).comparator();
        }

        @Override
        public final K firstKey() {
            SortedAsMap sortedAsMap = this;
            return ((SortedMap)sortedAsMap.submap).firstKey();
        }

        @Override
        public final K lastKey() {
            SortedAsMap sortedAsMap = this;
            return ((SortedMap)sortedAsMap.submap).lastKey();
        }

        public final SortedMap<K, Collection<V>> headMap(K toKey) {
            SortedAsMap sortedAsMap = this;
            return new SortedAsMap(this.this$0, ((SortedMap)sortedAsMap.submap).headMap(toKey));
        }

        public final SortedMap<K, Collection<V>> subMap(K fromKey, K toKey) {
            SortedAsMap sortedAsMap = this;
            return new SortedAsMap(this.this$0, ((SortedMap)sortedAsMap.submap).subMap(fromKey, toKey));
        }

        public final SortedMap<K, Collection<V>> tailMap(K fromKey) {
            SortedAsMap sortedAsMap = this;
            return new SortedAsMap(this.this$0, ((SortedMap)sortedAsMap.submap).tailMap(fromKey));
        }

        @Override
        private SortedSet<K> createKeySet() {
            SortedAsMap sortedAsMap = this;
            return new SortedKeySet(this.this$0, (SortedMap)sortedAsMap.submap);
        }
    }

    class AsMap
    extends Maps.ImprovedAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        AsMap(Map<K, Collection<V>> submap) {
            this.submap = submap;
        }

        @Override
        protected final Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries(this);
        }

        @Override
        public boolean containsKey(Object key) {
            return Maps.safeContainsKey(this.submap, key);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || this.submap.equals(object);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
                return;
            }
            Iterators.clear(new AsMapIterator(this));
        }

        final class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            private Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            private Collection<V> collection;
            private /* synthetic */ AsMap this$1;

            AsMapIterator(AsMap asMap) {
                this.this$1 = asMap;
                this.delegateIterator = this.this$1.submap.entrySet().iterator();
            }

            @Override
            public final boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public final void remove() {
                this.delegateIterator.remove();
                this.this$1.AbstractMapBasedMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
            }
        }

        final class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            private /* synthetic */ AsMap this$1;

            AsMapEntries(AsMap asMap) {
                this.this$1 = asMap;
            }

            @Override
            final Map<K, Collection<V>> map() {
                return this.this$1;
            }

            @Override
            public final Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator(this.this$1);
            }

            @Override
            public final boolean contains(Object o) {
                return Collections2.safeContains(this.this$1.submap.entrySet(), o);
            }

            @Override
            public final boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AbstractMapBasedMultimap.access$400(this.this$1.AbstractMapBasedMultimap.this, entry.getKey());
                return true;
            }
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        private Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        private K key;
        private Collection<V> collection;
        private Iterator<V> valueIterator;
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        Itr(AbstractMapBasedMultimap abstractMapBasedMultimap) {
            this.this$0 = abstractMapBasedMultimap;
            this.keyIterator = abstractMapBasedMultimap.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        abstract T output(K var1, V var2);

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                Map.Entry mapEntry = this.keyIterator.next();
                this.key = mapEntry.getKey();
                this.collection = mapEntry.getValue();
                this.valueIterator = this.collection.iterator();
            }
            return this.output(this.key, this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            this.this$0.totalSize--;
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$KeySet, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$KeySet - discarding signature.
     */
    final class SortedKeySet
    extends KeySet
    implements SortedSet {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        SortedKeySet(AbstractMapBasedMultimap abstractMapBasedMultimap, SortedMap<K, Collection<V>> subMap) {
            this.this$0 = abstractMapBasedMultimap;
            super(subMap);
        }

        public final Comparator<? super K> comparator() {
            SortedKeySet sortedKeySet = this;
            return ((SortedMap)super.map()).comparator();
        }

        public final K first() {
            SortedKeySet sortedKeySet = this;
            return ((SortedMap)super.map()).firstKey();
        }

        public final SortedSet<K> headSet(K toElement) {
            SortedKeySet sortedKeySet = this;
            return new SortedKeySet(this.this$0, ((SortedMap)super.map()).headMap(toElement));
        }

        public final K last() {
            SortedKeySet sortedKeySet = this;
            return ((SortedMap)super.map()).lastKey();
        }

        public final SortedSet<K> subSet(K fromElement, K toElement) {
            SortedKeySet sortedKeySet = this;
            return new SortedKeySet(this.this$0, ((SortedMap)super.map()).subMap(fromElement, toElement));
        }

        public final SortedSet<K> tailSet(K fromElement) {
            SortedKeySet sortedKeySet = this;
            return new SortedKeySet(this.this$0, ((SortedMap)super.map()).tailMap(fromElement));
        }
    }

    class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        KeySet(Map<K, Collection<V>> subMap) {
            super(subMap);
        }

        @Override
        public Iterator<K> iterator() {
            Iterator entryIterator = this.map().entrySet().iterator();
            return new Iterator<K>(this, entryIterator){
                private Map.Entry<K, Collection<V>> entry;
                private /* synthetic */ Iterator val$entryIterator;
                private /* synthetic */ KeySet this$1;
                {
                    this.this$1 = keySet;
                    this.val$entryIterator = iterator;
                }

                @Override
                public final boolean hasNext() {
                    return this.val$entryIterator.hasNext();
                }

                @Override
                public final K next() {
                    this.entry = (Map.Entry)this.val$entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public final void remove() {
                    Ascii.checkRemove(this.entry != null);
                    Collection collection = this.entry.getValue();
                    this.val$entryIterator.remove();
                    this.this$1.AbstractMapBasedMultimap.this.totalSize -= collection.size();
                    collection.clear();
                }
            };
        }

        @Override
        public boolean remove(Object key) {
            int count = 0;
            Collection collection = (Collection)this.map().remove(key);
            if (collection != null) {
                count = collection.size();
                collection.clear();
                AbstractMapBasedMultimap.this.totalSize -= count;
            }
            return count > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.map().keySet().containsAll(c);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || this.map().keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedList, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedList - discarding signature.
     */
    final class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(@Nullable K key, List<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            super((AbstractMapBasedMultimap)var1_1, key, delegate, (WrappedCollection)ancestor);
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    static class WrappedList
    extends WrappedCollection
    implements List {
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        WrappedList(@Nullable K key, List<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            this.this$0 = var1_1;
            super((AbstractMapBasedMultimap)var1_1, key, delegate, (WrappedCollection)ancestor);
        }

        final List<V> getListDelegate() {
            WrappedList wrappedList = this;
            return (List)wrappedList.delegate;
        }

        public boolean addAll(int index, Collection<? extends V> c) {
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c);
            if (changed) {
                WrappedList wrappedList = this;
                int newSize = wrappedList.delegate.size();
                this.this$0.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        public V get(int index) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(index);
        }

        public V set(int index, V element) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(index, element);
        }

        public void add(int index, V element) {
            this.refreshIfEmpty();
            WrappedList wrappedList = this;
            boolean wasEmpty = wrappedList.delegate.isEmpty();
            this.getListDelegate().add(index, element);
            this.this$0.totalSize++;
            if (wasEmpty) {
                this.addToMap();
            }
        }

        public V remove(int index) {
            this.refreshIfEmpty();
            Object value = this.getListDelegate().remove(index);
            this.this$0.totalSize--;
            this.removeIfEmpty();
            return value;
        }

        @Override
        public int indexOf(Object o) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(o);
        }

        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator(this);
        }

        public ListIterator<V> listIterator(int index) {
            this.refreshIfEmpty();
            return new WrappedListIterator(this, index);
        }

        public List<V> subList(int fromIndex, int toIndex) {
            WrappedList wrappedList;
            this.refreshIfEmpty();
            WrappedList wrappedList2 = this;
            Object k = wrappedList2.key;
            List list = this.getListDelegate().subList(fromIndex, toIndex);
            wrappedList2 = this;
            if (wrappedList2.ancestor == null) {
                wrappedList = this;
            } else {
                wrappedList2 = this;
                wrappedList = wrappedList2.ancestor;
            }
            return this.this$0.wrapList(k, list, wrappedList);
        }

        /*
         * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection.com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        final class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            private /* synthetic */ WrappedList this$1;

            WrappedListIterator(WrappedList wrappedList) {
                this.this$1 = wrappedList;
                super(wrappedList);
            }

            public WrappedListIterator(WrappedList wrappedList, int index) {
                this.this$1 = wrappedList;
                super(wrappedList, wrappedList.getListDelegate().listIterator(index));
            }

            private ListIterator<V> getDelegateListIterator() {
                WrappedListIterator wrappedListIterator = this;
                wrappedListIterator.validateIterator();
                return (ListIterator)wrappedListIterator.delegateIterator;
            }

            @Override
            public final boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public final V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public final int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public final int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public final void set(V value) {
                this.getDelegateListIterator().set(value);
            }

            public final void add(V value) {
                boolean wasEmpty = this.this$1.isEmpty();
                this.getDelegateListIterator().add(value);
                this.this$1.this$0.totalSize++;
                if (wasEmpty) {
                    this.this$1.addToMap();
                }
            }
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    final class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        WrappedSortedSet(@Nullable K key, SortedSet<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            this.this$0 = var1_1;
            super((AbstractMapBasedMultimap)var1_1, key, delegate, (WrappedCollection)ancestor);
        }

        private SortedSet<V> getSortedSetDelegate() {
            WrappedSortedSet wrappedSortedSet = this;
            return (SortedSet)wrappedSortedSet.delegate;
        }

        public final Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        public final V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        public final V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        public final SortedSet<V> headSet(V toElement) {
            WrappedSortedSet wrappedSortedSet;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet sortedSet = this.getSortedSetDelegate().headSet(toElement);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }

        public final SortedSet<V> subSet(V fromElement, V toElement) {
            WrappedSortedSet wrappedSortedSet;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet sortedSet = this.getSortedSetDelegate().subSet(fromElement, toElement);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }

        public final SortedSet<V> tailSet(V fromElement) {
            WrappedSortedSet wrappedSortedSet;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet sortedSet = this.getSortedSetDelegate().tailSet(fromElement);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMapBasedMultimap$com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection, not com.squareup.haha.guava.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    final class WrappedSet
    extends WrappedCollection
    implements Set {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        WrappedSet(AbstractMapBasedMultimap abstractMapBasedMultimap, @Nullable K key, Set<V> delegate) {
            this.this$0 = abstractMapBasedMultimap;
            super(abstractMapBasedMultimap, key, delegate, null);
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = Ascii.removeAllImpl((Set)this.delegate, c);
            if (changed) {
                int newSize = this.delegate.size();
                this.this$0.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }
    }

    static class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final AbstractMapBasedMultimap.WrappedCollection ancestor;
        private Collection<V> ancestorDelegate;
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        WrappedCollection(@Nullable K key, Collection<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            Collection collection;
            this.this$0 = var1_1;
            this.key = key;
            this.delegate = delegate;
            this.ancestor = ancestor;
            if (ancestor == null) {
                collection = null;
            } else {
                AbstractMapBasedMultimap.WrappedCollection wrappedCollection = ancestor;
                collection = wrappedCollection.delegate;
            }
            this.ancestorDelegate = collection;
        }

        final void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                AbstractMapBasedMultimap.WrappedCollection wrappedCollection = this.ancestor;
                if (wrappedCollection.delegate != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)this.this$0.map.get(this.key)) != null) {
                this.delegate = newDelegate;
            }
        }

        final void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
                return;
            }
            if (this.delegate.isEmpty()) {
                this.this$0.map.remove(this.key);
            }
        }

        final void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
                return;
            }
            this.this$0.map.put(this.key, this.delegate);
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator(this);
        }

        @Override
        public boolean add(V value) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed) {
                this.this$0.totalSize++;
                if (wasEmpty) {
                    this.addToMap();
                }
            }
            return changed;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                int newSize = this.delegate.size();
                this.this$0.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        @Override
        public boolean contains(Object o) {
            this.refreshIfEmpty();
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(c);
        }

        @Override
        public void clear() {
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            this.this$0.totalSize -= oldSize;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object o) {
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                this.this$0.totalSize--;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c);
            if (changed) {
                int newSize = this.delegate.size();
                this.this$0.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Ascii.checkNotNull(c);
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                int newSize = this.delegate.size();
                this.this$0.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            private Collection<V> originalDelegate;
            private /* synthetic */ WrappedCollection this$1;

            WrappedIterator(WrappedCollection wrappedCollection) {
                this.this$1 = wrappedCollection;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.access$100(wrappedCollection.this$0, wrappedCollection.delegate);
            }

            WrappedIterator(WrappedCollection wrappedCollection, Iterator<V> delegateIterator) {
                this.this$1 = wrappedCollection;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = delegateIterator;
            }

            final void validateIterator() {
                this.this$1.refreshIfEmpty();
                if (this.this$1.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                this.this$1.this$0.totalSize--;
                this.this$1.removeIfEmpty();
            }
        }
    }
}

