/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Quick Templates 2 module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qquickradiodelegate_p.h"
#include "qquickabstractbutton_p_p.h"
#include "qquickitemdelegate_p_p.h"

#include <QtGui/qpa/qplatformtheme.h>

QT_BEGIN_NAMESPACE

/*!
    \qmltype RadioDelegate
    \inherits ItemDelegate
//!     \instantiates QQuickRadioDelegate
    \inqmlmodule QtQuick.Controls
    \since 5.7
    \ingroup qtquickcontrols2-delegates
    \brief Exclusive item delegate with a radio indicator that can be toggled on or off.

    \image qtquickcontrols2-radiodelegate.gif

    RadioDelegate presents an item delegate that can be toggled on (checked) or
    off (unchecked). Radio delegates are typically used to select one option
    from a set of options.

    RadioDelegate inherits its API from \l ItemDelegate, which is inherited
    from AbstractButton. For instance, you can set \l {AbstractButton::text}{text},
    and react to \l {AbstractButton::clicked}{clicks} using the AbstractButton
    API. The state of the radio delegate can be set with the
    \l {AbstractButton::}{checked} property.

    Radio delegates are \l {AbstractButton::autoExclusive}{auto-exclusive}
    by default. Only one delegate can be checked at any time amongst radio
    delegates that belong to the same parent item; checking another delegate
    automatically unchecks the previously checked one. For radio delegates
    that do not share a common parent, ButtonGroup can be used to manage
    exclusivity.

    \l RadioButton is similar to RadioDelegate, except that it is typically
    not used in views, but rather when there are only a few options, and often
    with the requirement that each button is uniquely identifiable.

    \code
    ButtonGroup {
        id: buttonGroup
    }

    ListView {
        model: ["Option 1", "Option 2", "Option 3"]
        delegate: RadioDelegate {
            text: modelData
            checked: index == 0
            ButtonGroup.group: buttonGroup
        }
    }
    \endcode

    \sa {Customizing RadioDelegate}, {Delegate Controls}, RadioButton
*/

class Q_QUICKTEMPLATES2_PRIVATE_EXPORT QQuickRadioDelegatePrivate : public QQuickItemDelegatePrivate
{
    Q_DECLARE_PUBLIC(QQuickRadioDelegate)

public:
    QPalette defaultPalette() const override { return QQuickTheme::palette(QQuickTheme::ListView); }
};

QQuickRadioDelegate::QQuickRadioDelegate(QQuickItem *parent)
    : QQuickItemDelegate(*(new QQuickRadioDelegatePrivate), parent)
{
    setCheckable(true);
    setAutoExclusive(true);
}

QFont QQuickRadioDelegate::defaultFont() const
{
    return QQuickTheme::font(QQuickTheme::ListView);
}

#if QT_CONFIG(accessibility)
QAccessible::Role QQuickRadioDelegate::accessibleRole() const
{
    return QAccessible::RadioButton;
}
#endif

QT_END_NAMESPACE

#include "moc_qquickradiodelegate_p.cpp"
