// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_HARDWARE_CAPABILITIES_H_
#define UI_OZONE_PUBLIC_HARDWARE_CAPABILITIES_H_

#include "base/callback.h"

namespace ui {

struct HardwareCapabilities {
  // Number of planes available to the current CRTC(s).
  // This is specifically the count of non-CURSOR planes, because some boards
  // may have extra PRIMARY planes that could be used for overlays.
  int num_overlay_capable_planes = 0;
};
using HardwareCapabilitiesCallback =
    base::RepeatingCallback<void(HardwareCapabilities)>;

}  // namespace ui

#endif  // UI_OZONE_PUBLIC_HARDWARE_CAPABILITIES_H_
