#!/usr/bin/env python
# Copyright 2014 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import unittest

import hid_descriptors
import keyboard_gadget
import mouse_gadget


class HidTest(unittest.TestCase):

  def test_keyboard_example(self):
    expected = ''.join(chr(x) for x in [
        0x05, 0x01, 0x09, 0x06, 0xA1, 0x01, 0x05, 0x07, 0x19, 0xE0, 0x29,
        0xE7, 0x15, 0x00, 0x25, 0x01, 0x75, 0x01, 0x95, 0x08, 0x81, 0x02,
        0x95, 0x01, 0x75, 0x08, 0x81, 0x01, 0x95, 0x05, 0x75, 0x01, 0x05,
        0x08, 0x19, 0x01, 0x29, 0x05, 0x91, 0x02, 0x95, 0x01, 0x75, 0x03,
        0x91, 0x01, 0x95, 0x06, 0x75, 0x08, 0x15, 0x00, 0x25, 0x65, 0x05,
        0x07, 0x19, 0x00, 0x29, 0x65, 0x81, 0x00, 0xC0
    ])
    self.assertEquals(keyboard_gadget.KeyboardFeature.REPORT_DESC, expected)

  def test_mouse_example(self):
    expected = ''.join(chr(x) for x in [
        0x05, 0x01, 0x09, 0x02, 0xA1, 0x01, 0x09, 0x01, 0xA1, 0x00, 0x05, 0x09,
        0x19, 0x01, 0x29, 0x03, 0x15, 0x00, 0x25, 0x01, 0x95, 0x03, 0x75, 0x01,
        0x81, 0x02, 0x95, 0x01, 0x75, 0x05, 0x81, 0x01, 0x05, 0x01, 0x09, 0x30,
        0x09, 0x31, 0x15, 0x81, 0x25, 0x7F, 0x75, 0x08, 0x95, 0x02, 0x81, 0x06,
        0xC0, 0xC0
    ])
    self.assertEquals(mouse_gadget.MouseFeature.REPORT_DESC, expected)

  def test_tag(self):
    self.assertEquals(hid_descriptors.Push(), '\xa4')

  def test_2byte_tag(self):
    self.assertEquals(hid_descriptors.LogicalMaximum(0xFF00), '\x26\x00\xFF')

  def test_4byte_tag(self):
    self.assertEquals(hid_descriptors.LogicalMaximum(0xFF884400),
                      '\x27\x00\x44\x88\xFF')

  def test_long_tag(self):
    with self.assertRaises(NotImplementedError):
      hid_descriptors.LogicalMaximum(0xFFFFFFFFFFFFFFFF)

if __name__ == '__main__':
  unittest.main()
