/****************************************************************************
**
** Copyright (C) 2014 Klaralvdalens Datakonsult AB (KDAB).
** Copyright (C) 2021 The Qt Company Ltd and/or its subsidiary(-ies).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QT3DRENDER_QRENDERPASS_P_H
#define QT3DRENDER_QRENDERPASS_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/qnode_p.h>
#include <Qt3DRender/qrenderpass.h>

QT_BEGIN_NAMESPACE

namespace Qt3DRender {

class QParameter;
class QRenderState;
class QFilterKey;

class QRenderPassPrivate : public Qt3DCore::QNodePrivate
{
public:
    QRenderPassPrivate();

    Q_DECLARE_PUBLIC(QRenderPass)

    QVector<QFilterKey *> m_filterKeyList;
    QVector<QRenderState *> m_renderStates;
    QVector<QParameter *> m_parameters;
    QShaderProgram *m_shader;
};

struct QRenderPassData
{
    Qt3DCore::QNodeIdVector filterKeyIds;
    Qt3DCore::QNodeIdVector parameterIds;
    Qt3DCore::QNodeIdVector renderStateIds;
    Qt3DCore::QNodeId shaderId;
};

} // namespace Qt3DRender

QT_END_NAMESPACE

#endif // QRENDERPASS_P_H
