/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtLocation module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QPLACEATTRIBUTE_P_H
#define QPLACEATTRIBUTE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QSharedData>
#include <QString>
#include <QVariant>

QT_BEGIN_NAMESPACE

class QPlaceAttributePrivate : public QSharedData
{
public:
    QPlaceAttributePrivate(){}
    QPlaceAttributePrivate(const QPlaceAttributePrivate &other);
    virtual ~QPlaceAttributePrivate(){}


    virtual bool operator== (const QPlaceAttributePrivate &other) const;
    virtual QPlaceAttributePrivate *clone() const { return new QPlaceAttributePrivate(*this); }

    bool isEmpty() const;

    QString label;
    QString text;
};

template<> QPlaceAttributePrivate *QSharedDataPointer<QPlaceAttributePrivate>::clone();

QT_END_NAMESPACE

#endif

