/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQuick module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef DESIGNERSUPPORTPROPERTYCHANGES_H
#define DESIGNERSUPPORTPROPERTYCHANGES_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qquickdesignersupport_p.h"

#include <QVariant>

QT_BEGIN_NAMESPACE

class Q_QUICK_EXPORT QQuickDesignerSupportPropertyChanges
{
public:
    static void detachFromState(QObject *propertyChanges);
    static void attachToState(QObject *propertyChanges);
    static QObject *targetObject(QObject *propertyChanges);
    static void removeProperty(QObject *propertyChanges, const QQuickDesignerSupport::PropertyName &propertyName);
    static QVariant getProperty(QObject *propertyChanges, const QQuickDesignerSupport::PropertyName &propertyName);
    static void changeValue(QObject *propertyChanges, const QQuickDesignerSupport::PropertyName &propertyName, const QVariant &value);
    static void changeExpression(QObject *propertyChanges, const QQuickDesignerSupport::PropertyName &propertyName, const QString &expression);
    static QObject *stateObject(QObject *propertyChanges);
    static bool isNormalProperty(const QQuickDesignerSupport::PropertyName &propertyName);
};

QT_END_NAMESPACE

#endif // DESIGNERSUPPORTPROPERTYCHANGES_H
