/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB)
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQuick module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QSGNODE_P_H
#define QSGNODE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <qglobal.h>

#include "qsgnode.h"

QT_BEGIN_NAMESPACE

class QSGNodePrivate
{
public:
    QSGNodePrivate() {}
    virtual ~QSGNodePrivate() {}

#ifdef QSG_RUNTIME_DESCRIPTION
    static void setDescription(QSGNode *node, const QString &description) {
        node->d_ptr->descr= description;
    }
    static QString description(const QSGNode *node) {
        return node->d_ptr->descr;
    }
    QString descr;
#endif
};


class QSGBasicGeometryNodePrivate : public QSGNodePrivate
{
public:
    QSGBasicGeometryNodePrivate() {}
};


class QSGGeometryNodePrivate: public QSGBasicGeometryNodePrivate
{
public:
    QSGGeometryNodePrivate() {}
};

QT_END_NAMESPACE

#endif // QSGNODE_P_H
