/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtXmlPatterns module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QABSTRACTURIRESOLVER_H
#define QABSTRACTURIRESOLVER_H

#include <QtCore/QObject>
#include <QtXmlPatterns/qtxmlpatternsglobal.h>

QT_BEGIN_NAMESPACE


class QUrl;

class Q_XMLPATTERNS_EXPORT QAbstractUriResolver : public QObject
{
    Q_OBJECT
public:
    QAbstractUriResolver(QObject *parent = nullptr);
    virtual ~QAbstractUriResolver();

    virtual QUrl resolve(const QUrl &relative,
                         const QUrl &baseURI) const = 0;

private:
    Q_DISABLE_COPY(QAbstractUriResolver)
};

QT_END_NAMESPACE

#endif
