/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick Designer Components.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.0
import HelperWidgets 2.0
import QtQuick.Layouts 1.0

Column {
    anchors.left: parent.left
    anchors.right: parent.right

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Level Adjust")

        SectionLayout {
            rows: 2
            Label {
                text: qsTr("Gamma")
                toolTip: qsTr("The change factor for how the luminance of each pixel is altered.")
            }
            SecondColumnLayout {
                ColumnLayout {
                    RowLayout {
                        Label {
                            text: qsTr("R")
                        }
                        SpinBox {
                            minimumValue: 0
                            maximumValue: 100
                            decimals: 2
                            stepSize: 0.1
                            backendValue: backendValues.gammaR
                            Layout.fillWidth: true
                            sliderIndicatorVisible: true
                        }
                    }
                    RowLayout {
                        Label {
                            text: qsTr("G")
                        }
                        SpinBox {
                            minimumValue: 0
                            maximumValue: 100
                            decimals: 2
                            stepSize: 0.1
                            backendValue: backendValues.gammaG
                            Layout.fillWidth: true
                            sliderIndicatorVisible: true
                        }
                    }
                    RowLayout {
                        Label {
                            text: qsTr("B")
                        }
                        SpinBox {
                            minimumValue: 0
                            maximumValue: 100
                            decimals: 2
                            stepSize: 0.1
                            backendValue: backendValues.gammaB
                            Layout.fillWidth: true
                            sliderIndicatorVisible: true
                        }
                    }
                }
            }
        }
    }

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Minimum Input")

        ColorEditor {
            caption: qsTr("Minimum Input")
            backendValue: backendValues.minimumInput
            supportGradient: false
        }
    }

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Minimum Output")

        ColorEditor {
            caption: qsTr("Minimum Output")
            backendValue: backendValues.minimumOutput
            supportGradient: false
        }
    }

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Maximum Input")

        ColorEditor {
            caption: qsTr("Maximum Input")
            backendValue: backendValues.maximumInput
            supportGradient: false
        }
    }

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Maximum Output")

        ColorEditor {
            caption: qsTr("Maximum Output")
            backendValue: backendValues.maximumOutput
            supportGradient: false
        }
    }

    Section {
        anchors.left: parent.left
        anchors.right: parent.right
        caption: qsTr("Caching")

        SectionLayout {
            rows: 2
            Label {
                text: qsTr("Cached")
                toolTip: qsTr("Caches the effect output pixels to improve the rendering "
                              + "performance.")
            }
            SecondColumnLayout {
                CheckBox {
                    Layout.fillWidth: true
                    backendValue: backendValues.cached
                    text: backendValues.cached.valueToString
                }
                ExpandingSpacer {
                }
            }
        }
    }
}
