/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtSql module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QSQLDRIVER_P_H
#define QSQLDRIVER_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API. It exists for the convenience
// of the QtSQL module. This header file may change from version to version
// without notice, or even be removed.
//
// We mean it.
//

#include <QtSql/private/qtsqlglobal_p.h>
#include "private/qobject_p.h"
#include "qsqldriver.h"
#include "qsqlerror.h"

QT_BEGIN_NAMESPACE

class QSqlDriverPrivate : public QObjectPrivate
{
    Q_DECLARE_PUBLIC(QSqlDriver)

public:
    QSqlDriverPrivate(QSqlDriver::DbmsType type = QSqlDriver::UnknownDbms)
      : QObjectPrivate(),
        dbmsType(type)
    { }

    QSqlError error;
    QSql::NumericalPrecisionPolicy precisionPolicy = QSql::LowPrecisionDouble;
    QSqlDriver::DbmsType dbmsType;
    bool isOpen = false;
    bool isOpenError = false;
};

QT_END_NAMESPACE

#endif // QSQLDRIVER_P_H
