/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtXmlPatterns module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_ReceiverDynamicContext_H
#define Patternist_ReceiverDynamicContext_H

#include <private/qdelegatingdynamiccontext_p.h>

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short A DynamicContext that has a specialized QAbstractXmlReceiver.
     *
     * @author Frans Englich <frans.englich@nokia.com>
     */
    class ReceiverDynamicContext : public DelegatingDynamicContext
    {
    public:
        /**
         * Construct a ReceiverDynamicContext and passes @p prevContext to its super class. This
         * constructor is typically used when the super class is DelegatingDynamicContext.
         */
        ReceiverDynamicContext(const DynamicContext::Ptr &prevContext,
                               QAbstractXmlReceiver *const receiver);

        virtual QAbstractXmlReceiver *outputReceiver() const;

    private:
        QAbstractXmlReceiver *const m_receiver;
    };
}

QT_END_NAMESPACE

#endif
