/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import org.qtproject.qt.android.HideKeyboardRunnable;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtExtractedText;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtNativeInputConnection;

public class QtInputConnection
extends BaseInputConnection {
    private static final int ID_SELECT_ALL = 16908319;
    private static final int ID_CUT = 0x1020020;
    private static final int ID_COPY = 0x1020021;
    private static final int ID_PASTE = 0x1020022;
    private static final int ID_COPY_URL = 16908323;
    private static final int ID_SWITCH_INPUT_METHOD = 16908324;
    private static final int ID_ADD_TO_DICTIONARY = 16908330;
    private QtEditText m_view = null;

    private void setClosing(boolean bl) {
        if (bl) {
            this.m_view.postDelayed(new HideKeyboardRunnable(), 100L);
        } else {
            QtNative.activityDelegate().setKeyboardVisibility(true, System.nanoTime());
        }
    }

    public QtInputConnection(QtEditText qtEditText) {
        super((View)qtEditText, true);
        this.m_view = qtEditText;
    }

    public boolean beginBatchEdit() {
        this.setClosing(false);
        return QtNativeInputConnection.beginBatchEdit();
    }

    public boolean endBatchEdit() {
        this.setClosing(false);
        return QtNativeInputConnection.endBatchEdit();
    }

    public boolean commitCompletion(CompletionInfo completionInfo) {
        this.setClosing(false);
        return QtNativeInputConnection.commitCompletion(completionInfo.getText().toString(), completionInfo.getPosition());
    }

    public boolean commitText(CharSequence charSequence, int n) {
        this.setClosing(false);
        return QtNativeInputConnection.commitText(charSequence.toString(), n);
    }

    public boolean deleteSurroundingText(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.deleteSurroundingText(n, n2);
    }

    public boolean finishComposingText() {
        this.setClosing(true);
        return QtNativeInputConnection.finishComposingText();
    }

    public int getCursorCapsMode(int n) {
        return QtNativeInputConnection.getCursorCapsMode(n);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        QtExtractedText qtExtractedText = QtNativeInputConnection.getExtractedText(extractedTextRequest.hintMaxChars, extractedTextRequest.hintMaxLines, n);
        if (qtExtractedText == null) {
            return null;
        }
        ExtractedText extractedText = new ExtractedText();
        extractedText.partialEndOffset = qtExtractedText.partialEndOffset;
        extractedText.partialStartOffset = qtExtractedText.partialStartOffset;
        extractedText.selectionEnd = qtExtractedText.selectionEnd;
        extractedText.selectionStart = qtExtractedText.selectionStart;
        extractedText.startOffset = qtExtractedText.startOffset;
        extractedText.text = qtExtractedText.text;
        return extractedText;
    }

    public CharSequence getSelectedText(int n) {
        return QtNativeInputConnection.getSelectedText(n);
    }

    public CharSequence getTextAfterCursor(int n, int n2) {
        return QtNativeInputConnection.getTextAfterCursor(n, n2);
    }

    public CharSequence getTextBeforeCursor(int n, int n2) {
        return QtNativeInputConnection.getTextBeforeCursor(n, n2);
    }

    public boolean performContextMenuAction(int n) {
        switch (n) {
            case 16908319: {
                return QtNativeInputConnection.selectAll();
            }
            case 0x1020021: {
                return QtNativeInputConnection.copy();
            }
            case 16908323: {
                return QtNativeInputConnection.copyURL();
            }
            case 0x1020020: {
                return QtNativeInputConnection.cut();
            }
            case 0x1020022: {
                return QtNativeInputConnection.paste();
            }
            case 16908324: {
                InputMethodManager inputMethodManager = (InputMethodManager)this.m_view.getContext().getSystemService("input_method");
                if (inputMethodManager != null) {
                    inputMethodManager.showInputMethodPicker();
                }
                return true;
            }
            case 16908330: {
                return true;
            }
        }
        return super.performContextMenuAction(n);
    }

    public boolean setComposingText(CharSequence charSequence, int n) {
        this.setClosing(false);
        return QtNativeInputConnection.setComposingText(charSequence.toString(), n);
    }

    public boolean setComposingRegion(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.setComposingRegion(n, n2);
    }

    public boolean setSelection(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.setSelection(n, n2);
    }
}

