/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MediaRecorder;
import android.os.Build;
import java.util.ArrayList;

public class QtAudioDeviceManager {
    private static AudioManager m_audioManager = null;
    private static final AudioDevicesReceiver m_audioDevicesReceiver = new AudioDevicesReceiver();

    public static native void onAudioInputDevicesUpdated();

    public static native void onAudioOutputDevicesUpdated();

    private static void registerAudioHeadsetStateReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.action.HDMI_AUDIO_PLUG");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED");
        context.registerReceiver((BroadcastReceiver)m_audioDevicesReceiver, intentFilter);
    }

    public static void setContext(Context context) {
        m_audioManager = (AudioManager)context.getSystemService("audio");
        QtAudioDeviceManager.registerAudioHeadsetStateReceiver(context);
    }

    private static String[] getAudioOutputDevices() {
        return QtAudioDeviceManager.getAudioDevices(2);
    }

    private static String[] getAudioInputDevices() {
        return QtAudioDeviceManager.getAudioDevices(1);
    }

    private static boolean setAudioInput(MediaRecorder mediaRecorder, int n) {
        if (Build.VERSION.SDK_INT >= 28) {
            AudioDeviceInfo[] audioDeviceInfoArray;
            for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(1)) {
                if (audioDeviceInfo.getId() != n) continue;
                return mediaRecorder.setPreferredDevice(audioDeviceInfo);
            }
        }
        return false;
    }

    private static String audioDeviceTypeToString(int n) {
        switch (n) {
            case 19: {
                return "AUX Line";
            }
            case 7: 
            case 8: {
                return "Bluetooth";
            }
            case 1: {
                return "Built in earpiece";
            }
            case 15: {
                return "Built in microphone";
            }
            case 2: {
                return "Built in speaker";
            }
            case 13: {
                return "Dock";
            }
            case 14: {
                return "FM";
            }
            case 16: {
                return "FM TUNER";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI ARC";
            }
            case 20: {
                return "IP";
            }
            case 5: {
                return "Line analog";
            }
            case 6: {
                return "Line digital";
            }
            case 17: {
                return "TV tuner";
            }
            case 12: {
                return "USB accessory";
            }
            case 4: {
                return "Wired headphones";
            }
            case 3: {
                return "Wired headset";
            }
        }
        return "Unknown-Type";
    }

    private static String[] getAudioDevices(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            boolean bl = false;
            boolean bl2 = false;
            for (AudioDeviceInfo audioDeviceInfo : m_audioManager.getDevices(n)) {
                String string = QtAudioDeviceManager.audioDeviceTypeToString(audioDeviceInfo.getType());
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(0))) continue;
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(15))) {
                    if (bl) continue;
                    bl = true;
                } else if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(8))) {
                    if (bl2) continue;
                    bl2 = true;
                }
                arrayList.add(audioDeviceInfo.getId() + ":" + string + " (" + audioDeviceInfo.getProductName().toString() + ")");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static boolean setAudioOutput(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(2)) {
            if (audioDeviceInfo.getId() != n) continue;
            switch (audioDeviceInfo.getType()) {
                case 7: 
                case 8: {
                    QtAudioDeviceManager.setAudioOutput(3, true, false);
                    return true;
                }
                case 2: {
                    QtAudioDeviceManager.setAudioOutput(0, false, true);
                    return true;
                }
                case 3: 
                case 4: {
                    QtAudioDeviceManager.setAudioOutput(3, false, false);
                    return true;
                }
                case 1: {
                    QtAudioDeviceManager.setAudioOutput(2, false, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static void setAudioOutput(int n, boolean bl, boolean bl2) {
        m_audioManager.setMode(n);
        if (bl) {
            m_audioManager.startBluetoothSco();
        } else {
            m_audioManager.stopBluetoothSco();
        }
        m_audioManager.setBluetoothScoOn(bl);
        m_audioManager.setSpeakerphoneOn(bl2);
    }

    private static class AudioDevicesReceiver
    extends BroadcastReceiver {
        private AudioDevicesReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            QtAudioDeviceManager.onAudioInputDevicesUpdated();
            QtAudioDeviceManager.onAudioOutputDevicesUpdated();
        }
    }
}

