/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.accessibility;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import org.qtproject.qt.android.QtActivityDelegate;
import org.qtproject.qt.android.accessibility.QtNativeAccessibility;

public class QtAccessibilityDelegate
extends View.AccessibilityDelegate {
    private static final String TAG = "Qt A11Y";
    public static final int INVALID_ID = 333;
    private static final String DEFAULT_CLASS_NAME = "$VirtualChild";
    private View m_view = null;
    private AccessibilityManager m_manager;
    private QtActivityDelegate m_activityDelegate;
    private Activity m_activity;
    private ViewGroup m_layout;
    private int m_focusedVirtualViewId = 333;
    private int m_hoveredVirtualViewId = 333;
    private final int[] m_globalOffset = new int[2];
    private AccessibilityNodeProvider m_nodeProvider = new AccessibilityNodeProvider(){

        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            if (n == -1) {
                return QtAccessibilityDelegate.this.getNodeForView();
            }
            return QtAccessibilityDelegate.this.getNodeForVirtualViewId(n);
        }

        public boolean performAction(int n, int n2, Bundle bundle) {
            boolean bl = false;
            switch (n2) {
                case 64: {
                    if (QtAccessibilityDelegate.this.m_focusedVirtualViewId == n) break;
                    QtAccessibilityDelegate.this.m_focusedVirtualViewId = n;
                    QtAccessibilityDelegate.this.m_view.invalidate();
                    QtAccessibilityDelegate.this.sendEventForVirtualViewId(n, 32768);
                    bl = true;
                    break;
                }
                case 128: {
                    if (QtAccessibilityDelegate.this.m_focusedVirtualViewId == n) {
                        QtAccessibilityDelegate.this.m_focusedVirtualViewId = 333;
                    }
                    QtAccessibilityDelegate.this.m_view.invalidate();
                    QtAccessibilityDelegate.this.sendEventForVirtualViewId(n, 65536);
                    bl = true;
                    break;
                }
                default: {
                    if (n != -1) break;
                    return QtAccessibilityDelegate.this.m_view.performAccessibilityAction(n2, bundle);
                }
            }
            return bl |= QtAccessibilityDelegate.this.performActionForVirtualViewId(n, n2, bundle);
        }
    };

    public QtAccessibilityDelegate(Activity activity, ViewGroup viewGroup, QtActivityDelegate qtActivityDelegate) {
        this.m_activity = activity;
        this.m_layout = viewGroup;
        this.m_activityDelegate = qtActivityDelegate;
        this.m_manager = (AccessibilityManager)this.m_activity.getSystemService("accessibility");
        if (this.m_manager != null) {
            AccessibilityManagerListener accessibilityManagerListener = new AccessibilityManagerListener();
            if (!this.m_manager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)accessibilityManagerListener)) {
                Log.w((String)"Qt A11y", (String)"Could not register a11y state change listener");
            }
            if (this.m_manager.isEnabled()) {
                accessibilityManagerListener.onAccessibilityStateChanged(true);
            }
        }
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
        return this.m_nodeProvider;
    }

    private boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (!this.m_manager.isTouchExplorationEnabled()) {
            return false;
        }
        int n = QtNativeAccessibility.hitTest(motionEvent.getX(), motionEvent.getY());
        if (n == 333) {
            n = -1;
        }
        switch (motionEvent.getAction()) {
            case 7: 
            case 9: {
                this.setHoveredVirtualViewId(n);
                break;
            }
            case 10: {
                this.setHoveredVirtualViewId(n);
            }
        }
        return true;
    }

    public void notifyLocationChange() {
        this.invalidateVirtualViewId(this.m_focusedVirtualViewId);
    }

    public void notifyObjectHide(int n) {
        this.invalidateVirtualViewId(n);
    }

    public void notifyObjectFocus(int n) {
        if (this.m_view == null) {
            return;
        }
        this.m_view.invalidate();
        this.sendEventForVirtualViewId(n, 32768);
    }

    public boolean sendEventForVirtualViewId(int n, int n2) {
        if (n == 333 || !this.m_manager.isEnabled()) {
            Log.w((String)TAG, (String)"sendEventForVirtualViewId for invalid view");
            return false;
        }
        ViewGroup viewGroup = (ViewGroup)this.m_view.getParent();
        if (viewGroup == null) {
            Log.w((String)TAG, (String)"Could not send AccessibilityEvent because group was null. This should really not happen.");
            return false;
        }
        AccessibilityEvent accessibilityEvent = this.getEventForVirtualViewId(n, n2);
        return viewGroup.requestSendAccessibilityEvent(this.m_view, accessibilityEvent);
    }

    public void invalidateVirtualViewId(int n) {
        if (n != 333) {
            this.sendEventForVirtualViewId(n, 2048);
        }
    }

    private void setHoveredVirtualViewId(int n) {
        if (this.m_hoveredVirtualViewId == n) {
            return;
        }
        int n2 = this.m_hoveredVirtualViewId;
        this.m_hoveredVirtualViewId = n;
        this.sendEventForVirtualViewId(n, 128);
        this.sendEventForVirtualViewId(n2, 256);
    }

    private AccessibilityEvent getEventForVirtualViewId(int n, int n2) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n2);
        accessibilityEvent.setEnabled(true);
        accessibilityEvent.setClassName((CharSequence)(this.m_view.getClass().getName() + DEFAULT_CLASS_NAME));
        accessibilityEvent.setContentDescription((CharSequence)QtNativeAccessibility.descriptionForAccessibleObject(n));
        if (accessibilityEvent.getText().isEmpty() && TextUtils.isEmpty((CharSequence)accessibilityEvent.getContentDescription())) {
            Log.w((String)TAG, (String)"AccessibilityEvent with empty description");
        }
        accessibilityEvent.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
        accessibilityEvent.setSource(this.m_view, n);
        return accessibilityEvent;
    }

    private void dumpNodes(int n) {
        Log.i((String)TAG, (String)("A11Y hierarchy: " + n + " parent: " + QtNativeAccessibility.parentId(n)));
        Log.i((String)TAG, (String)("    desc: " + QtNativeAccessibility.descriptionForAccessibleObject(n) + " rect: " + QtNativeAccessibility.screenRect(n)));
        Log.i((String)TAG, (String)(" NODE: " + this.getNodeForVirtualViewId(n)));
        int[] nArray = QtNativeAccessibility.childIdListForAccessibleObject(n);
        for (int i = 0; i < nArray.length; ++i) {
            Log.i((String)TAG, (String)(n + " has child: " + nArray[i]));
            this.dumpNodes(nArray[i]);
        }
    }

    private AccessibilityNodeInfo getNodeForView() {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)this.m_view);
        AccessibilityNodeInfo accessibilityNodeInfo2 = AccessibilityNodeInfo.obtain((View)this.m_view);
        this.m_view.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo2);
        this.m_view.getLocationOnScreen(this.m_globalOffset);
        int n = this.m_globalOffset[0];
        int n2 = this.m_globalOffset[1];
        Rect rect = new Rect();
        accessibilityNodeInfo2.getBoundsInParent(rect);
        accessibilityNodeInfo.setBoundsInParent(rect);
        Rect rect2 = new Rect();
        accessibilityNodeInfo2.getBoundsInScreen(rect2);
        rect2.offset(n, n2);
        accessibilityNodeInfo.setBoundsInScreen(rect2);
        ViewParent viewParent = this.m_view.getParent();
        if (viewParent instanceof View) {
            accessibilityNodeInfo.setParent((View)viewParent);
        }
        accessibilityNodeInfo.setVisibleToUser(accessibilityNodeInfo2.isVisibleToUser());
        accessibilityNodeInfo.setPackageName(accessibilityNodeInfo2.getPackageName());
        accessibilityNodeInfo.setClassName(accessibilityNodeInfo2.getClassName());
        int[] nArray = QtNativeAccessibility.childIdListForAccessibleObject(-1);
        for (int i = 0; i < nArray.length; ++i) {
            accessibilityNodeInfo.addChild(this.m_view, nArray[i]);
        }
        return accessibilityNodeInfo;
    }

    private AccessibilityNodeInfo getNodeForVirtualViewId(int n) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
        accessibilityNodeInfo.setClassName((CharSequence)(this.m_view.getClass().getName() + DEFAULT_CLASS_NAME));
        accessibilityNodeInfo.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
        if (!QtNativeAccessibility.populateNode(n, accessibilityNodeInfo)) {
            return accessibilityNodeInfo;
        }
        accessibilityNodeInfo.setSource(this.m_view, n);
        if (TextUtils.isEmpty((CharSequence)accessibilityNodeInfo.getText()) && TextUtils.isEmpty((CharSequence)accessibilityNodeInfo.getContentDescription())) {
            Log.w((String)TAG, (String)("AccessibilityNodeInfo with empty contentDescription: " + n));
        }
        int n2 = QtNativeAccessibility.parentId(n);
        accessibilityNodeInfo.setParent(this.m_view, n2);
        Rect rect = QtNativeAccessibility.screenRect(n);
        int n3 = this.m_globalOffset[0];
        int n4 = this.m_globalOffset[1];
        rect.offset(n3, n4);
        accessibilityNodeInfo.setBoundsInScreen(rect);
        Rect rect2 = rect;
        Rect rect3 = QtNativeAccessibility.screenRect(n2);
        rect2.offset(-rect3.left, -rect3.top);
        accessibilityNodeInfo.setBoundsInParent(rect2);
        if (this.m_focusedVirtualViewId == n) {
            accessibilityNodeInfo.setAccessibilityFocused(true);
            accessibilityNodeInfo.addAction(128);
        } else {
            accessibilityNodeInfo.setAccessibilityFocused(false);
            accessibilityNodeInfo.addAction(64);
        }
        return accessibilityNodeInfo;
    }

    protected boolean performActionForVirtualViewId(int n, int n2, Bundle bundle) {
        boolean bl = false;
        switch (n2) {
            case 16: {
                bl = QtNativeAccessibility.clickAction(n);
                if (!bl) break;
                this.sendEventForVirtualViewId(n, 1);
                break;
            }
            case 4096: {
                bl = QtNativeAccessibility.scrollForward(n);
                if (!bl) break;
                this.sendEventForVirtualViewId(n, 4096);
                break;
            }
            case 8192: {
                bl = QtNativeAccessibility.scrollBackward(n);
                if (!bl) break;
                this.sendEventForVirtualViewId(n, 4096);
            }
        }
        return bl;
    }

    private class AccessibilityManagerListener
    implements AccessibilityManager.AccessibilityStateChangeListener {
        private AccessibilityManagerListener() {
        }

        public void onAccessibilityStateChanged(boolean bl) {
            if (bl) {
                try {
                    View view = QtAccessibilityDelegate.this.m_view;
                    if (view == null) {
                        view = new View((Context)QtAccessibilityDelegate.this.m_activity);
                        view.setId(-1);
                    }
                    view.setAccessibilityDelegate((View.AccessibilityDelegate)QtAccessibilityDelegate.this);
                    if (QtAccessibilityDelegate.this.m_view == null) {
                        QtAccessibilityDelegate.this.m_layout.addView(view, QtAccessibilityDelegate.this.m_activityDelegate.getSurfaceCount(), new ViewGroup.LayoutParams(-1, -1));
                    }
                    QtAccessibilityDelegate.this.m_view = view;
                    QtAccessibilityDelegate.this.m_view.setOnHoverListener((View.OnHoverListener)new HoverEventListener());
                }
                catch (Exception exception) {
                    Log.w((String)"Qt A11y", (String)("Unknown exception: " + exception.toString()));
                }
            } else if (QtAccessibilityDelegate.this.m_view != null) {
                QtAccessibilityDelegate.this.m_layout.removeView(QtAccessibilityDelegate.this.m_view);
                QtAccessibilityDelegate.this.m_view = null;
            }
            QtNativeAccessibility.setActive(bl);
        }
    }

    private class HoverEventListener
    implements View.OnHoverListener {
        private HoverEventListener() {
        }

        public boolean onHover(View view, MotionEvent motionEvent) {
            return QtAccessibilityDelegate.this.dispatchHoverEvent(motionEvent);
        }
    }
}

