/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class QtBluetoothLE {
    private static final String TAG = "QtBluetoothGatt";
    private final BluetoothAdapter mBluetoothAdapter;
    private boolean mLeScanRunning = false;
    private BluetoothGatt mBluetoothGatt = null;
    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private Constructor mCharacteristicConstructor = null;
    private String mRemoteGattAddress;
    private final UUID clientCharacteristicUuid = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final int MAX_MTU = 512;
    private final int DEFAULT_MTU = 23;
    private int mSupportedMtu = -1;
    private int HANDLE_FOR_RESET = -1;
    private int HANDLE_FOR_MTU_EXCHANGE = -2;
    private AtomicInteger handleForTimeout = new AtomicInteger(this.HANDLE_FOR_RESET);
    private final int RUNNABLE_TIMEOUT = 3000;
    private final Handler timeoutHandler = new Handler(Looper.getMainLooper());
    private BluetoothLeScanner mBluetoothLeScanner = null;
    private BroadcastReceiver bondStateBroadcastReceiver = null;
    long qtObject = 0L;
    Context qtContext = null;
    private final ScanCallback leScanCallback21 = new ScanCallback(){

        public void onScanResult(int n, ScanResult scanResult) {
            super.onScanResult(n, scanResult);
            QtBluetoothLE.this.leScanResult(QtBluetoothLE.this.qtObject, scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
        }

        public void onBatchScanResults(List<ScanResult> list) {
            super.onBatchScanResults(list);
            for (ScanResult scanResult : list) {
                QtBluetoothLE.this.leScanResult(QtBluetoothLE.this.qtObject, scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
            }
        }

        public void onScanFailed(int n) {
            super.onScanFailed(n);
            Log.d((String)QtBluetoothLE.TAG, (String)("BTLE device scan failed with " + n));
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            int n3;
            if (QtBluetoothLE.this.qtObject == 0L) {
                return;
            }
            int n4 = 0;
            switch (n2) {
                case 0: {
                    if (QtBluetoothLE.this.bondStateBroadcastReceiver != null) {
                        QtBluetoothLE.this.qtContext.unregisterReceiver(QtBluetoothLE.this.bondStateBroadcastReceiver);
                        QtBluetoothLE.this.bondStateBroadcastReceiver = null;
                    }
                    n4 = 0;
                    QtBluetoothLE.this.resetData();
                    if (QtBluetoothLE.this.mBluetoothGatt != null) {
                        QtBluetoothLE.this.mBluetoothGatt.close();
                        if (QtBluetoothLE.this.mHandler != null) {
                            QtBluetoothLE.this.mHandler.getLooper().quitSafely();
                            QtBluetoothLE.this.mHandler = null;
                        }
                    }
                    QtBluetoothLE.this.mBluetoothGatt = null;
                    break;
                }
                case 2: {
                    if (QtBluetoothLE.this.bondStateBroadcastReceiver == null) {
                        QtBluetoothLE.this.bondStateBroadcastReceiver = new BondStateBroadcastReceiver();
                        QtBluetoothLE.this.qtContext.registerReceiver(QtBluetoothLE.this.bondStateBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
                    }
                    n4 = 2;
                }
            }
            switch (n) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 257: {
                    n3 = 1;
                    break;
                }
                case 8: {
                    Log.w((String)QtBluetoothLE.TAG, (String)"Connection Error: Try to delay connect() call after previous activity");
                    n3 = 5;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    Log.w((String)QtBluetoothLE.TAG, (String)"The remote host closed the connection");
                    n3 = 7;
                    break;
                }
                case 22: {
                    n3 = 8;
                    break;
                }
                default: {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Unhandled error code on connectionStateChanged: " + n + " " + n2));
                    n3 = n;
                }
            }
            QtBluetoothLE.this.leConnectionStateChange(QtBluetoothLE.this.qtObject, n3, n4);
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            switch (n) {
                case 0: {
                    n2 = 0;
                    List list = QtBluetoothLE.this.mBluetoothGatt.getServices();
                    for (BluetoothGattService bluetoothGattService : list) {
                        stringBuilder.append(bluetoothGattService.getUuid().toString()).append(" ");
                    }
                    break;
                }
                default: {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Unhandled error code on onServicesDiscovered: " + n));
                    n2 = n;
                }
            }
            QtBluetoothLE.this.leServicesDiscovered(QtBluetoothLE.this.qtObject, n2, stringBuilder.toString());
            QtBluetoothLE.this.scheduleMtuExchange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            Object object;
            boolean bl;
            int n2 = -1;
            2 var5_5 = this;
            synchronized (var5_5) {
                n2 = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic);
                if (n2 == -1 || n2 >= QtBluetoothLE.this.entries.size()) {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Cannot find characteristic read request for read notification - handle: " + n2 + " size: " + QtBluetoothLE.this.entries.size()));
                    LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
                    synchronized (linkedList) {
                        QtBluetoothLE.this.pendingJob = null;
                    }
                    QtBluetoothLE.this.performNextIO();
                    return;
                }
            }
            boolean bl2 = bl = !QtBluetoothLE.this.handleForTimeout.compareAndSet(QtBluetoothLE.this.modifiedReadWriteHandle(n2, IoJobType.Read), QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("Late char read reply after timeout was hit for handle " + n2));
                return;
            }
            GattEntry gattEntry = (GattEntry)QtBluetoothLE.this.entries.get(n2);
            boolean bl3 = !gattEntry.valueKnown;
            gattEntry.valueKnown = true;
            if (n == 0) {
                QtBluetoothLE.this.leCharacteristicRead(QtBluetoothLE.this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), n2 + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getValue());
            } else if (bl3) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onCharacteristicRead during discovery error: " + n));
                Log.d((String)QtBluetoothLE.TAG, (String)("Non-readable characteristic " + bluetoothGattCharacteristic.getUuid() + " for service " + bluetoothGattCharacteristic.getService().getUuid()));
                QtBluetoothLE.this.leCharacteristicRead(QtBluetoothLE.this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), n2 + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getValue());
            } else {
                QtBluetoothLE.this.leServiceError(QtBluetoothLE.this.qtObject, n2 + 1, 5);
            }
            if (bl3) {
                object = (GattEntry)QtBluetoothLE.this.entries.get(gattEntry.associatedServiceHandle);
                if (((GattEntry)object).endHandle == n2) {
                    QtBluetoothLE.this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
                }
            }
            object = QtBluetoothLE.this.readWriteQueue;
            synchronized (object) {
                QtBluetoothLE.this.pendingJob = null;
            }
            QtBluetoothLE.this.performNextIO();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            byte[] byArray;
            int n2;
            boolean bl;
            int n3;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onCharacteristicWrite: error " + n));
            }
            if ((n3 = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic)) == -1) {
                Log.w((String)QtBluetoothLE.TAG, (String)"onCharacteristicWrite: cannot find handle");
                return;
            }
            boolean bl2 = bl = !QtBluetoothLE.this.handleForTimeout.compareAndSet(QtBluetoothLE.this.modifiedReadWriteHandle(n3, IoJobType.Write), QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("Late char write reply after timeout was hit for handle " + n3));
                return;
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
            synchronized (linkedList) {
                byArray = ((QtBluetoothLE)QtBluetoothLE.this).pendingJob.newValue;
                QtBluetoothLE.this.pendingJob = null;
            }
            QtBluetoothLE.this.leCharacteristicWritten(QtBluetoothLE.this.qtObject, n3 + 1, byArray, n2);
            QtBluetoothLE.this.performNextIO();
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            int n = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic);
            if (n == -1) {
                Log.w((String)QtBluetoothLE.TAG, (String)"onCharacteristicChanged: cannot find handle");
                return;
            }
            QtBluetoothLE.this.leCharacteristicChanged(QtBluetoothLE.this.qtObject, n + 1, bluetoothGattCharacteristic.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            Object object;
            boolean bl;
            int n2 = -1;
            2 var5_5 = this;
            synchronized (var5_5) {
                n2 = QtBluetoothLE.this.handleForDescriptor(bluetoothGattDescriptor);
                if (n2 == -1 || n2 >= QtBluetoothLE.this.entries.size()) {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Cannot find descriptor read request for read notification - handle: " + n2 + " size: " + QtBluetoothLE.this.entries.size()));
                    LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
                    synchronized (linkedList) {
                        QtBluetoothLE.this.pendingJob = null;
                    }
                    QtBluetoothLE.this.performNextIO();
                    return;
                }
            }
            boolean bl2 = bl = !QtBluetoothLE.this.handleForTimeout.compareAndSet(QtBluetoothLE.this.modifiedReadWriteHandle(n2, IoJobType.Read), QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("Late descriptor read reply after timeout was hit for handle " + n2));
                return;
            }
            GattEntry gattEntry = (GattEntry)QtBluetoothLE.this.entries.get(n2);
            boolean bl3 = !gattEntry.valueKnown;
            gattEntry.valueKnown = true;
            if (n == 0) {
                QtBluetoothLE.this.leDescriptorRead(QtBluetoothLE.this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), n2 + 1, bluetoothGattDescriptor.getUuid().toString(), bluetoothGattDescriptor.getValue());
            } else if (bl3) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onDescriptorRead during discovery error: " + n));
                Log.d((String)QtBluetoothLE.TAG, (String)("Non-readable descriptor " + bluetoothGattDescriptor.getUuid() + " for characteristic " + bluetoothGattDescriptor.getCharacteristic().getUuid() + " for service " + bluetoothGattDescriptor.getCharacteristic().getService().getUuid()));
                QtBluetoothLE.this.leDescriptorRead(QtBluetoothLE.this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), n2 + 1, bluetoothGattDescriptor.getUuid().toString(), bluetoothGattDescriptor.getValue());
            } else {
                QtBluetoothLE.this.leServiceError(QtBluetoothLE.this.qtObject, n2 + 1, 6);
            }
            if (bl3) {
                object = (GattEntry)QtBluetoothLE.this.entries.get(gattEntry.associatedServiceHandle);
                if (((GattEntry)object).endHandle == n2) {
                    QtBluetoothLE.this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
                }
                if (bluetoothGattDescriptor.getUuid().compareTo(QtBluetoothLE.this.clientCharacteristicUuid) == 0) {
                    int n3;
                    byte[] byArray = bluetoothGattDescriptor.getValue();
                    int n4 = n3 = byArray != null && byArray.length > 0 ? byArray[0] : 0;
                    if ((n3 & 3) > 0) {
                        Log.d((String)QtBluetoothLE.TAG, (String)"Found descriptor with automatic notifications.");
                        QtBluetoothLE.this.mBluetoothGatt.setCharacteristicNotification(bluetoothGattDescriptor.getCharacteristic(), true);
                    }
                }
            }
            object = QtBluetoothLE.this.readWriteQueue;
            synchronized (object) {
                QtBluetoothLE.this.pendingJob = null;
            }
            QtBluetoothLE.this.performNextIO();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            int n2;
            boolean bl;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onDescriptorWrite: error " + n));
            }
            int n3 = QtBluetoothLE.this.handleForDescriptor(bluetoothGattDescriptor);
            boolean bl2 = bl = !QtBluetoothLE.this.handleForTimeout.compareAndSet(QtBluetoothLE.this.modifiedReadWriteHandle(n3, IoJobType.Write), QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("Late descriptor write reply after timeout was hit for handle " + n3));
                return;
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 3;
                }
            }
            LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
            synchronized (linkedList) {
                QtBluetoothLE.this.pendingJob = null;
            }
            QtBluetoothLE.this.leDescriptorWritten(QtBluetoothLE.this.qtObject, n3 + 1, bluetoothGattDescriptor.getValue(), n2);
            QtBluetoothLE.this.performNextIO();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
            boolean bl;
            int n3 = QtBluetoothLE.this.mSupportedMtu;
            if (n2 == 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("MTU changed to " + n));
                QtBluetoothLE.this.mSupportedMtu = n;
            } else {
                Log.w((String)QtBluetoothLE.TAG, (String)("MTU change error " + n2 + ". New MTU " + n));
                QtBluetoothLE.this.mSupportedMtu = 23;
            }
            if (n3 != QtBluetoothLE.this.mSupportedMtu) {
                QtBluetoothLE.this.leMtuChanged(QtBluetoothLE.this.qtObject, QtBluetoothLE.this.mSupportedMtu);
            }
            boolean bl2 = bl = !QtBluetoothLE.this.handleForTimeout.compareAndSet(QtBluetoothLE.this.modifiedReadWriteHandle(QtBluetoothLE.this.HANDLE_FOR_MTU_EXCHANGE, IoJobType.Mtu), QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)"Late mtu reply after timeout was hit");
                return;
            }
            LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
            synchronized (linkedList) {
                QtBluetoothLE.this.pendingJob = null;
            }
            QtBluetoothLE.this.performNextIO();
        }
    };
    private final Hashtable<UUID, List<Integer>> uuidToEntry = new Hashtable(100);
    private final ArrayList<GattEntry> entries = new ArrayList(100);
    private final LinkedList<Integer> servicesToBeDiscovered = new LinkedList();
    private final LinkedList<ReadWriteJob> readWriteQueue = new LinkedList();
    private ReadWriteJob pendingJob;

    public QtBluetoothLE() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mBluetoothLeScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
    }

    public QtBluetoothLE(String string, Context context) {
        this();
        this.qtContext = context;
        this.mRemoteGattAddress = string;
    }

    public boolean scanForLeDevice(boolean bl) {
        if (bl == this.mLeScanRunning) {
            return true;
        }
        if (bl) {
            Log.d((String)TAG, (String)"New BTLE scanning API");
            ScanSettings.Builder builder = new ScanSettings.Builder();
            builder = builder.setScanMode(1);
            ScanSettings scanSettings = builder.build();
            ArrayList arrayList = new ArrayList();
            this.mBluetoothLeScanner.startScan(arrayList, scanSettings, this.leScanCallback21);
            this.mLeScanRunning = true;
        } else {
            try {
                this.mBluetoothLeScanner.stopScan(this.leScanCallback21);
            }
            catch (IllegalStateException illegalStateException) {
                Log.d((String)TAG, (String)("Stopping LE scan not possible: " + illegalStateException.getMessage()));
            }
            this.mLeScanRunning = false;
        }
        return this.mLeScanRunning == bl;
    }

    public native void leScanResult(long var1, BluetoothDevice var3, int var4, byte[] var5);

    public int mtu() {
        if (this.mSupportedMtu == -1) {
            return 23;
        }
        return this.mSupportedMtu;
    }

    public boolean connect() {
        Object object;
        Class[] classArray;
        BluetoothDevice bluetoothDevice;
        try {
            bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(this.mRemoteGattAddress);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)TAG, (String)("Remote address is not valid: " + this.mRemoteGattAddress));
            return false;
        }
        if (Build.VERSION.SDK_INT >= 27) {
            classArray = new HandlerThread("QtBluetoothLEHandlerThread");
            classArray.start();
            this.mHandler = new Handler(classArray.getLooper());
            object = new Class[]{Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE, Integer.TYPE, Handler.class};
            try {
                Method method = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", (Class<?>)object);
                if (method != null) {
                    this.mBluetoothGatt = (BluetoothGatt)method.invoke((Object)bluetoothDevice, this.qtContext, false, this.gattCallback, 2, 1, this.mHandler);
                    Log.w((String)TAG, (String)"Using Android v26 BluetoothDevice.connectGatt()");
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"connectGatt() v26 not available");
                exception.printStackTrace();
            }
            if (this.mBluetoothGatt == null) {
                this.mHandler.getLooper().quitSafely();
                this.mHandler = null;
            }
        }
        if (this.mBluetoothGatt == null) {
            try {
                classArray = new Class[]{BluetoothGattService.class, UUID.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                this.mCharacteristicConstructor = BluetoothGattCharacteristic.class.getDeclaredConstructor(classArray);
                this.mCharacteristicConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.w((String)TAG, (String)"Unable get characteristic constructor. Buffer race condition are possible");
            }
            try {
                classArray = new Class[]{Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE};
                object = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", classArray);
                if (object != null) {
                    this.mBluetoothGatt = (BluetoothGatt)((Method)object).invoke((Object)bluetoothDevice, this.qtContext, false, this.gattCallback, 2);
                    Log.w((String)TAG, (String)"Using Android v23 BluetoothDevice.connectGatt()");
                }
            }
            catch (Exception exception) {
                this.mBluetoothGatt = bluetoothDevice.connectGatt(this.qtContext, false, this.gattCallback);
            }
        }
        return this.mBluetoothGatt != null;
    }

    public void disconnect() {
        if (this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    public boolean discoverServices() {
        return this.mBluetoothGatt != null && this.mBluetoothGatt.discoverServices();
    }

    private int handleForCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (bluetoothGattCharacteristic == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattCharacteristic.getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case Descriptor: 
                    case CharacteristicValue: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Characteristic: {
                        if (gattEntry.characteristic != bluetoothGattCharacteristic) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private int handleForDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (bluetoothGattDescriptor == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattDescriptor.getCharacteristic().getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case CharacteristicValue: 
                    case Characteristic: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Descriptor: {
                        if (gattEntry.descriptor != bluetoothGattDescriptor) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private void populateHandles() {
        GattEntry gattEntry = null;
        List list = this.mBluetoothGatt.getServices();
        for (BluetoothGattService bluetoothGattService : list) {
            int n;
            GattEntry gattEntry2 = new GattEntry();
            gattEntry2.type = GattEntryType.Service;
            gattEntry2.service = bluetoothGattService;
            this.entries.add(gattEntry2);
            gattEntry2.associatedServiceHandle = n = this.entries.size() - 1;
            List<Integer> list2 = this.uuidToEntry.get(bluetoothGattService.getUuid());
            if (list2 == null) {
                list2 = new ArrayList<Integer>();
            }
            list2.add(this.entries.size() - 1);
            this.uuidToEntry.put(bluetoothGattService.getUuid(), list2);
            List list3 = bluetoothGattService.getCharacteristics();
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : list3) {
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.Characteristic;
                gattEntry.characteristic = bluetoothGattCharacteristic;
                gattEntry.associatedServiceHandle = n;
                this.entries.add(gattEntry);
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.CharacteristicValue;
                gattEntry.associatedServiceHandle = n;
                gattEntry.endHandle = this.entries.size();
                this.entries.add(gattEntry);
                List list4 = bluetoothGattCharacteristic.getDescriptors();
                for (BluetoothGattDescriptor bluetoothGattDescriptor : list4) {
                    gattEntry = new GattEntry();
                    gattEntry.type = GattEntryType.Descriptor;
                    gattEntry.descriptor = bluetoothGattDescriptor;
                    gattEntry.associatedServiceHandle = n;
                    this.entries.add(gattEntry);
                }
            }
            gattEntry2.endHandle = this.entries.size() - 1;
        }
        this.entries.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetData() {
        Object object = this;
        synchronized (object) {
            this.uuidToEntry.clear();
            this.entries.clear();
            this.servicesToBeDiscovered.clear();
        }
        this.timeoutHandler.removeCallbacksAndMessages(null);
        this.handleForTimeout.set(this.HANDLE_FOR_RESET);
        object = this.readWriteQueue;
        synchronized (object) {
            this.readWriteQueue.clear();
        }
    }

    public synchronized boolean discoverServiceDetails(String string, boolean bl) {
        try {
            GattEntry gattEntry;
            int n;
            if (this.mBluetoothGatt == null) {
                return false;
            }
            if (this.entries.isEmpty()) {
                this.populateHandles();
            }
            try {
                UUID uUID = UUID.fromString(string);
                List<Integer> list = this.uuidToEntry.get(uUID);
                if (list == null || list.isEmpty()) {
                    Log.w((String)TAG, (String)("Unknown service uuid for current device: " + uUID.toString()));
                    return false;
                }
                n = list.get(0);
                gattEntry = this.entries.get(n);
                if (gattEntry == null) {
                    Log.w((String)TAG, (String)("Service with UUID " + uUID.toString() + " not found"));
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)TAG, (String)"Cannot parse given UUID");
                return false;
            }
            if (gattEntry.type != GattEntryType.Service) {
                Log.w((String)TAG, (String)("Given UUID is not a service UUID: " + string));
                return false;
            }
            if (gattEntry.valueKnown || this.servicesToBeDiscovered.contains(n)) {
                Log.w((String)TAG, (String)"Service already known or to be discovered");
                return true;
            }
            this.servicesToBeDiscovered.add(n);
            this.scheduleServiceDetailDiscovery(n, bl);
            this.performNextIOThreaded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public String includedServices(String string) {
        UUID uUID;
        if (this.mBluetoothGatt == null) {
            return null;
        }
        try {
            uUID = UUID.fromString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(uUID);
        if (bluetoothGattService == null) {
            return null;
        }
        List list = bluetoothGattService.getIncludedServices();
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (BluetoothGattService bluetoothGattService2 : list) {
            stringBuilder.append(bluetoothGattService2.getUuid().toString()).append(" ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCurrentServiceDiscovery(int n) {
        Log.w((String)TAG, (String)("Finished current discovery for service handle " + n));
        GattEntry gattEntry = this.entries.get(n);
        gattEntry.valueKnown = true;
        QtBluetoothLE qtBluetoothLE = this;
        synchronized (qtBluetoothLE) {
            try {
                this.servicesToBeDiscovered.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                Log.w((String)TAG, (String)"Expected queued service but didn't find any");
            }
        }
        this.leServiceDetailDiscoveryFinished(this.qtObject, gattEntry.service.getUuid().toString(), n + 1, gattEntry.endHandle + 1);
    }

    private boolean executeMtuExchange() {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Method method = this.mBluetoothGatt.getClass().getDeclaredMethod("requestMtu", Integer.TYPE);
                if (method != null) {
                    Boolean bl = (Boolean)method.invoke((Object)this.mBluetoothGatt, 512);
                    if (bl.booleanValue()) {
                        Log.w((String)TAG, (String)"MTU change initiated");
                        return false;
                    }
                    Log.w((String)TAG, (String)"MTU change request failed");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.w((String)TAG, (String)"Assuming default MTU value of 23 bytes");
        this.mSupportedMtu = 23;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleMtuExchange() {
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.jobType = IoJobType.Mtu;
        readWriteJob.entry = null;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            this.readWriteQueue.add(readWriteJob);
        }
        this.performNextIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleServiceDetailDiscovery(int n, boolean bl) {
        GattEntry gattEntry = this.entries.get(n);
        int n2 = gattEntry.endHandle;
        if (n == n2) {
            Log.w((String)TAG, (String)"scheduleServiceDetailDiscovery: service is empty; nothing to discover");
            this.finishCurrentServiceDiscovery(n);
            return;
        }
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            for (int i = n + 1; i <= n2; ++i) {
                GattEntry gattEntry2 = this.entries.get(i);
                if (gattEntry2.type == GattEntryType.Service) {
                    Log.w((String)TAG, (String)"scheduleServiceDetailDiscovery: wrong endHandle");
                    return;
                }
                ReadWriteJob readWriteJob = new ReadWriteJob();
                readWriteJob.entry = gattEntry2;
                readWriteJob.jobType = bl ? IoJobType.Read : IoJobType.SkippedRead;
                boolean bl2 = this.readWriteQueue.add(readWriteJob);
                if (bl2) continue;
                Log.w((String)TAG, (String)("Cannot add service discovery job for " + gattEntry.service.getUuid() + " on item " + (Object)((Object)gattEntry2.type)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCharacteristic(int n, byte[] byArray, int n2) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Write;
        switch (n2) {
            case 1: {
                readWriteJob.requestedWriteType = 1;
                break;
            }
            case 2: {
                readWriteJob.requestedWriteType = 4;
                break;
            }
            default: {
                readWriteJob.requestedWriteType = 2;
            }
        }
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic write request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDescriptor(int n, byte[] byArray) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.requestedWriteType = 2;
        readWriteJob.jobType = IoJobType.Write;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor write request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCharacteristic(int n) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic read request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDescriptor(int n) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor read request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptCurrentIO(int n) {
        Object object = this.readWriteQueue;
        synchronized (object) {
            this.pendingJob = null;
        }
        this.performNextIOThreaded();
        if (n == this.HANDLE_FOR_MTU_EXCHANGE) {
            return;
        }
        try {
            object = this;
            synchronized (object) {
                GattEntry gattEntry = this.entries.get(n);
                if (gattEntry == null) {
                    return;
                }
                if (gattEntry.valueKnown) {
                    return;
                }
                gattEntry.valueKnown = true;
                GattEntry gattEntry2 = this.entries.get(gattEntry.associatedServiceHandle);
                if (gattEntry2 != null && gattEntry2.endHandle == n) {
                    this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.w((String)TAG, (String)("interruptCurrentIO(): Unknown gatt entry, index: " + n + " size: " + this.entries.size()));
        }
    }

    private void performNextIOThreaded() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    QtBluetoothLE.this.performNextIO();
                }
            });
        } else {
            this.performNextIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNextIO() {
        ReadWriteJob readWriteJob;
        if (this.mBluetoothGatt == null) {
            return;
        }
        boolean bl = false;
        int n = this.HANDLE_FOR_RESET;
        Object object = this.readWriteQueue;
        synchronized (object) {
            if (this.readWriteQueue.isEmpty() || this.pendingJob != null) {
                return;
            }
            readWriteJob = this.readWriteQueue.remove();
            if (readWriteJob.jobType == IoJobType.Mtu) {
                n = this.HANDLE_FOR_MTU_EXCHANGE;
            } else {
                switch (readWriteJob.entry.type) {
                    case Characteristic: {
                        n = this.handleForCharacteristic(readWriteJob.entry.characteristic);
                        break;
                    }
                    case Descriptor: {
                        n = this.handleForDescriptor(readWriteJob.entry.descriptor);
                        break;
                    }
                    case CharacteristicValue: {
                        n = readWriteJob.entry.endHandle;
                    }
                }
            }
            this.timeoutHandler.removeCallbacksAndMessages(null);
            this.handleForTimeout.set(this.modifiedReadWriteHandle(n, readWriteJob.jobType));
            switch (readWriteJob.jobType) {
                case Read: {
                    bl = this.executeReadJob(readWriteJob);
                    break;
                }
                case SkippedRead: {
                    bl = true;
                    break;
                }
                case Write: {
                    bl = this.executeWriteJob(readWriteJob);
                    break;
                }
                case Mtu: {
                    bl = this.executeMtuExchange();
                }
            }
            if (bl) {
                this.handleForTimeout.set(this.HANDLE_FOR_RESET);
            } else {
                this.pendingJob = readWriteJob;
                this.timeoutHandler.postDelayed((Runnable)new TimeoutRunnable(this.modifiedReadWriteHandle(n, readWriteJob.jobType)), 3000L);
            }
            if (readWriteJob.jobType != IoJobType.Mtu) {
                Log.w((String)TAG, (String)("Performing queued job, handle: " + n + " " + (Object)((Object)readWriteJob.jobType) + " (" + (readWriteJob.requestedWriteType == 1) + ") ValueKnown: " + readWriteJob.entry.valueKnown + " Skipping: " + bl + " " + (Object)((Object)readWriteJob.entry.type)));
            }
        }
        object = readWriteJob.entry;
        if (bl) {
            if (n > this.HANDLE_FOR_RESET) {
                boolean bl2;
                boolean bl3 = bl2 = !((GattEntry)object).valueKnown;
                if (bl2) {
                    ((GattEntry)object).valueKnown = true;
                    switch (((GattEntry)object).type) {
                        case Characteristic: {
                            Log.d((String)TAG, (String)(readWriteJob.jobType == IoJobType.Read ? "Non-readable" : "Skipped reading of characteristic " + ((GattEntry)object).characteristic.getUuid() + " for service " + ((GattEntry)object).characteristic.getService().getUuid()));
                            this.leCharacteristicRead(this.qtObject, ((GattEntry)object).characteristic.getService().getUuid().toString(), n + 1, ((GattEntry)object).characteristic.getUuid().toString(), ((GattEntry)object).characteristic.getProperties(), ((GattEntry)object).characteristic.getValue());
                            break;
                        }
                        case Descriptor: {
                            Log.d((String)TAG, (String)(readWriteJob.jobType == IoJobType.Read ? "Non-readable" : "Skipped reading of descriptor " + ((GattEntry)object).descriptor.getUuid() + " for service/char " + ((GattEntry)object).descriptor.getCharacteristic().getService().getUuid() + "/" + ((GattEntry)object).descriptor.getCharacteristic().getUuid()));
                            this.leDescriptorRead(this.qtObject, ((GattEntry)object).descriptor.getCharacteristic().getService().getUuid().toString(), ((GattEntry)object).descriptor.getCharacteristic().getUuid().toString(), n + 1, ((GattEntry)object).descriptor.getUuid().toString(), ((GattEntry)object).descriptor.getValue());
                            break;
                        }
                        case CharacteristicValue: {
                            break;
                        }
                        case Service: {
                            Log.w((String)TAG, (String)"Scheduling of Service Gatt entry for service discovery should never happen.");
                        }
                    }
                    QtBluetoothLE qtBluetoothLE = this;
                    synchronized (qtBluetoothLE) {
                        try {
                            GattEntry gattEntry = this.entries.get(((GattEntry)object).associatedServiceHandle);
                            if (gattEntry.endHandle == n) {
                                this.finishCurrentServiceDiscovery(((GattEntry)object).associatedServiceHandle);
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            Log.w((String)TAG, (String)("performNextIO(): Unknown service for entry, index: " + ((GattEntry)object).associatedServiceHandle + " size: " + this.entries.size()));
                        }
                    }
                }
                int n2 = 0;
                n2 = readWriteJob.jobType == IoJobType.Read ? (((GattEntry)object).type == GattEntryType.Characteristic ? 5 : 6) : (((GattEntry)object).type == GattEntryType.Characteristic ? 2 : 3);
                this.leServiceError(this.qtObject, n + 1, n2);
            }
            this.performNextIO();
        }
    }

    private BluetoothGattCharacteristic cloneChararacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        try {
            return (BluetoothGattCharacteristic)this.mCharacteristicConstructor.newInstance(bluetoothGattCharacteristic.getService(), bluetoothGattCharacteristic.getUuid(), bluetoothGattCharacteristic.getInstanceId(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getPermissions());
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("Cloning characteristic failed!" + exception));
            return null;
        }
    }

    private boolean executeWriteJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                if (this.mHandler != null || this.mCharacteristicConstructor == null) {
                    boolean bl;
                    if (readWriteJob.entry.characteristic.getWriteType() != readWriteJob.requestedWriteType) {
                        readWriteJob.entry.characteristic.setWriteType(readWriteJob.requestedWriteType);
                    }
                    return !(bl = readWriteJob.entry.characteristic.setValue(readWriteJob.newValue)) || !this.mBluetoothGatt.writeCharacteristic(readWriteJob.entry.characteristic);
                }
                BluetoothGattCharacteristic bluetoothGattCharacteristic = readWriteJob.entry.characteristic;
                BluetoothGattCharacteristic bluetoothGattCharacteristic2 = this.cloneChararacteristic(bluetoothGattCharacteristic);
                if (bluetoothGattCharacteristic2 == null) {
                    return true;
                }
                bluetoothGattCharacteristic2.setWriteType(readWriteJob.requestedWriteType);
                return !bluetoothGattCharacteristic2.setValue(readWriteJob.newValue) || !this.mBluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic2);
            }
            case Descriptor: {
                boolean bl;
                if (readWriteJob.entry.descriptor.getUuid().compareTo(this.clientCharacteristicUuid) == 0) {
                    boolean bl2 = false;
                    int n = readWriteJob.newValue[0] & 0xFF;
                    if ((n & 1) == 1 || (n >> 1 & 1) == 1) {
                        bl2 = true;
                    }
                    if (!(bl = this.mBluetoothGatt.setCharacteristicNotification(readWriteJob.entry.descriptor.getCharacteristic(), bl2))) {
                        Log.w((String)TAG, (String)"Cannot set characteristic notification");
                    }
                    Log.d((String)TAG, (String)("Enable notifications: " + bl2));
                }
                if ((bl = readWriteJob.entry.descriptor.setValue(readWriteJob.newValue)) && this.mBluetoothGatt.writeDescriptor(readWriteJob.entry.descriptor)) break;
                return true;
            }
            case CharacteristicValue: 
            case Service: {
                return true;
            }
        }
        return false;
    }

    private boolean executeReadJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                boolean bl;
                try {
                    bl = this.mBluetoothGatt.readCharacteristic(readWriteJob.entry.characteristic);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl = false;
                }
                if (bl) break;
                return true;
            }
            case Descriptor: {
                boolean bl;
                try {
                    bl = this.mBluetoothGatt.readDescriptor(readWriteJob.entry.descriptor);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl = false;
                }
                if (bl) break;
                return true;
            }
            case Service: {
                return true;
            }
            case CharacteristicValue: {
                return true;
            }
        }
        return false;
    }

    private int modifiedReadWriteHandle(int n, IoJobType ioJobType) {
        int n2 = n;
        if (n > 65535) {
            Log.w((String)TAG, (String)"Invalid handle");
        }
        n2 &= 0xFFFF;
        switch (ioJobType) {
            case Write: {
                n2 |= 0x10000;
                break;
            }
            case Read: {
                n2 |= 0x20000;
                break;
            }
            case Mtu: {
                n2 = this.HANDLE_FOR_MTU_EXCHANGE;
            }
        }
        return n2;
    }

    public boolean requestConnectionUpdatePriority(double d) {
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            Method method = this.mBluetoothGatt.getClass().getDeclaredMethod("requestConnectionPriority", Integer.TYPE);
            if (method == null) {
                return false;
            }
            int n = 0;
            if (d < 30.0) {
                n = 1;
            } else if (d > 100.0) {
                n = 2;
            }
            Object object = method.invoke((Object)this.mBluetoothGatt, n);
            return (Boolean)object;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public native void leConnectionStateChange(long var1, int var3, int var4);

    public native void leMtuChanged(long var1, int var3);

    public native void leServicesDiscovered(long var1, int var3, String var4);

    public native void leServiceDetailDiscoveryFinished(long var1, String var3, int var4, int var5);

    public native void leCharacteristicRead(long var1, String var3, int var4, String var5, int var6, byte[] var7);

    public native void leDescriptorRead(long var1, String var3, String var4, int var5, String var6, byte[] var7);

    public native void leCharacteristicWritten(long var1, int var3, byte[] var4, int var5);

    public native void leDescriptorWritten(long var1, int var3, byte[] var4, int var5);

    public native void leCharacteristicChanged(long var1, int var3, byte[] var4);

    public native void leServiceError(long var1, int var3, int var4);

    private class ReadWriteJob {
        public GattEntry entry;
        public byte[] newValue;
        public int requestedWriteType;
        public IoJobType jobType;

        private ReadWriteJob() {
        }
    }

    private static enum IoJobType {
        Read,
        Write,
        Mtu,
        SkippedRead;

    }

    private class GattEntry {
        public GattEntryType type;
        public boolean valueKnown = false;
        public BluetoothGattService service = null;
        public BluetoothGattCharacteristic characteristic = null;
        public BluetoothGattDescriptor descriptor = null;
        public int endHandle = -1;
        public int associatedServiceHandle;

        private GattEntry() {
        }
    }

    private static enum GattEntryType {
        Service,
        Characteristic,
        CharacteristicValue,
        Descriptor;

    }

    private class BondStateBroadcastReceiver
    extends BroadcastReceiver {
        private BondStateBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (QtBluetoothLE.this.mBluetoothGatt == null) {
                return;
            }
            BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (bluetoothDevice == null || !bluetoothDevice.getAddress().equals(QtBluetoothLE.this.mBluetoothGatt.getDevice().getAddress())) {
                return;
            }
            int n = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            int n2 = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
            if (n == 11) {
                LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
                synchronized (linkedList) {
                    if (QtBluetoothLE.this.pendingJob == null || ((QtBluetoothLE)QtBluetoothLE.this).pendingJob.jobType == IoJobType.Mtu) {
                        return;
                    }
                }
                QtBluetoothLE.this.timeoutHandler.removeCallbacksAndMessages(null);
                QtBluetoothLE.this.handleForTimeout.set(QtBluetoothLE.this.HANDLE_FOR_RESET);
            } else if (n2 == 11 && (n == 12 || n == 10)) {
                LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
                synchronized (linkedList) {
                    if (QtBluetoothLE.this.pendingJob == null || ((QtBluetoothLE)QtBluetoothLE.this).pendingJob.jobType == IoJobType.Mtu) {
                        return;
                    }
                    QtBluetoothLE.this.readWriteQueue.addFirst(QtBluetoothLE.this.pendingJob);
                    QtBluetoothLE.this.pendingJob = null;
                }
                QtBluetoothLE.this.performNextIO();
            } else if (n2 == 12 && n == 10) {
                try {
                    bluetoothDevice.getClass().getMethod("removeBond", new Class[0]).invoke((Object)bluetoothDevice, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        private int pendingJobHandle = -1;

        public TimeoutRunnable(int n) {
            this.pendingJobHandle = n;
        }

        @Override
        public void run() {
            boolean bl = QtBluetoothLE.this.handleForTimeout.compareAndSet(this.pendingJobHandle, QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("****** Timeout for request on handle " + (this.pendingJobHandle & 0xFFFF)));
                Log.w((String)QtBluetoothLE.TAG, (String)"****** Looks like the peripheral does NOT act in accordance to Bluetooth 4.x spec.");
                Log.w((String)QtBluetoothLE.TAG, (String)"****** Please check server implementation. Continuing under reservation.");
                if (this.pendingJobHandle > QtBluetoothLE.this.HANDLE_FOR_RESET) {
                    QtBluetoothLE.this.interruptCurrentIO(this.pendingJobHandle & 0xFFFF);
                } else if (this.pendingJobHandle < QtBluetoothLE.this.HANDLE_FOR_RESET) {
                    QtBluetoothLE.this.interruptCurrentIO(this.pendingJobHandle);
                }
            }
        }
    }
}

