/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private Path mClasspath;
    private String mFileName;
    private String mConfigLocation;
    private boolean mFailOnViolation = true;
    private String mFailureProperty;
    private final List<FileSet> mFileSets = Lists.newArrayList();
    private final List<Formatter> mFormatters = Lists.newArrayList();
    private final List<Property> mOverrideProps = Lists.newArrayList();
    private File mPropertiesFile;
    private int mMaxErrors;
    private int mMaxWarnings = Integer.MAX_VALUE;
    private boolean mOmitIgnoredModules = true;

    public void setFailureProperty(String aPropertyName) {
        this.mFailureProperty = aPropertyName;
    }

    public void setFailOnViolation(boolean aFail) {
        this.mFailOnViolation = aFail;
    }

    public void setMaxErrors(int aMaxErrors) {
        this.mMaxErrors = aMaxErrors;
    }

    public void setMaxWarnings(int aMaxWarnings) {
        this.mMaxWarnings = aMaxWarnings;
    }

    public void addFileset(FileSet aFS) {
        this.mFileSets.add(aFS);
    }

    public void addFormatter(Formatter aFormatter) {
        this.mFormatters.add(aFormatter);
    }

    public void addProperty(Property aProperty) {
        this.mOverrideProps.add(aProperty);
    }

    public void setClasspath(Path aClasspath) {
        if (this.mClasspath == null) {
            this.mClasspath = aClasspath;
        } else {
            this.mClasspath.append(aClasspath);
        }
    }

    public void setClasspathRef(Reference aClasspathRef) {
        this.createClasspath().setRefid(aClasspathRef);
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(this.getProject());
        }
        return this.mClasspath.createPath();
    }

    public void setFile(File aFile) {
        this.mFileName = aFile.getAbsolutePath();
    }

    public void setConfig(File aFile) {
        this.setConfigLocation(aFile.getAbsolutePath());
    }

    public void setConfigURL(URL aURL) {
        this.setConfigLocation(aURL.toExternalForm());
    }

    private void setConfigLocation(String aLocation) {
        if (this.mConfigLocation != null) {
            throw new BuildException("Attributes 'config' and 'configURL' must not be set at the same time");
        }
        this.mConfigLocation = aLocation;
    }

    public void setOmitIgnoredModules(boolean aOmit) {
        this.mOmitIgnoredModules = aOmit;
    }

    public void setProperties(File aProps) {
        this.mPropertiesFile = aProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        long startTime = System.currentTimeMillis();
        try {
            this.realExecute();
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.log("Total execution took " + (endTime - startTime) + " ms.", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realExecute() {
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation");
        String version = compilationProperties.getString("checkstyle.compile.version");
        String compileTimestamp = compilationProperties.getString("checkstyle.compile.timestamp");
        this.log("checkstyle version " + version, 3);
        this.log("compiled on " + compileTimestamp, 3);
        if (this.mFileName == null && this.mFileSets.isEmpty()) {
            throw new BuildException("Must specify at least one of 'file' or nested 'fileset'.", this.getLocation());
        }
        if (this.mConfigLocation == null) {
            throw new BuildException("Must specify 'config'.", this.getLocation());
        }
        Checker c = null;
        try {
            boolean ok;
            c = this.createChecker();
            SeverityLevelCounter warningCounter = new SeverityLevelCounter(SeverityLevel.WARNING);
            c.addListener(warningCounter);
            long startTime = System.currentTimeMillis();
            List<File> files = this.scanFileSets();
            long endTime = System.currentTimeMillis();
            this.log("To locate the files took " + (endTime - startTime) + " ms.", 3);
            this.log("Running Checkstyle " + version + " on " + files.size() + " files", 2);
            this.log("Using configuration " + this.mConfigLocation, 3);
            startTime = System.currentTimeMillis();
            int numErrs = c.process(files);
            endTime = System.currentTimeMillis();
            this.log("To process the files took " + (endTime - startTime) + " ms.", 3);
            int numWarnings = warningCounter.getCount();
            boolean bl = ok = numErrs <= this.mMaxErrors && numWarnings <= this.mMaxWarnings;
            if (!ok) {
                String failureMsg = "Got " + numErrs + " errors and " + numWarnings + " warnings.";
                if (this.mFailureProperty != null) {
                    this.getProject().setProperty(this.mFailureProperty, failureMsg);
                }
                if (this.mFailOnViolation) {
                    throw new BuildException(failureMsg, this.getLocation());
                }
            }
        }
        finally {
            if (c != null) {
                c.destroy();
            }
        }
    }

    private Checker createChecker() {
        Checker c = null;
        try {
            AuditListener[] listeners;
            Properties props = this.createOverridingProperties();
            Configuration config = ConfigurationLoader.loadConfiguration(this.mConfigLocation, (PropertyResolver)new PropertiesExpander(props), this.mOmitIgnoredModules);
            DefaultContext context = new DefaultContext();
            AntClassLoader loader = new AntClassLoader(this.getProject(), this.mClasspath);
            context.add("classloader", loader);
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            context.add("moduleClassLoader", moduleClassLoader);
            c = new Checker();
            c.contextualize(context);
            c.configure(config);
            for (AuditListener element : listeners = this.getListeners()) {
                c.addListener(element);
            }
        }
        catch (Exception e) {
            throw new BuildException("Unable to create a Checker: " + e.getMessage(), (Throwable)e);
        }
        return c;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties createOverridingProperties() {
        Properties retVal = new Properties();
        if (this.mPropertiesFile != null) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.mPropertiesFile);
                retVal.load(inStream);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new BuildException("Could not find Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
                    catch (IOException e2) {
                        throw new BuildException("Error loading Properties file '" + this.mPropertiesFile + "'", (Throwable)e2, this.getLocation());
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Utils.closeQuietly(inStream);
        }
        Hashtable antProps = this.getProject().getProperties();
        for (Object name : antProps.keySet()) {
            String key = (String)name;
            String value = String.valueOf(antProps.get(key));
            retVal.put(key, value);
        }
        Iterator<Object> i$ = this.mOverrideProps.iterator();
        while (i$.hasNext()) {
            Property p = (Property)i$.next();
            retVal.put(p.getKey(), p.getValue());
        }
        return retVal;
    }

    protected AuditListener[] getListeners() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        int formatterCount = Math.max(1, this.mFormatters.size());
        AuditListener[] listeners = new AuditListener[formatterCount];
        if (this.mFormatters.isEmpty()) {
            LogOutputStream debug = new LogOutputStream((Task)this, 4);
            LogOutputStream err = new LogOutputStream((Task)this, 0);
            listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
        } else {
            for (int i = 0; i < formatterCount; ++i) {
                Formatter f = this.mFormatters.get(i);
                listeners[i] = f.createListener(this);
            }
        }
        return listeners;
    }

    protected List<File> scanFileSets() {
        ArrayList<File> list = Lists.newArrayList();
        if (this.mFileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(new File(this.mFileName));
        }
        for (int i = 0; i < this.mFileSets.size(); ++i) {
            FileSet fs = this.mFileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] names = ds.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + ds.getBasedir(), 3);
            for (String element : names) {
                String pathname = ds.getBasedir() + File.separator + element;
                list.add(new File(pathname));
            }
        }
        return list;
    }

    public static class Listener {
        private String mClassname;

        public String getClassname() {
            return this.mClassname;
        }

        public void setClassname(String aClassname) {
            this.mClassname = aClassname;
        }
    }

    public static class Property {
        private String mKey;
        private String mValue;

        public String getKey() {
            return this.mKey;
        }

        public void setKey(String aKey) {
            this.mKey = aKey;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String aValue) {
            this.mValue = aValue;
        }

        public void setFile(File aValue) {
            this.setValue(aValue.getAbsolutePath());
        }
    }

    public static class Formatter {
        private FormatterType mFormatterType;
        private File mToFile;
        private boolean mUseFile = true;

        public void setType(FormatterType aType) {
            String val = aType.getValue();
            if (!CheckStyleTask.E_XML.equals(val) && !CheckStyleTask.E_PLAIN.equals(val)) {
                throw new BuildException("Invalid formatter type: " + val);
            }
            this.mFormatterType = aType;
        }

        public void setTofile(File aTo) {
            this.mToFile = aTo;
        }

        public void setUseFile(boolean aUse) {
            this.mUseFile = aUse;
        }

        public AuditListener createListener(Task aTask) throws IOException {
            if (this.mFormatterType != null && CheckStyleTask.E_XML.equals(this.mFormatterType.getValue())) {
                return this.createXMLLogger(aTask);
            }
            return this.createDefaultLogger(aTask);
        }

        private AuditListener createDefaultLogger(Task aTask) throws IOException {
            if (this.mToFile == null || !this.mUseFile) {
                return new DefaultLogger((OutputStream)new LogOutputStream(aTask, 4), true, (OutputStream)new LogOutputStream(aTask, 0), true);
            }
            return new DefaultLogger(new FileOutputStream(this.mToFile), true);
        }

        private AuditListener createXMLLogger(Task aTask) throws IOException {
            if (this.mToFile == null || !this.mUseFile) {
                return new XMLLogger((OutputStream)new LogOutputStream(aTask, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.mToFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return (String[])VALUES.clone();
        }
    }
}

