/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IllegalCatchCheck
extends AbstractIllegalCheck {
    public IllegalCatchCheck() {
        super(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{98};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST aDetailAST) {
        DetailAST paramDef = aDetailAST.findFirstToken(21);
        DetailAST excTypeParent = paramDef.findFirstToken(13);
        List<DetailAST> excTypes = this.getAllExceptionTypes(excTypeParent);
        for (DetailAST excType : excTypes) {
            FullIdent ident = FullIdent.createFullIdent(excType);
            if (!this.isIllegalClassName(ident.getText())) continue;
            this.log(aDetailAST, "illegal.catch", ident.getText());
        }
    }

    public List<DetailAST> getAllExceptionTypes(DetailAST aParentToken) {
        DetailAST currentNode = aParentToken.getFirstChild();
        LinkedList<DetailAST> exceptionTypes = new LinkedList<DetailAST>();
        if (currentNode.getType() == 114) {
            exceptionTypes.addAll(this.getAllExceptionTypes(currentNode));
            currentNode = currentNode.getNextSibling();
            if (currentNode != null) {
                exceptionTypes.add(currentNode);
            }
        } else {
            exceptionTypes.add(currentNode);
            while ((currentNode = currentNode.getNextSibling()) != null) {
                exceptionTypes.add(currentNode);
            }
        }
        return exceptionTypes;
    }
}

