/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST aAST) {
        boolean isUtilClass;
        if (this.isAbstract(aAST)) {
            return;
        }
        DetailAST objBlock = aAST.findFirstToken(6);
        boolean hasStaticModifier = this.isStatic(aAST);
        boolean hasMethodOrField = false;
        boolean hasNonStaticMethodOrField = false;
        boolean hasNonPrivateStaticMethodOrField = false;
        boolean hasDefaultCtor = true;
        boolean hasPublicCtor = false;
        for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST modifiers;
            int type = child.getType();
            if (type == 9 || type == 10) {
                hasMethodOrField = true;
                modifiers = child.findFirstToken(5);
                boolean isStatic = modifiers.branchContains(65);
                boolean isPrivate = modifiers.branchContains(62);
                if (!isStatic && !isPrivate) {
                    hasNonStaticMethodOrField = true;
                }
                if (isStatic && !isPrivate) {
                    hasNonPrivateStaticMethodOrField = true;
                }
            }
            if (type != 8) continue;
            hasDefaultCtor = false;
            modifiers = child.findFirstToken(5);
            if (modifiers.branchContains(62) || modifiers.branchContains(64)) continue;
            hasPublicCtor = true;
        }
        boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
        boolean extendsJLO = aAST.findFirstToken(18) == null;
        boolean bl = isUtilClass = extendsJLO && hasMethodOrField && !hasNonStaticMethodOrField && hasNonPrivateStaticMethodOrField;
        if (isUtilClass && hasAccessibleCtor && !hasStaticModifier) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "hide.utility.class", new Object[0]);
        }
    }

    private boolean isAbstract(DetailAST aAST) {
        return aAST.findFirstToken(5).branchContains(41);
    }

    private boolean isStatic(DetailAST aAST) {
        return aAST.findFirstToken(5).branchContains(65);
    }
}

