/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.awt.Color;
import java.util.List;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSelector {
    private final DetailAST ast;
    private final JTextArea editor;
    private final List<Integer> lines2position;

    public CodeSelector(DetailAST ast, JTextArea editor, List<Integer> lines2position) {
        this.ast = ast;
        this.editor = editor;
        this.lines2position = lines2position;
    }

    public void select() {
        int start = this.lines2position.get(this.ast.getLineNo()) + this.ast.getColumnNo();
        int end = this.findLastPosition(this.ast);
        this.editor.setSelectedTextColor(Color.blue);
        this.editor.requestFocusInWindow();
        this.editor.setSelectionStart(start);
        this.editor.setSelectionEnd(end);
        this.editor.transferFocusBackward();
    }

    private int findLastPosition(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            return this.lines2position.get(ast.getLineNo()) + ast.getColumnNo() + ast.getText().length();
        }
        return this.findLastPosition(ast.getLastChild());
    }
}

