/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.DeclarationCollector;

public class RequireThisCheck
extends DeclarationCollector {
    private boolean mCheckFields = true;
    private boolean mCheckMethods = true;

    public void setCheckFields(boolean aCheckFields) {
        this.mCheckFields = aCheckFields;
    }

    public boolean getCheckFields() {
        return this.mCheckFields;
    }

    public void setCheckMethods(boolean aCheckMethods) {
        this.mCheckMethods = aCheckMethods;
    }

    public boolean getCheckMethods() {
        return this.mCheckMethods;
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 8, 156, 59, 15, 9, 21, 7, 10};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        super.visitToken(aAST);
        if (aAST.getType() == 59) {
            this.processIDENT(aAST);
        }
    }

    private void processIDENT(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        if (parentType == 162 || parentType == 161 || parentType == 163) {
            return;
        }
        if (parentType == 27) {
            if (this.mCheckMethods && this.isClassField(aAST.getText())) {
                this.log(aAST, "require.this.method", aAST.getText());
            }
            return;
        }
        if (!this.mCheckFields) {
            return;
        }
        if (ScopeUtils.getSurroundingScope(aAST) == null) {
            return;
        }
        if (parentType == 60 && aAST.getPreviousSibling() != null) {
            return;
        }
        if (parentType == 13 || parentType == 138) {
            return;
        }
        if (parentType == 10 || parentType == 8 || parentType == 9 || parentType == 14 || parentType == 156 || parentType == 15 || parentType == 21 || parentType == 166) {
            return;
        }
        String name = aAST.getText();
        if (this.isClassField(name)) {
            this.log(aAST, "require.this.variable", name);
        }
    }
}

