# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
  },
  'targets': [
    {
      # GN version: //extensions/common:mojo
      'target_name': 'extensions_common_mojo',
      # The type of this target must be none. This is so that resources can
      # depend upon this target for generating the js bindings files. Any
      # generated cpp files must be listed explicitly in extensions_common
      'type': 'none',
      'includes': [
        '../mojo/public/tools/bindings/mojom_bindings_generator.gypi',
      ],
      'sources': [
        'common/mojo/keep_alive.mojom',
        'common/mojo/stash.mojom',
      ],
    },
    {
      # GN version: //extensions/common
      'target_name': 'extensions_common_constants',
      'type': 'static_library',
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'common/constants.cc',
        'common/constants.h',
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
    },
    {
      # GN version: //extensions/common
      'target_name': 'extensions_common',
      'type': 'static_library',
      'dependencies': [
        '../components/components.gyp:crx_file',
        '../components/components.gyp:url_matcher',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        # For Mojo generated headers for generated_api.cc.
        '../device/serial/serial.gyp:device_serial_mojo',
        '../device/usb/usb.gyp:device_usb',
        '../ipc/ipc.gyp:ipc',
        '../net/net.gyp:net',
        '../third_party/re2/re2.gyp:re2',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/gfx/ipc/gfx_ipc.gyp:gfx_ipc',
        '../url/url.gyp:url_lib',
        '../third_party/libxml/libxml.gyp:libxml',
        'common/api/api.gyp:extensions_api',
        'extensions_resources.gyp:extensions_resources',
        'extensions_strings.gyp:extensions_strings',
        'extensions_common_constants',
        'extensions_common_mojo',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'common/api/bluetooth/bluetooth_manifest_data.cc',
        'common/api/bluetooth/bluetooth_manifest_data.h',
        'common/api/bluetooth/bluetooth_manifest_handler.cc',
        'common/api/bluetooth/bluetooth_manifest_handler.h',
        'common/api/bluetooth/bluetooth_manifest_permission.cc',
        'common/api/bluetooth/bluetooth_manifest_permission.h',
        'common/api/messaging/message.h',
        'common/api/sockets/sockets_manifest_data.cc',
        'common/api/sockets/sockets_manifest_data.h',
        'common/api/sockets/sockets_manifest_handler.cc',
        'common/api/sockets/sockets_manifest_handler.h',
        'common/api/sockets/sockets_manifest_permission.cc',
        'common/api/sockets/sockets_manifest_permission.h',
        'common/common_manifest_handlers.cc',
        'common/common_manifest_handlers.h',
        'common/csp_validator.cc',
        'common/csp_validator.h',
        'common/dom_action_types.h',
        'common/draggable_region.cc',
        'common/draggable_region.h',
        'common/error_utils.cc',
        'common/error_utils.h',
        'common/event_filter.cc',
        'common/event_filter.h',
        'common/event_filtering_info.cc',
        'common/event_filtering_info.h',
        'common/event_matcher.cc',
        'common/event_matcher.h',
        'common/extension.cc',
        'common/extension.h',
        'common/extension_api.cc',
        'common/extension_api.h',
        'common/extension_icon_set.cc',
        'common/extension_icon_set.h',
        'common/extension_l10n_util.cc',
        'common/extension_l10n_util.h',
        'common/extension_message_generator.cc',
        'common/extension_message_generator.h',
        'common/extension_messages.cc',
        'common/extension_messages.h',
        'common/extension_paths.cc',
        'common/extension_paths.h',
        'common/extension_resource.cc',
        'common/extension_resource.h',
        'common/extension_set.cc',
        'common/extension_set.h',
        'common/extension_urls.cc',
        'common/extension_urls.h',
        'common/extension_utility_messages.h',
        'common/extensions_client.cc',
        'common/extensions_client.h',
        'common/feature_switch.cc',
        'common/feature_switch.h',
        'common/features/api_feature.cc',
        'common/features/api_feature.h',
        'common/features/base_feature_provider.cc',
        'common/features/base_feature_provider.h',
        'common/features/complex_feature.cc',
        'common/features/complex_feature.h',
        'common/features/feature.cc',
        'common/features/feature.h',
        'common/features/feature_provider.cc',
        'common/features/feature_provider.h',
        'common/features/json_feature_provider_source.cc',
        'common/features/json_feature_provider_source.h',
        'common/features/manifest_feature.cc',
        'common/features/manifest_feature.h',
        'common/features/permission_feature.cc',
        'common/features/permission_feature.h',
        'common/features/simple_feature.cc',
        'common/features/simple_feature.h',
        'common/features/simple_feature_filter.cc',
        'common/features/simple_feature_filter.h',
        'common/file_util.cc',
        'common/file_util.h',
        'common/guest_view/guest_view_constants.cc',
        'common/guest_view/guest_view_constants.h',
        'common/install_warning.cc',
        'common/install_warning.h',
        'common/manifest.cc',
        'common/manifest.h',
        'common/manifest_constants.cc',
        'common/manifest_constants.h',
        'common/manifest_handler.cc',
        'common/manifest_handler.h',
        'common/manifest_handler_helpers.cc',
        'common/manifest_handler_helpers.h',
        'common/manifest_handlers/background_info.cc',
        'common/manifest_handlers/background_info.h',
        'common/manifest_handlers/csp_info.cc',
        'common/manifest_handlers/csp_info.h',
        'common/manifest_handlers/externally_connectable.cc',
        'common/manifest_handlers/externally_connectable.h',
        'common/manifest_handlers/file_handler_info.cc',
        'common/manifest_handlers/file_handler_info.h',
        'common/manifest_handlers/icons_handler.cc',
        'common/manifest_handlers/icons_handler.h',
        'common/manifest_handlers/incognito_info.cc',
        'common/manifest_handlers/incognito_info.h',
        'common/manifest_handlers/kiosk_mode_info.cc',
        'common/manifest_handlers/kiosk_mode_info.h',
        'common/manifest_handlers/launcher_page_info.cc',
        'common/manifest_handlers/launcher_page_info.h',
        'common/manifest_handlers/oauth2_manifest_handler.cc',
        'common/manifest_handlers/oauth2_manifest_handler.h',
        'common/manifest_handlers/offline_enabled_info.cc',
        'common/manifest_handlers/offline_enabled_info.h',
        'common/manifest_handlers/options_page_info.cc',
        'common/manifest_handlers/options_page_info.h',
        'common/manifest_handlers/permissions_parser.cc',
        'common/manifest_handlers/permissions_parser.h',
        'common/manifest_handlers/requirements_info.cc',
        'common/manifest_handlers/requirements_info.h',
        'common/manifest_handlers/sandboxed_page_info.cc',
        'common/manifest_handlers/sandboxed_page_info.h',
        'common/manifest_handlers/shared_module_info.cc',
        'common/manifest_handlers/shared_module_info.h',
        'common/manifest_handlers/web_accessible_resources_info.cc',
        'common/manifest_handlers/web_accessible_resources_info.h',
        'common/manifest_handlers/webview_info.cc',
        'common/manifest_handlers/webview_info.h',
        'common/manifest_url_handlers.cc',
        'common/manifest_url_handlers.h',
        'common/message_bundle.cc',
        'common/message_bundle.h',
        'common/one_shot_event.cc',
        'common/one_shot_event.h',
        'common/permissions/api_permission.cc',
        'common/permissions/api_permission.h',
        'common/permissions/api_permission_set.cc',
        'common/permissions/api_permission_set.h',
        'common/permissions/base_set_operators.h',
        'common/permissions/extensions_api_permissions.cc',
        'common/permissions/extensions_api_permissions.h',
        'common/permissions/manifest_permission.cc',
        'common/permissions/manifest_permission.h',
        'common/permissions/manifest_permission_set.cc',
        'common/permissions/manifest_permission_set.h',
        'common/permissions/media_galleries_permission.cc',
        'common/permissions/media_galleries_permission.h',
        'common/permissions/media_galleries_permission_data.cc',
        'common/permissions/media_galleries_permission_data.h',
        'common/permissions/permission_message.cc',
        'common/permissions/permission_message.h',
        'common/permissions/permission_message_provider.cc',
        'common/permissions/permission_message_provider.h',
        'common/permissions/permission_message_util.cc',
        'common/permissions/permission_message_util.h',
        'common/permissions/permission_set.cc',
        'common/permissions/permission_set.h',
        'common/permissions/permissions_data.cc',
        'common/permissions/permissions_data.h',
        'common/permissions/permissions_info.cc',
        'common/permissions/permissions_info.h',
        'common/permissions/permissions_provider.h',
        'common/permissions/set_disjunction_permission.h',
        'common/permissions/settings_override_permission.cc',
        'common/permissions/settings_override_permission.h',
        'common/permissions/socket_permission.cc',
        'common/permissions/socket_permission.h',
        'common/permissions/socket_permission_data.cc',
        'common/permissions/socket_permission_data.h',
        'common/permissions/socket_permission_entry.cc',
        'common/permissions/socket_permission_entry.h',
        'common/permissions/usb_device_permission.cc',
        'common/permissions/usb_device_permission.h',
        'common/permissions/usb_device_permission_data.cc',
        'common/permissions/usb_device_permission_data.h',
        'common/stack_frame.cc',
        'common/stack_frame.h',
        'common/switches.cc',
        'common/switches.h',
        'common/update_manifest.cc',
        'common/update_manifest.h',
        'common/url_pattern.cc',
        'common/url_pattern.h',
        'common/url_pattern_set.cc',
        'common/url_pattern_set.h',
        'common/user_script.cc',
        'common/user_script.h',
        'common/value_counter.cc',
        'common/value_counter.h',
        'common/view_type.cc',
        'common/view_type.h',
        '<(SHARED_INTERMEDIATE_DIR)/extensions/common/mojo/keep_alive.mojom.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extensions/common/mojo/keep_alive.mojom.h',
        '<(SHARED_INTERMEDIATE_DIR)/extensions/common/mojo/stash.mojom.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extensions/common/mojo/stash.mojom.h',
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
      'conditions': [
        ['disable_nacl==0', {
          # NaClModulesHandler does not use any code in NaCl, so no dependency
          # on nacl_common.
          'sources': [
            'common/manifest_handlers/nacl_modules_handler.cc',
            'common/manifest_handlers/nacl_modules_handler.h',
          ],
        }],
      ],
    },
    {
      # GN version: //extensions/browser
      'target_name': 'extensions_browser',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_prefs',
        '../components/components.gyp:copresence_sockets',
        '../components/components.gyp:keyed_service_content',
        '../components/components.gyp:keyed_service_core',
        '../components/components.gyp:pref_registry',
        '../components/components.gyp:sessions_content',
        '../components/components.gyp:storage_monitor',
        '../components/components.gyp:web_cache_browser',
        '../components/components.gyp:web_modal',
        '../content/content.gyp:content_browser',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        '../device/serial/serial.gyp:device_serial',
        '../google_apis/google_apis.gyp:google_apis',
        '../skia/skia.gyp:skia',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/re2/re2.gyp:re2',
        'browser/api/api_registration.gyp:extensions_api_registration',
        'common/api/api.gyp:cast_channel_proto',
        'common/api/api.gyp:extensions_api',
        'extensions_common',
        'extensions_resources.gyp:extensions_resources',
        'extensions_strings.gyp:extensions_strings',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed to access generated API headers.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        # NOTE: When moving an API out of Chrome be sure to verify that the
        # Android build still compiles. See conditions below.
        'browser/api/activity_log/web_request_constants.cc',
        'browser/api/activity_log/web_request_constants.h',
        'browser/api/api_resource.cc',
        'browser/api/api_resource.h',
        'browser/api/api_resource_manager.h',
        'browser/api/app_current_window_internal/app_current_window_internal_api.cc',
        'browser/api/app_current_window_internal/app_current_window_internal_api.h',
        'browser/api/app_runtime/app_runtime_api.cc',
        'browser/api/app_runtime/app_runtime_api.h',
        'browser/api/app_view/app_view_guest_internal_api.cc',
        'browser/api/app_view/app_view_guest_internal_api.h',
        'browser/api/app_window/app_window_api.cc',
        'browser/api/app_window/app_window_api.h',
        'browser/api/async_api_function.cc',
        'browser/api/async_api_function.h',
        'browser/api/bluetooth/bluetooth_api.cc',
        'browser/api/bluetooth/bluetooth_api.h',
        'browser/api/bluetooth/bluetooth_api_pairing_delegate.cc',
        'browser/api/bluetooth/bluetooth_api_pairing_delegate.h',
        'browser/api/bluetooth/bluetooth_api_utils.cc',
        'browser/api/bluetooth/bluetooth_api_utils.h',
        'browser/api/bluetooth/bluetooth_event_router.cc',
        'browser/api/bluetooth/bluetooth_event_router.h',
        'browser/api/bluetooth/bluetooth_extension_function.cc',
        'browser/api/bluetooth/bluetooth_extension_function.h',
        'browser/api/bluetooth/bluetooth_private_api.cc',
        'browser/api/bluetooth/bluetooth_private_api.h',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_api.cc',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_api.h',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_connection.cc',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_connection.h',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_event_router.cc',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_event_router.h',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_notify_session.cc',
        'browser/api/bluetooth_low_energy/bluetooth_low_energy_notify_session.h',
        'browser/api/bluetooth_low_energy/utils.cc',
        'browser/api/bluetooth_low_energy/utils.h',
        'browser/api/bluetooth_socket/bluetooth_api_socket.cc',
        'browser/api/bluetooth_socket/bluetooth_api_socket.h',
        'browser/api/bluetooth_socket/bluetooth_socket_api.cc',
        'browser/api/bluetooth_socket/bluetooth_socket_api.h',
        'browser/api/bluetooth_socket/bluetooth_socket_event_dispatcher.cc',
        'browser/api/bluetooth_socket/bluetooth_socket_event_dispatcher.h',
        'browser/api/capture_web_contents_function.cc',
        'browser/api/capture_web_contents_function.h',
        'browser/api/cast_channel/cast_auth_ica.cc',
        'browser/api/cast_channel/cast_auth_ica.h',
        'browser/api/cast_channel/cast_auth_util.cc',
        'browser/api/cast_channel/cast_auth_util.h',
        'browser/api/cast_channel/cast_channel_api.cc',
        'browser/api/cast_channel/cast_channel_api.h',
        'browser/api/cast_channel/cast_framer.cc',
        'browser/api/cast_channel/cast_framer.h',
        'browser/api/cast_channel/cast_message_util.cc',
        'browser/api/cast_channel/cast_message_util.h',
        'browser/api/cast_channel/cast_socket.cc',
        'browser/api/cast_channel/cast_socket.h',
        'browser/api/cast_channel/cast_framer.cc',
        'browser/api/cast_channel/cast_framer.h',
        'browser/api/cast_channel/cast_transport.h',
        'browser/api/cast_channel/cast_transport.cc',
        'browser/api/cast_channel/logger.cc',
        'browser/api/cast_channel/logger.h',
        'browser/api/cast_channel/logger_util.cc',
        'browser/api/cast_channel/logger_util.h',
        'browser/api/copresence_socket/copresence_socket_api.cc',
        'browser/api/copresence_socket/copresence_socket_api.h',
        'browser/api/copresence_socket/copresence_socket_resources.cc',
        'browser/api/copresence_socket/copresence_socket_resources.h',
        'browser/api/declarative/deduping_factory.h',
        'browser/api/declarative/declarative_api.cc',
        'browser/api/declarative/declarative_api.h',
        'browser/api/declarative/declarative_rule.h',
        'browser/api/declarative/rules_cache_delegate.cc',
        'browser/api/declarative/rules_cache_delegate.h',
        'browser/api/declarative/rules_registry.cc',
        'browser/api/declarative/rules_registry.h',
        'browser/api/declarative/rules_registry_service.cc',
        'browser/api/declarative/rules_registry_service.h',
        'browser/api/declarative/test_rules_registry.cc',
        'browser/api/declarative/test_rules_registry.h',
        'browser/api/declarative_content/content_rules_registry.h',
        'browser/api/declarative_webrequest/request_stage.cc',
        'browser/api/declarative_webrequest/request_stage.h',
        'browser/api/declarative_webrequest/webrequest_action.cc',
        'browser/api/declarative_webrequest/webrequest_action.h',
        'browser/api/declarative_webrequest/webrequest_condition.cc',
        'browser/api/declarative_webrequest/webrequest_condition.h',
        'browser/api/declarative_webrequest/webrequest_condition_attribute.cc',
        'browser/api/declarative_webrequest/webrequest_condition_attribute.h',
        'browser/api/declarative_webrequest/webrequest_constants.cc',
        'browser/api/declarative_webrequest/webrequest_constants.h',
        'browser/api/declarative_webrequest/webrequest_rules_registry.cc',
        'browser/api/declarative_webrequest/webrequest_rules_registry.h',
        'browser/api/device_permissions_manager.cc',
        'browser/api/device_permissions_manager.h',
        'browser/api/device_permissions_prompt.cc',
        'browser/api/device_permissions_prompt.h',
        'browser/api/dns/dns_api.cc',
        'browser/api/dns/dns_api.h',
        'browser/api/dns/host_resolver_wrapper.cc',
        'browser/api/dns/host_resolver_wrapper.h',
        'browser/api/execute_code_function.cc',
        'browser/api/execute_code_function.h',
        'browser/api/extensions_api_client.cc',
        'browser/api/extensions_api_client.h',
        'browser/api/guest_view/guest_view_internal_api.cc',
        'browser/api/guest_view/guest_view_internal_api.h',
        'browser/api/hid/hid_api.cc',
        'browser/api/hid/hid_api.h',
        'browser/api/hid/hid_connection_resource.cc',
        'browser/api/hid/hid_connection_resource.h',
        'browser/api/hid/hid_device_manager.cc',
        'browser/api/hid/hid_device_manager.h',
        'browser/api/management/management_api.cc',
        'browser/api/management/management_api.h',
        'browser/api/management/management_api_delegate.h',
        'browser/api/management/management_api_constants.cc',
        'browser/api/management/management_api_constants.h',
        'browser/api/messaging/native_message_host.cc',
        'browser/api/power/power_api.cc',
        'browser/api/power/power_api.h',
        'browser/api/power/power_api_manager.cc',
        'browser/api/power/power_api_manager.h',
        'browser/api/runtime/runtime_api.cc',
        'browser/api/runtime/runtime_api.h',
        'browser/api/runtime/runtime_api_delegate.cc',
        'browser/api/runtime/runtime_api_delegate.h',
        'browser/api/serial/serial_api.cc',
        'browser/api/serial/serial_api.h',
        'browser/api/serial/serial_connection.cc',
        'browser/api/serial/serial_connection.h',
        'browser/api/serial/serial_event_dispatcher.cc',
        'browser/api/serial/serial_event_dispatcher.h',
        'browser/api/socket/socket.cc',
        'browser/api/socket/socket.h',
        'browser/api/socket/socket_api.cc',
        'browser/api/socket/socket_api.h',
        'browser/api/socket/tcp_socket.cc',
        'browser/api/socket/tcp_socket.h',
        'browser/api/socket/tls_socket.cc',
        'browser/api/socket/tls_socket.h',
        'browser/api/socket/udp_socket.cc',
        'browser/api/socket/udp_socket.h',
        'browser/api/sockets_tcp/sockets_tcp_api.cc',
        'browser/api/sockets_tcp/sockets_tcp_api.h',
        'browser/api/sockets_tcp/tcp_socket_event_dispatcher.cc',
        'browser/api/sockets_tcp/tcp_socket_event_dispatcher.h',
        'browser/api/sockets_tcp_server/sockets_tcp_server_api.cc',
        'browser/api/sockets_tcp_server/sockets_tcp_server_api.h',
        'browser/api/sockets_tcp_server/tcp_server_socket_event_dispatcher.cc',
        'browser/api/sockets_tcp_server/tcp_server_socket_event_dispatcher.h',
        'browser/api/sockets_udp/sockets_udp_api.cc',
        'browser/api/sockets_udp/sockets_udp_api.h',
        'browser/api/sockets_udp/udp_socket_event_dispatcher.cc',
        'browser/api/sockets_udp/udp_socket_event_dispatcher.h',
        'browser/api/storage/leveldb_settings_storage_factory.cc',
        'browser/api/storage/leveldb_settings_storage_factory.h',
        'browser/api/storage/local_value_store_cache.cc',
        'browser/api/storage/local_value_store_cache.h',
        'browser/api/storage/settings_namespace.cc',
        'browser/api/storage/settings_namespace.h',
        'browser/api/storage/settings_observer.h',
        'browser/api/storage/settings_storage_factory.h',
        'browser/api/storage/settings_storage_quota_enforcer.cc',
        'browser/api/storage/settings_storage_quota_enforcer.h',
        'browser/api/storage/storage_api.cc',
        'browser/api/storage/storage_api.h',
        'browser/api/storage/storage_frontend.cc',
        'browser/api/storage/storage_frontend.h',
        'browser/api/storage/value_store_cache.cc',
        'browser/api/storage/value_store_cache.h',
        'browser/api/storage/weak_unlimited_settings_storage.cc',
        'browser/api/storage/weak_unlimited_settings_storage.h',
        'browser/api/system_cpu/cpu_info_provider.cc',
        'browser/api/system_cpu/cpu_info_provider.h',
        'browser/api/system_cpu/cpu_info_provider_linux.cc',
        'browser/api/system_cpu/cpu_info_provider_mac.cc',
        'browser/api/system_cpu/cpu_info_provider_win.cc',
        'browser/api/system_cpu/system_cpu_api.cc',
        'browser/api/system_cpu/system_cpu_api.h',
        'browser/api/system_display/display_info_provider.cc',
        'browser/api/system_display/display_info_provider.h',
        'browser/api/system_display/system_display_api.cc',
        'browser/api/system_display/system_display_api.h',
        'browser/api/system_info/system_info_api.cc',
        'browser/api/system_info/system_info_api.h',
        'browser/api/system_info/system_info_provider.cc',
        'browser/api/system_info/system_info_provider.h',
        'browser/api/system_memory/memory_info_provider.cc',
        'browser/api/system_memory/memory_info_provider.h',
        'browser/api/system_memory/system_memory_api.cc',
        'browser/api/system_memory/system_memory_api.h',
        'browser/api/system_network/system_network_api.cc',
        'browser/api/system_network/system_network_api.h',
        'browser/api/system_storage/storage_info_provider.cc',
        'browser/api/system_storage/storage_info_provider.h',
        'browser/api/system_storage/system_storage_api.cc',
        'browser/api/system_storage/system_storage_api.h',
        'browser/api/test/test_api.cc',
        'browser/api/test/test_api.h',
        'browser/api/usb/usb_api.cc',
        'browser/api/usb/usb_api.h',
        'browser/api/usb/usb_device_resource.cc',
        'browser/api/usb/usb_device_resource.h',
        'browser/api/virtual_keyboard_private/virtual_keyboard_private_api.cc',
        'browser/api/virtual_keyboard_private/virtual_keyboard_private_api.h',
        'browser/api/virtual_keyboard_private/virtual_keyboard_delegate.h',
        'browser/api/vpn_provider/vpn_provider_api.cc',
        'browser/api/vpn_provider/vpn_provider_api.h',
        'browser/api/web_request/form_data_parser.cc',
        'browser/api/web_request/form_data_parser.h',
        'browser/api/web_request/upload_data_presenter.cc',
        'browser/api/web_request/upload_data_presenter.h',
        'browser/api/web_request/web_request_api.cc',
        'browser/api/web_request/web_request_api.h',
        'browser/api/web_request/web_request_api_constants.cc',
        'browser/api/web_request/web_request_api_constants.h',
        'browser/api/web_request/web_request_api_helpers.cc',
        'browser/api/web_request/web_request_api_helpers.h',
        'browser/api/web_request/web_request_event_router_delegate.cc',
        'browser/api/web_request/web_request_event_router_delegate.h',
        'browser/api/web_request/web_request_permissions.cc',
        'browser/api/web_request/web_request_permissions.h',
        'browser/api/web_request/web_request_time_tracker.cc',
        'browser/api/web_request/web_request_time_tracker.h',
        'browser/api/web_view/web_view_internal_api.cc',
        'browser/api/web_view/web_view_internal_api.h',
        'browser/api/webcam_private/webcam_private_api.h',
        'browser/api/webcam_private/webcam_private_api_chromeos.cc',
        'browser/api_activity_monitor.h',
        'browser/app_sorting.h',
        'browser/app_window/app_delegate.h',
        'browser/app_window/app_web_contents_helper.cc',
        'browser/app_window/app_web_contents_helper.h',
        'browser/app_window/app_window.cc',
        'browser/app_window/app_window.h',
        'browser/app_window/app_window_contents.cc',
        'browser/app_window/app_window_contents.h',
        'browser/app_window/app_window_geometry_cache.cc',
        'browser/app_window/app_window_geometry_cache.h',
        'browser/app_window/app_window_registry.cc',
        'browser/app_window/app_window_registry.h',
        'browser/app_window/app_window_client.cc',
        'browser/app_window/app_window_client.h',
        'browser/app_window/native_app_window.h',
        'browser/app_window/size_constraints.cc',
        'browser/app_window/size_constraints.h',
        'browser/blacklist_state.h',
        'browser/blob_holder.cc',
        'browser/blob_holder.h',
        'browser/browser_context_keyed_api_factory.h',
        'browser/browser_context_keyed_service_factories.cc',
        'browser/browser_context_keyed_service_factories.h',
        'browser/component_extension_resource_manager.h',
        'browser/computed_hashes.cc',
        'browser/computed_hashes.h',
        'browser/content_hash_fetcher.cc',
        'browser/content_hash_fetcher.h',
        'browser/content_hash_reader.cc',
        'browser/content_hash_reader.h',
        'browser/content_hash_tree.cc',
        'browser/content_hash_tree.h',
        'browser/content_verifier.cc',
        'browser/content_verifier.h',
        'browser/content_verifier_delegate.h',
        'browser/content_verifier_io_data.cc',
        'browser/content_verifier_io_data.h',
        'browser/content_verify_job.cc',
        'browser/content_verify_job.h',
        'browser/error_map.cc',
        'browser/error_map.h',
        'browser/event_listener_map.cc',
        'browser/event_listener_map.h',
        'browser/event_router.cc',
        'browser/event_router.h',
        'browser/extension_host.cc',
        'browser/extension_host.h',
        'browser/extension_host_delegate.h',
        'browser/extension_error.cc',
        'browser/extension_error.h',
        'browser/extension_function.cc',
        'browser/extension_function.h',
        'browser/extension_function_dispatcher.cc',
        'browser/extension_function_dispatcher.h',
        'browser/extension_function_registry.cc',
        'browser/extension_function_registry.h',
        'browser/extension_function_util.cc',
        'browser/extension_function_util.h',
        'browser/extension_icon_image.cc',
        'browser/extension_icon_image.h',
        'browser/extension_message_filter.cc',
        'browser/extension_message_filter.h',
        'browser/extension_pref_store.cc',
        'browser/extension_pref_store.h',
        'browser/extension_pref_value_map.cc',
        'browser/extension_pref_value_map_factory.cc',
        'browser/extension_pref_value_map_factory.h',
        'browser/extension_pref_value_map.h',
        'browser/extension_prefs.cc',
        'browser/extension_prefs.h',
        'browser/extension_prefs_factory.cc',
        'browser/extension_prefs_factory.h',
        'browser/extension_prefs_observer.h',
        'browser/extension_prefs_scope.h',
        'browser/extension_protocols.cc',
        'browser/extension_protocols.h',
        'browser/extension_registry.cc',
        'browser/extension_registry.h',
        'browser/extension_registry_factory.cc',
        'browser/extension_registry_factory.h',
        'browser/extension_registry_observer.h',
        'browser/extension_scoped_prefs.h',
        'browser/extension_system.cc',
        'browser/extension_system.h',
        'browser/extension_system_provider.cc',
        'browser/extension_system_provider.h',
        'browser/extension_util.cc',
        'browser/extension_util.h',
        'browser/extension_web_contents_observer.cc',
        'browser/extension_web_contents_observer.h',
        'browser/extensions_browser_client.cc',
        'browser/extensions_browser_client.h',
        'browser/external_provider_interface.h',
        'browser/granted_file_entry.cc',
        'browser/granted_file_entry.h',
        'browser/guest_view/app_view/app_view_constants.cc',
        'browser/guest_view/app_view/app_view_constants.h',
        'browser/guest_view/app_view/app_view_guest.cc',
        'browser/guest_view/app_view/app_view_guest.h',
        'browser/guest_view/app_view/app_view_guest_delegate.cc',
        'browser/guest_view/app_view/app_view_guest_delegate.h',
        'browser/guest_view/extension_options/extension_options_constants.cc',
        'browser/guest_view/extension_options/extension_options_constants.h',
        'browser/guest_view/extension_options/extension_options_guest.cc',
        'browser/guest_view/extension_options/extension_options_guest.h',
        'browser/guest_view/extension_options/extension_options_guest_delegate.cc',
        'browser/guest_view/extension_options/extension_options_guest_delegate.h',
        'browser/guest_view/guest_view_base.cc',
        'browser/guest_view/guest_view_base.h',
        'browser/guest_view/guest_view_manager_factory.h',
        'browser/guest_view/guest_view_manager.cc',
        'browser/guest_view/guest_view_manager.h',
        'browser/guest_view/guest_view.h',
        'browser/guest_view/mime_handler_view/mime_handler_view_constants.cc',
        'browser/guest_view/mime_handler_view/mime_handler_view_constants.h',
        'browser/guest_view/mime_handler_view/mime_handler_view_guest_delegate.cc',
        'browser/guest_view/mime_handler_view/mime_handler_view_guest_delegate.h',
        'browser/guest_view/mime_handler_view/mime_handler_view_guest.cc',
        'browser/guest_view/mime_handler_view/mime_handler_view_guest.h',
        'browser/guest_view/web_view/javascript_dialog_helper.cc',
        'browser/guest_view/web_view/javascript_dialog_helper.h',
        'browser/guest_view/web_view/web_view_constants.cc',
        'browser/guest_view/web_view/web_view_constants.h',
        'browser/guest_view/web_view/web_view_find_helper.cc',
        'browser/guest_view/web_view/web_view_find_helper.h',
        'browser/guest_view/web_view/web_view_guest.cc',
        'browser/guest_view/web_view/web_view_guest.h',
        'browser/guest_view/web_view/web_view_guest_delegate.h',
        'browser/guest_view/web_view/web_view_permission_types.h',
        'browser/guest_view/web_view/web_view_permission_helper.cc',
        'browser/guest_view/web_view/web_view_permission_helper.h',
        'browser/guest_view/web_view/web_view_permission_helper_delegate.cc',
        'browser/guest_view/web_view/web_view_permission_helper_delegate.h',
        'browser/guest_view/web_view/web_view_renderer_state.cc',
        'browser/guest_view/web_view/web_view_renderer_state.h',
        'browser/image_loader.cc',
        'browser/image_loader.h',
        'browser/image_loader_factory.cc',
        'browser/image_loader_factory.h',
        'browser/image_util.cc',
        'browser/image_util.h',
        'browser/info_map.cc',
        'browser/info_map.h',
        'browser/install/crx_installer_error.h',
        'browser/install/extension_install_ui.cc',
        'browser/install/extension_install_ui.h',
        'browser/install_flag.h',
        'browser/file_highlighter.cc',
        'browser/file_highlighter.h',
        'browser/file_reader.cc',
        'browser/file_reader.h',
        'browser/lazy_background_task_queue.cc',
        'browser/lazy_background_task_queue.h',
        'browser/management_policy.cc',
        'browser/management_policy.h',
        'browser/mojo/keep_alive_impl.cc',
        'browser/mojo/keep_alive_impl.h',
        'browser/mojo/service_registration_manager.cc',
        'browser/mojo/service_registration_manager.h',
        'browser/mojo/stash_backend.cc',
        'browser/mojo/stash_backend.h',
        'browser/notification_types.h',
        'browser/null_app_sorting.cc',
        'browser/null_app_sorting.h',
        'browser/pref_names.cc',
        'browser/pref_names.h',
        'browser/process_manager.cc',
        'browser/process_manager.h',
        'browser/process_manager_delegate.h',
        'browser/process_manager_factory.cc',
        'browser/process_manager_factory.h',
        'browser/process_manager_observer.h',
        'browser/process_map.cc',
        'browser/process_map.h',
        'browser/process_map_factory.cc',
        'browser/process_map_factory.h',
        'browser/quota_service.cc',
        'browser/quota_service.h',
        'browser/renderer_startup_helper.cc',
        'browser/renderer_startup_helper.h',
        'browser/runtime_data.cc',
        'browser/runtime_data.h',
        'browser/script_execution_observer.h',
        'browser/script_executor.cc',
        'browser/script_executor.h',
        'browser/state_store.cc',
        'browser/state_store.h',
        'browser/suggest_permission_util.cc',
        'browser/suggest_permission_util.h',
        'browser/uninstall_reason.h',
        'browser/update_observer.h',
        'browser/updater/extension_cache.h',
        'browser/updater/extension_downloader.cc',
        'browser/updater/extension_downloader.h',
        'browser/updater/extension_downloader_delegate.cc',
        'browser/updater/extension_downloader_delegate.h',
        'browser/updater/manifest_fetch_data.cc',
        'browser/updater/manifest_fetch_data.h',
        'browser/updater/null_extension_cache.cc',
        'browser/updater/null_extension_cache.h',
        'browser/updater/request_queue.h',
        'browser/updater/request_queue_impl.h',
        'browser/updater/safe_manifest_parser.cc',
        'browser/updater/safe_manifest_parser.h',
        'browser/updater/update_service.cc',
        'browser/updater/update_service.h',
        'browser/updater/update_service_factory.cc',
        'browser/updater/update_service_factory.h',
        'browser/url_request_util.cc',
        'browser/url_request_util.h',
        'browser/value_store/leveldb_value_store.cc',
        'browser/value_store/leveldb_value_store.h',
        'browser/value_store/testing_value_store.cc',
        'browser/value_store/testing_value_store.h',
        'browser/value_store/value_store.cc',
        'browser/value_store/value_store.h',
        'browser/value_store/value_store_change.cc',
        'browser/value_store/value_store_change.h',
        'browser/value_store/value_store_frontend.cc',
        'browser/value_store/value_store_frontend.h',
        'browser/value_store/value_store_util.cc',
        'browser/value_store/value_store_util.h',
        'browser/verified_contents.cc',
        'browser/verified_contents.h',
        'browser/view_type_utils.cc',
        'browser/view_type_utils.h',
        'browser/warning_service.cc',
        'browser/warning_service.h',
        'browser/warning_service_factory.cc',
        'browser/warning_service_factory.h',
        'browser/warning_set.cc',
        'browser/warning_set.h',
      ],
      'conditions': [
        # This condition exists only because the extensions_common_constants
        # target is always built and thus this file gets evaluated by GYP.
        # This does not need to be replicated into extensions/browser/BUILD.gn.
        ['OS == "ios" or OS == "android"', {
          'dependencies!': [
            '../components/components.gyp:storage_monitor',
          ],
        }],
        ['use_openssl==1', {
          'sources': [
            'browser/api/cast_channel/cast_auth_util_openssl.cc',
          ],
          'dependencies': [
            '../third_party/boringssl/boringssl.gyp:boringssl',
          ],
        }, {
          'sources': [
            # cast_auth_util_nss.cc uses NSS functions.
            'browser/api/cast_channel/cast_auth_util_nss.cc',
          ],
          'conditions': [
            ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
              'dependencies': [
                '../build/linux/system.gyp:ssl',
              ],
            }],
            ['OS == "mac" or OS == "ios" or OS == "win"', {
              'dependencies': [
                '../third_party/nss/nss.gyp:nspr',
                '../third_party/nss/nss.gyp:nss',
              ],
            }],
          ],
        }],
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
    },
    {
      # GN version: //extensions/renderer
      'target_name': 'extensions_renderer',
      'type': 'static_library',
      'dependencies': [
        'extensions_resources.gyp:extensions_resources',
        '../content/content.gyp:content_resources',
        '../gin/gin.gyp:gin',
        '../mojo/public/mojo_public.gyp:mojo_js_bindings',
        '../third_party/WebKit/public/blink.gyp:blink',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'renderer/activity_log_converter_strategy.cc',
        'renderer/activity_log_converter_strategy.h',
        'renderer/api/automation/automation_api_helper.cc',
        'renderer/api/automation/automation_api_helper.h',
        'renderer/api_activity_logger.cc',
        'renderer/api_activity_logger.h',
        'renderer/api_definitions_natives.cc',
        'renderer/api_definitions_natives.h',
        'renderer/app_runtime_custom_bindings.cc',
        'renderer/app_runtime_custom_bindings.h',
        'renderer/app_window_custom_bindings.cc',
        'renderer/app_window_custom_bindings.h',
        'renderer/binding_generating_native_handler.cc',
        'renderer/binding_generating_native_handler.h',
        'renderer/blob_native_handler.cc',
        'renderer/blob_native_handler.h',
        'renderer/console.cc',
        'renderer/console.h',
        'renderer/content_watcher.cc',
        'renderer/content_watcher.h',
        'renderer/context_menus_custom_bindings.cc',
        'renderer/context_menus_custom_bindings.h',
        'renderer/css_native_handler.cc',
        'renderer/css_native_handler.h',
        'renderer/default_dispatcher_delegate.cc',
        'renderer/default_dispatcher_delegate.h',
        'renderer/dispatcher.cc',
        'renderer/dispatcher.h',
        'renderer/dispatcher_delegate.h',
        'renderer/document_custom_bindings.cc',
        'renderer/document_custom_bindings.h',
        'renderer/dom_activity_logger.cc',
        'renderer/dom_activity_logger.h',
        'renderer/event_bindings.cc',
        'renderer/event_bindings.h',
        'renderer/extension_groups.h',
        'renderer/extension_helper.cc',
        'renderer/extension_helper.h',
        'renderer/extensions_render_frame_observer.cc',
        'renderer/extensions_render_frame_observer.h',
        'renderer/extensions_renderer_client.cc',
        'renderer/extensions_renderer_client.h',
        'renderer/file_system_natives.cc',
        'renderer/file_system_natives.h',
        'renderer/guest_view/extensions_guest_view_container.cc',
        'renderer/guest_view/extensions_guest_view_container.h',
        'renderer/guest_view/guest_view_container.cc',
        'renderer/guest_view/guest_view_container.h',
        'renderer/guest_view/guest_view_internal_custom_bindings.cc',
        'renderer/guest_view/guest_view_internal_custom_bindings.h',
        'renderer/guest_view/mime_handler_view_container.cc',
        'renderer/guest_view/mime_handler_view_container.h',
        'renderer/i18n_custom_bindings.cc',
        'renderer/i18n_custom_bindings.h',
        'renderer/id_generator_custom_bindings.cc',
        'renderer/id_generator_custom_bindings.h',
        'renderer/lazy_background_page_native_handler.cc',
        'renderer/lazy_background_page_native_handler.h',
        'renderer/logging_native_handler.cc',
        'renderer/logging_native_handler.h',
        'renderer/messaging_bindings.cc',
        'renderer/messaging_bindings.h',
        'renderer/module_system.cc',
        'renderer/module_system.h',
        'renderer/native_handler.cc',
        'renderer/native_handler.h',
        'renderer/object_backed_native_handler.cc',
        'renderer/object_backed_native_handler.h',
        'renderer/print_native_handler.cc',
        'renderer/print_native_handler.h',
        'renderer/process_info_native_handler.cc',
        'renderer/process_info_native_handler.h',
        'renderer/programmatic_script_injector.cc',
        'renderer/programmatic_script_injector.h',
        'renderer/render_view_observer_natives.cc',
        'renderer/request_sender.cc',
        'renderer/request_sender.h',
        'renderer/resource_bundle_source_map.cc',
        'renderer/resource_bundle_source_map.h',
        'renderer/resources/app_runtime_custom_bindings.js',
        'renderer/resources/app_window_custom_bindings.js',
        'renderer/resources/binding.js',
        'renderer/resources/context_menus_custom_bindings.js',
        'renderer/resources/declarative_webrequest_custom_bindings.js',
        'renderer/resources/entry_id_manager.js',
        'renderer/resources/event.js',
        'renderer/resources/extension.css',
        'renderer/resources/extension_custom_bindings.js',
        'renderer/resources/extension_fonts.css',
        'renderer/resources/greasemonkey_api.js',
        'renderer/resources/i18n_custom_bindings.js',
        'renderer/resources/image_util.js',
        'renderer/resources/json_schema.js',
        'renderer/resources/last_error.js',
        'renderer/resources/messaging.js',
        'renderer/resources/messaging_utils.js',
        'renderer/resources/permissions_custom_bindings.js',
        'renderer/resources/platform_app.css',
        'renderer/resources/platform_app.js',
        'renderer/resources/runtime_custom_bindings.js',
        'renderer/resources/schema_utils.js',
        'renderer/resources/send_request.js',
        'renderer/resources/set_icon.js',
        'renderer/resources/storage_area.js',
        'renderer/resources/test_custom_bindings.js',
        'renderer/resources/uncaught_exception_handler.js',
        'renderer/resources/unload_event.js',
        'renderer/resources/utils.js',
        'renderer/resources/extensions/web_view.js',
        'renderer/resources/extensions/web_view_events.js',
        'renderer/resources/extensions/web_view_experimental.js',
        'renderer/resources/web_request_custom_bindings.js',
        'renderer/resources/web_request_internal_custom_bindings.js',
        'renderer/runtime_custom_bindings.cc',
        'renderer/runtime_custom_bindings.h',
        'renderer/safe_builtins.cc',
        'renderer/safe_builtins.h',
        'renderer/scoped_persistent.h',
        'renderer/script_context.cc',
        'renderer/script_context.h',
        'renderer/script_context_set.cc',
        'renderer/script_context_set.h',
        'renderer/script_injection.cc',
        'renderer/script_injection.h',
        'renderer/script_injection_manager.cc',
        'renderer/script_injection_manager.h',
        'renderer/script_injector.h',
        'renderer/scripts_run_info.cc',
        'renderer/scripts_run_info.h',
        'renderer/send_request_natives.cc',
        'renderer/send_request_natives.h',
        'renderer/set_icon_natives.cc',
        'renderer/set_icon_natives.h',
        'renderer/static_v8_external_one_byte_string_resource.cc',
        'renderer/static_v8_external_one_byte_string_resource.h',
        'renderer/test_features_native_handler.cc',
        'renderer/test_features_native_handler.h',
        'renderer/user_gestures_native_handler.cc',
        'renderer/user_gestures_native_handler.h',
        'renderer/user_script_injector.cc',
        'renderer/user_script_injector.h',
        'renderer/user_script_set.cc',
        'renderer/user_script_set.h',
        'renderer/user_script_set_manager.cc',
        'renderer/user_script_set_manager.h',
        'renderer/utils_native_handler.cc',
        'renderer/utils_native_handler.h',
        'renderer/v8_context_native_handler.cc',
        'renderer/v8_context_native_handler.h',
        'renderer/v8_schema_registry.cc',
        'renderer/v8_schema_registry.h',
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
    },
    {
      # GN version: //extensions/utility
      'target_name': 'extensions_utility',
      'type': 'static_library',
      'dependencies': [
        '../content/content.gyp:content_utility',
        'extensions_common',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'utility/utility_handler.cc',
        'utility/utility_handler.h',
      ],
    },
    {
      # GN version: //extensions:test_support
      'target_name': 'extensions_test_support',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../components/components.gyp:user_prefs',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../net/net.gyp:net_test_support',
        '../testing/gtest.gyp:gtest',
        'browser/api/api_registration.gyp:extensions_api_registration',
        'common/api/api.gyp:extensions_api',
        'extensions_browser',
        'extensions_common',
        'extensions_resources.gyp:extensions_resources',
      ],
      'include_dirs': [
        '..',
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'browser/api/dns/mock_host_resolver_creator.cc',
        'browser/api/dns/mock_host_resolver_creator.h',
        'browser/api/storage/settings_test_util.cc',
        'browser/api/storage/settings_test_util.h',
        'browser/api_test_utils.cc',
        'browser/api_test_utils.h',
        'browser/api_unittest.cc',
        'browser/api_unittest.h',
        'browser/extension_error_test_util.cc',
        'browser/extension_error_test_util.h',
        'browser/extensions_test.cc',
        'browser/extensions_test.h',
        'browser/guest_view/test_guest_view_manager.cc',
        'browser/guest_view/test_guest_view_manager.h',
        'browser/mock_extension_system.cc',
        'browser/mock_extension_system.h',
        'browser/test_extension_registry_observer.cc',
        'browser/test_extension_registry_observer.h',
        'browser/test_extensions_browser_client.cc',
        'browser/test_extensions_browser_client.h',
        'browser/test_management_policy.cc',
        'browser/test_management_policy.h',
        'browser/test_runtime_api_delegate.cc',
        'browser/test_runtime_api_delegate.h',
        'common/extension_builder.cc',
        'common/extension_builder.h',
        'common/manifest_test.cc',
        'common/manifest_test.h',
        'common/test_util.cc',
        'common/test_util.h',
        'common/value_builder.cc',
        'common/value_builder.h',
        'renderer/test_extensions_renderer_client.cc',
        'renderer/test_extensions_renderer_client.h',
        'test/extension_test_message_listener.cc',
        'test/extension_test_message_listener.h',
        'test/result_catcher.cc',
        'test/result_catcher.h',
        'test/test_extensions_client.cc',
        'test/test_extensions_client.h',
        'test/test_permission_message_provider.cc',
        'test/test_permission_message_provider.h',
        'test/test_service_registration_manager.cc',
        'test/test_service_registration_manager.h',
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
    },
    {
      # The pak file generated by this target is intended to be shared by
      # both shell and test targets. It was combined because it might help a
      # little bit with build time by avoiding a repack step (one instead of
      # two).
      'target_name': 'extensions_shell_and_test_pak',
      'type': 'none',
      'dependencies': [
        '../content/browser/devtools/devtools_resources.gyp:devtools_resources',
        '../content/content.gyp:content_resources',
        '../content/content_shell_and_tests.gyp:content_shell_resources',
        '../third_party/WebKit/public/blink_resources.gyp:blink_resources',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        'extensions_resources.gyp:extensions_resources',
        'extensions_strings.gyp:extensions_strings',
        'shell/app_shell_resources.gyp:app_shell_resources',
      ],
      'actions': [
        {
          'action_name': 'repack_extensions_shell_and_test_pak',
          'variables': {
            'pak_inputs': [
              '<(SHARED_INTERMEDIATE_DIR)/blink/public/resources/blink_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/content/app/strings/content_strings_en-US.pak',
              '<(SHARED_INTERMEDIATE_DIR)/content/content_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/content/shell_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/extensions/extensions_browser_resources_100_percent.pak',
              '<(SHARED_INTERMEDIATE_DIR)/extensions/extensions_renderer_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/extensions/extensions_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/extensions/shell/app_shell_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/extensions/strings/extensions_strings_en-US.pak',
              '<(SHARED_INTERMEDIATE_DIR)/ui/resources/ui_resources_100_percent.pak',
              '<(SHARED_INTERMEDIATE_DIR)/ui/strings/app_locale_settings_en-US.pak',
              '<(SHARED_INTERMEDIATE_DIR)/ui/strings/ui_strings_en-US.pak',
              '<(SHARED_INTERMEDIATE_DIR)/webkit/devtools_resources.pak',
            ],
            'pak_output': '<(PRODUCT_DIR)/extensions_shell_and_test.pak',
          },
          'includes': [ '../build/repack_action.gypi' ],
        },
      ],
    },
    {
      'target_name': 'extensions_unittests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_prefs_test_support',
        '../base/base.gyp:test_support_base',
        '../components/components.gyp:keyed_service_content',
        '../components/components.gyp:user_prefs',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth_mocks',
        '../device/serial/serial.gyp:device_serial',
        '../device/serial/serial.gyp:device_serial_test_util',
        '../mojo/edk/mojo_edk.gyp:mojo_js_lib',
        '../mojo/edk/mojo_edk.gyp:mojo_system_impl',
        '../mojo/mojo_base.gyp:mojo_environment_chromium',
        '../mojo/public/mojo_public.gyp:mojo_cpp_bindings',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        'common/api/api.gyp:cast_channel_proto',
        'extensions_common',
        'extensions_renderer',
        'extensions_resources.gyp:extensions_resources',
        'extensions_shell_and_test_pak',
        'extensions_strings.gyp:extensions_strings',
        'extensions_test_support',
      ],
      # Needed for third_party libraries like leveldb.
      'include_dirs': [
        '..',
      ],
      'sources': [
        'browser/api/api_resource_manager_unittest.cc',
        'browser/api/bluetooth/bluetooth_event_router_unittest.cc',
        'browser/api/cast_channel/cast_auth_ica_unittest.cc',
        'browser/api/cast_channel/cast_auth_util_unittest.cc',
        'browser/api/cast_channel/cast_channel_api_unittest.cc',
        'browser/api/cast_channel/cast_framer_unittest.cc',
        'browser/api/cast_channel/cast_socket_unittest.cc',
        'browser/api/cast_channel/cast_transport_unittest.cc',
        'browser/api/cast_channel/logger_unittest.cc',
        'browser/api/declarative/declarative_rule_unittest.cc',
        'browser/api/declarative/deduping_factory_unittest.cc',
        'browser/api/declarative/rules_registry_unittest.cc',
        'browser/api/declarative_webrequest/webrequest_condition_unittest.cc',
        'browser/api/declarative_webrequest/webrequest_condition_attribute_unittest.cc',
        'browser/api/power/power_api_unittest.cc',
        'browser/api/sockets_tcp/sockets_tcp_api_unittest.cc',
        'browser/api/storage/settings_quota_unittest.cc',
        'browser/api/storage/storage_api_unittest.cc',
        'browser/api/storage/storage_frontend_unittest.cc',
        'browser/api/web_request/form_data_parser_unittest.cc',
        'browser/api/web_request/upload_data_presenter_unittest.cc',
        'browser/api/web_request/web_request_time_tracker_unittest.cc',
        'browser/app_window/app_window_geometry_cache_unittest.cc',
        'browser/computed_hashes_unittest.cc',
        'browser/content_hash_tree_unittest.cc',
        'browser/event_listener_map_unittest.cc',
        'browser/event_router_unittest.cc',
        'browser/error_map_unittest.cc',
        'browser/extension_icon_image_unittest.cc',
        'browser/extension_pref_value_map_unittest.cc',
        'browser/extension_registry_unittest.cc',
        'browser/file_highlighter_unittest.cc',
        'browser/file_reader_unittest.cc',
        'browser/guest_view/guest_view_manager_unittest.cc',
        'browser/image_loader_unittest.cc',
        'browser/image_util_unittest.cc',
        'browser/info_map_unittest.cc',
        'browser/lazy_background_task_queue_unittest.cc',
        'browser/management_policy_unittest.cc',
        'browser/mojo/keep_alive_impl_unittest.cc',
        'browser/mojo/stash_backend_unittest.cc',
        'browser/process_manager_unittest.cc',
        'browser/process_map_unittest.cc',
        'browser/quota_service_unittest.cc',
        'browser/runtime_data_unittest.cc',
        'browser/value_store/leveldb_value_store_unittest.cc',
        'browser/value_store/testing_value_store_unittest.cc',
        'browser/value_store/value_store_change_unittest.cc',
        'browser/value_store/value_store_frontend_unittest.cc',
        'browser/value_store/value_store_unittest.cc',
        'browser/value_store/value_store_unittest.h',
        'browser/verified_contents_unittest.cc',
        'browser/warning_service_unittest.cc',
        'common/api/sockets/sockets_manifest_permission_unittest.cc',
        'common/csp_validator_unittest.cc',
        'common/event_filter_unittest.cc',
        'common/extension_l10n_util_unittest.cc',
        'common/extension_resource_unittest.cc',
        'common/extension_set_unittest.cc',
        'common/features/base_feature_provider_unittest.cc',
        'common/features/complex_feature_unittest.cc',
        'common/features/simple_feature_unittest.cc',
        'common/file_util_unittest.cc',
        'common/manifest_handler_unittest.cc',
        'common/manifest_handlers/externally_connectable_unittest.cc',
        'common/manifest_handlers/file_handler_manifest_unittest.cc',
        'common/manifest_handlers/oauth2_manifest_unittest.cc',
        'common/manifest_handlers/shared_module_manifest_unittest.cc',
        'common/message_bundle_unittest.cc',
        'common/one_shot_event_unittest.cc',
        'common/permissions/api_permission_set_unittest.cc',
        'common/permissions/manifest_permission_set_unittest.cc',
        'common/permissions/socket_permission_unittest.cc',
        'common/permissions/usb_device_permission_unittest.cc',
        'common/stack_frame_unittest.cc',
        'common/url_pattern_set_unittest.cc',
        'common/url_pattern_unittest.cc',
        'common/user_script_unittest.cc',
        'renderer/activity_log_converter_strategy_unittest.cc',
        'renderer/api/serial/data_receiver_unittest.cc',
        'renderer/api/serial/data_sender_unittest.cc',
        'renderer/api/serial/serial_api_unittest.cc',
        'renderer/api_test_base.cc',
        'renderer/api_test_base.h',
        'renderer/api_test_base_unittest.cc',
        'renderer/event_unittest.cc',
        'renderer/json_schema_unittest.cc',
        'renderer/mojo/keep_alive_client_unittest.cc',
        'renderer/messaging_utils_unittest.cc',
        'renderer/module_system_test.cc',
        'renderer/module_system_test.h',
        'renderer/module_system_unittest.cc',
        'renderer/safe_builtins_unittest.cc',
        'renderer/script_context_set_unittest.cc',
        'renderer/utils_unittest.cc',
        'test/extensions_unittests_main.cc',
      ],
      # Disable c4267 warnings until we fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
      'conditions': [
        ['OS=="win" and win_use_allocator_shim==1', {
          'dependencies': [
            '../base/allocator/allocator.gyp:allocator',
          ],
        }],
      ],
    },
  ]
}
