// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by {{code_generator}}. DO NOT MODIFY!

#include "config.h"
#include "{{v8_class}}.h"

{% for filename in cpp_includes if filename != '%s.h' % v8_class %}
#include "{{filename}}"
{% endfor %}

namespace blink {

void {{v8_class}}::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, {{cpp_class}}& impl, ExceptionState& exceptionState)
{
    if (isUndefinedOrNull(v8Value))
        return;
    if (!v8Value->IsObject()) {
        exceptionState.throwTypeError("cannot convert to dictionary.");
        return;
    }

    // FIXME: Do not use Dictionary and DictionaryHelper
    // https://crbug.com/321462
    Dictionary dictionary(v8Value, isolate);
    // FIXME: Remove this v8::TryCatch once the code is switched from
    // Dictionary/DictionaryHelper to something that uses ExceptionState.
    v8::TryCatch block;
    {% for member in members %}
    {{member.cpp_type}} {{member.name}};
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "{{member.name}}", {{member.name}})) {
    {% if member.enum_validation_expression %}
        String string = {{member.name}};
        if (!({{member.enum_validation_expression}})) {
            exceptionState.throwTypeError("member {{member.name}} ('" + string + "') is not a valid enum value.");
            return;
        }
    {% elif member.is_object %}
        if (!{{member.name}}.isObject()) {
            exceptionState.throwTypeError("member {{member.name}} is not an object.");
            return;
        }
    {% endif %}
        impl.{{member.setter_name}}({{member.name}});
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    {% endfor %}
}

v8::Handle<v8::Value> toV8({{cpp_class}}& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    v8::Handle<v8::Object> v8Object = v8::Object::New(isolate);
    {% for member in members %}
    if (impl.{{member.has_method_name}}()) {
        {% if member.is_object %}
        ASSERT(impl.{{member.cpp_name}}().isObject());
        {% endif %}
        v8Object->Set(v8String(isolate, "{{member.name}}"), {{member.cpp_value_to_v8_value}});
    {% if member.v8_default_value %}
    } else {
        v8Object->Set(v8String(isolate, "{{member.name}}"), {{member.v8_default_value}});
    {% endif %}
    }

    {% endfor %}
    return v8Object;
}

} // namespace blink
