// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_VIEWS_EVENT_MONITOR_H_
#define UI_VIEWS_EVENT_MONITOR_H_

#include "ui/gfx/geometry/point.h"
#include "ui/views/views_export.h"

namespace ui {
class EventHandler;
}

namespace views {

// RAII-style class that forwards events posted to the application to
// |event_handler| before they are dispatched.
class VIEWS_EXPORT EventMonitor {
 public:
  virtual ~EventMonitor() {}

  static EventMonitor* Create(ui::EventHandler* event_handler);

  // Returns the last mouse location seen in a mouse event in screen
  // coordinates.
  static gfx::Point GetLastMouseLocation();
};

}  // namespace views

#endif  // UI_VIEWS_EVENT_MONITOR_H_
