// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.system.display.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

// This was modified to add 'chrome.system = {};'

/** @fileoverview Externs generated from namespace: system.display */

/** @const */
chrome.system = {};

/**
 * @const
 */
chrome.system.display = {};

/**
 * @typedef {{
 *   left: number,
 *   top: number,
 *   width: number,
 *   height: number
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-Bounds
 */
chrome.system.display.Bounds;

/**
 * @typedef {{
 *   left: number,
 *   top: number,
 *   right: number,
 *   bottom: number
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-Insets
 */
chrome.system.display.Insets;

/**
 * @typedef {{
 *   width: number,
 *   height: number,
 *   widthInNativePixels: number,
 *   heightInNativePixels: number,
 *   uiScale: number,
 *   deviceScaleFactor: number,
 *   isNative: boolean,
 *   isSelected: boolean
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-DisplayMode
 */
chrome.system.display.DisplayMode;

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/system.display#type-LayoutPosition
 */
chrome.system.display.LayoutPosition = {
  TOP: 'top',
  RIGHT: 'right',
  BOTTOM: 'bottom',
  LEFT: 'left',
};

/**
 * @typedef {{
 *   id: string,
 *   parentId: string,
 *   position: !chrome.system.display.LayoutPosition,
 *   offset: number
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-DisplayLayout
 */
chrome.system.display.DisplayLayout;

/**
 * @typedef {{
 *   id: string,
 *   name: string,
 *   mirroringSourceId: string,
 *   isPrimary: boolean,
 *   isInternal: boolean,
 *   isEnabled: boolean,
 *   dpiX: number,
 *   dpiY: number,
 *   rotation: number,
 *   bounds: !chrome.system.display.Bounds,
 *   overscan: !chrome.system.display.Insets,
 *   workArea: !chrome.system.display.Bounds,
 *   modes: !Array<!chrome.system.display.DisplayMode>
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-DisplayUnitInfo
 */
chrome.system.display.DisplayUnitInfo;

/**
 * @typedef {{
 *   mirroringSourceId: (string|undefined),
 *   isPrimary: (boolean|undefined),
 *   overscan: (!chrome.system.display.Insets|undefined),
 *   rotation: (number|undefined),
 *   boundsOriginX: (number|undefined),
 *   boundsOriginY: (number|undefined),
 *   displayMode: (!chrome.system.display.DisplayMode|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/system.display#type-DisplayProperties
 */
chrome.system.display.DisplayProperties;

/**
 * Get the information of all attached display devices.
 * @param {function(!Array<!chrome.system.display.DisplayUnitInfo>):void}
 *     callback
 * @see https://developer.chrome.com/extensions/system.display#method-getInfo
 */
chrome.system.display.getInfo = function(callback) {};

/**
 * Get the layout info for all displays. NOTE: This is only available to Chrome
 * OS Kiosk apps and Web UI.
 * @param {function(!Array<!chrome.system.display.DisplayLayout>):void} callback
 * @see https://developer.chrome.com/extensions/system.display#method-getDisplayLayout
 */
chrome.system.display.getDisplayLayout = function(callback) {};

/**
 * Updates the properties for the display specified by |id|, according to the
 * information provided in |info|. On failure, $(ref:runtime.lastError) will be
 * set. NOTE: This is only available to Chrome OS Kiosk apps and Web UI.
 * @param {string} id The display's unique identifier.
 * @param {!chrome.system.display.DisplayProperties} info The information about
 *     display properties that should be changed.     A property will be changed
 *     only if a new value for it is specified in     |info|.
 * @param {function():void=} callback Empty function called when the function
 *     finishes. To find out     whether the function succeeded,
 *     $(ref:runtime.lastError) should be     queried.
 * @see https://developer.chrome.com/extensions/system.display#method-setDisplayProperties
 */
chrome.system.display.setDisplayProperties = function(id, info, callback) {};

/**
 * Set the layout for all displays. Any display not included will use the
 * default layout. If a layout would overlap or be otherwise invalid it will be
 * adjusted to a valid layout. After layout is resolved, an onDisplayChanged
 * event will be triggered.
 * @param {!Array<!chrome.system.display.DisplayLayout>} layouts
 * @see https://developer.chrome.com/extensions/system.display#method-setDisplayLayout
 */
chrome.system.display.setDisplayLayout = function(layouts) {};

/**
 * Enables/disables the unified desktop feature. Note that this simply enables
 * the feature, but will not change the actual desktop mode. (That is, if the
 * desktop is in mirror mode, it will stay in mirror mode) NOTE: This is only
 * available to Chrome OS Kiosk apps and Web UI.
 * @param {boolean} enabled True if unified desktop should be enabled.
 * @see https://developer.chrome.com/extensions/system.display#method-enableUnifiedDesktop
 */
chrome.system.display.enableUnifiedDesktop = function(enabled) {};

/**
 * Starts overscan calibration for a display. This will show an overlay on the
 * screen indicating the current overscan insets. If overscan calibration for
 * display |id| is in progress this will reset calibration.
 * @param {string} id The display's unique identifier.
 * @see https://developer.chrome.com/extensions/system.display#method-overscanCalibrationStart
 */
chrome.system.display.overscanCalibrationStart = function(id) {};

/**
 * Adjusts the current overscan insets for a display. Typically this should
 * etiher move the display along an axis (e.g. left+right have the same value)
 * or scale it along an axis (e.g. top+bottom have opposite values). Each Adjust
 * call is cumulative with previous calls since Start.
 * @param {string} id The display's unique identifier.
 * @param {!chrome.system.display.Insets} delta The amount to change the
 *     overscan insets.
 * @see https://developer.chrome.com/extensions/system.display#method-overscanCalibrationAdjust
 */
chrome.system.display.overscanCalibrationAdjust = function(id, delta) {};

/**
 * Resets the overscan insets for a display to the last saved value (i.e before
 * Start was called).
 * @param {string} id The display's unique identifier.
 * @see https://developer.chrome.com/extensions/system.display#method-overscanCalibrationReset
 */
chrome.system.display.overscanCalibrationReset = function(id) {};

/**
 * Complete overscan adjustments for a display  by saving the current values and
 * hiding the overlay.
 * @param {string} id The display's unique identifier.
 * @see https://developer.chrome.com/extensions/system.display#method-overscanCalibrationComplete
 */
chrome.system.display.overscanCalibrationComplete = function(id) {};

/**
 * Fired when anything changes to the display configuration.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/system.display#event-onDisplayChanged
 */
chrome.system.display.onDisplayChanged;
