
if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 Studio3D module requires at least CMake version 3.1.0")
endif()

get_filename_component(_qt5Studio3D_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt5Studio3D_VERSION instead.
set(Qt5Studio3D_VERSION_STRING 2.8.0)

set(Qt5Studio3D_LIBRARIES Qt5::Studio3D)

macro(_qt5_Studio3D_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::Studio3D\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()

macro(_populate_Studio3D_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5::Studio3D APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt5Studio3D_install_prefix}/bin/${LIB_LOCATION}")
    _qt5_Studio3D_check_file_exists(${imported_location})
    set_target_properties(Qt5::Studio3D PROPERTIES
        "INTERFACE_LINK_LIBRARIES" "${_Qt5Studio3D_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt5Studio3D_LIB_DEPENDENCIES}"
    )

    set(imported_implib "${_qt5Studio3D_install_prefix}/lib/${IMPLIB_LOCATION}")
    _qt5_Studio3D_check_file_exists(${imported_implib})
    if(NOT "${IMPLIB_LOCATION}" STREQUAL "")
        set_target_properties(Qt5::Studio3D PROPERTIES
        "IMPORTED_IMPLIB_${Configuration}" ${imported_implib}
        )
    endif()
endmacro()

if (NOT TARGET Qt5::Studio3D)

    set(_Qt5Studio3D_OWN_INCLUDE_DIRS "${_qt5Studio3D_install_prefix}/include/" "${_qt5Studio3D_install_prefix}/include/QtStudio3D")
    set(Qt5Studio3D_PRIVATE_INCLUDE_DIRS
        "${_qt5Studio3D_install_prefix}/include/QtStudio3D/2.8.0"
        "${_qt5Studio3D_install_prefix}/include/QtStudio3D/2.8.0/QtStudio3D"
    )

    foreach(_dir ${_Qt5Studio3D_OWN_INCLUDE_DIRS})
        _qt5_Studio3D_check_file_exists(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt5Studio3D_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt5Studio3D_PRIVATE_INCLUDE_DIRS})
            _qt5_Studio3D_check_file_exists(${_dir})
        endforeach()
    endif()

    set(Qt5Studio3D_INCLUDE_DIRS ${_Qt5Studio3D_OWN_INCLUDE_DIRS})

    set(Qt5Studio3D_DEFINITIONS -DQT_STUDIO3D_LIB)
    set(Qt5Studio3D_COMPILE_DEFINITIONS QT_STUDIO3D_LIB)
    set(_Qt5Studio3D_MODULE_DEPENDENCIES "OpenGLExtensions;OpenGL;Widgets;Multimedia;Gui;Qml;Core")


    set(Qt5Studio3D_OWN_PRIVATE_INCLUDE_DIRS ${Qt5Studio3D_PRIVATE_INCLUDE_DIRS})

    set(_Qt5Studio3D_FIND_DEPENDENCIES_REQUIRED)
    if (Qt5Studio3D_FIND_REQUIRED)
        set(_Qt5Studio3D_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5Studio3D_FIND_DEPENDENCIES_QUIET)
    if (Qt5Studio3D_FIND_QUIETLY)
        set(_Qt5Studio3D_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5Studio3D_FIND_VERSION_EXACT)
    if (Qt5Studio3D_FIND_VERSION_EXACT)
        set(_Qt5Studio3D_FIND_VERSION_EXACT EXACT)
    endif()

    set(Qt5Studio3D_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt5Studio3D_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                2.8.0 ${_Qt5Studio3D_FIND_VERSION_EXACT}
                ${_Qt5Studio3D_DEPENDENCIES_FIND_QUIET}
                ${_Qt5Studio3D_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt5Studio3D_FOUND False)
            return()
        endif()

        list(APPEND Qt5Studio3D_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt5Studio3D_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt5Studio3D_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt5Studio3D_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt5Studio3D_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt5Studio3D_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5Studio3D_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5Studio3D_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5Studio3D_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5Studio3D_EXECUTABLE_COMPILE_FLAGS)

    set(_Qt5Studio3D_LIB_DEPENDENCIES "Qt5::OpenGLExtensions;Qt5::OpenGL;Qt5::Widgets;Qt5::Multimedia;Qt5::Gui;Qt5::Qml;Qt5::Core")


    add_library(Qt5::Studio3D SHARED IMPORTED)

    set_property(TARGET Qt5::Studio3D PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5Studio3D_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::Studio3D PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_STUDIO3D_LIB)

    set_property(TARGET Qt5::Studio3D PROPERTY INTERFACE_QT_ENABLED_FEATURES )
    set_property(TARGET Qt5::Studio3D PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    set(_Qt5Studio3D_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5Studio3D_PRIVATE_DIR ${Qt5Studio3D_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5Studio3D_PRIVATE_DIR})
            set(_Qt5Studio3D_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5Studio3D_PRIVATE_DIRS_EXIST)
        add_library(Qt5::Studio3DPrivate INTERFACE IMPORTED)
        set_property(TARGET Qt5::Studio3DPrivate PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${Qt5Studio3D_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5Studio3D_PRIVATEDEPS)
        foreach(dep ${_Qt5Studio3D_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5Studio3D_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET Qt5::Studio3DPrivate PROPERTY
            INTERFACE_LINK_LIBRARIES Qt5::Studio3D ${_Qt5Studio3D_PRIVATEDEPS}
        )
    endif()

    _populate_Studio3D_target_properties(RELEASE "Qt5Studio3D.dll" "libQt5Studio3D.a" )



    _populate_Studio3D_target_properties(DEBUG "Qt5Studio3Dd.dll" "libQt5Studio3Dd.a" )



    file(GLOB pluginTargets "${CMAKE_CURRENT_LIST_DIR}/Qt5Studio3D_*Plugin.cmake")

    macro(_populate_Studio3D_plugin_properties Plugin Configuration PLUGIN_LOCATION)
        set_property(TARGET Qt5::${Plugin} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

        set(imported_location "${_qt5Studio3D_install_prefix}/plugins/${PLUGIN_LOCATION}")
        _qt5_Studio3D_check_file_exists(${imported_location})
        set_target_properties(Qt5::${Plugin} PROPERTIES
            "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        )
    endmacro()

    if (pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()




_qt5_Studio3D_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/Qt5Studio3DConfigVersion.cmake")

endif()
