/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick 6.2
import QtQuick.Shapes 1.0
import UiTour

Item {
    id: root
    width: 1920
    height: 1080
    visible: true
    property alias slideSource: loader.source
    property var mainScreen: loader.item

    Image {
        id: gradientRect
        anchors.fill: parent
        source: "gradientRect.png"
        mipmap: true
        fillMode: Image.Stretch
    }

    Item {
        id: contentItem
        width: root.width
        height: root.height

        Item {
            id: tour
            width: contentItem.width * 0.70
            height: tour.width * content.height / content.width

            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 62
            anchors.horizontalCenter: parent.horizontalCenter


            Item {
                id: content
                width: mainScreen.width + 200
                height: mainScreen.height + 200
                transformOrigin: Item.TopLeft

                scale: Math.min(tour.width / content.width, (tour.height + 200) / content.height)

                Loader {
                    id: loader

                    width: 1920
                    x: 100
                    height: 1080

                    source: "MySlideShow.ui.qml"

                }

                /*
                MySlideShow {
                    x: 100
                    y: 0
                    id: mainScreen

                }*/

                Text {
                    id: captionText
                    y: 1100
                    width: 1842
                    height: 125
                    color: "#ffffff"
                    text: mainScreen.caption
                    anchors.bottom: parent.bottom
                    font.pixelSize: 32
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignTop
                    wrapMode: Text.WordWrap
                    anchors.bottomMargin: 55
                    anchors.horizontalCenter: parent.horizontalCenter
                    font.bold: true
                }

                Text {
                    id: titleText
                    y: 1098
                    width: 1842
                    height: 125
                    color: "#ffffff"
                    text: mainScreen.title
                    anchors.top: parent.top
                    font.pixelSize: 68
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignTop
                    wrapMode: Text.WordWrap
                    anchors.topMargin: -200
                    font.bold: true
                    anchors.horizontalCenter: parent.horizontalCenter
                }
            }


        }

        SlideNavButton {
            id: nextSlideButton
            x: 2024
            width: 120
            height: 845
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            anchors.rightMargin: 35
            visible: (mainScreen.progress !== (mainScreen.currentSlide + 1))
            Connections {
                target: nextSlideButton
                onButtonClicked: mainScreen.next()
            }
        }

        SlideNavButton {
            id: prevSlideButton
            y: 4
            width: 120
            height: 845
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left
            dialogButtonRotation: 180
            anchors.leftMargin: 35
            anchors.verticalCenterOffset: 0
            visible: ((mainScreen.currentSlide + 1) !== 1)
            Connections {
                target: prevSlideButton
                onButtonClicked: mainScreen.prev()
            }
        }
    }


    Text {
        id: pageIndicator
        color: "#ffffff"
        text: (mainScreen.currentSlide + 1) + "/" + mainScreen.progress
        anchors.bottom: parent.bottom
        font.pixelSize: 24
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        anchors.bottomMargin: 20
        anchors.horizontalCenter: parent.horizontalCenter
    }

}
